/* valacallback.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALACALLBACK_H__
#define __VALACALLBACK_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valadatatype.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_CALLBACK (vala_callback_get_type ())
#define VALA_CALLBACK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CALLBACK, ValaCallback))
#define VALA_CALLBACK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CALLBACK, ValaCallbackClass))
#define VALA_IS_CALLBACK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CALLBACK))
#define VALA_IS_CALLBACK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CALLBACK))
#define VALA_CALLBACK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CALLBACK, ValaCallbackClass))

typedef struct _ValaCallbackPrivate ValaCallbackPrivate;

/**
 * Represents a function callback type.
 */
struct _ValaCallback {
	ValaDataType parent;
	ValaCallbackPrivate * priv;
};
struct _ValaCallbackClass {
	ValaDataTypeClass parent;
};

ValaCallback* vala_callback_new (const char* _name, ValaTypeReference* _return_type, ValaSourceReference* source);
void vala_callback_add_type_parameter (ValaCallback* self, ValaTypeParameter* p);
void vala_callback_add_parameter (ValaCallback* self, ValaFormalParameter* param);
GList* vala_callback_get_parameters (ValaCallback* self);
gboolean vala_callback_matches_method (ValaCallback* self, ValaMethod* m);
void vala_callback_set_cname (ValaCallback* self, const char* cname);
void vala_callback_process_attributes (ValaCallback* self);
ValaTypeReference* vala_callback_get_return_type (ValaCallback* self);
void vala_callback_set_return_type (ValaCallback* self, ValaTypeReference* value);
gboolean vala_callback_get_instance (ValaCallback* self);
void vala_callback_set_instance (ValaCallback* self, gboolean value);
GType vala_callback_get_type ();

G_END_DECLS

#endif
