/* valaccodestruct.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valaccodestruct.h"
#include <ccode/valaccodestruct.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodedeclarator.h>

struct _ValaCCodeStructPrivate {
	char* _name;
	GList* declarations;
};
#define VALA_CCODE_STRUCT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_STRUCT, ValaCCodeStructPrivate))
enum  {
	VALA_CCODE_STRUCT_DUMMY_PROPERTY,
	VALA_CCODE_STRUCT_NAME,
};
static void vala_ccode_struct_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_struct_parent_class = NULL;
static void vala_ccode_struct_dispose (GObject * obj);


ValaCCodeStruct* vala_ccode_struct_new (const char* n)
{
	g_return_val_if_fail (n != NULL, NULL);
	GParameter * __params = g_new0 (GParameter, 1);
	GParameter * __params_it = __params;
	(__params_it->name = "name", g_value_init (&__params_it->value, G_TYPE_STRING), g_value_set_string (&__params_it->value, n), __params_it++);
	ValaCCodeStruct * self = g_object_newv (VALA_TYPE_CCODE_STRUCT, __params_it - __params, __params);
	return self;
}


/**
 * Adds the specified declaration as member to this struct.
 *
 * @param decl a variable declaration
 */
void vala_ccode_struct_add_declaration (ValaCCodeStruct* self, ValaCCodeDeclaration* decl)
{
	g_return_if_fail (VALA_IS_CCODE_STRUCT (self));
	g_return_if_fail (VALA_IS_CCODE_DECLARATION (decl));
	self->priv->declarations = g_list_append (self->priv->declarations, g_object_ref (decl));
}


/**
 * Adds a variable with the specified type and name to this struct.
 *
 * @param type_name field type
 * @param name      member name
 */
void vala_ccode_struct_add_field (ValaCCodeStruct* self, const char* type_name, const char* name)
{
	g_return_if_fail (VALA_IS_CCODE_STRUCT (self));
	g_return_if_fail (type_name != NULL);
	g_return_if_fail (name != NULL);
	ValaCCodeDeclaration* decl = vala_ccode_declaration_new (type_name);
	ValaCCodeVariableDeclarator* __temp0 = NULL;
	vala_ccode_declaration_add_declarator (decl, VALA_CCODE_DECLARATOR ((__temp0 = vala_ccode_variable_declarator_new (name))));
	(__temp0 == NULL ? NULL : (__temp0 = (g_object_unref (__temp0), NULL)));
	vala_ccode_struct_add_declaration (self, decl);
	(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
}


static void vala_ccode_struct_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer)
{
	ValaCCodeStruct * self = VALA_CCODE_STRUCT (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	vala_ccode_writer_write_string (writer, "struct ");
	vala_ccode_writer_write_string (writer, vala_ccode_struct_get_name (self));
	vala_ccode_writer_write_begin_block (writer);
	{
		GList* __temp1 = NULL;
		__temp1 = self->priv->declarations;
		GList* decl_it;
		for (decl_it = __temp1; decl_it != NULL; decl_it = decl_it->next) {
			ValaCCodeDeclaration* decl = decl_it->data;
			{
				vala_ccode_node_write (VALA_CCODE_NODE (decl), writer);
			}
		}
	}
	vala_ccode_writer_write_end_block (writer);
	vala_ccode_writer_write_string (writer, ";");
	vala_ccode_writer_write_newline (writer);
}


char* vala_ccode_struct_get_name (ValaCCodeStruct* self)
{
	g_return_val_if_fail (VALA_IS_CCODE_STRUCT (self), NULL);
	return self->priv->_name;
}


void vala_ccode_struct_set_name (ValaCCodeStruct* self, const char* value)
{
	g_return_if_fail (VALA_IS_CCODE_STRUCT (self));
	char* __temp3 = NULL;
	self->priv->_name = (__temp3 = g_strdup (value), (self->priv->_name = (g_free (self->priv->_name), NULL)), __temp3);
}


static void vala_ccode_struct_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaCCodeStruct * self = VALA_CCODE_STRUCT (object);
	switch (property_id) {
		case VALA_CCODE_STRUCT_NAME:
		g_value_set_string (value, vala_ccode_struct_get_name (self));
		break;
	}
}


static void vala_ccode_struct_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaCCodeStruct * self = VALA_CCODE_STRUCT (object);
	switch (property_id) {
		case VALA_CCODE_STRUCT_NAME:
		vala_ccode_struct_set_name (self, g_value_get_string (value));
		break;
	}
}


static void vala_ccode_struct_class_init (ValaCCodeStructClass * klass)
{
	vala_ccode_struct_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeStructPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_struct_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_struct_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_struct_dispose;
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_struct_real_write;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_STRUCT_NAME, g_param_spec_string ("name", "foo", "bar", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void vala_ccode_struct_init (ValaCCodeStruct * self)
{
	self->priv = VALA_CCODE_STRUCT_GET_PRIVATE (self);
}


static void vala_ccode_struct_dispose (GObject * obj)
{
	ValaCCodeStruct * self = VALA_CCODE_STRUCT (obj);
	(self->priv->_name = (g_free (self->priv->_name), NULL));
	(self->priv->declarations == NULL ? NULL : (self->priv->declarations = (g_list_foreach (self->priv->declarations, (GFunc) g_object_unref, NULL), g_list_free (self->priv->declarations), NULL)));
	ValaCCodeStructClass * klass;
	GObjectClass * parent_class;
	klass = VALA_CCODE_STRUCT_CLASS (g_type_class_peek (VALA_TYPE_CCODE_STRUCT));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_ccode_struct_get_type ()
{
	static GType vala_ccode_struct_type_id = 0;
	if (G_UNLIKELY (vala_ccode_struct_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeStructClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_struct_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeStruct), 0, (GInstanceInitFunc) vala_ccode_struct_init };
		vala_ccode_struct_type_id = g_type_register_static (VALA_TYPE_CCODE_NODE, "ValaCCodeStruct", &g_define_type_info, 0);
	}
	return vala_ccode_struct_type_id;
}




