/* valaccodeincludedirective.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALACCODEINCLUDEDIRECTIVE_H__
#define __VALACCODEINCLUDEDIRECTIVE_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodewriter.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_INCLUDE_DIRECTIVE (vala_ccode_include_directive_get_type ())
#define VALA_CCODE_INCLUDE_DIRECTIVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_INCLUDE_DIRECTIVE, ValaCCodeIncludeDirective))
#define VALA_CCODE_INCLUDE_DIRECTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_INCLUDE_DIRECTIVE, ValaCCodeIncludeDirectiveClass))
#define VALA_IS_CCODE_INCLUDE_DIRECTIVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_INCLUDE_DIRECTIVE))
#define VALA_IS_CCODE_INCLUDE_DIRECTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_INCLUDE_DIRECTIVE))
#define VALA_CCODE_INCLUDE_DIRECTIVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_INCLUDE_DIRECTIVE, ValaCCodeIncludeDirectiveClass))

typedef struct _ValaCCodeIncludeDirective ValaCCodeIncludeDirective;
typedef struct _ValaCCodeIncludeDirectiveClass ValaCCodeIncludeDirectiveClass;
typedef struct _ValaCCodeIncludeDirectivePrivate ValaCCodeIncludeDirectivePrivate;

/**
 * Represents an include preprocessor directive in the C code.
 */
struct _ValaCCodeIncludeDirective {
	ValaCCodeNode parent;
	ValaCCodeIncludeDirectivePrivate * priv;
};
struct _ValaCCodeIncludeDirectiveClass {
	ValaCCodeNodeClass parent;
};

ValaCCodeIncludeDirective* vala_ccode_include_directive_new (const char* _filename, gboolean _local);
char* vala_ccode_include_directive_get_filename (ValaCCodeIncludeDirective* self);
void vala_ccode_include_directive_set_filename (ValaCCodeIncludeDirective* self, const char* value);
gboolean vala_ccode_include_directive_get_local (ValaCCodeIncludeDirective* self);
void vala_ccode_include_directive_set_local (ValaCCodeIncludeDirective* self, gboolean value);
GType vala_ccode_include_directive_get_type ();

G_END_DECLS

#endif
