
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>
#include <dbus/dbus.h>


#define TYPE_RESOURCES (resources_get_type ())
#define RESOURCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RESOURCES, Resources))
#define IS_RESOURCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RESOURCES))
#define RESOURCES_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_RESOURCES, ResourcesIface))

typedef struct _Resources Resources;
typedef struct _ResourcesIface ResourcesIface;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ResourcesDBusProxy ResourcesDBusProxy;
typedef DBusGProxyClass ResourcesDBusProxyClass;

#define TYPE_HISTORY_ITEM (history_item_get_type ())
#define HISTORY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY_ITEM, HistoryItem))
#define HISTORY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY_ITEM, HistoryItemClass))
#define IS_HISTORY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY_ITEM))
#define IS_HISTORY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY_ITEM))
#define HISTORY_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY_ITEM, HistoryItemClass))

typedef struct _HistoryItem HistoryItem;
typedef struct _HistoryItemClass HistoryItemClass;
typedef struct _HistoryItemPrivate HistoryItemPrivate;
#define _history_item_unref0(var) ((var == NULL) ? NULL : (var = (history_item_unref (var), NULL)))
typedef struct _ParamSpecHistoryItem ParamSpecHistoryItem;

#define TYPE_HISTORY (history_get_type ())
#define HISTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY, History))
#define HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY, HistoryClass))
#define IS_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY))
#define IS_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY))
#define HISTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY, HistoryClass))

typedef struct _History History;
typedef struct _HistoryClass HistoryClass;
typedef struct _HistoryPrivate HistoryPrivate;
typedef struct _ParamSpecHistory ParamSpecHistory;

#define TYPE_EXPLORER (explorer_get_type ())
#define EXPLORER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPLORER, Explorer))
#define EXPLORER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPLORER, ExplorerClass))
#define IS_EXPLORER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPLORER))
#define IS_EXPLORER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPLORER))
#define EXPLORER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPLORER, ExplorerClass))

typedef struct _Explorer Explorer;
typedef struct _ExplorerClass ExplorerClass;
typedef struct _ExplorerPrivate ExplorerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _history_unref0(var) ((var == NULL) ? NULL : (var = (history_unref (var), NULL)))
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ParamSpecExplorer ParamSpecExplorer;
#define _explorer_unref0(var) ((var == NULL) ? NULL : (var = (explorer_unref (var), NULL)))
typedef struct _DBusObjectVTable _DBusObjectVTable;

struct _ResourcesIface {
	GTypeInterface parent_iface;
	void (*Load) (Resources* self, const char* url, GError** error);
	char** (*SparqlQuery) (Resources* self, const char* query, int* result_length1, int* result_length2, GError** error);
	void (*SparqlUpdate) (Resources* self, const char* query, GError** error);
};

struct _ResourcesDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _HistoryItem {
	GTypeInstance parent_instance;
	volatile int ref_count;
	HistoryItemPrivate * priv;
	char* uri;
	HistoryItem* next;
	HistoryItem* prev;
};

struct _HistoryItemClass {
	GTypeClass parent_class;
	void (*finalize) (HistoryItem *self);
};

struct _ParamSpecHistoryItem {
	GParamSpec parent_instance;
};

struct _History {
	GTypeInstance parent_instance;
	volatile int ref_count;
	HistoryPrivate * priv;
};

struct _HistoryClass {
	GTypeClass parent_class;
	void (*finalize) (History *self);
};

struct _HistoryPrivate {
	HistoryItem* items;
	HistoryItem* current;
};

struct _ParamSpecHistory {
	GParamSpec parent_instance;
};

struct _Explorer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ExplorerPrivate * priv;
};

struct _ExplorerClass {
	GTypeClass parent_class;
	void (*finalize) (Explorer *self);
};

struct _ExplorerPrivate {
	Resources* tracker;
	History* history;
	GtkListStore* uris;
	GtkListStore* relationships;
	GtkLabel* current_uri_label;
	GeeHashMap* namespaces;
	GtkNotebook* types;
	GtkButton* forward;
	GtkButton* back;
};

struct _ParamSpecExplorer {
	GParamSpec parent_instance;
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};


static gpointer history_item_parent_class = NULL;
static gpointer history_parent_class = NULL;
static gpointer explorer_parent_class = NULL;

GType resources_get_type (void);
void resources_Load (Resources* self, const char* url, GError** error);
char** resources_SparqlQuery (Resources* self, const char* query, int* result_length1, int* result_length2, GError** error);
void resources_SparqlUpdate (Resources* self, const char* query, GError** error);
void resources_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _resources_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult resources_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_resources_introspect (Resources* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_resources_property_get_all (Resources* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_resources_Load (Resources* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_resources_SparqlQuery (Resources* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_resources_SparqlUpdate (Resources* self, DBusConnection* connection, DBusMessage* message);
GType resources_dbus_proxy_get_type (void);
Resources* resources_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
DBusHandlerResult resources_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	RESOURCES_DBUS_PROXY_DUMMY_PROPERTY
};
static void resources_dbus_proxy_Load (Resources* self, const char* url, GError** error);
static char** resources_dbus_proxy_SparqlQuery (Resources* self, const char* query, int* result_length1, int* result_length2, GError** error);
static void resources_dbus_proxy_SparqlUpdate (Resources* self, const char* query, GError** error);
static void resources_dbus_proxy_interface_init (ResourcesIface* iface);
static void resources_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void resources_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
gpointer history_item_ref (gpointer instance);
void history_item_unref (gpointer instance);
GParamSpec* param_spec_history_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_history_item (GValue* value, gpointer v_object);
gpointer value_get_history_item (const GValue* value);
GType history_item_get_type (void);
enum  {
	HISTORY_ITEM_DUMMY_PROPERTY
};
HistoryItem* history_item_new (const char* uri);
HistoryItem* history_item_construct (GType object_type, const char* uri);
static void history_item_finalize (HistoryItem* obj);
gpointer history_ref (gpointer instance);
void history_unref (gpointer instance);
GParamSpec* param_spec_history (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_history (GValue* value, gpointer v_object);
gpointer value_get_history (const GValue* value);
GType history_get_type (void);
#define HISTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_HISTORY, HistoryPrivate))
enum  {
	HISTORY_DUMMY_PROPERTY
};
char* history_current_uri (History* self);
gboolean history_can_go_forward (History* self);
gboolean history_can_go_back (History* self);
gboolean history_forward (History* self);
gboolean history_back (History* self);
void history_add (History* self, const char* uri);
History* history_new (void);
History* history_construct (GType object_type);
static void history_finalize (History* obj);
gpointer explorer_ref (gpointer instance);
void explorer_unref (gpointer instance);
GParamSpec* param_spec_explorer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_explorer (GValue* value, gpointer v_object);
gpointer value_get_explorer (const GValue* value);
GType explorer_get_type (void);
#define EXPLORER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_EXPLORER, ExplorerPrivate))
enum  {
	EXPLORER_DUMMY_PROPERTY
};
#define EXPLORER_UI_FILE "tracker-explorer.ui"
static void _gtk_main_quit_gtk_object_destroy (GtkWindow* _sender, gpointer self);
static void explorer_entry_changed (Explorer* self, GtkEditable* editable);
static void _explorer_entry_changed_gtk_editable_changed (GtkEntry* _sender, gpointer self);
static void explorer_setup_uris (Explorer* self, GtkTreeView* urisview);
static void explorer_setup_relationships (Explorer* self, GtkTreeView* relationshipsview);
static void explorer_update_types_page (Explorer* self, GtkWidget* w);
static void _explorer_update_types_page_gtk_container_set_focus_child (GtkNotebook* _sender, GtkWidget* widget, gpointer self);
static void explorer_forward_clicked (Explorer* self);
static void _explorer_forward_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void explorer_back_clicked (Explorer* self);
static void _explorer_back_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void explorer_fetch_prefixes (Explorer* self);
void explorer_show (Explorer* self);
static void explorer_row_selected (Explorer* self, GtkTreeView* view, const GtkTreePath* path, GtkTreeViewColumn* column);
static void _explorer_row_selected_gtk_tree_view_row_activated (GtkTreeView* _sender, const GtkTreePath* path, GtkTreeViewColumn* column, gpointer self);
static GtkTreeView* explorer_setup_reverserelationships (Explorer* self);
static char* explorer_subst_prefix (Explorer* self, const char* uri);
static void explorer_clear_types (Explorer* self);
static void explorer_add_type (Explorer* self, const char* type);
static void explorer_update_pane (Explorer* self);
static void explorer_set_current_uri (Explorer* self, const char* uri);
Explorer* explorer_new (void);
Explorer* explorer_construct (GType object_type);
static void explorer_finalize (Explorer* obj);
gint _main (char** args, int args_length1);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);

static const DBusObjectPathVTable _resources_dbus_path_vtable = {_resources_dbus_unregister, resources_dbus_message};
static const _DBusObjectVTable _resources_dbus_vtable = {resources_dbus_register_object};


#line 11 "tracker-explorer.vala"
void resources_Load (Resources* self, const char* url, GError** error) {
#line 11 "tracker-explorer.vala"
	RESOURCES_GET_INTERFACE (self)->Load (self, url, error);
#line 261 "tracker-explorer.c"
}


#line 12 "tracker-explorer.vala"
char** resources_SparqlQuery (Resources* self, const char* query, int* result_length1, int* result_length2, GError** error) {
#line 12 "tracker-explorer.vala"
	return RESOURCES_GET_INTERFACE (self)->SparqlQuery (self, query, result_length1, result_length2, error);
#line 269 "tracker-explorer.c"
}


#line 13 "tracker-explorer.vala"
void resources_SparqlUpdate (Resources* self, const char* query, GError** error) {
#line 13 "tracker-explorer.vala"
	RESOURCES_GET_INTERFACE (self)->SparqlUpdate (self, query, error);
#line 277 "tracker-explorer.c"
}


void _resources_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_resources_introspect (Resources* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.Tracker1.Resources\">\n  <method name=\"Load\">\n    <arg name=\"url\" type=\"s\" direction=\"in\"/>\n  </method>\n  <method name=\"SparqlQuery\">\n    <arg name=\"query\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"aas\" direction=\"out\"/>\n  </method>\n  <method name=\"SparqlUpdate\">\n    <arg name=\"query\" type=\"s\" direction=\"in\"/>\n  </method>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_resources_property_get_all (Resources* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	if (strcmp (interface_name, "org.freedesktop.Tracker1.Resources") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_resources_Load (Resources* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* url;
	const char* _tmp1_;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	url = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp1_);
	dbus_message_iter_next (&iter);
	url = g_strdup (_tmp1_);
	resources_Load (self, url, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (url);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_resources_SparqlQuery (Resources* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* query;
	const char* _tmp2_;
	char** result;
	int result_length1;
	int result_length2;
	DBusMessage* reply;
	char** _tmp3_;
	DBusMessageIter _tmp4_;
	int _tmp5_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	query = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp2_);
	dbus_message_iter_next (&iter);
	query = g_strdup (_tmp2_);
	result_length1 = 0;
	result_length2 = 0;
	result = resources_SparqlQuery (self, query, &result_length1, &result_length2, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (query);
	_tmp3_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "as", &_tmp4_);
	for (_tmp5_ = 0; _tmp5_ < result_length1; _tmp5_++) {
		DBusMessageIter _tmp6_;
		int _tmp7_;
		dbus_message_iter_open_container (&_tmp4_, DBUS_TYPE_ARRAY, "s", &_tmp6_);
		for (_tmp7_ = 0; _tmp7_ < result_length2; _tmp7_++) {
			const char* _tmp8_;
			_tmp8_ = *_tmp3_;
			dbus_message_iter_append_basic (&_tmp6_, DBUS_TYPE_STRING, &_tmp8_);
			_tmp3_++;
		}
		dbus_message_iter_close_container (&_tmp4_, &_tmp6_);
	}
	dbus_message_iter_close_container (&iter, &_tmp4_);
	result = (_vala_array_free (result,  result_length1 *  result_length2, (GDestroyNotify) g_free), NULL);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_resources_SparqlUpdate (Resources* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* query;
	const char* _tmp9_;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	query = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp9_);
	dbus_message_iter_next (&iter);
	query = g_strdup (_tmp9_);
	resources_SparqlUpdate (self, query, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (query);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult resources_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_resources_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_resources_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.Tracker1.Resources", "Load")) {
		result = _dbus_resources_Load (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.Tracker1.Resources", "SparqlQuery")) {
		result = _dbus_resources_SparqlQuery (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.Tracker1.Resources", "SparqlUpdate")) {
		result = _dbus_resources_SparqlUpdate (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void resources_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_resources_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
}


static void resources_base_init (ResourcesIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_type_set_qdata (TYPE_RESOURCES, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_resources_dbus_vtable));
	}
}


GType resources_get_type (void) {
	static GType resources_type_id = 0;
	if (resources_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ResourcesIface), (GBaseInitFunc) resources_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		resources_type_id = g_type_register_static (G_TYPE_INTERFACE, "Resources", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (resources_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (resources_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &resources_dbus_proxy_get_type);
	}
	return resources_type_id;
}


G_DEFINE_TYPE_EXTENDED (ResourcesDBusProxy, resources_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_RESOURCES, resources_dbus_proxy_interface_init));
Resources* resources_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	Resources* self;
	self = g_object_new (resources_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.freedesktop.Tracker1.Resources", NULL);
	return self;
}


static GObject* resources_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (resources_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), resources_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


DBusHandlerResult resources_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void resources_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((ResourcesDBusProxy*) self)->disposed) {
		return;
	}
	((ResourcesDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), resources_dbus_proxy_filter, self);
	G_OBJECT_CLASS (resources_dbus_proxy_parent_class)->dispose (self);
}


static void resources_dbus_proxy_class_init (ResourcesDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = resources_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = resources_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = resources_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = resources_dbus_proxy_set_property;
}


static void resources_dbus_proxy_init (ResourcesDBusProxy* self) {
}


static void resources_dbus_proxy_Load (Resources* self, const char* url, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp10_;
	if (((ResourcesDBusProxy*) self)->disposed) {
		g_set_error_literal (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.Tracker1.Resources", "Load");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp10_ = url;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp10_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp11_;
			_edomain = DBUS_GERROR;
			_tmp11_ = _dbus_error.name + 27;
			if (strcmp (_tmp11_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp11_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp11_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp11_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp11_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp11_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp11_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp11_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp11_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp11_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp11_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp11_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp11_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp11_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp11_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp11_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp11_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp11_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp11_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp11_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp11_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp11_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp11_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp11_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp11_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp11_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp11_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp11_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp11_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp11_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp11_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp11_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp11_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, _dbus_error.message);
		dbus_error_free (&_dbus_error);
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static char** resources_dbus_proxy_SparqlQuery (Resources* self, const char* query, int* result_length1, int* result_length2, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp12_;
	char** _result;
	int _result_length1;
	int _result_length2;
	char** _tmp13_;
	int _tmp13__length;
	int _tmp13__size;
	int _tmp13__length1;
	DBusMessageIter _tmp14_;
	if (((ResourcesDBusProxy*) self)->disposed) {
		g_set_error_literal (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.Tracker1.Resources", "SparqlQuery");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp12_ = query;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp12_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp17_;
			_edomain = DBUS_GERROR;
			_tmp17_ = _dbus_error.name + 27;
			if (strcmp (_tmp17_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp17_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp17_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp17_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp17_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp17_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp17_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp17_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp17_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp17_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp17_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp17_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp17_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp17_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp17_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp17_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp17_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp17_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp17_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp17_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp17_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp17_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp17_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp17_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp17_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp17_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp17_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp17_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp17_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp17_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp17_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp17_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp17_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return _result;
	}
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_result_length2 = 0;
	_tmp13_ = g_new (char*, 5);
	_tmp13__length = 0;
	_tmp13__size = 4;
	_tmp13__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp14_);
	for (; dbus_message_iter_get_arg_type (&_tmp14_); _tmp13__length1++) {
		int _tmp13__length2;
		DBusMessageIter _tmp15_;
		_tmp13__length2 = 0;
		dbus_message_iter_recurse (&_tmp14_, &_tmp15_);
		for (; dbus_message_iter_get_arg_type (&_tmp15_); _tmp13__length2++) {
			const char* _tmp16_;
			if (_tmp13__size == _tmp13__length) {
				_tmp13__size = 2 * _tmp13__size;
				_tmp13_ = g_renew (char*, _tmp13_, _tmp13__size + 1);
			}
			dbus_message_iter_get_basic (&_tmp15_, &_tmp16_);
			dbus_message_iter_next (&_tmp15_);
			_tmp13_[_tmp13__length++] = g_strdup (_tmp16_);
		}
		_result_length2 = _tmp13__length2;
		dbus_message_iter_next (&_tmp14_);
	}
	_result_length1 = _tmp13__length1;
	_tmp13_[_tmp13__length] = NULL;
	dbus_message_iter_next (&_iter);
	_result = _tmp13_;
	*result_length1 = _result_length1;
	*result_length2 = _result_length2;
	dbus_message_unref (_reply);
	return _result;
}


static void resources_dbus_proxy_SparqlUpdate (Resources* self, const char* query, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp18_;
	if (((ResourcesDBusProxy*) self)->disposed) {
		g_set_error_literal (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.Tracker1.Resources", "SparqlUpdate");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp18_ = query;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp18_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp19_;
			_edomain = DBUS_GERROR;
			_tmp19_ = _dbus_error.name + 27;
			if (strcmp (_tmp19_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp19_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp19_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp19_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp19_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp19_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp19_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp19_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp19_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp19_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp19_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp19_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp19_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp19_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp19_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp19_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp19_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp19_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp19_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp19_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp19_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp19_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp19_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp19_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp19_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp19_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp19_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp19_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp19_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp19_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp19_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp19_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp19_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, _dbus_error.message);
		dbus_error_free (&_dbus_error);
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void resources_dbus_proxy_interface_init (ResourcesIface* iface) {
	iface->Load = resources_dbus_proxy_Load;
	iface->SparqlQuery = resources_dbus_proxy_SparqlQuery;
	iface->SparqlUpdate = resources_dbus_proxy_SparqlUpdate;
}


static void resources_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void resources_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


#line 17 "tracker-explorer.vala"
HistoryItem* history_item_construct (GType object_type, const char* uri) {
#line 1253 "tracker-explorer.c"
	HistoryItem* self;
	char* _tmp0_;
#line 17 "tracker-explorer.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 1258 "tracker-explorer.c"
	self = (HistoryItem*) g_type_create_instance (object_type);
#line 18 "tracker-explorer.vala"
	self->uri = (_tmp0_ = g_strdup (uri), _g_free0 (self->uri), _tmp0_);
#line 1262 "tracker-explorer.c"
	return self;
}


#line 17 "tracker-explorer.vala"
HistoryItem* history_item_new (const char* uri) {
#line 17 "tracker-explorer.vala"
	return history_item_construct (TYPE_HISTORY_ITEM, uri);
#line 1271 "tracker-explorer.c"
}


static void value_history_item_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_history_item_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		history_item_unref (value->data[0].v_pointer);
	}
}


static void value_history_item_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = history_item_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_history_item_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_history_item_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		HistoryItem* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = history_item_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_history_item_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	HistoryItem** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = history_item_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_history_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecHistoryItem* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_HISTORY_ITEM), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_history_item (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HISTORY_ITEM), NULL);
	return value->data[0].v_pointer;
}


void value_set_history_item (GValue* value, gpointer v_object) {
	HistoryItem* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HISTORY_ITEM));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HISTORY_ITEM));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		history_item_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		history_item_unref (old);
	}
}


static void history_item_class_init (HistoryItemClass * klass) {
	history_item_parent_class = g_type_class_peek_parent (klass);
	HISTORY_ITEM_CLASS (klass)->finalize = history_item_finalize;
}


static void history_item_instance_init (HistoryItem * self) {
	self->next = NULL;
	self->prev = NULL;
	self->ref_count = 1;
}


static void history_item_finalize (HistoryItem* obj) {
	HistoryItem * self;
	self = HISTORY_ITEM (obj);
	_g_free0 (self->uri);
	_history_item_unref0 (self->next);
	_history_item_unref0 (self->prev);
}


GType history_item_get_type (void) {
	static GType history_item_type_id = 0;
	if (history_item_type_id == 0) {
		static const GTypeValueTable g_define_type_value_table = { value_history_item_init, value_history_item_free_value, value_history_item_copy_value, value_history_item_peek_pointer, "p", value_history_item_collect_value, "p", value_history_item_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (HistoryItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) history_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HistoryItem), 0, (GInstanceInitFunc) history_item_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		history_item_type_id = g_type_register_fundamental (g_type_fundamental_next (), "HistoryItem", &g_define_type_info, &g_define_type_fundamental_info, 0);
	}
	return history_item_type_id;
}


gpointer history_item_ref (gpointer instance) {
	HistoryItem* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void history_item_unref (gpointer instance) {
	HistoryItem* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		HISTORY_ITEM_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


#line 29 "tracker-explorer.vala"
char* history_current_uri (History* self) {
#line 1422 "tracker-explorer.c"
	char* result;
#line 29 "tracker-explorer.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 30 "tracker-explorer.vala"
	if (self->priv->current != NULL) {
#line 1428 "tracker-explorer.c"
		result = g_strdup (self->priv->current->uri);
		return result;
	} else {
		result = NULL;
		return result;
	}
}


#line 37 "tracker-explorer.vala"
gboolean history_can_go_forward (History* self) {
#line 1440 "tracker-explorer.c"
	gboolean result;
	gboolean _tmp0_;
#line 37 "tracker-explorer.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1445 "tracker-explorer.c"
	_tmp0_ = FALSE;
#line 38 "tracker-explorer.vala"
	if (self->priv->current != NULL) {
#line 38 "tracker-explorer.vala"
		_tmp0_ = self->priv->current->next != NULL;
#line 1451 "tracker-explorer.c"
	} else {
#line 38 "tracker-explorer.vala"
		_tmp0_ = FALSE;
#line 1455 "tracker-explorer.c"
	}
	result = _tmp0_;
	return result;
}


#line 41 "tracker-explorer.vala"
gboolean history_can_go_back (History* self) {
#line 1464 "tracker-explorer.c"
	gboolean result;
	gboolean _tmp0_;
#line 41 "tracker-explorer.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1469 "tracker-explorer.c"
	_tmp0_ = FALSE;
#line 42 "tracker-explorer.vala"
	if (self->priv->current != NULL) {
#line 42 "tracker-explorer.vala"
		_tmp0_ = self->priv->current->prev != NULL;
#line 1475 "tracker-explorer.c"
	} else {
#line 42 "tracker-explorer.vala"
		_tmp0_ = FALSE;
#line 1479 "tracker-explorer.c"
	}
	result = _tmp0_;
	return result;
}


static gpointer _history_item_ref0 (gpointer self) {
	return self ? history_item_ref (self) : NULL;
}


#line 45 "tracker-explorer.vala"
gboolean history_forward (History* self) {
#line 1493 "tracker-explorer.c"
	gboolean result;
#line 45 "tracker-explorer.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 46 "tracker-explorer.vala"
	if (history_can_go_forward (self)) {
#line 1499 "tracker-explorer.c"
		HistoryItem* _tmp0_;
#line 47 "tracker-explorer.vala"
		self->priv->current = (_tmp0_ = _history_item_ref0 (self->priv->current->next), _history_item_unref0 (self->priv->current), _tmp0_);
#line 1503 "tracker-explorer.c"
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


#line 53 "tracker-explorer.vala"
gboolean history_back (History* self) {
#line 1514 "tracker-explorer.c"
	gboolean result;
#line 53 "tracker-explorer.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 54 "tracker-explorer.vala"
	if (history_can_go_back (self)) {
#line 1520 "tracker-explorer.c"
		HistoryItem* _tmp0_;
#line 55 "tracker-explorer.vala"
		self->priv->current = (_tmp0_ = _history_item_ref0 (self->priv->current->prev), _history_item_unref0 (self->priv->current), _tmp0_);
#line 1524 "tracker-explorer.c"
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


#line 61 "tracker-explorer.vala"
void history_add (History* self, const char* uri) {
#line 1535 "tracker-explorer.c"
	HistoryItem* hi;
	HistoryItem* _tmp4_;
#line 61 "tracker-explorer.vala"
	g_return_if_fail (self != NULL);
#line 61 "tracker-explorer.vala"
	g_return_if_fail (uri != NULL);
#line 1542 "tracker-explorer.c"
	hi = history_item_new (uri);
#line 63 "tracker-explorer.vala"
	if (self->priv->current == NULL) {
#line 1546 "tracker-explorer.c"
		HistoryItem* _tmp0_;
		HistoryItem* _tmp1_;
#line 64 "tracker-explorer.vala"
		self->priv->items = (_tmp0_ = _history_item_ref0 (hi), _history_item_unref0 (self->priv->items), _tmp0_);
#line 65 "tracker-explorer.vala"
		self->priv->current = (_tmp1_ = _history_item_ref0 (self->priv->items), _history_item_unref0 (self->priv->current), _tmp1_);
#line 1553 "tracker-explorer.c"
	} else {
		HistoryItem* _tmp2_;
		HistoryItem* _tmp3_;
#line 67 "tracker-explorer.vala"
		self->priv->current->next = (_tmp2_ = _history_item_ref0 (hi), _history_item_unref0 (self->priv->current->next), _tmp2_);
#line 68 "tracker-explorer.vala"
		hi->prev = (_tmp3_ = _history_item_ref0 (self->priv->current), _history_item_unref0 (hi->prev), _tmp3_);
#line 1561 "tracker-explorer.c"
	}
#line 70 "tracker-explorer.vala"
	self->priv->current = (_tmp4_ = _history_item_ref0 (hi), _history_item_unref0 (self->priv->current), _tmp4_);
#line 1565 "tracker-explorer.c"
	_history_item_unref0 (hi);
}


#line 25 "tracker-explorer.vala"
History* history_construct (GType object_type) {
#line 1572 "tracker-explorer.c"
	History* self;
	self = (History*) g_type_create_instance (object_type);
	return self;
}


#line 25 "tracker-explorer.vala"
History* history_new (void) {
#line 25 "tracker-explorer.vala"
	return history_construct (TYPE_HISTORY);
#line 1583 "tracker-explorer.c"
}


static void value_history_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_history_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		history_unref (value->data[0].v_pointer);
	}
}


static void value_history_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = history_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_history_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_history_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		History* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = history_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_history_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	History** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = history_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_history (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecHistory* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_HISTORY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_history (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HISTORY), NULL);
	return value->data[0].v_pointer;
}


void value_set_history (GValue* value, gpointer v_object) {
	History* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HISTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HISTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		history_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		history_unref (old);
	}
}


static void history_class_init (HistoryClass * klass) {
	history_parent_class = g_type_class_peek_parent (klass);
	HISTORY_CLASS (klass)->finalize = history_finalize;
	g_type_class_add_private (klass, sizeof (HistoryPrivate));
}


static void history_instance_init (History * self) {
	self->priv = HISTORY_GET_PRIVATE (self);
	self->priv->items = NULL;
	self->priv->current = NULL;
	self->ref_count = 1;
}


static void history_finalize (History* obj) {
	History * self;
	self = HISTORY (obj);
	_history_item_unref0 (self->priv->items);
	_history_item_unref0 (self->priv->current);
}


GType history_get_type (void) {
	static GType history_type_id = 0;
	if (history_type_id == 0) {
		static const GTypeValueTable g_define_type_value_table = { value_history_init, value_history_free_value, value_history_copy_value, value_history_peek_pointer, "p", value_history_collect_value, "p", value_history_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (HistoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) history_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (History), 0, (GInstanceInitFunc) history_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		history_type_id = g_type_register_fundamental (g_type_fundamental_next (), "History", &g_define_type_info, &g_define_type_fundamental_info, 0);
	}
	return history_type_id;
}


gpointer history_ref (gpointer instance) {
	History* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void history_unref (gpointer instance) {
	History* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		HISTORY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 7481 "gtk+-2.0.vapi"
static void _gtk_main_quit_gtk_object_destroy (GtkWindow* _sender, gpointer self) {
#line 1740 "tracker-explorer.c"
	gtk_main_quit ();
}


#line 200 "tracker-explorer.vala"
static void _explorer_entry_changed_gtk_editable_changed (GtkEntry* _sender, gpointer self) {
#line 1747 "tracker-explorer.c"
	explorer_entry_changed (self, _sender);
}


#line 241 "tracker-explorer.vala"
static void _explorer_update_types_page_gtk_container_set_focus_child (GtkNotebook* _sender, GtkWidget* widget, gpointer self) {
#line 1754 "tracker-explorer.c"
	explorer_update_types_page (self, widget);
}


#line 290 "tracker-explorer.vala"
static void _explorer_forward_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 1761 "tracker-explorer.c"
	explorer_forward_clicked (self);
}


#line 296 "tracker-explorer.vala"
static void _explorer_back_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 1768 "tracker-explorer.c"
	explorer_back_clicked (self);
}


#line 90 "tracker-explorer.vala"
void explorer_show (Explorer* self) {
#line 1775 "tracker-explorer.c"
	GError * _inner_error_;
	GtkBuilder* builder;
	GObject* _tmp1_;
	GtkWindow* window;
	GObject* _tmp2_;
	GtkEntry* entry;
	GObject* _tmp3_;
	GtkTreeView* urisview;
	GObject* _tmp4_;
	GtkTreeView* relationshipsview;
	GtkLabel* _tmp6_;
	GObject* _tmp5_;
	GtkNotebook* _tmp8_;
	GObject* _tmp7_;
	GtkButton* _tmp10_;
	GObject* _tmp9_;
	GtkButton* _tmp12_;
	GObject* _tmp11_;
#line 90 "tracker-explorer.vala"
	g_return_if_fail (self != NULL);
#line 1796 "tracker-explorer.c"
	_inner_error_ = NULL;
	{
		DBusGConnection* conn;
		Resources* _tmp0_;
		conn = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch0_dbus_gerror;
			}
			goto __finally0;
		}
#line 94 "tracker-explorer.vala"
		self->priv->tracker = (_tmp0_ = resources_dbus_proxy_new (conn, "org.freedesktop.Tracker1", "/org/freedesktop/Tracker1/Resources"), _g_object_unref0 (self->priv->tracker), _tmp0_);
#line 1810 "tracker-explorer.c"
		_dbus_g_connection_unref0 (conn);
	}
	goto __finally0;
	__catch0_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			GtkMessageDialog* msg;
			msg = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_CANCEL, "Error connecting to D-Bus session bus\n%s", e->message));
#line 101 "tracker-explorer.vala"
			gtk_dialog_run ((GtkDialog*) msg);
#line 102 "tracker-explorer.vala"
			gtk_main_quit ();
#line 1826 "tracker-explorer.c"
			_g_error_free0 (e);
			_g_object_unref0 (msg);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
	builder = gtk_builder_new ();
	{
#line 110 "tracker-explorer.vala"
		gtk_builder_add_from_file (builder, SRCDIR EXPLORER_UI_FILE, &_inner_error_);
#line 1841 "tracker-explorer.c"
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
			goto __finally1;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			{
#line 114 "tracker-explorer.vala"
				gtk_builder_add_from_file (builder, TRACKER_UI_DIR EXPLORER_UI_FILE, &_inner_error_);
#line 1857 "tracker-explorer.c"
				if (_inner_error_ != NULL) {
					goto __catch2_g_error;
					goto __finally2;
				}
			}
			goto __finally2;
			__catch2_g_error:
			{
				GError * e;
				e = _inner_error_;
				_inner_error_ = NULL;
				{
					GtkMessageDialog* msg;
					msg = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_CANCEL, "Failed to load UI\n%s", e->message));
#line 119 "tracker-explorer.vala"
					gtk_dialog_run ((GtkDialog*) msg);
#line 120 "tracker-explorer.vala"
					gtk_main_quit ();
#line 1876 "tracker-explorer.c"
					_g_error_free0 (e);
					_g_object_unref0 (msg);
				}
			}
			__finally2:
			if (_inner_error_ != NULL) {
				_g_error_free0 (e);
				_g_object_unref0 (builder);
				goto __finally1;
			}
			_g_error_free0 (e);
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
	window = _g_object_ref0 ((_tmp1_ = gtk_builder_get_object (builder, "explorer"), GTK_IS_WINDOW (_tmp1_) ? ((GtkWindow*) _tmp1_) : NULL));
#line 125 "tracker-explorer.vala"
	g_signal_connect ((GtkObject*) window, "destroy", (GCallback) _gtk_main_quit_gtk_object_destroy, NULL);
#line 1900 "tracker-explorer.c"
	entry = _g_object_ref0 ((_tmp2_ = gtk_builder_get_object (builder, "text-search"), GTK_IS_ENTRY (_tmp2_) ? ((GtkEntry*) _tmp2_) : NULL));
#line 128 "tracker-explorer.vala"
	g_signal_connect ((GtkEditable*) entry, "changed", (GCallback) _explorer_entry_changed_gtk_editable_changed, self);
#line 1904 "tracker-explorer.c"
	urisview = _g_object_ref0 ((_tmp3_ = gtk_builder_get_object (builder, "uris"), GTK_IS_TREE_VIEW (_tmp3_) ? ((GtkTreeView*) _tmp3_) : NULL));
#line 131 "tracker-explorer.vala"
	explorer_setup_uris (self, urisview);
#line 1908 "tracker-explorer.c"
	relationshipsview = _g_object_ref0 ((_tmp4_ = gtk_builder_get_object (builder, "relationshipsview"), GTK_IS_TREE_VIEW (_tmp4_) ? ((GtkTreeView*) _tmp4_) : NULL));
#line 134 "tracker-explorer.vala"
	explorer_setup_relationships (self, relationshipsview);
#line 136 "tracker-explorer.vala"
	self->priv->current_uri_label = (_tmp6_ = _g_object_ref0 ((_tmp5_ = gtk_builder_get_object (builder, "current-object"), GTK_IS_LABEL (_tmp5_) ? ((GtkLabel*) _tmp5_) : NULL)), _g_object_unref0 (self->priv->current_uri_label), _tmp6_);
#line 138 "tracker-explorer.vala"
	self->priv->types = (_tmp8_ = _g_object_ref0 ((_tmp7_ = gtk_builder_get_object (builder, "types"), GTK_IS_NOTEBOOK (_tmp7_) ? ((GtkNotebook*) _tmp7_) : NULL)), _g_object_unref0 (self->priv->types), _tmp8_);
#line 140 "tracker-explorer.vala"
	g_signal_connect ((GtkContainer*) self->priv->types, "set-focus-child", (GCallback) _explorer_update_types_page_gtk_container_set_focus_child, self);
#line 142 "tracker-explorer.vala"
	self->priv->forward = (_tmp10_ = _g_object_ref0 ((_tmp9_ = gtk_builder_get_object (builder, "forward"), GTK_IS_BUTTON (_tmp9_) ? ((GtkButton*) _tmp9_) : NULL)), _g_object_unref0 (self->priv->forward), _tmp10_);
#line 143 "tracker-explorer.vala"
	g_signal_connect (self->priv->forward, "clicked", (GCallback) _explorer_forward_clicked_gtk_button_clicked, self);
#line 144 "tracker-explorer.vala"
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->forward, FALSE);
#line 146 "tracker-explorer.vala"
	self->priv->back = (_tmp12_ = _g_object_ref0 ((_tmp11_ = gtk_builder_get_object (builder, "back"), GTK_IS_BUTTON (_tmp11_) ? ((GtkButton*) _tmp11_) : NULL)), _g_object_unref0 (self->priv->back), _tmp12_);
#line 147 "tracker-explorer.vala"
	g_signal_connect (self->priv->back, "clicked", (GCallback) _explorer_back_clicked_gtk_button_clicked, self);
#line 148 "tracker-explorer.vala"
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->back, FALSE);
#line 150 "tracker-explorer.vala"
	explorer_fetch_prefixes (self);
#line 152 "tracker-explorer.vala"
	gtk_widget_show_all ((GtkWidget*) window);
#line 1934 "tracker-explorer.c"
	_g_object_unref0 (builder);
	_g_object_unref0 (window);
	_g_object_unref0 (entry);
	_g_object_unref0 (urisview);
	_g_object_unref0 (relationshipsview);
}


#line 332 "tracker-explorer.vala"
static void _explorer_row_selected_gtk_tree_view_row_activated (GtkTreeView* _sender, const GtkTreePath* path, GtkTreeViewColumn* column, gpointer self) {
#line 1945 "tracker-explorer.c"
	explorer_row_selected (self, _sender, path, column);
}


#line 155 "tracker-explorer.vala"
static void explorer_setup_uris (Explorer* self, GtkTreeView* urisview) {
#line 1952 "tracker-explorer.c"
	GtkListStore* _tmp0_;
	GtkCellRendererText* _tmp1_;
#line 155 "tracker-explorer.vala"
	g_return_if_fail (self != NULL);
#line 155 "tracker-explorer.vala"
	g_return_if_fail (urisview != NULL);
#line 156 "tracker-explorer.vala"
	self->priv->uris = (_tmp0_ = gtk_list_store_new (1, G_TYPE_STRING, NULL), _g_object_unref0 (self->priv->uris), _tmp0_);
#line 157 "tracker-explorer.vala"
	gtk_tree_view_set_model (urisview, (GtkTreeModel*) self->priv->uris);
#line 159 "tracker-explorer.vala"
	gtk_tree_view_insert_column_with_attributes (urisview, -1, "URI", (GtkCellRenderer*) (_tmp1_ = g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ())), "text", 0, NULL, NULL);
#line 1965 "tracker-explorer.c"
	_g_object_unref0 (_tmp1_);
#line 160 "tracker-explorer.vala"
	g_signal_connect (urisview, "row-activated", (GCallback) _explorer_row_selected_gtk_tree_view_row_activated, self);
#line 1969 "tracker-explorer.c"
}


#line 163 "tracker-explorer.vala"
static void explorer_setup_relationships (Explorer* self, GtkTreeView* relationshipsview) {
#line 1975 "tracker-explorer.c"
	GtkListStore* _tmp0_;
	GtkCellRendererText* _tmp1_;
	GtkCellRendererText* _tmp2_;
#line 163 "tracker-explorer.vala"
	g_return_if_fail (self != NULL);
#line 163 "tracker-explorer.vala"
	g_return_if_fail (relationshipsview != NULL);
#line 164 "tracker-explorer.vala"
	self->priv->relationships = (_tmp0_ = gtk_list_store_new (3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, NULL), _g_object_unref0 (self->priv->relationships), _tmp0_);
#line 165 "tracker-explorer.vala"
	gtk_tree_view_set_model (relationshipsview, (GtkTreeModel*) self->priv->relationships);
#line 167 "tracker-explorer.vala"
	gtk_tree_view_insert_column_with_attributes (relationshipsview, -1, "Relationship", (GtkCellRenderer*) (_tmp1_ = g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ())), "text", 1, NULL, NULL);
#line 1989 "tracker-explorer.c"
	_g_object_unref0 (_tmp1_);
#line 168 "tracker-explorer.vala"
	gtk_tree_view_insert_column_with_attributes (relationshipsview, -1, "Object", (GtkCellRenderer*) (_tmp2_ = g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ())), "text", 2, NULL, NULL);
#line 1993 "tracker-explorer.c"
	_g_object_unref0 (_tmp2_);
#line 169 "tracker-explorer.vala"
	g_signal_connect (relationshipsview, "row-activated", (GCallback) _explorer_row_selected_gtk_tree_view_row_activated, self);
#line 1997 "tracker-explorer.c"
}


#line 172 "tracker-explorer.vala"
static GtkTreeView* explorer_setup_reverserelationships (Explorer* self) {
#line 2003 "tracker-explorer.c"
	GtkTreeView* result;
	GtkListStore* reverserelationships;
	GtkTreeView* reverserelationshipsview;
	GtkCellRendererText* _tmp0_;
	GtkCellRendererText* _tmp1_;
#line 172 "tracker-explorer.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 2011 "tracker-explorer.c"
	reverserelationships = gtk_list_store_new (3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, NULL);
	reverserelationshipsview = g_object_ref_sink ((GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) reverserelationships));
#line 177 "tracker-explorer.vala"
	gtk_tree_view_set_model (reverserelationshipsview, (GtkTreeModel*) reverserelationships);
#line 179 "tracker-explorer.vala"
	gtk_tree_view_insert_column_with_attributes (reverserelationshipsview, -1, "Subject", (GtkCellRenderer*) (_tmp0_ = g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ())), "text", 1, NULL, NULL);
#line 2018 "tracker-explorer.c"
	_g_object_unref0 (_tmp0_);
#line 180 "tracker-explorer.vala"
	gtk_tree_view_insert_column_with_attributes (reverserelationshipsview, -1, "Relationship", (GtkCellRenderer*) (_tmp1_ = g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ())), "text", 2, NULL, NULL);
#line 2022 "tracker-explorer.c"
	_g_object_unref0 (_tmp1_);
#line 181 "tracker-explorer.vala"
	g_signal_connect (reverserelationshipsview, "row-activated", (GCallback) _explorer_row_selected_gtk_tree_view_row_activated, self);
#line 2026 "tracker-explorer.c"
	result = reverserelationshipsview;
	_g_object_unref0 (reverserelationships);
	return result;
}


#line 948 "glib-2.0.vapi"
static char* string_substring (const char* self, glong offset, glong len) {
#line 2035 "tracker-explorer.c"
	char* result;
	glong string_length;
	const char* start;
#line 948 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 2041 "tracker-explorer.c"
	string_length = g_utf8_strlen (self, -1);
#line 950 "glib-2.0.vapi"
	if (offset < 0) {
#line 951 "glib-2.0.vapi"
		offset = string_length + offset;
#line 952 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= 0, NULL);
#line 2049 "tracker-explorer.c"
	} else {
#line 954 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= string_length, NULL);
#line 2053 "tracker-explorer.c"
	}
#line 956 "glib-2.0.vapi"
	if (len < 0) {
#line 957 "glib-2.0.vapi"
		len = string_length - offset;
#line 2059 "tracker-explorer.c"
	}
#line 959 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
#line 2063 "tracker-explorer.c"
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


#line 187 "tracker-explorer.vala"
static void explorer_fetch_prefixes (Explorer* self) {
#line 2072 "tracker-explorer.c"
	GError * _inner_error_;
	char* query;
#line 187 "tracker-explorer.vala"
	g_return_if_fail (self != NULL);
#line 2077 "tracker-explorer.c"
	_inner_error_ = NULL;
	query = g_strdup ("SELECT ?s ?prefix WHERE { ?s a tracker:Namespace ; tracker:prefix ?prefix }");
	{
		char** _tmp2_;
		gint _result__length2;
		gint _result__length1;
		gint _tmp1_;
		gint _tmp0_;
		char** _result_;
		_result_ = (_tmp2_ = resources_SparqlQuery (self->priv->tracker, query, &_tmp0_, &_tmp1_, &_inner_error_), _result__length1 = _tmp0_, _result__length2 = _tmp1_, _tmp2_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch3_dbus_gerror;
			}
			goto __finally3;
		}
		{
			gint i;
			i = 0;
			{
				gboolean _tmp3_;
				_tmp3_ = TRUE;
#line 191 "tracker-explorer.vala"
				while (TRUE) {
#line 2102 "tracker-explorer.c"
					char* _namespace;
					char* _tmp4_;
#line 191 "tracker-explorer.vala"
					if (!_tmp3_) {
#line 191 "tracker-explorer.vala"
						i++;
#line 2109 "tracker-explorer.c"
					}
#line 191 "tracker-explorer.vala"
					_tmp3_ = FALSE;
#line 191 "tracker-explorer.vala"
					if (!(i < _result__length1)) {
#line 191 "tracker-explorer.vala"
						break;
#line 2117 "tracker-explorer.c"
					}
					_namespace = g_strdup (_result_[(i * _result__length2) + 0]);
#line 193 "tracker-explorer.vala"
					_namespace = (_tmp4_ = string_substring (_namespace, (glong) 0, g_utf8_strlen (_namespace, -1) - 1), _g_free0 (_namespace), _tmp4_);
#line 194 "tracker-explorer.vala"
					gee_abstract_map_set ((GeeAbstractMap*) self->priv->namespaces, _namespace, _result_[(i * _result__length2) + 1]);
#line 2124 "tracker-explorer.c"
					_g_free0 (_namespace);
				}
			}
		}
		_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
	}
	goto __finally3;
	__catch3_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (e);
		}
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_free0 (query);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (query);
}


#line 200 "tracker-explorer.vala"
static void explorer_entry_changed (Explorer* self, GtkEditable* editable) {
#line 2154 "tracker-explorer.c"
	GError * _inner_error_;
	char* query;
#line 200 "tracker-explorer.vala"
	g_return_if_fail (self != NULL);
#line 200 "tracker-explorer.vala"
	g_return_if_fail (editable != NULL);
#line 2161 "tracker-explorer.c"
	_inner_error_ = NULL;
	query = g_strdup_printf ("SELECT ?s WHERE { ?s fts:match \"%s*\" }", gtk_entry_get_text (GTK_ENTRY (editable)));
	{
		char** _tmp2_;
		gint _result__length2;
		gint _result__length1;
		gint _tmp1_;
		gint _tmp0_;
		char** _result_;
		_result_ = (_tmp2_ = resources_SparqlQuery (self->priv->tracker, query, &_tmp0_, &_tmp1_, &_inner_error_), _result__length1 = _tmp0_, _result__length2 = _tmp1_, _tmp2_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch4_dbus_gerror;
			}
			goto __finally4;
		}
#line 206 "tracker-explorer.vala"
		gtk_list_store_clear (self->priv->uris);
#line 2180 "tracker-explorer.c"
		{
			char** s_collection;
			int s_collection_length1;
			int s_it;
#line 207 "tracker-explorer.vala"
			s_collection = _result_;
#line 2187 "tracker-explorer.c"
			s_collection_length1 = _result__length1 * _result__length2;
			for (s_it = 0; s_it < (_result__length1 * _result__length2); s_it = s_it + 1) {
				char* s;
				s = g_strdup (s_collection[s_it]);
				{
					GtkTreeIter iter = {0};
#line 210 "tracker-explorer.vala"
					gtk_list_store_append (self->priv->uris, &iter);
#line 211 "tracker-explorer.vala"
					gtk_list_store_set (self->priv->uris, &iter, 0, s, -1, -1);
#line 2198 "tracker-explorer.c"
					_g_free0 (s);
				}
			}
		}
		_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
	}
	goto __finally4;
	__catch4_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (e);
		}
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_free0 (query);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (query);
}


#line 220 "tracker-explorer.vala"
static char* explorer_subst_prefix (Explorer* self, const char* uri) {
#line 2228 "tracker-explorer.c"
	char* result;
	char** _tmp1_;
	gint parts_size;
	gint parts_length1;
	char** _tmp0_;
	char** parts;
	char* prefix;
	char* relationship;
#line 220 "tracker-explorer.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 220 "tracker-explorer.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 2241 "tracker-explorer.c"
	parts = (_tmp1_ = _tmp0_ = g_strsplit (uri, "#", 0), parts_length1 = _vala_array_length (_tmp0_), parts_size = parts_length1, _tmp1_);
	prefix = (char*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->namespaces, parts[0]);
	relationship = NULL;
#line 225 "tracker-explorer.vala"
	if (prefix != NULL) {
#line 2247 "tracker-explorer.c"
		char* _tmp2_;
#line 226 "tracker-explorer.vala"
		relationship = (_tmp2_ = g_strjoin (":", prefix, parts[1], NULL), _g_free0 (relationship), _tmp2_);
#line 2251 "tracker-explorer.c"
	} else {
		char* _tmp3_;
#line 228 "tracker-explorer.vala"
		relationship = (_tmp3_ = g_strdup (uri), _g_free0 (relationship), _tmp3_);
#line 2256 "tracker-explorer.c"
	}
	result = relationship;
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (prefix);
	return result;
}


#line 232 "tracker-explorer.vala"
static void explorer_clear_types (Explorer* self) {
#line 2267 "tracker-explorer.c"
	gint npages;
#line 232 "tracker-explorer.vala"
	g_return_if_fail (self != NULL);
#line 2271 "tracker-explorer.c"
	npages = gtk_notebook_get_n_pages (self->priv->types);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
#line 234 "tracker-explorer.vala"
			while (TRUE) {
#line 234 "tracker-explorer.vala"
				if (!_tmp0_) {
#line 234 "tracker-explorer.vala"
					i++;
#line 2285 "tracker-explorer.c"
				}
#line 234 "tracker-explorer.vala"
				_tmp0_ = FALSE;
#line 234 "tracker-explorer.vala"
				if (!(i < npages)) {
#line 234 "tracker-explorer.vala"
					break;
#line 2293 "tracker-explorer.c"
				}
#line 236 "tracker-explorer.vala"
				gtk_notebook_remove_page (self->priv->types, 0);
#line 2297 "tracker-explorer.c"
			}
		}
	}
}


#line 241 "tracker-explorer.vala"
static void explorer_update_types_page (Explorer* self, GtkWidget* w) {
#line 2306 "tracker-explorer.c"
	GError * _inner_error_;
	gint page_num;
	GtkWidget* _tmp0_;
	GtkScrolledWindow* sw;
	GtkWidget* _tmp1_;
	char* type;
	GtkWidget* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkListStore* model;
#line 241 "tracker-explorer.vala"
	g_return_if_fail (self != NULL);
#line 2318 "tracker-explorer.c"
	_inner_error_ = NULL;
	page_num = gtk_notebook_get_current_page (self->priv->types);
#line 243 "tracker-explorer.vala"
	if (page_num < 0) {
#line 2323 "tracker-explorer.c"
		return;
	}
	sw = _g_object_ref0 ((_tmp0_ = gtk_notebook_get_nth_page (self->priv->types, page_num), GTK_IS_SCROLLED_WINDOW (_tmp0_) ? ((GtkScrolledWindow*) _tmp0_) : NULL));
	type = g_strdup (gtk_label_get_text ((_tmp1_ = gtk_notebook_get_tab_label (self->priv->types, (GtkWidget*) sw), GTK_IS_LABEL (_tmp1_) ? ((GtkLabel*) _tmp1_) : NULL)));
	model = _g_object_ref0 ((_tmp3_ = gtk_tree_view_get_model ((_tmp2_ = gtk_bin_get_child ((GtkBin*) sw), GTK_IS_TREE_VIEW (_tmp2_) ? ((GtkTreeView*) _tmp2_) : NULL)), GTK_IS_LIST_STORE (_tmp3_) ? ((GtkListStore*) _tmp3_) : NULL));
	{
		char* query;
		char** _tmp6_;
		gint _result__length2;
		gint _result__length1;
		gint _tmp5_;
		gint _tmp4_;
		char** _result_;
		GtkTreeIter iter = {0};
		query = g_strdup_printf ("SELECT ?r WHERE { ?r rdfs:range %s }", type);
		_result_ = (_tmp6_ = resources_SparqlQuery (self->priv->tracker, query, &_tmp4_, &_tmp5_, &_inner_error_), _result__length1 = _tmp4_, _result__length2 = _tmp5_, _tmp6_);
		if (_inner_error_ != NULL) {
			_g_free0 (query);
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch5_dbus_gerror;
			}
			goto __finally5;
		}
#line 255 "tracker-explorer.vala"
		gtk_list_store_clear (model);
#line 2349 "tracker-explorer.c"
		{
			gint i;
			i = 0;
			{
				gboolean _tmp7_;
				_tmp7_ = TRUE;
#line 258 "tracker-explorer.vala"
				while (TRUE) {
#line 2358 "tracker-explorer.c"
					char* relation;
					char* _tmp8_;
					char* _tmp9_;
					char* query2;
					char** _tmp12_;
					gint result2_length2;
					gint result2_length1;
					gint _tmp11_;
					gint _tmp10_;
					char** result2;
#line 258 "tracker-explorer.vala"
					if (!_tmp7_) {
#line 258 "tracker-explorer.vala"
						i++;
#line 2373 "tracker-explorer.c"
					}
#line 258 "tracker-explorer.vala"
					_tmp7_ = FALSE;
#line 258 "tracker-explorer.vala"
					if (!(i < _result__length1)) {
#line 258 "tracker-explorer.vala"
						break;
#line 2381 "tracker-explorer.c"
					}
					relation = explorer_subst_prefix (self, _result_[(i * _result__length2) + 0]);
					query2 = (_tmp9_ = g_strdup_printf ("SELECT ?s WHERE { ?s %s <%s>}", relation, _tmp8_ = history_current_uri (self->priv->history)), _g_free0 (_tmp8_), _tmp9_);
					result2 = (_tmp12_ = resources_SparqlQuery (self->priv->tracker, query2, &_tmp10_, &_tmp11_, &_inner_error_), result2_length1 = _tmp10_, result2_length2 = _tmp11_, _tmp12_);
					if (_inner_error_ != NULL) {
						_g_free0 (relation);
						_g_free0 (query2);
						_g_free0 (query);
						_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
						if (_inner_error_->domain == DBUS_GERROR) {
							goto __catch5_dbus_gerror;
						}
						goto __finally5;
					}
					{
						gint j;
						j = 0;
						{
							gboolean _tmp13_;
							_tmp13_ = TRUE;
#line 263 "tracker-explorer.vala"
							while (TRUE) {
#line 2404 "tracker-explorer.c"
								char* subject;
#line 263 "tracker-explorer.vala"
								if (!_tmp13_) {
#line 263 "tracker-explorer.vala"
									j++;
#line 2410 "tracker-explorer.c"
								}
#line 263 "tracker-explorer.vala"
								_tmp13_ = FALSE;
#line 263 "tracker-explorer.vala"
								if (!(j < result2_length1)) {
#line 263 "tracker-explorer.vala"
									break;
#line 2418 "tracker-explorer.c"
								}
								subject = explorer_subst_prefix (self, result2[(j * result2_length2) + 0]);
#line 265 "tracker-explorer.vala"
								gtk_list_store_append (model, &iter);
#line 266 "tracker-explorer.vala"
								gtk_list_store_set (model, &iter, 0, result2[(j * result2_length2) + 0], -1, -1);
#line 267 "tracker-explorer.vala"
								gtk_list_store_set (model, &iter, 1, subject, -1, -1);
#line 268 "tracker-explorer.vala"
								gtk_list_store_set (model, &iter, 2, relation, -1, -1);
#line 2429 "tracker-explorer.c"
								_g_free0 (subject);
							}
						}
					}
					_g_free0 (relation);
					_g_free0 (query2);
					result2 = (_vala_array_free (result2, result2_length1 * result2_length2, (GDestroyNotify) g_free), NULL);
				}
			}
		}
		_g_free0 (query);
		_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
	}
	goto __finally5;
	__catch5_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (e);
		}
	}
	__finally5:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (sw);
		_g_free0 (type);
		_g_object_unref0 (model);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (sw);
	_g_free0 (type);
	_g_object_unref0 (model);
}


#line 276 "tracker-explorer.vala"
static void explorer_add_type (Explorer* self, const char* type) {
#line 2470 "tracker-explorer.c"
	GtkLabel* tab_label;
	GtkScrolledWindow* child;
	GtkTreeView* tv;
#line 276 "tracker-explorer.vala"
	g_return_if_fail (self != NULL);
#line 276 "tracker-explorer.vala"
	g_return_if_fail (type != NULL);
#line 2478 "tracker-explorer.c"
	tab_label = g_object_ref_sink ((GtkLabel*) gtk_label_new (type));
	child = g_object_ref_sink ((GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL));
	tv = explorer_setup_reverserelationships (self);
#line 280 "tracker-explorer.vala"
	gtk_container_add ((GtkContainer*) child, (GtkWidget*) tv);
#line 281 "tracker-explorer.vala"
	gtk_notebook_append_page (self->priv->types, (GtkWidget*) child, (GtkWidget*) tab_label);
#line 282 "tracker-explorer.vala"
	gtk_widget_show_all ((GtkWidget*) child);
#line 2488 "tracker-explorer.c"
	_g_object_unref0 (tab_label);
	_g_object_unref0 (child);
	_g_object_unref0 (tv);
}


#line 285 "tracker-explorer.vala"
static void explorer_set_current_uri (Explorer* self, const char* uri) {
#line 285 "tracker-explorer.vala"
	g_return_if_fail (self != NULL);
#line 285 "tracker-explorer.vala"
	g_return_if_fail (uri != NULL);
#line 286 "tracker-explorer.vala"
	history_add (self->priv->history, uri);
#line 287 "tracker-explorer.vala"
	explorer_update_pane (self);
#line 2505 "tracker-explorer.c"
}


#line 290 "tracker-explorer.vala"
static void explorer_forward_clicked (Explorer* self) {
#line 290 "tracker-explorer.vala"
	g_return_if_fail (self != NULL);
#line 291 "tracker-explorer.vala"
	if (history_forward (self->priv->history)) {
#line 292 "tracker-explorer.vala"
		explorer_update_pane (self);
#line 2517 "tracker-explorer.c"
	}
}


#line 296 "tracker-explorer.vala"
static void explorer_back_clicked (Explorer* self) {
#line 296 "tracker-explorer.vala"
	g_return_if_fail (self != NULL);
#line 297 "tracker-explorer.vala"
	if (history_back (self->priv->history)) {
#line 298 "tracker-explorer.vala"
		explorer_update_pane (self);
#line 2530 "tracker-explorer.c"
	}
}


#line 302 "tracker-explorer.vala"
static void explorer_update_pane (Explorer* self) {
#line 2537 "tracker-explorer.c"
	GError * _inner_error_;
	char* _tmp1_;
	char* _tmp0_;
#line 302 "tracker-explorer.vala"
	g_return_if_fail (self != NULL);
#line 2543 "tracker-explorer.c"
	_inner_error_ = NULL;
#line 303 "tracker-explorer.vala"
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->forward, history_can_go_forward (self->priv->history));
#line 304 "tracker-explorer.vala"
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->back, history_can_go_back (self->priv->history));
#line 305 "tracker-explorer.vala"
	gtk_label_set_text (self->priv->current_uri_label, _tmp1_ = explorer_subst_prefix (self, _tmp0_ = history_current_uri (self->priv->history)));
#line 2551 "tracker-explorer.c"
	_g_free0 (_tmp1_);
	_g_free0 (_tmp0_);
	{
		char* _tmp2_;
		char* _tmp3_;
		char* query;
		GtkTreeIter iter = {0};
		char** _tmp6_;
		gint _result__length2;
		gint _result__length1;
		gint _tmp5_;
		gint _tmp4_;
		char** _result_;
		query = (_tmp3_ = g_strdup_printf ("SELECT ?r ?o  WHERE { <%s> ?r ?o }", _tmp2_ = history_current_uri (self->priv->history)), _g_free0 (_tmp2_), _tmp3_);
		_result_ = (_tmp6_ = resources_SparqlQuery (self->priv->tracker, query, &_tmp4_, &_tmp5_, &_inner_error_), _result__length1 = _tmp4_, _result__length2 = _tmp5_, _tmp6_);
		if (_inner_error_ != NULL) {
			_g_free0 (query);
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch6_dbus_gerror;
			}
			goto __finally6;
		}
#line 310 "tracker-explorer.vala"
		gtk_list_store_clear (self->priv->relationships);
#line 311 "tracker-explorer.vala"
		explorer_clear_types (self);
#line 2578 "tracker-explorer.c"
		{
			gint i;
			i = 0;
			{
				gboolean _tmp7_;
				_tmp7_ = TRUE;
#line 313 "tracker-explorer.vala"
				while (TRUE) {
#line 2587 "tracker-explorer.c"
					char* relationship;
					char* obj;
					gboolean _tmp8_;
#line 313 "tracker-explorer.vala"
					if (!_tmp7_) {
#line 313 "tracker-explorer.vala"
						i++;
#line 2595 "tracker-explorer.c"
					}
#line 313 "tracker-explorer.vala"
					_tmp7_ = FALSE;
#line 313 "tracker-explorer.vala"
					if (!(i < _result__length1)) {
#line 313 "tracker-explorer.vala"
						break;
#line 2603 "tracker-explorer.c"
					}
					relationship = explorer_subst_prefix (self, _result_[(i * _result__length2) + 0]);
					obj = explorer_subst_prefix (self, _result_[(i * _result__length2) + 1]);
#line 316 "tracker-explorer.vala"
					gtk_list_store_append (self->priv->relationships, &iter);
#line 317 "tracker-explorer.vala"
					gtk_list_store_set (self->priv->relationships, &iter, 0, _result_[(i * _result__length2) + 1], -1, -1);
#line 318 "tracker-explorer.vala"
					gtk_list_store_set (self->priv->relationships, &iter, 1, relationship, -1, -1);
#line 319 "tracker-explorer.vala"
					gtk_list_store_set (self->priv->relationships, &iter, 2, obj, -1, -1);
#line 2615 "tracker-explorer.c"
					_tmp8_ = FALSE;
#line 321 "tracker-explorer.vala"
					if (_vala_strcmp0 (relationship, "rdf:type") == 0) {
#line 321 "tracker-explorer.vala"
						_tmp8_ = _vala_strcmp0 (obj, "rdfs:Resource") != 0;
#line 2621 "tracker-explorer.c"
					} else {
#line 321 "tracker-explorer.vala"
						_tmp8_ = FALSE;
#line 2625 "tracker-explorer.c"
					}
#line 321 "tracker-explorer.vala"
					if (_tmp8_) {
#line 322 "tracker-explorer.vala"
						explorer_add_type (self, obj);
#line 2631 "tracker-explorer.c"
					}
					_g_free0 (relationship);
					_g_free0 (obj);
				}
			}
		}
#line 325 "tracker-explorer.vala"
		gtk_notebook_set_current_page (self->priv->types, gtk_notebook_get_n_pages (self->priv->types) - 1);
#line 326 "tracker-explorer.vala"
		explorer_update_types_page (self, NULL);
#line 2642 "tracker-explorer.c"
		_g_free0 (query);
		_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
	}
	goto __finally6;
	__catch6_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (e);
		}
	}
	__finally6:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
}


#line 332 "tracker-explorer.vala"
static void explorer_row_selected (Explorer* self, GtkTreeView* view, const GtkTreePath* path, GtkTreeViewColumn* column) {
#line 2667 "tracker-explorer.c"
	GtkTreeIter iter = {0};
	GtkTreeModel* model;
	const char* uri;
#line 332 "tracker-explorer.vala"
	g_return_if_fail (self != NULL);
#line 332 "tracker-explorer.vala"
	g_return_if_fail (view != NULL);
#line 332 "tracker-explorer.vala"
	g_return_if_fail (path != NULL);
#line 332 "tracker-explorer.vala"
	g_return_if_fail (column != NULL);
#line 2679 "tracker-explorer.c"
	model = _g_object_ref0 (gtk_tree_view_get_model (view));
#line 335 "tracker-explorer.vala"
	gtk_tree_model_get_iter (model, &iter, path);
#line 2683 "tracker-explorer.c"
	uri = NULL;
#line 337 "tracker-explorer.vala"
	gtk_tree_model_get (model, &iter, 0, &uri, -1);
#line 338 "tracker-explorer.vala"
	explorer_set_current_uri (self, uri);
#line 2689 "tracker-explorer.c"
	_g_object_unref0 (model);
}


#line 76 "tracker-explorer.vala"
Explorer* explorer_construct (GType object_type) {
#line 2696 "tracker-explorer.c"
	Explorer* self;
	self = (Explorer*) g_type_create_instance (object_type);
	return self;
}


#line 76 "tracker-explorer.vala"
Explorer* explorer_new (void) {
#line 76 "tracker-explorer.vala"
	return explorer_construct (TYPE_EXPLORER);
#line 2707 "tracker-explorer.c"
}


static void value_explorer_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_explorer_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		explorer_unref (value->data[0].v_pointer);
	}
}


static void value_explorer_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = explorer_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_explorer_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_explorer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Explorer* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = explorer_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_explorer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Explorer** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = explorer_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_explorer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecExplorer* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_EXPLORER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_explorer (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EXPLORER), NULL);
	return value->data[0].v_pointer;
}


void value_set_explorer (GValue* value, gpointer v_object) {
	Explorer* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EXPLORER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_EXPLORER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		explorer_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		explorer_unref (old);
	}
}


static void explorer_class_init (ExplorerClass * klass) {
	explorer_parent_class = g_type_class_peek_parent (klass);
	EXPLORER_CLASS (klass)->finalize = explorer_finalize;
	g_type_class_add_private (klass, sizeof (ExplorerPrivate));
}


static void explorer_instance_init (Explorer * self) {
	self->priv = EXPLORER_GET_PRIVATE (self);
	self->priv->history = history_new ();
	self->priv->namespaces = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal, g_str_equal);
	self->ref_count = 1;
}


static void explorer_finalize (Explorer* obj) {
	Explorer * self;
	self = EXPLORER (obj);
	_g_object_unref0 (self->priv->tracker);
	_history_unref0 (self->priv->history);
	_g_object_unref0 (self->priv->uris);
	_g_object_unref0 (self->priv->relationships);
	_g_object_unref0 (self->priv->current_uri_label);
	_g_object_unref0 (self->priv->namespaces);
	_g_object_unref0 (self->priv->types);
	_g_object_unref0 (self->priv->forward);
	_g_object_unref0 (self->priv->back);
}


GType explorer_get_type (void) {
	static GType explorer_type_id = 0;
	if (explorer_type_id == 0) {
		static const GTypeValueTable g_define_type_value_table = { value_explorer_init, value_explorer_free_value, value_explorer_copy_value, value_explorer_peek_pointer, "p", value_explorer_collect_value, "p", value_explorer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ExplorerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) explorer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Explorer), 0, (GInstanceInitFunc) explorer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		explorer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Explorer", &g_define_type_info, &g_define_type_fundamental_info, 0);
	}
	return explorer_type_id;
}


gpointer explorer_ref (gpointer instance) {
	Explorer* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void explorer_unref (gpointer instance) {
	Explorer* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		EXPLORER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


#line 346 "tracker-explorer.vala"
gint _main (char** args, int args_length1) {
#line 2866 "tracker-explorer.c"
	gint result;
	Explorer* s;
#line 347 "tracker-explorer.vala"
	gtk_init (&args_length1, &args);
#line 2871 "tracker-explorer.c"
	s = explorer_new ();
#line 350 "tracker-explorer.vala"
	explorer_show (s);
#line 351 "tracker-explorer.vala"
	gtk_main ();
#line 2877 "tracker-explorer.c"
	result = 0;
	_explorer_unref0 (s);
	return result;
}


#line 346 "tracker-explorer.vala"
int main (int argc, char ** argv) {
#line 346 "tracker-explorer.vala"
	g_type_init ();
#line 346 "tracker-explorer.vala"
	return _main (argv, argc);
#line 2890 "tracker-explorer.c"
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}




