/* rygel-http-get-test.c generated by valac 0.11.6, the Vala compiler
 * generated from rygel-http-get-test.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <libsoup/soup.h>
#include <gio/gio.h>
#include <libgssdp/gssdp.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TYPE_HTTP_GET_TEST (rygel_http_get_test_get_type ())
#define RYGEL_HTTP_GET_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_TEST, RygelHTTPGetTest))
#define RYGEL_HTTP_GET_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_TEST, RygelHTTPGetTestClass))
#define RYGEL_IS_HTTP_GET_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_TEST))
#define RYGEL_IS_HTTP_GET_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_TEST))
#define RYGEL_HTTP_GET_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_TEST, RygelHTTPGetTestClass))

typedef struct _RygelHTTPGetTest RygelHTTPGetTest;
typedef struct _RygelHTTPGetTestClass RygelHTTPGetTestClass;
typedef struct _RygelHTTPGetTestPrivate RygelHTTPGetTestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_CLIENT (rygel_http_client_get_type ())
#define RYGEL_HTTP_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClient))
#define RYGEL_HTTP_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientClass))
#define RYGEL_IS_HTTP_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_CLIENT))
#define RYGEL_IS_HTTP_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_CLIENT))
#define RYGEL_HTTP_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientClass))

typedef struct _RygelHTTPClient RygelHTTPClient;
typedef struct _RygelHTTPClientClass RygelHTTPClientClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelHttpGetTestHandleClientMessageData RygelHttpGetTestHandleClientMessageData;
#define _rygel_media_object_unref0(var) ((var == NULL) ? NULL : (var = (rygel_media_object_unref (var), NULL)))

#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;
typedef struct _RygelHTTPClientPrivate RygelHTTPClientPrivate;
typedef struct _Block1Data Block1Data;
typedef struct _RygelHttpClientRunData RygelHttpClientRunData;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;
typedef struct _Block2Data Block2Data;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;
typedef struct _RygelMediaContainerFindObjectData RygelMediaContainerFindObjectData;

#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;
typedef struct _RygelHTTPGetHandlerPrivate RygelHTTPGetHandlerPrivate;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;
typedef struct _RygelParamSpecHTTPGetHandler RygelParamSpecHTTPGetHandler;

#define RYGEL_TYPE_HTTP_TRANSCODE_HANDLER (rygel_http_transcode_handler_get_type ())
#define RYGEL_HTTP_TRANSCODE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandler))
#define RYGEL_HTTP_TRANSCODE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandlerClass))
#define RYGEL_IS_HTTP_TRANSCODE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER))
#define RYGEL_IS_HTTP_TRANSCODE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER))
#define RYGEL_HTTP_TRANSCODE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandlerClass))

typedef struct _RygelHTTPTranscodeHandler RygelHTTPTranscodeHandler;
typedef struct _RygelHTTPTranscodeHandlerClass RygelHTTPTranscodeHandlerClass;
typedef struct _RygelHTTPTranscodeHandlerPrivate RygelHTTPTranscodeHandlerPrivate;

#define RYGEL_TYPE_HTTP_IDENTITY_HANDLER (rygel_http_identity_handler_get_type ())
#define RYGEL_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandler))
#define RYGEL_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_HTTP_IDENTITY_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))

typedef struct _RygelHTTPIdentityHandler RygelHTTPIdentityHandler;
typedef struct _RygelHTTPIdentityHandlerClass RygelHTTPIdentityHandlerClass;
typedef struct _RygelHTTPIdentityHandlerPrivate RygelHTTPIdentityHandlerPrivate;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;

#define RYGEL_TYPE_VISUAL_ITEM (rygel_visual_item_get_type ())
#define RYGEL_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItem))
#define RYGEL_IS_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_VISUAL_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemIface))

typedef struct _RygelVisualItem RygelVisualItem;
typedef struct _RygelVisualItemIface RygelVisualItemIface;
typedef struct _RygelVideoItemPrivate RygelVideoItemPrivate;

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;
typedef struct _RygelMusicItemPrivate RygelMusicItemPrivate;
#define _rygel_thumbnail_unref0(var) ((var == NULL) ? NULL : (var = (rygel_thumbnail_unref (var), NULL)))
typedef struct _RygelThumbnailPrivate RygelThumbnailPrivate;
typedef struct _RygelParamSpecThumbnail RygelParamSpecThumbnail;
typedef struct _RygelSubtitlePrivate RygelSubtitlePrivate;
typedef struct _RygelParamSpecSubtitle RygelParamSpecSubtitle;
typedef struct _RygelHTTPResponsePrivate RygelHTTPResponsePrivate;
typedef struct _Block3Data Block3Data;
typedef struct _RygelHttpResponseRunData RygelHttpResponseRunData;
typedef struct _RygelParamSpecMediaObject RygelParamSpecMediaObject;
typedef struct _RygelTranscoderPrivate RygelTranscoderPrivate;
typedef struct _RygelParamSpecTranscoder RygelParamSpecTranscoder;

typedef enum  {
	RYGEL_TEST_ERROR_SKIP = 77,
	RYGEL_TEST_ERROR_TIMEOUT
} RygelTestError;
#define RYGEL_TEST_ERROR rygel_test_error_quark ()
struct _RygelHTTPGetTest {
	GObject parent_instance;
	RygelHTTPGetTestPrivate * priv;
	RygelHTTPServer* server;
	RygelHTTPClient* client;
};

struct _RygelHTTPGetTestClass {
	GObjectClass parent_class;
	void (*run) (RygelHTTPGetTest* self, GError** error);
};

struct _RygelHTTPGetTestPrivate {
	gboolean server_done;
	gboolean client_done;
	GMainLoop* main_loop;
	GError* error;
};

struct _RygelHTTPServer {
	GObject parent_instance;
	RygelHTTPServerPrivate * priv;
	RygelMediaContainer* root_container;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	GObjectClass parent_class;
};

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaItem* item;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelHttpGetTestHandleClientMessageData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPGetTest* self;
	SoupMessage* msg;
	RygelHTTPRequest* _tmp0_;
	RygelHTTPRequest* request;
	RygelHTTPRequest* _tmp1_;
	GError * _error_;
	GError* _tmp2_;
	GError* _tmp3_;
	GError * _inner_error_;
};

struct _RygelHTTPClient {
	GObject parent_instance;
	RygelHTTPClientPrivate * priv;
	GUPnPContext* context;
	SoupMessage* msg;
};

struct _RygelHTTPClientClass {
	GObjectClass parent_class;
};

struct _RygelHTTPClientPrivate {
	GCancellable* _cancellable;
};

struct _Block1Data {
	int _ref_count_;
	RygelHTTPClient * self;
	GSourceFunc run_continue;
	gpointer run_continue_target;
	GDestroyNotify run_continue_target_destroy_notify;
	gpointer _async_data_;
};

struct _RygelHttpClientRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPClient* self;
	Block1Data* _data1_;
	SoupSession* _tmp0_;
	SoupMessage* _tmp1_;
};

struct _RygelMediaObject {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelMediaObjectPrivate * priv;
	gchar* id;
};

struct _RygelMediaObjectClass {
	GTypeClass parent_class;
	void (*finalize) (RygelMediaObject *self);
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
};

struct _Block2Data {
	int _ref_count_;
	RygelMediaContainer * self;
	GSourceFunc find_object_continue;
	gpointer find_object_continue_target;
	GDestroyNotify find_object_continue_target_destroy_notify;
	gpointer _async_data_;
};

struct _RygelMediaContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaContainer* self;
	gchar* item_id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	Block2Data* _data2_;
	RygelVideoItem* _tmp0_;
};

struct _RygelHTTPGetHandler {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelHTTPGetHandlerPrivate * priv;
};

struct _RygelHTTPGetHandlerClass {
	GTypeClass parent_class;
	void (*finalize) (RygelHTTPGetHandler *self);
};

struct _RygelParamSpecHTTPGetHandler {
	GParamSpec parent_instance;
};

struct _RygelHTTPTranscodeHandler {
	RygelHTTPGetHandler parent_instance;
	RygelHTTPTranscodeHandlerPrivate * priv;
};

struct _RygelHTTPTranscodeHandlerClass {
	RygelHTTPGetHandlerClass parent_class;
};

struct _RygelHTTPIdentityHandler {
	RygelHTTPGetHandler parent_instance;
	RygelHTTPIdentityHandlerPrivate * priv;
};

struct _RygelHTTPIdentityHandlerClass {
	RygelHTTPGetHandlerClass parent_class;
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	glong size;
	GeeArrayList* subtitles;
	GeeArrayList* thumbnails;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
	gint64 duration;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelVisualItemIface {
	GTypeInterface parent_iface;
	gint (*get_width) (RygelVisualItem* self);
	void (*set_width) (RygelVisualItem* self, gint value);
	gint (*get_height) (RygelVisualItem* self);
	void (*set_height) (RygelVisualItem* self, gint value);
	gint (*get_pixel_width) (RygelVisualItem* self);
	void (*set_pixel_width) (RygelVisualItem* self, gint value);
	gint (*get_pixel_height) (RygelVisualItem* self);
	void (*set_pixel_height) (RygelVisualItem* self, gint value);
	gint (*get_color_depth) (RygelVisualItem* self);
	void (*set_color_depth) (RygelVisualItem* self, gint value);
	GeeArrayList* (*get_thumbnails) (RygelVisualItem* self);
	void (*set_thumbnails) (RygelVisualItem* self, GeeArrayList* value);
};

struct _RygelVideoItem {
	RygelAudioItem parent_instance;
	RygelVideoItemPrivate * priv;
	GeeArrayList* subtitles;
};

struct _RygelVideoItemClass {
	RygelAudioItemClass parent_class;
};

struct _RygelVideoItemPrivate {
	gint _width;
	gint _height;
	gint _pixel_width;
	gint _pixel_height;
	gint _color_depth;
	GeeArrayList* _thumbnails;
};

struct _RygelMusicItem {
	RygelAudioItem parent_instance;
	RygelMusicItemPrivate * priv;
	RygelThumbnail* album_art;
};

struct _RygelMusicItemClass {
	RygelAudioItemClass parent_class;
};

struct _RygelThumbnail {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelThumbnailPrivate * priv;
	glong size;
};

struct _RygelThumbnailClass {
	GTypeClass parent_class;
	void (*finalize) (RygelThumbnail *self);
};

struct _RygelParamSpecThumbnail {
	GParamSpec parent_instance;
};

struct _RygelSubtitle {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSubtitlePrivate * priv;
	glong size;
};

struct _RygelSubtitleClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSubtitle *self);
};

struct _RygelParamSpecSubtitle {
	GParamSpec parent_instance;
};

struct _RygelHTTPResponse {
	GObject parent_instance;
	RygelHTTPResponsePrivate * priv;
};

struct _RygelHTTPResponseClass {
	GObjectClass parent_class;
};

struct _RygelHTTPResponsePrivate {
	GCancellable* _cancellable;
	SoupMessage* msg;
	SoupServer* server;
};

struct _Block3Data {
	int _ref_count_;
	RygelHTTPResponse * self;
	GSourceFunc run_continue;
	gpointer run_continue_target;
	GDestroyNotify run_continue_target_destroy_notify;
	gpointer _async_data_;
};

struct _RygelHttpResponseRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPResponse* self;
	Block3Data* _data3_;
};

struct _RygelParamSpecMediaObject {
	GParamSpec parent_instance;
};

struct _RygelTranscoder {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTranscoderPrivate * priv;
};

struct _RygelTranscoderClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTranscoder *self);
};

struct _RygelParamSpecTranscoder {
	GParamSpec parent_instance;
};


static gpointer rygel_http_get_test_parent_class = NULL;
static gpointer rygel_http_server_parent_class = NULL;
static gpointer rygel_http_client_parent_class = NULL;
static RygelStateMachineIface* rygel_http_client_rygel_state_machine_parent_iface = NULL;
static gpointer rygel_media_container_parent_class = NULL;
static gpointer rygel_http_get_handler_parent_class = NULL;
static gpointer rygel_http_transcode_handler_parent_class = NULL;
static gpointer rygel_http_identity_handler_parent_class = NULL;
static gpointer rygel_media_item_parent_class = NULL;
static gpointer rygel_audio_item_parent_class = NULL;
static gpointer rygel_video_item_parent_class = NULL;
static RygelVisualItemIface* rygel_video_item_rygel_visual_item_parent_iface = NULL;
static gpointer rygel_music_item_parent_class = NULL;
static gpointer rygel_thumbnail_parent_class = NULL;
static gpointer rygel_subtitle_parent_class = NULL;
static gpointer rygel_http_response_parent_class = NULL;
static RygelStateMachineIface* rygel_http_response_rygel_state_machine_parent_iface = NULL;
static gpointer rygel_media_object_parent_class = NULL;
static gpointer rygel_transcoder_parent_class = NULL;

GQuark rygel_test_error_quark (void);
GType rygel_http_get_test_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_client_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_GET_TEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_GET_TEST, RygelHTTPGetTestPrivate))
enum  {
	RYGEL_HTTP_GET_TEST_DUMMY_PROPERTY
};
gint rygel_http_get_test_main (gchar** args, int args_length1);
RygelHTTPGetTest* rygel_http_get_test_new (GError** error);
RygelHTTPGetTest* rygel_http_get_test_construct (GType object_type, GError** error);
void rygel_http_get_test_run (RygelHTTPGetTest* self, GError** error);
RygelHTTPServer* rygel_http_server_new (GError** error);
RygelHTTPServer* rygel_http_server_construct (GType object_type, GError** error);
gpointer rygel_media_object_ref (gpointer instance);
void rygel_media_object_unref (gpointer instance);
GParamSpec* rygel_param_spec_media_object (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_media_object (GValue* value, gpointer v_object);
void rygel_value_take_media_object (GValue* value, gpointer v_object);
gpointer rygel_value_get_media_object (const GValue* value);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
gchar* rygel_http_server_get_uri (RygelHTTPServer* self);
RygelHTTPClient* rygel_http_client_new (GUPnPContext* context, const gchar* uri);
RygelHTTPClient* rygel_http_client_construct (GType object_type, GUPnPContext* context, const gchar* uri);
static void rygel_http_get_test_real_run (RygelHTTPGetTest* self, GError** error);
static gboolean rygel_http_get_test_on_timeout (RygelHTTPGetTest* self);
static gboolean _rygel_http_get_test_on_timeout_gsource_func (gpointer self);
static void rygel_http_get_test_on_message_received (RygelHTTPGetTest* self, RygelHTTPServer* server, SoupMessage* msg);
static void _rygel_http_get_test_on_message_received_rygel_http_server_message_received (RygelHTTPServer* _sender, SoupMessage* message, gpointer self);
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
static void rygel_http_get_test_on_client_completed (RygelHTTPGetTest* self, RygelStateMachine* client);
static void _rygel_http_get_test_on_client_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self);
void rygel_state_machine_run (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_state_machine_run_finish (RygelStateMachine* self, GAsyncResult* _res_);
GType rygel_http_request_get_type (void) G_GNUC_CONST;
static RygelHTTPRequest* rygel_http_get_test_create_request (RygelHTTPGetTest* self, SoupMessage* msg, GError** error);
RygelHTTPGet* rygel_http_get_new (RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
RygelHTTPGet* rygel_http_get_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
GType rygel_http_get_get_type (void) G_GNUC_CONST;
static void rygel_http_get_test_handle_client_message (RygelHTTPGetTest* self, SoupMessage* msg, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_get_test_handle_client_message_finish (RygelHTTPGetTest* self, GAsyncResult* _res_);
static void rygel_http_get_test_handle_client_message_data_free (gpointer _data);
static gboolean rygel_http_get_test_handle_client_message_co (RygelHttpGetTestHandleClientMessageData* data);
static void rygel_http_get_test_handle_client_message_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
static void rygel_http_get_test_finalize (GObject* obj);
enum  {
	RYGEL_HTTP_SERVER_DUMMY_PROPERTY,
	RYGEL_HTTP_SERVER_PATH_ROOT,
	RYGEL_HTTP_SERVER_URI
};
#define RYGEL_HTTP_SERVER_SERVER_PATH "/RygelHTTPServer/Rygel/Test"
static void rygel_http_server_server_cb (RygelHTTPServer* self, SoupServer* server, SoupMessage* msg, const gchar* path, GHashTable* query, SoupClientContext* client);
static void _rygel_http_server_server_cb_soup_server_callback (SoupServer* server, SoupMessage* msg, const gchar* path, GHashTable* query, SoupClientContext* client, gpointer self);
RygelMediaContainer* rygel_media_container_new (void);
RygelMediaContainer* rygel_media_container_construct (GType object_type);
gpointer rygel_transcoder_ref (gpointer instance);
void rygel_transcoder_unref (gpointer instance);
GParamSpec* rygel_param_spec_transcoder (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_transcoder (GValue* value, gpointer v_object);
void rygel_value_take_transcoder (GValue* value, gpointer v_object);
gpointer rygel_value_get_transcoder (const GValue* value);
GType rygel_transcoder_get_type (void) G_GNUC_CONST;
RygelTranscoder* rygel_http_server_get_transcoder (RygelHTTPServer* self, const gchar* target, GError** error);
RygelTranscoder* rygel_transcoder_new (void);
RygelTranscoder* rygel_transcoder_construct (GType object_type);
const gchar* rygel_http_server_get_path_root (RygelHTTPServer* self);
#define RYGEL_MEDIA_CONTAINER_ITEM_ID "TestItem"
RygelHTTPItemURI* rygel_http_item_uri_new (const gchar* item_id, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
RygelHTTPItemURI* rygel_http_item_uri_construct (GType object_type, const gchar* item_id, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
gchar* rygel_http_item_uri_to_string (RygelHTTPItemURI* self);
static void rygel_http_server_finalize (GObject* obj);
static void _vala_rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
#define RYGEL_HTTP_CLIENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientPrivate))
enum  {
	RYGEL_HTTP_CLIENT_DUMMY_PROPERTY,
	RYGEL_HTTP_CLIENT_CANCELLABLE
};
static void rygel_http_client_real_run_data_free (gpointer _data);
static void rygel_http_client_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_client_real_run_co (RygelHttpClientRunData* data);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static gboolean _rygel_http_client_real_run_co_gsource_func (gpointer self);
static void _lambda1_ (SoupSession* session, SoupMessage* msg, Block1Data* _data1_);
static void __lambda1__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self);
static void rygel_http_client_finalize (GObject* obj);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static void _vala_rygel_http_client_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void rygel_state_machine_set_cancellable (RygelStateMachine* self, GCancellable* value);
static void _vala_rygel_http_client_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	RYGEL_MEDIA_CONTAINER_DUMMY_PROPERTY
};
static void rygel_media_container_find_object_data_free (gpointer _data);
void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* item_id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_media_container_find_object_co (RygelMediaContainerFindObjectData* data);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static gboolean _rygel_media_container_find_object_co_gsource_func (gpointer self);
static gboolean _lambda0_ (Block2Data* _data2_);
static gboolean __lambda0__gsource_func (gpointer self);
RygelVideoItem* rygel_video_item_new (void);
RygelVideoItem* rygel_video_item_construct (GType object_type);
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_video_item_get_type (void) G_GNUC_CONST;
RygelMediaObject* rygel_media_object_new (void);
RygelMediaObject* rygel_media_object_construct (GType object_type);
gpointer rygel_http_get_handler_ref (gpointer instance);
void rygel_http_get_handler_unref (gpointer instance);
GParamSpec* rygel_param_spec_http_get_handler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_http_get_handler (GValue* value, gpointer v_object);
void rygel_value_take_http_get_handler (GValue* value, gpointer v_object);
gpointer rygel_value_get_http_get_handler (const GValue* value);
GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_GET_HANDLER_DUMMY_PROPERTY
};
GType rygel_http_response_get_type (void) G_GNUC_CONST;
RygelHTTPResponse* rygel_http_get_handler_render_body (RygelHTTPGetHandler* self, RygelHTTPGet* get_request);
RygelHTTPResponse* rygel_http_response_new (RygelHTTPGet* get_request);
RygelHTTPResponse* rygel_http_response_construct (GType object_type, RygelHTTPGet* get_request);
void rygel_http_get_handler_add_response_headers (RygelHTTPGetHandler* self, RygelHTTPGet* get_request);
RygelHTTPGetHandler* rygel_http_get_handler_construct (GType object_type);
static void rygel_http_get_handler_finalize (RygelHTTPGetHandler* obj);
GType rygel_http_transcode_handler_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_TRANSCODE_HANDLER_DUMMY_PROPERTY
};
RygelHTTPTranscodeHandler* rygel_http_transcode_handler_new (RygelTranscoder* transcoder, GCancellable* cancellable);
RygelHTTPTranscodeHandler* rygel_http_transcode_handler_construct (GType object_type, RygelTranscoder* transcoder, GCancellable* cancellable);
GType rygel_http_identity_handler_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_IDENTITY_HANDLER_DUMMY_PROPERTY
};
RygelHTTPIdentityHandler* rygel_http_identity_handler_new (GCancellable* cancellable);
RygelHTTPIdentityHandler* rygel_http_identity_handler_construct (GType object_type, GCancellable* cancellable);
gpointer rygel_subtitle_ref (gpointer instance);
void rygel_subtitle_unref (gpointer instance);
GParamSpec* rygel_param_spec_subtitle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_subtitle (GValue* value, gpointer v_object);
void rygel_value_take_subtitle (GValue* value, gpointer v_object);
gpointer rygel_value_get_subtitle (const GValue* value);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
gpointer rygel_thumbnail_ref (gpointer instance);
void rygel_thumbnail_unref (gpointer instance);
GParamSpec* rygel_param_spec_thumbnail (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_thumbnail (GValue* value, gpointer v_object);
void rygel_value_take_thumbnail (GValue* value, gpointer v_object);
gpointer rygel_value_get_thumbnail (const GValue* value);
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MEDIA_ITEM_DUMMY_PROPERTY
};
gboolean rygel_media_item_should_stream (RygelMediaItem* self);
gboolean rygel_media_item_streamable (RygelMediaItem* self);
RygelMediaItem* rygel_media_item_construct (GType object_type);
static void rygel_media_item_finalize (RygelMediaObject* obj);
enum  {
	RYGEL_AUDIO_ITEM_DUMMY_PROPERTY
};
RygelAudioItem* rygel_audio_item_new (void);
RygelAudioItem* rygel_audio_item_construct (GType object_type);
static void rygel_audio_item_finalize (RygelMediaObject* obj);
GType rygel_visual_item_get_type (void) G_GNUC_CONST;
gint rygel_visual_item_get_width (RygelVisualItem* self);
void rygel_visual_item_set_width (RygelVisualItem* self, gint value);
gint rygel_visual_item_get_height (RygelVisualItem* self);
void rygel_visual_item_set_height (RygelVisualItem* self, gint value);
gint rygel_visual_item_get_pixel_width (RygelVisualItem* self);
void rygel_visual_item_set_pixel_width (RygelVisualItem* self, gint value);
gint rygel_visual_item_get_pixel_height (RygelVisualItem* self);
void rygel_visual_item_set_pixel_height (RygelVisualItem* self, gint value);
gint rygel_visual_item_get_color_depth (RygelVisualItem* self);
void rygel_visual_item_set_color_depth (RygelVisualItem* self, gint value);
GeeArrayList* rygel_visual_item_get_thumbnails (RygelVisualItem* self);
void rygel_visual_item_set_thumbnails (RygelVisualItem* self, GeeArrayList* value);
#define RYGEL_VIDEO_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemPrivate))
enum  {
	RYGEL_VIDEO_ITEM_DUMMY_PROPERTY
};
static void rygel_video_item_finalize (RygelMediaObject* obj);
GType rygel_music_item_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MUSIC_ITEM_DUMMY_PROPERTY
};
RygelMusicItem* rygel_music_item_new (void);
RygelMusicItem* rygel_music_item_construct (GType object_type);
static void rygel_music_item_finalize (RygelMediaObject* obj);
enum  {
	RYGEL_THUMBNAIL_DUMMY_PROPERTY
};
RygelThumbnail* rygel_thumbnail_new (void);
RygelThumbnail* rygel_thumbnail_construct (GType object_type);
static void rygel_thumbnail_finalize (RygelThumbnail* obj);
enum  {
	RYGEL_SUBTITLE_DUMMY_PROPERTY
};
RygelSubtitle* rygel_subtitle_new (void);
RygelSubtitle* rygel_subtitle_construct (GType object_type);
static void rygel_subtitle_finalize (RygelSubtitle* obj);
#define RYGEL_HTTP_RESPONSE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponsePrivate))
enum  {
	RYGEL_HTTP_RESPONSE_DUMMY_PROPERTY,
	RYGEL_HTTP_RESPONSE_CANCELLABLE
};
static void rygel_http_response_real_run_data_free (gpointer _data);
static void rygel_http_response_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_response_real_run_co (RygelHttpResponseRunData* data);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static gboolean _rygel_http_response_real_run_co_gsource_func (gpointer self);
static gboolean _lambda2_ (Block3Data* _data3_);
static gboolean __lambda2__gsource_func (gpointer self);
static void rygel_http_response_finalize (GObject* obj);
static void _vala_rygel_http_response_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_http_response_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	RYGEL_MEDIA_OBJECT_DUMMY_PROPERTY
};
static void rygel_media_object_finalize (RygelMediaObject* obj);
enum  {
	RYGEL_TRANSCODER_DUMMY_PROPERTY
};
static void rygel_transcoder_finalize (RygelTranscoder* obj);


GQuark rygel_test_error_quark (void) {
	return g_quark_from_static_string ("rygel_test_error-quark");
}


gint rygel_http_get_test_main (gchar** args, int args_length1) {
	gint result = 0;
	RygelHTTPGetTest* _tmp0_ = NULL;
	RygelHTTPGetTest* test;
	GError * _inner_error_ = NULL;
	_tmp0_ = rygel_http_get_test_new (&_inner_error_);
	test = _tmp0_;
	if (_inner_error_ != NULL) {
		if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
			goto __catch0_rygel_test_error_skip;
		}
		goto __catch0_g_error;
	}
	rygel_http_get_test_run (test, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (test);
		if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
			goto __catch0_rygel_test_error_skip;
		}
		goto __catch0_g_error;
	}
	_g_object_unref0 (test);
	goto __finally0;
	__catch0_rygel_test_error_skip:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		result = _error_->code;
		_g_error_free0 (_error_);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("rygel-http-get-test.vala:51: %s", _error_->message);
		result = -1;
		_g_error_free0 (_error_);
		return result;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_thread_init (NULL);
	g_type_init ();
	return rygel_http_get_test_main (argv, argc);
}


RygelHTTPGetTest* rygel_http_get_test_construct (GType object_type, GError** error) {
	RygelHTTPGetTest * self = NULL;
	RygelHTTPServer* _tmp0_ = NULL;
	RygelHTTPServer* _tmp1_;
	RygelHTTPServer* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	RygelHTTPClient* _tmp5_ = NULL;
	RygelHTTPClient* _tmp6_;
	GMainLoop* _tmp7_ = NULL;
	GMainLoop* _tmp8_;
	GError * _inner_error_ = NULL;
	self = (RygelHTTPGetTest*) g_object_new (object_type, NULL);
	_tmp0_ = rygel_http_server_new (&_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp2_ = _tmp1_;
	_g_object_unref0 (self->server);
	self->server = _tmp2_;
	_tmp3_ = rygel_http_server_get_uri (self->server);
	_tmp4_ = _tmp3_;
	_tmp5_ = rygel_http_client_new (self->server->context, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (self->client);
	self->client = _tmp6_;
	_g_free0 (_tmp4_);
	_tmp7_ = g_main_loop_new (NULL, FALSE);
	_tmp8_ = _tmp7_;
	_g_main_loop_unref0 (self->priv->main_loop);
	self->priv->main_loop = _tmp8_;
	return self;
}


RygelHTTPGetTest* rygel_http_get_test_new (GError** error) {
	return rygel_http_get_test_construct (RYGEL_TYPE_HTTP_GET_TEST, error);
}


static gboolean _rygel_http_get_test_on_timeout_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_http_get_test_on_timeout (self);
	return result;
}


static void _rygel_http_get_test_on_message_received_rygel_http_server_message_received (RygelHTTPServer* _sender, SoupMessage* message, gpointer self) {
	rygel_http_get_test_on_message_received (self, _sender, message);
}


static void _rygel_http_get_test_on_client_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self) {
	rygel_http_get_test_on_client_completed (self, _sender);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static void rygel_http_get_test_real_run (RygelHTTPGetTest* self, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 3, _rygel_http_get_test_on_timeout_gsource_func, g_object_ref (self), g_object_unref);
	g_signal_connect_object (self->server, "message-received", (GCallback) _rygel_http_get_test_on_message_received_rygel_http_server_message_received, self, 0);
	g_signal_connect_object ((RygelStateMachine*) self->client, "completed", (GCallback) _rygel_http_get_test_on_client_completed_rygel_state_machine_completed, self, 0);
	rygel_state_machine_run ((RygelStateMachine*) self->client, NULL, NULL);
	g_main_loop_run (self->priv->main_loop);
	if (self->priv->error != NULL) {
		GError* _tmp0_;
		_tmp0_ = _g_error_copy0 (self->priv->error);
		_inner_error_ = _tmp0_;
		g_propagate_error (error, _inner_error_);
		return;
	}
}


void rygel_http_get_test_run (RygelHTTPGetTest* self, GError** error) {
	RYGEL_HTTP_GET_TEST_GET_CLASS (self)->run (self, error);
}


static RygelHTTPRequest* rygel_http_get_test_create_request (RygelHTTPGetTest* self, SoupMessage* msg, GError** error) {
	RygelHTTPRequest* result = NULL;
	SoupServer* _tmp0_ = NULL;
	RygelHTTPGet* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (msg != NULL, NULL);
	_tmp0_ = gupnp_context_get_server (self->server->context);
	_tmp1_ = rygel_http_get_new (self->server, _tmp0_, msg);
	result = (RygelHTTPRequest*) _tmp1_;
	return result;
}


static void rygel_http_get_test_on_client_completed (RygelHTTPGetTest* self, RygelStateMachine* client) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (client != NULL);
	if (self->priv->server_done) {
		g_main_loop_quit (self->priv->main_loop);
	}
	self->priv->client_done = TRUE;
}


static void rygel_http_get_test_on_message_received (RygelHTTPGetTest* self, RygelHTTPServer* server, SoupMessage* msg) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (server != NULL);
	g_return_if_fail (msg != NULL);
	rygel_http_get_test_handle_client_message (self, msg, NULL, NULL);
}


static void rygel_http_get_test_handle_client_message_data_free (gpointer _data) {
	RygelHttpGetTestHandleClientMessageData* data;
	data = _data;
	_g_object_unref0 (data->msg);
	_g_object_unref0 (data->self);
	g_slice_free (RygelHttpGetTestHandleClientMessageData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_http_get_test_handle_client_message (RygelHTTPGetTest* self, SoupMessage* msg, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHttpGetTestHandleClientMessageData* _data_;
	_data_ = g_slice_new0 (RygelHttpGetTestHandleClientMessageData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_get_test_handle_client_message);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_get_test_handle_client_message_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->msg = _g_object_ref0 (msg);
	rygel_http_get_test_handle_client_message_co (_data_);
}


static void rygel_http_get_test_handle_client_message_finish (RygelHTTPGetTest* self, GAsyncResult* _res_) {
	RygelHttpGetTestHandleClientMessageData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_http_get_test_handle_client_message_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpGetTestHandleClientMessageData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_http_get_test_handle_client_message_co (data);
}


static gboolean rygel_http_get_test_handle_client_message_co (RygelHttpGetTestHandleClientMessageData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = rygel_http_get_test_create_request (data->self, data->msg, &data->_inner_error_);
	data->request = data->_tmp0_;
	if (data->_inner_error_ != NULL) {
		goto __catch1_g_error;
	}
	data->_state_ = 1;
	rygel_state_machine_run ((RygelStateMachine*) data->request, rygel_http_get_test_handle_client_message_ready, data);
	return FALSE;
	_state_1:
	rygel_state_machine_run_finish ((RygelStateMachine*) data->request, data->_res_);
	g_assert (((RygelHTTPRequest*) (data->_tmp1_ = data->request, RYGEL_IS_HTTP_GET (data->_tmp1_) ? ((RygelHTTPGet*) data->_tmp1_) : NULL))->item != NULL);
	if (data->self->priv->client_done) {
		g_main_loop_quit (data->self->priv->main_loop);
	}
	data->self->priv->server_done = TRUE;
	_g_object_unref0 (data->request);
	goto __finally1;
	__catch1_g_error:
	{
		data->_error_ = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp2_ = _g_error_copy0 (data->_error_);
		data->_tmp3_ = data->_tmp2_;
		_g_error_free0 (data->self->priv->error);
		data->self->priv->error = data->_tmp3_;
		g_main_loop_quit (data->self->priv->main_loop);
		_g_error_free0 (data->_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	__finally1:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static gboolean rygel_http_get_test_on_timeout (RygelHTTPGetTest* self) {
	gboolean result = FALSE;
	GError* _tmp0_ = NULL;
	GError* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_error_new_literal (RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_TIMEOUT, "Timeout");
	_tmp1_ = _tmp0_;
	_g_error_free0 (self->priv->error);
	self->priv->error = _tmp1_;
	g_main_loop_quit (self->priv->main_loop);
	result = FALSE;
	return result;
}


static void rygel_http_get_test_class_init (RygelHTTPGetTestClass * klass) {
	rygel_http_get_test_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPGetTestPrivate));
	RYGEL_HTTP_GET_TEST_CLASS (klass)->run = rygel_http_get_test_real_run;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_get_test_finalize;
}


static void rygel_http_get_test_instance_init (RygelHTTPGetTest * self) {
	self->priv = RYGEL_HTTP_GET_TEST_GET_PRIVATE (self);
}


static void rygel_http_get_test_finalize (GObject* obj) {
	RygelHTTPGetTest * self;
	self = RYGEL_HTTP_GET_TEST (obj);
	_g_object_unref0 (self->server);
	_g_object_unref0 (self->client);
	_g_main_loop_unref0 (self->priv->main_loop);
	_g_error_free0 (self->priv->error);
	G_OBJECT_CLASS (rygel_http_get_test_parent_class)->finalize (obj);
}


GType rygel_http_get_test_get_type (void) {
	static volatile gsize rygel_http_get_test_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_get_test_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPGetTestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_get_test_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPGetTest), 0, (GInstanceInitFunc) rygel_http_get_test_instance_init, NULL };
		GType rygel_http_get_test_type_id;
		rygel_http_get_test_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPGetTest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_get_test_type_id__volatile, rygel_http_get_test_type_id);
	}
	return rygel_http_get_test_type_id__volatile;
}


static void _rygel_http_server_server_cb_soup_server_callback (SoupServer* server, SoupMessage* msg, const gchar* path, GHashTable* query, SoupClientContext* client, gpointer self) {
	rygel_http_server_server_cb (self, server, msg, path, query, client);
}


RygelHTTPServer* rygel_http_server_construct (GType object_type, GError** error) {
	RygelHTTPServer * self = NULL;
	GUPnPContext* _tmp0_ = NULL;
	GUPnPContext* _tmp1_;
	GUPnPContext* _tmp2_;
	const gchar* _tmp4_ = NULL;
	guint _tmp5_;
	SoupServer* _tmp6_ = NULL;
	RygelMediaContainer* _tmp7_ = NULL;
	RygelMediaContainer* _tmp8_;
	GError * _inner_error_ = NULL;
	self = (RygelHTTPServer*) g_object_new (object_type, NULL);
	_tmp0_ = gupnp_context_new (NULL, "lo", (guint) 0, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch2_g_error;
	}
	_tmp2_ = _tmp1_;
	_g_object_unref0 (self->context);
	self->context = _tmp2_;
	goto __finally2;
	__catch2_g_error:
	{
		GError * _error_;
		GError* _tmp3_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = g_error_new_literal (RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP, "Network context not available");
		_inner_error_ = _tmp3_;
		_g_error_free0 (_error_);
		goto __finally2;
	}
	__finally2:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_TEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	g_assert (self->context != NULL);
	_tmp4_ = gssdp_client_get_host_ip ((GSSDPClient*) self->context);
	g_assert (_tmp4_ != NULL);
	_tmp5_ = gupnp_context_get_port (self->context);
	g_assert (_tmp5_ > 0);
	_tmp6_ = gupnp_context_get_server (self->context);
	soup_server_add_handler (_tmp6_, RYGEL_HTTP_SERVER_SERVER_PATH, _rygel_http_server_server_cb_soup_server_callback, g_object_ref (self), g_object_unref);
	_tmp7_ = rygel_media_container_new ();
	_tmp8_ = _tmp7_;
	_rygel_media_object_unref0 (self->root_container);
	self->root_container = _tmp8_;
	return self;
}


RygelHTTPServer* rygel_http_server_new (GError** error) {
	return rygel_http_server_construct (RYGEL_TYPE_HTTP_SERVER, error);
}


static void rygel_http_server_server_cb (RygelHTTPServer* self, SoupServer* server, SoupMessage* msg, const gchar* path, GHashTable* query, SoupClientContext* client) {
	SoupServer* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (server != NULL);
	g_return_if_fail (msg != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (client != NULL);
	_tmp0_ = gupnp_context_get_server (self->context);
	soup_server_pause_message (_tmp0_, msg);
	g_signal_emit_by_name (self, "message-received", msg);
}


RygelTranscoder* rygel_http_server_get_transcoder (RygelHTTPServer* self, const gchar* target, GError** error) {
	RygelTranscoder* result = NULL;
	RygelTranscoder* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (target != NULL, NULL);
	_tmp0_ = rygel_transcoder_new ();
	result = _tmp0_;
	return result;
}


const gchar* rygel_http_server_get_path_root (RygelHTTPServer* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = RYGEL_HTTP_SERVER_SERVER_PATH;
	return result;
}


gchar* rygel_http_server_get_uri (RygelHTTPServer* self) {
	gchar* result;
	RygelHTTPItemURI* _tmp0_ = NULL;
	RygelHTTPItemURI* item_uri;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = rygel_http_item_uri_new (RYGEL_MEDIA_CONTAINER_ITEM_ID, self, -1, -1, NULL);
	item_uri = _tmp0_;
	_tmp1_ = rygel_http_item_uri_to_string (item_uri);
	result = _tmp1_;
	_g_object_unref0 (item_uri);
	return result;
}


static void rygel_http_server_class_init (RygelHTTPServerClass * klass) {
	rygel_http_server_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_server_get_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_server_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SERVER_PATH_ROOT, g_param_spec_string ("path-root", "path-root", "path-root", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SERVER_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("message_received", RYGEL_TYPE_HTTP_SERVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, SOUP_TYPE_MESSAGE);
}


static void rygel_http_server_instance_init (RygelHTTPServer * self) {
}


static void rygel_http_server_finalize (GObject* obj) {
	RygelHTTPServer * self;
	self = RYGEL_HTTP_SERVER (obj);
	_rygel_media_object_unref0 (self->root_container);
	_g_object_unref0 (self->context);
	G_OBJECT_CLASS (rygel_http_server_parent_class)->finalize (obj);
}


GType rygel_http_server_get_type (void) {
	static volatile gsize rygel_http_server_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_server_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPServerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_server_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPServer), 0, (GInstanceInitFunc) rygel_http_server_instance_init, NULL };
		GType rygel_http_server_type_id;
		rygel_http_server_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPServer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_server_type_id__volatile, rygel_http_server_type_id);
	}
	return rygel_http_server_type_id__volatile;
}


static void _vala_rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPServer * self;
	self = RYGEL_HTTP_SERVER (object);
	switch (property_id) {
		case RYGEL_HTTP_SERVER_PATH_ROOT:
		g_value_set_string (value, rygel_http_server_get_path_root (self));
		break;
		case RYGEL_HTTP_SERVER_URI:
		g_value_take_string (value, rygel_http_server_get_uri (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


RygelHTTPClient* rygel_http_client_construct (GType object_type, GUPnPContext* context, const gchar* uri) {
	RygelHTTPClient * self = NULL;
	GUPnPContext* _tmp0_;
	GUPnPContext* _tmp1_;
	SoupMessage* _tmp2_ = NULL;
	SoupMessage* _tmp3_;
	g_return_val_if_fail (context != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	self = (RygelHTTPClient*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (context);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->context);
	self->context = _tmp1_;
	_tmp2_ = soup_message_new ("GET", uri);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->msg);
	self->msg = _tmp3_;
	g_assert (self->msg != NULL);
	return self;
}


RygelHTTPClient* rygel_http_client_new (GUPnPContext* context, const gchar* uri) {
	return rygel_http_client_construct (RYGEL_TYPE_HTTP_CLIENT, context, uri);
}


static void rygel_http_client_real_run_data_free (gpointer _data) {
	RygelHttpClientRunData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (RygelHttpClientRunData, data);
}


static void rygel_http_client_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPClient * self;
	RygelHttpClientRunData* _data_;
	self = (RygelHTTPClient*) base;
	_data_ = g_slice_new0 (RygelHttpClientRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_client_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_client_real_run_data_free);
	_data_->self = _g_object_ref0 (self);
	rygel_http_client_real_run_co (_data_);
}


static void rygel_http_client_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelHttpClientRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		(_data1_->run_continue_target_destroy_notify == NULL) ? NULL : (_data1_->run_continue_target_destroy_notify (_data1_->run_continue_target), NULL);
		_data1_->run_continue = NULL;
		_data1_->run_continue_target = NULL;
		_data1_->run_continue_target_destroy_notify = NULL;
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean _rygel_http_client_real_run_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_http_client_real_run_co (self);
	return result;
}


static void _lambda1_ (SoupSession* session, SoupMessage* msg, Block1Data* _data1_) {
	RygelHTTPClient * self;
	self = _data1_->self;
	g_return_if_fail (session != NULL);
	g_return_if_fail (msg != NULL);
	_data1_->run_continue (_data1_->run_continue_target);
}


static void __lambda1__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self) {
	_lambda1_ (session, msg, self);
}


static gboolean rygel_http_client_real_run_co (RygelHttpClientRunData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_data1_ = g_slice_new0 (Block1Data);
	data->_data1_->_ref_count_ = 1;
	data->_data1_->self = g_object_ref (data->self);
	data->_data1_->_async_data_ = data;
	data->_data1_->run_continue = _rygel_http_client_real_run_co_gsource_func;
	data->_data1_->run_continue_target = data;
	data->_data1_->run_continue_target_destroy_notify = NULL;
	data->_tmp0_ = NULL;
	data->_tmp0_ = gupnp_context_get_session (data->self->context);
	data->_tmp1_ = _g_object_ref0 (data->self->msg);
	soup_session_queue_message (data->_tmp0_, data->_tmp1_, __lambda1__soup_session_callback, data->_data1_);
	data->_state_ = 1;
	return FALSE;
	_state_1:
	;
	g_signal_emit_by_name ((RygelStateMachine*) data->self, "completed");
	block1_data_unref (data->_data1_);
	data->_data1_ = NULL;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static GCancellable* rygel_http_client_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelHTTPClient* self;
	self = (RygelHTTPClient*) base;
	result = self->priv->_cancellable;
	return result;
}


static void rygel_http_client_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelHTTPClient* self;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	self = (RygelHTTPClient*) base;
	_tmp0_ = _g_object_ref0 (value);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->_cancellable);
	self->priv->_cancellable = _tmp1_;
	g_object_notify ((GObject *) self, "cancellable");
}


static void rygel_http_client_class_init (RygelHTTPClientClass * klass) {
	rygel_http_client_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPClientPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_client_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_client_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_client_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_CLIENT_CANCELLABLE, "cancellable");
}


static void rygel_http_client_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
	rygel_http_client_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = (void (*)(RygelStateMachine*)) rygel_http_client_real_run;
	iface->run_finish = rygel_http_client_real_run_finish;
	iface->get_cancellable = rygel_http_client_real_get_cancellable;
	iface->set_cancellable = rygel_http_client_real_set_cancellable;
}


static void rygel_http_client_instance_init (RygelHTTPClient * self) {
	self->priv = RYGEL_HTTP_CLIENT_GET_PRIVATE (self);
}


static void rygel_http_client_finalize (GObject* obj) {
	RygelHTTPClient * self;
	self = RYGEL_HTTP_CLIENT (obj);
	_g_object_unref0 (self->context);
	_g_object_unref0 (self->msg);
	_g_object_unref0 (self->priv->_cancellable);
	G_OBJECT_CLASS (rygel_http_client_parent_class)->finalize (obj);
}


GType rygel_http_client_get_type (void) {
	static volatile gsize rygel_http_client_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_client_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPClientClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_client_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPClient), 0, (GInstanceInitFunc) rygel_http_client_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_http_client_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_http_client_type_id;
		rygel_http_client_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPClient", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_http_client_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_http_client_type_id__volatile, rygel_http_client_type_id);
	}
	return rygel_http_client_type_id__volatile;
}


static void _vala_rygel_http_client_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPClient * self;
	self = RYGEL_HTTP_CLIENT (object);
	switch (property_id) {
		case RYGEL_HTTP_CLIENT_CANCELLABLE:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_http_client_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPClient * self;
	self = RYGEL_HTTP_CLIENT (object);
	switch (property_id) {
		case RYGEL_HTTP_CLIENT_CANCELLABLE:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void rygel_media_container_find_object_data_free (gpointer _data) {
	RygelMediaContainerFindObjectData* data;
	data = _data;
	_g_free0 (data->item_id);
	_g_object_unref0 (data->cancellable);
	_rygel_media_object_unref0 (data->result);
	_rygel_media_object_unref0 (data->self);
	g_slice_free (RygelMediaContainerFindObjectData, data);
}


static gpointer _rygel_media_object_ref0 (gpointer self) {
	return self ? rygel_media_object_ref (self) : NULL;
}


void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* item_id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaContainerFindObjectData* _data_;
	_data_ = g_slice_new0 (RygelMediaContainerFindObjectData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, rygel_media_container_find_object);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_container_find_object_data_free);
	_data_->self = _rygel_media_object_ref0 (self);
	_data_->item_id = g_strdup (item_id);
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_media_container_find_object_co (_data_);
}


RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelMediaContainerFindObjectData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_rygel_media_object_unref0 (_data2_->self);
		(_data2_->find_object_continue_target_destroy_notify == NULL) ? NULL : (_data2_->find_object_continue_target_destroy_notify (_data2_->find_object_continue_target), NULL);
		_data2_->find_object_continue = NULL;
		_data2_->find_object_continue_target = NULL;
		_data2_->find_object_continue_target_destroy_notify = NULL;
		g_slice_free (Block2Data, _data2_);
	}
}


static gboolean _rygel_media_container_find_object_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_media_container_find_object_co (self);
	return result;
}


static gboolean _lambda0_ (Block2Data* _data2_) {
	RygelMediaContainer * self;
	gboolean result = FALSE;
	self = _data2_->self;
	_data2_->find_object_continue (_data2_->find_object_continue_target);
	result = FALSE;
	return result;
}


static gboolean __lambda0__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda0_ (self);
	return result;
}


static gboolean rygel_media_container_find_object_co (RygelMediaContainerFindObjectData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_data2_ = g_slice_new0 (Block2Data);
	data->_data2_->_ref_count_ = 1;
	data->_data2_->self = rygel_media_object_ref (data->self);
	data->_data2_->_async_data_ = data;
	data->_data2_->find_object_continue = _rygel_media_container_find_object_co_gsource_func;
	data->_data2_->find_object_continue_target = data;
	data->_data2_->find_object_continue_target_destroy_notify = NULL;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda0__gsource_func, block2_data_ref (data->_data2_), block2_data_unref);
	data->_state_ = 1;
	return FALSE;
	_state_1:
	;
	if (g_strcmp0 (data->item_id, RYGEL_MEDIA_CONTAINER_ITEM_ID) == 0) {
		data->_tmp0_ = NULL;
		data->_tmp0_ = rygel_video_item_new ();
		data->result = (RygelMediaObject*) data->_tmp0_;
		block2_data_unref (data->_data2_);
		data->_data2_ = NULL;
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	} else {
		data->result = NULL;
		block2_data_unref (data->_data2_);
		data->_data2_ = NULL;
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	block2_data_unref (data->_data2_);
	data->_data2_ = NULL;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


RygelMediaContainer* rygel_media_container_construct (GType object_type) {
	RygelMediaContainer* self = NULL;
	self = (RygelMediaContainer*) rygel_media_object_construct (object_type);
	return self;
}


RygelMediaContainer* rygel_media_container_new (void) {
	return rygel_media_container_construct (RYGEL_TYPE_MEDIA_CONTAINER);
}


static void rygel_media_container_class_init (RygelMediaContainerClass * klass) {
	rygel_media_container_parent_class = g_type_class_peek_parent (klass);
}


static void rygel_media_container_instance_init (RygelMediaContainer * self) {
}


GType rygel_media_container_get_type (void) {
	static volatile gsize rygel_media_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaContainer), 0, (GInstanceInitFunc) rygel_media_container_instance_init, NULL };
		GType rygel_media_container_type_id;
		rygel_media_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaContainer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_container_type_id__volatile, rygel_media_container_type_id);
	}
	return rygel_media_container_type_id__volatile;
}


RygelHTTPResponse* rygel_http_get_handler_render_body (RygelHTTPGetHandler* self, RygelHTTPGet* get_request) {
	RygelHTTPResponse* result = NULL;
	RygelHTTPResponse* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (get_request != NULL, NULL);
	_tmp0_ = rygel_http_response_new (get_request);
	result = _tmp0_;
	return result;
}


void rygel_http_get_handler_add_response_headers (RygelHTTPGetHandler* self, RygelHTTPGet* get_request) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (get_request != NULL);
}


RygelHTTPGetHandler* rygel_http_get_handler_construct (GType object_type) {
	RygelHTTPGetHandler* self = NULL;
	self = (RygelHTTPGetHandler*) g_type_create_instance (object_type);
	return self;
}


static void rygel_value_http_get_handler_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_value_http_get_handler_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_http_get_handler_unref (value->data[0].v_pointer);
	}
}


static void rygel_value_http_get_handler_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_http_get_handler_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_value_http_get_handler_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_value_http_get_handler_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelHTTPGetHandler* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_http_get_handler_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_value_http_get_handler_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelHTTPGetHandler** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_http_get_handler_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_param_spec_http_get_handler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecHTTPGetHandler* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_HTTP_GET_HANDLER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_value_get_http_get_handler (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_HTTP_GET_HANDLER), NULL);
	return value->data[0].v_pointer;
}


void rygel_value_set_http_get_handler (GValue* value, gpointer v_object) {
	RygelHTTPGetHandler* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_HTTP_GET_HANDLER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_HTTP_GET_HANDLER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_http_get_handler_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_http_get_handler_unref (old);
	}
}


void rygel_value_take_http_get_handler (GValue* value, gpointer v_object) {
	RygelHTTPGetHandler* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_HTTP_GET_HANDLER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_HTTP_GET_HANDLER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_http_get_handler_unref (old);
	}
}


static void rygel_http_get_handler_class_init (RygelHTTPGetHandlerClass * klass) {
	rygel_http_get_handler_parent_class = g_type_class_peek_parent (klass);
	RYGEL_HTTP_GET_HANDLER_CLASS (klass)->finalize = rygel_http_get_handler_finalize;
}


static void rygel_http_get_handler_instance_init (RygelHTTPGetHandler * self) {
	self->ref_count = 1;
}


static void rygel_http_get_handler_finalize (RygelHTTPGetHandler* obj) {
	RygelHTTPGetHandler * self;
	self = RYGEL_HTTP_GET_HANDLER (obj);
}


GType rygel_http_get_handler_get_type (void) {
	static volatile gsize rygel_http_get_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_get_handler_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_http_get_handler_init, rygel_value_http_get_handler_free_value, rygel_value_http_get_handler_copy_value, rygel_value_http_get_handler_peek_pointer, "p", rygel_value_http_get_handler_collect_value, "p", rygel_value_http_get_handler_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPGetHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_get_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPGetHandler), 0, (GInstanceInitFunc) rygel_http_get_handler_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_http_get_handler_type_id;
		rygel_http_get_handler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelHTTPGetHandler", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_http_get_handler_type_id__volatile, rygel_http_get_handler_type_id);
	}
	return rygel_http_get_handler_type_id__volatile;
}


gpointer rygel_http_get_handler_ref (gpointer instance) {
	RygelHTTPGetHandler* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_http_get_handler_unref (gpointer instance) {
	RygelHTTPGetHandler* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_HTTP_GET_HANDLER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


RygelHTTPTranscodeHandler* rygel_http_transcode_handler_construct (GType object_type, RygelTranscoder* transcoder, GCancellable* cancellable) {
	RygelHTTPTranscodeHandler* self = NULL;
	g_return_val_if_fail (transcoder != NULL, NULL);
	g_return_val_if_fail (cancellable != NULL, NULL);
	self = (RygelHTTPTranscodeHandler*) rygel_http_get_handler_construct (object_type);
	return self;
}


RygelHTTPTranscodeHandler* rygel_http_transcode_handler_new (RygelTranscoder* transcoder, GCancellable* cancellable) {
	return rygel_http_transcode_handler_construct (RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, transcoder, cancellable);
}


static void rygel_http_transcode_handler_class_init (RygelHTTPTranscodeHandlerClass * klass) {
	rygel_http_transcode_handler_parent_class = g_type_class_peek_parent (klass);
}


static void rygel_http_transcode_handler_instance_init (RygelHTTPTranscodeHandler * self) {
}


GType rygel_http_transcode_handler_get_type (void) {
	static volatile gsize rygel_http_transcode_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_transcode_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPTranscodeHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_transcode_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPTranscodeHandler), 0, (GInstanceInitFunc) rygel_http_transcode_handler_instance_init, NULL };
		GType rygel_http_transcode_handler_type_id;
		rygel_http_transcode_handler_type_id = g_type_register_static (RYGEL_TYPE_HTTP_GET_HANDLER, "RygelHTTPTranscodeHandler", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_transcode_handler_type_id__volatile, rygel_http_transcode_handler_type_id);
	}
	return rygel_http_transcode_handler_type_id__volatile;
}


RygelHTTPIdentityHandler* rygel_http_identity_handler_construct (GType object_type, GCancellable* cancellable) {
	RygelHTTPIdentityHandler* self = NULL;
	g_return_val_if_fail (cancellable != NULL, NULL);
	self = (RygelHTTPIdentityHandler*) rygel_http_get_handler_construct (object_type);
	return self;
}


RygelHTTPIdentityHandler* rygel_http_identity_handler_new (GCancellable* cancellable) {
	return rygel_http_identity_handler_construct (RYGEL_TYPE_HTTP_IDENTITY_HANDLER, cancellable);
}


static void rygel_http_identity_handler_class_init (RygelHTTPIdentityHandlerClass * klass) {
	rygel_http_identity_handler_parent_class = g_type_class_peek_parent (klass);
}


static void rygel_http_identity_handler_instance_init (RygelHTTPIdentityHandler * self) {
}


GType rygel_http_identity_handler_get_type (void) {
	static volatile gsize rygel_http_identity_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_identity_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPIdentityHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_identity_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPIdentityHandler), 0, (GInstanceInitFunc) rygel_http_identity_handler_instance_init, NULL };
		GType rygel_http_identity_handler_type_id;
		rygel_http_identity_handler_type_id = g_type_register_static (RYGEL_TYPE_HTTP_GET_HANDLER, "RygelHTTPIdentityHandler", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_identity_handler_type_id__volatile, rygel_http_identity_handler_type_id);
	}
	return rygel_http_identity_handler_type_id__volatile;
}


gboolean rygel_media_item_should_stream (RygelMediaItem* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = TRUE;
	return result;
}


gboolean rygel_media_item_streamable (RygelMediaItem* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = TRUE;
	return result;
}


RygelMediaItem* rygel_media_item_construct (GType object_type) {
	RygelMediaItem* self = NULL;
	self = (RygelMediaItem*) rygel_media_object_construct (object_type);
	return self;
}


static void rygel_media_item_class_init (RygelMediaItemClass * klass) {
	rygel_media_item_parent_class = g_type_class_peek_parent (klass);
	RYGEL_MEDIA_OBJECT_CLASS (klass)->finalize = rygel_media_item_finalize;
}


static void rygel_media_item_instance_init (RygelMediaItem * self) {
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
	self->size = (glong) 1024;
	_tmp0_ = gee_array_list_new (RYGEL_TYPE_SUBTITLE, (GBoxedCopyFunc) rygel_subtitle_ref, rygel_subtitle_unref, NULL);
	self->subtitles = _tmp0_;
	_tmp1_ = gee_array_list_new (RYGEL_TYPE_THUMBNAIL, (GBoxedCopyFunc) rygel_thumbnail_ref, rygel_thumbnail_unref, NULL);
	self->thumbnails = _tmp1_;
}


static void rygel_media_item_finalize (RygelMediaObject* obj) {
	RygelMediaItem * self;
	self = RYGEL_MEDIA_ITEM (obj);
	_g_object_unref0 (self->subtitles);
	_g_object_unref0 (self->thumbnails);
	RYGEL_MEDIA_OBJECT_CLASS (rygel_media_item_parent_class)->finalize (obj);
}


GType rygel_media_item_get_type (void) {
	static volatile gsize rygel_media_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaItem), 0, (GInstanceInitFunc) rygel_media_item_instance_init, NULL };
		GType rygel_media_item_type_id;
		rygel_media_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaItem", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_media_item_type_id__volatile, rygel_media_item_type_id);
	}
	return rygel_media_item_type_id__volatile;
}


RygelAudioItem* rygel_audio_item_construct (GType object_type) {
	RygelAudioItem* self = NULL;
	self = (RygelAudioItem*) rygel_media_item_construct (object_type);
	return self;
}


RygelAudioItem* rygel_audio_item_new (void) {
	return rygel_audio_item_construct (RYGEL_TYPE_AUDIO_ITEM);
}


static void rygel_audio_item_class_init (RygelAudioItemClass * klass) {
	rygel_audio_item_parent_class = g_type_class_peek_parent (klass);
	RYGEL_MEDIA_OBJECT_CLASS (klass)->finalize = rygel_audio_item_finalize;
}


static void rygel_audio_item_instance_init (RygelAudioItem * self) {
	self->duration = (gint64) 2048;
}


static void rygel_audio_item_finalize (RygelMediaObject* obj) {
	RygelAudioItem * self;
	self = RYGEL_AUDIO_ITEM (obj);
	RYGEL_MEDIA_OBJECT_CLASS (rygel_audio_item_parent_class)->finalize (obj);
}


GType rygel_audio_item_get_type (void) {
	static volatile gsize rygel_audio_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_audio_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelAudioItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_audio_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelAudioItem), 0, (GInstanceInitFunc) rygel_audio_item_instance_init, NULL };
		GType rygel_audio_item_type_id;
		rygel_audio_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_ITEM, "RygelAudioItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_audio_item_type_id__volatile, rygel_audio_item_type_id);
	}
	return rygel_audio_item_type_id__volatile;
}


gint rygel_visual_item_get_width (RygelVisualItem* self) {
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_width (self);
}


void rygel_visual_item_set_width (RygelVisualItem* self, gint value) {
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_width (self, value);
}


gint rygel_visual_item_get_height (RygelVisualItem* self) {
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_height (self);
}


void rygel_visual_item_set_height (RygelVisualItem* self, gint value) {
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_height (self, value);
}


gint rygel_visual_item_get_pixel_width (RygelVisualItem* self) {
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_pixel_width (self);
}


void rygel_visual_item_set_pixel_width (RygelVisualItem* self, gint value) {
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_pixel_width (self, value);
}


gint rygel_visual_item_get_pixel_height (RygelVisualItem* self) {
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_pixel_height (self);
}


void rygel_visual_item_set_pixel_height (RygelVisualItem* self, gint value) {
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_pixel_height (self, value);
}


gint rygel_visual_item_get_color_depth (RygelVisualItem* self) {
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_color_depth (self);
}


void rygel_visual_item_set_color_depth (RygelVisualItem* self, gint value) {
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_color_depth (self, value);
}


GeeArrayList* rygel_visual_item_get_thumbnails (RygelVisualItem* self) {
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_thumbnails (self);
}


void rygel_visual_item_set_thumbnails (RygelVisualItem* self, GeeArrayList* value) {
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_thumbnails (self, value);
}


static void rygel_visual_item_base_init (RygelVisualItemIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType rygel_visual_item_get_type (void) {
	static volatile gsize rygel_visual_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_visual_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelVisualItemIface), (GBaseInitFunc) rygel_visual_item_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType rygel_visual_item_type_id;
		rygel_visual_item_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelVisualItem", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (rygel_visual_item_type_id, RYGEL_TYPE_MEDIA_ITEM);
		g_once_init_leave (&rygel_visual_item_type_id__volatile, rygel_visual_item_type_id);
	}
	return rygel_visual_item_type_id__volatile;
}


RygelVideoItem* rygel_video_item_construct (GType object_type) {
	RygelVideoItem* self = NULL;
	self = (RygelVideoItem*) rygel_audio_item_construct (object_type);
	return self;
}


RygelVideoItem* rygel_video_item_new (void) {
	return rygel_video_item_construct (RYGEL_TYPE_VIDEO_ITEM);
}


static gint rygel_video_item_real_get_width (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	self = (RygelVideoItem*) base;
	result = self->priv->_width;
	return result;
}


static void rygel_video_item_real_set_width (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	self = (RygelVideoItem*) base;
	self->priv->_width = value;
}


static gint rygel_video_item_real_get_height (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	self = (RygelVideoItem*) base;
	result = self->priv->_height;
	return result;
}


static void rygel_video_item_real_set_height (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	self = (RygelVideoItem*) base;
	self->priv->_height = value;
}


static gint rygel_video_item_real_get_pixel_width (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	self = (RygelVideoItem*) base;
	result = self->priv->_pixel_width;
	return result;
}


static void rygel_video_item_real_set_pixel_width (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	self = (RygelVideoItem*) base;
	self->priv->_pixel_width = value;
}


static gint rygel_video_item_real_get_pixel_height (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	self = (RygelVideoItem*) base;
	result = self->priv->_pixel_height;
	return result;
}


static void rygel_video_item_real_set_pixel_height (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	self = (RygelVideoItem*) base;
	self->priv->_pixel_height = value;
}


static gint rygel_video_item_real_get_color_depth (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	self = (RygelVideoItem*) base;
	result = self->priv->_color_depth;
	return result;
}


static void rygel_video_item_real_set_color_depth (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	self = (RygelVideoItem*) base;
	self->priv->_color_depth = value;
}


static GeeArrayList* rygel_video_item_real_get_thumbnails (RygelVisualItem* base) {
	GeeArrayList* result;
	RygelVideoItem* self;
	self = (RygelVideoItem*) base;
	result = self->priv->_thumbnails;
	return result;
}


static void rygel_video_item_real_set_thumbnails (RygelVisualItem* base, GeeArrayList* value) {
	RygelVideoItem* self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	self = (RygelVideoItem*) base;
	_tmp0_ = _g_object_ref0 (value);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->_thumbnails);
	self->priv->_thumbnails = _tmp1_;
}


static void rygel_video_item_class_init (RygelVideoItemClass * klass) {
	rygel_video_item_parent_class = g_type_class_peek_parent (klass);
	RYGEL_MEDIA_OBJECT_CLASS (klass)->finalize = rygel_video_item_finalize;
	g_type_class_add_private (klass, sizeof (RygelVideoItemPrivate));
}


static void rygel_video_item_rygel_visual_item_interface_init (RygelVisualItemIface * iface) {
	rygel_video_item_rygel_visual_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_width = rygel_video_item_real_get_width;
	iface->set_width = rygel_video_item_real_set_width;
	iface->get_height = rygel_video_item_real_get_height;
	iface->set_height = rygel_video_item_real_set_height;
	iface->get_pixel_width = rygel_video_item_real_get_pixel_width;
	iface->set_pixel_width = rygel_video_item_real_set_pixel_width;
	iface->get_pixel_height = rygel_video_item_real_get_pixel_height;
	iface->set_pixel_height = rygel_video_item_real_set_pixel_height;
	iface->get_color_depth = rygel_video_item_real_get_color_depth;
	iface->set_color_depth = rygel_video_item_real_set_color_depth;
	iface->get_thumbnails = rygel_video_item_real_get_thumbnails;
	iface->set_thumbnails = rygel_video_item_real_set_thumbnails;
}


static void rygel_video_item_instance_init (RygelVideoItem * self) {
	self->priv = RYGEL_VIDEO_ITEM_GET_PRIVATE (self);
	self->priv->_width = -1;
	self->priv->_height = -1;
	self->priv->_pixel_width = -1;
	self->priv->_pixel_height = -1;
	self->priv->_color_depth = -1;
}


static void rygel_video_item_finalize (RygelMediaObject* obj) {
	RygelVideoItem * self;
	self = RYGEL_VIDEO_ITEM (obj);
	_g_object_unref0 (self->priv->_thumbnails);
	_g_object_unref0 (self->subtitles);
	RYGEL_MEDIA_OBJECT_CLASS (rygel_video_item_parent_class)->finalize (obj);
}


GType rygel_video_item_get_type (void) {
	static volatile gsize rygel_video_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_video_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelVideoItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_video_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelVideoItem), 0, (GInstanceInitFunc) rygel_video_item_instance_init, NULL };
		static const GInterfaceInfo rygel_visual_item_info = { (GInterfaceInitFunc) rygel_video_item_rygel_visual_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_video_item_type_id;
		rygel_video_item_type_id = g_type_register_static (RYGEL_TYPE_AUDIO_ITEM, "RygelVideoItem", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_video_item_type_id, RYGEL_TYPE_VISUAL_ITEM, &rygel_visual_item_info);
		g_once_init_leave (&rygel_video_item_type_id__volatile, rygel_video_item_type_id);
	}
	return rygel_video_item_type_id__volatile;
}


RygelMusicItem* rygel_music_item_construct (GType object_type) {
	RygelMusicItem* self = NULL;
	self = (RygelMusicItem*) rygel_audio_item_construct (object_type);
	return self;
}


RygelMusicItem* rygel_music_item_new (void) {
	return rygel_music_item_construct (RYGEL_TYPE_MUSIC_ITEM);
}


static void rygel_music_item_class_init (RygelMusicItemClass * klass) {
	rygel_music_item_parent_class = g_type_class_peek_parent (klass);
	RYGEL_MEDIA_OBJECT_CLASS (klass)->finalize = rygel_music_item_finalize;
}


static void rygel_music_item_instance_init (RygelMusicItem * self) {
}


static void rygel_music_item_finalize (RygelMediaObject* obj) {
	RygelMusicItem * self;
	self = RYGEL_MUSIC_ITEM (obj);
	_rygel_thumbnail_unref0 (self->album_art);
	RYGEL_MEDIA_OBJECT_CLASS (rygel_music_item_parent_class)->finalize (obj);
}


GType rygel_music_item_get_type (void) {
	static volatile gsize rygel_music_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_music_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMusicItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_music_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMusicItem), 0, (GInstanceInitFunc) rygel_music_item_instance_init, NULL };
		GType rygel_music_item_type_id;
		rygel_music_item_type_id = g_type_register_static (RYGEL_TYPE_AUDIO_ITEM, "RygelMusicItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_music_item_type_id__volatile, rygel_music_item_type_id);
	}
	return rygel_music_item_type_id__volatile;
}


RygelThumbnail* rygel_thumbnail_construct (GType object_type) {
	RygelThumbnail* self = NULL;
	self = (RygelThumbnail*) g_type_create_instance (object_type);
	return self;
}


RygelThumbnail* rygel_thumbnail_new (void) {
	return rygel_thumbnail_construct (RYGEL_TYPE_THUMBNAIL);
}


static void rygel_value_thumbnail_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_value_thumbnail_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_thumbnail_unref (value->data[0].v_pointer);
	}
}


static void rygel_value_thumbnail_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_thumbnail_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_value_thumbnail_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_value_thumbnail_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelThumbnail* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_thumbnail_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_value_thumbnail_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelThumbnail** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_thumbnail_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_param_spec_thumbnail (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecThumbnail* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_THUMBNAIL), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_value_get_thumbnail (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_THUMBNAIL), NULL);
	return value->data[0].v_pointer;
}


void rygel_value_set_thumbnail (GValue* value, gpointer v_object) {
	RygelThumbnail* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_THUMBNAIL));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_THUMBNAIL));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_thumbnail_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_thumbnail_unref (old);
	}
}


void rygel_value_take_thumbnail (GValue* value, gpointer v_object) {
	RygelThumbnail* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_THUMBNAIL));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_THUMBNAIL));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_thumbnail_unref (old);
	}
}


static void rygel_thumbnail_class_init (RygelThumbnailClass * klass) {
	rygel_thumbnail_parent_class = g_type_class_peek_parent (klass);
	RYGEL_THUMBNAIL_CLASS (klass)->finalize = rygel_thumbnail_finalize;
}


static void rygel_thumbnail_instance_init (RygelThumbnail * self) {
	self->size = (glong) 1024;
	self->ref_count = 1;
}


static void rygel_thumbnail_finalize (RygelThumbnail* obj) {
	RygelThumbnail * self;
	self = RYGEL_THUMBNAIL (obj);
}


GType rygel_thumbnail_get_type (void) {
	static volatile gsize rygel_thumbnail_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_thumbnail_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_thumbnail_init, rygel_value_thumbnail_free_value, rygel_value_thumbnail_copy_value, rygel_value_thumbnail_peek_pointer, "p", rygel_value_thumbnail_collect_value, "p", rygel_value_thumbnail_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelThumbnailClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_thumbnail_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelThumbnail), 0, (GInstanceInitFunc) rygel_thumbnail_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_thumbnail_type_id;
		rygel_thumbnail_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelThumbnail", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_thumbnail_type_id__volatile, rygel_thumbnail_type_id);
	}
	return rygel_thumbnail_type_id__volatile;
}


gpointer rygel_thumbnail_ref (gpointer instance) {
	RygelThumbnail* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_thumbnail_unref (gpointer instance) {
	RygelThumbnail* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_THUMBNAIL_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


RygelSubtitle* rygel_subtitle_construct (GType object_type) {
	RygelSubtitle* self = NULL;
	self = (RygelSubtitle*) g_type_create_instance (object_type);
	return self;
}


RygelSubtitle* rygel_subtitle_new (void) {
	return rygel_subtitle_construct (RYGEL_TYPE_SUBTITLE);
}


static void rygel_value_subtitle_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_value_subtitle_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_subtitle_unref (value->data[0].v_pointer);
	}
}


static void rygel_value_subtitle_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_subtitle_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_value_subtitle_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_value_subtitle_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelSubtitle* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_subtitle_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_value_subtitle_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelSubtitle** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_subtitle_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_param_spec_subtitle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecSubtitle* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_SUBTITLE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_value_get_subtitle (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_SUBTITLE), NULL);
	return value->data[0].v_pointer;
}


void rygel_value_set_subtitle (GValue* value, gpointer v_object) {
	RygelSubtitle* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_SUBTITLE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_SUBTITLE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_subtitle_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_subtitle_unref (old);
	}
}


void rygel_value_take_subtitle (GValue* value, gpointer v_object) {
	RygelSubtitle* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_SUBTITLE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_SUBTITLE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_subtitle_unref (old);
	}
}


static void rygel_subtitle_class_init (RygelSubtitleClass * klass) {
	rygel_subtitle_parent_class = g_type_class_peek_parent (klass);
	RYGEL_SUBTITLE_CLASS (klass)->finalize = rygel_subtitle_finalize;
}


static void rygel_subtitle_instance_init (RygelSubtitle * self) {
	self->size = (glong) 1024;
	self->ref_count = 1;
}


static void rygel_subtitle_finalize (RygelSubtitle* obj) {
	RygelSubtitle * self;
	self = RYGEL_SUBTITLE (obj);
}


GType rygel_subtitle_get_type (void) {
	static volatile gsize rygel_subtitle_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_subtitle_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_subtitle_init, rygel_value_subtitle_free_value, rygel_value_subtitle_copy_value, rygel_value_subtitle_peek_pointer, "p", rygel_value_subtitle_collect_value, "p", rygel_value_subtitle_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelSubtitleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_subtitle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSubtitle), 0, (GInstanceInitFunc) rygel_subtitle_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_subtitle_type_id;
		rygel_subtitle_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelSubtitle", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_subtitle_type_id__volatile, rygel_subtitle_type_id);
	}
	return rygel_subtitle_type_id__volatile;
}


gpointer rygel_subtitle_ref (gpointer instance) {
	RygelSubtitle* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_subtitle_unref (gpointer instance) {
	RygelSubtitle* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_SUBTITLE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


RygelHTTPResponse* rygel_http_response_construct (GType object_type, RygelHTTPGet* get_request) {
	RygelHTTPResponse * self = NULL;
	SoupMessage* _tmp0_;
	SoupMessage* _tmp1_;
	SoupServer* _tmp2_;
	SoupServer* _tmp3_;
	g_return_val_if_fail (get_request != NULL, NULL);
	self = (RygelHTTPResponse*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (((RygelHTTPRequest*) get_request)->msg);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->msg);
	self->priv->msg = _tmp1_;
	_tmp2_ = _g_object_ref0 (((RygelHTTPRequest*) get_request)->server);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->priv->server);
	self->priv->server = _tmp3_;
	return self;
}


RygelHTTPResponse* rygel_http_response_new (RygelHTTPGet* get_request) {
	return rygel_http_response_construct (RYGEL_TYPE_HTTP_RESPONSE, get_request);
}


static void rygel_http_response_real_run_data_free (gpointer _data) {
	RygelHttpResponseRunData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (RygelHttpResponseRunData, data);
}


static void rygel_http_response_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPResponse * self;
	RygelHttpResponseRunData* _data_;
	self = (RygelHTTPResponse*) base;
	_data_ = g_slice_new0 (RygelHttpResponseRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_response_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_response_real_run_data_free);
	_data_->self = _g_object_ref0 (self);
	rygel_http_response_real_run_co (_data_);
}


static void rygel_http_response_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelHttpResponseRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->self);
		(_data3_->run_continue_target_destroy_notify == NULL) ? NULL : (_data3_->run_continue_target_destroy_notify (_data3_->run_continue_target), NULL);
		_data3_->run_continue = NULL;
		_data3_->run_continue_target = NULL;
		_data3_->run_continue_target_destroy_notify = NULL;
		g_slice_free (Block3Data, _data3_);
	}
}


static gboolean _rygel_http_response_real_run_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_http_response_real_run_co (self);
	return result;
}


static gboolean _lambda2_ (Block3Data* _data3_) {
	RygelHTTPResponse * self;
	gboolean result = FALSE;
	self = _data3_->self;
	_data3_->run_continue (_data3_->run_continue_target);
	result = FALSE;
	return result;
}


static gboolean __lambda2__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda2_ (self);
	return result;
}


static gboolean rygel_http_response_real_run_co (RygelHttpResponseRunData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_data3_ = g_slice_new0 (Block3Data);
	data->_data3_->_ref_count_ = 1;
	data->_data3_->self = g_object_ref (data->self);
	data->_data3_->_async_data_ = data;
	data->_data3_->run_continue = _rygel_http_response_real_run_co_gsource_func;
	data->_data3_->run_continue_target = data;
	data->_data3_->run_continue_target_destroy_notify = NULL;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda2__gsource_func, block3_data_ref (data->_data3_), block3_data_unref);
	data->_state_ = 1;
	return FALSE;
	_state_1:
	;
	soup_message_set_status (data->self->priv->msg, (guint) SOUP_STATUS_OK);
	soup_server_unpause_message (data->self->priv->server, data->self->priv->msg);
	g_signal_emit_by_name ((RygelStateMachine*) data->self, "completed");
	block3_data_unref (data->_data3_);
	data->_data3_ = NULL;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static GCancellable* rygel_http_response_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelHTTPResponse* self;
	self = (RygelHTTPResponse*) base;
	result = self->priv->_cancellable;
	return result;
}


static void rygel_http_response_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelHTTPResponse* self;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	self = (RygelHTTPResponse*) base;
	_tmp0_ = _g_object_ref0 (value);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->_cancellable);
	self->priv->_cancellable = _tmp1_;
	g_object_notify ((GObject *) self, "cancellable");
}


static void rygel_http_response_class_init (RygelHTTPResponseClass * klass) {
	rygel_http_response_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPResponsePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_response_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_response_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_response_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_RESPONSE_CANCELLABLE, "cancellable");
}


static void rygel_http_response_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
	rygel_http_response_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = (void (*)(RygelStateMachine*)) rygel_http_response_real_run;
	iface->run_finish = rygel_http_response_real_run_finish;
	iface->get_cancellable = rygel_http_response_real_get_cancellable;
	iface->set_cancellable = rygel_http_response_real_set_cancellable;
}


static void rygel_http_response_instance_init (RygelHTTPResponse * self) {
	self->priv = RYGEL_HTTP_RESPONSE_GET_PRIVATE (self);
}


static void rygel_http_response_finalize (GObject* obj) {
	RygelHTTPResponse * self;
	self = RYGEL_HTTP_RESPONSE (obj);
	_g_object_unref0 (self->priv->_cancellable);
	_g_object_unref0 (self->priv->msg);
	_g_object_unref0 (self->priv->server);
	G_OBJECT_CLASS (rygel_http_response_parent_class)->finalize (obj);
}


GType rygel_http_response_get_type (void) {
	static volatile gsize rygel_http_response_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_response_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPResponseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_response_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPResponse), 0, (GInstanceInitFunc) rygel_http_response_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_http_response_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_http_response_type_id;
		rygel_http_response_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPResponse", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_http_response_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_http_response_type_id__volatile, rygel_http_response_type_id);
	}
	return rygel_http_response_type_id__volatile;
}


static void _vala_rygel_http_response_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPResponse * self;
	self = RYGEL_HTTP_RESPONSE (object);
	switch (property_id) {
		case RYGEL_HTTP_RESPONSE_CANCELLABLE:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_http_response_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPResponse * self;
	self = RYGEL_HTTP_RESPONSE (object);
	switch (property_id) {
		case RYGEL_HTTP_RESPONSE_CANCELLABLE:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


RygelMediaObject* rygel_media_object_construct (GType object_type) {
	RygelMediaObject* self = NULL;
	self = (RygelMediaObject*) g_type_create_instance (object_type);
	return self;
}


RygelMediaObject* rygel_media_object_new (void) {
	return rygel_media_object_construct (RYGEL_TYPE_MEDIA_OBJECT);
}


static void rygel_value_media_object_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_value_media_object_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_media_object_unref (value->data[0].v_pointer);
	}
}


static void rygel_value_media_object_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_media_object_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_value_media_object_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_value_media_object_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelMediaObject* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_media_object_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_value_media_object_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelMediaObject** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_media_object_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_param_spec_media_object (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecMediaObject* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_MEDIA_OBJECT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_value_get_media_object (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_MEDIA_OBJECT), NULL);
	return value->data[0].v_pointer;
}


void rygel_value_set_media_object (GValue* value, gpointer v_object) {
	RygelMediaObject* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_MEDIA_OBJECT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_MEDIA_OBJECT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_media_object_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_media_object_unref (old);
	}
}


void rygel_value_take_media_object (GValue* value, gpointer v_object) {
	RygelMediaObject* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_MEDIA_OBJECT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_MEDIA_OBJECT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_media_object_unref (old);
	}
}


static void rygel_media_object_class_init (RygelMediaObjectClass * klass) {
	rygel_media_object_parent_class = g_type_class_peek_parent (klass);
	RYGEL_MEDIA_OBJECT_CLASS (klass)->finalize = rygel_media_object_finalize;
}


static void rygel_media_object_instance_init (RygelMediaObject * self) {
	self->ref_count = 1;
}


static void rygel_media_object_finalize (RygelMediaObject* obj) {
	RygelMediaObject * self;
	self = RYGEL_MEDIA_OBJECT (obj);
	_g_free0 (self->id);
}


GType rygel_media_object_get_type (void) {
	static volatile gsize rygel_media_object_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_object_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_media_object_init, rygel_value_media_object_free_value, rygel_value_media_object_copy_value, rygel_value_media_object_peek_pointer, "p", rygel_value_media_object_collect_value, "p", rygel_value_media_object_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaObject), 0, (GInstanceInitFunc) rygel_media_object_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_media_object_type_id;
		rygel_media_object_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelMediaObject", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_media_object_type_id__volatile, rygel_media_object_type_id);
	}
	return rygel_media_object_type_id__volatile;
}


gpointer rygel_media_object_ref (gpointer instance) {
	RygelMediaObject* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_media_object_unref (gpointer instance) {
	RygelMediaObject* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_MEDIA_OBJECT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


RygelTranscoder* rygel_transcoder_construct (GType object_type) {
	RygelTranscoder* self = NULL;
	self = (RygelTranscoder*) g_type_create_instance (object_type);
	return self;
}


RygelTranscoder* rygel_transcoder_new (void) {
	return rygel_transcoder_construct (RYGEL_TYPE_TRANSCODER);
}


static void rygel_value_transcoder_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_value_transcoder_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_transcoder_unref (value->data[0].v_pointer);
	}
}


static void rygel_value_transcoder_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_transcoder_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_value_transcoder_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_value_transcoder_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelTranscoder* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_transcoder_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_value_transcoder_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelTranscoder** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_transcoder_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_param_spec_transcoder (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecTranscoder* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_TRANSCODER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_value_get_transcoder (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_TRANSCODER), NULL);
	return value->data[0].v_pointer;
}


void rygel_value_set_transcoder (GValue* value, gpointer v_object) {
	RygelTranscoder* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_TRANSCODER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_TRANSCODER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_transcoder_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_transcoder_unref (old);
	}
}


void rygel_value_take_transcoder (GValue* value, gpointer v_object) {
	RygelTranscoder* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_TRANSCODER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_TRANSCODER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_transcoder_unref (old);
	}
}


static void rygel_transcoder_class_init (RygelTranscoderClass * klass) {
	rygel_transcoder_parent_class = g_type_class_peek_parent (klass);
	RYGEL_TRANSCODER_CLASS (klass)->finalize = rygel_transcoder_finalize;
}


static void rygel_transcoder_instance_init (RygelTranscoder * self) {
	self->ref_count = 1;
}


static void rygel_transcoder_finalize (RygelTranscoder* obj) {
	RygelTranscoder * self;
	self = RYGEL_TRANSCODER (obj);
}


GType rygel_transcoder_get_type (void) {
	static volatile gsize rygel_transcoder_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_transcoder_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_transcoder_init, rygel_value_transcoder_free_value, rygel_value_transcoder_copy_value, rygel_value_transcoder_peek_pointer, "p", rygel_value_transcoder_collect_value, "p", rygel_value_transcoder_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelTranscoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_transcoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTranscoder), 0, (GInstanceInitFunc) rygel_transcoder_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_transcoder_type_id;
		rygel_transcoder_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelTranscoder", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_transcoder_type_id__volatile, rygel_transcoder_type_id);
	}
	return rygel_transcoder_type_id__volatile;
}


gpointer rygel_transcoder_ref (gpointer instance) {
	RygelTranscoder* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_transcoder_unref (gpointer instance) {
	RygelTranscoder* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_TRANSCODER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



