/* rygel-media-item.c generated by valac 0.11.6, the Vala compiler
 * generated from rygel-media-item.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp-av/gupnp-av.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gst/gst.h>
#include <gio/gio.h>
#include <libgupnp/gupnp.h>
#include <libgssdp/gssdp.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))

#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelTranscodeManagerPrivate RygelTranscodeManagerPrivate;

#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define RYGEL_TYPE_META_CONFIG (rygel_meta_config_get_type ())
#define RYGEL_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfig))
#define RYGEL_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))
#define RYGEL_IS_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_META_CONFIG))
#define RYGEL_IS_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_META_CONFIG))
#define RYGEL_META_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))

typedef struct _RygelMetaConfig RygelMetaConfig;
typedef struct _RygelMetaConfigClass RygelMetaConfigClass;

#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;

typedef enum  {
	RYGEL_MEDIA_ITEM_ERROR_BAD_URI
} RygelMediaItemError;
#define RYGEL_MEDIA_ITEM_ERROR rygel_media_item_error_quark ()
struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	gchar* date;
	gchar* mime_type;
	gchar* dlna_profile;
	GRegex* address_regex;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_uri) (RygelMediaItem* self, const gchar* uri);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelMediaItemPrivate {
	gint64 _size;
	gboolean _place_holder;
};

struct _RygelTranscodeManager {
	GObject parent_instance;
	RygelTranscodeManagerPrivate * priv;
};

struct _RygelTranscodeManagerClass {
	GObjectClass parent_class;
	gchar* (*create_uri_for_item) (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
	gchar* (*get_protocol) (RygelTranscodeManager* self);
	GeeArrayList* (*get_protocol_info) (RygelTranscodeManager* self);
};

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPServer {
	RygelTranscodeManager parent_instance;
	RygelHTTPServerPrivate * priv;
	RygelMediaContainer* root_container;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	RygelTranscodeManagerClass parent_class;
};

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gboolean (*get_upnp_enabled) (RygelConfiguration* self, GError** error);
	gchar* (*get_interface) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp3_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp2ts_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_lpcm_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_wmv_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_upload) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_deletion) (RygelConfiguration* self, GError** error);
	gchar* (*get_log_levels) (RygelConfiguration* self, GError** error);
	gchar* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_title) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_string) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
};


static gpointer rygel_media_item_parent_class = NULL;

GQuark rygel_media_item_error_quark (void);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemPrivate))
enum  {
	RYGEL_MEDIA_ITEM_DUMMY_PROPERTY,
	RYGEL_MEDIA_ITEM_SIZE,
	RYGEL_MEDIA_ITEM_PLACE_HOLDER,
	RYGEL_MEDIA_ITEM_OCM_FLAGS
};
RygelMediaItem* rygel_media_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMediaObject* rygel_media_object_construct (GType object_type);
void rygel_media_object_set_title (RygelMediaObject* self, const gchar* value);
GstElement* rygel_media_item_create_stream_source (RygelMediaItem* self);
static GstElement* rygel_media_item_real_create_stream_source (RygelMediaItem* self);
static inline void _dynamic_set_blocksize1 (GstElement* obj, glong value);
static inline void _dynamic_set_tcp_timeout2 (GstElement* obj, gint64 value);
gboolean rygel_media_item_should_stream (RygelMediaItem* self);
gboolean rygel_media_item_streamable (RygelMediaItem* self);
gint64 rygel_media_item_get_size (RygelMediaItem* self);
static gboolean rygel_media_item_real_streamable (RygelMediaItem* self);
void rygel_media_item_add_uri (RygelMediaItem* self, const gchar* uri);
static void rygel_media_item_real_add_uri (RygelMediaItem* self, const gchar* uri);
GType rygel_transcoder_get_type (void) G_GNUC_CONST;
gint rygel_media_item_compare_transcoders (RygelMediaItem* self, RygelTranscoder* transcoder1, RygelTranscoder* transcoder2);
guint rygel_transcoder_get_distance (RygelTranscoder* self, RygelMediaItem* item);
GUPnPDIDLLiteResource* rygel_media_item_add_resource (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
static GUPnPDIDLLiteResource* rygel_media_item_real_add_resource (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
gboolean rygel_media_item_get_place_holder (RygelMediaItem* self);
GUPnPProtocolInfo* rygel_media_item_get_protocol_info (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
static gint rygel_media_item_real_compare_by_property (RygelMediaObject* base, RygelMediaObject* media_object, const gchar* property);
static gint rygel_media_item_compare_by_date (RygelMediaItem* self, RygelMediaItem* item);
gint rygel_media_object_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
static GUPnPDIDLLiteObject* rygel_media_item_real_serialize (RygelMediaObject* base, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
gboolean rygel_media_object_get_restricted (RygelMediaObject* self);
GUPnPOCMFlags rygel_media_object_get_ocm_flags (RygelMediaObject* self);
const gchar* rygel_media_object_get_title (RygelMediaObject* self);
void rygel_media_item_add_proxy_resources (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
void rygel_media_item_add_resources (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void rygel_media_item_real_add_proxy_resources (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
void rygel_http_server_add_proxy_resource (RygelHTTPServer* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, GError** error);
void rygel_transcode_manager_add_resources (RygelTranscodeManager* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, GError** error);
static GUPnPProtocolInfo* rygel_media_item_real_get_protocol_info (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
gchar* rygel_media_item_get_protocol_for_uri (RygelMediaItem* self, const gchar* uri, GError** error);
static void rygel_media_item_real_add_resources (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
static gint rygel_media_item_compare_long (RygelMediaItem* self, glong a, glong b);
void rygel_media_item_set_size (RygelMediaItem* self, gint64 value);
static void rygel_media_item_set_place_holder (RygelMediaItem* self, gboolean value);
GType rygel_meta_config_get_type (void) G_GNUC_CONST;
RygelMetaConfig* rygel_meta_config_get_default (void);
GType rygel_configuration_get_type (void) G_GNUC_CONST;
gboolean rygel_configuration_get_allow_deletion (RygelConfiguration* self, GError** error);
static void rygel_media_item_finalize (GObject* obj);
static void _vala_rygel_media_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GQuark rygel_media_item_error_quark (void) {
	return g_quark_from_static_string ("rygel_media_item_error-quark");
}


RygelMediaItem* rygel_media_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class) {
	RygelMediaItem * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GRegex* _tmp6_ = NULL;
	GRegex* _tmp7_;
	GRegex* _tmp8_;
	GRegex* _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (upnp_class != NULL, NULL);
	self = (RygelMediaItem*) rygel_media_object_construct (object_type);
	_tmp0_ = g_strdup (id);
	_tmp1_ = _tmp0_;
	_g_free0 (((RygelMediaObject*) self)->id);
	((RygelMediaObject*) self)->id = _tmp1_;
	((RygelMediaObject*) self)->parent = parent;
	rygel_media_object_set_title ((RygelMediaObject*) self, title);
	_tmp2_ = g_strdup (upnp_class);
	_tmp3_ = _tmp2_;
	_g_free0 (((RygelMediaObject*) self)->upnp_class);
	((RygelMediaObject*) self)->upnp_class = _tmp3_;
	_tmp4_ = g_regex_escape_string ("@ADDRESS@", -1);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_regex_new (_tmp5_, 0, 0, &_inner_error_);
	_tmp8_ = (_tmp7_ = _tmp6_, _g_free0 (_tmp5_), _tmp7_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch46_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp9_ = _tmp8_;
	_g_regex_unref0 (self->address_regex);
	self->address_regex = _tmp9_;
	goto __finally46;
	__catch46_g_regex_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (err);
	}
	__finally46:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


static inline void _dynamic_set_blocksize1 (GstElement* obj, glong value) {
	g_object_set (obj, "blocksize", value, NULL);
}


static inline void _dynamic_set_tcp_timeout2 (GstElement* obj, gint64 value) {
	g_object_set (obj, "tcp-timeout", value, NULL);
}


static GstElement* rygel_media_item_real_create_stream_source (RygelMediaItem* self) {
	GstElement* result = NULL;
	GstElement* src;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	src = NULL;
	_tmp0_ = gee_collection_get_size ((GeeCollection*) ((RygelMediaObject*) self)->uris);
	if (_tmp0_ != 0) {
		gpointer _tmp1_ = NULL;
		gchar* _tmp2_;
		GstElement* _tmp3_ = NULL;
		GstElement* _tmp4_;
		_tmp1_ = gee_abstract_list_get ((GeeAbstractList*) ((RygelMediaObject*) self)->uris, 0);
		_tmp2_ = (gchar*) _tmp1_;
		_tmp3_ = gst_element_make_from_uri (GST_URI_SRC, _tmp2_, NULL);
		_tmp4_ = _tmp3_;
		_gst_object_unref0 (src);
		src = _tmp4_;
		_g_free0 (_tmp2_);
	}
	if (src != NULL) {
		GObjectClass* _tmp5_ = NULL;
		GParamSpec* _tmp6_ = NULL;
		GObjectClass* _tmp7_ = NULL;
		GParamSpec* _tmp8_ = NULL;
		_tmp5_ = G_OBJECT_GET_CLASS ((GObject*) src);
		_tmp6_ = g_object_class_find_property (_tmp5_, "blocksize");
		if (_tmp6_ != NULL) {
			_dynamic_set_blocksize1 (src, (glong) 65536);
		}
		_tmp7_ = G_OBJECT_GET_CLASS ((GObject*) src);
		_tmp8_ = g_object_class_find_property (_tmp7_, "tcp-timeout");
		if (_tmp8_ != NULL) {
			_dynamic_set_tcp_timeout2 (src, (gint64) 60000000);
		}
	}
	result = src;
	return result;
}


GstElement* rygel_media_item_create_stream_source (RygelMediaItem* self) {
	return RYGEL_MEDIA_ITEM_GET_CLASS (self)->create_stream_source (self);
}


gboolean rygel_media_item_should_stream (RygelMediaItem* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = rygel_media_item_streamable (self);
	if (_tmp1_) {
		gint64 _tmp2_;
		_tmp2_ = rygel_media_item_get_size (self);
		_tmp0_ = _tmp2_ <= 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean rygel_media_item_real_streamable (RygelMediaItem* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_critical ("Type `%s' does not implement abstract method `rygel_media_item_streamable'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


gboolean rygel_media_item_streamable (RygelMediaItem* self) {
	return RYGEL_MEDIA_ITEM_GET_CLASS (self)->streamable (self);
}


static void rygel_media_item_real_add_uri (RygelMediaItem* self, const gchar* uri) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	gee_abstract_collection_add ((GeeAbstractCollection*) ((RygelMediaObject*) self)->uris, uri);
}


void rygel_media_item_add_uri (RygelMediaItem* self, const gchar* uri) {
	RYGEL_MEDIA_ITEM_GET_CLASS (self)->add_uri (self, uri);
}


gint rygel_media_item_compare_transcoders (RygelMediaItem* self, RygelTranscoder* transcoder1, RygelTranscoder* transcoder2) {
	gint result = 0;
	guint _tmp0_;
	guint _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (transcoder1 != NULL, 0);
	g_return_val_if_fail (transcoder2 != NULL, 0);
	_tmp0_ = rygel_transcoder_get_distance (transcoder1, self);
	_tmp1_ = rygel_transcoder_get_distance (transcoder2, self);
	result = ((gint) _tmp0_) - ((gint) _tmp1_);
	return result;
}


static GUPnPDIDLLiteResource* rygel_media_item_real_add_resource (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error) {
	GUPnPDIDLLiteResource* result = NULL;
	GUPnPDIDLLiteResource* _tmp0_ = NULL;
	GUPnPDIDLLiteResource* res;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint64 _tmp3_;
	GUPnPProtocolInfo* _tmp4_ = NULL;
	GUPnPProtocolInfo* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (didl_item != NULL, NULL);
	g_return_val_if_fail (protocol != NULL, NULL);
	_tmp0_ = gupnp_didl_lite_object_add_resource ((GUPnPDIDLLiteObject*) didl_item);
	res = _tmp0_;
	if (uri != NULL) {
		_tmp1_ = !self->priv->_place_holder;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gupnp_didl_lite_resource_set_uri (res, uri);
	} else {
		gupnp_didl_lite_resource_set_uri (res, "");
	}
	if (import_uri != NULL) {
		_tmp2_ = self->priv->_place_holder;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gupnp_didl_lite_resource_set_import_uri (res, import_uri);
	}
	_tmp3_ = rygel_media_item_get_size (self);
	gupnp_didl_lite_resource_set_size64 (res, _tmp3_);
	_tmp4_ = rygel_media_item_get_protocol_info (self, uri, protocol);
	_tmp5_ = _tmp4_;
	gupnp_didl_lite_resource_set_protocol_info (res, _tmp5_);
	_g_object_unref0 (_tmp5_);
	result = res;
	return result;
}


GUPnPDIDLLiteResource* rygel_media_item_add_resource (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error) {
	return RYGEL_MEDIA_ITEM_GET_CLASS (self)->add_resource (self, didl_item, uri, protocol, import_uri, error);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gint rygel_media_item_real_compare_by_property (RygelMediaObject* base, RygelMediaObject* media_object, const gchar* property) {
	RygelMediaItem * self;
	gint result = 0;
	RygelMediaObject* _tmp0_;
	RygelMediaItem* _tmp1_;
	RygelMediaItem* item;
	const gchar* _tmp2_;
	GQuark _tmp3_;
	static GQuark _tmp3__label0 = 0;
	self = (RygelMediaItem*) base;
	g_return_val_if_fail (media_object != NULL, 0);
	g_return_val_if_fail (property != NULL, 0);
	if (!RYGEL_IS_MEDIA_ITEM (media_object)) {
		result = 1;
		return result;
	}
	_tmp1_ = _g_object_ref0 ((_tmp0_ = media_object, RYGEL_IS_MEDIA_ITEM (_tmp0_) ? ((RygelMediaItem*) _tmp0_) : NULL));
	item = _tmp1_;
	_tmp2_ = property;
	_tmp3_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if (_tmp3_ == ((0 != _tmp3__label0) ? _tmp3__label0 : (_tmp3__label0 = g_quark_from_static_string ("dc:date")))) {
		switch (0) {
			default:
			{
				gint _tmp4_;
				_tmp4_ = rygel_media_item_compare_by_date (self, item);
				result = _tmp4_;
				_g_object_unref0 (item);
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gint _tmp5_;
				_tmp5_ = RYGEL_MEDIA_OBJECT_CLASS (rygel_media_item_parent_class)->compare_by_property (RYGEL_MEDIA_OBJECT (self), (RygelMediaObject*) item, property);
				result = _tmp5_;
				_g_object_unref0 (item);
				return result;
			}
		}
	}
	_g_object_unref0 (item);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static GUPnPDIDLLiteObject* rygel_media_item_real_serialize (RygelMediaObject* base, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error) {
	RygelMediaItem * self;
	GUPnPDIDLLiteObject* result = NULL;
	GUPnPDIDLLiteItem* _tmp0_ = NULL;
	GUPnPDIDLLiteItem* didl_item;
	gboolean _tmp1_;
	const gchar* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelMediaItem*) base;
	g_return_val_if_fail (writer != NULL, NULL);
	g_return_val_if_fail (http_server != NULL, NULL);
	_tmp0_ = gupnp_didl_lite_writer_add_item (writer);
	didl_item = _tmp0_;
	gupnp_didl_lite_object_set_id ((GUPnPDIDLLiteObject*) didl_item, ((RygelMediaObject*) self)->id);
	if (((RygelMediaObject*) self)->parent != NULL) {
		gupnp_didl_lite_object_set_parent_id ((GUPnPDIDLLiteObject*) didl_item, ((RygelMediaObject*) ((RygelMediaObject*) self)->parent)->id);
	} else {
		gupnp_didl_lite_object_set_parent_id ((GUPnPDIDLLiteObject*) didl_item, "0");
	}
	_tmp1_ = rygel_media_object_get_restricted ((RygelMediaObject*) self);
	if (_tmp1_) {
		gupnp_didl_lite_object_set_restricted ((GUPnPDIDLLiteObject*) didl_item, TRUE);
	} else {
		GUPnPOCMFlags _tmp2_;
		gupnp_didl_lite_object_set_restricted ((GUPnPDIDLLiteObject*) didl_item, FALSE);
		_tmp2_ = rygel_media_object_get_ocm_flags ((RygelMediaObject*) self);
		gupnp_didl_lite_object_set_dlna_managed ((GUPnPDIDLLiteObject*) didl_item, _tmp2_);
	}
	_tmp3_ = rygel_media_object_get_title ((RygelMediaObject*) self);
	gupnp_didl_lite_object_set_title ((GUPnPDIDLLiteObject*) didl_item, _tmp3_);
	gupnp_didl_lite_object_set_upnp_class ((GUPnPDIDLLiteObject*) didl_item, ((RygelMediaObject*) self)->upnp_class);
	rygel_media_item_add_proxy_resources (self, http_server, didl_item, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (didl_item);
		return NULL;
	}
	if (!self->priv->_place_holder) {
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* host_ip;
		gboolean internal_allowed = FALSE;
		gboolean _tmp6_ = FALSE;
		const gchar* _tmp7_ = NULL;
		GList* _tmp8_ = NULL;
		_tmp4_ = gssdp_client_get_host_ip ((GSSDPClient*) http_server->context);
		_tmp5_ = g_strdup (_tmp4_);
		host_ip = _tmp5_;
		_tmp7_ = gssdp_client_get_interface ((GSSDPClient*) http_server->context);
		if (g_strcmp0 (_tmp7_, "lo") == 0) {
			_tmp6_ = TRUE;
		} else {
			_tmp6_ = g_strcmp0 (host_ip, "127.0.0.1") == 0;
		}
		internal_allowed = _tmp6_;
		rygel_media_item_add_resources (self, didl_item, internal_allowed, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (host_ip);
			_g_object_unref0 (didl_item);
			return NULL;
		}
		_tmp8_ = gupnp_didl_lite_object_get_resources ((GUPnPDIDLLiteObject*) didl_item);
		{
			GList* res_collection;
			GList* res_it;
			res_collection = _tmp8_;
			for (res_it = res_collection; res_it != NULL; res_it = res_it->next) {
				GUPnPDIDLLiteResource* _tmp9_;
				GUPnPDIDLLiteResource* res;
				_tmp9_ = _g_object_ref0 ((GUPnPDIDLLiteResource*) res_it->data);
				res = _tmp9_;
				{
					const gchar* _tmp10_ = NULL;
					gchar* _tmp11_ = NULL;
					gchar* _tmp12_;
					gchar* _tmp13_;
					_tmp10_ = gupnp_didl_lite_resource_get_uri (res);
					_tmp11_ = g_regex_replace_literal (self->address_regex, _tmp10_, (gssize) (-1), 0, host_ip, 0, &_inner_error_);
					_tmp12_ = _tmp11_;
					if (_inner_error_ != NULL) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (res);
						__g_list_free__g_object_unref0_0 (res_collection);
						_g_free0 (host_ip);
						_g_object_unref0 (didl_item);
						return NULL;
					}
					_tmp13_ = _tmp12_;
					gupnp_didl_lite_resource_set_uri (res, _tmp13_);
					_g_free0 (_tmp13_);
					_g_object_unref0 (res);
				}
			}
			__g_list_free__g_object_unref0_0 (res_collection);
		}
		_g_free0 (host_ip);
	}
	result = (GUPnPDIDLLiteObject*) didl_item;
	return result;
}


static void rygel_media_item_real_add_proxy_resources (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (server != NULL);
	g_return_if_fail (didl_item != NULL);
	rygel_http_server_add_proxy_resource (server, didl_item, self, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	if (!self->priv->_place_holder) {
		rygel_transcode_manager_add_resources ((RygelTranscodeManager*) server, didl_item, self, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
}


void rygel_media_item_add_proxy_resources (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error) {
	RYGEL_MEDIA_ITEM_GET_CLASS (self)->add_proxy_resources (self, server, didl_item, error);
}


static GUPnPProtocolInfo* rygel_media_item_real_get_protocol_info (RygelMediaItem* self, const gchar* uri, const gchar* protocol) {
	GUPnPProtocolInfo* result = NULL;
	GUPnPProtocolInfo* _tmp0_ = NULL;
	GUPnPProtocolInfo* protocol_info;
	gboolean _tmp1_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (protocol != NULL, NULL);
	_tmp0_ = gupnp_protocol_info_new ();
	protocol_info = _tmp0_;
	gupnp_protocol_info_set_mime_type (protocol_info, self->mime_type);
	gupnp_protocol_info_set_dlna_profile (protocol_info, self->dlna_profile);
	gupnp_protocol_info_set_protocol (protocol_info, protocol);
	gupnp_protocol_info_set_dlna_flags (protocol_info, GUPNP_DLNA_FLAGS_DLNA_V15 | GUPNP_DLNA_FLAGS_CONNECTION_STALL);
	_tmp1_ = rygel_media_item_streamable (self);
	if (_tmp1_) {
		GUPnPDLNAFlags _tmp2_;
		_tmp2_ = gupnp_protocol_info_get_dlna_flags (protocol_info);
		gupnp_protocol_info_set_dlna_flags (protocol_info, _tmp2_ | GUPNP_DLNA_FLAGS_STREAMING_TRANSFER_MODE);
	}
	_tmp3_ = rygel_media_item_should_stream (self);
	if (!_tmp3_) {
		GUPnPDLNAFlags _tmp4_;
		gupnp_protocol_info_set_dlna_operation (protocol_info, GUPNP_DLNA_OPERATION_RANGE);
		_tmp4_ = gupnp_protocol_info_get_dlna_flags (protocol_info);
		gupnp_protocol_info_set_dlna_flags (protocol_info, _tmp4_ | GUPNP_DLNA_FLAGS_BACKGROUND_TRANSFER_MODE);
	}
	result = protocol_info;
	return result;
}


GUPnPProtocolInfo* rygel_media_item_get_protocol_info (RygelMediaItem* self, const gchar* uri, const gchar* protocol) {
	return RYGEL_MEDIA_ITEM_GET_CLASS (self)->get_protocol_info (self, uri, protocol);
}


gchar* rygel_media_item_get_protocol_for_uri (RygelMediaItem* self, const gchar* uri, GError** error) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* scheme;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = g_uri_parse_scheme (uri);
	scheme = _tmp0_;
	if (scheme == NULL) {
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		_tmp1_ = _ ("Bad URI: %s");
		_tmp2_ = g_error_new (RYGEL_MEDIA_ITEM_ERROR, RYGEL_MEDIA_ITEM_ERROR_BAD_URI, _tmp1_, uri);
		_inner_error_ = _tmp2_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (scheme);
		return NULL;
	}
	if (g_strcmp0 (scheme, "http") == 0) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("http-get");
		result = _tmp3_;
		_g_free0 (scheme);
		return result;
	} else {
		if (g_strcmp0 (scheme, "file") == 0) {
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("internal");
			result = _tmp4_;
			_g_free0 (scheme);
			return result;
		} else {
			if (g_strcmp0 (scheme, "rtsp") == 0) {
				gchar* _tmp5_;
				_tmp5_ = g_strdup ("rtsp-rtp-udp");
				result = _tmp5_;
				_g_free0 (scheme);
				return result;
			} else {
				const gchar* _tmp6_ = NULL;
				_tmp6_ = _ ("Failed to probe protocol for URI %s. Assuming '%s'");
				g_warning (_tmp6_, uri, scheme);
				result = scheme;
				return result;
			}
		}
	}
	_g_free0 (scheme);
}


static void rygel_media_item_real_add_resources (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (didl_item != NULL);
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _uri_list;
		gint _tmp1_;
		gint _uri_size;
		gint _uri_index;
		_tmp0_ = _g_object_ref0 (((RygelMediaObject*) self)->uris);
		_uri_list = _tmp0_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _uri_list);
		_uri_size = _tmp1_;
		_uri_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			gchar* uri;
			gchar* _tmp3_ = NULL;
			gchar* protocol;
			gboolean _tmp4_ = FALSE;
			_uri_index = _uri_index + 1;
			if (!(_uri_index < _uri_size)) {
				break;
			}
			_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _uri_list, _uri_index);
			uri = (gchar*) _tmp2_;
			_tmp3_ = rygel_media_item_get_protocol_for_uri (self, uri, &_inner_error_);
			protocol = _tmp3_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (uri);
				_g_object_unref0 (_uri_list);
				return;
			}
			if (allow_internal) {
				_tmp4_ = TRUE;
			} else {
				_tmp4_ = g_strcmp0 (protocol, "internal") != 0;
			}
			if (_tmp4_) {
				GUPnPDIDLLiteResource* _tmp5_ = NULL;
				GUPnPDIDLLiteResource* _tmp6_;
				_tmp5_ = rygel_media_item_add_resource (self, didl_item, uri, protocol, NULL, &_inner_error_);
				_tmp6_ = _tmp5_;
				_g_object_unref0 (_tmp6_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (protocol);
					_g_free0 (uri);
					_g_object_unref0 (_uri_list);
					return;
				}
			}
			_g_free0 (protocol);
			_g_free0 (uri);
		}
		_g_object_unref0 (_uri_list);
	}
}


void rygel_media_item_add_resources (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error) {
	RYGEL_MEDIA_ITEM_GET_CLASS (self)->add_resources (self, didl_item, allow_internal, error);
}


static gint rygel_media_item_compare_by_date (RygelMediaItem* self, RygelMediaItem* item) {
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (item != NULL, 0);
	if (self->date == NULL) {
		result = -1;
		return result;
	} else {
		if (item->date == NULL) {
			result = 1;
			return result;
		} else {
			GTimeVal tv1 = {0};
			gboolean _tmp0_;
			GTimeVal tv2 = {0};
			gboolean _tmp1_;
			gint _tmp2_;
			gint ret;
			g_get_current_time (&tv1);
			_tmp0_ = g_time_val_from_iso8601 (self->date, &tv1);
			g_assert (_tmp0_);
			g_get_current_time (&tv2);
			_tmp1_ = g_time_val_from_iso8601 (item->date, &tv2);
			g_assert (_tmp1_);
			_tmp2_ = rygel_media_item_compare_long (self, tv1.tv_sec, tv2.tv_sec);
			ret = _tmp2_;
			if (ret == 0) {
				gint _tmp3_;
				_tmp3_ = rygel_media_item_compare_long (self, tv1.tv_usec, tv2.tv_usec);
				ret = _tmp3_;
			}
			result = ret;
			return result;
		}
	}
}


static gint rygel_media_item_compare_long (RygelMediaItem* self, glong a, glong b) {
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	if (a < b) {
		result = -1;
		return result;
	} else {
		if (a > b) {
			result = 1;
			return result;
		} else {
			result = 0;
			return result;
		}
	}
}


gint64 rygel_media_item_get_size (RygelMediaItem* self) {
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_size;
	return result;
}


void rygel_media_item_set_size (RygelMediaItem* self, gint64 value) {
	g_return_if_fail (self != NULL);
	if (value == 0) {
		rygel_media_item_set_place_holder (self, TRUE);
	}
	self->priv->_size = value;
	g_object_notify ((GObject *) self, "size");
}


gboolean rygel_media_item_get_place_holder (RygelMediaItem* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_place_holder;
	return result;
}


static void rygel_media_item_set_place_holder (RygelMediaItem* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_place_holder = value;
	g_object_notify ((GObject *) self, "place-holder");
}


static GUPnPOCMFlags rygel_media_item_real_get_ocm_flags (RygelMediaObject* base) {
	GUPnPOCMFlags result;
	RygelMediaItem* self;
	RygelMetaConfig* _tmp0_ = NULL;
	RygelMetaConfig* config;
	gboolean allow_deletion;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GError * _inner_error_ = NULL;
	self = (RygelMediaItem*) base;
	if (self->priv->_place_holder) {
		result = GUPNP_OCM_FLAGS_DESTROYABLE;
		return result;
	}
	_tmp0_ = rygel_meta_config_get_default ();
	config = _tmp0_;
	allow_deletion = TRUE;
	_tmp1_ = rygel_configuration_get_allow_deletion ((RygelConfiguration*) config, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		goto __catch47_g_error;
	}
	allow_deletion = _tmp2_;
	goto __finally47;
	__catch47_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally47:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	if (allow_deletion) {
		result = GUPNP_OCM_FLAGS_DESTROYABLE;
		_g_object_unref0 (config);
		return result;
	} else {
		result = GUPNP_OCM_FLAGS_NONE;
		_g_object_unref0 (config);
		return result;
	}
	_g_object_unref0 (config);
}


static void rygel_media_item_class_init (RygelMediaItemClass * klass) {
	rygel_media_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaItemPrivate));
	RYGEL_MEDIA_ITEM_CLASS (klass)->create_stream_source = rygel_media_item_real_create_stream_source;
	RYGEL_MEDIA_ITEM_CLASS (klass)->streamable = rygel_media_item_real_streamable;
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_uri = rygel_media_item_real_add_uri;
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_resource = rygel_media_item_real_add_resource;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->compare_by_property = rygel_media_item_real_compare_by_property;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->serialize = rygel_media_item_real_serialize;
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_proxy_resources = rygel_media_item_real_add_proxy_resources;
	RYGEL_MEDIA_ITEM_CLASS (klass)->get_protocol_info = rygel_media_item_real_get_protocol_info;
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_resources = rygel_media_item_real_add_resources;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->get_ocm_flags = rygel_media_item_real_get_ocm_flags;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_ITEM_SIZE, g_param_spec_int64 ("size", "size", "size", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_ITEM_PLACE_HOLDER, g_param_spec_boolean ("place-holder", "place-holder", "place-holder", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_ITEM_OCM_FLAGS, "ocm-flags");
}


static void rygel_media_item_instance_init (RygelMediaItem * self) {
	self->priv = RYGEL_MEDIA_ITEM_GET_PRIVATE (self);
	self->priv->_size = (gint64) (-1);
	self->priv->_place_holder = FALSE;
}


static void rygel_media_item_finalize (GObject* obj) {
	RygelMediaItem * self;
	self = RYGEL_MEDIA_ITEM (obj);
	_g_free0 (self->date);
	_g_free0 (self->mime_type);
	_g_free0 (self->dlna_profile);
	_g_regex_unref0 (self->address_regex);
	G_OBJECT_CLASS (rygel_media_item_parent_class)->finalize (obj);
}


/**
 * Represents a media (Music, Video and Image) item.
 */
GType rygel_media_item_get_type (void) {
	static volatile gsize rygel_media_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaItem), 0, (GInstanceInitFunc) rygel_media_item_instance_init, NULL };
		GType rygel_media_item_type_id;
		rygel_media_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaItem", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_media_item_type_id__volatile, rygel_media_item_type_id);
	}
	return rygel_media_item_type_id__volatile;
}


static void _vala_rygel_media_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaItem * self;
	self = RYGEL_MEDIA_ITEM (object);
	switch (property_id) {
		case RYGEL_MEDIA_ITEM_SIZE:
		g_value_set_int64 (value, rygel_media_item_get_size (self));
		break;
		case RYGEL_MEDIA_ITEM_PLACE_HOLDER:
		g_value_set_boolean (value, rygel_media_item_get_place_holder (self));
		break;
		case RYGEL_MEDIA_ITEM_OCM_FLAGS:
		g_value_set_flags (value, rygel_media_object_get_ocm_flags ((RygelMediaObject*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_media_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaItem * self;
	self = RYGEL_MEDIA_ITEM (object);
	switch (property_id) {
		case RYGEL_MEDIA_ITEM_SIZE:
		rygel_media_item_set_size (self, g_value_get_int64 (value));
		break;
		case RYGEL_MEDIA_ITEM_PLACE_HOLDER:
		rygel_media_item_set_place_holder (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



