/* rygel-xbox-hacks.c generated by valac 0.11.3, the Vala compiler
 * generated from rygel-xbox-hacks.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <libsoup/soup.h>
#include <glib/gi18n-lib.h>
#include <libxml/tree.h>
#include <libxml/parser.h>
#include <libgupnp-av/gupnp-av.h>
#include <gee.h>
#include <gst/gst.h>
#include <gio/gio.h>
#include <stdio.h>


#define RYGEL_TYPE_XBOX_HACKS (rygel_xbox_hacks_get_type ())
#define RYGEL_XBOX_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacks))
#define RYGEL_XBOX_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksClass))
#define RYGEL_IS_XBOX_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_XBOX_HACKS))
#define RYGEL_IS_XBOX_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_XBOX_HACKS))
#define RYGEL_XBOX_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksClass))

typedef struct _RygelXBoxHacks RygelXBoxHacks;
typedef struct _RygelXBoxHacksClass RygelXBoxHacksClass;
typedef struct _RygelXBoxHacksPrivate RygelXBoxHacksPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_ROOT_DEVICE (rygel_root_device_get_type ())
#define RYGEL_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDevice))
#define RYGEL_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))
#define RYGEL_IS_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_IS_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_ROOT_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))

typedef struct _RygelRootDevice RygelRootDevice;
typedef struct _RygelRootDeviceClass RygelRootDeviceClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_MEDIA_QUERY_ACTION (rygel_media_query_action_get_type ())
#define RYGEL_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction))
#define RYGEL_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))
#define RYGEL_IS_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_IS_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_MEDIA_QUERY_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))

typedef struct _RygelMediaQueryAction RygelMediaQueryAction;
typedef struct _RygelMediaQueryActionClass RygelMediaQueryActionClass;

#define RYGEL_TYPE_SEARCH (rygel_search_get_type ())
#define RYGEL_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH, RygelSearch))
#define RYGEL_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH, RygelSearchClass))
#define RYGEL_IS_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH))
#define RYGEL_IS_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH))
#define RYGEL_SEARCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH, RygelSearchClass))

typedef struct _RygelSearch RygelSearch;
typedef struct _RygelSearchClass RygelSearchClass;

#define RYGEL_TYPE_BROWSE (rygel_browse_get_type ())
#define RYGEL_BROWSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BROWSE, RygelBrowse))
#define RYGEL_BROWSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BROWSE, RygelBrowseClass))
#define RYGEL_IS_BROWSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BROWSE))
#define RYGEL_IS_BROWSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BROWSE))
#define RYGEL_BROWSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BROWSE, RygelBrowseClass))

typedef struct _RygelBrowse RygelBrowse;
typedef struct _RygelBrowseClass RygelBrowseClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerIface))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerIface RygelSearchableContainerIface;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;

#define RYGEL_TYPE_RELATIONAL_EXPRESSION (rygel_relational_expression_get_type ())
#define RYGEL_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpression))
#define RYGEL_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))
#define RYGEL_IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))

typedef struct _RygelRelationalExpression RygelRelationalExpression;
typedef struct _RygelRelationalExpressionClass RygelRelationalExpressionClass;
typedef struct _RygelSearchExpressionPrivate RygelSearchExpressionPrivate;
typedef struct _RygelXboxHacksSearchData RygelXboxHacksSearchData;
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))

typedef enum  {
	RYGEL_XBOX_HACKS_ERROR_NA
} RygelXBoxHacksError;
#define RYGEL_XBOX_HACKS_ERROR rygel_xbox_hacks_error_quark ()
struct _RygelXBoxHacks {
	GObject parent_instance;
	RygelXBoxHacksPrivate * priv;
};

struct _RygelXBoxHacksClass {
	GObjectClass parent_class;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	gchar* date;
	gchar* mime_type;
	gchar* dlna_profile;
	GRegex* address_regex;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_uri) (RygelMediaItem* self, const gchar* uri);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelSearchableContainerIface {
	GTypeInterface parent_iface;
	void (*search) (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
};

struct _RygelSearchExpression {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSearchExpressionPrivate * priv;
	gpointer op;
	gpointer operand1;
	gpointer operand2;
};

struct _RygelSearchExpressionClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSearchExpression *self);
	gboolean (*satisfied_by) (RygelSearchExpression* self, RygelMediaObject* media_object);
	gchar* (*to_string) (RygelSearchExpression* self);
};

struct _RygelXboxHacksSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelXBoxHacks* self;
	RygelSearchableContainer* container;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	guint _tmp0_;
	RygelMediaObjects* _tmp1_;
	RygelMediaObjects* results;
	gboolean _tmp2_;
	RygelSearchExpression* _tmp3_;
	RygelRelationalExpression* _tmp4_;
	RygelRelationalExpression* rel_expression;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gint _tmp7_;
	GError * _inner_error_;
};


static gpointer rygel_xbox_hacks_parent_class = NULL;
static gchar* rygel_xbox_hacks_AGENT;
static gchar* rygel_xbox_hacks_AGENT = NULL;
static gchar* rygel_xbox_hacks_DMS;
static gchar* rygel_xbox_hacks_DMS = NULL;
static gchar* rygel_xbox_hacks_DMS_V1;
static gchar* rygel_xbox_hacks_DMS_V1 = NULL;
static gchar* rygel_xbox_hacks_FRIENDLY_NAME_POSTFIX;
static gchar* rygel_xbox_hacks_FRIENDLY_NAME_POSTFIX = NULL;
static gchar* rygel_xbox_hacks_MODEL_NAME;
static gchar* rygel_xbox_hacks_MODEL_NAME = NULL;

GQuark rygel_xbox_hacks_error_quark (void);
GType rygel_xbox_hacks_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_XBOX_HACKS_DUMMY_PROPERTY
};
RygelXBoxHacks* rygel_xbox_hacks_new_for_action (GUPnPServiceAction* action, GError** error);
RygelXBoxHacks* rygel_xbox_hacks_construct_for_action (GType object_type, GUPnPServiceAction* action, GError** error);
GType rygel_root_device_get_type (void) G_GNUC_CONST;
void rygel_xbox_hacks_apply_on_device (RygelXBoxHacks* self, RygelRootDevice* device, const gchar* template_path, GError** error);
static void rygel_xbox_hacks_modify_dms_desc (RygelXBoxHacks* self, xmlDoc* doc);
static void rygel_xbox_hacks_save_modified_desc (RygelXBoxHacks* self, GUPnPXMLDoc* doc, const gchar* desc_path, GError** error);
GType rygel_media_query_action_get_type (void) G_GNUC_CONST;
void rygel_xbox_hacks_translate_container_id (RygelXBoxHacks* self, RygelMediaQueryAction* action, gchar** container_id);
GType rygel_search_get_type (void) G_GNUC_CONST;
GType rygel_browse_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
void rygel_xbox_hacks_apply (RygelXBoxHacks* self, RygelMediaItem* item);
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
static void rygel_xbox_hacks_search_data_free (gpointer _data);
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
void rygel_xbox_hacks_search (RygelXBoxHacks* self, RygelSearchableContainer* container, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_xbox_hacks_search_finish (RygelXBoxHacks* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static gboolean rygel_xbox_hacks_search_co (RygelXboxHacksSearchData* data);
void rygel_searchable_container_search (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_searchable_container_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static void rygel_xbox_hacks_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GType rygel_relational_expression_get_type (void) G_GNUC_CONST;
xmlNode* rygel_xml_utils_get_element (xmlNode* node, ...);
static xmlNode* rygel_xbox_hacks_find_cds_type_node (RygelXBoxHacks* self, xmlNode* doc_node);
#define RYGEL_CONTENT_DIRECTORY_UPNP_TYPE_V1 "urn:schemas-upnp-org:service:ContentDirectory:1"
#define RYGEL_CONTENT_DIRECTORY_UPNP_TYPE "urn:schemas-upnp-org:service:ContentDirectory:2"
RygelXBoxHacks* rygel_xbox_hacks_new (void);
RygelXBoxHacks* rygel_xbox_hacks_construct (GType object_type);
static void rygel_xbox_hacks_finalize (GObject* obj);


GQuark rygel_xbox_hacks_error_quark (void) {
	return g_quark_from_static_string ("rygel_xbox_hacks_error-quark");
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr (self, needle);
	result = _tmp0_ != NULL;
	return result;
}


RygelXBoxHacks* rygel_xbox_hacks_construct_for_action (GType object_type, GUPnPServiceAction* action, GError** error) {
	RygelXBoxHacks * self = NULL;
	SoupMessage* _tmp0_ = NULL;
	SoupMessage* _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* agent;
	gboolean _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (action != NULL, NULL);
	self = (RygelXBoxHacks*) g_object_new (object_type, NULL);
	_tmp0_ = gupnp_service_action_get_message (action);
	_tmp1_ = _tmp0_;
	_tmp2_ = soup_message_headers_get_one (_tmp1_->request_headers, "User-Agent");
	_tmp3_ = g_strdup (_tmp2_);
	agent = (_tmp4_ = _tmp3_, _g_object_unref0 (_tmp1_), _tmp4_);
	_tmp5_ = string_contains (agent, "Xbox");
	if (!_tmp5_) {
		const gchar* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		_tmp6_ = _ ("Not Applicable");
		_tmp7_ = g_error_new_literal (RYGEL_XBOX_HACKS_ERROR, RYGEL_XBOX_HACKS_ERROR_NA, _tmp6_);
		_inner_error_ = _tmp7_;
		if (_inner_error_->domain == RYGEL_XBOX_HACKS_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (agent);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (agent);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_g_free0 (agent);
	return self;
}


RygelXBoxHacks* rygel_xbox_hacks_new_for_action (GUPnPServiceAction* action, GError** error) {
	return rygel_xbox_hacks_construct_for_action (RYGEL_TYPE_XBOX_HACKS, action, error);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GRegex* _tmp2_ = NULL;
	GRegex* _tmp3_;
	GRegex* regex;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	_tmp0_ = g_regex_escape_string (old, -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_regex_new (_tmp1_, 0, 0, &_inner_error_);
	regex = (_tmp3_ = _tmp2_, _g_free0 (_tmp1_), _tmp3_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch57_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch57_g_regex_error;
		}
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp5_;
	_g_regex_unref0 (regex);
	return result;
	_g_regex_unref0 (regex);
	goto __finally57;
	__catch57_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally57:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


void rygel_xbox_hacks_apply_on_device (RygelXBoxHacks* self, RygelRootDevice* device, const gchar* template_path, GError** error) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	GUPnPXMLDoc* _tmp2_ = NULL;
	GUPnPXMLDoc* doc;
	gchar* _tmp3_ = NULL;
	gchar* desc_path;
	GRegex* _tmp4_ = NULL;
	GRegex* regex;
	const gchar* _tmp5_ = NULL;
	gchar* server_path;
	GUPnPContext* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	g_return_if_fail (template_path != NULL);
	_tmp0_ = gupnp_device_info_get_device_type ((GUPnPDeviceInfo*) device);
	_tmp1_ = g_str_has_prefix (_tmp0_, rygel_xbox_hacks_DMS);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = gupnp_xml_doc_new_from_path (template_path, &_inner_error_);
	doc = _tmp2_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	rygel_xbox_hacks_modify_dms_desc (self, doc->doc);
	_tmp3_ = string_replace (template_path, ".xml", "-xbox.xml");
	desc_path = _tmp3_;
	rygel_xbox_hacks_save_modified_desc (self, doc, desc_path, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (desc_path);
		_g_object_unref0 (doc);
		return;
	}
	_tmp4_ = g_regex_new (rygel_xbox_hacks_AGENT, G_REGEX_CASELESS, 0, &_inner_error_);
	regex = _tmp4_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (desc_path);
		_g_object_unref0 (doc);
		return;
	}
	_tmp5_ = gupnp_root_device_get_relative_location ((GUPnPRootDevice*) device);
	server_path = g_strconcat ("/", _tmp5_, NULL);
	_tmp6_ = gupnp_device_info_get_context ((GUPnPDeviceInfo*) device);
	gupnp_context_host_path_for_agent (_tmp6_, desc_path, server_path, regex);
	_g_free0 (server_path);
	_g_regex_unref0 (regex);
	_g_free0 (desc_path);
	_g_object_unref0 (doc);
}


void rygel_xbox_hacks_translate_container_id (RygelXBoxHacks* self, RygelMediaQueryAction* action, gchar** container_id) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (container_id != NULL);
	if (RYGEL_IS_SEARCH (action)) {
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		if (g_strcmp0 (*container_id, "1") == 0) {
			_tmp6_ = TRUE;
		} else {
			_tmp6_ = g_strcmp0 (*container_id, "4") == 0;
		}
		if (_tmp6_) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = g_strcmp0 (*container_id, "5") == 0;
		}
		if (_tmp5_) {
			_tmp4_ = TRUE;
		} else {
			_tmp4_ = g_strcmp0 (*container_id, "6") == 0;
		}
		if (_tmp4_) {
			_tmp3_ = TRUE;
		} else {
			_tmp3_ = g_strcmp0 (*container_id, "7") == 0;
		}
		if (_tmp3_) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = g_strcmp0 (*container_id, "F") == 0;
		}
		_tmp1_ = _tmp2_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		if (RYGEL_IS_BROWSE (action)) {
			_tmp9_ = g_strcmp0 (*container_id, "15") == 0;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			_tmp8_ = TRUE;
		} else {
			_tmp8_ = g_strcmp0 (*container_id, "14") == 0;
		}
		if (_tmp8_) {
			_tmp7_ = TRUE;
		} else {
			_tmp7_ = g_strcmp0 (*container_id, "16") == 0;
		}
		_tmp0_ = _tmp7_;
	}
	if (_tmp0_) {
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = g_strdup ("0");
		_tmp11_ = _tmp10_;
		_g_free0 (*container_id);
		*container_id = _tmp11_;
	}
}


void rygel_xbox_hacks_apply (RygelXBoxHacks* self, RygelMediaItem* item) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	if (g_strcmp0 (item->mime_type, "video/x-msvideo") == 0) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = g_strdup ("video/avi");
		_tmp1_ = _tmp0_;
		_g_free0 (item->mime_type);
		item->mime_type = _tmp1_;
	} else {
		if (g_strcmp0 (item->mime_type, "video/mpeg") == 0) {
			gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = g_strdup ("invalid/content");
			_tmp3_ = _tmp2_;
			_g_free0 (item->mime_type);
			item->mime_type = _tmp3_;
		}
	}
}


static void rygel_xbox_hacks_search_data_free (gpointer _data) {
	RygelXboxHacksSearchData* data;
	data = _data;
	_g_object_unref0 (data->container);
	_rygel_search_expression_unref0 (data->expression);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (RygelXboxHacksSearchData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
	return self ? rygel_search_expression_ref (self) : NULL;
}


void rygel_xbox_hacks_search (RygelXBoxHacks* self, RygelSearchableContainer* container, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelXboxHacksSearchData* _data_;
	_data_ = g_slice_new0 (RygelXboxHacksSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_xbox_hacks_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_xbox_hacks_search_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->container = _g_object_ref0 (container);
	_data_->expression = _rygel_search_expression_ref0 (expression);
	_data_->offset = offset;
	_data_->max_count = max_count;
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_xbox_hacks_search_co (_data_);
}


RygelMediaObjects* rygel_xbox_hacks_search_finish (RygelXBoxHacks* self, GAsyncResult* _res_, guint* total_matches, GError** error) {
	RygelMediaObjects* result;
	RygelXboxHacksSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	*total_matches = _data_->total_matches;
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_xbox_hacks_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelXboxHacksSearchData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_xbox_hacks_search_co (data);
}


static gboolean rygel_xbox_hacks_search_co (RygelXboxHacksSearchData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_state_ = 1;
	rygel_searchable_container_search (data->container, data->expression, data->offset, data->max_count, data->cancellable, rygel_xbox_hacks_search_ready, data);
	return FALSE;
	_state_1:
	data->_tmp1_ = NULL;
	data->_tmp1_ = rygel_searchable_container_search_finish (data->container, data->_res_, &data->_tmp0_, &data->_inner_error_);
	data->total_matches = data->_tmp0_;
	data->results = data->_tmp1_;
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	if (data->total_matches == 0) {
		data->_tmp2_ = RYGEL_IS_RELATIONAL_EXPRESSION (data->expression);
	} else {
		data->_tmp2_ = FALSE;
	}
	if (data->_tmp2_) {
		data->_tmp4_ = _rygel_search_expression_ref0 ((data->_tmp3_ = data->expression, RYGEL_IS_RELATIONAL_EXPRESSION (data->_tmp3_) ? ((RygelRelationalExpression*) data->_tmp3_) : NULL));
		data->rel_expression = data->_tmp4_;
		data->_tmp6_ = G_LIKELY (((const gchar*) ((RygelSearchExpression*) data->rel_expression)->operand1) != NULL);
		if (data->_tmp6_) {
			data->_tmp5_ = g_strcmp0 ((const gchar*) ((RygelSearchExpression*) data->rel_expression)->operand1, "upnp:class") == 0;
		} else {
			data->_tmp5_ = FALSE;
		}
		if (data->_tmp5_) {
			data->_tmp7_ = gee_collection_get_size ((GeeCollection*) data->results);
			data->total_matches = (guint) data->_tmp7_;
		}
		_rygel_search_expression_unref0 (data->rel_expression);
	}
	data->result = data->results;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_object_unref0 (data->results);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_xbox_hacks_modify_dms_desc (RygelXBoxHacks* self, xmlDoc* doc) {
	xmlNode* _tmp0_ = NULL;
	xmlNode* element;
	xmlNode* _tmp1_ = NULL;
	xmlNode* _tmp2_ = NULL;
	xmlNode* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (doc != NULL);
	_tmp0_ = rygel_xml_utils_get_element ((xmlNode*) doc, "root", "device", "deviceType", NULL);
	element = _tmp0_;
	g_assert (element != NULL);
	xmlNodeSetContent (element, rygel_xbox_hacks_DMS_V1);
	_tmp1_ = rygel_xml_utils_get_element ((xmlNode*) doc, "root", "device", "modelName", NULL);
	element = _tmp1_;
	g_assert (element != NULL);
	xmlNodeSetContent (element, rygel_xbox_hacks_MODEL_NAME);
	_tmp2_ = rygel_xml_utils_get_element ((xmlNode*) doc, "root", "device", "friendlyName", NULL);
	element = _tmp2_;
	g_assert (element != NULL);
	xmlNodeAddContent (element, rygel_xbox_hacks_FRIENDLY_NAME_POSTFIX);
	_tmp3_ = rygel_xbox_hacks_find_cds_type_node (self, doc);
	element = _tmp3_;
	g_assert (element != NULL);
	xmlNodeSetContent (element, RYGEL_CONTENT_DIRECTORY_UPNP_TYPE_V1);
}


static xmlNode* rygel_xbox_hacks_find_cds_type_node (RygelXBoxHacks* self, xmlNode* doc_node) {
	xmlNode* result = NULL;
	xmlNode* _tmp0_ = NULL;
	xmlNode* element;
	gboolean _tmp1_ = FALSE;
	xmlNode* cds_type_node;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = rygel_xml_utils_get_element (doc_node, "root", "device", "serviceList", NULL);
	element = _tmp0_;
	if (element != NULL) {
		_tmp1_ = element->children != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	g_assert (_tmp1_);
	cds_type_node = NULL;
	{
		xmlNode* service_node;
		service_node = element->children;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				if (!_tmp2_) {
					service_node = service_node->next;
				}
				_tmp2_ = FALSE;
				if (!(service_node != NULL)) {
					break;
				}
				{
					xmlNode* type_node;
					type_node = service_node->children;
					{
						gboolean _tmp3_;
						_tmp3_ = TRUE;
						while (TRUE) {
							gboolean _tmp4_ = FALSE;
							if (!_tmp3_) {
								type_node = type_node->next;
							}
							_tmp3_ = FALSE;
							if (!(type_node != NULL)) {
								break;
							}
							if (g_strcmp0 (type_node->name, "serviceType") == 0) {
								gchar* _tmp5_ = NULL;
								gchar* _tmp6_;
								_tmp5_ = xmlNodeGetContent (type_node);
								_tmp6_ = _tmp5_;
								_tmp4_ = g_strcmp0 (_tmp6_, RYGEL_CONTENT_DIRECTORY_UPNP_TYPE) == 0;
								_g_free0 (_tmp6_);
							} else {
								_tmp4_ = FALSE;
							}
							if (_tmp4_) {
								cds_type_node = type_node;
							}
						}
					}
				}
				if (cds_type_node != NULL) {
					break;
				}
			}
		}
	}
	result = cds_type_node;
	return result;
}


static void rygel_xbox_hacks_save_modified_desc (RygelXBoxHacks* self, GUPnPXMLDoc* doc, const gchar* desc_path, GError** error) {
	FILE* _tmp0_ = NULL;
	FILE* f;
	gint res;
	gboolean _tmp2_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (doc != NULL);
	g_return_if_fail (desc_path != NULL);
	_tmp0_ = fopen (desc_path, "w+");
	f = _tmp0_;
	res = -1;
	if (f != NULL) {
		gint _tmp1_;
		_tmp1_ = xmlDocDump (f, doc->doc);
		res = _tmp1_;
	}
	if (f == NULL) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = res == (-1);
	}
	if (_tmp2_) {
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		gchar* message;
		GError* _tmp5_ = NULL;
		_tmp3_ = _ ("Failed to write modified description to %s.");
		_tmp4_ = g_strdup (_tmp3_);
		message = _tmp4_;
		_tmp5_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, message, desc_path);
		_inner_error_ = _tmp5_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (message);
		_fclose0 (f);
		return;
	}
	_fclose0 (f);
}


RygelXBoxHacks* rygel_xbox_hacks_construct (GType object_type) {
	RygelXBoxHacks * self = NULL;
	self = (RygelXBoxHacks*) g_object_new (object_type, NULL);
	return self;
}


RygelXBoxHacks* rygel_xbox_hacks_new (void) {
	return rygel_xbox_hacks_construct (RYGEL_TYPE_XBOX_HACKS);
}


static void rygel_xbox_hacks_class_init (RygelXBoxHacksClass * klass) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	rygel_xbox_hacks_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_xbox_hacks_finalize;
	_tmp0_ = g_strdup (".*Xbox.*");
	rygel_xbox_hacks_AGENT = _tmp0_;
	_tmp1_ = g_strdup ("urn:schemas-upnp-org:device:MediaServer");
	rygel_xbox_hacks_DMS = _tmp1_;
	rygel_xbox_hacks_DMS_V1 = g_strconcat (rygel_xbox_hacks_DMS, ":1", NULL);
	_tmp2_ = g_strdup (": 1 : Windows Media Connect");
	rygel_xbox_hacks_FRIENDLY_NAME_POSTFIX = _tmp2_;
	_tmp3_ = g_strdup ("Windows Media Connect");
	rygel_xbox_hacks_MODEL_NAME = _tmp3_;
}


static void rygel_xbox_hacks_instance_init (RygelXBoxHacks * self) {
}


static void rygel_xbox_hacks_finalize (GObject* obj) {
	RygelXBoxHacks * self;
	self = RYGEL_XBOX_HACKS (obj);
	G_OBJECT_CLASS (rygel_xbox_hacks_parent_class)->finalize (obj);
}


GType rygel_xbox_hacks_get_type (void) {
	static volatile gsize rygel_xbox_hacks_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_xbox_hacks_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelXBoxHacksClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_xbox_hacks_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelXBoxHacks), 0, (GInstanceInitFunc) rygel_xbox_hacks_instance_init, NULL };
		GType rygel_xbox_hacks_type_id;
		rygel_xbox_hacks_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelXBoxHacks", &g_define_type_info, 0);
		g_once_init_leave (&rygel_xbox_hacks_type_id__volatile, rygel_xbox_hacks_type_id);
	}
	return rygel_xbox_hacks_type_id__volatile;
}



