/* rygel-meta-config.c generated by valac 0.11.3, the Vala compiler
 * generated from rygel-meta-config.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Nokia Corporation.
 * Copyright (C) 2008,2009 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;

#define RYGEL_TYPE_LOG_LEVEL (rygel_log_level_get_type ())

#define RYGEL_TYPE_META_CONFIG (rygel_meta_config_get_type ())
#define RYGEL_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfig))
#define RYGEL_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))
#define RYGEL_IS_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_META_CONFIG))
#define RYGEL_IS_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_META_CONFIG))
#define RYGEL_META_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))

typedef struct _RygelMetaConfig RygelMetaConfig;
typedef struct _RygelMetaConfigClass RygelMetaConfigClass;
typedef struct _RygelMetaConfigPrivate RygelMetaConfigPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_CMDLINE_CONFIG (rygel_cmdline_config_get_type ())
#define RYGEL_CMDLINE_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CMDLINE_CONFIG, RygelCmdlineConfig))
#define RYGEL_CMDLINE_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CMDLINE_CONFIG, RygelCmdlineConfigClass))
#define RYGEL_IS_CMDLINE_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CMDLINE_CONFIG))
#define RYGEL_IS_CMDLINE_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CMDLINE_CONFIG))
#define RYGEL_CMDLINE_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CMDLINE_CONFIG, RygelCmdlineConfigClass))

typedef struct _RygelCmdlineConfig RygelCmdlineConfig;
typedef struct _RygelCmdlineConfigClass RygelCmdlineConfigClass;

#define RYGEL_TYPE_ENVIRONMENT_CONFIG (rygel_environment_config_get_type ())
#define RYGEL_ENVIRONMENT_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ENVIRONMENT_CONFIG, RygelEnvironmentConfig))
#define RYGEL_ENVIRONMENT_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ENVIRONMENT_CONFIG, RygelEnvironmentConfigClass))
#define RYGEL_IS_ENVIRONMENT_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ENVIRONMENT_CONFIG))
#define RYGEL_IS_ENVIRONMENT_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ENVIRONMENT_CONFIG))
#define RYGEL_ENVIRONMENT_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ENVIRONMENT_CONFIG, RygelEnvironmentConfigClass))

typedef struct _RygelEnvironmentConfig RygelEnvironmentConfig;
typedef struct _RygelEnvironmentConfigClass RygelEnvironmentConfigClass;

#define RYGEL_TYPE_USER_CONFIG (rygel_user_config_get_type ())
#define RYGEL_USER_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_USER_CONFIG, RygelUserConfig))
#define RYGEL_USER_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_USER_CONFIG, RygelUserConfigClass))
#define RYGEL_IS_USER_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_USER_CONFIG))
#define RYGEL_IS_USER_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_USER_CONFIG))
#define RYGEL_USER_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_USER_CONFIG, RygelUserConfigClass))

typedef struct _RygelUserConfig RygelUserConfig;
typedef struct _RygelUserConfigClass RygelUserConfigClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

typedef enum  {
	RYGEL_LOG_LEVEL_INVALID = 0,
	RYGEL_LOG_LEVEL_CRITICAL = 1,
	RYGEL_LOG_LEVEL_ERROR = 2,
	RYGEL_LOG_LEVEL_WARNING = 3,
	RYGEL_LOG_LEVEL_INFO = 4,
	RYGEL_LOG_LEVEL_DEFAULT = 4,
	RYGEL_LOG_LEVEL_DEBUG = 5
} RygelLogLevel;

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gboolean (*get_upnp_enabled) (RygelConfiguration* self, GError** error);
	gchar* (*get_interface) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp3_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp2ts_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_lpcm_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_wmv_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_upload) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_deletion) (RygelConfiguration* self, GError** error);
	RygelLogLevel (*get_log_level) (RygelConfiguration* self, GError** error);
	gchar* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_title) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_string) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
};

struct _RygelMetaConfig {
	GObject parent_instance;
	RygelMetaConfigPrivate * priv;
};

struct _RygelMetaConfigClass {
	GObjectClass parent_class;
};

struct _RygelMetaConfigPrivate {
	GeeArrayList* configs;
};

typedef enum  {
	RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET,
	RYGEL_CONFIGURATION_ERROR_VALUE_OUT_OF_RANGE
} RygelConfigurationError;
#define RYGEL_CONFIGURATION_ERROR rygel_configuration_error_quark ()

static gpointer rygel_meta_config_parent_class = NULL;
static RygelMetaConfig* rygel_meta_config_meta_config;
static RygelMetaConfig* rygel_meta_config_meta_config = NULL;
static RygelConfigurationIface* rygel_meta_config_rygel_configuration_parent_iface = NULL;

GType rygel_log_level_get_type (void) G_GNUC_CONST;
GType rygel_configuration_get_type (void) G_GNUC_CONST;
GType rygel_meta_config_get_type (void) G_GNUC_CONST;
#define RYGEL_META_CONFIG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_META_CONFIG, RygelMetaConfigPrivate))
enum  {
	RYGEL_META_CONFIG_DUMMY_PROPERTY
};
RygelMetaConfig* rygel_meta_config_get_default (void);
RygelMetaConfig* rygel_meta_config_new (void);
RygelMetaConfig* rygel_meta_config_construct (GType object_type);
GType rygel_cmdline_config_get_type (void) G_GNUC_CONST;
RygelCmdlineConfig* rygel_cmdline_config_get_default (void);
GType rygel_environment_config_get_type (void) G_GNUC_CONST;
RygelEnvironmentConfig* rygel_environment_config_get_default (void);
GType rygel_user_config_get_type (void) G_GNUC_CONST;
RygelUserConfig* rygel_user_config_get_default (GError** error);
static gboolean rygel_meta_config_real_get_upnp_enabled (RygelConfiguration* base, GError** error);
gboolean rygel_configuration_get_upnp_enabled (RygelConfiguration* self, GError** error);
GQuark rygel_configuration_error_quark (void);
static gchar* rygel_meta_config_real_get_interface (RygelConfiguration* base, GError** error);
gchar* rygel_configuration_get_interface (RygelConfiguration* self, GError** error);
static gint rygel_meta_config_real_get_port (RygelConfiguration* base, GError** error);
gint rygel_configuration_get_port (RygelConfiguration* self, GError** error);
static gboolean rygel_meta_config_real_get_transcoding (RygelConfiguration* base, GError** error);
gboolean rygel_configuration_get_transcoding (RygelConfiguration* self, GError** error);
static gboolean rygel_meta_config_real_get_mp3_transcoder (RygelConfiguration* base, GError** error);
gboolean rygel_configuration_get_mp3_transcoder (RygelConfiguration* self, GError** error);
static gboolean rygel_meta_config_real_get_mp2ts_transcoder (RygelConfiguration* base, GError** error);
gboolean rygel_configuration_get_mp2ts_transcoder (RygelConfiguration* self, GError** error);
static gboolean rygel_meta_config_real_get_lpcm_transcoder (RygelConfiguration* base, GError** error);
gboolean rygel_configuration_get_lpcm_transcoder (RygelConfiguration* self, GError** error);
static gboolean rygel_meta_config_real_get_wmv_transcoder (RygelConfiguration* base, GError** error);
gboolean rygel_configuration_get_wmv_transcoder (RygelConfiguration* self, GError** error);
static gboolean rygel_meta_config_real_get_allow_upload (RygelConfiguration* base, GError** error);
gboolean rygel_configuration_get_allow_upload (RygelConfiguration* self, GError** error);
static gboolean rygel_meta_config_real_get_allow_deletion (RygelConfiguration* base, GError** error);
gboolean rygel_configuration_get_allow_deletion (RygelConfiguration* self, GError** error);
static RygelLogLevel rygel_meta_config_real_get_log_level (RygelConfiguration* base, GError** error);
RygelLogLevel rygel_configuration_get_log_level (RygelConfiguration* self, GError** error);
static gchar* rygel_meta_config_real_get_plugin_path (RygelConfiguration* base, GError** error);
gchar* rygel_configuration_get_plugin_path (RygelConfiguration* self, GError** error);
static gboolean rygel_meta_config_real_get_enabled (RygelConfiguration* base, const gchar* section, GError** error);
gboolean rygel_configuration_get_enabled (RygelConfiguration* self, const gchar* section, GError** error);
static gchar* rygel_meta_config_real_get_title (RygelConfiguration* base, const gchar* section, GError** error);
gchar* rygel_configuration_get_title (RygelConfiguration* self, const gchar* section, GError** error);
static gchar* rygel_meta_config_real_get_string (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error);
gchar* rygel_configuration_get_string (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
static GeeArrayList* rygel_meta_config_real_get_string_list (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error);
GeeArrayList* rygel_configuration_get_string_list (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
static gint rygel_meta_config_real_get_int (RygelConfiguration* base, const gchar* section, const gchar* key, gint min, gint max, GError** error);
gint rygel_configuration_get_int (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
static GeeArrayList* rygel_meta_config_real_get_int_list (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error);
GeeArrayList* rygel_configuration_get_int_list (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
static gboolean rygel_meta_config_real_get_bool (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error);
gboolean rygel_configuration_get_bool (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
static void rygel_meta_config_finalize (GObject* obj);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelMetaConfig* rygel_meta_config_get_default (void) {
	RygelMetaConfig* result = NULL;
	RygelMetaConfig* _tmp2_;
	if (rygel_meta_config_meta_config == NULL) {
		RygelMetaConfig* _tmp0_ = NULL;
		RygelMetaConfig* _tmp1_;
		_tmp0_ = rygel_meta_config_new ();
		_tmp1_ = _tmp0_;
		_g_object_unref0 (rygel_meta_config_meta_config);
		rygel_meta_config_meta_config = _tmp1_;
	}
	_tmp2_ = _g_object_ref0 (rygel_meta_config_meta_config);
	result = _tmp2_;
	return result;
}


RygelMetaConfig* rygel_meta_config_construct (GType object_type) {
	RygelMetaConfig * self = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_;
	RygelCmdlineConfig* _tmp2_ = NULL;
	RygelCmdlineConfig* _tmp3_;
	RygelEnvironmentConfig* _tmp4_ = NULL;
	RygelEnvironmentConfig* _tmp5_;
	RygelUserConfig* _tmp6_ = NULL;
	RygelUserConfig* user_config;
	GError * _inner_error_ = NULL;
	self = (RygelMetaConfig*) g_object_new (object_type, NULL);
	_tmp0_ = gee_array_list_new (RYGEL_TYPE_CONFIGURATION, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->configs);
	self->priv->configs = _tmp1_;
	_tmp2_ = rygel_cmdline_config_get_default ();
	_tmp3_ = _tmp2_;
	gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->configs, (RygelConfiguration*) _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = rygel_environment_config_get_default ();
	_tmp5_ = _tmp4_;
	gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->configs, (RygelConfiguration*) _tmp5_);
	_g_object_unref0 (_tmp5_);
	_tmp6_ = rygel_user_config_get_default (&_inner_error_);
	user_config = _tmp6_;
	if (_inner_error_ != NULL) {
		goto __catch6_g_error;
	}
	gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->configs, (RygelConfiguration*) user_config);
	_g_object_unref0 (user_config);
	goto __finally6;
	__catch6_g_error:
	{
		GError * err;
		const gchar* _tmp7_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = _ ("Failed to load user configuration: %s");
		g_warning (_tmp7_, err->message);
		_g_error_free0 (err);
	}
	__finally6:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


RygelMetaConfig* rygel_meta_config_new (void) {
	return rygel_meta_config_construct (RYGEL_TYPE_META_CONFIG);
}


static gboolean rygel_meta_config_real_get_upnp_enabled (RygelConfiguration* base, GError** error) {
	RygelMetaConfig * self;
	gboolean result = FALSE;
	gboolean val;
	gboolean unavailable;
	GError * _inner_error_ = NULL;
	self = (RygelMetaConfig*) base;
	val = TRUE;
	unavailable = TRUE;
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _config_list;
		gint _tmp1_;
		gint _config_size;
		gint _config_index;
		_tmp0_ = _g_object_ref0 (self->priv->configs);
		_config_list = _tmp0_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _config_list);
		_config_size = _tmp1_;
		_config_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			RygelConfiguration* config;
			gboolean _tmp3_;
			gboolean _tmp4_;
			_config_index = _config_index + 1;
			if (!(_config_index < _config_size)) {
				break;
			}
			_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _config_list, _config_index);
			config = (RygelConfiguration*) _tmp2_;
			_tmp3_ = rygel_configuration_get_upnp_enabled (config, &_inner_error_);
			_tmp4_ = _tmp3_;
			if (_inner_error_ != NULL) {
				goto __catch7_g_error;
			}
			val = _tmp4_;
			unavailable = FALSE;
			_g_object_unref0 (config);
			break;
			goto __finally7;
			__catch7_g_error:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				_g_error_free0 (err);
			}
			__finally7:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (config);
				_g_object_unref0 (_config_list);
				return FALSE;
			}
			_g_object_unref0 (config);
		}
		_g_object_unref0 (_config_list);
	}
	if (unavailable) {
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		_tmp5_ = _ ("No value available");
		_tmp6_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp5_);
		_inner_error_ = _tmp6_;
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = val;
	return result;
}


static gchar* rygel_meta_config_real_get_interface (RygelConfiguration* base, GError** error) {
	RygelMetaConfig * self;
	gchar* result = NULL;
	gchar* val;
	gboolean unavailable;
	GError * _inner_error_ = NULL;
	self = (RygelMetaConfig*) base;
	val = NULL;
	unavailable = TRUE;
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _config_list;
		gint _tmp1_;
		gint _config_size;
		gint _config_index;
		_tmp0_ = _g_object_ref0 (self->priv->configs);
		_config_list = _tmp0_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _config_list);
		_config_size = _tmp1_;
		_config_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			RygelConfiguration* config;
			gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			gchar* _tmp5_;
			_config_index = _config_index + 1;
			if (!(_config_index < _config_size)) {
				break;
			}
			_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _config_list, _config_index);
			config = (RygelConfiguration*) _tmp2_;
			_tmp3_ = rygel_configuration_get_interface (config, &_inner_error_);
			_tmp4_ = _tmp3_;
			if (_inner_error_ != NULL) {
				goto __catch8_g_error;
			}
			_tmp5_ = _tmp4_;
			_g_free0 (val);
			val = _tmp5_;
			unavailable = FALSE;
			_g_object_unref0 (config);
			break;
			goto __finally8;
			__catch8_g_error:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				_g_error_free0 (err);
			}
			__finally8:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (config);
				_g_object_unref0 (_config_list);
				_g_free0 (val);
				return NULL;
			}
			_g_object_unref0 (config);
		}
		_g_object_unref0 (_config_list);
	}
	if (unavailable) {
		const gchar* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		_tmp6_ = _ ("No value available");
		_tmp7_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp6_);
		_inner_error_ = _tmp7_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (val);
		return NULL;
	}
	result = val;
	return result;
}


static gint rygel_meta_config_real_get_port (RygelConfiguration* base, GError** error) {
	RygelMetaConfig * self;
	gint result = 0;
	gint val;
	gboolean unavailable;
	GError * _inner_error_ = NULL;
	self = (RygelMetaConfig*) base;
	val = 0;
	unavailable = TRUE;
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _config_list;
		gint _tmp1_;
		gint _config_size;
		gint _config_index;
		_tmp0_ = _g_object_ref0 (self->priv->configs);
		_config_list = _tmp0_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _config_list);
		_config_size = _tmp1_;
		_config_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			RygelConfiguration* config;
			gint _tmp3_;
			gint _tmp4_;
			_config_index = _config_index + 1;
			if (!(_config_index < _config_size)) {
				break;
			}
			_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _config_list, _config_index);
			config = (RygelConfiguration*) _tmp2_;
			_tmp3_ = rygel_configuration_get_port (config, &_inner_error_);
			_tmp4_ = _tmp3_;
			if (_inner_error_ != NULL) {
				goto __catch9_g_error;
			}
			val = _tmp4_;
			unavailable = FALSE;
			_g_object_unref0 (config);
			break;
			goto __finally9;
			__catch9_g_error:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				_g_error_free0 (err);
			}
			__finally9:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (config);
				_g_object_unref0 (_config_list);
				return 0;
			}
			_g_object_unref0 (config);
		}
		_g_object_unref0 (_config_list);
	}
	if (unavailable) {
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		_tmp5_ = _ ("No value available");
		_tmp6_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp5_);
		_inner_error_ = _tmp6_;
		g_propagate_error (error, _inner_error_);
		return 0;
	}
	result = val;
	return result;
}


static gboolean rygel_meta_config_real_get_transcoding (RygelConfiguration* base, GError** error) {
	RygelMetaConfig * self;
	gboolean result = FALSE;
	gboolean val;
	gboolean unavailable;
	GError * _inner_error_ = NULL;
	self = (RygelMetaConfig*) base;
	val = TRUE;
	unavailable = TRUE;
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _config_list;
		gint _tmp1_;
		gint _config_size;
		gint _config_index;
		_tmp0_ = _g_object_ref0 (self->priv->configs);
		_config_list = _tmp0_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _config_list);
		_config_size = _tmp1_;
		_config_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			RygelConfiguration* config;
			gboolean _tmp3_;
			gboolean _tmp4_;
			_config_index = _config_index + 1;
			if (!(_config_index < _config_size)) {
				break;
			}
			_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _config_list, _config_index);
			config = (RygelConfiguration*) _tmp2_;
			_tmp3_ = rygel_configuration_get_transcoding (config, &_inner_error_);
			_tmp4_ = _tmp3_;
			if (_inner_error_ != NULL) {
				goto __catch10_g_error;
			}
			val = _tmp4_;
			unavailable = FALSE;
			_g_object_unref0 (config);
			break;
			goto __finally10;
			__catch10_g_error:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				_g_error_free0 (err);
			}
			__finally10:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (config);
				_g_object_unref0 (_config_list);
				return FALSE;
			}
			_g_object_unref0 (config);
		}
		_g_object_unref0 (_config_list);
	}
	if (unavailable) {
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		_tmp5_ = _ ("No value available");
		_tmp6_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp5_);
		_inner_error_ = _tmp6_;
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = val;
	return result;
}


static gboolean rygel_meta_config_real_get_mp3_transcoder (RygelConfiguration* base, GError** error) {
	RygelMetaConfig * self;
	gboolean result = FALSE;
	gboolean val;
	gboolean unavailable;
	GError * _inner_error_ = NULL;
	self = (RygelMetaConfig*) base;
	val = TRUE;
	unavailable = TRUE;
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _config_list;
		gint _tmp1_;
		gint _config_size;
		gint _config_index;
		_tmp0_ = _g_object_ref0 (self->priv->configs);
		_config_list = _tmp0_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _config_list);
		_config_size = _tmp1_;
		_config_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			RygelConfiguration* config;
			gboolean _tmp3_;
			gboolean _tmp4_;
			_config_index = _config_index + 1;
			if (!(_config_index < _config_size)) {
				break;
			}
			_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _config_list, _config_index);
			config = (RygelConfiguration*) _tmp2_;
			_tmp3_ = rygel_configuration_get_mp3_transcoder (config, &_inner_error_);
			_tmp4_ = _tmp3_;
			if (_inner_error_ != NULL) {
				goto __catch11_g_error;
			}
			val = _tmp4_;
			unavailable = FALSE;
			_g_object_unref0 (config);
			break;
			goto __finally11;
			__catch11_g_error:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				_g_error_free0 (err);
			}
			__finally11:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (config);
				_g_object_unref0 (_config_list);
				return FALSE;
			}
			_g_object_unref0 (config);
		}
		_g_object_unref0 (_config_list);
	}
	if (unavailable) {
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		_tmp5_ = _ ("No value available");
		_tmp6_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp5_);
		_inner_error_ = _tmp6_;
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = val;
	return result;
}


static gboolean rygel_meta_config_real_get_mp2ts_transcoder (RygelConfiguration* base, GError** error) {
	RygelMetaConfig * self;
	gboolean result = FALSE;
	gboolean val;
	gboolean unavailable;
	GError * _inner_error_ = NULL;
	self = (RygelMetaConfig*) base;
	val = TRUE;
	unavailable = TRUE;
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _config_list;
		gint _tmp1_;
		gint _config_size;
		gint _config_index;
		_tmp0_ = _g_object_ref0 (self->priv->configs);
		_config_list = _tmp0_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _config_list);
		_config_size = _tmp1_;
		_config_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			RygelConfiguration* config;
			gboolean _tmp3_;
			gboolean _tmp4_;
			_config_index = _config_index + 1;
			if (!(_config_index < _config_size)) {
				break;
			}
			_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _config_list, _config_index);
			config = (RygelConfiguration*) _tmp2_;
			_tmp3_ = rygel_configuration_get_mp2ts_transcoder (config, &_inner_error_);
			_tmp4_ = _tmp3_;
			if (_inner_error_ != NULL) {
				goto __catch12_g_error;
			}
			val = _tmp4_;
			unavailable = FALSE;
			_g_object_unref0 (config);
			break;
			goto __finally12;
			__catch12_g_error:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				_g_error_free0 (err);
			}
			__finally12:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (config);
				_g_object_unref0 (_config_list);
				return FALSE;
			}
			_g_object_unref0 (config);
		}
		_g_object_unref0 (_config_list);
	}
	if (unavailable) {
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		_tmp5_ = _ ("No value available");
		_tmp6_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp5_);
		_inner_error_ = _tmp6_;
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = val;
	return result;
}


static gboolean rygel_meta_config_real_get_lpcm_transcoder (RygelConfiguration* base, GError** error) {
	RygelMetaConfig * self;
	gboolean result = FALSE;
	gboolean val;
	gboolean unavailable;
	GError * _inner_error_ = NULL;
	self = (RygelMetaConfig*) base;
	val = TRUE;
	unavailable = TRUE;
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _config_list;
		gint _tmp1_;
		gint _config_size;
		gint _config_index;
		_tmp0_ = _g_object_ref0 (self->priv->configs);
		_config_list = _tmp0_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _config_list);
		_config_size = _tmp1_;
		_config_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			RygelConfiguration* config;
			gboolean _tmp3_;
			gboolean _tmp4_;
			_config_index = _config_index + 1;
			if (!(_config_index < _config_size)) {
				break;
			}
			_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _config_list, _config_index);
			config = (RygelConfiguration*) _tmp2_;
			_tmp3_ = rygel_configuration_get_lpcm_transcoder (config, &_inner_error_);
			_tmp4_ = _tmp3_;
			if (_inner_error_ != NULL) {
				goto __catch13_g_error;
			}
			val = _tmp4_;
			unavailable = FALSE;
			_g_object_unref0 (config);
			break;
			goto __finally13;
			__catch13_g_error:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				_g_error_free0 (err);
			}
			__finally13:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (config);
				_g_object_unref0 (_config_list);
				return FALSE;
			}
			_g_object_unref0 (config);
		}
		_g_object_unref0 (_config_list);
	}
	if (unavailable) {
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		_tmp5_ = _ ("No value available");
		_tmp6_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp5_);
		_inner_error_ = _tmp6_;
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = val;
	return result;
}


static gboolean rygel_meta_config_real_get_wmv_transcoder (RygelConfiguration* base, GError** error) {
	RygelMetaConfig * self;
	gboolean result = FALSE;
	gboolean val;
	gboolean unavailable;
	GError * _inner_error_ = NULL;
	self = (RygelMetaConfig*) base;
	val = TRUE;
	unavailable = TRUE;
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _config_list;
		gint _tmp1_;
		gint _config_size;
		gint _config_index;
		_tmp0_ = _g_object_ref0 (self->priv->configs);
		_config_list = _tmp0_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _config_list);
		_config_size = _tmp1_;
		_config_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			RygelConfiguration* config;
			gboolean _tmp3_;
			gboolean _tmp4_;
			_config_index = _config_index + 1;
			if (!(_config_index < _config_size)) {
				break;
			}
			_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _config_list, _config_index);
			config = (RygelConfiguration*) _tmp2_;
			_tmp3_ = rygel_configuration_get_wmv_transcoder (config, &_inner_error_);
			_tmp4_ = _tmp3_;
			if (_inner_error_ != NULL) {
				goto __catch14_g_error;
			}
			val = _tmp4_;
			unavailable = FALSE;
			_g_object_unref0 (config);
			break;
			goto __finally14;
			__catch14_g_error:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				_g_error_free0 (err);
			}
			__finally14:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (config);
				_g_object_unref0 (_config_list);
				return FALSE;
			}
			_g_object_unref0 (config);
		}
		_g_object_unref0 (_config_list);
	}
	if (unavailable) {
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		_tmp5_ = _ ("No value available");
		_tmp6_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp5_);
		_inner_error_ = _tmp6_;
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = val;
	return result;
}


static gboolean rygel_meta_config_real_get_allow_upload (RygelConfiguration* base, GError** error) {
	RygelMetaConfig * self;
	gboolean result = FALSE;
	gboolean val;
	gboolean unavailable;
	GError * _inner_error_ = NULL;
	self = (RygelMetaConfig*) base;
	val = TRUE;
	unavailable = TRUE;
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _config_list;
		gint _tmp1_;
		gint _config_size;
		gint _config_index;
		_tmp0_ = _g_object_ref0 (self->priv->configs);
		_config_list = _tmp0_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _config_list);
		_config_size = _tmp1_;
		_config_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			RygelConfiguration* config;
			gboolean _tmp3_;
			gboolean _tmp4_;
			_config_index = _config_index + 1;
			if (!(_config_index < _config_size)) {
				break;
			}
			_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _config_list, _config_index);
			config = (RygelConfiguration*) _tmp2_;
			_tmp3_ = rygel_configuration_get_allow_upload (config, &_inner_error_);
			_tmp4_ = _tmp3_;
			if (_inner_error_ != NULL) {
				goto __catch15_g_error;
			}
			val = _tmp4_;
			unavailable = FALSE;
			_g_object_unref0 (config);
			break;
			goto __finally15;
			__catch15_g_error:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				_g_error_free0 (err);
			}
			__finally15:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (config);
				_g_object_unref0 (_config_list);
				return FALSE;
			}
			_g_object_unref0 (config);
		}
		_g_object_unref0 (_config_list);
	}
	if (unavailable) {
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		_tmp5_ = _ ("No value available");
		_tmp6_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp5_);
		_inner_error_ = _tmp6_;
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = val;
	return result;
}


static gboolean rygel_meta_config_real_get_allow_deletion (RygelConfiguration* base, GError** error) {
	RygelMetaConfig * self;
	gboolean result = FALSE;
	gboolean val;
	gboolean unavailable;
	GError * _inner_error_ = NULL;
	self = (RygelMetaConfig*) base;
	val = TRUE;
	unavailable = TRUE;
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _config_list;
		gint _tmp1_;
		gint _config_size;
		gint _config_index;
		_tmp0_ = _g_object_ref0 (self->priv->configs);
		_config_list = _tmp0_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _config_list);
		_config_size = _tmp1_;
		_config_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			RygelConfiguration* config;
			gboolean _tmp3_;
			gboolean _tmp4_;
			_config_index = _config_index + 1;
			if (!(_config_index < _config_size)) {
				break;
			}
			_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _config_list, _config_index);
			config = (RygelConfiguration*) _tmp2_;
			_tmp3_ = rygel_configuration_get_allow_deletion (config, &_inner_error_);
			_tmp4_ = _tmp3_;
			if (_inner_error_ != NULL) {
				goto __catch16_g_error;
			}
			val = _tmp4_;
			unavailable = FALSE;
			_g_object_unref0 (config);
			break;
			goto __finally16;
			__catch16_g_error:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				_g_error_free0 (err);
			}
			__finally16:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (config);
				_g_object_unref0 (_config_list);
				return FALSE;
			}
			_g_object_unref0 (config);
		}
		_g_object_unref0 (_config_list);
	}
	if (unavailable) {
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		_tmp5_ = _ ("No value available");
		_tmp6_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp5_);
		_inner_error_ = _tmp6_;
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = val;
	return result;
}


static RygelLogLevel rygel_meta_config_real_get_log_level (RygelConfiguration* base, GError** error) {
	RygelMetaConfig * self;
	RygelLogLevel result = 0;
	RygelLogLevel val;
	gboolean unavailable;
	GError * _inner_error_ = NULL;
	self = (RygelMetaConfig*) base;
	val = RYGEL_LOG_LEVEL_DEFAULT;
	unavailable = TRUE;
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _config_list;
		gint _tmp1_;
		gint _config_size;
		gint _config_index;
		_tmp0_ = _g_object_ref0 (self->priv->configs);
		_config_list = _tmp0_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _config_list);
		_config_size = _tmp1_;
		_config_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			RygelConfiguration* config;
			RygelLogLevel _tmp3_;
			RygelLogLevel _tmp4_;
			_config_index = _config_index + 1;
			if (!(_config_index < _config_size)) {
				break;
			}
			_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _config_list, _config_index);
			config = (RygelConfiguration*) _tmp2_;
			_tmp3_ = rygel_configuration_get_log_level (config, &_inner_error_);
			_tmp4_ = _tmp3_;
			if (_inner_error_ != NULL) {
				goto __catch17_g_error;
			}
			val = _tmp4_;
			unavailable = FALSE;
			_g_object_unref0 (config);
			break;
			goto __finally17;
			__catch17_g_error:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				_g_error_free0 (err);
			}
			__finally17:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (config);
				_g_object_unref0 (_config_list);
				return 0;
			}
			_g_object_unref0 (config);
		}
		_g_object_unref0 (_config_list);
	}
	if (unavailable) {
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		_tmp5_ = _ ("No value available");
		_tmp6_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp5_);
		_inner_error_ = _tmp6_;
		g_propagate_error (error, _inner_error_);
		return 0;
	}
	result = val;
	return result;
}


static gchar* rygel_meta_config_real_get_plugin_path (RygelConfiguration* base, GError** error) {
	RygelMetaConfig * self;
	gchar* result = NULL;
	gchar* val;
	gboolean unavailable;
	GError * _inner_error_ = NULL;
	self = (RygelMetaConfig*) base;
	val = NULL;
	unavailable = TRUE;
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _config_list;
		gint _tmp1_;
		gint _config_size;
		gint _config_index;
		_tmp0_ = _g_object_ref0 (self->priv->configs);
		_config_list = _tmp0_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _config_list);
		_config_size = _tmp1_;
		_config_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			RygelConfiguration* config;
			gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			gchar* _tmp5_;
			_config_index = _config_index + 1;
			if (!(_config_index < _config_size)) {
				break;
			}
			_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _config_list, _config_index);
			config = (RygelConfiguration*) _tmp2_;
			_tmp3_ = rygel_configuration_get_plugin_path (config, &_inner_error_);
			_tmp4_ = _tmp3_;
			if (_inner_error_ != NULL) {
				goto __catch18_g_error;
			}
			_tmp5_ = _tmp4_;
			_g_free0 (val);
			val = _tmp5_;
			unavailable = FALSE;
			_g_object_unref0 (config);
			break;
			goto __finally18;
			__catch18_g_error:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				_g_error_free0 (err);
			}
			__finally18:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (config);
				_g_object_unref0 (_config_list);
				_g_free0 (val);
				return NULL;
			}
			_g_object_unref0 (config);
		}
		_g_object_unref0 (_config_list);
	}
	if (unavailable) {
		GError* _tmp6_ = NULL;
		_tmp6_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, "No value available");
		_inner_error_ = _tmp6_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (val);
		return NULL;
	}
	result = val;
	return result;
}


static gboolean rygel_meta_config_real_get_enabled (RygelConfiguration* base, const gchar* section, GError** error) {
	RygelMetaConfig * self;
	gboolean result = FALSE;
	gboolean val;
	gboolean unavailable;
	GError * _inner_error_ = NULL;
	self = (RygelMetaConfig*) base;
	g_return_val_if_fail (section != NULL, FALSE);
	val = TRUE;
	unavailable = TRUE;
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _config_list;
		gint _tmp1_;
		gint _config_size;
		gint _config_index;
		_tmp0_ = _g_object_ref0 (self->priv->configs);
		_config_list = _tmp0_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _config_list);
		_config_size = _tmp1_;
		_config_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			RygelConfiguration* config;
			gboolean _tmp3_;
			gboolean _tmp4_;
			_config_index = _config_index + 1;
			if (!(_config_index < _config_size)) {
				break;
			}
			_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _config_list, _config_index);
			config = (RygelConfiguration*) _tmp2_;
			_tmp3_ = rygel_configuration_get_enabled (config, section, &_inner_error_);
			_tmp4_ = _tmp3_;
			if (_inner_error_ != NULL) {
				goto __catch19_g_error;
			}
			val = _tmp4_;
			unavailable = FALSE;
			_g_object_unref0 (config);
			break;
			goto __finally19;
			__catch19_g_error:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				_g_error_free0 (err);
			}
			__finally19:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (config);
				_g_object_unref0 (_config_list);
				return FALSE;
			}
			_g_object_unref0 (config);
		}
		_g_object_unref0 (_config_list);
	}
	if (unavailable) {
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		_tmp5_ = _ ("No value set for '%s/enabled'");
		_tmp6_ = g_error_new (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp5_, section);
		_inner_error_ = _tmp6_;
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = val;
	return result;
}


static gchar* rygel_meta_config_real_get_title (RygelConfiguration* base, const gchar* section, GError** error) {
	RygelMetaConfig * self;
	gchar* result = NULL;
	gchar* val;
	GError * _inner_error_ = NULL;
	self = (RygelMetaConfig*) base;
	g_return_val_if_fail (section != NULL, NULL);
	val = NULL;
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _config_list;
		gint _tmp1_;
		gint _config_size;
		gint _config_index;
		_tmp0_ = _g_object_ref0 (self->priv->configs);
		_config_list = _tmp0_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _config_list);
		_config_size = _tmp1_;
		_config_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			RygelConfiguration* config;
			gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			gchar* _tmp5_;
			_config_index = _config_index + 1;
			if (!(_config_index < _config_size)) {
				break;
			}
			_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _config_list, _config_index);
			config = (RygelConfiguration*) _tmp2_;
			_tmp3_ = rygel_configuration_get_title (config, section, &_inner_error_);
			_tmp4_ = _tmp3_;
			if (_inner_error_ != NULL) {
				goto __catch20_g_error;
			}
			_tmp5_ = _tmp4_;
			_g_free0 (val);
			val = _tmp5_;
			_g_object_unref0 (config);
			break;
			goto __finally20;
			__catch20_g_error:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				_g_error_free0 (err);
			}
			__finally20:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (config);
				_g_object_unref0 (_config_list);
				_g_free0 (val);
				return NULL;
			}
			_g_object_unref0 (config);
		}
		_g_object_unref0 (_config_list);
	}
	if (val == NULL) {
		const gchar* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		_tmp6_ = _ ("No value set for '%s/enabled'");
		_tmp7_ = g_error_new (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp6_, section);
		_inner_error_ = _tmp7_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (val);
		return NULL;
	}
	result = val;
	return result;
}


static gchar* rygel_meta_config_real_get_string (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error) {
	RygelMetaConfig * self;
	gchar* result = NULL;
	gchar* val;
	GError * _inner_error_ = NULL;
	self = (RygelMetaConfig*) base;
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	val = NULL;
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _config_list;
		gint _tmp1_;
		gint _config_size;
		gint _config_index;
		_tmp0_ = _g_object_ref0 (self->priv->configs);
		_config_list = _tmp0_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _config_list);
		_config_size = _tmp1_;
		_config_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			RygelConfiguration* config;
			gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			gchar* _tmp5_;
			_config_index = _config_index + 1;
			if (!(_config_index < _config_size)) {
				break;
			}
			_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _config_list, _config_index);
			config = (RygelConfiguration*) _tmp2_;
			_tmp3_ = rygel_configuration_get_string (config, section, key, &_inner_error_);
			_tmp4_ = _tmp3_;
			if (_inner_error_ != NULL) {
				goto __catch21_g_error;
			}
			_tmp5_ = _tmp4_;
			_g_free0 (val);
			val = _tmp5_;
			_g_object_unref0 (config);
			break;
			goto __finally21;
			__catch21_g_error:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				_g_error_free0 (err);
			}
			__finally21:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (config);
				_g_object_unref0 (_config_list);
				_g_free0 (val);
				return NULL;
			}
			_g_object_unref0 (config);
		}
		_g_object_unref0 (_config_list);
	}
	if (val == NULL) {
		const gchar* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		_tmp6_ = _ ("No value available for '%s/%s'");
		_tmp7_ = g_error_new (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp6_, section, key);
		_inner_error_ = _tmp7_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (val);
		return NULL;
	}
	result = val;
	return result;
}


static GeeArrayList* rygel_meta_config_real_get_string_list (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error) {
	RygelMetaConfig * self;
	GeeArrayList* result = NULL;
	GeeArrayList* val;
	GError * _inner_error_ = NULL;
	self = (RygelMetaConfig*) base;
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	val = NULL;
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _config_list;
		gint _tmp1_;
		gint _config_size;
		gint _config_index;
		_tmp0_ = _g_object_ref0 (self->priv->configs);
		_config_list = _tmp0_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _config_list);
		_config_size = _tmp1_;
		_config_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			RygelConfiguration* config;
			GeeArrayList* _tmp3_ = NULL;
			GeeArrayList* _tmp4_;
			GeeArrayList* _tmp5_;
			_config_index = _config_index + 1;
			if (!(_config_index < _config_size)) {
				break;
			}
			_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _config_list, _config_index);
			config = (RygelConfiguration*) _tmp2_;
			_tmp3_ = rygel_configuration_get_string_list (config, section, key, &_inner_error_);
			_tmp4_ = _tmp3_;
			if (_inner_error_ != NULL) {
				goto __catch22_g_error;
			}
			_tmp5_ = _tmp4_;
			_g_object_unref0 (val);
			val = _tmp5_;
			_g_object_unref0 (config);
			break;
			goto __finally22;
			__catch22_g_error:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				_g_error_free0 (err);
			}
			__finally22:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (config);
				_g_object_unref0 (_config_list);
				_g_object_unref0 (val);
				return NULL;
			}
			_g_object_unref0 (config);
		}
		_g_object_unref0 (_config_list);
	}
	if (val == NULL) {
		const gchar* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		_tmp6_ = _ ("No value available for '%s/%s'");
		_tmp7_ = g_error_new (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp6_, section, key);
		_inner_error_ = _tmp7_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (val);
		return NULL;
	}
	result = val;
	return result;
}


static gint rygel_meta_config_real_get_int (RygelConfiguration* base, const gchar* section, const gchar* key, gint min, gint max, GError** error) {
	RygelMetaConfig * self;
	gint result = 0;
	gint val;
	gboolean unavailable;
	GError * _inner_error_ = NULL;
	self = (RygelMetaConfig*) base;
	g_return_val_if_fail (section != NULL, 0);
	g_return_val_if_fail (key != NULL, 0);
	val = 0;
	unavailable = TRUE;
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _config_list;
		gint _tmp1_;
		gint _config_size;
		gint _config_index;
		_tmp0_ = _g_object_ref0 (self->priv->configs);
		_config_list = _tmp0_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _config_list);
		_config_size = _tmp1_;
		_config_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			RygelConfiguration* config;
			gint _tmp3_;
			gint _tmp4_;
			_config_index = _config_index + 1;
			if (!(_config_index < _config_size)) {
				break;
			}
			_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _config_list, _config_index);
			config = (RygelConfiguration*) _tmp2_;
			_tmp3_ = rygel_configuration_get_int (config, section, key, min, max, &_inner_error_);
			_tmp4_ = _tmp3_;
			if (_inner_error_ != NULL) {
				goto __catch23_g_error;
			}
			val = _tmp4_;
			unavailable = FALSE;
			_g_object_unref0 (config);
			break;
			goto __finally23;
			__catch23_g_error:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				_g_error_free0 (err);
			}
			__finally23:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (config);
				_g_object_unref0 (_config_list);
				return 0;
			}
			_g_object_unref0 (config);
		}
		_g_object_unref0 (_config_list);
	}
	if (unavailable) {
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		_tmp5_ = _ ("No value available for '%s/%s'");
		_tmp6_ = g_error_new (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp5_, section, key);
		_inner_error_ = _tmp6_;
		g_propagate_error (error, _inner_error_);
		return 0;
	}
	result = val;
	return result;
}


static GeeArrayList* rygel_meta_config_real_get_int_list (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error) {
	RygelMetaConfig * self;
	GeeArrayList* result = NULL;
	GeeArrayList* val;
	GError * _inner_error_ = NULL;
	self = (RygelMetaConfig*) base;
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	val = NULL;
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _config_list;
		gint _tmp1_;
		gint _config_size;
		gint _config_index;
		_tmp0_ = _g_object_ref0 (self->priv->configs);
		_config_list = _tmp0_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _config_list);
		_config_size = _tmp1_;
		_config_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			RygelConfiguration* config;
			GeeArrayList* _tmp3_ = NULL;
			GeeArrayList* _tmp4_;
			GeeArrayList* _tmp5_;
			_config_index = _config_index + 1;
			if (!(_config_index < _config_size)) {
				break;
			}
			_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _config_list, _config_index);
			config = (RygelConfiguration*) _tmp2_;
			_tmp3_ = rygel_configuration_get_int_list (config, section, key, &_inner_error_);
			_tmp4_ = _tmp3_;
			if (_inner_error_ != NULL) {
				goto __catch24_g_error;
			}
			_tmp5_ = _tmp4_;
			_g_object_unref0 (val);
			val = _tmp5_;
			_g_object_unref0 (config);
			break;
			goto __finally24;
			__catch24_g_error:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				_g_error_free0 (err);
			}
			__finally24:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (config);
				_g_object_unref0 (_config_list);
				_g_object_unref0 (val);
				return NULL;
			}
			_g_object_unref0 (config);
		}
		_g_object_unref0 (_config_list);
	}
	if (val == NULL) {
		const gchar* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		_tmp6_ = _ ("No value available for '%s/%s'");
		_tmp7_ = g_error_new (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp6_, section, key);
		_inner_error_ = _tmp7_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (val);
		return NULL;
	}
	result = val;
	return result;
}


static gboolean rygel_meta_config_real_get_bool (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error) {
	RygelMetaConfig * self;
	gboolean result = FALSE;
	gboolean val;
	gboolean unavailable;
	GError * _inner_error_ = NULL;
	self = (RygelMetaConfig*) base;
	g_return_val_if_fail (section != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	val = FALSE;
	unavailable = TRUE;
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _config_list;
		gint _tmp1_;
		gint _config_size;
		gint _config_index;
		_tmp0_ = _g_object_ref0 (self->priv->configs);
		_config_list = _tmp0_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _config_list);
		_config_size = _tmp1_;
		_config_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			RygelConfiguration* config;
			gboolean _tmp3_;
			gboolean _tmp4_;
			_config_index = _config_index + 1;
			if (!(_config_index < _config_size)) {
				break;
			}
			_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _config_list, _config_index);
			config = (RygelConfiguration*) _tmp2_;
			_tmp3_ = rygel_configuration_get_bool (config, section, key, &_inner_error_);
			_tmp4_ = _tmp3_;
			if (_inner_error_ != NULL) {
				goto __catch25_g_error;
			}
			val = _tmp4_;
			unavailable = FALSE;
			_g_object_unref0 (config);
			break;
			goto __finally25;
			__catch25_g_error:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				_g_error_free0 (err);
			}
			__finally25:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (config);
				_g_object_unref0 (_config_list);
				return FALSE;
			}
			_g_object_unref0 (config);
		}
		_g_object_unref0 (_config_list);
	}
	if (unavailable) {
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		_tmp5_ = _ ("No value available for '%s/%s'");
		_tmp6_ = g_error_new (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _tmp5_, section, key);
		_inner_error_ = _tmp6_;
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = val;
	return result;
}


static void rygel_meta_config_class_init (RygelMetaConfigClass * klass) {
	rygel_meta_config_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMetaConfigPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_meta_config_finalize;
}


static void rygel_meta_config_rygel_configuration_interface_init (RygelConfigurationIface * iface) {
	rygel_meta_config_rygel_configuration_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_upnp_enabled = (gboolean (*)(RygelConfiguration* ,GError**)) rygel_meta_config_real_get_upnp_enabled;
	iface->get_interface = (gchar* (*)(RygelConfiguration* ,GError**)) rygel_meta_config_real_get_interface;
	iface->get_port = (gint (*)(RygelConfiguration* ,GError**)) rygel_meta_config_real_get_port;
	iface->get_transcoding = (gboolean (*)(RygelConfiguration* ,GError**)) rygel_meta_config_real_get_transcoding;
	iface->get_mp3_transcoder = (gboolean (*)(RygelConfiguration* ,GError**)) rygel_meta_config_real_get_mp3_transcoder;
	iface->get_mp2ts_transcoder = (gboolean (*)(RygelConfiguration* ,GError**)) rygel_meta_config_real_get_mp2ts_transcoder;
	iface->get_lpcm_transcoder = (gboolean (*)(RygelConfiguration* ,GError**)) rygel_meta_config_real_get_lpcm_transcoder;
	iface->get_wmv_transcoder = (gboolean (*)(RygelConfiguration* ,GError**)) rygel_meta_config_real_get_wmv_transcoder;
	iface->get_allow_upload = (gboolean (*)(RygelConfiguration* ,GError**)) rygel_meta_config_real_get_allow_upload;
	iface->get_allow_deletion = (gboolean (*)(RygelConfiguration* ,GError**)) rygel_meta_config_real_get_allow_deletion;
	iface->get_log_level = (RygelLogLevel (*)(RygelConfiguration* ,GError**)) rygel_meta_config_real_get_log_level;
	iface->get_plugin_path = (gchar* (*)(RygelConfiguration* ,GError**)) rygel_meta_config_real_get_plugin_path;
	iface->get_enabled = (gboolean (*)(RygelConfiguration* ,const gchar* ,GError**)) rygel_meta_config_real_get_enabled;
	iface->get_title = (gchar* (*)(RygelConfiguration* ,const gchar* ,GError**)) rygel_meta_config_real_get_title;
	iface->get_string = (gchar* (*)(RygelConfiguration* ,const gchar* ,const gchar* ,GError**)) rygel_meta_config_real_get_string;
	iface->get_string_list = (GeeArrayList* (*)(RygelConfiguration* ,const gchar* ,const gchar* ,GError**)) rygel_meta_config_real_get_string_list;
	iface->get_int = (gint (*)(RygelConfiguration* ,const gchar* ,const gchar* ,gint ,gint ,GError**)) rygel_meta_config_real_get_int;
	iface->get_int_list = (GeeArrayList* (*)(RygelConfiguration* ,const gchar* ,const gchar* ,GError**)) rygel_meta_config_real_get_int_list;
	iface->get_bool = (gboolean (*)(RygelConfiguration* ,const gchar* ,const gchar* ,GError**)) rygel_meta_config_real_get_bool;
}


static void rygel_meta_config_instance_init (RygelMetaConfig * self) {
	self->priv = RYGEL_META_CONFIG_GET_PRIVATE (self);
}


static void rygel_meta_config_finalize (GObject* obj) {
	RygelMetaConfig * self;
	self = RYGEL_META_CONFIG (obj);
	_g_object_unref0 (self->priv->configs);
	G_OBJECT_CLASS (rygel_meta_config_parent_class)->finalize (obj);
}


/**
 * Manages all the configuration sources for Rygel.
 *
 * Abstracts Rygel and it's plugins from Configuration implementations. It keeps
 * all real configuration sources in a list and returns the value provided by
 * the first one. If none of them provides the value, it emits an error.
 */
GType rygel_meta_config_get_type (void) {
	static volatile gsize rygel_meta_config_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_meta_config_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMetaConfigClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_meta_config_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMetaConfig), 0, (GInstanceInitFunc) rygel_meta_config_instance_init, NULL };
		static const GInterfaceInfo rygel_configuration_info = { (GInterfaceInitFunc) rygel_meta_config_rygel_configuration_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_meta_config_type_id;
		rygel_meta_config_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMetaConfig", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_meta_config_type_id, RYGEL_TYPE_CONFIGURATION, &rygel_configuration_info);
		g_once_init_leave (&rygel_meta_config_type_id__volatile, rygel_meta_config_type_id);
	}
	return rygel_meta_config_type_id__volatile;
}



