/* rygel-media-export-root-container.c generated by valac 0.11.3, the Vala compiler
 * generated from rygel-media-export-root-container.vala, do not modify */

/*
 * Copyright (C) 2009,2010 Jens Georg <mail@jensge.org>.
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <rygel.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_MEDIA_EXPORT_TYPE_FOLDER_DEFINITION (rygel_media_export_folder_definition_get_type ())
typedef struct _RygelMediaExportFolderDefinition RygelMediaExportFolderDefinition;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER (rygel_media_export_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainer))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))

typedef struct _RygelMediaExportDBContainer RygelMediaExportDBContainer;
typedef struct _RygelMediaExportDBContainerClass RygelMediaExportDBContainerClass;
typedef struct _RygelMediaExportDBContainerPrivate RygelMediaExportDBContainerPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;

#define RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER (rygel_media_export_root_container_get_type ())
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, RygelMediaExportRootContainer))
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, RygelMediaExportRootContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_ROOT_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_ROOT_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER))
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, RygelMediaExportRootContainerClass))

typedef struct _RygelMediaExportRootContainer RygelMediaExportRootContainer;
typedef struct _RygelMediaExportRootContainerClass RygelMediaExportRootContainerClass;
typedef struct _RygelMediaExportRootContainerPrivate RygelMediaExportRootContainerPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_DBUS_SERVICE (rygel_media_export_dbus_service_get_type ())
#define RYGEL_MEDIA_EXPORT_DBUS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DBUS_SERVICE, RygelMediaExportDBusService))
#define RYGEL_MEDIA_EXPORT_DBUS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DBUS_SERVICE, RygelMediaExportDBusServiceClass))
#define RYGEL_MEDIA_EXPORT_IS_DBUS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DBUS_SERVICE))
#define RYGEL_MEDIA_EXPORT_IS_DBUS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DBUS_SERVICE))
#define RYGEL_MEDIA_EXPORT_DBUS_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DBUS_SERVICE, RygelMediaExportDBusServiceClass))

typedef struct _RygelMediaExportDBusService RygelMediaExportDBusService;
typedef struct _RygelMediaExportDBusServiceClass RygelMediaExportDBusServiceClass;

#define RYGEL_MEDIA_EXPORT_TYPE_HARVESTER (rygel_media_export_harvester_get_type ())
#define RYGEL_MEDIA_EXPORT_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvester))
#define RYGEL_MEDIA_EXPORT_HARVESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterClass))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER))
#define RYGEL_MEDIA_EXPORT_HARVESTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterClass))

typedef struct _RygelMediaExportHarvester RygelMediaExportHarvester;
typedef struct _RygelMediaExportHarvesterClass RygelMediaExportHarvesterClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_NULL_CONTAINER (rygel_null_container_get_type ())
#define RYGEL_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainer))
#define RYGEL_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))
#define RYGEL_IS_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_IS_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_NULL_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))

typedef struct _RygelNullContainer RygelNullContainer;
typedef struct _RygelNullContainerClass RygelNullContainerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER (rygel_media_export_query_container_get_type ())
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainer))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainerClass))

typedef struct _RygelMediaExportQueryContainer RygelMediaExportQueryContainer;
typedef struct _RygelMediaExportQueryContainerClass RygelMediaExportQueryContainerClass;
typedef struct _RygelMediaExportRootContainerFindObjectData RygelMediaExportRootContainerFindObjectData;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
typedef struct _RygelMediaExportRootContainerSearchData RygelMediaExportRootContainerSearchData;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _RygelMediaExportQueryContainerPrivate RygelMediaExportQueryContainerPrivate;

struct _RygelMediaExportFolderDefinition {
	gchar* title;
	gchar* definition;
};

struct _RygelMediaExportDBContainer {
	RygelMediaContainer parent_instance;
	RygelMediaExportDBContainerPrivate * priv;
	RygelMediaExportMediaCache* media_db;
};

struct _RygelMediaExportDBContainerClass {
	RygelMediaContainerClass parent_class;
	void (*search) (RygelMediaExportDBContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelMediaExportDBContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
};

struct _RygelMediaExportRootContainer {
	RygelMediaExportDBContainer parent_instance;
	RygelMediaExportRootContainerPrivate * priv;
};

struct _RygelMediaExportRootContainerClass {
	RygelMediaExportDBContainerClass parent_class;
};

struct _RygelMediaExportRootContainerPrivate {
	RygelMediaExportDBusService* service;
	RygelMediaExportHarvester* harvester;
	GCancellable* cancellable;
	RygelMediaContainer* filesystem_container;
};

typedef enum  {
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_IO_ERROR,
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR
} RygelMediaExportDatabaseError;
#define RYGEL_MEDIA_EXPORT_DATABASE_ERROR rygel_media_export_database_error_quark ()
struct _RygelMediaExportRootContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaExportRootContainer* self;
	gchar* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	RygelMediaObject* _tmp0_;
	RygelMediaObject* object;
	gboolean _tmp1_;
	gboolean _tmp2_;
	RygelMediaExportQueryContainer* _tmp3_;
	RygelMediaExportQueryContainer* container;
	GError * _inner_error_;
};

struct _RygelMediaExportRootContainerSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaExportRootContainer* self;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	guint _tmp0_;
	RygelMediaObjects* _tmp1_;
	RygelMediaObjects* _tmp2_;
	RygelMediaObjects* list;
	RygelMediaContainer* query_container;
	gchar* upnp_class;
	RygelSearchExpression* _tmp3_;
	RygelRelationalExpression* _tmp4_;
	RygelRelationalExpression* relational_expression;
	RygelMediaExportQueryContainer* _tmp5_;
	RygelMediaContainer* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	RygelMediaContainer* _tmp9_;
	gboolean _tmp10_;
	RygelMediaObjects* _tmp11_;
	RygelMediaObjects* _tmp12_;
	RygelMediaObjects* _tmp13_;
	RygelMediaObjects* _tmp14_;
	RygelMediaObjects* _object_list;
	gint _tmp15_;
	gint _object_size;
	gint _object_index;
	gpointer _tmp16_;
	RygelMediaObject* object;
	gchar* _tmp17_;
	gchar* _tmp18_;
	guint _tmp19_;
	RygelMediaObjects* _tmp20_;
	RygelMediaObjects* _tmp21_;
	GError * _inner_error_;
};

struct _RygelMediaExportQueryContainer {
	RygelMediaExportDBContainer parent_instance;
	RygelMediaExportQueryContainerPrivate * priv;
	gchar* plaintext_id;
};

struct _RygelMediaExportQueryContainerClass {
	RygelMediaExportDBContainerClass parent_class;
};


static gpointer rygel_media_export_root_container_parent_class = NULL;
static RygelMediaContainer* rygel_media_export_root_container_instance;
static RygelMediaContainer* rygel_media_export_root_container_instance = NULL;
static GError* rygel_media_export_root_container_creation_error;
static GError* rygel_media_export_root_container_creation_error = NULL;

GType rygel_media_export_folder_definition_get_type (void) G_GNUC_CONST;
RygelMediaExportFolderDefinition* rygel_media_export_folder_definition_dup (const RygelMediaExportFolderDefinition* self);
void rygel_media_export_folder_definition_free (RygelMediaExportFolderDefinition* self);
void rygel_media_export_folder_definition_copy (const RygelMediaExportFolderDefinition* self, RygelMediaExportFolderDefinition* dest);
void rygel_media_export_folder_definition_destroy (RygelMediaExportFolderDefinition* self);
GType rygel_media_export_db_container_get_type (void) G_GNUC_CONST;
GType rygel_media_export_media_cache_get_type (void) G_GNUC_CONST;
GType rygel_media_export_root_container_get_type (void) G_GNUC_CONST;
GType rygel_media_export_dbus_service_get_type (void) G_GNUC_CONST;
guint rygel_media_export_dbus_service_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType rygel_media_export_harvester_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, RygelMediaExportRootContainerPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_DUMMY_PROPERTY
};
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_NAME "Files & Folders"
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID "Filesystem"
RygelMediaContainer* rygel_media_export_root_container_get_instance (GError** error);
static RygelMediaExportRootContainer* rygel_media_export_root_container_new (GError** error);
static RygelMediaExportRootContainer* rygel_media_export_root_container_construct (GType object_type, GError** error);
RygelNullContainer* rygel_null_container_new (void);
RygelNullContainer* rygel_null_container_construct (GType object_type);
GType rygel_null_container_get_type (void) G_GNUC_CONST;
void rygel_media_export_root_container_shutdown (RygelMediaExportRootContainer* self);
void rygel_media_export_root_container_add_uri (RygelMediaExportRootContainer* self, const gchar* uri);
void rygel_media_export_harvester_schedule (RygelMediaExportHarvester* self, GFile* file, RygelMediaContainer* parent, const gchar* flag);
void rygel_media_export_root_container_remove_uri (RygelMediaExportRootContainer* self, const gchar* uri);
gchar* rygel_media_export_media_cache_get_id (GFile* file);
void rygel_media_export_harvester_cancel (RygelMediaExportHarvester* self, GFile* file);
GQuark rygel_media_export_database_error_quark (void);
void rygel_media_export_media_cache_remove_by_id (RygelMediaExportMediaCache* self, const gchar* id, GError** error);
gchar** rygel_media_export_root_container_get_dynamic_uris (RygelMediaExportRootContainer* self, int* result_length1);
GeeList* rygel_media_export_media_cache_get_flagged_uris (RygelMediaExportMediaCache* self, const gchar* flag, GError** error);
static void rygel_media_export_root_container_real_find_object_data_free (gpointer _data);
static void rygel_media_export_root_container_real_find_object (RygelMediaContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_media_export_root_container_real_find_object_co (RygelMediaExportRootContainerFindObjectData* data);
static void rygel_media_export_root_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX "virtual-container:"
RygelMediaExportQueryContainer* rygel_media_export_query_container_new (RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* name);
RygelMediaExportQueryContainer* rygel_media_export_query_container_construct (GType object_type, RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* name);
GType rygel_media_export_query_container_get_type (void) G_GNUC_CONST;
static void rygel_media_export_root_container_real_search_data_free (gpointer _data);
static void rygel_media_export_root_container_real_search (RygelMediaExportDBContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_media_export_root_container_real_search_co (RygelMediaExportRootContainerSearchData* data);
void rygel_media_export_db_container_search (RygelMediaExportDBContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_media_export_db_container_search_finish (RygelMediaExportDBContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static void rygel_media_export_root_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static RygelMediaExportQueryContainer* rygel_media_export_root_container_search_to_virtual_container (RygelMediaExportRootContainer* self, RygelRelationalExpression* expression);
static gboolean rygel_media_export_root_container_is_search_in_virtual_container (RygelMediaExportRootContainer* self, RygelSearchExpression* expression, RygelMediaContainer** container);
static GeeArrayList* rygel_media_export_root_container_get_uris (RygelMediaExportRootContainer* self);
void rygel_media_export_query_container_register_id (gchar** id);
RygelMediaExportMediaCache* rygel_media_export_media_cache_get_default (GError** error);
RygelMediaExportDBContainer* rygel_media_export_db_container_new (RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* title);
RygelMediaExportDBContainer* rygel_media_export_db_container_construct (GType object_type, RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* title);
RygelMediaExportHarvester* rygel_media_export_harvester_new (GCancellable* cancellable);
RygelMediaExportHarvester* rygel_media_export_harvester_construct (GType object_type, GCancellable* cancellable);
RygelMediaExportDBusService* rygel_media_export_dbus_service_new (RygelMediaExportRootContainer* root_container, GError** error);
RygelMediaExportDBusService* rygel_media_export_dbus_service_construct (GType object_type, RygelMediaExportRootContainer* root_container, GError** error);
void rygel_media_export_media_cache_save_container (RygelMediaExportMediaCache* self, RygelMediaContainer* container, GError** error);
GeeArrayList* rygel_media_export_media_cache_get_child_ids (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error);
static void rygel_media_export_root_container_add_default_virtual_folders (RygelMediaExportRootContainer* self);
static void rygel_media_export_root_container_add_virtual_containers_for_class (RygelMediaExportRootContainer* self, const gchar* parent, const gchar* item_class, RygelMediaExportFolderDefinition* definitions, int definitions_length1, GError** error);
static void rygel_media_export_root_container_add_folder_definition (RygelMediaExportRootContainer* self, RygelMediaContainer* container, const gchar* item_class, RygelMediaExportFolderDefinition* definition, GError** error);
static void rygel_media_export_root_container_finalize (GObject* obj);

const RygelMediaExportFolderDefinition virtual_folders_default[2] = {{"Year", "dc:date,?"}, {"All", ""}};
const RygelMediaExportFolderDefinition virtual_folders_music[3] = {{"Artist", "upnp:artist,?,upnp:album,?"}, {"Album", "upnp:album,?"}, {"Genre", "dc:genre,?"}};

void rygel_media_export_folder_definition_copy (const RygelMediaExportFolderDefinition* self, RygelMediaExportFolderDefinition* dest) {
	dest->title = g_strdup (self->title);
	dest->definition = g_strdup (self->definition);
}


void rygel_media_export_folder_definition_destroy (RygelMediaExportFolderDefinition* self) {
	_g_free0 (self->title);
	_g_free0 (self->definition);
}


RygelMediaExportFolderDefinition* rygel_media_export_folder_definition_dup (const RygelMediaExportFolderDefinition* self) {
	RygelMediaExportFolderDefinition* dup;
	dup = g_new0 (RygelMediaExportFolderDefinition, 1);
	rygel_media_export_folder_definition_copy (self, dup);
	return dup;
}


void rygel_media_export_folder_definition_free (RygelMediaExportFolderDefinition* self) {
	rygel_media_export_folder_definition_destroy (self);
	g_free (self);
}


GType rygel_media_export_folder_definition_get_type (void) {
	static volatile gsize rygel_media_export_folder_definition_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_folder_definition_type_id__volatile)) {
		GType rygel_media_export_folder_definition_type_id;
		rygel_media_export_folder_definition_type_id = g_boxed_type_register_static ("RygelMediaExportFolderDefinition", (GBoxedCopyFunc) rygel_media_export_folder_definition_dup, (GBoxedFreeFunc) rygel_media_export_folder_definition_free);
		g_once_init_leave (&rygel_media_export_folder_definition_type_id__volatile, rygel_media_export_folder_definition_type_id);
	}
	return rygel_media_export_folder_definition_type_id__volatile;
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelMediaContainer* rygel_media_export_root_container_get_instance (GError** error) {
	RygelMediaContainer* result = NULL;
	RygelMediaContainer* _tmp8_;
	GError * _inner_error_ = NULL;
	if (rygel_media_export_root_container_instance == NULL) {
		RygelMediaExportRootContainer* _tmp0_ = NULL;
		RygelMediaExportRootContainer* _tmp1_;
		RygelMediaContainer* _tmp2_;
		_tmp0_ = rygel_media_export_root_container_new (&_inner_error_);
		_tmp1_ = _tmp0_;
		if (_inner_error_ != NULL) {
			goto __catch24_g_error;
		}
		_tmp2_ = (RygelMediaContainer*) _tmp1_;
		_g_object_unref0 (rygel_media_export_root_container_instance);
		rygel_media_export_root_container_instance = _tmp2_;
		goto __finally24;
		__catch24_g_error:
		{
			GError * _error_;
			RygelNullContainer* _tmp3_ = NULL;
			RygelMediaContainer* _tmp4_;
			GError* _tmp5_;
			GError* _tmp6_;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			_tmp3_ = rygel_null_container_new ();
			_tmp4_ = (RygelMediaContainer*) _tmp3_;
			_g_object_unref0 (rygel_media_export_root_container_instance);
			rygel_media_export_root_container_instance = _tmp4_;
			_tmp5_ = _g_error_copy0 (_error_);
			_tmp6_ = _tmp5_;
			_g_error_free0 (rygel_media_export_root_container_creation_error);
			rygel_media_export_root_container_creation_error = _tmp6_;
			_g_error_free0 (_error_);
		}
		__finally24:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
	} else {
		if (rygel_media_export_root_container_creation_error != NULL) {
			GError* _tmp7_;
			_tmp7_ = _g_error_copy0 (rygel_media_export_root_container_creation_error);
			_inner_error_ = _tmp7_;
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
	}
	_tmp8_ = _g_object_ref0 (rygel_media_export_root_container_instance);
	result = _tmp8_;
	return result;
}


void rygel_media_export_root_container_shutdown (RygelMediaExportRootContainer* self) {
	g_return_if_fail (self != NULL);
	g_cancellable_cancel (self->priv->cancellable);
}


void rygel_media_export_root_container_add_uri (RygelMediaExportRootContainer* self, const gchar* uri) {
	GFile* _tmp0_ = NULL;
	GFile* file;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = g_file_new_for_commandline_arg (uri);
	file = _tmp0_;
	rygel_media_export_harvester_schedule (self->priv->harvester, file, self->priv->filesystem_container, "DBUS");
	_g_object_unref0 (file);
}


void rygel_media_export_root_container_remove_uri (RygelMediaExportRootContainer* self, const gchar* uri) {
	GFile* _tmp0_ = NULL;
	GFile* file;
	gchar* _tmp1_ = NULL;
	gchar* id;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = g_file_new_for_commandline_arg (uri);
	file = _tmp0_;
	_tmp1_ = rygel_media_export_media_cache_get_id (file);
	id = _tmp1_;
	rygel_media_export_harvester_cancel (self->priv->harvester, file);
	rygel_media_export_media_cache_remove_by_id (((RygelMediaExportDBContainer*) self)->media_db, id, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch25_g_error;
	}
	goto __finally25;
	__catch25_g_error:
	{
		GError * _error_;
		const gchar* _tmp2_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _ ("Failed to remove URI: %s");
		g_warning (_tmp2_, _error_->message);
		_g_error_free0 (_error_);
	}
	__finally25:
	if (_inner_error_ != NULL) {
		_g_free0 (id);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (id);
	_g_object_unref0 (file);
}


gchar** rygel_media_export_root_container_get_dynamic_uris (RygelMediaExportRootContainer* self, int* result_length1) {
	gchar** result = NULL;
	GeeList* _tmp0_ = NULL;
	GeeList* uris;
	gint _tmp1_;
	gpointer* _tmp2_ = NULL;
	gchar** _tmp3_;
	gchar** _tmp4_ = NULL;
	gchar** _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = rygel_media_export_media_cache_get_flagged_uris (((RygelMediaExportDBContainer*) self)->media_db, "DBUS", &_inner_error_);
	uris = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch26_g_error;
	}
	_tmp2_ = gee_collection_to_array ((GeeCollection*) uris, &_tmp1_);
	_tmp3_ = _tmp2_;
	*result_length1 = _tmp1_;
	result = _tmp3_;
	_g_object_unref0 (uris);
	return result;
	_g_object_unref0 (uris);
	goto __finally26;
	__catch26_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally26:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = g_new0 (gchar*, 0 + 1);
	_tmp5_ = _tmp4_;
	*result_length1 = 0;
	result = _tmp5_;
	return result;
}


static void rygel_media_export_root_container_real_find_object_data_free (gpointer _data) {
	RygelMediaExportRootContainerFindObjectData* data;
	data = _data;
	_g_free0 (data->id);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (RygelMediaExportRootContainerFindObjectData, data);
}


static void rygel_media_export_root_container_real_find_object (RygelMediaContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportRootContainer * self;
	RygelMediaExportRootContainerFindObjectData* _data_;
	self = (RygelMediaExportRootContainer*) base;
	_data_ = g_slice_new0 (RygelMediaExportRootContainerFindObjectData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_export_root_container_real_find_object);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_export_root_container_real_find_object_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->id = g_strdup (id);
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_media_export_root_container_real_find_object_co (_data_);
}


static RygelMediaObject* rygel_media_export_root_container_real_find_object_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelMediaExportRootContainerFindObjectData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_media_export_root_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaExportRootContainerFindObjectData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_media_export_root_container_real_find_object_co (data);
}


static gboolean rygel_media_export_root_container_real_find_object_co (RygelMediaExportRootContainerFindObjectData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_state_ = 1;
	RYGEL_MEDIA_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->find_object ((RygelMediaContainer*) RYGEL_MEDIA_EXPORT_DB_CONTAINER (data->self), data->id, data->cancellable, rygel_media_export_root_container_find_object_ready, data);
	return FALSE;
	_state_1:
	data->_tmp0_ = NULL;
	data->_tmp0_ = RYGEL_MEDIA_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->find_object_finish ((RygelMediaContainer*) RYGEL_MEDIA_EXPORT_DB_CONTAINER (data->self), data->_res_, &data->_inner_error_);
	data->object = data->_tmp0_;
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	if (data->object == NULL) {
		data->_tmp2_ = g_str_has_prefix (data->id, RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX);
		data->_tmp1_ = data->_tmp2_;
	} else {
		data->_tmp1_ = FALSE;
	}
	if (data->_tmp1_) {
		data->_tmp3_ = NULL;
		data->_tmp3_ = rygel_media_export_query_container_new (((RygelMediaExportDBContainer*) data->self)->media_db, data->id, "");
		data->container = data->_tmp3_;
		((RygelMediaObject*) data->container)->parent = (RygelMediaContainer*) data->self;
		data->result = (RygelMediaObject*) data->container;
		_g_object_unref0 (data->object);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->result = data->object;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_object_unref0 (data->object);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_media_export_root_container_real_search_data_free (gpointer _data) {
	RygelMediaExportRootContainerSearchData* data;
	data = _data;
	_rygel_search_expression_unref0 (data->expression);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (RygelMediaExportRootContainerSearchData, data);
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
	return self ? rygel_search_expression_ref (self) : NULL;
}


static void rygel_media_export_root_container_real_search (RygelMediaExportDBContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportRootContainer * self;
	RygelMediaExportRootContainerSearchData* _data_;
	self = (RygelMediaExportRootContainer*) base;
	_data_ = g_slice_new0 (RygelMediaExportRootContainerSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_export_root_container_real_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_export_root_container_real_search_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->expression = _rygel_search_expression_ref0 (expression);
	_data_->offset = offset;
	_data_->max_count = max_count;
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_media_export_root_container_real_search_co (_data_);
}


static RygelMediaObjects* rygel_media_export_root_container_real_search_finish (RygelMediaExportDBContainer* base, GAsyncResult* _res_, guint* total_matches, GError** error) {
	RygelMediaObjects* result;
	RygelMediaExportRootContainerSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	*total_matches = _data_->total_matches;
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_media_export_root_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaExportRootContainerSearchData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_media_export_root_container_real_search_co (data);
}


static gboolean rygel_media_export_root_container_real_search_co (RygelMediaExportRootContainerSearchData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (data->expression == NULL) {
		data->_state_ = 1;
		RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->search (RYGEL_MEDIA_EXPORT_DB_CONTAINER (data->self), data->expression, data->offset, data->max_count, data->cancellable, rygel_media_export_root_container_search_ready, data);
		return FALSE;
		_state_1:
		data->_tmp1_ = NULL;
		data->_tmp1_ = RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->search_finish (RYGEL_MEDIA_EXPORT_DB_CONTAINER (data->self), data->_res_, &data->_tmp0_, &data->_inner_error_);
		data->total_matches = data->_tmp0_;
		data->_tmp2_ = data->_tmp1_;
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		data->result = data->_tmp2_;
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->query_container = NULL;
	data->upnp_class = NULL;
	if (RYGEL_IS_RELATIONAL_EXPRESSION (data->expression)) {
		data->_tmp4_ = _rygel_search_expression_ref0 ((data->_tmp3_ = data->expression, RYGEL_IS_RELATIONAL_EXPRESSION (data->_tmp3_) ? ((RygelRelationalExpression*) data->_tmp3_) : NULL));
		data->relational_expression = data->_tmp4_;
		data->_tmp5_ = NULL;
		data->_tmp5_ = rygel_media_export_root_container_search_to_virtual_container (data->self, data->relational_expression);
		data->_tmp6_ = (RygelMediaContainer*) data->_tmp5_;
		_g_object_unref0 (data->query_container);
		data->query_container = data->_tmp6_;
		data->_tmp7_ = g_strdup ((const gchar*) ((RygelSearchExpression*) data->relational_expression)->operand2);
		data->_tmp8_ = data->_tmp7_;
		_g_free0 (data->upnp_class);
		data->upnp_class = data->_tmp8_;
		_rygel_search_expression_unref0 (data->relational_expression);
	} else {
		data->_tmp9_ = NULL;
		data->_tmp10_ = rygel_media_export_root_container_is_search_in_virtual_container (data->self, data->expression, &data->_tmp9_);
		_g_object_unref0 (data->query_container);
		data->query_container = data->_tmp9_;
		if (data->_tmp10_) {
		}
	}
	if (data->query_container != NULL) {
		data->_state_ = 2;
		rygel_media_container_get_children (data->query_container, data->offset, data->max_count, data->cancellable, rygel_media_export_root_container_search_ready, data);
		return FALSE;
		_state_2:
		data->_tmp11_ = NULL;
		data->_tmp11_ = rygel_media_container_get_children_finish (data->query_container, data->_res_, &data->_inner_error_);
		data->_tmp12_ = data->_tmp11_;
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_free0 (data->upnp_class);
			_g_object_unref0 (data->query_container);
			_g_object_unref0 (data->list);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		data->_tmp13_ = data->_tmp12_;
		_g_object_unref0 (data->list);
		data->list = data->_tmp13_;
		data->total_matches = (guint) data->query_container->child_count;
		if (data->upnp_class != NULL) {
			{
				data->_tmp14_ = _g_object_ref0 (data->list);
				data->_object_list = data->_tmp14_;
				data->_tmp15_ = gee_collection_get_size ((GeeCollection*) data->_object_list);
				data->_object_size = data->_tmp15_;
				data->_object_index = -1;
				while (TRUE) {
					data->_object_index = data->_object_index + 1;
					if (!(data->_object_index < data->_object_size)) {
						break;
					}
					data->_tmp16_ = NULL;
					data->_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) data->_object_list, data->_object_index);
					data->object = (RygelMediaObject*) data->_tmp16_;
					data->_tmp17_ = g_strdup (data->upnp_class);
					data->_tmp18_ = data->_tmp17_;
					_g_free0 (data->object->upnp_class);
					data->object->upnp_class = data->_tmp18_;
					_g_object_unref0 (data->object);
				}
				_g_object_unref0 (data->_object_list);
			}
		}
		data->result = data->list;
		_g_free0 (data->upnp_class);
		_g_object_unref0 (data->query_container);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	} else {
		data->_state_ = 3;
		RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->search (RYGEL_MEDIA_EXPORT_DB_CONTAINER (data->self), data->expression, data->offset, data->max_count, data->cancellable, rygel_media_export_root_container_search_ready, data);
		return FALSE;
		_state_3:
		data->_tmp20_ = NULL;
		data->_tmp20_ = RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->search_finish (RYGEL_MEDIA_EXPORT_DB_CONTAINER (data->self), data->_res_, &data->_tmp19_, &data->_inner_error_);
		data->total_matches = data->_tmp19_;
		data->_tmp21_ = data->_tmp20_;
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_free0 (data->upnp_class);
			_g_object_unref0 (data->query_container);
			_g_object_unref0 (data->list);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		data->result = data->_tmp21_;
		_g_free0 (data->upnp_class);
		_g_object_unref0 (data->query_container);
		_g_object_unref0 (data->list);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	_g_free0 (data->upnp_class);
	_g_object_unref0 (data->query_container);
	_g_object_unref0 (data->list);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GRegex* _tmp2_ = NULL;
	GRegex* _tmp3_;
	GRegex* regex;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	_tmp0_ = g_regex_escape_string (old, -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_regex_new (_tmp1_, 0, 0, &_inner_error_);
	regex = (_tmp3_ = _tmp2_, _g_free0 (_tmp1_), _tmp3_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch29_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch29_g_regex_error;
		}
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp5_;
	_g_regex_unref0 (regex);
	return result;
	_g_regex_unref0 (regex);
	goto __finally29;
	__catch29_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally29:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static GeeArrayList* rygel_media_export_root_container_get_uris (RygelMediaExportRootContainer* self) {
	GeeArrayList* result = NULL;
	GeeArrayList* uris;
	GeeArrayList* actual_uris;
	RygelMetaConfig* _tmp0_ = NULL;
	RygelMetaConfig* config;
	GeeArrayList* _tmp1_ = NULL;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeList* _tmp6_ = NULL;
	GeeList* _tmp7_;
	GeeList* _tmp8_;
	GeeArrayList* _tmp9_ = NULL;
	GeeArrayList* _tmp10_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	uris = NULL;
	actual_uris = NULL;
	_tmp0_ = rygel_meta_config_get_default ();
	config = _tmp0_;
	_tmp1_ = rygel_configuration_get_string_list ((RygelConfiguration*) config, "MediaExport", "uris", &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		goto __catch27_g_error;
	}
	_tmp3_ = _tmp2_;
	_g_object_unref0 (uris);
	uris = _tmp3_;
	goto __finally27;
	__catch27_g_error:
	{
		GError * _error_;
		GeeArrayList* _tmp4_ = NULL;
		GeeArrayList* _tmp5_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (uris);
		uris = _tmp5_;
		_g_error_free0 (_error_);
	}
	__finally27:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (config);
		_g_object_unref0 (actual_uris);
		_g_object_unref0 (uris);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp6_ = rygel_media_export_media_cache_get_flagged_uris (((RygelMediaExportDBContainer*) self)->media_db, "DBUS", &_inner_error_);
	_tmp7_ = _tmp6_;
	if (_inner_error_ != NULL) {
		goto __catch28_g_error;
	}
	_tmp8_ = _tmp7_;
	gee_abstract_collection_add_all ((GeeAbstractCollection*) uris, (GeeCollection*) _tmp8_);
	_g_object_unref0 (_tmp8_);
	goto __finally28;
	__catch28_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally28:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (config);
		_g_object_unref0 (actual_uris);
		_g_object_unref0 (uris);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp9_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	_tmp10_ = _tmp9_;
	_g_object_unref0 (actual_uris);
	actual_uris = _tmp10_;
	{
		GeeArrayList* _tmp11_;
		GeeArrayList* _uri_list;
		gint _tmp12_;
		gint _uri_size;
		gint _uri_index;
		_tmp11_ = _g_object_ref0 (uris);
		_uri_list = _tmp11_;
		_tmp12_ = gee_collection_get_size ((GeeCollection*) _uri_list);
		_uri_size = _tmp12_;
		_uri_index = -1;
		while (TRUE) {
			gpointer _tmp13_ = NULL;
			gchar* uri;
			gchar* _tmp14_;
			gchar* actual_uri;
			const gchar* _tmp15_ = NULL;
			gchar* _tmp16_;
			gchar* pictures_dir;
			const gchar* _tmp17_ = NULL;
			gchar* _tmp18_;
			gchar* videos_dir;
			const gchar* _tmp19_ = NULL;
			gchar* _tmp20_;
			gchar* music_dir;
			gboolean _tmp21_;
			gboolean _tmp24_;
			gboolean _tmp27_;
			_uri_index = _uri_index + 1;
			if (!(_uri_index < _uri_size)) {
				break;
			}
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _uri_list, _uri_index);
			uri = (gchar*) _tmp13_;
			_tmp14_ = g_strdup (uri);
			actual_uri = _tmp14_;
			_tmp15_ = g_get_user_special_dir (G_USER_DIRECTORY_PICTURES);
			_tmp16_ = g_strdup (_tmp15_);
			pictures_dir = _tmp16_;
			_tmp17_ = g_get_user_special_dir (G_USER_DIRECTORY_VIDEOS);
			_tmp18_ = g_strdup (_tmp17_);
			videos_dir = _tmp18_;
			_tmp19_ = g_get_user_special_dir (G_USER_DIRECTORY_MUSIC);
			_tmp20_ = g_strdup (_tmp19_);
			music_dir = _tmp20_;
			_tmp21_ = G_LIKELY (pictures_dir != NULL);
			if (_tmp21_) {
				gchar* _tmp22_ = NULL;
				gchar* _tmp23_;
				_tmp22_ = string_replace (actual_uri, "@PICTURES@", pictures_dir);
				_tmp23_ = _tmp22_;
				_g_free0 (actual_uri);
				actual_uri = _tmp23_;
			}
			_tmp24_ = G_LIKELY (videos_dir != NULL);
			if (_tmp24_) {
				gchar* _tmp25_ = NULL;
				gchar* _tmp26_;
				_tmp25_ = string_replace (actual_uri, "@VIDEOS@", videos_dir);
				_tmp26_ = _tmp25_;
				_g_free0 (actual_uri);
				actual_uri = _tmp26_;
			}
			_tmp27_ = G_LIKELY (music_dir != NULL);
			if (_tmp27_) {
				gchar* _tmp28_ = NULL;
				gchar* _tmp29_;
				_tmp28_ = string_replace (actual_uri, "@MUSIC@", music_dir);
				_tmp29_ = _tmp28_;
				_g_free0 (actual_uri);
				actual_uri = _tmp29_;
			}
			gee_abstract_collection_add ((GeeAbstractCollection*) actual_uris, actual_uri);
			_g_free0 (music_dir);
			_g_free0 (videos_dir);
			_g_free0 (pictures_dir);
			_g_free0 (actual_uri);
			_g_free0 (uri);
		}
		_g_object_unref0 (_uri_list);
	}
	result = actual_uris;
	_g_object_unref0 (config);
	_g_object_unref0 (uris);
	return result;
}


static RygelMediaExportQueryContainer* rygel_media_export_root_container_search_to_virtual_container (RygelMediaExportRootContainer* self, RygelRelationalExpression* expression) {
	RygelMediaExportQueryContainer* result = NULL;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (expression != NULL, NULL);
	if (g_strcmp0 ((const gchar*) ((RygelSearchExpression*) expression)->operand1, "upnp:class") == 0) {
		_tmp0_ = GPOINTER_TO_INT (((RygelSearchExpression*) expression)->op) == GUPNP_SEARCH_CRITERIA_OP_EQ;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp1_;
		gchar* id;
		const gchar* _tmp2_;
		GQuark _tmp3_;
		static GQuark _tmp3__label0 = 0;
		static GQuark _tmp3__label1 = 0;
		static GQuark _tmp3__label2 = 0;
		RygelMediaExportQueryContainer* _tmp7_ = NULL;
		_tmp1_ = g_strdup (RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX);
		id = _tmp1_;
		_tmp2_ = (const gchar*) ((RygelSearchExpression*) expression)->operand2;
		_tmp3_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
		if (_tmp3_ == ((0 != _tmp3__label0) ? _tmp3__label0 : (_tmp3__label0 = g_quark_from_static_string ("object.container.album.musicAlbum")))) {
			switch (0) {
				default:
				{
					gchar* _tmp4_;
					_tmp4_ = g_strconcat (id, "upnp:album,?", NULL);
					_g_free0 (id);
					id = _tmp4_;
					break;
				}
			}
		} else if (_tmp3_ == ((0 != _tmp3__label1) ? _tmp3__label1 : (_tmp3__label1 = g_quark_from_static_string ("object.container.person.musicArtist")))) {
			switch (0) {
				default:
				{
					gchar* _tmp5_;
					_tmp5_ = g_strconcat (id, "dc:creator,?,upnp:album,?", NULL);
					_g_free0 (id);
					id = _tmp5_;
					break;
				}
			}
		} else if (_tmp3_ == ((0 != _tmp3__label2) ? _tmp3__label2 : (_tmp3__label2 = g_quark_from_static_string ("object.container.genre.musicGenre")))) {
			switch (0) {
				default:
				{
					gchar* _tmp6_;
					_tmp6_ = g_strconcat (id, "dc:genre,?", NULL);
					_g_free0 (id);
					id = _tmp6_;
					break;
				}
			}
		} else {
			switch (0) {
				default:
				{
					result = NULL;
					_g_free0 (id);
					return result;
				}
			}
		}
		rygel_media_export_query_container_register_id (&id);
		_tmp7_ = rygel_media_export_query_container_new (((RygelMediaExportDBContainer*) self)->media_db, id, "");
		result = _tmp7_;
		_g_free0 (id);
		return result;
	}
	result = NULL;
	return result;
}


/**
     * Check if a passed search expression is a simple search in a virtual
     * container.
     *
     * @param expression the expression to check
     * @param new_id contains the id of the virtual container constructed from
     *               the search
     * @param upnp_class contains the class of the container the search was
     *                   looking in
     * @return true if it was a search in virtual container, false otherwise.
     * @note This works single level only. Enough to satisfy Xbox music
     *       browsing, but may need refinement
     */
static gboolean rygel_media_export_root_container_is_search_in_virtual_container (RygelMediaExportRootContainer* self, RygelSearchExpression* expression, RygelMediaContainer** container) {
	RygelMediaContainer* _container = NULL;
	gboolean result = FALSE;
	RygelRelationalExpression* virtual_expression;
	RygelMediaExportQueryContainer* query_container;
	RygelSearchExpression* _tmp0_;
	RygelLogicalExpression* _tmp1_;
	RygelLogicalExpression* logical_expression;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	RygelSearchExpression* _tmp4_;
	RygelRelationalExpression* _tmp5_;
	RygelRelationalExpression* left_expression;
	RygelSearchExpression* _tmp6_;
	RygelRelationalExpression* _tmp7_;
	RygelRelationalExpression* right_expression;
	RygelMediaExportQueryContainer* _tmp8_ = NULL;
	RygelMediaExportQueryContainer* _tmp9_;
	gchar* _tmp16_ = NULL;
	gchar* last_argument;
	gchar* _tmp17_ = NULL;
	gchar* escaped_detail;
	gchar* _tmp18_ = NULL;
	gchar* new_id;
	RygelMediaExportQueryContainer* _tmp19_ = NULL;
	RygelMediaContainer* _tmp20_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (expression != NULL, FALSE);
	virtual_expression = NULL;
	query_container = NULL;
	if (!RYGEL_IS_LOGICAL_EXPRESSION (expression)) {
		result = FALSE;
		_g_object_unref0 (query_container);
		_rygel_search_expression_unref0 (virtual_expression);
		if (container) {
			*container = _container;
		} else {
			_g_object_unref0 (_container);
		}
		return result;
	}
	_tmp1_ = _rygel_search_expression_ref0 ((_tmp0_ = expression, RYGEL_IS_LOGICAL_EXPRESSION (_tmp0_) ? ((RygelLogicalExpression*) _tmp0_) : NULL));
	logical_expression = _tmp1_;
	if (RYGEL_IS_RELATIONAL_EXPRESSION ((RygelSearchExpression*) ((RygelSearchExpression*) logical_expression)->operand1)) {
		_tmp3_ = RYGEL_IS_RELATIONAL_EXPRESSION ((RygelSearchExpression*) ((RygelSearchExpression*) logical_expression)->operand2);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = GPOINTER_TO_INT (((RygelSearchExpression*) logical_expression)->op) == RYGEL_LOGICAL_OPERATOR_AND;
	} else {
		_tmp2_ = FALSE;
	}
	if (!_tmp2_) {
		result = FALSE;
		_rygel_search_expression_unref0 (logical_expression);
		_g_object_unref0 (query_container);
		_rygel_search_expression_unref0 (virtual_expression);
		if (container) {
			*container = _container;
		} else {
			_g_object_unref0 (_container);
		}
		return result;
	}
	_tmp5_ = _rygel_search_expression_ref0 ((_tmp4_ = (RygelSearchExpression*) ((RygelSearchExpression*) logical_expression)->operand1, RYGEL_IS_RELATIONAL_EXPRESSION (_tmp4_) ? ((RygelRelationalExpression*) _tmp4_) : NULL));
	left_expression = _tmp5_;
	_tmp7_ = _rygel_search_expression_ref0 ((_tmp6_ = (RygelSearchExpression*) ((RygelSearchExpression*) logical_expression)->operand2, RYGEL_IS_RELATIONAL_EXPRESSION (_tmp6_) ? ((RygelRelationalExpression*) _tmp6_) : NULL));
	right_expression = _tmp7_;
	_tmp8_ = rygel_media_export_root_container_search_to_virtual_container (self, left_expression);
	_tmp9_ = _tmp8_;
	_g_object_unref0 (query_container);
	query_container = _tmp9_;
	if (query_container == NULL) {
		RygelMediaExportQueryContainer* _tmp10_ = NULL;
		RygelMediaExportQueryContainer* _tmp11_;
		_tmp10_ = rygel_media_export_root_container_search_to_virtual_container (self, right_expression);
		_tmp11_ = _tmp10_;
		_g_object_unref0 (query_container);
		query_container = _tmp11_;
		if (query_container != NULL) {
			RygelRelationalExpression* _tmp12_;
			RygelRelationalExpression* _tmp13_;
			_tmp12_ = _rygel_search_expression_ref0 (left_expression);
			_tmp13_ = _tmp12_;
			_rygel_search_expression_unref0 (virtual_expression);
			virtual_expression = _tmp13_;
		} else {
			result = FALSE;
			_rygel_search_expression_unref0 (right_expression);
			_rygel_search_expression_unref0 (left_expression);
			_rygel_search_expression_unref0 (logical_expression);
			_g_object_unref0 (query_container);
			_rygel_search_expression_unref0 (virtual_expression);
			if (container) {
				*container = _container;
			} else {
				_g_object_unref0 (_container);
			}
			return result;
		}
	} else {
		RygelRelationalExpression* _tmp14_;
		RygelRelationalExpression* _tmp15_;
		_tmp14_ = _rygel_search_expression_ref0 (right_expression);
		_tmp15_ = _tmp14_;
		_rygel_search_expression_unref0 (virtual_expression);
		virtual_expression = _tmp15_;
	}
	_tmp16_ = string_replace (query_container->plaintext_id, RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, "");
	last_argument = _tmp16_;
	_tmp17_ = g_uri_escape_string ((const gchar*) ((RygelSearchExpression*) virtual_expression)->operand2, "", TRUE);
	escaped_detail = _tmp17_;
	_tmp18_ = g_strdup_printf ("%s%s,%s,%s", RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, (const gchar*) ((RygelSearchExpression*) virtual_expression)->operand1, escaped_detail, last_argument);
	new_id = _tmp18_;
	rygel_media_export_query_container_register_id (&new_id);
	_tmp19_ = rygel_media_export_query_container_new (((RygelMediaExportDBContainer*) self)->media_db, new_id, "");
	_tmp20_ = (RygelMediaContainer*) _tmp19_;
	_g_object_unref0 (_container);
	_container = _tmp20_;
	result = TRUE;
	_g_free0 (new_id);
	_g_free0 (escaped_detail);
	_g_free0 (last_argument);
	_rygel_search_expression_unref0 (right_expression);
	_rygel_search_expression_unref0 (left_expression);
	_rygel_search_expression_unref0 (logical_expression);
	_g_object_unref0 (query_container);
	_rygel_search_expression_unref0 (virtual_expression);
	if (container) {
		*container = _container;
	} else {
		_g_object_unref0 (_container);
	}
	return result;
}


/**
     * Create a new root container.
     */
static RygelMediaExportRootContainer* rygel_media_export_root_container_construct (GType object_type, GError** error) {
	RygelMediaExportRootContainer * self = NULL;
	RygelMediaExportMediaCache* _tmp0_ = NULL;
	RygelMediaExportMediaCache* db;
	GCancellable* _tmp1_ = NULL;
	GCancellable* _tmp2_;
	RygelMediaExportHarvester* _tmp3_ = NULL;
	RygelMediaExportHarvester* _tmp4_;
	RygelMediaExportDBusService* _tmp5_ = NULL;
	RygelMediaExportDBusService* _tmp6_;
	RygelMediaExportDBusService* _tmp7_;
	RygelNullContainer* _tmp9_ = NULL;
	RygelMediaContainer* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GeeArrayList* ids;
	GeeArrayList* _tmp13_ = NULL;
	GeeArrayList* _tmp14_;
	GeeArrayList* _tmp15_;
	GeeArrayList* _tmp18_ = NULL;
	GeeArrayList* uris;
	GError * _inner_error_ = NULL;
	_tmp0_ = rygel_media_export_media_cache_get_default (&_inner_error_);
	db = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	self = (RygelMediaExportRootContainer*) rygel_media_export_db_container_construct (object_type, db, "0", "MediaExportRoot");
	_tmp1_ = g_cancellable_new ();
	_tmp2_ = _tmp1_;
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp2_;
	_tmp3_ = rygel_media_export_harvester_new (self->priv->cancellable);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (self->priv->harvester);
	self->priv->harvester = _tmp4_;
	_tmp5_ = rygel_media_export_dbus_service_new (self, &_inner_error_);
	_tmp6_ = _tmp5_;
	if (_inner_error_ != NULL) {
		goto __catch30_g_error;
	}
	_tmp7_ = _tmp6_;
	_g_object_unref0 (self->priv->service);
	self->priv->service = _tmp7_;
	goto __finally30;
	__catch30_g_error:
	{
		GError * err;
		const gchar* _tmp8_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = _ ("Failed to create MediaExport D-Bus service: %s");
		g_warning (_tmp8_, err->message);
		_g_error_free0 (err);
	}
	__finally30:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (db);
		_g_object_unref0 (self);
		return NULL;
	}
	rygel_media_export_media_cache_save_container (((RygelMediaExportDBContainer*) self)->media_db, (RygelMediaContainer*) self, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch31_g_error;
	}
	goto __finally31;
	__catch31_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally31:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (db);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp9_ = rygel_null_container_new ();
	_tmp10_ = (RygelMediaContainer*) _tmp9_;
	_g_object_unref0 (self->priv->filesystem_container);
	self->priv->filesystem_container = _tmp10_;
	((RygelMediaObject*) self->priv->filesystem_container)->parent = (RygelMediaContainer*) self;
	rygel_media_object_set_title ((RygelMediaObject*) self->priv->filesystem_container, RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_NAME);
	_tmp11_ = g_strdup (RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID);
	_tmp12_ = _tmp11_;
	_g_free0 (((RygelMediaObject*) self->priv->filesystem_container)->id);
	((RygelMediaObject*) self->priv->filesystem_container)->id = _tmp12_;
	rygel_media_export_media_cache_save_container (((RygelMediaExportDBContainer*) self)->media_db, self->priv->filesystem_container, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch32_g_error;
	}
	goto __finally32;
	__catch32_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally32:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (db);
		_g_object_unref0 (self);
		return NULL;
	}
	ids = NULL;
	_tmp13_ = rygel_media_export_media_cache_get_child_ids (((RygelMediaExportDBContainer*) self)->media_db, RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID, &_inner_error_);
	_tmp14_ = _tmp13_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch33_rygel_media_export_database_error;
		}
		_g_object_unref0 (ids);
		_g_object_unref0 (db);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp15_ = _tmp14_;
	_g_object_unref0 (ids);
	ids = _tmp15_;
	goto __finally33;
	__catch33_rygel_media_export_database_error:
	{
		GError * e;
		GeeArrayList* _tmp16_ = NULL;
		GeeArrayList* _tmp17_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
		_tmp17_ = _tmp16_;
		_g_object_unref0 (ids);
		ids = _tmp17_;
		_g_error_free0 (e);
	}
	__finally33:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (ids);
		_g_object_unref0 (db);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp18_ = rygel_media_export_root_container_get_uris (self);
	uris = _tmp18_;
	{
		GeeArrayList* _tmp19_;
		GeeArrayList* _uri_list;
		gint _tmp20_;
		gint _uri_size;
		gint _uri_index;
		_tmp19_ = _g_object_ref0 (uris);
		_uri_list = _tmp19_;
		_tmp20_ = gee_collection_get_size ((GeeCollection*) _uri_list);
		_uri_size = _tmp20_;
		_uri_index = -1;
		while (TRUE) {
			gpointer _tmp21_ = NULL;
			gchar* uri;
			GFile* _tmp22_ = NULL;
			GFile* file;
			gboolean _tmp23_;
			_uri_index = _uri_index + 1;
			if (!(_uri_index < _uri_size)) {
				break;
			}
			_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _uri_list, _uri_index);
			uri = (gchar*) _tmp21_;
			_tmp22_ = g_file_new_for_commandline_arg (uri);
			file = _tmp22_;
			_tmp23_ = g_file_query_exists (file, NULL);
			if (_tmp23_) {
				gchar* _tmp24_ = NULL;
				gchar* _tmp25_;
				_tmp24_ = rygel_media_export_media_cache_get_id (file);
				_tmp25_ = _tmp24_;
				gee_abstract_collection_remove ((GeeAbstractCollection*) ids, _tmp25_);
				_g_free0 (_tmp25_);
				rygel_media_export_harvester_schedule (self->priv->harvester, file, self->priv->filesystem_container, NULL);
			}
			_g_object_unref0 (file);
			_g_free0 (uri);
		}
		_g_object_unref0 (_uri_list);
	}
	{
		GeeArrayList* _tmp26_;
		GeeArrayList* _id_list;
		gint _tmp27_;
		gint _id_size;
		gint _id_index;
		_tmp26_ = _g_object_ref0 (ids);
		_id_list = _tmp26_;
		_tmp27_ = gee_collection_get_size ((GeeCollection*) _id_list);
		_id_size = _tmp27_;
		_id_index = -1;
		while (TRUE) {
			gpointer _tmp28_ = NULL;
			gchar* id;
			_id_index = _id_index + 1;
			if (!(_id_index < _id_size)) {
				break;
			}
			_tmp28_ = gee_abstract_list_get ((GeeAbstractList*) _id_list, _id_index);
			id = (gchar*) _tmp28_;
			g_debug ("rygel-media-export-root-container.vala:363: ID %s no longer in config;" \
" deleting...", id);
			rygel_media_export_media_cache_remove_by_id (((RygelMediaExportDBContainer*) self)->media_db, id, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
					goto __catch34_rygel_media_export_database_error;
				}
				_g_free0 (id);
				_g_object_unref0 (_id_list);
				_g_object_unref0 (uris);
				_g_object_unref0 (ids);
				_g_object_unref0 (db);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			goto __finally34;
			__catch34_rygel_media_export_database_error:
			{
				GError * _error_;
				const gchar* _tmp29_ = NULL;
				_error_ = _inner_error_;
				_inner_error_ = NULL;
				_tmp29_ = _ ("Failed to remove entry: %s");
				g_warning (_tmp29_, _error_->message);
				_g_error_free0 (_error_);
			}
			__finally34:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (id);
				_g_object_unref0 (_id_list);
				_g_object_unref0 (uris);
				_g_object_unref0 (ids);
				_g_object_unref0 (db);
				_g_object_unref0 (self);
				return NULL;
			}
			_g_free0 (id);
		}
		_g_object_unref0 (_id_list);
	}
	rygel_media_export_root_container_add_default_virtual_folders (self);
	rygel_media_container_updated ((RygelMediaContainer*) self);
	_g_object_unref0 (uris);
	_g_object_unref0 (ids);
	_g_object_unref0 (db);
	return self;
}


static RygelMediaExportRootContainer* rygel_media_export_root_container_new (GError** error) {
	return rygel_media_export_root_container_construct (RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, error);
}


static void rygel_media_export_root_container_add_default_virtual_folders (RygelMediaExportRootContainer* self) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = _ ("Music");
	rygel_media_export_root_container_add_virtual_containers_for_class (self, _tmp0_, "object.item.audioItem.musicTrack", virtual_folders_music, G_N_ELEMENTS (virtual_folders_music), &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch35_g_error;
	}
	_tmp1_ = _ ("Pictures");
	rygel_media_export_root_container_add_virtual_containers_for_class (self, _tmp1_, "object.item.imageItem.photo", NULL, 0, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch35_g_error;
	}
	_tmp2_ = _ ("Videos");
	rygel_media_export_root_container_add_virtual_containers_for_class (self, _tmp2_, "object.item.videoItem", NULL, 0, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch35_g_error;
	}
	goto __finally35;
	__catch35_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally35:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static const gchar* string_offset (const gchar* self, glong offset) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = (const gchar*) (((gchar*) self) + offset);
	return result;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	glong string_length;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_ = NULL;
	const gchar* start_string;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	string_length = (glong) _tmp0_;
	if (start < 0) {
		start = string_length + start;
	}
	if (end < 0) {
		end = string_length + end;
	}
	if (start >= 0) {
		_tmp1_ = start <= string_length;
	} else {
		_tmp1_ = FALSE;
	}
	g_return_val_if_fail (_tmp1_, NULL);
	if (end >= 0) {
		_tmp2_ = end <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp3_ = string_offset (self, start);
	start_string = _tmp3_;
	_tmp4_ = string_offset (start_string, end - start);
	_tmp5_ = g_strndup (start_string, ((gchar*) _tmp4_) - ((gchar*) start_string));
	result = _tmp5_;
	return result;
}


static void rygel_media_export_root_container_add_folder_definition (RygelMediaExportRootContainer* self, RygelMediaContainer* container, const gchar* item_class, RygelMediaExportFolderDefinition* definition, GError** error) {
	gchar* _tmp0_ = NULL;
	gchar* id;
	gboolean _tmp1_;
	RygelMediaExportQueryContainer* _tmp4_ = NULL;
	RygelMediaExportQueryContainer* query_container;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (item_class != NULL);
	_tmp0_ = g_strdup_printf ("%supnp:class,%s,%s", RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, item_class, (*definition).definition);
	id = _tmp0_;
	_tmp1_ = g_str_has_suffix (id, ",");
	if (_tmp1_) {
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		_tmp2_ = string_slice (id, (glong) 0, (glong) (-1));
		_tmp3_ = _tmp2_;
		_g_free0 (id);
		id = _tmp3_;
	}
	rygel_media_export_query_container_register_id (&id);
	_tmp4_ = rygel_media_export_query_container_new (((RygelMediaExportDBContainer*) self)->media_db, id, (*definition).title);
	query_container = _tmp4_;
	((RygelMediaObject*) query_container)->parent = container;
	rygel_media_export_media_cache_save_container (((RygelMediaExportDBContainer*) self)->media_db, (RygelMediaContainer*) query_container, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (query_container);
		_g_free0 (id);
		return;
	}
	_g_object_unref0 (query_container);
	_g_free0 (id);
}


static void rygel_media_export_root_container_add_virtual_containers_for_class (RygelMediaExportRootContainer* self, const gchar* parent, const gchar* item_class, RygelMediaExportFolderDefinition* definitions, int definitions_length1, GError** error) {
	RygelNullContainer* _tmp0_ = NULL;
	RygelNullContainer* container;
	gchar* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	g_return_if_fail (item_class != NULL);
	_tmp0_ = rygel_null_container_new ();
	container = _tmp0_;
	((RygelMediaObject*) container)->parent = (RygelMediaContainer*) self;
	rygel_media_object_set_title ((RygelMediaObject*) container, parent);
	_tmp1_ = g_strconcat ("virtual-parent:", item_class, NULL);
	_g_free0 (((RygelMediaObject*) container)->id);
	((RygelMediaObject*) container)->id = _tmp1_;
	rygel_media_export_media_cache_save_container (((RygelMediaExportDBContainer*) self)->media_db, (RygelMediaContainer*) container, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (container);
		return;
	}
	{
		RygelMediaExportFolderDefinition* definition_collection;
		int definition_collection_length1;
		int definition_it;
		definition_collection = virtual_folders_default;
		definition_collection_length1 = G_N_ELEMENTS (virtual_folders_default);
		for (definition_it = 0; definition_it < G_N_ELEMENTS (virtual_folders_default); definition_it = definition_it + 1) {
			RygelMediaExportFolderDefinition definition;
			definition = definition_collection[definition_it];
			{
				rygel_media_export_root_container_add_folder_definition (self, (RygelMediaContainer*) container, item_class, &definition, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (container);
					return;
				}
			}
		}
	}
	if (definitions != NULL) {
		{
			RygelMediaExportFolderDefinition* definition_collection;
			int definition_collection_length1;
			int definition_it;
			definition_collection = definitions;
			definition_collection_length1 = definitions_length1;
			for (definition_it = 0; definition_it < definitions_length1; definition_it = definition_it + 1) {
				RygelMediaExportFolderDefinition _tmp2_;
				RygelMediaExportFolderDefinition _tmp3_ = {0};
				RygelMediaExportFolderDefinition definition;
				_tmp2_ = (rygel_media_export_folder_definition_copy (&definition_collection[definition_it], &_tmp3_), _tmp3_);
				definition = _tmp2_;
				{
					rygel_media_export_root_container_add_folder_definition (self, (RygelMediaContainer*) container, item_class, &definition, &_inner_error_);
					if (_inner_error_ != NULL) {
						g_propagate_error (error, _inner_error_);
						rygel_media_export_folder_definition_destroy (&definition);
						_g_object_unref0 (container);
						return;
					}
					rygel_media_export_folder_definition_destroy (&definition);
				}
			}
		}
	}
	_g_object_unref0 (container);
}


static void rygel_media_export_root_container_class_init (RygelMediaExportRootContainerClass * klass) {
	rygel_media_export_root_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaExportRootContainerPrivate));
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object = rygel_media_export_root_container_real_find_object;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object_finish = rygel_media_export_root_container_real_find_object_finish;
	RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS (klass)->search = rygel_media_export_root_container_real_search;
	RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS (klass)->search_finish = rygel_media_export_root_container_real_search_finish;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_root_container_finalize;
}


static void rygel_media_export_root_container_instance_init (RygelMediaExportRootContainer * self) {
	self->priv = RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_GET_PRIVATE (self);
}


static void rygel_media_export_root_container_finalize (GObject* obj) {
	RygelMediaExportRootContainer * self;
	self = RYGEL_MEDIA_EXPORT_ROOT_CONTAINER (obj);
	_g_object_unref0 (self->priv->service);
	_g_object_unref0 (self->priv->harvester);
	_g_object_unref0 (self->priv->cancellable);
	_g_object_unref0 (self->priv->filesystem_container);
	G_OBJECT_CLASS (rygel_media_export_root_container_parent_class)->finalize (obj);
}


/**
 * Represents the root container.
 */
GType rygel_media_export_root_container_get_type (void) {
	static volatile gsize rygel_media_export_root_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_root_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportRootContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_root_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportRootContainer), 0, (GInstanceInitFunc) rygel_media_export_root_container_instance_init, NULL };
		GType rygel_media_export_root_container_type_id;
		rygel_media_export_root_container_type_id = g_type_register_static (RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, "RygelMediaExportRootContainer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_root_container_type_id__volatile, rygel_media_export_root_container_type_id);
	}
	return rygel_media_export_root_container_type_id__volatile;
}



