/* rygel-media-export-harvesting-task.c generated by valac 0.11.3, the Vala compiler
 * generated from rygel-media-export-harvesting-task.vala, do not modify */

/*
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-dlna/gupnp-dlna-information.h>
#include <glib/gi18n-lib.h>


#define RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK (rygel_media_export_harvesting_task_get_type ())
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTask))
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTaskClass))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTING_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTING_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK))
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTaskClass))

typedef struct _RygelMediaExportHarvestingTask RygelMediaExportHarvestingTask;
typedef struct _RygelMediaExportHarvestingTaskClass RygelMediaExportHarvestingTaskClass;
typedef struct _RygelMediaExportHarvestingTaskPrivate RygelMediaExportHarvestingTaskPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR (rygel_media_export_metadata_extractor_get_type ())
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractor))
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorClass))
#define RYGEL_MEDIA_EXPORT_IS_METADATA_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_IS_METADATA_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorClass))

typedef struct _RygelMediaExportMetadataExtractor RygelMediaExportMetadataExtractor;
typedef struct _RygelMediaExportMetadataExtractorClass RygelMediaExportMetadataExtractorClass;

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;

#define RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR (rygel_media_export_recursive_file_monitor_get_type ())
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitor))
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitorClass))
#define RYGEL_MEDIA_EXPORT_IS_RECURSIVE_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR))
#define RYGEL_MEDIA_EXPORT_IS_RECURSIVE_FILE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR))
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitorClass))

typedef struct _RygelMediaExportRecursiveFileMonitor RygelMediaExportRecursiveFileMonitor;
typedef struct _RygelMediaExportRecursiveFileMonitorClass RygelMediaExportRecursiveFileMonitorClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_queue_free0(var) ((var == NULL) ? NULL : (var = (g_queue_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMediaExportHarvestingTaskRunData RygelMediaExportHarvestingTaskRunData;

#define RYGEL_TYPE_NULL_CONTAINER (rygel_null_container_get_type ())
#define RYGEL_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainer))
#define RYGEL_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))
#define RYGEL_IS_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_IS_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_NULL_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))

typedef struct _RygelNullContainer RygelNullContainer;
typedef struct _RygelNullContainerClass RygelNullContainerClass;

#define RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER (rygel_media_export_dummy_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DUMMY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER, RygelMediaExportDummyContainer))
#define RYGEL_MEDIA_EXPORT_DUMMY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER, RygelMediaExportDummyContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DUMMY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DUMMY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DUMMY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER, RygelMediaExportDummyContainerClass))

typedef struct _RygelMediaExportDummyContainer RygelMediaExportDummyContainer;
typedef struct _RygelMediaExportDummyContainerClass RygelMediaExportDummyContainerClass;
typedef struct _RygelNullContainerPrivate RygelNullContainerPrivate;
typedef struct _RygelMediaExportDummyContainerPrivate RygelMediaExportDummyContainerPrivate;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _RygelMediaExportHarvestingTaskEnumerateDirectoryData RygelMediaExportHarvestingTaskEnumerateDirectoryData;

struct _RygelMediaExportHarvestingTask {
	GObject parent_instance;
	RygelMediaExportHarvestingTaskPrivate * priv;
	GFile* origin;
};

struct _RygelMediaExportHarvestingTaskClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportHarvestingTaskPrivate {
	RygelMediaExportMetadataExtractor* extractor;
	RygelMediaExportMediaCache* cache;
	GQueue* containers;
	GeeQueue* files;
	RygelMediaExportRecursiveFileMonitor* monitor;
	GRegex* file_filter;
	gchar* flag;
	RygelMediaContainer* parent;
	GCancellable* _cancellable;
};

struct _RygelMediaExportHarvestingTaskRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaExportHarvestingTask* self;
	GCancellable* _tmp0_;
	GFileInfo* _tmp1_;
	GFileInfo* info;
	gboolean _tmp2_;
	GFileType _tmp3_;
	RygelMediaContainer* _tmp4_;
	GError * _error_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GError * _inner_error_;
};

typedef enum  {
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_IO_ERROR,
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR
} RygelMediaExportDatabaseError;
#define RYGEL_MEDIA_EXPORT_DATABASE_ERROR rygel_media_export_database_error_quark ()
struct _RygelNullContainer {
	RygelMediaContainer parent_instance;
	RygelNullContainerPrivate * priv;
};

struct _RygelNullContainerClass {
	RygelMediaContainerClass parent_class;
};

struct _RygelMediaExportDummyContainer {
	RygelNullContainer parent_instance;
	RygelMediaExportDummyContainerPrivate * priv;
	GFile* file;
	GeeList* children;
};

struct _RygelMediaExportDummyContainerClass {
	RygelNullContainerClass parent_class;
};

struct _RygelMediaExportHarvestingTaskEnumerateDirectoryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaExportHarvestingTask* self;
	gconstpointer _tmp0_;
	RygelMediaContainer* _tmp1_;
	GFile* _tmp2_;
	GFile* directory;
	GCancellable* _tmp3_;
	GFileEnumerator* _tmp4_;
	GFileEnumerator* enumerator;
	GList* list;
	gboolean _tmp5_;
	gboolean _tmp6_;
	GCancellable* _tmp7_;
	GList* _tmp8_;
	GList* _tmp9_;
	GList* _tmp10_;
	GCancellable* _tmp11_;
	GError * err;
	const gchar* _tmp12_;
	GError * _inner_error_;
};


static gpointer rygel_media_export_harvesting_task_parent_class = NULL;
static RygelStateMachineIface* rygel_media_export_harvesting_task_rygel_state_machine_parent_iface = NULL;

GType rygel_media_export_harvesting_task_get_type (void) G_GNUC_CONST;
GType rygel_media_export_metadata_extractor_get_type (void) G_GNUC_CONST;
GType rygel_media_export_media_cache_get_type (void) G_GNUC_CONST;
GType rygel_media_export_recursive_file_monitor_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTaskPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_HARVESTING_TASK_DUMMY_PROPERTY,
	RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CANCELLABLE
};
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_BATCH_SIZE 256
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_HARVESTER_ATTRIBUTES G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_TIME_MODIFIED "," G_FILE_ATTRIBUTE_STANDARD_SIZE
RygelMediaExportHarvestingTask* rygel_media_export_harvesting_task_new (RygelMediaExportMetadataExtractor* extractor, RygelMediaExportRecursiveFileMonitor* monitor, GRegex* file_filter, GFile* file, RygelMediaContainer* parent, const gchar* flag);
RygelMediaExportHarvestingTask* rygel_media_export_harvesting_task_construct (GType object_type, RygelMediaExportMetadataExtractor* extractor, RygelMediaExportRecursiveFileMonitor* monitor, GRegex* file_filter, GFile* file, RygelMediaContainer* parent, const gchar* flag);
RygelMediaExportMediaCache* rygel_media_export_media_cache_get_default (GError** error);
static void rygel_media_export_harvesting_task_on_extracted_cb (RygelMediaExportHarvestingTask* self, GFile* file, GUPnPDLNAInformation* dlna, const gchar* mime, guint64 size, guint64 mtime);
static void _rygel_media_export_harvesting_task_on_extracted_cb_rygel_media_export_metadata_extractor_extraction_done (RygelMediaExportMetadataExtractor* _sender, GFile* file, GUPnPDLNAInformation* info, const gchar* mime, guint64 size, guint64 mtime, gpointer self);
static void rygel_media_export_harvesting_task_on_extractor_error_cb (RygelMediaExportHarvestingTask* self, GFile* file, GError* _error_);
static void _rygel_media_export_harvesting_task_on_extractor_error_cb_rygel_media_export_metadata_extractor_error (RygelMediaExportMetadataExtractor* _sender, GFile* file, GError* err, gpointer self);
void rygel_media_export_harvesting_task_cancel (RygelMediaExportHarvestingTask* self);
static void rygel_media_export_harvesting_task_real_run_data_free (gpointer _data);
static void rygel_media_export_harvesting_task_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_media_export_harvesting_task_real_run_co (RygelMediaExportHarvestingTaskRunData* data);
static void rygel_media_export_harvesting_task_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_media_export_harvesting_task_process_file (RygelMediaExportHarvestingTask* self, GFile* file, GFileInfo* info, RygelMediaContainer* parent);
static gboolean rygel_media_export_harvesting_task_on_idle (RygelMediaExportHarvestingTask* self);
static gboolean _rygel_media_export_harvesting_task_on_idle_gsource_func (gpointer self);
static gboolean rygel_media_export_harvesting_task_push_if_changed_or_unknown (RygelMediaExportHarvestingTask* self, GFile* file, GFileInfo* info);
GQuark rygel_media_export_database_error_quark (void);
gboolean rygel_media_export_media_cache_exists (RygelMediaExportMediaCache* self, GFile* file, gint64* timestamp, gint64* size, GError** error);
void rygel_media_export_recursive_file_monitor_add (RygelMediaExportRecursiveFileMonitor* self, GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_media_export_recursive_file_monitor_add_finish (RygelMediaExportRecursiveFileMonitor* self, GAsyncResult* _res_);
RygelMediaExportDummyContainer* rygel_media_export_dummy_container_new (GFile* file, RygelMediaContainer* parent);
RygelMediaExportDummyContainer* rygel_media_export_dummy_container_construct (GType object_type, GFile* file, RygelMediaContainer* parent);
GType rygel_null_container_get_type (void) G_GNUC_CONST;
GType rygel_media_export_dummy_container_get_type (void) G_GNUC_CONST;
void rygel_media_export_media_cache_save_container (RygelMediaExportMediaCache* self, RygelMediaContainer* container, GError** error);
static gboolean rygel_media_export_harvesting_task_process_children (RygelMediaExportHarvestingTask* self, GList* list);
void rygel_media_export_dummy_container_seen (RygelMediaExportDummyContainer* self, GFile* file);
static void rygel_media_export_harvesting_task_enumerate_directory_data_free (gpointer _data);
static void rygel_media_export_harvesting_task_enumerate_directory (RygelMediaExportHarvestingTask* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_media_export_harvesting_task_enumerate_directory_finish (RygelMediaExportHarvestingTask* self, GAsyncResult* _res_);
static gboolean rygel_media_export_harvesting_task_enumerate_directory_co (RygelMediaExportHarvestingTaskEnumerateDirectoryData* data);
static void rygel_media_export_harvesting_task_enumerate_directory_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void rygel_media_export_harvesting_task_cleanup_database (RygelMediaExportHarvestingTask* self);
static void rygel_media_export_harvesting_task_do_update (RygelMediaExportHarvestingTask* self);
void rygel_media_export_media_cache_remove_by_id (RygelMediaExportMediaCache* self, const gchar* id, GError** error);
void rygel_media_export_metadata_extractor_extract (RygelMediaExportMetadataExtractor* self, GFile* file);
void rygel_media_export_media_cache_flag_object (RygelMediaExportMediaCache* self, GFile* file, const gchar* flag, GError** error);
RygelMediaItem* rygel_media_export_item_factory_create_simple (RygelMediaContainer* parent, GFile* file, const gchar* mime, guint64 size, guint64 mtime);
RygelMediaItem* rygel_media_export_item_factory_create_from_info (RygelMediaContainer* parent, GFile* file, GUPnPDLNAInformation* dlna_info, const gchar* mime, guint64 size, guint64 mtime);
void rygel_media_export_media_cache_save_item (RygelMediaExportMediaCache* self, RygelMediaItem* item, GError** error);
static void rygel_media_export_harvesting_task_finalize (GObject* obj);
static void _vala_rygel_media_export_harvesting_task_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_export_harvesting_task_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _rygel_media_export_harvesting_task_on_extracted_cb_rygel_media_export_metadata_extractor_extraction_done (RygelMediaExportMetadataExtractor* _sender, GFile* file, GUPnPDLNAInformation* info, const gchar* mime, guint64 size, guint64 mtime, gpointer self) {
	rygel_media_export_harvesting_task_on_extracted_cb (self, file, info, mime, size, mtime);
}


static void _rygel_media_export_harvesting_task_on_extractor_error_cb_rygel_media_export_metadata_extractor_error (RygelMediaExportMetadataExtractor* _sender, GFile* file, GError* err, gpointer self) {
	rygel_media_export_harvesting_task_on_extractor_error_cb (self, file, err);
}


static gpointer _g_regex_ref0 (gpointer self) {
	return self ? g_regex_ref (self) : NULL;
}


RygelMediaExportHarvestingTask* rygel_media_export_harvesting_task_construct (GType object_type, RygelMediaExportMetadataExtractor* extractor, RygelMediaExportRecursiveFileMonitor* monitor, GRegex* file_filter, GFile* file, RygelMediaContainer* parent, const gchar* flag) {
	RygelMediaExportHarvestingTask * self = NULL;
	RygelMediaExportMetadataExtractor* _tmp0_;
	RygelMediaExportMetadataExtractor* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	RygelMediaContainer* _tmp4_;
	RygelMediaContainer* _tmp5_;
	RygelMediaExportMediaCache* _tmp6_ = NULL;
	RygelMediaExportMediaCache* _tmp7_;
	RygelMediaExportMediaCache* _tmp8_;
	GeeLinkedList* _tmp9_ = NULL;
	GeeQueue* _tmp10_;
	GQueue* _tmp11_ = NULL;
	GQueue* _tmp12_;
	RygelMediaExportRecursiveFileMonitor* _tmp13_;
	RygelMediaExportRecursiveFileMonitor* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	GRegex* _tmp17_;
	GRegex* _tmp18_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (extractor != NULL, NULL);
	g_return_val_if_fail (monitor != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	self = (RygelMediaExportHarvestingTask*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (extractor);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->extractor);
	self->priv->extractor = _tmp1_;
	_tmp2_ = _g_object_ref0 (file);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->origin);
	self->origin = _tmp3_;
	_tmp4_ = _g_object_ref0 (parent);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (self->priv->parent);
	self->priv->parent = _tmp5_;
	_tmp6_ = rygel_media_export_media_cache_get_default (&_inner_error_);
	_tmp7_ = _tmp6_;
	if (_inner_error_ != NULL) {
		goto __catch45_g_error;
	}
	_tmp8_ = _tmp7_;
	_g_object_unref0 (self->priv->cache);
	self->priv->cache = _tmp8_;
	goto __finally45;
	__catch45_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (_error_);
	}
	__finally45:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	g_signal_connect_object (self->priv->extractor, "extraction-done", (GCallback) _rygel_media_export_harvesting_task_on_extracted_cb_rygel_media_export_metadata_extractor_extraction_done, self, 0);
	g_signal_connect_object (self->priv->extractor, "error", (GCallback) _rygel_media_export_harvesting_task_on_extractor_error_cb_rygel_media_export_metadata_extractor_error, self, 0);
	_tmp9_ = gee_linked_list_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	_tmp10_ = (GeeQueue*) _tmp9_;
	_g_object_unref0 (self->priv->files);
	self->priv->files = _tmp10_;
	_tmp11_ = g_queue_new ();
	_tmp12_ = _tmp11_;
	_g_queue_free0 (self->priv->containers);
	self->priv->containers = _tmp12_;
	_tmp13_ = _g_object_ref0 (monitor);
	_tmp14_ = _tmp13_;
	_g_object_unref0 (self->priv->monitor);
	self->priv->monitor = _tmp14_;
	_tmp15_ = g_strdup (flag);
	_tmp16_ = _tmp15_;
	_g_free0 (self->priv->flag);
	self->priv->flag = _tmp16_;
	_tmp17_ = _g_regex_ref0 (file_filter);
	_tmp18_ = _tmp17_;
	_g_regex_unref0 (self->priv->file_filter);
	self->priv->file_filter = _tmp18_;
	return self;
}


RygelMediaExportHarvestingTask* rygel_media_export_harvesting_task_new (RygelMediaExportMetadataExtractor* extractor, RygelMediaExportRecursiveFileMonitor* monitor, GRegex* file_filter, GFile* file, RygelMediaContainer* parent, const gchar* flag) {
	return rygel_media_export_harvesting_task_construct (RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, extractor, monitor, file_filter, file, parent, flag);
}


void rygel_media_export_harvesting_task_cancel (RygelMediaExportHarvestingTask* self) {
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_cancellable_new ();
	_tmp1_ = _tmp0_;
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
	g_cancellable_cancel (_tmp2_);
}


static void rygel_media_export_harvesting_task_real_run_data_free (gpointer _data) {
	RygelMediaExportHarvestingTaskRunData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (RygelMediaExportHarvestingTaskRunData, data);
}


static void rygel_media_export_harvesting_task_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportHarvestingTask * self;
	RygelMediaExportHarvestingTaskRunData* _data_;
	self = (RygelMediaExportHarvestingTask*) base;
	_data_ = g_slice_new0 (RygelMediaExportHarvestingTaskRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_export_harvesting_task_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_export_harvesting_task_real_run_data_free);
	_data_->self = _g_object_ref0 (self);
	rygel_media_export_harvesting_task_real_run_co (_data_);
}


static void rygel_media_export_harvesting_task_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelMediaExportHarvestingTaskRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
     * Extract all metainformation from a given file.
     *
     * What action will be taken depends on the arguments
     * * file is a simple file. Then only information of this
     *   file will be extracted
     * * file is a directory and recursive is false. The children
     *   of the directory (if not directories themselves) will be
     *   enqueued for extraction
     * * file is a directory and recursive is true. ++ All ++ children
     *   of the directory will be enqueued for extraction, even directories
     *
     * No matter how many children are contained within file's hierarchy,
     * only one event is sent when all the children are done.
     */
static void rygel_media_export_harvesting_task_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaExportHarvestingTaskRunData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_media_export_harvesting_task_real_run_co (data);
}


static gboolean _rygel_media_export_harvesting_task_on_idle_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_media_export_harvesting_task_on_idle (self);
	return result;
}


static gboolean rygel_media_export_harvesting_task_real_run_co (RygelMediaExportHarvestingTaskRunData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self);
	data->_state_ = 1;
	g_file_query_info_async (data->self->origin, RYGEL_MEDIA_EXPORT_HARVESTING_TASK_HARVESTER_ATTRIBUTES, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, data->_tmp0_, rygel_media_export_harvesting_task_run_ready, data);
	return FALSE;
	_state_1:
	data->_tmp1_ = NULL;
	data->_tmp1_ = g_file_query_info_finish (data->self->origin, data->_res_, &data->_inner_error_);
	data->info = data->_tmp1_;
	if (data->_inner_error_ != NULL) {
		goto __catch46_g_error;
	}
	data->_tmp2_ = rygel_media_export_harvesting_task_process_file (data->self, data->self->origin, data->info, data->self->priv->parent);
	if (data->_tmp2_) {
		data->_tmp3_ = g_file_info_get_file_type (data->info);
		if (data->_tmp3_ != G_FILE_TYPE_DIRECTORY) {
			data->_tmp4_ = _g_object_ref0 (data->self->priv->parent);
			g_queue_push_tail (data->self->priv->containers, data->_tmp4_);
		}
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _rygel_media_export_harvesting_task_on_idle_gsource_func, g_object_ref (data->self), g_object_unref);
	} else {
		g_signal_emit_by_name ((RygelStateMachine*) data->self, "completed");
	}
	_g_object_unref0 (data->info);
	goto __finally46;
	__catch46_g_error:
	{
		data->_error_ = data->_inner_error_;
		data->_inner_error_ = NULL;
		if (!g_error_matches (data->_error_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
			data->_tmp5_ = NULL;
			data->_tmp5_ = _ ("Failed to harvest file %s: %s");
			data->_tmp6_ = NULL;
			data->_tmp6_ = g_file_get_uri (data->self->origin);
			data->_tmp7_ = data->_tmp6_;
			g_warning (data->_tmp5_, data->_tmp7_, data->_error_->message);
			_g_free0 (data->_tmp7_);
		} else {
			data->_tmp8_ = NULL;
			data->_tmp8_ = g_file_get_uri (data->self->origin);
			data->_tmp9_ = data->_tmp8_;
			g_debug ("rygel-media-export-harvesting-task.vala:119: Harvesting of uri %s was " \
"cancelled", data->_tmp9_);
			_g_free0 (data->_tmp9_);
		}
		g_signal_emit_by_name ((RygelStateMachine*) data->self, "completed");
		_g_error_free0 (data->_error_);
	}
	__finally46:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


/**
     * Add a file to the meta-data extraction queue.
     *
     * The file will only be added to the queue if one of the following
     * conditions is met:
     *   - The file is not in the cache
     *   - The current mtime of the file is larger than the cached
     *   - The size has changed
     * @param file to check
     * @param info FileInfo of the file to check
     * @return true, if the file has been queued, false otherwise.
     */
static gboolean rygel_media_export_harvesting_task_push_if_changed_or_unknown (RygelMediaExportHarvestingTask* self, GFile* file, GFileInfo* info) {
	gboolean result = FALSE;
	gint64 timestamp = 0LL;
	gint64 size = 0LL;
	gint64 _tmp0_;
	gint64 _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	g_return_val_if_fail (info != NULL, FALSE);
	_tmp2_ = rygel_media_export_media_cache_exists (self->priv->cache, file, &_tmp0_, &_tmp1_, &_inner_error_);
	timestamp = _tmp0_;
	size = _tmp1_;
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		goto __catch47_g_error;
	}
	if (_tmp3_) {
		guint64 _tmp4_;
		gint64 mtime;
		gboolean _tmp5_ = FALSE;
		_tmp4_ = g_file_info_get_attribute_uint64 (info, G_FILE_ATTRIBUTE_TIME_MODIFIED);
		mtime = (gint64) _tmp4_;
		if (mtime > timestamp) {
			_tmp5_ = TRUE;
		} else {
			gint64 _tmp6_;
			_tmp6_ = g_file_info_get_size (info);
			_tmp5_ = _tmp6_ != size;
		}
		if (_tmp5_) {
			gee_queue_offer (self->priv->files, file);
			result = TRUE;
			return result;
		}
	} else {
		gee_queue_offer (self->priv->files, file);
		result = TRUE;
		return result;
	}
	goto __finally47;
	__catch47_g_error:
	{
		GError * _error_;
		const gchar* _tmp7_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = _ ("Failed to query database: %s");
		g_warning (_tmp7_, _error_->message);
		_g_error_free0 (_error_);
	}
	__finally47:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


static gboolean rygel_media_export_harvesting_task_process_file (RygelMediaExportHarvestingTask* self, GFile* file, GFileInfo* info, RygelMediaContainer* parent) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar _tmp1_;
	GFileType _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	g_return_val_if_fail (info != NULL, FALSE);
	g_return_val_if_fail (parent != NULL, FALSE);
	_tmp0_ = g_file_info_get_name (info);
	_tmp1_ = string_get (_tmp0_, (glong) 0);
	if (_tmp1_ == '.') {
		result = FALSE;
		return result;
	}
	_tmp2_ = g_file_info_get_file_type (info);
	if (_tmp2_ == G_FILE_TYPE_DIRECTORY) {
		RygelMediaExportDummyContainer* _tmp3_ = NULL;
		RygelMediaExportDummyContainer* container;
		RygelMediaContainer* _tmp4_;
		rygel_media_export_recursive_file_monitor_add (self->priv->monitor, file, NULL, NULL);
		_tmp3_ = rygel_media_export_dummy_container_new (file, parent);
		container = _tmp3_;
		_tmp4_ = _g_object_ref0 ((RygelMediaContainer*) container);
		g_queue_push_tail (self->priv->containers, _tmp4_);
		rygel_media_export_media_cache_save_container (self->priv->cache, (RygelMediaContainer*) container, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch48_g_error;
		}
		goto __finally48;
		__catch48_g_error:
		{
			GError * err;
			const gchar* _tmp5_ = NULL;
			err = _inner_error_;
			_inner_error_ = NULL;
			_tmp5_ = _ ("Failed to update database: %s");
			g_warning (_tmp5_, err->message);
			result = FALSE;
			_g_error_free0 (err);
			_g_object_unref0 (container);
			return result;
		}
		__finally48:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (container);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		result = TRUE;
		_g_object_unref0 (container);
		return result;
	} else {
		gboolean _tmp6_ = FALSE;
		gboolean _tmp10_;
		if (self->priv->file_filter != NULL) {
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			gboolean _tmp9_;
			_tmp7_ = g_file_get_uri (file);
			_tmp8_ = _tmp7_;
			_tmp9_ = g_regex_match (self->priv->file_filter, _tmp8_, 0, NULL);
			_tmp6_ = !_tmp9_;
			_g_free0 (_tmp8_);
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			result = FALSE;
			return result;
		}
		_tmp10_ = rygel_media_export_harvesting_task_push_if_changed_or_unknown (self, file, info);
		result = _tmp10_;
		return result;
	}
}


static gboolean rygel_media_export_harvesting_task_process_children (RygelMediaExportHarvestingTask* self, GList* list) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gconstpointer _tmp3_ = NULL;
	RygelMediaContainer* _tmp4_;
	RygelMediaExportDummyContainer* _tmp5_;
	RygelMediaExportDummyContainer* container;
	g_return_val_if_fail (self != NULL, FALSE);
	if (list == NULL) {
		_tmp0_ = TRUE;
	} else {
		GCancellable* _tmp1_ = NULL;
		gboolean _tmp2_;
		_tmp1_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
		_tmp2_ = g_cancellable_is_cancelled (_tmp1_);
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = g_queue_peek_head (self->priv->containers);
	_tmp5_ = _g_object_ref0 ((_tmp4_ = (RygelMediaContainer*) _tmp3_, RYGEL_MEDIA_EXPORT_IS_DUMMY_CONTAINER (_tmp4_) ? ((RygelMediaExportDummyContainer*) _tmp4_) : NULL));
	container = _tmp5_;
	{
		GList* info_collection;
		GList* info_it;
		info_collection = list;
		for (info_it = info_collection; info_it != NULL; info_it = info_it->next) {
			GFileInfo* _tmp6_;
			GFileInfo* info;
			_tmp6_ = _g_object_ref0 ((GFileInfo*) info_it->data);
			info = _tmp6_;
			{
				const gchar* _tmp7_ = NULL;
				GFile* _tmp8_ = NULL;
				GFile* file;
				_tmp7_ = g_file_info_get_name (info);
				_tmp8_ = g_file_get_child (container->file, _tmp7_);
				file = _tmp8_;
				rygel_media_export_dummy_container_seen (container, file);
				rygel_media_export_harvesting_task_process_file (self, file, info, (RygelMediaContainer*) container);
				_g_object_unref0 (file);
				_g_object_unref0 (info);
			}
		}
	}
	result = TRUE;
	_g_object_unref0 (container);
	return result;
}


static void rygel_media_export_harvesting_task_enumerate_directory_data_free (gpointer _data) {
	RygelMediaExportHarvestingTaskEnumerateDirectoryData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (RygelMediaExportHarvestingTaskEnumerateDirectoryData, data);
}


static void rygel_media_export_harvesting_task_enumerate_directory (RygelMediaExportHarvestingTask* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportHarvestingTaskEnumerateDirectoryData* _data_;
	_data_ = g_slice_new0 (RygelMediaExportHarvestingTaskEnumerateDirectoryData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_export_harvesting_task_enumerate_directory);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_export_harvesting_task_enumerate_directory_data_free);
	_data_->self = _g_object_ref0 (self);
	rygel_media_export_harvesting_task_enumerate_directory_co (_data_);
}


static void rygel_media_export_harvesting_task_enumerate_directory_finish (RygelMediaExportHarvestingTask* self, GAsyncResult* _res_) {
	RygelMediaExportHarvestingTaskEnumerateDirectoryData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_media_export_harvesting_task_enumerate_directory_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaExportHarvestingTaskEnumerateDirectoryData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_media_export_harvesting_task_enumerate_directory_co (data);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gboolean rygel_media_export_harvesting_task_enumerate_directory_co (RygelMediaExportHarvestingTaskEnumerateDirectoryData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_queue_peek_head (data->self->priv->containers);
	data->_tmp2_ = _g_object_ref0 ((data->_tmp1_ = (RygelMediaContainer*) data->_tmp0_, RYGEL_MEDIA_EXPORT_IS_DUMMY_CONTAINER (data->_tmp1_) ? ((RygelMediaExportDummyContainer*) data->_tmp1_) : NULL)->file);
	data->directory = data->_tmp2_;
	data->_tmp3_ = NULL;
	data->_tmp3_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self);
	data->_state_ = 1;
	g_file_enumerate_children_async (data->directory, RYGEL_MEDIA_EXPORT_HARVESTING_TASK_HARVESTER_ATTRIBUTES, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, data->_tmp3_, rygel_media_export_harvesting_task_enumerate_directory_ready, data);
	return FALSE;
	_state_1:
	data->_tmp4_ = NULL;
	data->_tmp4_ = g_file_enumerate_children_finish (data->directory, data->_res_, &data->_inner_error_);
	data->enumerator = data->_tmp4_;
	if (data->_inner_error_ != NULL) {
		goto __catch49_g_error;
	}
	data->list = NULL;
	{
		data->_tmp5_ = TRUE;
		while (TRUE) {
			if (!data->_tmp5_) {
				data->_tmp6_ = rygel_media_export_harvesting_task_process_children (data->self, data->list);
				if (!data->_tmp6_) {
					break;
				}
			}
			data->_tmp5_ = FALSE;
			data->_tmp7_ = NULL;
			data->_tmp7_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self);
			data->_state_ = 2;
			g_file_enumerator_next_files_async (data->enumerator, RYGEL_MEDIA_EXPORT_HARVESTING_TASK_BATCH_SIZE, G_PRIORITY_DEFAULT, data->_tmp7_, rygel_media_export_harvesting_task_enumerate_directory_ready, data);
			return FALSE;
			_state_2:
			data->_tmp8_ = NULL;
			data->_tmp8_ = g_file_enumerator_next_files_finish (data->enumerator, data->_res_, &data->_inner_error_);
			data->_tmp9_ = data->_tmp8_;
			if (data->_inner_error_ != NULL) {
				__g_list_free__g_object_unref0_0 (data->list);
				_g_object_unref0 (data->enumerator);
				goto __catch49_g_error;
			}
			data->_tmp10_ = data->_tmp9_;
			__g_list_free__g_object_unref0_0 (data->list);
			data->list = data->_tmp10_;
		}
	}
	data->_tmp11_ = NULL;
	data->_tmp11_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self);
	data->_state_ = 3;
	g_file_enumerator_close_async (data->enumerator, G_PRIORITY_DEFAULT, data->_tmp11_, rygel_media_export_harvesting_task_enumerate_directory_ready, data);
	return FALSE;
	_state_3:
	g_file_enumerator_close_finish (data->enumerator, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		__g_list_free__g_object_unref0_0 (data->list);
		_g_object_unref0 (data->enumerator);
		goto __catch49_g_error;
	}
	__g_list_free__g_object_unref0_0 (data->list);
	_g_object_unref0 (data->enumerator);
	goto __finally49;
	__catch49_g_error:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp12_ = NULL;
		data->_tmp12_ = _ ("failed to enumerate folder: %s");
		g_warning (data->_tmp12_, data->err->message);
		_g_error_free0 (data->err);
	}
	__finally49:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->directory);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	rygel_media_export_harvesting_task_cleanup_database (data->self);
	rygel_media_export_harvesting_task_do_update (data->self);
	_g_object_unref0 (data->directory);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_media_export_harvesting_task_cleanup_database (RygelMediaExportHarvestingTask* self) {
	gconstpointer _tmp0_ = NULL;
	RygelMediaContainer* _tmp1_;
	RygelMediaExportDummyContainer* _tmp2_;
	RygelMediaExportDummyContainer* container;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_queue_peek_head (self->priv->containers);
	_tmp2_ = _g_object_ref0 ((_tmp1_ = (RygelMediaContainer*) _tmp0_, RYGEL_MEDIA_EXPORT_IS_DUMMY_CONTAINER (_tmp1_) ? ((RygelMediaExportDummyContainer*) _tmp1_) : NULL));
	container = _tmp2_;
	{
		GeeList* _tmp3_;
		GeeList* _child_list;
		gint _tmp4_;
		gint _child_size;
		gint _child_index;
		_tmp3_ = _g_object_ref0 (container->children);
		_child_list = _tmp3_;
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _child_list);
		_child_size = _tmp4_;
		_child_index = -1;
		while (TRUE) {
			gpointer _tmp5_ = NULL;
			gchar* child;
			_child_index = _child_index + 1;
			if (!(_child_index < _child_size)) {
				break;
			}
			_tmp5_ = gee_list_get (_child_list, _child_index);
			child = (gchar*) _tmp5_;
			rygel_media_export_media_cache_remove_by_id (self->priv->cache, child, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_free0 (child);
				_g_object_unref0 (_child_list);
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
					goto __catch50_rygel_media_export_database_error;
				}
				_g_free0 (child);
				_g_object_unref0 (_child_list);
				_g_object_unref0 (container);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_g_free0 (child);
		}
		_g_object_unref0 (_child_list);
	}
	goto __finally50;
	__catch50_rygel_media_export_database_error:
	{
		GError * _error_;
		const gchar* _tmp6_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = _ ("Failed to get children of container %s: %s");
		g_warning (_tmp6_, ((RygelMediaObject*) container)->id, _error_->message);
		_g_error_free0 (_error_);
	}
	__finally50:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (container);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (container);
}


static gboolean rygel_media_export_harvesting_task_on_idle (RygelMediaExportHarvestingTask* self) {
	gboolean result = FALSE;
	GCancellable* _tmp0_ = NULL;
	gboolean _tmp1_;
	gint _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
	_tmp1_ = g_cancellable_is_cancelled (_tmp0_);
	if (_tmp1_) {
		g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
		result = FALSE;
		return result;
	}
	_tmp2_ = gee_collection_get_size ((GeeCollection*) self->priv->files);
	if (_tmp2_ > 0) {
		gpointer _tmp3_ = NULL;
		GFile* _tmp4_;
		_tmp3_ = gee_queue_peek (self->priv->files);
		_tmp4_ = (GFile*) _tmp3_;
		rygel_media_export_metadata_extractor_extract (self->priv->extractor, _tmp4_);
		_g_object_unref0 (_tmp4_);
	} else {
		guint _tmp5_;
		_tmp5_ = g_queue_get_length (self->priv->containers);
		if (_tmp5_ > 0) {
			rygel_media_export_harvesting_task_enumerate_directory (self, NULL, NULL);
		} else {
			if (self->priv->flag != NULL) {
				rygel_media_export_media_cache_flag_object (self->priv->cache, self->origin, self->priv->flag, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch51_g_error;
				}
				goto __finally51;
				__catch51_g_error:
				{
					GError * _error_;
					_error_ = _inner_error_;
					_inner_error_ = NULL;
					_g_error_free0 (_error_);
				}
				__finally51:
				if (_inner_error_ != NULL) {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
			}
			g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
		}
	}
	result = FALSE;
	return result;
}


static void rygel_media_export_harvesting_task_on_extracted_cb (RygelMediaExportHarvestingTask* self, GFile* file, GUPnPDLNAInformation* dlna, const gchar* mime, guint64 size, guint64 mtime) {
	GCancellable* _tmp0_ = NULL;
	gboolean _tmp1_;
	gpointer _tmp2_ = NULL;
	GFile* entry;
	gboolean _tmp3_ = FALSE;
	RygelMediaItem* item;
	gpointer _tmp11_ = NULL;
	GFile* _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (mime != NULL);
	_tmp0_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
	_tmp1_ = g_cancellable_is_cancelled (_tmp0_);
	if (_tmp1_) {
		g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
	}
	_tmp2_ = gee_queue_peek (self->priv->files);
	entry = (GFile*) _tmp2_;
	if (entry == NULL) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = file != entry;
	}
	if (_tmp3_) {
		_g_object_unref0 (entry);
		return;
	}
	item = NULL;
	if (dlna == NULL) {
		gconstpointer _tmp4_ = NULL;
		RygelMediaItem* _tmp5_ = NULL;
		RygelMediaItem* _tmp6_;
		_tmp4_ = g_queue_peek_head (self->priv->containers);
		_tmp5_ = rygel_media_export_item_factory_create_simple ((RygelMediaContainer*) _tmp4_, file, mime, size, mtime);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (item);
		item = _tmp6_;
	} else {
		gconstpointer _tmp7_ = NULL;
		RygelMediaItem* _tmp8_ = NULL;
		RygelMediaItem* _tmp9_;
		_tmp7_ = g_queue_peek_head (self->priv->containers);
		_tmp8_ = rygel_media_export_item_factory_create_from_info ((RygelMediaContainer*) _tmp7_, file, dlna, mime, size, mtime);
		_tmp9_ = _tmp8_;
		_g_object_unref0 (item);
		item = _tmp9_;
	}
	if (item != NULL) {
		gconstpointer _tmp10_ = NULL;
		_tmp10_ = g_queue_peek_head (self->priv->containers);
		rygel_media_object_set_parent_ref ((RygelMediaObject*) item, (RygelMediaContainer*) _tmp10_);
		rygel_media_export_media_cache_save_item (self->priv->cache, item, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch52_g_error;
		}
		goto __finally52;
		__catch52_g_error:
		{
			GError * _error_;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (_error_);
		}
		__finally52:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (item);
			_g_object_unref0 (entry);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp11_ = gee_queue_poll (self->priv->files);
	_tmp12_ = (GFile*) _tmp11_;
	_g_object_unref0 (_tmp12_);
	rygel_media_export_harvesting_task_do_update (self);
	_g_object_unref0 (item);
	_g_object_unref0 (entry);
}


static void rygel_media_export_harvesting_task_on_extractor_error_cb (RygelMediaExportHarvestingTask* self, GFile* file, GError* _error_) {
	gpointer _tmp0_ = NULL;
	GFile* entry;
	gboolean _tmp1_ = FALSE;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gpointer _tmp4_ = NULL;
	GFile* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = gee_queue_peek (self->priv->files);
	entry = (GFile*) _tmp0_;
	if (entry == NULL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = file != entry;
	}
	if (_tmp1_) {
		_g_object_unref0 (entry);
		return;
	}
	_tmp2_ = g_file_get_uri (file);
	_tmp3_ = _tmp2_;
	g_debug ("rygel-media-export-harvesting-task.vala:338: Skipping %s; extraction c" \
"ompletely failed: %s", _tmp3_, _error_->message);
	_g_free0 (_tmp3_);
	_tmp4_ = gee_queue_poll (self->priv->files);
	_tmp5_ = (GFile*) _tmp4_;
	_g_object_unref0 (_tmp5_);
	rygel_media_export_harvesting_task_do_update (self);
	_g_object_unref0 (entry);
}


/**
     * If all files of a container were processed, notify the container
     * about this and set the updating signal.
     * Reschedule the iteration and extraction
     */
static void rygel_media_export_harvesting_task_do_update (RygelMediaExportHarvestingTask* self) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = gee_collection_get_size ((GeeCollection*) self->priv->files);
	if (_tmp1_ == 0) {
		guint _tmp2_;
		_tmp2_ = g_queue_get_length (self->priv->containers);
		_tmp0_ = _tmp2_ != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gconstpointer _tmp3_ = NULL;
		gpointer _tmp4_ = NULL;
		RygelMediaContainer* _tmp5_;
		_tmp3_ = g_queue_peek_head (self->priv->containers);
		rygel_media_container_updated ((RygelMediaContainer*) _tmp3_);
		_tmp4_ = g_queue_pop_head (self->priv->containers);
		_tmp5_ = (RygelMediaContainer*) _tmp4_;
		_g_object_unref0 (_tmp5_);
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _rygel_media_export_harvesting_task_on_idle_gsource_func, g_object_ref (self), g_object_unref);
}


static GCancellable* rygel_media_export_harvesting_task_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelMediaExportHarvestingTask* self;
	self = (RygelMediaExportHarvestingTask*) base;
	result = self->priv->_cancellable;
	return result;
}


static void rygel_media_export_harvesting_task_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelMediaExportHarvestingTask* self;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	self = (RygelMediaExportHarvestingTask*) base;
	_tmp0_ = _g_object_ref0 (value);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->_cancellable);
	self->priv->_cancellable = _tmp1_;
	g_object_notify ((GObject *) self, "cancellable");
}


static void rygel_media_export_harvesting_task_class_init (RygelMediaExportHarvestingTaskClass * klass) {
	rygel_media_export_harvesting_task_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaExportHarvestingTaskPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_export_harvesting_task_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_export_harvesting_task_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_harvesting_task_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CANCELLABLE, "cancellable");
}


static void rygel_media_export_harvesting_task_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
	rygel_media_export_harvesting_task_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = (void (*)(RygelStateMachine*)) rygel_media_export_harvesting_task_real_run;
	iface->run_finish = rygel_media_export_harvesting_task_real_run_finish;
	iface->get_cancellable = rygel_media_export_harvesting_task_real_get_cancellable;
	iface->set_cancellable = rygel_media_export_harvesting_task_real_set_cancellable;
}


static void rygel_media_export_harvesting_task_instance_init (RygelMediaExportHarvestingTask * self) {
	self->priv = RYGEL_MEDIA_EXPORT_HARVESTING_TASK_GET_PRIVATE (self);
}


static void rygel_media_export_harvesting_task_finalize (GObject* obj) {
	RygelMediaExportHarvestingTask * self;
	self = RYGEL_MEDIA_EXPORT_HARVESTING_TASK (obj);
	_g_object_unref0 (self->origin);
	_g_object_unref0 (self->priv->extractor);
	_g_object_unref0 (self->priv->cache);
	_g_queue_free0 (self->priv->containers);
	_g_object_unref0 (self->priv->files);
	_g_object_unref0 (self->priv->monitor);
	_g_regex_unref0 (self->priv->file_filter);
	_g_free0 (self->priv->flag);
	_g_object_unref0 (self->priv->parent);
	_g_object_unref0 (self->priv->_cancellable);
	G_OBJECT_CLASS (rygel_media_export_harvesting_task_parent_class)->finalize (obj);
}


GType rygel_media_export_harvesting_task_get_type (void) {
	static volatile gsize rygel_media_export_harvesting_task_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_harvesting_task_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportHarvestingTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_harvesting_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportHarvestingTask), 0, (GInstanceInitFunc) rygel_media_export_harvesting_task_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_media_export_harvesting_task_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_media_export_harvesting_task_type_id;
		rygel_media_export_harvesting_task_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportHarvestingTask", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_media_export_harvesting_task_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_media_export_harvesting_task_type_id__volatile, rygel_media_export_harvesting_task_type_id);
	}
	return rygel_media_export_harvesting_task_type_id__volatile;
}


static void _vala_rygel_media_export_harvesting_task_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaExportHarvestingTask * self;
	self = RYGEL_MEDIA_EXPORT_HARVESTING_TASK (object);
	switch (property_id) {
		case RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CANCELLABLE:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_media_export_harvesting_task_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaExportHarvestingTask * self;
	self = RYGEL_MEDIA_EXPORT_HARVESTING_TASK (object);
	switch (property_id) {
		case RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CANCELLABLE:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



