/* rygel-external-icon-factory.c generated by valac 0.11.2, the Vala compiler
 * generated from rygel-external-icon-factory.vala, do not modify */

/*
 * Copyright (C) 2009 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <rygel.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_EXTERNAL_TYPE_ICON_FACTORY (rygel_external_icon_factory_get_type ())
#define RYGEL_EXTERNAL_ICON_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_EXTERNAL_TYPE_ICON_FACTORY, RygelExternalIconFactory))
#define RYGEL_EXTERNAL_ICON_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_EXTERNAL_TYPE_ICON_FACTORY, RygelExternalIconFactoryClass))
#define RYGEL_EXTERNAL_IS_ICON_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_EXTERNAL_TYPE_ICON_FACTORY))
#define RYGEL_EXTERNAL_IS_ICON_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_EXTERNAL_TYPE_ICON_FACTORY))
#define RYGEL_EXTERNAL_ICON_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_EXTERNAL_TYPE_ICON_FACTORY, RygelExternalIconFactoryClass))

typedef struct _RygelExternalIconFactory RygelExternalIconFactory;
typedef struct _RygelExternalIconFactoryClass RygelExternalIconFactoryClass;
typedef struct _RygelExternalIconFactoryPrivate RygelExternalIconFactoryPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))
#define _rygel_external_icon_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_external_icon_factory_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelExternalIconFactoryCreateData RygelExternalIconFactoryCreateData;
typedef struct _RygelExternalParamSpecIconFactory RygelExternalParamSpecIconFactory;

struct _RygelExternalIconFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelExternalIconFactoryPrivate * priv;
};

struct _RygelExternalIconFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelExternalIconFactory *self);
};

struct _RygelExternalIconFactoryCreateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalIconFactory* self;
	gchar* service_name;
	GHashTable* container_props;
	RygelIconInfo* result;
	gconstpointer _tmp0_;
	GVariant* _tmp1_;
	GVariant* value;
	gchar* _tmp2_;
	gchar* icon_path;
	FreeDesktopProperties* props;
	GHashTable* _tmp3_;
	GHashTable* item_props;
	RygelIconInfo* _tmp4_;
	GError * _inner_error_;
};

struct _RygelExternalParamSpecIconFactory {
	GParamSpec parent_instance;
};


static gpointer rygel_external_icon_factory_parent_class = NULL;
static gchar* rygel_external_icon_factory_ITEM_IFACE;
static gchar* rygel_external_icon_factory_ITEM_IFACE = NULL;

gpointer rygel_external_icon_factory_ref (gpointer instance);
void rygel_external_icon_factory_unref (gpointer instance);
GParamSpec* rygel_external_param_spec_icon_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_external_value_set_icon_factory (GValue* value, gpointer v_object);
void rygel_external_value_take_icon_factory (GValue* value, gpointer v_object);
gpointer rygel_external_value_get_icon_factory (const GValue* value);
GType rygel_external_icon_factory_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_EXTERNAL_ICON_FACTORY_DUMMY_PROPERTY
};
static void rygel_external_icon_factory_create_data_free (gpointer _data);
static void rygel_external_icon_factory_create_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_external_icon_factory_create (RygelExternalIconFactory* self, const gchar* service_name, GHashTable* container_props, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelIconInfo* rygel_external_icon_factory_create_finish (RygelExternalIconFactory* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_external_icon_factory_create_co (RygelExternalIconFactoryCreateData* data);
static const gchar* _variant_get26 (GVariant* value);
static RygelIconInfo* rygel_external_icon_factory_create_from_props (RygelExternalIconFactory* self, GHashTable* props);
static const gchar* _variant_get27 (GVariant* value);
static gchar* rygel_external_icon_factory_get_ext_for_mime (RygelExternalIconFactory* self, const gchar* mime_type);
static gchar** _variant_get28 (GVariant* value, int* result_length1);
static gchar** _vala_array_dup5 (gchar** self, int length);
static gint64 _variant_get29 (GVariant* value);
static gint rygel_external_icon_factory_get_int (RygelExternalIconFactory* self, GHashTable* props, const gchar* prop);
static gint _variant_get30 (GVariant* value);
RygelExternalIconFactory* rygel_external_icon_factory_new (void);
RygelExternalIconFactory* rygel_external_icon_factory_construct (GType object_type);
static void rygel_external_icon_factory_finalize (RygelExternalIconFactory* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void rygel_external_icon_factory_create_data_free (gpointer _data) {
	RygelExternalIconFactoryCreateData* data;
	data = _data;
	_g_free0 (data->service_name);
	_g_hash_table_unref0 (data->container_props);
	_rygel_icon_info_unref0 (data->result);
	_rygel_external_icon_factory_unref0 (data->self);
	g_slice_free (RygelExternalIconFactoryCreateData, data);
}


static gpointer _rygel_external_icon_factory_ref0 (gpointer self) {
	return self ? rygel_external_icon_factory_ref (self) : NULL;
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


void rygel_external_icon_factory_create (RygelExternalIconFactory* self, const gchar* service_name, GHashTable* container_props, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalIconFactoryCreateData* _data_;
	_data_ = g_slice_new0 (RygelExternalIconFactoryCreateData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, rygel_external_icon_factory_create);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_icon_factory_create_data_free);
	_data_->self = _rygel_external_icon_factory_ref0 (self);
	_data_->service_name = g_strdup (service_name);
	_data_->container_props = _g_hash_table_ref0 (container_props);
	rygel_external_icon_factory_create_co (_data_);
}


RygelIconInfo* rygel_external_icon_factory_create_finish (RygelExternalIconFactory* self, GAsyncResult* _res_, GError** error) {
	RygelIconInfo* result;
	RygelExternalIconFactoryCreateData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_external_icon_factory_create_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalIconFactoryCreateData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_external_icon_factory_create_co (data);
}


static gpointer _g_variant_ref0 (gpointer self) {
	return self ? g_variant_ref (self) : NULL;
}


static const gchar* _variant_get26 (GVariant* value) {
	return g_variant_dup_string (value, NULL);
}


static gboolean rygel_external_icon_factory_create_co (RygelExternalIconFactoryCreateData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_hash_table_lookup (data->container_props, "Icon");
	data->_tmp1_ = _g_variant_ref0 ((GVariant*) data->_tmp0_);
	data->value = data->_tmp1_;
	if (data->value == NULL) {
		data->result = NULL;
		_g_variant_unref0 (data->value);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp2_ = g_strdup (_variant_get26 (data->value));
	data->icon_path = data->_tmp2_;
	data->_state_ = 1;
	g_async_initable_new_async (FREE_DESKTOP_TYPE_PROPERTIES_PROXY, 0, NULL, rygel_external_icon_factory_create_ready, data, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", data->service_name, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", data->icon_path, "g-interface-name", "org.freedesktop.DBus.Properties", NULL);
	return FALSE;
	_state_1:
	data->props = (FreeDesktopProperties*) g_async_initable_new_finish (data->_source_object_, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == G_IO_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_free0 (data->icon_path);
			_g_variant_unref0 (data->value);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_free0 (data->icon_path);
			_g_variant_unref0 (data->value);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->_state_ = 2;
	free_desktop_properties_get_all (data->props, rygel_external_icon_factory_ITEM_IFACE, rygel_external_icon_factory_create_ready, data);
	return FALSE;
	_state_2:
	data->_tmp3_ = NULL;
	data->_tmp3_ = free_desktop_properties_get_all_finish (data->props, data->_res_, &data->_inner_error_);
	data->item_props = data->_tmp3_;
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == G_IO_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->props);
			_g_free0 (data->icon_path);
			_g_variant_unref0 (data->value);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (data->props);
			_g_free0 (data->icon_path);
			_g_variant_unref0 (data->value);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->_tmp4_ = NULL;
	data->_tmp4_ = rygel_external_icon_factory_create_from_props (data->self, data->item_props);
	data->result = data->_tmp4_;
	_g_hash_table_unref0 (data->item_props);
	_g_object_unref0 (data->props);
	_g_free0 (data->icon_path);
	_g_variant_unref0 (data->value);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_hash_table_unref0 (data->item_props);
	_g_object_unref0 (data->props);
	_g_free0 (data->icon_path);
	_g_variant_unref0 (data->value);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static const gchar* _variant_get27 (GVariant* value) {
	return g_variant_dup_string (value, NULL);
}


static gchar** _variant_get28 (GVariant* value, int* result_length1) {
	gchar** _tmp8_;
	int _tmp8__length;
	int _tmp8__size;
	int _tmp8__length1;
	GVariantIter _tmp9_;
	GVariant* _tmp10_;
	_tmp8_ = g_new (gchar*, 5);
	_tmp8__length = 0;
	_tmp8__size = 4;
	_tmp8__length1 = 0;
	g_variant_iter_init (&_tmp9_, value);
	for (; _tmp10_ = g_variant_iter_next_value (&_tmp9_); _tmp8__length1++) {
		if (_tmp8__size == _tmp8__length) {
			_tmp8__size = 2 * _tmp8__size;
			_tmp8_ = g_renew (gchar*, _tmp8_, _tmp8__size + 1);
		}
		_tmp8_[_tmp8__length++] = g_variant_dup_string (_tmp10_, NULL);
		g_variant_unref (_tmp10_);
	}
	*result_length1 = _tmp8__length1;
	_tmp8_[_tmp8__length] = NULL;
	return _tmp8_;
}


static gchar** _vala_array_dup5 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static gint64 _variant_get29 (GVariant* value) {
	return g_variant_get_int64 (value);
}


static RygelIconInfo* rygel_external_icon_factory_create_from_props (RygelExternalIconFactory* self, GHashTable* props) {
	RygelIconInfo* result = NULL;
	gconstpointer _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* mime_type;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	RygelIconInfo* _tmp4_ = NULL;
	RygelIconInfo* _tmp5_;
	RygelIconInfo* icon;
	gconstpointer _tmp6_ = NULL;
	gint _tmp7_;
	gchar** _tmp11_;
	gchar** _tmp12_;
	gint uris_length1;
	gint _uris_size_;
	gchar** _tmp13_;
	gchar** uris;
	gboolean _tmp14_ = FALSE;
	gconstpointer _tmp17_ = NULL;
	GVariant* _tmp18_;
	GVariant* value;
	gint _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (props != NULL, NULL);
	_tmp0_ = g_hash_table_lookup (props, "MIMEType");
	_tmp1_ = g_strdup (_variant_get27 ((GVariant*) _tmp0_));
	mime_type = _tmp1_;
	_tmp2_ = rygel_external_icon_factory_get_ext_for_mime (self, mime_type);
	_tmp3_ = _tmp2_;
	_tmp4_ = rygel_icon_info_new (mime_type, _tmp3_);
	icon = (_tmp5_ = _tmp4_, _g_free0 (_tmp3_), _tmp5_);
	_tmp6_ = g_hash_table_lookup (props, "URLs");
	_tmp11_ = (_tmp12_ = _variant_get28 ((GVariant*) _tmp6_, &_tmp7_), (_tmp12_ == NULL) ? ((gpointer) _tmp12_) : _vala_array_dup5 (_tmp12_, _tmp7_));
	_tmp13_ = _tmp11_;
	uris_length1 = _tmp7_;
	_uris_size_ = uris_length1;
	uris = _tmp13_;
	if (uris != NULL) {
		_tmp14_ = uris[0] != NULL;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp15_ = g_strdup (uris[0]);
		_tmp16_ = _tmp15_;
		_g_free0 (icon->uri);
		icon->uri = _tmp16_;
	}
	_tmp17_ = g_hash_table_lookup (props, "Size");
	_tmp18_ = _g_variant_ref0 ((GVariant*) _tmp17_);
	value = _tmp18_;
	if (value != NULL) {
		icon->size = _variant_get29 (value);
	}
	_tmp19_ = rygel_external_icon_factory_get_int (self, props, "Width");
	icon->width = _tmp19_;
	_tmp20_ = rygel_external_icon_factory_get_int (self, props, "Height");
	icon->height = _tmp20_;
	_tmp21_ = rygel_external_icon_factory_get_int (self, props, "ColorDepth");
	icon->depth = _tmp21_;
	result = icon;
	_g_variant_unref0 (value);
	uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (mime_type);
	return result;
}


static gchar* rygel_external_icon_factory_get_ext_for_mime (RygelExternalIconFactory* self, const gchar* mime_type) {
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (mime_type != NULL, NULL);
	if (g_strcmp0 (mime_type, "image/jpeg") == 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("jpg");
		result = _tmp0_;
		return result;
	} else {
		if (g_strcmp0 (mime_type, "image/gif") == 0) {
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("gif");
			result = _tmp1_;
			return result;
		} else {
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("png");
			result = _tmp2_;
			return result;
		}
	}
}


static gint _variant_get30 (GVariant* value) {
	return g_variant_get_int32 (value);
}


static gint rygel_external_icon_factory_get_int (RygelExternalIconFactory* self, GHashTable* props, const gchar* prop) {
	gint result = 0;
	gconstpointer _tmp0_ = NULL;
	GVariant* _tmp1_;
	GVariant* value;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (props != NULL, 0);
	g_return_val_if_fail (prop != NULL, 0);
	_tmp0_ = g_hash_table_lookup (props, prop);
	_tmp1_ = _g_variant_ref0 ((GVariant*) _tmp0_);
	value = _tmp1_;
	if (value != NULL) {
		result = _variant_get30 (value);
		_g_variant_unref0 (value);
		return result;
	} else {
		result = -1;
		_g_variant_unref0 (value);
		return result;
	}
	_g_variant_unref0 (value);
}


RygelExternalIconFactory* rygel_external_icon_factory_construct (GType object_type) {
	RygelExternalIconFactory* self = NULL;
	self = (RygelExternalIconFactory*) g_type_create_instance (object_type);
	return self;
}


RygelExternalIconFactory* rygel_external_icon_factory_new (void) {
	return rygel_external_icon_factory_construct (RYGEL_EXTERNAL_TYPE_ICON_FACTORY);
}


static void rygel_external_value_icon_factory_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_external_value_icon_factory_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_external_icon_factory_unref (value->data[0].v_pointer);
	}
}


static void rygel_external_value_icon_factory_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_external_icon_factory_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_external_value_icon_factory_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_external_value_icon_factory_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelExternalIconFactory* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_external_icon_factory_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_external_value_icon_factory_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelExternalIconFactory** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_external_icon_factory_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_external_param_spec_icon_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelExternalParamSpecIconFactory* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_EXTERNAL_TYPE_ICON_FACTORY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_external_value_get_icon_factory (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_EXTERNAL_TYPE_ICON_FACTORY), NULL);
	return value->data[0].v_pointer;
}


void rygel_external_value_set_icon_factory (GValue* value, gpointer v_object) {
	RygelExternalIconFactory* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_EXTERNAL_TYPE_ICON_FACTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_EXTERNAL_TYPE_ICON_FACTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_external_icon_factory_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_external_icon_factory_unref (old);
	}
}


void rygel_external_value_take_icon_factory (GValue* value, gpointer v_object) {
	RygelExternalIconFactory* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_EXTERNAL_TYPE_ICON_FACTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_EXTERNAL_TYPE_ICON_FACTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_external_icon_factory_unref (old);
	}
}


static void rygel_external_icon_factory_class_init (RygelExternalIconFactoryClass * klass) {
	gchar* _tmp0_;
	rygel_external_icon_factory_parent_class = g_type_class_peek_parent (klass);
	RYGEL_EXTERNAL_ICON_FACTORY_CLASS (klass)->finalize = rygel_external_icon_factory_finalize;
	_tmp0_ = g_strdup ("org.gnome.UPnP.MediaItem1");
	rygel_external_icon_factory_ITEM_IFACE = _tmp0_;
}


static void rygel_external_icon_factory_instance_init (RygelExternalIconFactory * self) {
	self->ref_count = 1;
}


static void rygel_external_icon_factory_finalize (RygelExternalIconFactory* obj) {
	RygelExternalIconFactory * self;
	self = RYGEL_EXTERNAL_ICON_FACTORY (obj);
}


GType rygel_external_icon_factory_get_type (void) {
	static volatile gsize rygel_external_icon_factory_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_external_icon_factory_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_external_value_icon_factory_init, rygel_external_value_icon_factory_free_value, rygel_external_value_icon_factory_copy_value, rygel_external_value_icon_factory_peek_pointer, "p", rygel_external_value_icon_factory_collect_value, "p", rygel_external_value_icon_factory_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelExternalIconFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_external_icon_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelExternalIconFactory), 0, (GInstanceInitFunc) rygel_external_icon_factory_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_external_icon_factory_type_id;
		rygel_external_icon_factory_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelExternalIconFactory", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_external_icon_factory_type_id__volatile, rygel_external_icon_factory_type_id);
	}
	return rygel_external_icon_factory_type_id__volatile;
}


gpointer rygel_external_icon_factory_ref (gpointer instance) {
	RygelExternalIconFactory* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_external_icon_factory_unref (gpointer instance) {
	RygelExternalIconFactory* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_EXTERNAL_ICON_FACTORY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



