/* rygel-root-device-factory.c generated by valac 0.11.2, the Vala compiler
 * generated from rygel-root-device-factory.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Nokia Corporation.
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2007 OpenedHand Ltd.
 *
 * Authors: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                                <zeeshan.ali@nokia.com>
 *          Jorn Baayen <jorn@openedhand.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <config.h>
#include <libxml/tree.h>
#include <glib/gi18n-lib.h>
#include <libgssdp/gssdp.h>
#include <stdio.h>
#include <gio/gio.h>
#include <libxml/parser.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TYPE_ROOT_DEVICE_FACTORY (rygel_root_device_factory_get_type ())
#define RYGEL_ROOT_DEVICE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactory))
#define RYGEL_ROOT_DEVICE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactoryClass))
#define RYGEL_IS_ROOT_DEVICE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY))
#define RYGEL_IS_ROOT_DEVICE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE_FACTORY))
#define RYGEL_ROOT_DEVICE_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactoryClass))

typedef struct _RygelRootDeviceFactory RygelRootDeviceFactory;
typedef struct _RygelRootDeviceFactoryClass RygelRootDeviceFactoryClass;
typedef struct _RygelRootDeviceFactoryPrivate RygelRootDeviceFactoryPrivate;

#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;

#define RYGEL_TYPE_LOG_LEVEL (rygel_log_level_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_META_CONFIG (rygel_meta_config_get_type ())
#define RYGEL_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfig))
#define RYGEL_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))
#define RYGEL_IS_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_META_CONFIG))
#define RYGEL_IS_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_META_CONFIG))
#define RYGEL_META_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))

typedef struct _RygelMetaConfig RygelMetaConfig;
typedef struct _RygelMetaConfigClass RygelMetaConfigClass;
#define _rygel_root_device_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_root_device_factory_unref (var), NULL)))

#define RYGEL_TYPE_PLUGIN (rygel_plugin_get_type ())
#define RYGEL_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN, RygelPlugin))
#define RYGEL_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN, RygelPluginClass))
#define RYGEL_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN))
#define RYGEL_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN))
#define RYGEL_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN, RygelPluginClass))

typedef struct _RygelPlugin RygelPlugin;
typedef struct _RygelPluginClass RygelPluginClass;

#define RYGEL_TYPE_ROOT_DEVICE (rygel_root_device_get_type ())
#define RYGEL_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDevice))
#define RYGEL_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))
#define RYGEL_IS_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_IS_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_ROOT_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))

typedef struct _RygelRootDevice RygelRootDevice;
typedef struct _RygelRootDeviceClass RygelRootDeviceClass;
typedef struct _RygelPluginPrivate RygelPluginPrivate;

#define RYGEL_TYPE_RESOURCE_INFO (rygel_resource_info_get_type ())
#define RYGEL_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfo))
#define RYGEL_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))
#define RYGEL_IS_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_IS_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_RESOURCE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))

typedef struct _RygelResourceInfo RygelResourceInfo;
typedef struct _RygelResourceInfoClass RygelResourceInfoClass;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;

#define RYGEL_TYPE_XBOX_HACKS (rygel_xbox_hacks_get_type ())
#define RYGEL_XBOX_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacks))
#define RYGEL_XBOX_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksClass))
#define RYGEL_IS_XBOX_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_XBOX_HACKS))
#define RYGEL_IS_XBOX_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_XBOX_HACKS))
#define RYGEL_XBOX_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksClass))

typedef struct _RygelXBoxHacks RygelXBoxHacks;
typedef struct _RygelXBoxHacksClass RygelXBoxHacksClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _RygelResourceInfoPrivate RygelResourceInfoPrivate;
#define _rygel_resource_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_resource_info_unref (var), NULL)))
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))
typedef struct _RygelIconInfoPrivate RygelIconInfoPrivate;
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
typedef struct _RygelParamSpecRootDeviceFactory RygelParamSpecRootDeviceFactory;

typedef enum  {
	ROOT_DEVICE_FACTORY_ERROR_XML_PARSE
} RootDeviceFactoryError;
#define ROOT_DEVICE_FACTORY_ERROR root_device_factory_error_quark ()
struct _RygelRootDeviceFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelRootDeviceFactoryPrivate * priv;
	GUPnPContext* context;
};

struct _RygelRootDeviceFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelRootDeviceFactory *self);
};

typedef enum  {
	RYGEL_LOG_LEVEL_INVALID = 0,
	RYGEL_LOG_LEVEL_CRITICAL = 1,
	RYGEL_LOG_LEVEL_ERROR = 2,
	RYGEL_LOG_LEVEL_WARNING = 3,
	RYGEL_LOG_LEVEL_INFO = 4,
	RYGEL_LOG_LEVEL_DEFAULT = 4,
	RYGEL_LOG_LEVEL_DEBUG = 5
} RygelLogLevel;

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gboolean (*get_upnp_enabled) (RygelConfiguration* self, GError** error);
	gchar* (*get_interface) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp3_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp2ts_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_lpcm_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_wmv_transcoder) (RygelConfiguration* self, GError** error);
	RygelLogLevel (*get_log_level) (RygelConfiguration* self, GError** error);
	gchar* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_title) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_string) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
};

struct _RygelRootDeviceFactoryPrivate {
	RygelConfiguration* config;
	gchar* desc_dir;
};

struct _RygelPlugin {
	GUPnPResourceFactory parent_instance;
	RygelPluginPrivate * priv;
	gchar* name;
	gchar* title;
	gchar* description;
	gchar* desc_path;
	GeeArrayList* resource_infos;
	GeeArrayList* icon_infos;
	GeeArrayList* default_icons;
};

struct _RygelPluginClass {
	GUPnPResourceFactoryClass parent_class;
};

struct _RygelResourceInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelResourceInfoPrivate * priv;
	gchar* upnp_type;
	gchar* upnp_id;
	gchar* description_path;
	GType type;
};

struct _RygelResourceInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelResourceInfo *self);
};

struct _RygelIconInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelIconInfoPrivate * priv;
	gchar* mime_type;
	gchar* uri;
	gchar* file_extension;
	gint64 size;
	gint width;
	gint height;
	gint depth;
};

struct _RygelIconInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelIconInfo *self);
};

struct _RygelParamSpecRootDeviceFactory {
	GParamSpec parent_instance;
};


static gpointer rygel_root_device_factory_parent_class = NULL;

void uuid_generate (guchar* uuid);
void uuid_unparse (guchar* uuid, guchar* output);
GQuark root_device_factory_error_quark (void);
gpointer rygel_root_device_factory_ref (gpointer instance);
void rygel_root_device_factory_unref (gpointer instance);
GParamSpec* rygel_param_spec_root_device_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_root_device_factory (GValue* value, gpointer v_object);
void rygel_value_take_root_device_factory (GValue* value, gpointer v_object);
gpointer rygel_value_get_root_device_factory (const GValue* value);
GType rygel_root_device_factory_get_type (void) G_GNUC_CONST;
GType rygel_log_level_get_type (void) G_GNUC_CONST;
GType rygel_configuration_get_type (void) G_GNUC_CONST;
#define RYGEL_ROOT_DEVICE_FACTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactoryPrivate))
enum  {
	RYGEL_ROOT_DEVICE_FACTORY_DUMMY_PROPERTY
};
RygelRootDeviceFactory* rygel_root_device_factory_new (GUPnPContext* context, GError** error);
RygelRootDeviceFactory* rygel_root_device_factory_construct (GType object_type, GUPnPContext* context, GError** error);
GType rygel_meta_config_get_type (void) G_GNUC_CONST;
RygelMetaConfig* rygel_meta_config_get_default (void);
static void rygel_root_device_factory_ensure_dir_exists (RygelRootDeviceFactory* self, const gchar* dir_path, GError** error);
GType rygel_plugin_get_type (void) G_GNUC_CONST;
GType rygel_root_device_get_type (void) G_GNUC_CONST;
RygelRootDevice* rygel_root_device_factory_create (RygelRootDeviceFactory* self, RygelPlugin* plugin, GError** error);
gpointer rygel_resource_info_ref (gpointer instance);
void rygel_resource_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_resource_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_resource_info (GValue* value, gpointer v_object);
void rygel_value_take_resource_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_resource_info (const GValue* value);
GType rygel_resource_info_get_type (void) G_GNUC_CONST;
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
static GUPnPXMLDoc* rygel_root_device_factory_create_desc (RygelRootDeviceFactory* self, RygelPlugin* plugin, const gchar* desc_path, const gchar* template_path, GError** error);
RygelRootDevice* rygel_root_device_new (GUPnPContext* context, RygelPlugin* plugin, GUPnPXMLDoc* description_doc, const gchar* description_path, const gchar* description_dir);
RygelRootDevice* rygel_root_device_construct (GType object_type, GUPnPContext* context, RygelPlugin* plugin, GUPnPXMLDoc* description_doc, const gchar* description_path, const gchar* description_dir);
RygelXBoxHacks* rygel_xbox_hacks_new (void);
RygelXBoxHacks* rygel_xbox_hacks_construct (GType object_type);
GType rygel_xbox_hacks_get_type (void) G_GNUC_CONST;
void rygel_xbox_hacks_apply_on_device (RygelXBoxHacks* self, RygelRootDevice* device, const gchar* template_path, GError** error);
static gboolean rygel_root_device_factory_check_path_exist (RygelRootDeviceFactory* self, const gchar* path);
static void rygel_root_device_factory_prepare_desc_for_plugin (RygelRootDeviceFactory* self, GUPnPXMLDoc* doc, RygelPlugin* plugin);
static void rygel_root_device_factory_save_modified_desc (RygelRootDeviceFactory* self, GUPnPXMLDoc* doc, const gchar* desc_path, GError** error);
xmlNode* rygel_xml_utils_get_element (xmlNode* node, ...);
static void rygel_root_device_factory_set_friendly_name_and_udn (RygelRootDeviceFactory* self, xmlNode* device_element, const gchar* plugin_name, const gchar* plugin_title);
static void rygel_root_device_factory_set_description (RygelRootDeviceFactory* self, xmlNode* device_element, const gchar* description);
static void rygel_root_device_factory_add_icons_to_desc (RygelRootDeviceFactory* self, xmlNode* device_element, RygelPlugin* plugin);
static void rygel_root_device_factory_add_services_to_desc (RygelRootDeviceFactory* self, xmlNode* device_element, RygelPlugin* plugin);
gchar* rygel_configuration_get_title (RygelConfiguration* self, const gchar* section, GError** error);
static gchar* rygel_root_device_factory_generate_random_udn (RygelRootDeviceFactory* self);
static void rygel_root_device_factory_add_service_to_desc (RygelRootDeviceFactory* self, xmlNode* service_list_node, const gchar* plugin_name, RygelResourceInfo* resource_info);
static void rygel_root_device_factory_add_icon_to_desc (RygelRootDeviceFactory* self, xmlNode* icon_list_node, RygelIconInfo* icon_info, RygelPlugin* plugin);
static void rygel_root_device_factory_finalize (RygelRootDeviceFactory* obj);


GQuark root_device_factory_error_quark (void) {
	return g_quark_from_static_string ("root_device_factory_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelRootDeviceFactory* rygel_root_device_factory_construct (GType object_type, GUPnPContext* context, GError** error) {
	RygelRootDeviceFactory* self = NULL;
	RygelMetaConfig* _tmp0_ = NULL;
	RygelConfiguration* _tmp1_;
	GUPnPContext* _tmp2_;
	GUPnPContext* _tmp3_;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* config_dir;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (context != NULL, NULL);
	self = (RygelRootDeviceFactory*) g_type_create_instance (object_type);
	_tmp0_ = rygel_meta_config_get_default ();
	_tmp1_ = (RygelConfiguration*) _tmp0_;
	_g_object_unref0 (self->priv->config);
	self->priv->config = _tmp1_;
	_tmp2_ = _g_object_ref0 (context);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->context);
	self->context = _tmp3_;
	_tmp4_ = g_get_user_config_dir ();
	_tmp5_ = g_strdup (_tmp4_);
	config_dir = _tmp5_;
	rygel_root_device_factory_ensure_dir_exists (self, config_dir, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (config_dir);
		_rygel_root_device_factory_unref0 (self);
		return NULL;
	}
	_tmp6_ = g_build_filename (config_dir, "Rygel", NULL);
	_tmp7_ = _tmp6_;
	_g_free0 (self->priv->desc_dir);
	self->priv->desc_dir = _tmp7_;
	rygel_root_device_factory_ensure_dir_exists (self, self->priv->desc_dir, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (config_dir);
		_rygel_root_device_factory_unref0 (self);
		return NULL;
	}
	_g_free0 (config_dir);
	return self;
}


RygelRootDeviceFactory* rygel_root_device_factory_new (GUPnPContext* context, GError** error) {
	return rygel_root_device_factory_construct (RYGEL_TYPE_ROOT_DEVICE_FACTORY, context, error);
}


RygelRootDevice* rygel_root_device_factory_create (RygelRootDeviceFactory* self, RygelPlugin* plugin, GError** error) {
	RygelRootDevice* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* desc_path;
	gchar* _tmp3_;
	gchar* template_path;
	GUPnPXMLDoc* _tmp4_ = NULL;
	GUPnPXMLDoc* doc;
	RygelRootDevice* _tmp5_ = NULL;
	RygelRootDevice* device;
	RygelXBoxHacks* _tmp6_ = NULL;
	RygelXBoxHacks* xbox_hacks;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (plugin != NULL, NULL);
	_tmp0_ = g_strconcat (plugin->name, ".xml", NULL);
	_tmp1_ = g_build_filename (self->priv->desc_dir, _tmp0_, NULL);
	desc_path = (_tmp2_ = _tmp1_, _g_free0 (_tmp0_), _tmp2_);
	_tmp3_ = g_strdup (plugin->desc_path);
	template_path = _tmp3_;
	_tmp4_ = rygel_root_device_factory_create_desc (self, plugin, desc_path, template_path, &_inner_error_);
	doc = _tmp4_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (template_path);
		_g_free0 (desc_path);
		return NULL;
	}
	_tmp5_ = rygel_root_device_new (self->context, plugin, doc, desc_path, DATA_DIR);
	device = _tmp5_;
	_tmp6_ = rygel_xbox_hacks_new ();
	xbox_hacks = _tmp6_;
	rygel_xbox_hacks_apply_on_device (xbox_hacks, device, desc_path, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (xbox_hacks);
		_g_object_unref0 (device);
		_g_object_unref0 (doc);
		_g_free0 (template_path);
		_g_free0 (desc_path);
		return NULL;
	}
	result = device;
	_g_object_unref0 (xbox_hacks);
	_g_object_unref0 (doc);
	_g_free0 (template_path);
	_g_free0 (desc_path);
	return result;
}


static GUPnPXMLDoc* rygel_root_device_factory_create_desc (RygelRootDeviceFactory* self, RygelPlugin* plugin, const gchar* desc_path, const gchar* template_path, GError** error) {
	GUPnPXMLDoc* result = NULL;
	GUPnPXMLDoc* doc;
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (plugin != NULL, NULL);
	g_return_val_if_fail (desc_path != NULL, NULL);
	g_return_val_if_fail (template_path != NULL, NULL);
	doc = NULL;
	_tmp0_ = rygel_root_device_factory_check_path_exist (self, desc_path);
	if (_tmp0_) {
		GUPnPXMLDoc* _tmp1_ = NULL;
		GUPnPXMLDoc* _tmp2_;
		GUPnPXMLDoc* _tmp3_;
		_tmp1_ = gupnp_xml_doc_new_from_path (desc_path, &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (doc);
			return NULL;
		}
		_tmp3_ = _tmp2_;
		_g_object_unref0 (doc);
		doc = _tmp3_;
	} else {
		GUPnPXMLDoc* _tmp4_ = NULL;
		GUPnPXMLDoc* _tmp5_;
		GUPnPXMLDoc* _tmp6_;
		_tmp4_ = gupnp_xml_doc_new_from_path (template_path, &_inner_error_);
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (doc);
			return NULL;
		}
		_tmp6_ = _tmp5_;
		_g_object_unref0 (doc);
		doc = _tmp6_;
	}
	rygel_root_device_factory_prepare_desc_for_plugin (self, doc, plugin);
	rygel_root_device_factory_save_modified_desc (self, doc, desc_path, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (doc);
		return NULL;
	}
	result = doc;
	return result;
}


static void rygel_root_device_factory_prepare_desc_for_plugin (RygelRootDeviceFactory* self, GUPnPXMLDoc* doc, RygelPlugin* plugin) {
	xmlNode* device_element = NULL;
	xmlNode* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (doc != NULL);
	g_return_if_fail (plugin != NULL);
	_tmp0_ = rygel_xml_utils_get_element ((xmlNode*) doc->doc, "root", "device", NULL, NULL);
	device_element = _tmp0_;
	if (device_element == NULL) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = _ ("XML node '%s' not found.");
		g_warning (_tmp1_, "/root/device");
		return;
	}
	rygel_root_device_factory_set_friendly_name_and_udn (self, device_element, plugin->name, plugin->title);
	if (plugin->description != NULL) {
		rygel_root_device_factory_set_description (self, device_element, plugin->description);
	}
	rygel_root_device_factory_add_icons_to_desc (self, device_element, plugin);
	rygel_root_device_factory_add_services_to_desc (self, device_element, plugin);
}


/**
     * Fills the description doc @doc with a friendly name, and UDN from gconf.
     * If these keys are not present in gconf, they are set with default values.
     */
static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GRegex* _tmp2_ = NULL;
	GRegex* _tmp3_;
	GRegex* regex;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	_tmp0_ = g_regex_escape_string (old, -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_regex_new (_tmp1_, 0, 0, &_inner_error_);
	regex = (_tmp3_ = _tmp2_, _g_free0 (_tmp1_), _tmp3_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch61_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch61_g_regex_error;
		}
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp5_;
	_g_regex_unref0 (regex);
	return result;
	_g_regex_unref0 (regex);
	goto __finally61;
	__catch61_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally61:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void rygel_root_device_factory_set_friendly_name_and_udn (RygelRootDeviceFactory* self, xmlNode* device_element, const gchar* plugin_name, const gchar* plugin_title) {
	xmlNode* _tmp0_ = NULL;
	xmlNode* element;
	gchar* title;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	xmlNode* _tmp16_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* udn;
	gboolean _tmp19_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (plugin_name != NULL);
	g_return_if_fail (plugin_title != NULL);
	_tmp0_ = rygel_xml_utils_get_element (device_element, "friendlyName", NULL, NULL);
	element = _tmp0_;
	if (element == NULL) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = _ ("XML node '%s' not found.");
		g_warning (_tmp1_, "/root/device/friendlyName");
		return;
	}
	title = NULL;
	_tmp2_ = rygel_configuration_get_title (self->priv->config, plugin_name, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		goto __catch60_g_error;
	}
	_tmp4_ = _tmp3_;
	_g_free0 (title);
	title = _tmp4_;
	goto __finally60;
	__catch60_g_error:
	{
		GError * err;
		gchar* _tmp5_;
		gchar* _tmp6_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = g_strdup (plugin_title);
		_tmp6_ = _tmp5_;
		_g_free0 (title);
		title = _tmp6_;
		_g_error_free0 (err);
	}
	__finally60:
	if (_inner_error_ != NULL) {
		_g_free0 (title);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp7_ = g_get_real_name ();
	_tmp8_ = string_replace (title, "@REALNAME@", _tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (title);
	title = _tmp9_;
	_tmp10_ = g_get_user_name ();
	_tmp11_ = string_replace (title, "@USERNAME@", _tmp10_);
	_tmp12_ = _tmp11_;
	_g_free0 (title);
	title = _tmp12_;
	_tmp13_ = g_get_host_name ();
	_tmp14_ = string_replace (title, "@HOSTNAME@", _tmp13_);
	_tmp15_ = _tmp14_;
	_g_free0 (title);
	title = _tmp15_;
	xmlNodeSetContent (element, title);
	_tmp16_ = rygel_xml_utils_get_element (device_element, "UDN", NULL);
	element = _tmp16_;
	if (element == NULL) {
		const gchar* _tmp17_ = NULL;
		_tmp17_ = _ ("XML node '%s' not found.");
		g_warning (_tmp17_, "/root/device/UDN");
		_g_free0 (title);
		return;
	}
	_tmp18_ = xmlNodeGetContent (element);
	udn = _tmp18_;
	if (udn == NULL) {
		_tmp19_ = TRUE;
	} else {
		_tmp19_ = g_strcmp0 (udn, "") == 0;
	}
	if (_tmp19_) {
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_;
		_tmp20_ = rygel_root_device_factory_generate_random_udn (self);
		_tmp21_ = _tmp20_;
		_g_free0 (udn);
		udn = _tmp21_;
		xmlNodeSetContent (element, udn);
	}
	_g_free0 (udn);
	_g_free0 (title);
}


static void rygel_root_device_factory_set_description (RygelRootDeviceFactory* self, xmlNode* device_element, const gchar* description) {
	xmlNode* _tmp0_ = NULL;
	xmlNode* element;
	g_return_if_fail (self != NULL);
	g_return_if_fail (description != NULL);
	_tmp0_ = rygel_xml_utils_get_element (device_element, "modelDescription", NULL, NULL);
	element = _tmp0_;
	if (element == NULL) {
		xmlNewChild (device_element, NULL, "modelDescription", description);
	}
	xmlNodeSetContent (element, description);
}


static void rygel_root_device_factory_add_services_to_desc (RygelRootDeviceFactory* self, xmlNode* device_element, RygelPlugin* plugin) {
	xmlNode* _tmp0_ = NULL;
	xmlNode* service_list_node;
	g_return_if_fail (self != NULL);
	g_return_if_fail (plugin != NULL);
	_tmp0_ = rygel_xml_utils_get_element (device_element, "serviceList", NULL, NULL);
	service_list_node = _tmp0_;
	if (service_list_node == NULL) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = _ ("XML node '%s' not found.");
		g_warning (_tmp1_, "/root/device/serviceList");
		return;
	}
	xmlNodeSetContent (service_list_node, "");
	{
		GeeArrayList* _tmp2_;
		GeeArrayList* _resource_info_list;
		gint _tmp3_;
		gint _resource_info_size;
		gint _resource_info_index;
		_tmp2_ = _g_object_ref0 (plugin->resource_infos);
		_resource_info_list = _tmp2_;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _resource_info_list);
		_resource_info_size = _tmp3_;
		_resource_info_index = -1;
		while (TRUE) {
			gpointer _tmp4_ = NULL;
			RygelResourceInfo* resource_info;
			gboolean _tmp5_;
			_resource_info_index = _resource_info_index + 1;
			if (!(_resource_info_index < _resource_info_size)) {
				break;
			}
			_tmp4_ = gee_abstract_list_get ((GeeAbstractList*) _resource_info_list, _resource_info_index);
			resource_info = (RygelResourceInfo*) _tmp4_;
			_tmp5_ = g_type_is_a (resource_info->type, GUPNP_TYPE_SERVICE);
			if (_tmp5_) {
				rygel_root_device_factory_add_service_to_desc (self, service_list_node, plugin->name, resource_info);
			}
			_rygel_resource_info_unref0 (resource_info);
		}
		_g_object_unref0 (_resource_info_list);
	}
}


static void rygel_root_device_factory_add_service_to_desc (RygelRootDeviceFactory* self, xmlNode* service_list_node, const gchar* plugin_name, RygelResourceInfo* resource_info) {
	xmlNode* _tmp0_ = NULL;
	xmlNode* service_node;
	gchar* url;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (plugin_name != NULL);
	g_return_if_fail (resource_info != NULL);
	_tmp0_ = xmlNewChild (service_list_node, NULL, "service", NULL);
	service_node = _tmp0_;
	xmlNewChild (service_node, NULL, "serviceType", resource_info->upnp_type);
	xmlNewChild (service_node, NULL, "serviceId", resource_info->upnp_id);
	url = g_strconcat ("/", resource_info->description_path, NULL);
	xmlNewChild (service_node, NULL, "SCPDURL", url);
	_tmp1_ = g_strconcat ("/", plugin_name, NULL);
	_tmp2_ = g_strconcat (_tmp1_, "/", NULL);
	_tmp3_ = g_type_name (resource_info->type);
	_tmp4_ = g_strconcat (_tmp2_, _tmp3_, NULL);
	_tmp5_ = g_strconcat (_tmp4_, "/Event", NULL);
	_g_free0 (url);
	url = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_g_free0 (_tmp1_);
	xmlNewChild (service_node, NULL, "eventSubURL", url);
	_tmp6_ = g_strconcat ("/", plugin_name, NULL);
	_tmp7_ = g_strconcat (_tmp6_, "/", NULL);
	_tmp8_ = g_type_name (resource_info->type);
	_tmp9_ = g_strconcat (_tmp7_, _tmp8_, NULL);
	_tmp10_ = g_strconcat (_tmp9_, "/Control", NULL);
	_g_free0 (url);
	url = _tmp10_;
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp6_);
	xmlNewChild (service_node, NULL, "controlURL", url);
	_g_free0 (url);
}


static void rygel_root_device_factory_add_icons_to_desc (RygelRootDeviceFactory* self, xmlNode* device_element, RygelPlugin* plugin) {
	GeeArrayList* _tmp0_;
	GeeArrayList* icons;
	gboolean _tmp1_ = FALSE;
	xmlNode* _tmp5_ = NULL;
	xmlNode* icon_list_node;
	g_return_if_fail (self != NULL);
	g_return_if_fail (plugin != NULL);
	_tmp0_ = _g_object_ref0 (plugin->icon_infos);
	icons = _tmp0_;
	if (icons == NULL) {
		_tmp1_ = TRUE;
	} else {
		gint _tmp2_;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) icons);
		_tmp1_ = _tmp2_ == 0;
	}
	if (_tmp1_) {
		GeeArrayList* _tmp3_;
		GeeArrayList* _tmp4_;
		g_debug ("rygel-root-device-factory.vala:242: No icon provided by plugin '%s'. U" \
"sing Rygel logo.", plugin->name);
		_tmp3_ = _g_object_ref0 (plugin->default_icons);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (icons);
		icons = _tmp4_;
	}
	_tmp5_ = rygel_xml_utils_get_element (device_element, "iconList", NULL, NULL);
	icon_list_node = _tmp5_;
	if (icon_list_node == NULL) {
		xmlNode* _tmp6_ = NULL;
		_tmp6_ = xmlNewChild (device_element, NULL, "iconList", NULL);
		icon_list_node = _tmp6_;
	} else {
		xmlNodeSetContent (icon_list_node, "");
	}
	{
		GeeArrayList* _tmp7_;
		GeeArrayList* _icon_list;
		gint _tmp8_;
		gint _icon_size;
		gint _icon_index;
		_tmp7_ = _g_object_ref0 (icons);
		_icon_list = _tmp7_;
		_tmp8_ = gee_collection_get_size ((GeeCollection*) _icon_list);
		_icon_size = _tmp8_;
		_icon_index = -1;
		while (TRUE) {
			gpointer _tmp9_ = NULL;
			RygelIconInfo* icon;
			_icon_index = _icon_index + 1;
			if (!(_icon_index < _icon_size)) {
				break;
			}
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _icon_list, _icon_index);
			icon = (RygelIconInfo*) _tmp9_;
			rygel_root_device_factory_add_icon_to_desc (self, icon_list_node, icon, plugin);
			_rygel_icon_info_unref0 (icon);
		}
		_g_object_unref0 (_icon_list);
	}
	_g_object_unref0 (icons);
}


static const gchar* string_offset (const gchar* self, glong offset) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = (const gchar*) (((gchar*) self) + offset);
	return result;
}


static void rygel_root_device_factory_add_icon_to_desc (RygelRootDeviceFactory* self, xmlNode* icon_list_node, RygelIconInfo* icon_info, RygelPlugin* plugin) {
	xmlNode* _tmp0_ = NULL;
	xmlNode* icon_node;
	gchar* _tmp1_ = NULL;
	gchar* width;
	gchar* _tmp2_ = NULL;
	gchar* height;
	gchar* _tmp3_ = NULL;
	gchar* depth;
	gchar* _tmp4_;
	gchar* uri;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon_info != NULL);
	g_return_if_fail (plugin != NULL);
	_tmp0_ = xmlNewChild (icon_list_node, NULL, "icon", NULL);
	icon_node = _tmp0_;
	_tmp1_ = g_strdup_printf ("%i", icon_info->width);
	width = _tmp1_;
	_tmp2_ = g_strdup_printf ("%i", icon_info->height);
	height = _tmp2_;
	_tmp3_ = g_strdup_printf ("%i", icon_info->depth);
	depth = _tmp3_;
	xmlNewChild (icon_node, NULL, "mimetype", icon_info->mime_type);
	xmlNewChild (icon_node, NULL, "width", width);
	xmlNewChild (icon_node, NULL, "height", height);
	xmlNewChild (icon_node, NULL, "depth", depth);
	_tmp4_ = g_strdup (icon_info->uri);
	uri = _tmp4_;
	_tmp5_ = g_str_has_prefix (uri, "file://");
	if (_tmp5_) {
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* remote_path;
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		gchar* local_path;
		_tmp6_ = g_strconcat ("/", plugin->name, NULL);
		_tmp7_ = g_strconcat (_tmp6_, "-", NULL);
		_tmp8_ = g_strconcat (_tmp7_, width, NULL);
		_tmp9_ = g_strconcat (_tmp8_, "x", NULL);
		_tmp10_ = g_strconcat (_tmp9_, height, NULL);
		_tmp11_ = g_strconcat (_tmp10_, "x", NULL);
		_tmp12_ = g_strconcat (_tmp11_, depth, NULL);
		_tmp13_ = g_strconcat (_tmp12_, ".", NULL);
		remote_path = (_tmp14_ = g_strconcat (_tmp13_, icon_info->file_extension, NULL), _g_free0 (_tmp13_), _g_free0 (_tmp12_), _g_free0 (_tmp11_), _g_free0 (_tmp10_), _g_free0 (_tmp9_), _g_free0 (_tmp8_), _g_free0 (_tmp7_), _g_free0 (_tmp6_), _tmp14_);
		_tmp15_ = string_offset (uri, (glong) 7);
		_tmp16_ = g_strdup (_tmp15_);
		local_path = _tmp16_;
		gupnp_context_host_path (self->context, local_path, remote_path);
		xmlNewChild (icon_node, NULL, "url", remote_path);
		_g_free0 (local_path);
		_g_free0 (remote_path);
	} else {
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		_tmp17_ = gssdp_client_get_host_ip ((GSSDPClient*) self->context);
		_tmp18_ = string_replace (uri, "@ADDRESS@", _tmp17_);
		_tmp19_ = _tmp18_;
		_g_free0 (uri);
		uri = _tmp19_;
		xmlNewChild (icon_node, NULL, "url", uri);
	}
	_g_free0 (uri);
	_g_free0 (depth);
	_g_free0 (height);
	_g_free0 (width);
}


static void rygel_root_device_factory_save_modified_desc (RygelRootDeviceFactory* self, GUPnPXMLDoc* doc, const gchar* desc_path, GError** error) {
	FILE* _tmp0_ = NULL;
	FILE* file;
	gboolean _tmp1_;
	gchar* mem;
	gint len;
	gchar* _tmp5_ = NULL;
	gint _tmp6_;
	gboolean _tmp7_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (doc != NULL);
	g_return_if_fail (desc_path != NULL);
	_tmp0_ = fopen (desc_path, "w+");
	file = _tmp0_;
	_tmp1_ = G_UNLIKELY (file == NULL);
	if (_tmp1_) {
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* message;
		GError* _tmp4_ = NULL;
		_tmp2_ = _ ("Failed to write modified description to %s");
		_tmp3_ = g_strdup (_tmp2_);
		message = _tmp3_;
		_tmp4_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, message, desc_path);
		_inner_error_ = _tmp4_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (message);
		_fclose0 (file);
		return;
	}
	mem = NULL;
	len = -1;
	xmlDocDumpFormatMemory (doc->doc, &_tmp5_, &_tmp6_, FALSE);
	_g_free0 (mem);
	mem = _tmp5_;
	len = _tmp6_;
	_tmp7_ = G_UNLIKELY (len <= 0);
	if (_tmp7_) {
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		gchar* message;
		GError* _tmp10_ = NULL;
		_tmp8_ = _ ("Failed to write modified description to %s");
		_tmp9_ = g_strdup (_tmp8_);
		message = _tmp9_;
		_tmp10_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, message, desc_path);
		_inner_error_ = _tmp10_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (message);
		_g_free0 (mem);
		_fclose0 (file);
		return;
	}
	_tmp11_ = string_replace (mem, "\n", "");
	_tmp12_ = _tmp11_;
	fputs (_tmp12_, file);
	_g_free0 (_tmp12_);
	_g_free0 (mem);
	_fclose0 (file);
}


static gboolean rygel_root_device_factory_check_path_exist (RygelRootDeviceFactory* self, const gchar* path) {
	gboolean result = FALSE;
	GFile* _tmp0_ = NULL;
	GFile* file;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = g_file_new_for_path (path);
	file = _tmp0_;
	_tmp1_ = g_file_query_exists (file, NULL);
	result = _tmp1_;
	_g_object_unref0 (file);
	return result;
}


static void rygel_root_device_factory_ensure_dir_exists (RygelRootDeviceFactory* self, const gchar* dir_path, GError** error) {
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dir_path != NULL);
	_tmp0_ = rygel_root_device_factory_check_path_exist (self, dir_path);
	if (!_tmp0_) {
		GFile* _tmp1_ = NULL;
		GFile* file;
		_tmp1_ = g_file_new_for_path (dir_path);
		file = _tmp1_;
		g_file_make_directory (file, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (file);
			return;
		}
		_g_object_unref0 (file);
	}
}


static gchar* rygel_root_device_factory_generate_random_udn (RygelRootDeviceFactory* self) {
	gchar* result = NULL;
	guchar* _tmp0_ = NULL;
	gint udn_length1;
	gint _udn_size_;
	guchar* _tmp1_;
	guchar* udn;
	guchar* _tmp2_ = NULL;
	gint id_length1;
	gint _id_size_;
	guchar* _tmp3_;
	guchar* id;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (guchar, 50);
	_tmp1_ = _tmp0_;
	udn_length1 = 50;
	_udn_size_ = udn_length1;
	udn = _tmp1_;
	_tmp2_ = g_new0 (guchar, 16);
	_tmp3_ = _tmp2_;
	id_length1 = 16;
	_id_size_ = id_length1;
	id = _tmp3_;
	uuid_generate (id);
	uuid_unparse (id, udn);
	result = g_strconcat ("uuid:", (const gchar*) udn, NULL);
	id = (g_free (id), NULL);
	udn = (g_free (udn), NULL);
	return result;
}


static void rygel_value_root_device_factory_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_value_root_device_factory_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_root_device_factory_unref (value->data[0].v_pointer);
	}
}


static void rygel_value_root_device_factory_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_root_device_factory_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_value_root_device_factory_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_value_root_device_factory_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelRootDeviceFactory* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_root_device_factory_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_value_root_device_factory_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelRootDeviceFactory** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_root_device_factory_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_param_spec_root_device_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecRootDeviceFactory* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_ROOT_DEVICE_FACTORY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_value_get_root_device_factory (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_ROOT_DEVICE_FACTORY), NULL);
	return value->data[0].v_pointer;
}


void rygel_value_set_root_device_factory (GValue* value, gpointer v_object) {
	RygelRootDeviceFactory* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_ROOT_DEVICE_FACTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_ROOT_DEVICE_FACTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_root_device_factory_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_root_device_factory_unref (old);
	}
}


void rygel_value_take_root_device_factory (GValue* value, gpointer v_object) {
	RygelRootDeviceFactory* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_ROOT_DEVICE_FACTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_ROOT_DEVICE_FACTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_root_device_factory_unref (old);
	}
}


static void rygel_root_device_factory_class_init (RygelRootDeviceFactoryClass * klass) {
	rygel_root_device_factory_parent_class = g_type_class_peek_parent (klass);
	RYGEL_ROOT_DEVICE_FACTORY_CLASS (klass)->finalize = rygel_root_device_factory_finalize;
	g_type_class_add_private (klass, sizeof (RygelRootDeviceFactoryPrivate));
}


static void rygel_root_device_factory_instance_init (RygelRootDeviceFactory * self) {
	self->priv = RYGEL_ROOT_DEVICE_FACTORY_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void rygel_root_device_factory_finalize (RygelRootDeviceFactory* obj) {
	RygelRootDeviceFactory * self;
	self = RYGEL_ROOT_DEVICE_FACTORY (obj);
	_g_object_unref0 (self->context);
	_g_object_unref0 (self->priv->config);
	_g_free0 (self->priv->desc_dir);
}


/**
 * Factory for RootDevice objects. Give it a plugin and it will create a
 * Root device for that.
 */
GType rygel_root_device_factory_get_type (void) {
	static volatile gsize rygel_root_device_factory_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_root_device_factory_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_root_device_factory_init, rygel_value_root_device_factory_free_value, rygel_value_root_device_factory_copy_value, rygel_value_root_device_factory_peek_pointer, "p", rygel_value_root_device_factory_collect_value, "p", rygel_value_root_device_factory_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelRootDeviceFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_root_device_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelRootDeviceFactory), 0, (GInstanceInitFunc) rygel_root_device_factory_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_root_device_factory_type_id;
		rygel_root_device_factory_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelRootDeviceFactory", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_root_device_factory_type_id__volatile, rygel_root_device_factory_type_id);
	}
	return rygel_root_device_factory_type_id__volatile;
}


gpointer rygel_root_device_factory_ref (gpointer instance) {
	RygelRootDeviceFactory* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_root_device_factory_unref (gpointer instance) {
	RygelRootDeviceFactory* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_ROOT_DEVICE_FACTORY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



