/* rygel-http-server.c generated by valac 0.11.2, the Vala compiler
 * generated from rygel-http-server.vala, do not modify */

/*
 * Copyright (C) 2008, 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>
#include <gio/gio.h>
#include <libgupnp/gupnp.h>
#include <libsoup/soup.h>


#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;
typedef struct _RygelTranscodeManagerPrivate RygelTranscodeManagerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;
typedef struct _RygelContentDirectoryPrivate RygelContentDirectoryPrivate;
typedef struct _RygelHttpServerRunData RygelHttpServerRunData;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;

#define RYGEL_TYPE_HTTP_POST (rygel_http_post_get_type ())
#define RYGEL_HTTP_POST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_POST, RygelHTTPPost))
#define RYGEL_HTTP_POST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_POST, RygelHTTPPostClass))
#define RYGEL_IS_HTTP_POST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_POST))
#define RYGEL_IS_HTTP_POST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_POST))
#define RYGEL_HTTP_POST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_POST, RygelHTTPPostClass))

typedef struct _RygelHTTPPost RygelHTTPPost;
typedef struct _RygelHTTPPostClass RygelHTTPPostClass;

struct _RygelTranscodeManager {
	GObject parent_instance;
	RygelTranscodeManagerPrivate * priv;
};

struct _RygelTranscodeManagerClass {
	GObjectClass parent_class;
	gchar* (*create_uri_for_item) (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
	gchar* (*get_protocol) (RygelTranscodeManager* self);
	GeeArrayList* (*get_protocol_info) (RygelTranscodeManager* self);
};

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPServer {
	RygelTranscodeManager parent_instance;
	RygelHTTPServerPrivate * priv;
	RygelMediaContainer* root_container;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	RygelTranscodeManagerClass parent_class;
};

struct _RygelHTTPServerPrivate {
	gchar* _path_root;
	GeeArrayList* requests;
	GCancellable* _cancellable;
};

struct _RygelContentDirectory {
	GUPnPService parent_instance;
	RygelContentDirectoryPrivate * priv;
	gchar* feature_list;
	RygelHTTPServer* http_server;
	RygelMediaContainer* root_container;
	GCancellable* cancellable;
	guint32 system_update_id;
};

struct _RygelContentDirectoryClass {
	GUPnPServiceClass parent_class;
};

struct _RygelHttpServerRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPServer* self;
	SoupServer* _tmp0_;
	SoupServer* _tmp1_;
	SoupServer* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaItem* item;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};


static gpointer rygel_http_server_parent_class = NULL;
static RygelStateMachineIface* rygel_http_server_rygel_state_machine_parent_iface = NULL;

GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_SERVER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerPrivate))
enum  {
	RYGEL_HTTP_SERVER_DUMMY_PROPERTY,
	RYGEL_HTTP_SERVER_PATH_ROOT,
	RYGEL_HTTP_SERVER_CANCELLABLE
};
#define RYGEL_HTTP_SERVER_SERVER_PATH_PREFIX "/RygelHTTPServer"
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
RygelHTTPServer* rygel_http_server_new (RygelContentDirectory* content_dir, const gchar* name);
RygelHTTPServer* rygel_http_server_construct (GType object_type, RygelContentDirectory* content_dir, const gchar* name);
RygelTranscodeManager* rygel_transcode_manager_construct (GType object_type);
void rygel_state_machine_set_cancellable (RygelStateMachine* self, GCancellable* value);
static void rygel_http_server_set_path_root (RygelHTTPServer* self, const gchar* value);
static void rygel_http_server_real_run_data_free (gpointer _data);
static void rygel_http_server_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_server_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_http_server_real_run_co (RygelHttpServerRunData* data);
const gchar* rygel_http_server_get_path_root (RygelHTTPServer* self);
static void rygel_http_server_server_handler (RygelHTTPServer* self, SoupServer* server, SoupMessage* msg, const gchar* server_path, GHashTable* query, SoupClientContext* soup_client);
static void _rygel_http_server_server_handler_soup_server_callback (SoupServer* server, SoupMessage* msg, const gchar* path, GHashTable* query, SoupClientContext* client, gpointer self);
static void rygel_http_server_on_request_aborted (RygelHTTPServer* self, SoupServer* server, SoupMessage* message, SoupClientContext* client);
static void _rygel_http_server_on_request_aborted_soup_server_request_aborted (SoupServer* _sender, SoupMessage* msg, SoupClientContext* client, gpointer self);
static void rygel_http_server_on_request_started (RygelHTTPServer* self, SoupServer* server, SoupMessage* message, SoupClientContext* client);
static void _rygel_http_server_on_request_started_soup_server_request_started (SoupServer* _sender, SoupMessage* msg, SoupClientContext* client, gpointer self);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static void rygel_http_server_on_cancelled (RygelHTTPServer* self, GCancellable* cancellable);
static void _rygel_http_server_on_cancelled_g_cancellable_cancelled (GCancellable* _sender, gpointer self);
void rygel_http_server_add_proxy_resource (RygelHTTPServer* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, GError** error);
static gboolean rygel_http_server_http_uri_present (RygelHTTPServer* self, RygelMediaItem* item);
gchar* rygel_transcode_manager_create_uri_for_item (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
GUPnPDIDLLiteResource* rygel_media_item_add_resource (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
gchar* rygel_transcode_manager_get_protocol (RygelTranscodeManager* self);
gboolean rygel_http_server_need_proxy (RygelHTTPServer* self, const gchar* uri);
static gchar* rygel_http_server_real_create_uri_for_item (RygelTranscodeManager* base, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
RygelHTTPItemURI* rygel_http_item_uri_new (const gchar* item_id, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
RygelHTTPItemURI* rygel_http_item_uri_construct (GType object_type, const gchar* item_id, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
gchar* rygel_http_item_uri_to_string (RygelHTTPItemURI* self);
static gchar* rygel_http_server_real_get_protocol (RygelTranscodeManager* base);
static GeeArrayList* rygel_http_server_real_get_protocol_info (RygelTranscodeManager* base);
GeeArrayList* rygel_transcode_manager_get_protocol_info (RygelTranscodeManager* self);
static void rygel_http_server_on_request_completed (RygelHTTPServer* self, RygelStateMachine* machine);
static void _lambda1_ (const gchar* name, const gchar* value, RygelHTTPServer* self);
static void __lambda1__soup_message_headers_foreach_func (const gchar* name, const gchar* value, gpointer self);
static void rygel_http_server_queue_request (RygelHTTPServer* self, RygelHTTPRequest* request);
RygelHTTPGet* rygel_http_get_new (RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
RygelHTTPGet* rygel_http_get_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
GType rygel_http_get_get_type (void) G_GNUC_CONST;
static void rygel_http_server_on_got_headers (RygelHTTPServer* self, SoupMessage* msg);
static void _rygel_http_server_on_got_headers_soup_message_got_headers (SoupMessage* _sender, gpointer self);
RygelHTTPPost* rygel_http_post_new (RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
RygelHTTPPost* rygel_http_post_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
GType rygel_http_post_get_type (void) G_GNUC_CONST;
static void _rygel_http_server_on_request_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self);
void rygel_state_machine_run (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_state_machine_run_finish (RygelStateMachine* self, GAsyncResult* _res_);
static void rygel_http_server_finalize (GObject* obj);
static void _vala_rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_http_server_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelHTTPServer* rygel_http_server_construct (GType object_type, RygelContentDirectory* content_dir, const gchar* name) {
	RygelHTTPServer * self = NULL;
	RygelMediaContainer* _tmp0_;
	RygelMediaContainer* _tmp1_;
	GUPnPContext* _tmp2_ = NULL;
	GUPnPContext* _tmp3_;
	GUPnPContext* _tmp4_;
	GeeArrayList* _tmp5_ = NULL;
	GeeArrayList* _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (content_dir != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	self = (RygelHTTPServer*) rygel_transcode_manager_construct (object_type);
	_tmp0_ = _g_object_ref0 (content_dir->root_container);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->root_container);
	self->root_container = _tmp1_;
	_tmp2_ = gupnp_service_info_get_context ((GUPnPServiceInfo*) content_dir);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (self->context);
	self->context = _tmp4_;
	_tmp5_ = gee_array_list_new (RYGEL_TYPE_HTTP_REQUEST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (self->priv->requests);
	self->priv->requests = _tmp6_;
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, content_dir->cancellable);
	_tmp7_ = g_strconcat (RYGEL_HTTP_SERVER_SERVER_PATH_PREFIX "/", name, NULL);
	rygel_http_server_set_path_root (self, _tmp7_);
	_g_free0 (_tmp7_);
	return self;
}


RygelHTTPServer* rygel_http_server_new (RygelContentDirectory* content_dir, const gchar* name) {
	return rygel_http_server_construct (RYGEL_TYPE_HTTP_SERVER, content_dir, name);
}


static void rygel_http_server_real_run_data_free (gpointer _data) {
	RygelHttpServerRunData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (RygelHttpServerRunData, data);
}


static void rygel_http_server_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPServer * self;
	RygelHttpServerRunData* _data_;
	self = (RygelHTTPServer*) base;
	_data_ = g_slice_new0 (RygelHttpServerRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_server_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_server_real_run_data_free);
	_data_->self = _g_object_ref0 (self);
	rygel_http_server_real_run_co (_data_);
}


static void rygel_http_server_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelHttpServerRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_http_server_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpServerRunData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_http_server_real_run_co (data);
}


static void _rygel_http_server_server_handler_soup_server_callback (SoupServer* server, SoupMessage* msg, const gchar* path, GHashTable* query, SoupClientContext* client, gpointer self) {
	rygel_http_server_server_handler (self, server, msg, path, query, client);
}


static void _rygel_http_server_on_request_aborted_soup_server_request_aborted (SoupServer* _sender, SoupMessage* msg, SoupClientContext* client, gpointer self) {
	rygel_http_server_on_request_aborted (self, _sender, msg, client);
}


static void _rygel_http_server_on_request_started_soup_server_request_started (SoupServer* _sender, SoupMessage* msg, SoupClientContext* client, gpointer self) {
	rygel_http_server_on_request_started (self, _sender, msg, client);
}


static void _rygel_http_server_on_cancelled_g_cancellable_cancelled (GCancellable* _sender, gpointer self) {
	rygel_http_server_on_cancelled (self, _sender);
}


static gboolean rygel_http_server_real_run_co (RygelHttpServerRunData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = gupnp_context_get_server (data->self->context);
	soup_server_add_handler (data->_tmp0_, data->self->priv->_path_root, _rygel_http_server_server_handler_soup_server_callback, g_object_ref (data->self), g_object_unref);
	data->_tmp1_ = NULL;
	data->_tmp1_ = gupnp_context_get_server (data->self->context);
	g_signal_connect_object (data->_tmp1_, "request-aborted", (GCallback) _rygel_http_server_on_request_aborted_soup_server_request_aborted, data->self, 0);
	data->_tmp2_ = NULL;
	data->_tmp2_ = gupnp_context_get_server (data->self->context);
	g_signal_connect_object (data->_tmp2_, "request-started", (GCallback) _rygel_http_server_on_request_started_soup_server_request_started, data->self, 0);
	data->_tmp3_ = NULL;
	data->_tmp3_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self);
	if (data->_tmp3_ != NULL) {
		data->_tmp4_ = NULL;
		data->_tmp4_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self);
		g_signal_connect_object (data->_tmp4_, "cancelled", (GCallback) _rygel_http_server_on_cancelled_g_cancellable_cancelled, data->self, 0);
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


void rygel_http_server_add_proxy_resource (RygelHTTPServer* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, GError** error) {
	gboolean _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* uri;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	GUPnPDIDLLiteResource* _tmp4_ = NULL;
	GUPnPDIDLLiteResource* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (didl_item != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = rygel_http_server_http_uri_present (self, item);
	if (_tmp0_) {
		return;
	}
	_tmp1_ = rygel_transcode_manager_create_uri_for_item ((RygelTranscodeManager*) self, item, -1, -1, NULL);
	uri = _tmp1_;
	_tmp2_ = rygel_transcode_manager_get_protocol ((RygelTranscodeManager*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = rygel_media_item_add_resource (item, didl_item, uri, _tmp3_, uri, &_inner_error_);
	_tmp5_ = _tmp4_;
	_tmp5_;
	_g_object_unref0 (_tmp5_);
	_g_free0 (_tmp3_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (uri);
		return;
	}
	_g_free0 (uri);
}


gboolean rygel_http_server_need_proxy (RygelHTTPServer* self, const gchar* uri) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (uri != NULL, FALSE);
	_tmp0_ = g_uri_parse_scheme (uri);
	_tmp1_ = _tmp0_;
	result = (_tmp2_ = g_strcmp0 (_tmp1_, "http") != 0, _g_free0 (_tmp1_), _tmp2_);
	return result;
}


static gboolean rygel_http_server_http_uri_present (RygelHTTPServer* self, RygelMediaItem* item) {
	gboolean result = FALSE;
	gboolean present;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item != NULL, FALSE);
	present = FALSE;
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _uri_list;
		gint _tmp1_;
		gint _uri_size;
		gint _uri_index;
		_tmp0_ = _g_object_ref0 (((RygelMediaObject*) item)->uris);
		_uri_list = _tmp0_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _uri_list);
		_uri_size = _tmp1_;
		_uri_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			gchar* uri;
			gboolean _tmp3_;
			_uri_index = _uri_index + 1;
			if (!(_uri_index < _uri_size)) {
				break;
			}
			_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _uri_list, _uri_index);
			uri = (gchar*) _tmp2_;
			_tmp3_ = rygel_http_server_need_proxy (self, uri);
			if (!_tmp3_) {
				present = TRUE;
				_g_free0 (uri);
				break;
			}
			_g_free0 (uri);
		}
		_g_object_unref0 (_uri_list);
	}
	result = present;
	return result;
}


static void rygel_http_server_on_cancelled (RygelHTTPServer* self, GCancellable* cancellable) {
	GCancellable* _tmp0_ = NULL;
	SoupServer* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cancellable != NULL);
	_tmp0_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
	g_cancellable_cancel (_tmp0_);
	_tmp1_ = gupnp_context_get_server (self->context);
	soup_server_remove_handler (_tmp1_, self->priv->_path_root);
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
}


static gchar* rygel_http_server_real_create_uri_for_item (RygelTranscodeManager* base, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target) {
	RygelHTTPServer * self;
	gchar* result = NULL;
	RygelHTTPItemURI* _tmp0_ = NULL;
	RygelHTTPItemURI* uri;
	gchar* _tmp1_ = NULL;
	self = (RygelHTTPServer*) base;
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = rygel_http_item_uri_new (((RygelMediaObject*) item)->id, self, thumbnail_index, subtitle_index, transcode_target);
	uri = _tmp0_;
	_tmp1_ = rygel_http_item_uri_to_string (uri);
	result = _tmp1_;
	_g_object_unref0 (uri);
	return result;
}


static gchar* rygel_http_server_real_get_protocol (RygelTranscodeManager* base) {
	RygelHTTPServer * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = (RygelHTTPServer*) base;
	_tmp0_ = g_strdup ("http-get");
	result = _tmp0_;
	return result;
}


static GeeArrayList* rygel_http_server_real_get_protocol_info (RygelTranscodeManager* base) {
	RygelHTTPServer * self;
	GeeArrayList* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* protocol_infos;
	GUPnPProtocolInfo* _tmp1_ = NULL;
	GUPnPProtocolInfo* protocol_info;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	self = (RygelHTTPServer*) base;
	_tmp0_ = RYGEL_TRANSCODE_MANAGER_CLASS (rygel_http_server_parent_class)->get_protocol_info (RYGEL_TRANSCODE_MANAGER (self));
	protocol_infos = _tmp0_;
	_tmp1_ = gupnp_protocol_info_new ();
	protocol_info = _tmp1_;
	_tmp2_ = rygel_transcode_manager_get_protocol ((RygelTranscodeManager*) self);
	_tmp3_ = _tmp2_;
	gupnp_protocol_info_set_protocol (protocol_info, _tmp3_);
	_g_free0 (_tmp3_);
	gupnp_protocol_info_set_mime_type (protocol_info, "*");
	gee_abstract_collection_add ((GeeAbstractCollection*) protocol_infos, protocol_info);
	result = protocol_infos;
	_g_object_unref0 (protocol_info);
	return result;
}


static void rygel_http_server_on_request_completed (RygelHTTPServer* self, RygelStateMachine* machine) {
	RygelStateMachine* _tmp0_;
	RygelHTTPRequest* _tmp1_;
	RygelHTTPRequest* request;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	SoupURI* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (machine != NULL);
	_tmp1_ = _g_object_ref0 ((_tmp0_ = machine, RYGEL_IS_HTTP_REQUEST (_tmp0_) ? ((RygelHTTPRequest*) _tmp0_) : NULL));
	request = _tmp1_;
	gee_abstract_collection_remove ((GeeAbstractCollection*) self->priv->requests, request);
	_tmp3_ = (g_object_get (request->msg, "method", &_tmp2_, NULL), _tmp2_);
	_tmp4_ = soup_message_get_uri (request->msg);
	_tmp5_ = soup_uri_to_string (_tmp4_, FALSE);
	_tmp6_ = _tmp5_;
	g_debug ("rygel-http-server.vala:134: HTTP %s request for URI '%s' handled.", _tmp3_, _tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
	_g_object_unref0 (request);
}


static void _lambda1_ (const gchar* name, const gchar* value, RygelHTTPServer* self) {
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	g_debug ("rygel-http-server.vala:153: %s : %s", name, value);
}


static void __lambda1__soup_message_headers_foreach_func (const gchar* name, const gchar* value, gpointer self) {
	_lambda1_ (name, value, self);
}


static void rygel_http_server_server_handler (RygelHTTPServer* self, SoupServer* server, SoupMessage* msg, const gchar* server_path, GHashTable* query, SoupClientContext* soup_client) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	SoupURI* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	RygelHTTPGet* _tmp8_ = NULL;
	RygelHTTPGet* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (server != NULL);
	g_return_if_fail (msg != NULL);
	g_return_if_fail (server_path != NULL);
	g_return_if_fail (soup_client != NULL);
	_tmp1_ = (g_object_get (msg, "method", &_tmp0_, NULL), _tmp0_);
	if ((_tmp2_ = g_strcmp0 (_tmp1_, "POST") == 0, _g_free0 (_tmp1_), _tmp2_)) {
		return;
	}
	_tmp4_ = (g_object_get (msg, "method", &_tmp3_, NULL), _tmp3_);
	_tmp5_ = soup_message_get_uri (msg);
	_tmp6_ = soup_uri_to_string (_tmp5_, FALSE);
	_tmp7_ = _tmp6_;
	g_debug ("rygel-http-server.vala:149: HTTP %s request for URI '%s'. Headers:", _tmp4_, _tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp4_);
	soup_message_headers_foreach (msg->request_headers, __lambda1__soup_message_headers_foreach_func, self);
	_tmp8_ = rygel_http_get_new (self, server, msg);
	_tmp9_ = _tmp8_;
	rygel_http_server_queue_request (self, (RygelHTTPRequest*) _tmp9_);
	_g_object_unref0 (_tmp9_);
}


static void rygel_http_server_on_request_aborted (RygelHTTPServer* self, SoupServer* server, SoupMessage* message, SoupClientContext* client) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (server != NULL);
	g_return_if_fail (message != NULL);
	g_return_if_fail (client != NULL);
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _request_list;
		gint _tmp1_;
		gint _request_size;
		gint _request_index;
		_tmp0_ = _g_object_ref0 (self->priv->requests);
		_request_list = _tmp0_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _request_list);
		_request_size = _tmp1_;
		_request_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			RygelHTTPRequest* request;
			_request_index = _request_index + 1;
			if (!(_request_index < _request_size)) {
				break;
			}
			_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _request_list, _request_index);
			request = (RygelHTTPRequest*) _tmp2_;
			if (request->msg == message) {
				GCancellable* _tmp3_ = NULL;
				gchar* _tmp4_ = NULL;
				gchar* _tmp5_;
				SoupURI* _tmp6_ = NULL;
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_;
				_tmp3_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) request);
				g_cancellable_cancel (_tmp3_);
				_tmp5_ = (g_object_get (request->msg, "method", &_tmp4_, NULL), _tmp4_);
				_tmp6_ = soup_message_get_uri (request->msg);
				_tmp7_ = soup_uri_to_string (_tmp6_, FALSE);
				_tmp8_ = _tmp7_;
				g_debug ("rygel-http-server.vala:165: HTTP client aborted %s request for URI '%s" \
"'.", _tmp5_, _tmp8_);
				_g_free0 (_tmp8_);
				_g_free0 (_tmp5_);
				_g_object_unref0 (request);
				break;
			}
			_g_object_unref0 (request);
		}
		_g_object_unref0 (_request_list);
	}
}


static void _rygel_http_server_on_got_headers_soup_message_got_headers (SoupMessage* _sender, gpointer self) {
	rygel_http_server_on_got_headers (self, _sender);
}


static void rygel_http_server_on_request_started (RygelHTTPServer* self, SoupServer* server, SoupMessage* message, SoupClientContext* client) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (server != NULL);
	g_return_if_fail (message != NULL);
	g_return_if_fail (client != NULL);
	g_signal_connect_object (message, "got-headers", (GCallback) _rygel_http_server_on_got_headers_soup_message_got_headers, self, 0);
}


static void rygel_http_server_on_got_headers (RygelHTTPServer* self, SoupMessage* msg) {
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp2_ = (g_object_get (msg, "method", &_tmp1_, NULL), _tmp1_);
	if ((_tmp3_ = g_strcmp0 (_tmp2_, "POST") == 0, _g_free0 (_tmp2_), _tmp3_)) {
		SoupURI* _tmp4_ = NULL;
		gboolean _tmp5_;
		_tmp4_ = soup_message_get_uri (msg);
		_tmp5_ = g_str_has_prefix (_tmp4_->path, self->priv->_path_root);
		_tmp0_ = _tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		SoupURI* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		SoupServer* _tmp9_ = NULL;
		RygelHTTPPost* _tmp10_ = NULL;
		RygelHTTPPost* _tmp11_;
		_tmp6_ = soup_message_get_uri (msg);
		_tmp7_ = soup_uri_to_string (_tmp6_, FALSE);
		_tmp8_ = _tmp7_;
		g_debug ("rygel-http-server.vala:183: HTTP POST request for URI '%s'", _tmp8_);
		_g_free0 (_tmp8_);
		_tmp9_ = gupnp_context_get_server (self->context);
		_tmp10_ = rygel_http_post_new (self, _tmp9_, msg);
		_tmp11_ = _tmp10_;
		rygel_http_server_queue_request (self, (RygelHTTPRequest*) _tmp11_);
		_g_object_unref0 (_tmp11_);
	}
}


static void _rygel_http_server_on_request_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self) {
	rygel_http_server_on_request_completed (self, _sender);
}


static void rygel_http_server_queue_request (RygelHTTPServer* self, RygelHTTPRequest* request) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (request != NULL);
	g_signal_connect_object ((RygelStateMachine*) request, "completed", (GCallback) _rygel_http_server_on_request_completed_rygel_state_machine_completed, self, 0);
	gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->requests, request);
	rygel_state_machine_run ((RygelStateMachine*) request, NULL, NULL);
}


const gchar* rygel_http_server_get_path_root (RygelHTTPServer* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_path_root;
	return result;
}


static void rygel_http_server_set_path_root (RygelHTTPServer* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_path_root);
	self->priv->_path_root = _tmp1_;
	g_object_notify ((GObject *) self, "path-root");
}


static GCancellable* rygel_http_server_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelHTTPServer* self;
	self = (RygelHTTPServer*) base;
	result = self->priv->_cancellable;
	return result;
}


static void rygel_http_server_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelHTTPServer* self;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	self = (RygelHTTPServer*) base;
	_tmp0_ = _g_object_ref0 (value);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->_cancellable);
	self->priv->_cancellable = _tmp1_;
	g_object_notify ((GObject *) self, "cancellable");
}


static void rygel_http_server_class_init (RygelHTTPServerClass * klass) {
	rygel_http_server_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPServerPrivate));
	RYGEL_TRANSCODE_MANAGER_CLASS (klass)->create_uri_for_item = rygel_http_server_real_create_uri_for_item;
	RYGEL_TRANSCODE_MANAGER_CLASS (klass)->get_protocol = rygel_http_server_real_get_protocol;
	RYGEL_TRANSCODE_MANAGER_CLASS (klass)->get_protocol_info = rygel_http_server_real_get_protocol_info;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_server_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_server_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_server_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SERVER_PATH_ROOT, g_param_spec_string ("path-root", "path-root", "path-root", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SERVER_CANCELLABLE, "cancellable");
}


static void rygel_http_server_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
	rygel_http_server_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = (void (*)(RygelStateMachine*)) rygel_http_server_real_run;
	iface->run_finish = rygel_http_server_real_run_finish;
	iface->get_cancellable = rygel_http_server_real_get_cancellable;
	iface->set_cancellable = rygel_http_server_real_set_cancellable;
}


static void rygel_http_server_instance_init (RygelHTTPServer * self) {
	self->priv = RYGEL_HTTP_SERVER_GET_PRIVATE (self);
}


static void rygel_http_server_finalize (GObject* obj) {
	RygelHTTPServer * self;
	self = RYGEL_HTTP_SERVER (obj);
	_g_free0 (self->priv->_path_root);
	_g_object_unref0 (self->root_container);
	_g_object_unref0 (self->context);
	_g_object_unref0 (self->priv->requests);
	_g_object_unref0 (self->priv->_cancellable);
	G_OBJECT_CLASS (rygel_http_server_parent_class)->finalize (obj);
}


GType rygel_http_server_get_type (void) {
	static volatile gsize rygel_http_server_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_server_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPServerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_server_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPServer), 0, (GInstanceInitFunc) rygel_http_server_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_http_server_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_http_server_type_id;
		rygel_http_server_type_id = g_type_register_static (RYGEL_TYPE_TRANSCODE_MANAGER, "RygelHTTPServer", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_http_server_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_http_server_type_id__volatile, rygel_http_server_type_id);
	}
	return rygel_http_server_type_id__volatile;
}


static void _vala_rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPServer * self;
	self = RYGEL_HTTP_SERVER (object);
	switch (property_id) {
		case RYGEL_HTTP_SERVER_PATH_ROOT:
		g_value_set_string (value, rygel_http_server_get_path_root (self));
		break;
		case RYGEL_HTTP_SERVER_CANCELLABLE:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_http_server_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPServer * self;
	self = RYGEL_HTTP_SERVER (object);
	switch (property_id) {
		case RYGEL_HTTP_SERVER_PATH_ROOT:
		rygel_http_server_set_path_root (self, g_value_get_string (value));
		break;
		case RYGEL_HTTP_SERVER_CANCELLABLE:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



