/* rygel-thumbnailer.c generated by valac 0.9.5, the Vala compiler
 * generated from rygel-thumbnailer.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_THUMBNAILER (rygel_thumbnailer_get_type ())
#define RYGEL_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAILER, RygelThumbnailer))
#define RYGEL_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAILER, RygelThumbnailerClass))
#define RYGEL_IS_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAILER))
#define RYGEL_IS_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAILER))
#define RYGEL_THUMBNAILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAILER, RygelThumbnailerClass))

typedef struct _RygelThumbnailer RygelThumbnailer;
typedef struct _RygelThumbnailerClass RygelThumbnailerClass;
typedef struct _RygelThumbnailerPrivate RygelThumbnailerPrivate;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelIconInfoPrivate RygelIconInfoPrivate;
typedef struct _RygelThumbnailPrivate RygelThumbnailPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	THUMBNAILER_ERROR_NO_DIR,
	THUMBNAILER_ERROR_NO_THUMBNAIL
} ThumbnailerError;
#define THUMBNAILER_ERROR thumbnailer_error_quark ()
struct _RygelThumbnailer {
	GObject parent_instance;
	RygelThumbnailerPrivate * priv;
	char* directory;
};

struct _RygelThumbnailerClass {
	GObjectClass parent_class;
};

struct _RygelThumbnailerPrivate {
	RygelThumbnail* template;
	char* extension;
};

struct _RygelIconInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelIconInfoPrivate * priv;
	char* mime_type;
	char* uri;
	char* file_extension;
	gint64 size;
	gint width;
	gint height;
	gint depth;
};

struct _RygelIconInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelIconInfo *self);
};

struct _RygelThumbnail {
	RygelIconInfo parent_instance;
	RygelThumbnailPrivate * priv;
	char* dlna_profile;
};

struct _RygelThumbnailClass {
	RygelIconInfoClass parent_class;
	GUPnPDIDLLiteResource* (*add_resource) (RygelThumbnail* self, GUPnPDIDLLiteItem* didl_item, const char* protocol);
};


static RygelThumbnailer* rygel_thumbnailer_thumbnailer;
static RygelThumbnailer* rygel_thumbnailer_thumbnailer = NULL;
static gboolean rygel_thumbnailer_first_time;
static gboolean rygel_thumbnailer_first_time = TRUE;
static gpointer rygel_thumbnailer_parent_class = NULL;

GQuark thumbnailer_error_quark (void);
GType rygel_thumbnailer_get_type (void) G_GNUC_CONST;
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
#define RYGEL_THUMBNAILER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_THUMBNAILER, RygelThumbnailerPrivate))
enum  {
	RYGEL_THUMBNAILER_DUMMY_PROPERTY
};
RygelThumbnail* rygel_thumbnail_new (const char* mime_type, const char* dlna_profile, const char* file_extension);
RygelThumbnail* rygel_thumbnail_construct (GType object_type, const char* mime_type, const char* dlna_profile, const char* file_extension);
static RygelThumbnailer* rygel_thumbnailer_new (GError** error);
static RygelThumbnailer* rygel_thumbnailer_construct (GType object_type, GError** error);
RygelThumbnailer* rygel_thumbnailer_get_default (void);
RygelThumbnail* rygel_thumbnailer_get_thumbnail (RygelThumbnailer* self, const char* uri, GError** error);
static void rygel_thumbnailer_finalize (GObject* obj);



GQuark thumbnailer_error_quark (void) {
	return g_quark_from_static_string ("thumbnailer_error-quark");
}


#line 42 "rygel-thumbnailer.vala"
static RygelThumbnailer* rygel_thumbnailer_construct (GType object_type, GError** error) {
#line 160 "rygel-thumbnailer.c"
	GError * _inner_error_;
	RygelThumbnailer * self;
	char* dir;
	GFile* file;
	RygelThumbnail* _tmp0_;
	char* _tmp7_;
	_inner_error_ = NULL;
#line 42 "rygel-thumbnailer.vala"
	self = (RygelThumbnailer*) g_object_new (object_type, NULL);
#line 43 "rygel-thumbnailer.vala"
	dir = g_build_filename (g_get_home_dir (), ".thumbnails", "cropped", NULL);
#line 46 "rygel-thumbnailer.vala"
	file = g_file_new_for_path (dir);
#line 47 "rygel-thumbnailer.vala"
	self->priv->template = (_tmp0_ = rygel_thumbnail_new ("image/jpeg", "JPEG_TN", "jpg"), _rygel_icon_info_unref0 (self->priv->template), _tmp0_);
#line 49 "rygel-thumbnailer.vala"
	if (!g_file_query_exists (file, NULL)) {
#line 178 "rygel-thumbnailer.c"
		char* _tmp1_;
		GFile* _tmp2_;
#line 50 "rygel-thumbnailer.vala"
		dir = (_tmp1_ = g_build_filename (g_get_home_dir (), ".thumbnails", "normal", NULL), _g_free0 (dir), _tmp1_);
#line 53 "rygel-thumbnailer.vala"
		file = (_tmp2_ = g_file_new_for_path (dir), _g_object_unref0 (file), _tmp2_);
#line 55 "rygel-thumbnailer.vala"
		if (!g_file_query_exists (file, NULL)) {
#line 187 "rygel-thumbnailer.c"
			char* message;
#line 56 "rygel-thumbnailer.vala"
			message = g_strdup (_ ("Failed to find thumbnails folder."));
#line 191 "rygel-thumbnailer.c"
			_inner_error_ = g_error_new_literal (THUMBNAILER_ERROR, THUMBNAILER_ERROR_NO_DIR, message);
			{
				if (_inner_error_->domain == THUMBNAILER_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (message);
					_g_object_unref0 (file);
					_g_free0 (dir);
					_g_object_unref0 (self);
					return NULL;
				} else {
					_g_free0 (message);
					_g_object_unref0 (file);
					_g_free0 (dir);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_g_free0 (message);
		} else {
			char* _tmp3_;
			char* _tmp4_;
			char* _tmp5_;
#line 60 "rygel-thumbnailer.vala"
			((RygelIconInfo*) self->priv->template)->mime_type = (_tmp3_ = g_strdup ("image/png"), _g_free0 (((RygelIconInfo*) self->priv->template)->mime_type), _tmp3_);
#line 61 "rygel-thumbnailer.vala"
			self->priv->template->dlna_profile = (_tmp4_ = g_strdup ("PNG_TN"), _g_free0 (self->priv->template->dlna_profile), _tmp4_);
#line 62 "rygel-thumbnailer.vala"
			((RygelIconInfo*) self->priv->template)->width = 128;
#line 63 "rygel-thumbnailer.vala"
			((RygelIconInfo*) self->priv->template)->height = 128;
#line 64 "rygel-thumbnailer.vala"
			((RygelIconInfo*) self->priv->template)->depth = 32;
#line 65 "rygel-thumbnailer.vala"
			self->priv->extension = (_tmp5_ = g_strdup (".png"), _g_free0 (self->priv->extension), _tmp5_);
#line 227 "rygel-thumbnailer.c"
		}
	} else {
		char* _tmp6_;
#line 68 "rygel-thumbnailer.vala"
		((RygelIconInfo*) self->priv->template)->width = 124;
#line 69 "rygel-thumbnailer.vala"
		((RygelIconInfo*) self->priv->template)->height = 124;
#line 70 "rygel-thumbnailer.vala"
		((RygelIconInfo*) self->priv->template)->depth = 24;
#line 71 "rygel-thumbnailer.vala"
		self->priv->extension = (_tmp6_ = g_strdup (".jpeg"), _g_free0 (self->priv->extension), _tmp6_);
#line 239 "rygel-thumbnailer.c"
	}
#line 74 "rygel-thumbnailer.vala"
	self->directory = (_tmp7_ = g_strdup (dir), _g_free0 (self->directory), _tmp7_);
#line 243 "rygel-thumbnailer.c"
	_g_object_unref0 (file);
	_g_free0 (dir);
	return self;
}


#line 42 "rygel-thumbnailer.vala"
static RygelThumbnailer* rygel_thumbnailer_new (GError** error) {
#line 42 "rygel-thumbnailer.vala"
	return rygel_thumbnailer_construct (RYGEL_TYPE_THUMBNAILER, error);
#line 254 "rygel-thumbnailer.c"
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 77 "rygel-thumbnailer.vala"
RygelThumbnailer* rygel_thumbnailer_get_default (void) {
#line 265 "rygel-thumbnailer.c"
	RygelThumbnailer* result = NULL;
	GError * _inner_error_;
	_inner_error_ = NULL;
#line 78 "rygel-thumbnailer.vala"
	if (rygel_thumbnailer_first_time) {
#line 271 "rygel-thumbnailer.c"
		{
			RygelThumbnailer* _tmp0_;
			RygelThumbnailer* _tmp1_;
#line 80 "rygel-thumbnailer.vala"
			_tmp0_ = rygel_thumbnailer_new (&_inner_error_);
#line 277 "rygel-thumbnailer.c"
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == THUMBNAILER_ERROR) {
					goto __catch43_thumbnailer_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
#line 80 "rygel-thumbnailer.vala"
			rygel_thumbnailer_thumbnailer = (_tmp1_ = _tmp0_, _g_object_unref0 (rygel_thumbnailer_thumbnailer), _tmp1_);
#line 288 "rygel-thumbnailer.c"
		}
		goto __finally43;
		__catch43_thumbnailer_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			{
#line 82 "rygel-thumbnailer.vala"
				g_warning (_ ("No thumbnailer available: %s"), err->message);
#line 299 "rygel-thumbnailer.c"
				_g_error_free0 (err);
			}
		}
		__finally43:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 85 "rygel-thumbnailer.vala"
		rygel_thumbnailer_first_time = FALSE;
#line 311 "rygel-thumbnailer.c"
	}
	result = _g_object_ref0 (rygel_thumbnailer_thumbnailer);
#line 88 "rygel-thumbnailer.vala"
	return result;
#line 316 "rygel-thumbnailer.c"
}


#line 91 "rygel-thumbnailer.vala"
RygelThumbnail* rygel_thumbnailer_get_thumbnail (RygelThumbnailer* self, const char* uri, GError** error) {
#line 322 "rygel-thumbnailer.c"
	RygelThumbnail* result = NULL;
	GError * _inner_error_;
	RygelThumbnail* thumbnail;
	char* _tmp0_;
	char* _tmp1_;
	char* path;
	char* full_path;
	GFile* file;
	GFileInfo* info;
	RygelThumbnail* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
#line 91 "rygel-thumbnailer.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 91 "rygel-thumbnailer.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 339 "rygel-thumbnailer.c"
	_inner_error_ = NULL;
#line 92 "rygel-thumbnailer.vala"
	thumbnail = NULL;
#line 94 "rygel-thumbnailer.vala"
	path = (_tmp1_ = g_strconcat (_tmp0_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, uri, -1), self->priv->extension, NULL), _g_free0 (_tmp0_), _tmp1_);
#line 96 "rygel-thumbnailer.vala"
	full_path = g_build_filename (self->directory, path, NULL);
#line 97 "rygel-thumbnailer.vala"
	file = g_file_new_for_path (full_path);
#line 99 "rygel-thumbnailer.vala"
	info = g_file_query_info (file, G_FILE_ATTRIBUTE_ACCESS_CAN_READ "," G_FILE_ATTRIBUTE_STANDARD_SIZE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 351 "rygel-thumbnailer.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (file);
		_g_free0 (full_path);
		_g_free0 (path);
		_rygel_icon_info_unref0 (thumbnail);
		return NULL;
	}
#line 104 "rygel-thumbnailer.vala"
	if (!g_file_info_get_attribute_boolean (info, G_FILE_ATTRIBUTE_ACCESS_CAN_READ)) {
#line 362 "rygel-thumbnailer.c"
		_inner_error_ = g_error_new_literal (THUMBNAILER_ERROR, THUMBNAILER_ERROR_NO_THUMBNAIL, _ ("No thumbnail available"));
		{
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (info);
			_g_object_unref0 (file);
			_g_free0 (full_path);
			_g_free0 (path);
			_rygel_icon_info_unref0 (thumbnail);
			return NULL;
		}
	}
#line 109 "rygel-thumbnailer.vala"
	thumbnail = (_tmp2_ = rygel_thumbnail_new ("image/jpeg", "JPEG_TN", "jpg"), _rygel_icon_info_unref0 (thumbnail), _tmp2_);
#line 110 "rygel-thumbnailer.vala"
	((RygelIconInfo*) thumbnail)->width = ((RygelIconInfo*) self->priv->template)->width;
#line 111 "rygel-thumbnailer.vala"
	((RygelIconInfo*) thumbnail)->height = ((RygelIconInfo*) self->priv->template)->height;
#line 112 "rygel-thumbnailer.vala"
	((RygelIconInfo*) thumbnail)->depth = ((RygelIconInfo*) self->priv->template)->depth;
#line 113 "rygel-thumbnailer.vala"
	_tmp3_ = g_filename_to_uri (full_path, NULL, &_inner_error_);
#line 384 "rygel-thumbnailer.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		_g_free0 (full_path);
		_g_free0 (path);
		_rygel_icon_info_unref0 (thumbnail);
		return NULL;
	}
#line 113 "rygel-thumbnailer.vala"
	((RygelIconInfo*) thumbnail)->uri = (_tmp4_ = _tmp3_, _g_free0 (((RygelIconInfo*) thumbnail)->uri), _tmp4_);
#line 114 "rygel-thumbnailer.vala"
	((RygelIconInfo*) thumbnail)->size = (gint64) g_file_info_get_attribute_uint64 (info, G_FILE_ATTRIBUTE_STANDARD_SIZE);
#line 398 "rygel-thumbnailer.c"
	result = thumbnail;
	_g_object_unref0 (info);
	_g_object_unref0 (file);
	_g_free0 (full_path);
	_g_free0 (path);
#line 117 "rygel-thumbnailer.vala"
	return result;
#line 406 "rygel-thumbnailer.c"
}


static void rygel_thumbnailer_class_init (RygelThumbnailerClass * klass) {
	rygel_thumbnailer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelThumbnailerPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_thumbnailer_finalize;
}


static void rygel_thumbnailer_instance_init (RygelThumbnailer * self) {
	self->priv = RYGEL_THUMBNAILER_GET_PRIVATE (self);
}


static void rygel_thumbnailer_finalize (GObject* obj) {
	RygelThumbnailer * self;
	self = RYGEL_THUMBNAILER (obj);
	_g_free0 (self->directory);
	_rygel_icon_info_unref0 (self->priv->template);
	_g_free0 (self->priv->extension);
	G_OBJECT_CLASS (rygel_thumbnailer_parent_class)->finalize (obj);
}


/**
 * Provides thumbnails for images and vidoes.
 */
GType rygel_thumbnailer_get_type (void) {
	static volatile gsize rygel_thumbnailer_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_thumbnailer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelThumbnailerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_thumbnailer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelThumbnailer), 0, (GInstanceInitFunc) rygel_thumbnailer_instance_init, NULL };
		GType rygel_thumbnailer_type_id;
		rygel_thumbnailer_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelThumbnailer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_thumbnailer_type_id__volatile, rygel_thumbnailer_type_id);
	}
	return rygel_thumbnailer_type_id__volatile;
}




