/* rygel-media-export-root-container.c generated by valac 0.9.5, the Vala compiler
 * generated from rygel-media-export-root-container.vala, do not modify */

/*
 * Copyright (C) 2009,2010 Jens Georg <mail@jensge.org>.
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <rygel.h>
#include <gio/gio.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_MEDIA_EXPORT_TYPE_FOLDER_DEFINITION (rygel_media_export_folder_definition_get_type ())
typedef struct _RygelMediaExportFolderDefinition RygelMediaExportFolderDefinition;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER (rygel_media_export_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainer))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))

typedef struct _RygelMediaExportDBContainer RygelMediaExportDBContainer;
typedef struct _RygelMediaExportDBContainerClass RygelMediaExportDBContainerClass;
typedef struct _RygelMediaExportDBContainerPrivate RygelMediaExportDBContainerPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;

#define RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER (rygel_media_export_root_container_get_type ())
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, RygelMediaExportRootContainer))
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, RygelMediaExportRootContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_ROOT_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_ROOT_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER))
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, RygelMediaExportRootContainerClass))

typedef struct _RygelMediaExportRootContainer RygelMediaExportRootContainer;
typedef struct _RygelMediaExportRootContainerClass RygelMediaExportRootContainerClass;
typedef struct _RygelMediaExportRootContainerPrivate RygelMediaExportRootContainerPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_DBUS_SERVICE (rygel_media_export_dbus_service_get_type ())
#define RYGEL_MEDIA_EXPORT_DBUS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DBUS_SERVICE, RygelMediaExportDBusService))
#define RYGEL_MEDIA_EXPORT_DBUS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DBUS_SERVICE, RygelMediaExportDBusServiceClass))
#define RYGEL_MEDIA_EXPORT_IS_DBUS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DBUS_SERVICE))
#define RYGEL_MEDIA_EXPORT_IS_DBUS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DBUS_SERVICE))
#define RYGEL_MEDIA_EXPORT_DBUS_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DBUS_SERVICE, RygelMediaExportDBusServiceClass))

typedef struct _RygelMediaExportDBusService RygelMediaExportDBusService;
typedef struct _RygelMediaExportDBusServiceClass RygelMediaExportDBusServiceClass;

#define RYGEL_MEDIA_EXPORT_TYPE_HARVESTER (rygel_media_export_harvester_get_type ())
#define RYGEL_MEDIA_EXPORT_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvester))
#define RYGEL_MEDIA_EXPORT_HARVESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterClass))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER))
#define RYGEL_MEDIA_EXPORT_HARVESTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterClass))

typedef struct _RygelMediaExportHarvester RygelMediaExportHarvester;
typedef struct _RygelMediaExportHarvesterClass RygelMediaExportHarvesterClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_NULL_CONTAINER (rygel_null_container_get_type ())
#define RYGEL_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainer))
#define RYGEL_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))
#define RYGEL_IS_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_IS_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_NULL_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))

typedef struct _RygelNullContainer RygelNullContainer;
typedef struct _RygelNullContainerClass RygelNullContainerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER (rygel_media_export_query_container_get_type ())
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainer))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainerClass))

typedef struct _RygelMediaExportQueryContainer RygelMediaExportQueryContainer;
typedef struct _RygelMediaExportQueryContainerClass RygelMediaExportQueryContainerClass;
typedef struct _RygelMediaExportRootContainerFindObjectData RygelMediaExportRootContainerFindObjectData;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
typedef struct _RygelMediaExportRootContainerSearchData RygelMediaExportRootContainerSearchData;
typedef struct _RygelMediaExportQueryContainerPrivate RygelMediaExportQueryContainerPrivate;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _RygelMediaExportFolderDefinition {
	char* title;
	char* definition;
};

struct _RygelMediaExportDBContainer {
	RygelMediaContainer parent_instance;
	RygelMediaExportDBContainerPrivate * priv;
	RygelMediaExportMediaCache* media_db;
};

struct _RygelMediaExportDBContainerClass {
	RygelMediaContainerClass parent_class;
};

struct _RygelMediaExportRootContainer {
	RygelMediaExportDBContainer parent_instance;
	RygelMediaExportRootContainerPrivate * priv;
};

struct _RygelMediaExportRootContainerClass {
	RygelMediaExportDBContainerClass parent_class;
};

struct _RygelMediaExportRootContainerPrivate {
	RygelMediaExportDBusService* service;
	RygelMediaExportHarvester* harvester;
	GCancellable* cancellable;
	RygelMediaContainer* filesystem_container;
};

typedef enum  {
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_IO_ERROR,
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR
} RygelMediaExportDatabaseError;
#define RYGEL_MEDIA_EXPORT_DATABASE_ERROR rygel_media_export_database_error_quark ()
struct _RygelMediaExportRootContainerFindObjectData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaExportRootContainer* self;
	char* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	RygelMediaObject* object;
	gboolean _tmp0_;
	RygelMediaExportQueryContainer* container;
	GError * _inner_error_;
};

struct _RygelMediaExportRootContainerSearchData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaExportRootContainer* self;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelMediaObjects* _tmp0_;
	RygelMediaObjects* list;
	RygelMediaContainer* query_container;
	char* upnp_class;
	RygelRelationalExpression* relational_expression;
	RygelSearchExpression* _tmp1_;
	RygelMediaContainer* _tmp2_;
	char* _tmp3_;
	RygelMediaContainer* _tmp6_;
	gboolean _tmp5_;
	RygelMediaContainer* _tmp4_;
	RygelMediaObjects* _tmp7_;
	RygelMediaObjects* _tmp8_;
	GeeIterator* _object_it;
	RygelMediaObject* object;
	char* _tmp9_;
	RygelMediaObjects* _tmp10_;
	GError * _inner_error_;
};

struct _RygelMediaExportQueryContainer {
	RygelMediaExportDBContainer parent_instance;
	RygelMediaExportQueryContainerPrivate * priv;
	char* plaintext_id;
};

struct _RygelMediaExportQueryContainerClass {
	RygelMediaExportDBContainerClass parent_class;
};


static RygelMediaContainer* rygel_media_export_root_container_instance;
static RygelMediaContainer* rygel_media_export_root_container_instance = NULL;
static gpointer rygel_media_export_root_container_parent_class = NULL;

GType rygel_media_export_folder_definition_get_type (void) G_GNUC_CONST;
RygelMediaExportFolderDefinition* rygel_media_export_folder_definition_dup (const RygelMediaExportFolderDefinition* self);
void rygel_media_export_folder_definition_free (RygelMediaExportFolderDefinition* self);
void rygel_media_export_folder_definition_copy (const RygelMediaExportFolderDefinition* self, RygelMediaExportFolderDefinition* dest);
void rygel_media_export_folder_definition_destroy (RygelMediaExportFolderDefinition* self);
GType rygel_media_export_db_container_get_type (void) G_GNUC_CONST;
GType rygel_media_export_media_cache_get_type (void) G_GNUC_CONST;
GType rygel_media_export_root_container_get_type (void) G_GNUC_CONST;
GType rygel_media_export_dbus_service_get_type (void) G_GNUC_CONST;
GType rygel_media_export_harvester_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, RygelMediaExportRootContainerPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_DUMMY_PROPERTY
};
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_NAME "Files & Folders"
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID "Filesystem"
static RygelMediaExportRootContainer* rygel_media_export_root_container_new (GError** error);
static RygelMediaExportRootContainer* rygel_media_export_root_container_construct (GType object_type, GError** error);
RygelNullContainer* rygel_null_container_new (void);
RygelNullContainer* rygel_null_container_construct (GType object_type);
GType rygel_null_container_get_type (void) G_GNUC_CONST;
RygelMediaContainer* rygel_media_export_root_container_get_instance (void);
void rygel_media_export_root_container_shutdown (RygelMediaExportRootContainer* self);
void rygel_media_export_harvester_schedule (RygelMediaExportHarvester* self, GFile* file, RygelMediaContainer* parent, const char* flag);
void rygel_media_export_root_container_add_uri (RygelMediaExportRootContainer* self, const char* uri);
char* rygel_media_export_media_cache_get_id (GFile* file);
void rygel_media_export_harvester_cancel (RygelMediaExportHarvester* self, GFile* file);
GQuark rygel_media_export_database_error_quark (void);
void rygel_media_export_media_cache_remove_by_id (RygelMediaExportMediaCache* self, const char* id, GError** error);
void rygel_media_export_root_container_remove_uri (RygelMediaExportRootContainer* self, const char* uri);
GeeList* rygel_media_export_media_cache_get_flagged_uris (RygelMediaExportMediaCache* self, const char* flag, GError** error);
char** rygel_media_export_root_container_get_dynamic_uris (RygelMediaExportRootContainer* self, int* result_length1);
static void rygel_media_export_root_container_real_find_object_data_free (gpointer _data);
static void rygel_media_export_root_container_real_find_object (RygelMediaContainer* base, const char* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_media_export_root_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX "virtual-container:"
RygelMediaExportQueryContainer* rygel_media_export_query_container_new (RygelMediaExportMediaCache* media_db, const char* id, const char* name);
RygelMediaExportQueryContainer* rygel_media_export_query_container_construct (GType object_type, RygelMediaExportMediaCache* media_db, const char* id, const char* name);
GType rygel_media_export_query_container_get_type (void) G_GNUC_CONST;
static gboolean rygel_media_export_root_container_real_find_object_co (RygelMediaExportRootContainerFindObjectData* data);
static void rygel_media_export_root_container_real_search_data_free (gpointer _data);
static void rygel_media_export_root_container_real_search (RygelMediaContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_media_export_root_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static RygelMediaExportQueryContainer* rygel_media_export_root_container_search_to_virtual_container (RygelMediaExportRootContainer* self, RygelRelationalExpression* expression);
static gboolean rygel_media_export_root_container_is_search_in_virtual_container (RygelMediaExportRootContainer* self, RygelSearchExpression* expression, RygelMediaContainer** container);
static gboolean rygel_media_export_root_container_real_search_co (RygelMediaExportRootContainerSearchData* data);
static GeeArrayList* rygel_media_export_root_container_get_uris (RygelMediaExportRootContainer* self);
void rygel_media_export_query_container_register_id (char** id);
RygelMediaExportMediaCache* rygel_media_export_media_cache_get_default (GError** error);
RygelMediaExportDBContainer* rygel_media_export_db_container_new (RygelMediaExportMediaCache* media_db, const char* id, const char* title);
RygelMediaExportDBContainer* rygel_media_export_db_container_construct (GType object_type, RygelMediaExportMediaCache* media_db, const char* id, const char* title);
RygelMediaExportHarvester* rygel_media_export_harvester_new (GCancellable* cancellable);
RygelMediaExportHarvester* rygel_media_export_harvester_construct (GType object_type, GCancellable* cancellable);
RygelMediaExportDBusService* rygel_media_export_dbus_service_new (RygelMediaExportRootContainer* root_container, GError** error);
RygelMediaExportDBusService* rygel_media_export_dbus_service_construct (GType object_type, RygelMediaExportRootContainer* root_container, GError** error);
void rygel_media_export_media_cache_save_container (RygelMediaExportMediaCache* self, RygelMediaContainer* container, GError** error);
GeeArrayList* rygel_media_export_media_cache_get_child_ids (RygelMediaExportMediaCache* self, const char* container_id, GError** error);
static void rygel_media_export_root_container_add_default_virtual_folders (RygelMediaExportRootContainer* self);
static void rygel_media_export_root_container_add_virtual_containers_for_class (RygelMediaExportRootContainer* self, const char* parent, const char* item_class, RygelMediaExportFolderDefinition* definitions, int definitions_length1, GError** error);
static void rygel_media_export_root_container_add_folder_definition (RygelMediaExportRootContainer* self, RygelMediaContainer* container, const char* item_class, RygelMediaExportFolderDefinition* definition, GError** error);
static void rygel_media_export_root_container_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);

const RygelMediaExportFolderDefinition virtual_folders_default[2] = {{N_ ("Year"), "dc:date,?"}, {N_ ("All"), ""}};
const RygelMediaExportFolderDefinition virtual_folders_music[3] = {{N_ ("Artist"), "upnp:artist,?,upnp:album,?"}, {N_ ("Album"), "upnp:album,?"}, {N_ ("Genre"), "dc:genre,?"}};


void rygel_media_export_folder_definition_copy (const RygelMediaExportFolderDefinition* self, RygelMediaExportFolderDefinition* dest) {
	dest->title = g_strdup (self->title);
	dest->definition = g_strdup (self->definition);
}


void rygel_media_export_folder_definition_destroy (RygelMediaExportFolderDefinition* self) {
	_g_free0 (self->title);
	_g_free0 (self->definition);
}


RygelMediaExportFolderDefinition* rygel_media_export_folder_definition_dup (const RygelMediaExportFolderDefinition* self) {
	RygelMediaExportFolderDefinition* dup;
	dup = g_new0 (RygelMediaExportFolderDefinition, 1);
	rygel_media_export_folder_definition_copy (self, dup);
	return dup;
}


void rygel_media_export_folder_definition_free (RygelMediaExportFolderDefinition* self) {
	rygel_media_export_folder_definition_destroy (self);
	g_free (self);
}


GType rygel_media_export_folder_definition_get_type (void) {
	static volatile gsize rygel_media_export_folder_definition_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_folder_definition_type_id__volatile)) {
		GType rygel_media_export_folder_definition_type_id;
		rygel_media_export_folder_definition_type_id = g_boxed_type_register_static ("RygelMediaExportFolderDefinition", (GBoxedCopyFunc) rygel_media_export_folder_definition_dup, (GBoxedFreeFunc) rygel_media_export_folder_definition_free);
		g_once_init_leave (&rygel_media_export_folder_definition_type_id__volatile, rygel_media_export_folder_definition_type_id);
	}
	return rygel_media_export_folder_definition_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 54 "rygel-media-export-root-container.vala"
RygelMediaContainer* rygel_media_export_root_container_get_instance (void) {
#line 326 "rygel-media-export-root-container.c"
	RygelMediaContainer* result = NULL;
	GError * _inner_error_;
	_inner_error_ = NULL;
#line 55 "rygel-media-export-root-container.vala"
	if (rygel_media_export_root_container_instance == NULL) {
#line 332 "rygel-media-export-root-container.c"
		{
			RygelMediaExportRootContainer* _tmp0_;
			RygelMediaContainer* _tmp1_;
#line 57 "rygel-media-export-root-container.vala"
			_tmp0_ = rygel_media_export_root_container_new (&_inner_error_);
#line 338 "rygel-media-export-root-container.c"
			if (_inner_error_ != NULL) {
				goto __catch23_g_error;
			}
#line 57 "rygel-media-export-root-container.vala"
			rygel_media_export_root_container_instance = (_tmp1_ = (RygelMediaContainer*) _tmp0_, _g_object_unref0 (rygel_media_export_root_container_instance), _tmp1_);
#line 344 "rygel-media-export-root-container.c"
		}
		goto __finally23;
		__catch23_g_error:
		{
			GError * _error_;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			{
				RygelMediaContainer* _tmp2_;
#line 59 "rygel-media-export-root-container.vala"
				g_warning ("rygel-media-export-root-container.vala:59: %s", _ ("Failed to create instance of database"));
#line 60 "rygel-media-export-root-container.vala"
				rygel_media_export_root_container_instance = (_tmp2_ = (RygelMediaContainer*) rygel_null_container_new (), _g_object_unref0 (rygel_media_export_root_container_instance), _tmp2_);
#line 358 "rygel-media-export-root-container.c"
				_g_error_free0 (_error_);
			}
		}
		__finally23:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _g_object_ref0 (rygel_media_export_root_container_instance);
#line 64 "rygel-media-export-root-container.vala"
	return result;
#line 372 "rygel-media-export-root-container.c"
}


#line 67 "rygel-media-export-root-container.vala"
void rygel_media_export_root_container_shutdown (RygelMediaExportRootContainer* self) {
#line 67 "rygel-media-export-root-container.vala"
	g_return_if_fail (self != NULL);
#line 68 "rygel-media-export-root-container.vala"
	g_cancellable_cancel (self->priv->cancellable);
#line 382 "rygel-media-export-root-container.c"
}


#line 73 "rygel-media-export-root-container.vala"
void rygel_media_export_root_container_add_uri (RygelMediaExportRootContainer* self, const char* uri) {
#line 388 "rygel-media-export-root-container.c"
	GFile* file;
#line 73 "rygel-media-export-root-container.vala"
	g_return_if_fail (self != NULL);
#line 73 "rygel-media-export-root-container.vala"
	g_return_if_fail (uri != NULL);
#line 74 "rygel-media-export-root-container.vala"
	file = g_file_new_for_commandline_arg (uri);
#line 75 "rygel-media-export-root-container.vala"
	rygel_media_export_harvester_schedule (self->priv->harvester, file, self->priv->filesystem_container, "DBUS");
#line 398 "rygel-media-export-root-container.c"
	_g_object_unref0 (file);
}


#line 80 "rygel-media-export-root-container.vala"
void rygel_media_export_root_container_remove_uri (RygelMediaExportRootContainer* self, const char* uri) {
#line 405 "rygel-media-export-root-container.c"
	GError * _inner_error_;
	GFile* file;
	char* id;
#line 80 "rygel-media-export-root-container.vala"
	g_return_if_fail (self != NULL);
#line 80 "rygel-media-export-root-container.vala"
	g_return_if_fail (uri != NULL);
#line 413 "rygel-media-export-root-container.c"
	_inner_error_ = NULL;
#line 81 "rygel-media-export-root-container.vala"
	file = g_file_new_for_commandline_arg (uri);
#line 82 "rygel-media-export-root-container.vala"
	id = rygel_media_export_media_cache_get_id (file);
#line 84 "rygel-media-export-root-container.vala"
	rygel_media_export_harvester_cancel (self->priv->harvester, file);
#line 421 "rygel-media-export-root-container.c"
	{
#line 86 "rygel-media-export-root-container.vala"
		rygel_media_export_media_cache_remove_by_id (((RygelMediaExportDBContainer*) self)->media_db, id, &_inner_error_);
#line 425 "rygel-media-export-root-container.c"
		if (_inner_error_ != NULL) {
			goto __catch24_g_error;
		}
	}
	goto __finally24;
	__catch24_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
#line 88 "rygel-media-export-root-container.vala"
			g_warning (_ ("Failed to remove URI: %s"), _error_->message);
#line 439 "rygel-media-export-root-container.c"
			_g_error_free0 (_error_);
		}
	}
	__finally24:
	if (_inner_error_ != NULL) {
		_g_free0 (id);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (id);
	_g_object_unref0 (file);
}


#line 92 "rygel-media-export-root-container.vala"
char** rygel_media_export_root_container_get_dynamic_uris (RygelMediaExportRootContainer* self, int* result_length1) {
#line 458 "rygel-media-export-root-container.c"
	char** result = NULL;
	GError * _inner_error_;
	char** _tmp2_;
#line 92 "rygel-media-export-root-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 464 "rygel-media-export-root-container.c"
	_inner_error_ = NULL;
	{
		GeeList* uris;
		gint _tmp0_;
		char** _tmp1_;
#line 94 "rygel-media-export-root-container.vala"
		uris = rygel_media_export_media_cache_get_flagged_uris (((RygelMediaExportDBContainer*) self)->media_db, "DBUS", &_inner_error_);
#line 472 "rygel-media-export-root-container.c"
		if (_inner_error_ != NULL) {
			goto __catch25_g_error;
		}
		result = (_tmp1_ = gee_collection_to_array ((GeeCollection*) uris, &_tmp0_), *result_length1 = _tmp0_, _tmp1_);
		_g_object_unref0 (uris);
#line 96 "rygel-media-export-root-container.vala"
		return result;
#line 480 "rygel-media-export-root-container.c"
		_g_object_unref0 (uris);
	}
	goto __finally25;
	__catch25_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (_error_);
		}
	}
	__finally25:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = (_tmp2_ = g_new0 (char*, 0 + 1), *result_length1 = 0, _tmp2_);
#line 99 "rygel-media-export-root-container.vala"
	return result;
#line 502 "rygel-media-export-root-container.c"
}


static void rygel_media_export_root_container_real_find_object_data_free (gpointer _data) {
	RygelMediaExportRootContainerFindObjectData* data;
	data = _data;
	_g_free0 (data->id);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (RygelMediaExportRootContainerFindObjectData, data);
}


static void rygel_media_export_root_container_real_find_object (RygelMediaContainer* base, const char* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportRootContainer * self;
	RygelMediaExportRootContainerFindObjectData* _data_;
	self = (RygelMediaExportRootContainer*) base;
	_data_ = g_slice_new0 (RygelMediaExportRootContainerFindObjectData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_export_root_container_real_find_object);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_export_root_container_real_find_object_data_free);
	_data_->self = g_object_ref (self);
	_data_->id = g_strdup (id);
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_media_export_root_container_real_find_object_co (_data_);
}


static RygelMediaObject* rygel_media_export_root_container_real_find_object_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelMediaExportRootContainerFindObjectData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_media_export_root_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaExportRootContainerFindObjectData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_media_export_root_container_real_find_object_co (data);
}


static gboolean rygel_media_export_root_container_real_find_object_co (RygelMediaExportRootContainerFindObjectData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->_state_ = 3;
		RYGEL_MEDIA_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->find_object ((RygelMediaContainer*) RYGEL_MEDIA_EXPORT_DB_CONTAINER (data->self), data->id, data->cancellable, rygel_media_export_root_container_find_object_ready, data);
		return FALSE;
		_state_3:
		data->object = RYGEL_MEDIA_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->find_object_finish ((RygelMediaContainer*) RYGEL_MEDIA_EXPORT_DB_CONTAINER (data->self), data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
#line 109 "rygel-media-export-root-container.vala"
		if (data->object == NULL) {
#line 109 "rygel-media-export-root-container.vala"
			data->_tmp0_ = g_str_has_prefix (data->id, RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX);
#line 585 "rygel-media-export-root-container.c"
		} else {
#line 109 "rygel-media-export-root-container.vala"
			data->_tmp0_ = FALSE;
#line 589 "rygel-media-export-root-container.c"
		}
#line 109 "rygel-media-export-root-container.vala"
		if (data->_tmp0_) {
#line 593 "rygel-media-export-root-container.c"
			data->container = rygel_media_export_query_container_new (((RygelMediaExportDBContainer*) data->self)->media_db, data->id, "");
#line 111 "rygel-media-export-root-container.vala"
			((RygelMediaObject*) data->container)->parent = (RygelMediaContainer*) data->self;
#line 597 "rygel-media-export-root-container.c"
			data->result = (RygelMediaObject*) data->container;
			_g_object_unref0 (data->object);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			_g_object_unref0 (data->container);
		}
		data->result = data->object;
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		_g_object_unref0 (data->object);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void rygel_media_export_root_container_real_search_data_free (gpointer _data) {
	RygelMediaExportRootContainerSearchData* data;
	data = _data;
	_rygel_search_expression_unref0 (data->expression);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (RygelMediaExportRootContainerSearchData, data);
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
	return self ? rygel_search_expression_ref (self) : NULL;
}


static void rygel_media_export_root_container_real_search (RygelMediaContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportRootContainer * self;
	RygelMediaExportRootContainerSearchData* _data_;
	self = (RygelMediaExportRootContainer*) base;
	_data_ = g_slice_new0 (RygelMediaExportRootContainerSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_export_root_container_real_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_export_root_container_real_search_data_free);
	_data_->self = g_object_ref (self);
	_data_->expression = _rygel_search_expression_ref0 (expression);
	_data_->offset = offset;
	_data_->max_count = max_count;
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_media_export_root_container_real_search_co (_data_);
}


static RygelMediaObjects* rygel_media_export_root_container_real_search_finish (RygelMediaContainer* base, GAsyncResult* _res_, guint* total_matches, GError** error) {
	RygelMediaObjects* result;
	RygelMediaExportRootContainerSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	*total_matches = _data_->total_matches;
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_media_export_root_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaExportRootContainerSearchData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_media_export_root_container_real_search_co (data);
}


static gboolean rygel_media_export_root_container_real_search_co (RygelMediaExportRootContainerSearchData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		case 6:
		goto _state_6;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
#line 125 "rygel-media-export-root-container.vala"
		if (data->expression == NULL) {
#line 706 "rygel-media-export-root-container.c"
			data->_state_ = 4;
			RYGEL_MEDIA_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->search ((RygelMediaContainer*) RYGEL_MEDIA_EXPORT_DB_CONTAINER (data->self), data->expression, data->offset, data->max_count, data->cancellable, rygel_media_export_root_container_search_ready, data);
			return FALSE;
			_state_4:
			data->_tmp0_ = RYGEL_MEDIA_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->search_finish ((RygelMediaContainer*) RYGEL_MEDIA_EXPORT_DB_CONTAINER (data->self), data->_res_, &data->total_matches, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
			data->result = data->_tmp0_;
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		data->query_container = NULL;
		data->upnp_class = NULL;
#line 137 "rygel-media-export-root-container.vala"
		if (RYGEL_IS_RELATIONAL_EXPRESSION (data->expression)) {
#line 740 "rygel-media-export-root-container.c"
			data->relational_expression = _rygel_search_expression_ref0 ((data->_tmp1_ = data->expression, RYGEL_IS_RELATIONAL_EXPRESSION (data->_tmp1_) ? ((RygelRelationalExpression*) data->_tmp1_) : NULL));
#line 140 "rygel-media-export-root-container.vala"
			data->query_container = (data->_tmp2_ = (RygelMediaContainer*) rygel_media_export_root_container_search_to_virtual_container (data->self, data->relational_expression), _g_object_unref0 (data->query_container), data->_tmp2_);
#line 142 "rygel-media-export-root-container.vala"
			data->upnp_class = (data->_tmp3_ = g_strdup ((const char*) ((RygelSearchExpression*) data->relational_expression)->operand2), _g_free0 (data->upnp_class), data->_tmp3_);
#line 746 "rygel-media-export-root-container.c"
			_rygel_search_expression_unref0 (data->relational_expression);
		} else {
			data->_tmp4_ = NULL;
#line 143 "rygel-media-export-root-container.vala"
			if ((data->_tmp5_ = rygel_media_export_root_container_is_search_in_virtual_container (data->self, data->expression, &data->_tmp4_), data->query_container = (data->_tmp6_ = data->_tmp4_, _g_object_unref0 (data->query_container), data->_tmp6_), data->_tmp5_)) {
#line 752 "rygel-media-export-root-container.c"
			}
		}
#line 148 "rygel-media-export-root-container.vala"
		if (data->query_container != NULL) {
#line 757 "rygel-media-export-root-container.c"
			data->_state_ = 5;
			rygel_media_container_get_children (data->query_container, data->offset, data->max_count, data->cancellable, rygel_media_export_root_container_search_ready, data);
			return FALSE;
			_state_5:
			data->_tmp7_ = rygel_media_container_get_children_finish (data->query_container, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_g_free0 (data->upnp_class);
				_g_object_unref0 (data->query_container);
				_g_object_unref0 (data->list);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
#line 149 "rygel-media-export-root-container.vala"
			data->list = (data->_tmp8_ = data->_tmp7_, _g_object_unref0 (data->list), data->_tmp8_);
#line 152 "rygel-media-export-root-container.vala"
			data->total_matches = (guint) data->query_container->child_count;
#line 154 "rygel-media-export-root-container.vala"
			if (data->upnp_class != NULL) {
#line 785 "rygel-media-export-root-container.c"
				{
					data->_object_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) data->list);
#line 155 "rygel-media-export-root-container.vala"
					while (TRUE) {
#line 155 "rygel-media-export-root-container.vala"
						if (!gee_iterator_next (data->_object_it)) {
#line 155 "rygel-media-export-root-container.vala"
							break;
#line 794 "rygel-media-export-root-container.c"
						}
						data->object = (RygelMediaObject*) gee_iterator_get (data->_object_it);
#line 156 "rygel-media-export-root-container.vala"
						data->object->upnp_class = (data->_tmp9_ = g_strdup (data->upnp_class), _g_free0 (data->object->upnp_class), data->_tmp9_);
#line 799 "rygel-media-export-root-container.c"
						_g_object_unref0 (data->object);
					}
					_g_object_unref0 (data->_object_it);
				}
			}
			data->result = data->list;
			_g_free0 (data->upnp_class);
			_g_object_unref0 (data->query_container);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		} else {
			data->_state_ = 6;
			RYGEL_MEDIA_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->search ((RygelMediaContainer*) RYGEL_MEDIA_EXPORT_DB_CONTAINER (data->self), data->expression, data->offset, data->max_count, data->cancellable, rygel_media_export_root_container_search_ready, data);
			return FALSE;
			_state_6:
			data->_tmp10_ = RYGEL_MEDIA_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->search_finish ((RygelMediaContainer*) RYGEL_MEDIA_EXPORT_DB_CONTAINER (data->self), data->_res_, &data->total_matches, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_g_free0 (data->upnp_class);
				_g_object_unref0 (data->query_container);
				_g_object_unref0 (data->list);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
			data->result = data->_tmp10_;
			_g_free0 (data->upnp_class);
			_g_object_unref0 (data->query_container);
			_g_object_unref0 (data->list);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		_g_free0 (data->upnp_class);
		_g_object_unref0 (data->query_container);
		_g_object_unref0 (data->list);
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


#line 172 "rygel-media-export-root-container.vala"
static GeeArrayList* rygel_media_export_root_container_get_uris (RygelMediaExportRootContainer* self) {
#line 871 "rygel-media-export-root-container.c"
	GeeArrayList* result = NULL;
	GError * _inner_error_;
	GeeArrayList* uris;
	RygelMetaConfig* config;
#line 172 "rygel-media-export-root-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 878 "rygel-media-export-root-container.c"
	_inner_error_ = NULL;
	uris = NULL;
#line 175 "rygel-media-export-root-container.vala"
	config = rygel_meta_config_get_default ();
#line 883 "rygel-media-export-root-container.c"
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
#line 178 "rygel-media-export-root-container.vala"
		_tmp0_ = rygel_configuration_get_string_list ((RygelConfiguration*) config, "MediaExport", "uris", &_inner_error_);
#line 889 "rygel-media-export-root-container.c"
		if (_inner_error_ != NULL) {
			goto __catch26_g_error;
		}
#line 178 "rygel-media-export-root-container.vala"
		uris = (_tmp1_ = _tmp0_, _g_object_unref0 (uris), _tmp1_);
#line 895 "rygel-media-export-root-container.c"
	}
	goto __finally26;
	__catch26_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			GeeArrayList* _tmp2_;
#line 180 "rygel-media-export-root-container.vala"
			uris = (_tmp2_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL), _g_object_unref0 (uris), _tmp2_);
#line 907 "rygel-media-export-root-container.c"
			_g_error_free0 (_error_);
		}
	}
	__finally26:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (config);
		_g_object_unref0 (uris);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	{
		GeeList* _tmp3_;
		GeeList* _tmp4_;
#line 184 "rygel-media-export-root-container.vala"
		_tmp3_ = rygel_media_export_media_cache_get_flagged_uris (((RygelMediaExportDBContainer*) self)->media_db, "DBUS", &_inner_error_);
#line 924 "rygel-media-export-root-container.c"
		if (_inner_error_ != NULL) {
			goto __catch27_g_error;
		}
#line 184 "rygel-media-export-root-container.vala"
		gee_abstract_collection_add_all ((GeeAbstractCollection*) uris, (GeeCollection*) (_tmp4_ = _tmp3_));
#line 930 "rygel-media-export-root-container.c"
		_g_object_unref0 (_tmp4_);
	}
	goto __finally27;
	__catch27_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (_error_);
		}
	}
	__finally27:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (config);
		_g_object_unref0 (uris);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = uris;
	_g_object_unref0 (config);
#line 187 "rygel-media-export-root-container.vala"
	return result;
#line 955 "rygel-media-export-root-container.c"
}


#line 190 "rygel-media-export-root-container.vala"
static RygelMediaExportQueryContainer* rygel_media_export_root_container_search_to_virtual_container (RygelMediaExportRootContainer* self, RygelRelationalExpression* expression) {
#line 961 "rygel-media-export-root-container.c"
	RygelMediaExportQueryContainer* result = NULL;
	gboolean _tmp0_ = FALSE;
#line 190 "rygel-media-export-root-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 190 "rygel-media-export-root-container.vala"
	g_return_val_if_fail (expression != NULL, NULL);
#line 192 "rygel-media-export-root-container.vala"
	if (_vala_strcmp0 ((const char*) ((RygelSearchExpression*) expression)->operand1, "upnp:class") == 0) {
#line 193 "rygel-media-export-root-container.vala"
		_tmp0_ = GPOINTER_TO_INT (((RygelSearchExpression*) expression)->op) == GUPNP_SEARCH_CRITERIA_OP_EQ;
#line 972 "rygel-media-export-root-container.c"
	} else {
#line 192 "rygel-media-export-root-container.vala"
		_tmp0_ = FALSE;
#line 976 "rygel-media-export-root-container.c"
	}
#line 192 "rygel-media-export-root-container.vala"
	if (_tmp0_) {
#line 980 "rygel-media-export-root-container.c"
		GQuark _tmp2_;
		const char* _tmp1_;
		static GQuark _tmp2__label0 = 0;
		static GQuark _tmp2__label1 = 0;
		_tmp1_ = (const char*) ((RygelSearchExpression*) expression)->operand2;
		_tmp2_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
		if (_tmp2_ == ((0 != _tmp2__label0) ? _tmp2__label0 : (_tmp2__label0 = g_quark_from_static_string ("object.container.album.musicAlbum"))))
		switch (0) {
			default:
			{
				char* id;
#line 196 "rygel-media-export-root-container.vala"
				id = g_strdup ("virtual-container:upnp:album,?");
#line 197 "rygel-media-export-root-container.vala"
				rygel_media_export_query_container_register_id (&id);
#line 996 "rygel-media-export-root-container.c"
				result = rygel_media_export_query_container_new (((RygelMediaExportDBContainer*) self)->media_db, id, _ ("Albums"));
				_g_free0 (id);
#line 199 "rygel-media-export-root-container.vala"
				return result;
#line 1001 "rygel-media-export-root-container.c"
			}
		} else if (_tmp2_ == ((0 != _tmp2__label1) ? _tmp2__label1 : (_tmp2__label1 = g_quark_from_static_string ("object.container.person.musicArtist"))))
		switch (0) {
			default:
			{
				char* id;
#line 204 "rygel-media-export-root-container.vala"
				id = g_strdup ("virtual-container:dc:creator,?,upnp:album,?");
#line 205 "rygel-media-export-root-container.vala"
				rygel_media_export_query_container_register_id (&id);
#line 1012 "rygel-media-export-root-container.c"
				result = rygel_media_export_query_container_new (((RygelMediaExportDBContainer*) self)->media_db, id, _ ("Artists"));
				_g_free0 (id);
#line 207 "rygel-media-export-root-container.vala"
				return result;
#line 1017 "rygel-media-export-root-container.c"
			}
		} else
		switch (0) {
			default:
			{
				result = NULL;
#line 211 "rygel-media-export-root-container.vala"
				return result;
#line 1026 "rygel-media-export-root-container.c"
			}
		}
	}
	result = NULL;
#line 215 "rygel-media-export-root-container.vala"
	return result;
#line 1033 "rygel-media-export-root-container.c"
}


#line 1156 "glib-2.0.vapi"
static char* string_replace (const char* self, const char* old, const char* replacement) {
#line 1039 "rygel-media-export-root-container.c"
	char* result = NULL;
	GError * _inner_error_;
#line 1156 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1156 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1156 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1048 "rygel-media-export-root-container.c"
	_inner_error_ = NULL;
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
#line 1158 "glib-2.0.vapi"
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
#line 1057 "rygel-media-export-root-container.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch28_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 1159 "glib-2.0.vapi"
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
#line 1068 "rygel-media-export-root-container.c"
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch28_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
#line 1159 "glib-2.0.vapi"
		return result;
#line 1083 "rygel-media-export-root-container.c"
	}
	goto __finally28;
	__catch28_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 1161 "glib-2.0.vapi"
			g_assert_not_reached ();
#line 1094 "rygel-media-export-root-container.c"
			_g_error_free0 (e);
		}
	}
	__finally28:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


/**
     * Check if a passed search expression is a simple search in a virtual
     * container.
     *
     * @param expression the expression to check
     * @param new_id contains the id of the virtual container constructed from
     *               the search
     * @param upnp_class contains the class of the container the search was
     *                   looking in
     * @return true if it was a search in virtual container, false otherwise.
     * @note This works single level only. Enough to satisfy Xbox music
     *       browsing, but may need refinement
     */
#line 231 "rygel-media-export-root-container.vala"
static gboolean rygel_media_export_root_container_is_search_in_virtual_container (RygelMediaExportRootContainer* self, RygelSearchExpression* expression, RygelMediaContainer** container) {
#line 1122 "rygel-media-export-root-container.c"
	gboolean result = FALSE;
	RygelRelationalExpression* virtual_expression;
	RygelMediaExportQueryContainer* query_container;
	RygelSearchExpression* _tmp0_;
	RygelLogicalExpression* logical_expression;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	RygelSearchExpression* _tmp3_;
	RygelRelationalExpression* left_expression;
	RygelSearchExpression* _tmp4_;
	RygelRelationalExpression* right_expression;
	RygelMediaExportQueryContainer* _tmp5_;
	char* last_argument;
	char* escaped_detail;
	char* new_id;
	RygelMediaContainer* _tmp9_;
#line 231 "rygel-media-export-root-container.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 231 "rygel-media-export-root-container.vala"
	g_return_val_if_fail (expression != NULL, FALSE);
#line 1143 "rygel-media-export-root-container.c"
	if (container != NULL) {
		*container = NULL;
	}
#line 234 "rygel-media-export-root-container.vala"
	virtual_expression = NULL;
#line 1149 "rygel-media-export-root-container.c"
	query_container = NULL;
#line 237 "rygel-media-export-root-container.vala"
	if (!RYGEL_IS_LOGICAL_EXPRESSION (expression)) {
#line 1153 "rygel-media-export-root-container.c"
		result = FALSE;
		_g_object_unref0 (query_container);
		_rygel_search_expression_unref0 (virtual_expression);
#line 238 "rygel-media-export-root-container.vala"
		return result;
#line 1159 "rygel-media-export-root-container.c"
	}
#line 241 "rygel-media-export-root-container.vala"
	logical_expression = _rygel_search_expression_ref0 ((_tmp0_ = expression, RYGEL_IS_LOGICAL_EXPRESSION (_tmp0_) ? ((RygelLogicalExpression*) _tmp0_) : NULL));
#line 243 "rygel-media-export-root-container.vala"
	if (RYGEL_IS_RELATIONAL_EXPRESSION ((RygelSearchExpression*) ((RygelSearchExpression*) logical_expression)->operand1)) {
#line 244 "rygel-media-export-root-container.vala"
		_tmp2_ = RYGEL_IS_RELATIONAL_EXPRESSION ((RygelSearchExpression*) ((RygelSearchExpression*) logical_expression)->operand2);
#line 1167 "rygel-media-export-root-container.c"
	} else {
#line 243 "rygel-media-export-root-container.vala"
		_tmp2_ = FALSE;
#line 1171 "rygel-media-export-root-container.c"
	}
#line 243 "rygel-media-export-root-container.vala"
	if (_tmp2_) {
#line 245 "rygel-media-export-root-container.vala"
		_tmp1_ = GPOINTER_TO_INT (((RygelSearchExpression*) logical_expression)->op) == RYGEL_LOGICAL_OPERATOR_AND;
#line 1177 "rygel-media-export-root-container.c"
	} else {
#line 243 "rygel-media-export-root-container.vala"
		_tmp1_ = FALSE;
#line 1181 "rygel-media-export-root-container.c"
	}
#line 243 "rygel-media-export-root-container.vala"
	if (!_tmp1_) {
#line 1185 "rygel-media-export-root-container.c"
		result = FALSE;
		_rygel_search_expression_unref0 (logical_expression);
		_g_object_unref0 (query_container);
		_rygel_search_expression_unref0 (virtual_expression);
#line 247 "rygel-media-export-root-container.vala"
		return result;
#line 1192 "rygel-media-export-root-container.c"
	}
#line 250 "rygel-media-export-root-container.vala"
	left_expression = _rygel_search_expression_ref0 ((_tmp3_ = (RygelSearchExpression*) ((RygelSearchExpression*) logical_expression)->operand1, RYGEL_IS_RELATIONAL_EXPRESSION (_tmp3_) ? ((RygelRelationalExpression*) _tmp3_) : NULL));
#line 251 "rygel-media-export-root-container.vala"
	right_expression = _rygel_search_expression_ref0 ((_tmp4_ = (RygelSearchExpression*) ((RygelSearchExpression*) logical_expression)->operand2, RYGEL_IS_RELATIONAL_EXPRESSION (_tmp4_) ? ((RygelRelationalExpression*) _tmp4_) : NULL));
#line 253 "rygel-media-export-root-container.vala"
	query_container = (_tmp5_ = rygel_media_export_root_container_search_to_virtual_container (self, left_expression), _g_object_unref0 (query_container), _tmp5_);
#line 254 "rygel-media-export-root-container.vala"
	if (query_container == NULL) {
#line 1202 "rygel-media-export-root-container.c"
		RygelMediaExportQueryContainer* _tmp6_;
#line 255 "rygel-media-export-root-container.vala"
		query_container = (_tmp6_ = rygel_media_export_root_container_search_to_virtual_container (self, right_expression), _g_object_unref0 (query_container), _tmp6_);
#line 256 "rygel-media-export-root-container.vala"
		if (query_container != NULL) {
#line 1208 "rygel-media-export-root-container.c"
			RygelRelationalExpression* _tmp7_;
#line 257 "rygel-media-export-root-container.vala"
			virtual_expression = (_tmp7_ = _rygel_search_expression_ref0 (left_expression), _rygel_search_expression_unref0 (virtual_expression), _tmp7_);
#line 1212 "rygel-media-export-root-container.c"
		} else {
			result = FALSE;
			_rygel_search_expression_unref0 (right_expression);
			_rygel_search_expression_unref0 (left_expression);
			_rygel_search_expression_unref0 (logical_expression);
			_g_object_unref0 (query_container);
			_rygel_search_expression_unref0 (virtual_expression);
#line 259 "rygel-media-export-root-container.vala"
			return result;
#line 1222 "rygel-media-export-root-container.c"
		}
	} else {
		RygelRelationalExpression* _tmp8_;
#line 262 "rygel-media-export-root-container.vala"
		virtual_expression = (_tmp8_ = _rygel_search_expression_ref0 (right_expression), _rygel_search_expression_unref0 (virtual_expression), _tmp8_);
#line 1228 "rygel-media-export-root-container.c"
	}
#line 265 "rygel-media-export-root-container.vala"
	last_argument = string_replace (query_container->plaintext_id, RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, "");
#line 269 "rygel-media-export-root-container.vala"
	escaped_detail = g_uri_escape_string ((const char*) ((RygelSearchExpression*) virtual_expression)->operand2, "", TRUE);
#line 272 "rygel-media-export-root-container.vala"
	new_id = g_strdup_printf ("%s%s,%s,%s", RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, (const char*) ((RygelSearchExpression*) virtual_expression)->operand1, escaped_detail, last_argument);
#line 277 "rygel-media-export-root-container.vala"
	rygel_media_export_query_container_register_id (&new_id);
#line 278 "rygel-media-export-root-container.vala"
	*container = (_tmp9_ = (RygelMediaContainer*) rygel_media_export_query_container_new (((RygelMediaExportDBContainer*) self)->media_db, new_id, ""), _g_object_unref0 (*container), _tmp9_);
#line 1240 "rygel-media-export-root-container.c"
	result = TRUE;
	_g_free0 (new_id);
	_g_free0 (escaped_detail);
	_g_free0 (last_argument);
	_rygel_search_expression_unref0 (right_expression);
	_rygel_search_expression_unref0 (left_expression);
	_rygel_search_expression_unref0 (logical_expression);
	_g_object_unref0 (query_container);
	_rygel_search_expression_unref0 (virtual_expression);
#line 280 "rygel-media-export-root-container.vala"
	return result;
#line 1252 "rygel-media-export-root-container.c"
}


/**
     * Create a new root container.
     */
#line 287 "rygel-media-export-root-container.vala"
static RygelMediaExportRootContainer* rygel_media_export_root_container_construct (GType object_type, GError** error) {
#line 1261 "rygel-media-export-root-container.c"
	GError * _inner_error_;
	RygelMediaExportRootContainer * self;
	RygelMediaExportMediaCache* db;
	GCancellable* _tmp0_;
	RygelMediaExportHarvester* _tmp1_;
	GeeArrayList* ids;
	GeeArrayList* uris;
	_inner_error_ = NULL;
#line 288 "rygel-media-export-root-container.vala"
	db = rygel_media_export_media_cache_get_default (&_inner_error_);
#line 1272 "rygel-media-export-root-container.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
#line 290 "rygel-media-export-root-container.vala"
	self = (RygelMediaExportRootContainer*) rygel_media_export_db_container_construct (object_type, db, "0", "MediaExportRoot");
#line 292 "rygel-media-export-root-container.vala"
	self->priv->cancellable = (_tmp0_ = g_cancellable_new (), _g_object_unref0 (self->priv->cancellable), _tmp0_);
#line 293 "rygel-media-export-root-container.vala"
	self->priv->harvester = (_tmp1_ = rygel_media_export_harvester_new (self->priv->cancellable), _g_object_unref0 (self->priv->harvester), _tmp1_);
#line 1284 "rygel-media-export-root-container.c"
	{
		RygelMediaExportDBusService* _tmp2_;
		RygelMediaExportDBusService* _tmp3_;
#line 296 "rygel-media-export-root-container.vala"
		_tmp2_ = rygel_media_export_dbus_service_new (self, &_inner_error_);
#line 1290 "rygel-media-export-root-container.c"
		if (_inner_error_ != NULL) {
			goto __catch29_g_error;
		}
#line 296 "rygel-media-export-root-container.vala"
		self->priv->service = (_tmp3_ = _tmp2_, _g_object_unref0 (self->priv->service), _tmp3_);
#line 1296 "rygel-media-export-root-container.c"
	}
	goto __finally29;
	__catch29_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
#line 298 "rygel-media-export-root-container.vala"
			g_warning (_ ("Failed to create MediaExport DBus service: %s"), err->message);
#line 1307 "rygel-media-export-root-container.c"
			_g_error_free0 (err);
		}
	}
	__finally29:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (db);
		_g_object_unref0 (self);
		return NULL;
	}
	{
#line 303 "rygel-media-export-root-container.vala"
		rygel_media_export_media_cache_save_container (((RygelMediaExportDBContainer*) self)->media_db, (RygelMediaContainer*) self, &_inner_error_);
#line 1321 "rygel-media-export-root-container.c"
		if (_inner_error_ != NULL) {
			goto __catch30_g_error;
		}
	}
	goto __finally30;
	__catch30_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (_error_);
		}
	}
	__finally30:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (db);
		_g_object_unref0 (self);
		return NULL;
	}
	{
		RygelMediaContainer* _tmp4_;
		char* _tmp5_;
#line 307 "rygel-media-export-root-container.vala"
		self->priv->filesystem_container = (_tmp4_ = (RygelMediaContainer*) rygel_null_container_new (), _g_object_unref0 (self->priv->filesystem_container), _tmp4_);
#line 308 "rygel-media-export-root-container.vala"
		((RygelMediaObject*) self->priv->filesystem_container)->parent = (RygelMediaContainer*) self;
#line 309 "rygel-media-export-root-container.vala"
		rygel_media_object_set_title ((RygelMediaObject*) self->priv->filesystem_container, RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_NAME);
#line 310 "rygel-media-export-root-container.vala"
		((RygelMediaObject*) self->priv->filesystem_container)->id = (_tmp5_ = g_strdup (RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID), _g_free0 (((RygelMediaObject*) self->priv->filesystem_container)->id), _tmp5_);
#line 311 "rygel-media-export-root-container.vala"
		rygel_media_export_media_cache_save_container (((RygelMediaExportDBContainer*) self)->media_db, self->priv->filesystem_container, &_inner_error_);
#line 1356 "rygel-media-export-root-container.c"
		if (_inner_error_ != NULL) {
			goto __catch31_g_error;
		}
	}
	goto __finally31;
	__catch31_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (_error_);
		}
	}
	__finally31:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (db);
		_g_object_unref0 (self);
		return NULL;
	}
	ids = NULL;
	{
		GeeArrayList* _tmp6_;
		GeeArrayList* _tmp7_;
#line 316 "rygel-media-export-root-container.vala"
		_tmp6_ = rygel_media_export_media_cache_get_child_ids (((RygelMediaExportDBContainer*) self)->media_db, RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID, &_inner_error_);
#line 1384 "rygel-media-export-root-container.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch32_rygel_media_export_database_error;
			}
			_g_object_unref0 (ids);
			_g_object_unref0 (db);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 316 "rygel-media-export-root-container.vala"
		ids = (_tmp7_ = _tmp6_, _g_object_unref0 (ids), _tmp7_);
#line 1397 "rygel-media-export-root-container.c"
	}
	goto __finally32;
	__catch32_rygel_media_export_database_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			GeeArrayList* _tmp8_;
#line 318 "rygel-media-export-root-container.vala"
			ids = (_tmp8_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL), _g_object_unref0 (ids), _tmp8_);
#line 1409 "rygel-media-export-root-container.c"
			_g_error_free0 (e);
		}
	}
	__finally32:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (ids);
		_g_object_unref0 (db);
		_g_object_unref0 (self);
		return NULL;
	}
#line 321 "rygel-media-export-root-container.vala"
	uris = rygel_media_export_root_container_get_uris (self);
#line 1423 "rygel-media-export-root-container.c"
	{
		GeeIterator* _uri_it;
#line 322 "rygel-media-export-root-container.vala"
		_uri_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) uris);
#line 322 "rygel-media-export-root-container.vala"
		while (TRUE) {
#line 1430 "rygel-media-export-root-container.c"
			char* uri;
			GFile* file;
#line 322 "rygel-media-export-root-container.vala"
			if (!gee_iterator_next (_uri_it)) {
#line 322 "rygel-media-export-root-container.vala"
				break;
#line 1437 "rygel-media-export-root-container.c"
			}
#line 322 "rygel-media-export-root-container.vala"
			uri = (char*) gee_iterator_get (_uri_it);
#line 323 "rygel-media-export-root-container.vala"
			file = g_file_new_for_commandline_arg (uri);
#line 324 "rygel-media-export-root-container.vala"
			if (g_file_query_exists (file, NULL)) {
#line 1445 "rygel-media-export-root-container.c"
				char* _tmp9_;
#line 325 "rygel-media-export-root-container.vala"
				gee_abstract_collection_remove ((GeeAbstractCollection*) ids, _tmp9_ = rygel_media_export_media_cache_get_id (file));
#line 1449 "rygel-media-export-root-container.c"
				_g_free0 (_tmp9_);
#line 326 "rygel-media-export-root-container.vala"
				rygel_media_export_harvester_schedule (self->priv->harvester, file, self->priv->filesystem_container, NULL);
#line 1453 "rygel-media-export-root-container.c"
			}
			_g_object_unref0 (file);
			_g_free0 (uri);
		}
		_g_object_unref0 (_uri_it);
	}
	{
		GeeIterator* _id_it;
#line 331 "rygel-media-export-root-container.vala"
		_id_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) ids);
#line 331 "rygel-media-export-root-container.vala"
		while (TRUE) {
#line 1466 "rygel-media-export-root-container.c"
			char* id;
#line 331 "rygel-media-export-root-container.vala"
			if (!gee_iterator_next (_id_it)) {
#line 331 "rygel-media-export-root-container.vala"
				break;
#line 1472 "rygel-media-export-root-container.c"
			}
#line 331 "rygel-media-export-root-container.vala"
			id = (char*) gee_iterator_get (_id_it);
#line 332 "rygel-media-export-root-container.vala"
			g_debug (_ ("ID %s no longer in config, deleting..."), id);
#line 1478 "rygel-media-export-root-container.c"
			{
#line 334 "rygel-media-export-root-container.vala"
				rygel_media_export_media_cache_remove_by_id (((RygelMediaExportDBContainer*) self)->media_db, id, &_inner_error_);
#line 1482 "rygel-media-export-root-container.c"
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
						goto __catch33_rygel_media_export_database_error;
					}
					_g_free0 (id);
					_g_object_unref0 (_id_it);
					_g_object_unref0 (uris);
					_g_object_unref0 (ids);
					_g_object_unref0 (db);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			goto __finally33;
			__catch33_rygel_media_export_database_error:
			{
				GError * _error_;
				_error_ = _inner_error_;
				_inner_error_ = NULL;
				{
#line 336 "rygel-media-export-root-container.vala"
					g_warning (_ ("Failed to remove entry: %s"), _error_->message);
#line 1506 "rygel-media-export-root-container.c"
					_g_error_free0 (_error_);
				}
			}
			__finally33:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (id);
				_g_object_unref0 (_id_it);
				_g_object_unref0 (uris);
				_g_object_unref0 (ids);
				_g_object_unref0 (db);
				_g_object_unref0 (self);
				return NULL;
			}
			_g_free0 (id);
		}
		_g_object_unref0 (_id_it);
	}
#line 340 "rygel-media-export-root-container.vala"
	rygel_media_export_root_container_add_default_virtual_folders (self);
#line 342 "rygel-media-export-root-container.vala"
	rygel_media_container_updated ((RygelMediaContainer*) self);
#line 1529 "rygel-media-export-root-container.c"
	_g_object_unref0 (uris);
	_g_object_unref0 (ids);
	_g_object_unref0 (db);
	return self;
}


#line 287 "rygel-media-export-root-container.vala"
static RygelMediaExportRootContainer* rygel_media_export_root_container_new (GError** error) {
#line 287 "rygel-media-export-root-container.vala"
	return rygel_media_export_root_container_construct (RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, error);
#line 1541 "rygel-media-export-root-container.c"
}


#line 345 "rygel-media-export-root-container.vala"
static void rygel_media_export_root_container_add_default_virtual_folders (RygelMediaExportRootContainer* self) {
#line 1547 "rygel-media-export-root-container.c"
	GError * _inner_error_;
#line 345 "rygel-media-export-root-container.vala"
	g_return_if_fail (self != NULL);
#line 1551 "rygel-media-export-root-container.c"
	_inner_error_ = NULL;
	{
#line 347 "rygel-media-export-root-container.vala"
		rygel_media_export_root_container_add_virtual_containers_for_class (self, _ ("Music"), "object.item.audioItem.musicTrack", virtual_folders_music, G_N_ELEMENTS (virtual_folders_music), &_inner_error_);
#line 1556 "rygel-media-export-root-container.c"
		if (_inner_error_ != NULL) {
			goto __catch34_g_error;
		}
#line 350 "rygel-media-export-root-container.vala"
		rygel_media_export_root_container_add_virtual_containers_for_class (self, _ ("Pictures"), "object.item.imageItem.photo", NULL, 0, &_inner_error_);
#line 1562 "rygel-media-export-root-container.c"
		if (_inner_error_ != NULL) {
			goto __catch34_g_error;
		}
#line 352 "rygel-media-export-root-container.vala"
		rygel_media_export_root_container_add_virtual_containers_for_class (self, _ ("Videos"), "object.item.videoItem", NULL, 0, &_inner_error_);
#line 1568 "rygel-media-export-root-container.c"
		if (_inner_error_ != NULL) {
			goto __catch34_g_error;
		}
	}
	goto __finally34;
	__catch34_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (_error_);
		}
	}
	__finally34:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	;
}


#line 1101 "glib-2.0.vapi"
static char* string_slice (const char* self, glong start, glong end) {
#line 1595 "rygel-media-export-root-container.c"
	char* result = NULL;
	glong string_length;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const char* start_string;
#line 1101 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1102 "glib-2.0.vapi"
	string_length = g_utf8_strlen (self, -1);
#line 1103 "glib-2.0.vapi"
	if (start < 0) {
#line 1104 "glib-2.0.vapi"
		start = string_length + start;
#line 1609 "rygel-media-export-root-container.c"
	}
#line 1106 "glib-2.0.vapi"
	if (end < 0) {
#line 1107 "glib-2.0.vapi"
		end = string_length + end;
#line 1615 "rygel-media-export-root-container.c"
	}
#line 1109 "glib-2.0.vapi"
	if (start >= 0) {
#line 1109 "glib-2.0.vapi"
		_tmp0_ = start <= string_length;
#line 1621 "rygel-media-export-root-container.c"
	} else {
#line 1109 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 1625 "rygel-media-export-root-container.c"
	}
#line 1109 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp0_, NULL);
#line 1110 "glib-2.0.vapi"
	if (end >= 0) {
#line 1110 "glib-2.0.vapi"
		_tmp1_ = end <= string_length;
#line 1633 "rygel-media-export-root-container.c"
	} else {
#line 1110 "glib-2.0.vapi"
		_tmp1_ = FALSE;
#line 1637 "rygel-media-export-root-container.c"
	}
#line 1110 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp1_, NULL);
#line 1111 "glib-2.0.vapi"
	g_return_val_if_fail (start <= end, NULL);
#line 1112 "glib-2.0.vapi"
	start_string = g_utf8_offset_to_pointer (self, start);
#line 1645 "rygel-media-export-root-container.c"
	result = g_strndup (start_string, ((gchar*) g_utf8_offset_to_pointer (start_string, end - start)) - ((gchar*) start_string));
#line 1113 "glib-2.0.vapi"
	return result;
#line 1649 "rygel-media-export-root-container.c"
}


#line 357 "rygel-media-export-root-container.vala"
static void rygel_media_export_root_container_add_folder_definition (RygelMediaExportRootContainer* self, RygelMediaContainer* container, const char* item_class, RygelMediaExportFolderDefinition* definition, GError** error) {
#line 1655 "rygel-media-export-root-container.c"
	GError * _inner_error_;
	char* id;
	RygelMediaExportQueryContainer* query_container;
#line 357 "rygel-media-export-root-container.vala"
	g_return_if_fail (self != NULL);
#line 357 "rygel-media-export-root-container.vala"
	g_return_if_fail (container != NULL);
#line 357 "rygel-media-export-root-container.vala"
	g_return_if_fail (item_class != NULL);
#line 1665 "rygel-media-export-root-container.c"
	_inner_error_ = NULL;
#line 361 "rygel-media-export-root-container.vala"
	id = g_strdup_printf ("%supnp:class,%s,%s", RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, item_class, (*definition).definition);
#line 364 "rygel-media-export-root-container.vala"
	if (g_str_has_suffix (id, ",")) {
#line 1671 "rygel-media-export-root-container.c"
		char* _tmp0_;
#line 365 "rygel-media-export-root-container.vala"
		id = (_tmp0_ = string_slice (id, (glong) 0, (glong) (-1)), _g_free0 (id), _tmp0_);
#line 1675 "rygel-media-export-root-container.c"
	}
#line 368 "rygel-media-export-root-container.vala"
	rygel_media_export_query_container_register_id (&id);
#line 369 "rygel-media-export-root-container.vala"
	query_container = rygel_media_export_query_container_new (((RygelMediaExportDBContainer*) self)->media_db, id, (*definition).title);
#line 372 "rygel-media-export-root-container.vala"
	((RygelMediaObject*) query_container)->parent = container;
#line 373 "rygel-media-export-root-container.vala"
	rygel_media_export_media_cache_save_container (((RygelMediaExportDBContainer*) self)->media_db, (RygelMediaContainer*) query_container, &_inner_error_);
#line 1685 "rygel-media-export-root-container.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (query_container);
		_g_free0 (id);
		return;
	}
	_g_object_unref0 (query_container);
	_g_free0 (id);
}


#line 376 "rygel-media-export-root-container.vala"
static void rygel_media_export_root_container_add_virtual_containers_for_class (RygelMediaExportRootContainer* self, const char* parent, const char* item_class, RygelMediaExportFolderDefinition* definitions, int definitions_length1, GError** error) {
#line 1699 "rygel-media-export-root-container.c"
	GError * _inner_error_;
	RygelNullContainer* container;
	char* _tmp0_;
#line 376 "rygel-media-export-root-container.vala"
	g_return_if_fail (self != NULL);
#line 376 "rygel-media-export-root-container.vala"
	g_return_if_fail (parent != NULL);
#line 376 "rygel-media-export-root-container.vala"
	g_return_if_fail (item_class != NULL);
#line 1709 "rygel-media-export-root-container.c"
	_inner_error_ = NULL;
#line 381 "rygel-media-export-root-container.vala"
	container = rygel_null_container_new ();
#line 382 "rygel-media-export-root-container.vala"
	((RygelMediaObject*) container)->parent = (RygelMediaContainer*) self;
#line 383 "rygel-media-export-root-container.vala"
	rygel_media_object_set_title ((RygelMediaObject*) container, parent);
#line 384 "rygel-media-export-root-container.vala"
	((RygelMediaObject*) container)->id = (_tmp0_ = g_strconcat ("virtual-parent:", item_class, NULL), _g_free0 (((RygelMediaObject*) container)->id), _tmp0_);
#line 385 "rygel-media-export-root-container.vala"
	rygel_media_export_media_cache_save_container (((RygelMediaExportDBContainer*) self)->media_db, (RygelMediaContainer*) container, &_inner_error_);
#line 1721 "rygel-media-export-root-container.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (container);
		return;
	}
	{
		RygelMediaExportFolderDefinition* definition_collection;
		int definition_collection_length1;
		int definition_it;
#line 387 "rygel-media-export-root-container.vala"
		definition_collection = virtual_folders_default;
#line 1733 "rygel-media-export-root-container.c"
		definition_collection_length1 = G_N_ELEMENTS (virtual_folders_default);
		for (definition_it = 0; definition_it < G_N_ELEMENTS (virtual_folders_default); definition_it = definition_it + 1) {
			RygelMediaExportFolderDefinition definition;
			definition = definition_collection[definition_it];
			{
#line 388 "rygel-media-export-root-container.vala"
				rygel_media_export_root_container_add_folder_definition (self, (RygelMediaContainer*) container, item_class, &definition, &_inner_error_);
#line 1741 "rygel-media-export-root-container.c"
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (container);
					return;
				}
			}
		}
	}
#line 391 "rygel-media-export-root-container.vala"
	if (definitions != NULL) {
#line 1752 "rygel-media-export-root-container.c"
		{
			RygelMediaExportFolderDefinition* definition_collection;
			int definition_collection_length1;
			int definition_it;
#line 392 "rygel-media-export-root-container.vala"
			definition_collection = definitions;
#line 1759 "rygel-media-export-root-container.c"
			definition_collection_length1 = definitions_length1;
			for (definition_it = 0; definition_it < definitions_length1; definition_it = definition_it + 1) {
				RygelMediaExportFolderDefinition _tmp1_ = {0};
				RygelMediaExportFolderDefinition definition;
				definition = (rygel_media_export_folder_definition_copy (&definition_collection[definition_it], &_tmp1_), _tmp1_);
				{
#line 393 "rygel-media-export-root-container.vala"
					rygel_media_export_root_container_add_folder_definition (self, (RygelMediaContainer*) container, item_class, &definition, &_inner_error_);
#line 1768 "rygel-media-export-root-container.c"
					if (_inner_error_ != NULL) {
						g_propagate_error (error, _inner_error_);
						rygel_media_export_folder_definition_destroy (&definition);
						_g_object_unref0 (container);
						return;
					}
					rygel_media_export_folder_definition_destroy (&definition);
				}
			}
		}
	}
	_g_object_unref0 (container);
}


static void rygel_media_export_root_container_class_init (RygelMediaExportRootContainerClass * klass) {
	rygel_media_export_root_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaExportRootContainerPrivate));
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object = rygel_media_export_root_container_real_find_object;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object_finish = rygel_media_export_root_container_real_find_object_finish;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->search = rygel_media_export_root_container_real_search;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->search_finish = rygel_media_export_root_container_real_search_finish;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_root_container_finalize;
}


static void rygel_media_export_root_container_instance_init (RygelMediaExportRootContainer * self) {
	self->priv = RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_GET_PRIVATE (self);
}


static void rygel_media_export_root_container_finalize (GObject* obj) {
	RygelMediaExportRootContainer * self;
	self = RYGEL_MEDIA_EXPORT_ROOT_CONTAINER (obj);
	_g_object_unref0 (self->priv->service);
	_g_object_unref0 (self->priv->harvester);
	_g_object_unref0 (self->priv->cancellable);
	_g_object_unref0 (self->priv->filesystem_container);
	G_OBJECT_CLASS (rygel_media_export_root_container_parent_class)->finalize (obj);
}


/**
 * Represents the root container.
 */
GType rygel_media_export_root_container_get_type (void) {
	static volatile gsize rygel_media_export_root_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_root_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportRootContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_root_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportRootContainer), 0, (GInstanceInitFunc) rygel_media_export_root_container_instance_init, NULL };
		GType rygel_media_export_root_container_type_id;
		rygel_media_export_root_container_type_id = g_type_register_static (RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, "RygelMediaExportRootContainer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_root_container_type_id__volatile, rygel_media_export_root_container_type_id);
	}
	return rygel_media_export_root_container_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




