/* rygel-media-export-item.c generated by valac 0.9.5, the Vala compiler
 * generated from rygel-media-export-item.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008 Nokia Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gst/discoverer/gstdiscoverer.h>
#include <libgupnp-dlna/gupnp-dlna-information.h>
#include <gst/gst.h>
#include <gst/tag/tag.h>


#define RYGEL_MEDIA_EXPORT_TYPE_ITEM (rygel_media_export_item_get_type ())
#define RYGEL_MEDIA_EXPORT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_ITEM, RygelMediaExportItem))
#define RYGEL_MEDIA_EXPORT_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_ITEM, RygelMediaExportItemClass))
#define RYGEL_MEDIA_EXPORT_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_ITEM))
#define RYGEL_MEDIA_EXPORT_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_ITEM, RygelMediaExportItemClass))

typedef struct _RygelMediaExportItem RygelMediaExportItem;
typedef struct _RygelMediaExportItemClass RygelMediaExportItemClass;
typedef struct _RygelMediaExportItemPrivate RygelMediaExportItemPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER (rygel_media_export_jpeg_writer_get_type ())
#define RYGEL_MEDIA_EXPORT_JPEG_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER, RygelMediaExportJPEGWriter))
#define RYGEL_MEDIA_EXPORT_JPEG_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER, RygelMediaExportJPEGWriterClass))
#define RYGEL_MEDIA_EXPORT_IS_JPEG_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER))
#define RYGEL_MEDIA_EXPORT_IS_JPEG_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER))
#define RYGEL_MEDIA_EXPORT_JPEG_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER, RygelMediaExportJPEGWriterClass))

typedef struct _RygelMediaExportJPEGWriter RygelMediaExportJPEGWriter;
typedef struct _RygelMediaExportJPEGWriterClass RygelMediaExportJPEGWriterClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gst_structure_free0(var) ((var == NULL) ? NULL : (var = (gst_structure_free (var), NULL)))

struct _RygelMediaExportItem {
	RygelMediaItem parent_instance;
	RygelMediaExportItemPrivate * priv;
};

struct _RygelMediaExportItemClass {
	RygelMediaItemClass parent_class;
};


static gpointer rygel_media_export_item_parent_class = NULL;

GType rygel_media_export_item_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MEDIA_EXPORT_ITEM_DUMMY_PROPERTY
};
char* rygel_media_export_media_cache_get_id (GFile* file);
RygelMediaExportItem* rygel_media_export_item_new_simple (RygelMediaContainer* parent, GFile* file, const char* mime, guint64 size, guint64 mtime);
RygelMediaExportItem* rygel_media_export_item_construct_simple (GType object_type, RygelMediaContainer* parent, GFile* file, const char* mime, guint64 size, guint64 mtime);
static RygelMediaExportItem* rygel_media_export_item_new_photo (RygelMediaContainer* parent, const char* id, GFile* file, GUPnPDLNAInformation* dlna_info, GstStreamVideoInformation* video_info, const char* mime, guint64 size, guint64 mtime);
static RygelMediaExportItem* rygel_media_export_item_construct_photo (GType object_type, RygelMediaContainer* parent, const char* id, GFile* file, GUPnPDLNAInformation* dlna_info, GstStreamVideoInformation* video_info, const char* mime, guint64 size, guint64 mtime);
static RygelMediaExportItem* rygel_media_export_item_new_video (RygelMediaContainer* parent, const char* id, GFile* file, GUPnPDLNAInformation* dlna_info, GstStreamVideoInformation* video_info, GstStreamAudioInformation* audio_info, const char* mime, guint64 size, guint64 mtime);
static RygelMediaExportItem* rygel_media_export_item_construct_video (GType object_type, RygelMediaContainer* parent, const char* id, GFile* file, GUPnPDLNAInformation* dlna_info, GstStreamVideoInformation* video_info, GstStreamAudioInformation* audio_info, const char* mime, guint64 size, guint64 mtime);
static RygelMediaExportItem* rygel_media_export_item_new_audio (RygelMediaContainer* parent, const char* id, GFile* file, GUPnPDLNAInformation* dlna_info, GstStreamAudioInformation* audio_info, const char* mime, guint64 size, guint64 mtime);
static RygelMediaExportItem* rygel_media_export_item_construct_audio (GType object_type, RygelMediaContainer* parent, const char* id, GFile* file, GUPnPDLNAInformation* dlna_info, GstStreamAudioInformation* audio_info, const char* mime, guint64 size, guint64 mtime);
RygelMediaExportItem* rygel_media_export_item_create_from_info (RygelMediaContainer* parent, GFile* file, GUPnPDLNAInformation* dlna_info, const char* mime, guint64 size, guint64 mtime);
static RygelMediaExportItem* rygel_media_export_item_new (RygelMediaContainer* parent, const char* id, GFile* file, GUPnPDLNAInformation* dlna_info, const char* mime, guint64 size, guint64 mtime, const char* upnp_class);
static RygelMediaExportItem* rygel_media_export_item_construct (GType object_type, RygelMediaContainer* parent, const char* id, GFile* file, GUPnPDLNAInformation* dlna_info, const char* mime, guint64 size, guint64 mtime, const char* upnp_class);
RygelMediaExportJPEGWriter* rygel_media_export_jpeg_writer_new (GError** error);
RygelMediaExportJPEGWriter* rygel_media_export_jpeg_writer_construct (GType object_type, GError** error);
GType rygel_media_export_jpeg_writer_get_type (void) G_GNUC_CONST;
void rygel_media_export_jpeg_writer_write (RygelMediaExportJPEGWriter* self, GstBuffer* buffer, GFile* file);



#line 31 "rygel-media-export-item.vala"
RygelMediaExportItem* rygel_media_export_item_construct_simple (GType object_type, RygelMediaContainer* parent, GFile* file, const char* mime, guint64 size, guint64 mtime) {
#line 102 "rygel-media-export-item.c"
	RygelMediaExportItem * self;
	char* title;
	char* upnp_class;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
#line 31 "rygel-media-export-item.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 31 "rygel-media-export-item.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 31 "rygel-media-export-item.vala"
	g_return_val_if_fail (mime != NULL, NULL);
#line 36 "rygel-media-export-item.vala"
	title = g_file_get_basename (file);
#line 117 "rygel-media-export-item.c"
	upnp_class = NULL;
#line 39 "rygel-media-export-item.vala"
	if (g_str_has_prefix (mime, "video/")) {
#line 121 "rygel-media-export-item.c"
		char* _tmp0_;
#line 40 "rygel-media-export-item.vala"
		upnp_class = (_tmp0_ = g_strdup (RYGEL_MEDIA_ITEM_VIDEO_CLASS), _g_free0 (upnp_class), _tmp0_);
#line 125 "rygel-media-export-item.c"
	} else {
#line 41 "rygel-media-export-item.vala"
		if (g_str_has_prefix (mime, "image/")) {
#line 129 "rygel-media-export-item.c"
			char* _tmp1_;
#line 42 "rygel-media-export-item.vala"
			upnp_class = (_tmp1_ = g_strdup (RYGEL_MEDIA_ITEM_PHOTO_CLASS), _g_free0 (upnp_class), _tmp1_);
#line 133 "rygel-media-export-item.c"
		} else {
			char* _tmp2_;
#line 44 "rygel-media-export-item.vala"
			upnp_class = (_tmp2_ = g_strdup (RYGEL_MEDIA_ITEM_AUDIO_CLASS), _g_free0 (upnp_class), _tmp2_);
#line 138 "rygel-media-export-item.c"
		}
	}
#line 47 "rygel-media-export-item.vala"
	self = (RygelMediaExportItem*) rygel_media_item_construct (object_type, _tmp3_ = rygel_media_export_media_cache_get_id (file), parent, title, upnp_class);
#line 143 "rygel-media-export-item.c"
	_g_free0 (_tmp3_);
#line 48 "rygel-media-export-item.vala"
	((RygelMediaItem*) self)->mime_type = (_tmp4_ = g_strdup (mime), _g_free0 (((RygelMediaItem*) self)->mime_type), _tmp4_);
#line 49 "rygel-media-export-item.vala"
	((RygelMediaItem*) self)->size = (gint64) size;
#line 50 "rygel-media-export-item.vala"
	((RygelMediaObject*) self)->modified = mtime;
#line 51 "rygel-media-export-item.vala"
	rygel_media_item_add_uri ((RygelMediaItem*) self, _tmp5_ = g_file_get_uri (file), NULL);
#line 153 "rygel-media-export-item.c"
	_g_free0 (_tmp5_);
	_g_free0 (upnp_class);
	_g_free0 (title);
	return self;
}


#line 31 "rygel-media-export-item.vala"
RygelMediaExportItem* rygel_media_export_item_new_simple (RygelMediaContainer* parent, GFile* file, const char* mime, guint64 size, guint64 mtime) {
#line 31 "rygel-media-export-item.vala"
	return rygel_media_export_item_construct_simple (RYGEL_MEDIA_EXPORT_TYPE_ITEM, parent, file, mime, size, mtime);
#line 165 "rygel-media-export-item.c"
}


#line 54 "rygel-media-export-item.vala"
RygelMediaExportItem* rygel_media_export_item_create_from_info (RygelMediaContainer* parent, GFile* file, GUPnPDLNAInformation* dlna_info, const char* mime, guint64 size, guint64 mtime) {
#line 171 "rygel-media-export-item.c"
	RygelMediaExportItem* result = NULL;
	char* id;
	GstStreamAudioInformation* audio_info;
	GstStreamVideoInformation* video_info;
#line 54 "rygel-media-export-item.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 54 "rygel-media-export-item.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 54 "rygel-media-export-item.vala"
	g_return_val_if_fail (dlna_info != NULL, NULL);
#line 54 "rygel-media-export-item.vala"
	g_return_val_if_fail (mime != NULL, NULL);
#line 60 "rygel-media-export-item.vala"
	id = rygel_media_export_media_cache_get_id (file);
#line 61 "rygel-media-export-item.vala"
	audio_info = NULL;
#line 62 "rygel-media-export-item.vala"
	video_info = NULL;
#line 190 "rygel-media-export-item.c"
	{
		GList* stream_info_collection;
		GList* stream_info_it;
#line 64 "rygel-media-export-item.vala"
		stream_info_collection = gupnp_dlna_information_get_info (dlna_info)->stream_list;
#line 196 "rygel-media-export-item.c"
		for (stream_info_it = stream_info_collection; stream_info_it != NULL; stream_info_it = stream_info_it->next) {
			GstStreamInformation* stream_info;
#line 64 "rygel-media-export-item.vala"
			stream_info = (GstStreamInformation*) stream_info_it->data;
#line 201 "rygel-media-export-item.c"
			{
				gboolean _tmp0_ = FALSE;
#line 66 "rygel-media-export-item.vala"
				if (audio_info == NULL) {
#line 67 "rygel-media-export-item.vala"
					_tmp0_ = stream_info->streamtype == GST_STREAM_AUDIO;
#line 208 "rygel-media-export-item.c"
				} else {
#line 66 "rygel-media-export-item.vala"
					_tmp0_ = FALSE;
#line 212 "rygel-media-export-item.c"
				}
#line 66 "rygel-media-export-item.vala"
				if (_tmp0_) {
#line 68 "rygel-media-export-item.vala"
					audio_info = (GstStreamAudioInformation*) stream_info;
#line 218 "rygel-media-export-item.c"
				} else {
					gboolean _tmp1_ = FALSE;
#line 69 "rygel-media-export-item.vala"
					if (video_info == NULL) {
#line 223 "rygel-media-export-item.c"
						gboolean _tmp2_ = FALSE;
#line 70 "rygel-media-export-item.vala"
						if (stream_info->streamtype == GST_STREAM_VIDEO) {
#line 70 "rygel-media-export-item.vala"
							_tmp2_ = TRUE;
#line 229 "rygel-media-export-item.c"
						} else {
#line 71 "rygel-media-export-item.vala"
							_tmp2_ = stream_info->streamtype == GST_STREAM_IMAGE;
#line 233 "rygel-media-export-item.c"
						}
#line 70 "rygel-media-export-item.vala"
						_tmp1_ = _tmp2_;
#line 237 "rygel-media-export-item.c"
					} else {
#line 69 "rygel-media-export-item.vala"
						_tmp1_ = FALSE;
#line 241 "rygel-media-export-item.c"
					}
#line 69 "rygel-media-export-item.vala"
					if (_tmp1_) {
#line 72 "rygel-media-export-item.vala"
						video_info = (GstStreamVideoInformation*) stream_info;
#line 247 "rygel-media-export-item.c"
					}
				}
			}
		}
	}
#line 76 "rygel-media-export-item.vala"
	if (video_info != NULL) {
#line 255 "rygel-media-export-item.c"
		gboolean _tmp3_ = FALSE;
#line 77 "rygel-media-export-item.vala"
		if (audio_info == NULL) {
#line 78 "rygel-media-export-item.vala"
			_tmp3_ = ((GstStreamInformation*) video_info)->streamtype == GST_STREAM_IMAGE;
#line 261 "rygel-media-export-item.c"
		} else {
#line 77 "rygel-media-export-item.vala"
			_tmp3_ = FALSE;
#line 265 "rygel-media-export-item.c"
		}
#line 77 "rygel-media-export-item.vala"
		if (_tmp3_) {
#line 269 "rygel-media-export-item.c"
			result = rygel_media_export_item_new_photo (parent, id, file, dlna_info, video_info, mime, size, mtime);
			_g_free0 (id);
#line 79 "rygel-media-export-item.vala"
			return result;
#line 274 "rygel-media-export-item.c"
		} else {
			result = rygel_media_export_item_new_video (parent, id, file, dlna_info, video_info, audio_info, mime, size, mtime);
			_g_free0 (id);
#line 88 "rygel-media-export-item.vala"
			return result;
#line 280 "rygel-media-export-item.c"
		}
	} else {
#line 98 "rygel-media-export-item.vala"
		if (audio_info != NULL) {
#line 285 "rygel-media-export-item.c"
			result = rygel_media_export_item_new_audio (parent, id, file, dlna_info, audio_info, mime, size, mtime);
			_g_free0 (id);
#line 99 "rygel-media-export-item.vala"
			return result;
#line 290 "rygel-media-export-item.c"
		} else {
			result = NULL;
			_g_free0 (id);
#line 108 "rygel-media-export-item.vala"
			return result;
#line 296 "rygel-media-export-item.c"
		}
	}
	_g_free0 (id);
}


#line 112 "rygel-media-export-item.vala"
static RygelMediaExportItem* rygel_media_export_item_construct_video (GType object_type, RygelMediaContainer* parent, const char* id, GFile* file, GUPnPDLNAInformation* dlna_info, GstStreamVideoInformation* video_info, GstStreamAudioInformation* audio_info, const char* mime, guint64 size, guint64 mtime) {
#line 305 "rygel-media-export-item.c"
	RygelMediaExportItem * self;
#line 112 "rygel-media-export-item.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 112 "rygel-media-export-item.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 112 "rygel-media-export-item.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 112 "rygel-media-export-item.vala"
	g_return_val_if_fail (dlna_info != NULL, NULL);
#line 112 "rygel-media-export-item.vala"
	g_return_val_if_fail (video_info != NULL, NULL);
#line 112 "rygel-media-export-item.vala"
	g_return_val_if_fail (mime != NULL, NULL);
#line 121 "rygel-media-export-item.vala"
	self = (RygelMediaExportItem*) rygel_media_export_item_construct (object_type, parent, id, file, dlna_info, mime, size, mtime, RYGEL_MEDIA_ITEM_VIDEO_CLASS);
#line 130 "rygel-media-export-item.vala"
	((RygelMediaItem*) self)->width = (gint) video_info->width;
#line 131 "rygel-media-export-item.vala"
	((RygelMediaItem*) self)->height = (gint) video_info->height;
#line 132 "rygel-media-export-item.vala"
	((RygelMediaItem*) self)->color_depth = (gint) video_info->depth;
#line 134 "rygel-media-export-item.vala"
	if (audio_info != NULL) {
#line 135 "rygel-media-export-item.vala"
		((RygelMediaItem*) self)->n_audio_channels = (gint) audio_info->channels;
#line 136 "rygel-media-export-item.vala"
		((RygelMediaItem*) self)->sample_freq = (gint) audio_info->sample_rate;
#line 137 "rygel-media-export-item.vala"
		if (((GstStreamInformation*) audio_info)->tags != NULL) {
#line 335 "rygel-media-export-item.c"
			guint tmp = 0U;
#line 140 "rygel-media-export-item.vala"
			gst_tag_list_get_uint (((GstStreamInformation*) audio_info)->tags, GST_TAG_BITRATE, &tmp);
#line 141 "rygel-media-export-item.vala"
			((RygelMediaItem*) self)->bitrate = ((gint) tmp) / 8;
#line 341 "rygel-media-export-item.c"
		}
	}
	return self;
}


#line 112 "rygel-media-export-item.vala"
static RygelMediaExportItem* rygel_media_export_item_new_video (RygelMediaContainer* parent, const char* id, GFile* file, GUPnPDLNAInformation* dlna_info, GstStreamVideoInformation* video_info, GstStreamAudioInformation* audio_info, const char* mime, guint64 size, guint64 mtime) {
#line 112 "rygel-media-export-item.vala"
	return rygel_media_export_item_construct_video (RYGEL_MEDIA_EXPORT_TYPE_ITEM, parent, id, file, dlna_info, video_info, audio_info, mime, size, mtime);
#line 352 "rygel-media-export-item.c"
}


#line 146 "rygel-media-export-item.vala"
static RygelMediaExportItem* rygel_media_export_item_construct_photo (GType object_type, RygelMediaContainer* parent, const char* id, GFile* file, GUPnPDLNAInformation* dlna_info, GstStreamVideoInformation* video_info, const char* mime, guint64 size, guint64 mtime) {
#line 358 "rygel-media-export-item.c"
	RygelMediaExportItem * self;
#line 146 "rygel-media-export-item.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 146 "rygel-media-export-item.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 146 "rygel-media-export-item.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 146 "rygel-media-export-item.vala"
	g_return_val_if_fail (dlna_info != NULL, NULL);
#line 146 "rygel-media-export-item.vala"
	g_return_val_if_fail (video_info != NULL, NULL);
#line 146 "rygel-media-export-item.vala"
	g_return_val_if_fail (mime != NULL, NULL);
#line 154 "rygel-media-export-item.vala"
	self = (RygelMediaExportItem*) rygel_media_export_item_construct (object_type, parent, id, file, dlna_info, mime, size, mtime, RYGEL_MEDIA_ITEM_PHOTO_CLASS);
#line 163 "rygel-media-export-item.vala"
	((RygelMediaItem*) self)->width = (gint) video_info->width;
#line 164 "rygel-media-export-item.vala"
	((RygelMediaItem*) self)->height = (gint) video_info->height;
#line 165 "rygel-media-export-item.vala"
	((RygelMediaItem*) self)->color_depth = (gint) video_info->depth;
#line 380 "rygel-media-export-item.c"
	return self;
}


#line 146 "rygel-media-export-item.vala"
static RygelMediaExportItem* rygel_media_export_item_new_photo (RygelMediaContainer* parent, const char* id, GFile* file, GUPnPDLNAInformation* dlna_info, GstStreamVideoInformation* video_info, const char* mime, guint64 size, guint64 mtime) {
#line 146 "rygel-media-export-item.vala"
	return rygel_media_export_item_construct_photo (RYGEL_MEDIA_EXPORT_TYPE_ITEM, parent, id, file, dlna_info, video_info, mime, size, mtime);
#line 389 "rygel-media-export-item.c"
}


static gpointer _gst_structure_copy0 (gpointer self) {
	return self ? gst_structure_copy (self) : NULL;
}


#line 168 "rygel-media-export-item.vala"
static RygelMediaExportItem* rygel_media_export_item_construct_audio (GType object_type, RygelMediaContainer* parent, const char* id, GFile* file, GUPnPDLNAInformation* dlna_info, GstStreamAudioInformation* audio_info, const char* mime, guint64 size, guint64 mtime) {
#line 400 "rygel-media-export-item.c"
	GError * _inner_error_;
	RygelMediaExportItem * self;
#line 168 "rygel-media-export-item.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 168 "rygel-media-export-item.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 168 "rygel-media-export-item.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 168 "rygel-media-export-item.vala"
	g_return_val_if_fail (dlna_info != NULL, NULL);
#line 168 "rygel-media-export-item.vala"
	g_return_val_if_fail (audio_info != NULL, NULL);
#line 168 "rygel-media-export-item.vala"
	g_return_val_if_fail (mime != NULL, NULL);
#line 415 "rygel-media-export-item.c"
	_inner_error_ = NULL;
#line 176 "rygel-media-export-item.vala"
	self = (RygelMediaExportItem*) rygel_media_export_item_construct (object_type, parent, id, file, dlna_info, mime, size, mtime, RYGEL_MEDIA_ITEM_MUSIC_CLASS);
#line 185 "rygel-media-export-item.vala"
	if (((GstStreamInformation*) audio_info)->tags != NULL) {
#line 421 "rygel-media-export-item.c"
		GstBuffer* buffer;
		guint tmp = 0U;
		buffer = NULL;
#line 187 "rygel-media-export-item.vala"
		gst_tag_list_get_buffer (((GstStreamInformation*) audio_info)->tags, GST_TAG_IMAGE, &buffer);
#line 188 "rygel-media-export-item.vala"
		if (buffer != NULL) {
#line 429 "rygel-media-export-item.c"
			GstStructure* structure;
			gint image_type = 0;
#line 189 "rygel-media-export-item.vala"
			structure = _gst_structure_copy0 (gst_caps_get_structure (buffer->caps, (guint) 0));
#line 191 "rygel-media-export-item.vala"
			gst_structure_get_enum (structure, "image-type", GST_TYPE_TAG_IMAGE_TYPE, &image_type);
#line 194 "rygel-media-export-item.vala"
			switch (image_type) {
#line 438 "rygel-media-export-item.c"
				case GST_TAG_IMAGE_TYPE_UNDEFINED:
				case GST_TAG_IMAGE_TYPE_FRONT_COVER:
				{
					RygelMediaArtStore* store;
					GFile* thumb;
#line 197 "rygel-media-export-item.vala"
					store = rygel_media_art_store_get_default ();
#line 198 "rygel-media-export-item.vala"
					thumb = rygel_media_art_store_get_media_art_file (store, "album", (RygelMediaItem*) self, TRUE);
#line 448 "rygel-media-export-item.c"
					{
						RygelMediaExportJPEGWriter* writer;
#line 202 "rygel-media-export-item.vala"
						writer = rygel_media_export_jpeg_writer_new (&_inner_error_);
#line 453 "rygel-media-export-item.c"
						if (_inner_error_ != NULL) {
							goto __catch52_g_error;
						}
#line 203 "rygel-media-export-item.vala"
						rygel_media_export_jpeg_writer_write (writer, buffer, thumb);
#line 459 "rygel-media-export-item.c"
						_g_object_unref0 (writer);
					}
					goto __finally52;
					__catch52_g_error:
					{
						GError * _error_;
						_error_ = _inner_error_;
						_inner_error_ = NULL;
						{
							_g_error_free0 (_error_);
						}
					}
					__finally52:
					if (_inner_error_ != NULL) {
						_g_object_unref0 (thumb);
						_g_object_unref0 (store);
						_gst_structure_free0 (structure);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
					_g_object_unref0 (thumb);
					_g_object_unref0 (store);
#line 205 "rygel-media-export-item.vala"
					break;
#line 485 "rygel-media-export-item.c"
				}
				default:
				{
#line 207 "rygel-media-export-item.vala"
					break;
#line 491 "rygel-media-export-item.c"
				}
			}
			_gst_structure_free0 (structure);
		}
#line 212 "rygel-media-export-item.vala"
		gst_tag_list_get_uint (((GstStreamInformation*) audio_info)->tags, GST_TAG_BITRATE, &tmp);
#line 213 "rygel-media-export-item.vala"
		((RygelMediaItem*) self)->bitrate = ((gint) tmp) / 8;
#line 500 "rygel-media-export-item.c"
	}
#line 215 "rygel-media-export-item.vala"
	((RygelMediaItem*) self)->n_audio_channels = (gint) audio_info->channels;
#line 216 "rygel-media-export-item.vala"
	((RygelMediaItem*) self)->sample_freq = (gint) audio_info->sample_rate;
#line 506 "rygel-media-export-item.c"
	return self;
}


#line 168 "rygel-media-export-item.vala"
static RygelMediaExportItem* rygel_media_export_item_new_audio (RygelMediaContainer* parent, const char* id, GFile* file, GUPnPDLNAInformation* dlna_info, GstStreamAudioInformation* audio_info, const char* mime, guint64 size, guint64 mtime) {
#line 168 "rygel-media-export-item.vala"
	return rygel_media_export_item_construct_audio (RYGEL_MEDIA_EXPORT_TYPE_ITEM, parent, id, file, dlna_info, audio_info, mime, size, mtime);
#line 515 "rygel-media-export-item.c"
}


#line 219 "rygel-media-export-item.vala"
static RygelMediaExportItem* rygel_media_export_item_construct (GType object_type, RygelMediaContainer* parent, const char* id, GFile* file, GUPnPDLNAInformation* dlna_info, const char* mime, guint64 size, guint64 mtime, const char* upnp_class) {
#line 521 "rygel-media-export-item.c"
	RygelMediaExportItem * self;
	char* title;
	gboolean _tmp0_ = FALSE;
	char* _tmp21_;
#line 219 "rygel-media-export-item.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 219 "rygel-media-export-item.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 219 "rygel-media-export-item.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 219 "rygel-media-export-item.vala"
	g_return_val_if_fail (dlna_info != NULL, NULL);
#line 219 "rygel-media-export-item.vala"
	g_return_val_if_fail (mime != NULL, NULL);
#line 219 "rygel-media-export-item.vala"
	g_return_val_if_fail (upnp_class != NULL, NULL);
#line 227 "rygel-media-export-item.vala"
	title = NULL;
#line 229 "rygel-media-export-item.vala"
	if (gupnp_dlna_information_get_info (dlna_info)->tags == NULL) {
#line 229 "rygel-media-export-item.vala"
		_tmp0_ = TRUE;
#line 544 "rygel-media-export-item.c"
	} else {
		char* _tmp3_;
		gboolean _tmp2_;
		char* _tmp1_ = NULL;
#line 230 "rygel-media-export-item.vala"
		_tmp0_ = !(_tmp2_ = gst_tag_list_get_string (gupnp_dlna_information_get_info (dlna_info)->tags, GST_TAG_TITLE, &_tmp1_), title = (_tmp3_ = _tmp1_, _g_free0 (title), _tmp3_), _tmp2_);
#line 551 "rygel-media-export-item.c"
	}
#line 229 "rygel-media-export-item.vala"
	if (_tmp0_) {
#line 555 "rygel-media-export-item.c"
		char* _tmp4_;
#line 231 "rygel-media-export-item.vala"
		title = (_tmp4_ = g_file_get_basename (file), _g_free0 (title), _tmp4_);
#line 559 "rygel-media-export-item.c"
	}
#line 234 "rygel-media-export-item.vala"
	self = (RygelMediaExportItem*) rygel_media_item_construct (object_type, id, parent, title, upnp_class);
#line 236 "rygel-media-export-item.vala"
	if (gupnp_dlna_information_get_info (dlna_info)->duration > 0) {
#line 237 "rygel-media-export-item.vala"
		((RygelMediaItem*) self)->duration = (glong) (gupnp_dlna_information_get_info (dlna_info)->duration / GST_SECOND);
#line 567 "rygel-media-export-item.c"
	} else {
#line 239 "rygel-media-export-item.vala"
		((RygelMediaItem*) self)->duration = (glong) (-1);
#line 571 "rygel-media-export-item.c"
	}
#line 242 "rygel-media-export-item.vala"
	if (gupnp_dlna_information_get_info (dlna_info)->tags != NULL) {
#line 575 "rygel-media-export-item.c"
		char* _tmp6_;
		char* _tmp5_ = NULL;
		char* _tmp8_;
		char* _tmp7_ = NULL;
		char* _tmp10_;
		char* _tmp9_ = NULL;
		guint tmp = 0U;
		GDate* date = NULL;
		GDate* _tmp13_;
		gboolean _tmp12_;
		GDate* _tmp11_ = NULL;
#line 243 "rygel-media-export-item.vala"
		gst_tag_list_get_string (gupnp_dlna_information_get_info (dlna_info)->tags, GST_TAG_ARTIST, &_tmp5_);
#line 243 "rygel-media-export-item.vala"
		((RygelMediaItem*) self)->author = (_tmp6_ = _tmp5_, _g_free0 (((RygelMediaItem*) self)->author), _tmp6_);
#line 244 "rygel-media-export-item.vala"
		gst_tag_list_get_string (gupnp_dlna_information_get_info (dlna_info)->tags, GST_TAG_ALBUM, &_tmp7_);
#line 244 "rygel-media-export-item.vala"
		((RygelMediaItem*) self)->album = (_tmp8_ = _tmp7_, _g_free0 (((RygelMediaItem*) self)->album), _tmp8_);
#line 245 "rygel-media-export-item.vala"
		gst_tag_list_get_string (gupnp_dlna_information_get_info (dlna_info)->tags, GST_TAG_GENRE, &_tmp9_);
#line 245 "rygel-media-export-item.vala"
		((RygelMediaItem*) self)->genre = (_tmp10_ = _tmp9_, _g_free0 (((RygelMediaItem*) self)->genre), _tmp10_);
#line 248 "rygel-media-export-item.vala"
		gst_tag_list_get_uint (gupnp_dlna_information_get_info (dlna_info)->tags, GST_TAG_TRACK_NUMBER, &tmp);
#line 249 "rygel-media-export-item.vala"
		((RygelMediaItem*) self)->track_number = (gint) tmp;
#line 252 "rygel-media-export-item.vala"
		if ((_tmp12_ = gst_tag_list_get_date (gupnp_dlna_information_get_info (dlna_info)->tags, GST_TAG_DATE, &_tmp11_), date = (_tmp13_ = _tmp11_, _g_free0 (date), _tmp13_), _tmp12_)) {
#line 605 "rygel-media-export-item.c"
			gchar* _tmp14_;
			gint _datestr_size_;
			gint datestr_length1;
			gchar* datestr;
			char* _tmp15_;
			datestr = (_tmp14_ = g_new0 (gchar, 30), datestr_length1 = 30, _datestr_size_ = datestr_length1, _tmp14_);
#line 254 "rygel-media-export-item.vala"
			g_date_strftime (datestr, datestr_length1, "%F", date);
#line 255 "rygel-media-export-item.vala"
			((RygelMediaItem*) self)->date = (_tmp15_ = g_strdup ((const char*) datestr), _g_free0 (((RygelMediaItem*) self)->date), _tmp15_);
#line 616 "rygel-media-export-item.c"
			datestr = (g_free (datestr), NULL);
		}
		_g_free0 (date);
	}
#line 260 "rygel-media-export-item.vala"
	if (((RygelMediaItem*) self)->date == NULL) {
#line 623 "rygel-media-export-item.c"
		GTimeVal _tmp16_ = {0};
		GTimeVal tv;
		char* _tmp17_;
#line 261 "rygel-media-export-item.vala"
		tv = (_tmp16_.tv_sec = (glong) mtime, _tmp16_.tv_usec = (glong) 0, _tmp16_);
#line 262 "rygel-media-export-item.vala"
		((RygelMediaItem*) self)->date = (_tmp17_ = g_time_val_to_iso8601 (&tv), _g_free0 (((RygelMediaItem*) self)->date), _tmp17_);
#line 631 "rygel-media-export-item.c"
	}
#line 265 "rygel-media-export-item.vala"
	((RygelMediaItem*) self)->size = (gint64) size;
#line 266 "rygel-media-export-item.vala"
	((RygelMediaObject*) self)->modified = (guint64) ((gint64) mtime);
#line 268 "rygel-media-export-item.vala"
	if (gupnp_dlna_information_get_name (dlna_info) != NULL) {
#line 639 "rygel-media-export-item.c"
		char* _tmp18_;
		char* _tmp19_;
#line 269 "rygel-media-export-item.vala"
		((RygelMediaItem*) self)->dlna_profile = (_tmp18_ = g_strdup (gupnp_dlna_information_get_name (dlna_info)), _g_free0 (((RygelMediaItem*) self)->dlna_profile), _tmp18_);
#line 270 "rygel-media-export-item.vala"
		((RygelMediaItem*) self)->mime_type = (_tmp19_ = g_strdup (gupnp_dlna_information_get_mime (dlna_info)), _g_free0 (((RygelMediaItem*) self)->mime_type), _tmp19_);
#line 646 "rygel-media-export-item.c"
	} else {
		char* _tmp20_;
#line 272 "rygel-media-export-item.vala"
		((RygelMediaItem*) self)->mime_type = (_tmp20_ = g_strdup (mime), _g_free0 (((RygelMediaItem*) self)->mime_type), _tmp20_);
#line 651 "rygel-media-export-item.c"
	}
#line 275 "rygel-media-export-item.vala"
	rygel_media_item_add_uri ((RygelMediaItem*) self, _tmp21_ = g_file_get_uri (file), NULL);
#line 655 "rygel-media-export-item.c"
	_g_free0 (_tmp21_);
	_g_free0 (title);
	return self;
}


#line 219 "rygel-media-export-item.vala"
static RygelMediaExportItem* rygel_media_export_item_new (RygelMediaContainer* parent, const char* id, GFile* file, GUPnPDLNAInformation* dlna_info, const char* mime, guint64 size, guint64 mtime, const char* upnp_class) {
#line 219 "rygel-media-export-item.vala"
	return rygel_media_export_item_construct (RYGEL_MEDIA_EXPORT_TYPE_ITEM, parent, id, file, dlna_info, mime, size, mtime, upnp_class);
#line 666 "rygel-media-export-item.c"
}


static void rygel_media_export_item_class_init (RygelMediaExportItemClass * klass) {
	rygel_media_export_item_parent_class = g_type_class_peek_parent (klass);
}


static void rygel_media_export_item_instance_init (RygelMediaExportItem * self) {
}


/**
 * Represents MediaExport item.
 */
GType rygel_media_export_item_get_type (void) {
	static volatile gsize rygel_media_export_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportItem), 0, (GInstanceInitFunc) rygel_media_export_item_instance_init, NULL };
		GType rygel_media_export_item_type_id;
		rygel_media_export_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_ITEM, "RygelMediaExportItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_item_type_id__volatile, rygel_media_export_item_type_id);
	}
	return rygel_media_export_item_type_id__volatile;
}




