/* rygel-media-export-database.c generated by valac 0.9.5, the Vala compiler
 * generated from rygel-media-export-database.vala, do not modify */

/*
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>


#define RYGEL_MEDIA_EXPORT_TYPE_DATABASE (rygel_media_export_database_get_type ())
#define RYGEL_MEDIA_EXPORT_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabase))
#define RYGEL_MEDIA_EXPORT_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabaseClass))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE))
#define RYGEL_MEDIA_EXPORT_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabaseClass))

typedef struct _RygelMediaExportDatabase RygelMediaExportDatabase;
typedef struct _RygelMediaExportDatabaseClass RygelMediaExportDatabaseClass;
typedef struct _RygelMediaExportDatabasePrivate RygelMediaExportDatabasePrivate;
#define _sqlite3_close0(var) ((var == NULL) ? NULL : (var = (sqlite3_close (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_IO_ERROR,
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR
} RygelMediaExportDatabaseError;
#define RYGEL_MEDIA_EXPORT_DATABASE_ERROR rygel_media_export_database_error_quark ()
struct _RygelMediaExportDatabase {
	GObject parent_instance;
	RygelMediaExportDatabasePrivate * priv;
};

struct _RygelMediaExportDatabaseClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportDatabasePrivate {
	sqlite3* db;
};

typedef gboolean (*RygelMediaExportDatabaseRowCallback) (sqlite3_stmt* stmt, void* user_data);

static gpointer rygel_media_export_database_parent_class = NULL;

GQuark rygel_media_export_database_error_quark (void);
GType rygel_media_export_database_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_DATABASE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabasePrivate))
enum  {
	RYGEL_MEDIA_EXPORT_DATABASE_DUMMY_PROPERTY
};
RygelMediaExportDatabase* rygel_media_export_database_new (const char* name, GError** error);
RygelMediaExportDatabase* rygel_media_export_database_construct (GType object_type, const char* name, GError** error);
static sqlite3_stmt* rygel_media_export_database_prepare_statement (RygelMediaExportDatabase* self, const char* sql, GValue* values, int values_length1, GError** error);
gint rygel_media_export_database_exec (RygelMediaExportDatabase* self, const char* sql, GValue* values, int values_length1, RygelMediaExportDatabaseRowCallback callback, void* callback_target, GCancellable* cancellable, GError** error);
void rygel_media_export_database_analyze (RygelMediaExportDatabase* self);
void rygel_media_export_database_null (GValue* result);
static void rygel_media_export_database_single_statement (RygelMediaExportDatabase* self, const char* sql, GError** error);
void rygel_media_export_database_begin (RygelMediaExportDatabase* self, GError** error);
void rygel_media_export_database_commit (RygelMediaExportDatabase* self, GError** error);
void rygel_media_export_database_rollback (RygelMediaExportDatabase* self);
static void rygel_media_export_database_finalize (GObject* obj);



GQuark rygel_media_export_database_error_quark (void) {
	return g_quark_from_static_string ("rygel_media_export_database_error-quark");
}


#line 34 "sqlite3.vapi"
static gint _sqlite3_exec (sqlite3* self, const char* sql, sqlite3_callback sqlite3_callback, void* sqlite3_callback_target, char** errmsg) {
#line 101 "rygel-media-export-database.c"
	gint result = 0;
	const char* sqlite_errmsg;
	gint ec;
#line 34 "sqlite3.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 34 "sqlite3.vapi"
	g_return_val_if_fail (sql != NULL, 0);
#line 109 "rygel-media-export-database.c"
	if (errmsg != NULL) {
		*errmsg = NULL;
	}
	sqlite_errmsg = NULL;
#line 36 "sqlite3.vapi"
	ec = sqlite3_exec (self, sql, sqlite3_callback, sqlite3_callback_target, (char**) (&sqlite_errmsg));
#line 37 "sqlite3.vapi"
	if ((errmsg) != NULL) {
#line 118 "rygel-media-export-database.c"
		char* _tmp0_;
#line 38 "sqlite3.vapi"
		*errmsg = (_tmp0_ = g_strdup (sqlite_errmsg), _g_free0 (*errmsg), _tmp0_);
#line 122 "rygel-media-export-database.c"
	}
#line 40 "sqlite3.vapi"
	sqlite3_free ((void*) sqlite_errmsg);
#line 126 "rygel-media-export-database.c"
	result = ec;
#line 41 "sqlite3.vapi"
	return result;
#line 130 "rygel-media-export-database.c"
}


/**
     * Open a database in the user's cache directory as defined by XDG
     *
     * @param name of the database, used to build full path
     * (<cache-dir>/rygel/<name>.db)
     */
#line 52 "rygel-media-export-database.vala"
RygelMediaExportDatabase* rygel_media_export_database_construct (GType object_type, const char* name, GError** error) {
#line 142 "rygel-media-export-database.c"
	GError * _inner_error_;
	RygelMediaExportDatabase * self;
	char* dirname;
	char* _tmp0_;
	char* _tmp1_;
	char* db_file;
	sqlite3* _tmp4_;
	gint _tmp3_;
	sqlite3* _tmp2_ = NULL;
	gint rc;
#line 52 "rygel-media-export-database.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 155 "rygel-media-export-database.c"
	_inner_error_ = NULL;
#line 52 "rygel-media-export-database.vala"
	self = (RygelMediaExportDatabase*) g_object_new (object_type, NULL);
#line 53 "rygel-media-export-database.vala"
	dirname = g_build_filename (g_get_user_cache_dir (), "rygel", NULL);
#line 55 "rygel-media-export-database.vala"
	g_mkdir_with_parents (dirname, 0750);
#line 56 "rygel-media-export-database.vala"
	db_file = (_tmp1_ = g_build_filename (dirname, _tmp0_ = g_strdup_printf ("%s.db", name), NULL), _g_free0 (_tmp0_), _tmp1_);
#line 57 "rygel-media-export-database.vala"
	g_debug (_ ("Using database file %s"), db_file);
#line 58 "rygel-media-export-database.vala"
	rc = (_tmp3_ = sqlite3_open (db_file, &_tmp2_), self->priv->db = (_tmp4_ = _tmp2_, _sqlite3_close0 (self->priv->db), _tmp4_), _tmp3_);
#line 59 "rygel-media-export-database.vala"
	if (rc != SQLITE_OK) {
#line 171 "rygel-media-export-database.c"
		_inner_error_ = g_error_new (RYGEL_MEDIA_EXPORT_DATABASE_ERROR, RYGEL_MEDIA_EXPORT_DATABASE_ERROR_IO_ERROR, _ ("Failed to open database: %d (%s)"), rc, sqlite3_errmsg (self->priv->db));
		{
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (db_file);
				_g_free0 (dirname);
				_g_object_unref0 (self);
				return NULL;
			} else {
				_g_free0 (db_file);
				_g_free0 (dirname);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
#line 66 "rygel-media-export-database.vala"
	_sqlite3_exec (self->priv->db, "PRAGMA cache_size = 32768", NULL, NULL, NULL);
#line 67 "rygel-media-export-database.vala"
	_sqlite3_exec (self->priv->db, "PRAGMA synchronous = OFF", NULL, NULL, NULL);
#line 68 "rygel-media-export-database.vala"
	_sqlite3_exec (self->priv->db, "PRAGMA temp_store = MEMORY", NULL, NULL, NULL);
#line 69 "rygel-media-export-database.vala"
	_sqlite3_exec (self->priv->db, "PRAGMA count_changes = OFF", NULL, NULL, NULL);
#line 197 "rygel-media-export-database.c"
	_g_free0 (db_file);
	_g_free0 (dirname);
	return self;
}


#line 52 "rygel-media-export-database.vala"
RygelMediaExportDatabase* rygel_media_export_database_new (const char* name, GError** error) {
#line 52 "rygel-media-export-database.vala"
	return rygel_media_export_database_construct (RYGEL_MEDIA_EXPORT_TYPE_DATABASE, name, error);
#line 208 "rygel-media-export-database.c"
}


/**
     * Execute a cancellable SQL statement.
     *
     * The supplied values are bound to the SQL statement and the RowCallback
     * is called on every row of the resultset.
     *
     * @param sql statement to execute
     * @param values array of values to bind to the SQL statement or null if
     * none
     * @param callback to call on each row of the result set or null if none
     * necessary
     * @param cancellable to cancel the running query or null if none
     * necessary
     */
#line 86 "rygel-media-export-database.vala"
gint rygel_media_export_database_exec (RygelMediaExportDatabase* self, const char* sql, GValue* values, int values_length1, RygelMediaExportDatabaseRowCallback callback, void* callback_target, GCancellable* cancellable, GError** error) {
#line 228 "rygel-media-export-database.c"
	gint result = 0;
	GError * _inner_error_;
	gint rc = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp3_ = FALSE;
#line 86 "rygel-media-export-database.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 86 "rygel-media-export-database.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 239 "rygel-media-export-database.c"
	_inner_error_ = NULL;
#line 95 "rygel-media-export-database.vala"
	if (values == NULL) {
#line 95 "rygel-media-export-database.vala"
		_tmp1_ = callback == NULL;
#line 245 "rygel-media-export-database.c"
	} else {
#line 95 "rygel-media-export-database.vala"
		_tmp1_ = FALSE;
#line 249 "rygel-media-export-database.c"
	}
#line 95 "rygel-media-export-database.vala"
	if (_tmp1_) {
#line 95 "rygel-media-export-database.vala"
		_tmp0_ = cancellable == NULL;
#line 255 "rygel-media-export-database.c"
	} else {
#line 95 "rygel-media-export-database.vala"
		_tmp0_ = FALSE;
#line 259 "rygel-media-export-database.c"
	}
#line 95 "rygel-media-export-database.vala"
	if (_tmp0_) {
#line 96 "rygel-media-export-database.vala"
		rc = _sqlite3_exec (self->priv->db, sql, NULL, NULL, NULL);
#line 265 "rygel-media-export-database.c"
	} else {
		sqlite3_stmt* statement;
#line 98 "rygel-media-export-database.vala"
		statement = rygel_media_export_database_prepare_statement (self, sql, values, values_length1, &_inner_error_);
#line 270 "rygel-media-export-database.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
#line 99 "rygel-media-export-database.vala"
		while (TRUE) {
#line 283 "rygel-media-export-database.c"
			gboolean _tmp2_ = FALSE;
#line 99 "rygel-media-export-database.vala"
			if (!((rc = sqlite3_step (statement)) == SQLITE_ROW)) {
#line 99 "rygel-media-export-database.vala"
				break;
#line 289 "rygel-media-export-database.c"
			}
#line 100 "rygel-media-export-database.vala"
			if (cancellable != NULL) {
#line 100 "rygel-media-export-database.vala"
				_tmp2_ = g_cancellable_is_cancelled (cancellable);
#line 295 "rygel-media-export-database.c"
			} else {
#line 100 "rygel-media-export-database.vala"
				_tmp2_ = FALSE;
#line 299 "rygel-media-export-database.c"
			}
#line 100 "rygel-media-export-database.vala"
			if (_tmp2_) {
#line 101 "rygel-media-export-database.vala"
				break;
#line 305 "rygel-media-export-database.c"
			}
#line 104 "rygel-media-export-database.vala"
			if (callback != NULL) {
#line 105 "rygel-media-export-database.vala"
				if (!callback (statement, callback_target)) {
#line 106 "rygel-media-export-database.vala"
					rc = SQLITE_DONE;
#line 108 "rygel-media-export-database.vala"
					break;
#line 315 "rygel-media-export-database.c"
				}
			}
		}
		_sqlite3_finalize0 (statement);
	}
#line 114 "rygel-media-export-database.vala"
	if (rc != SQLITE_DONE) {
#line 114 "rygel-media-export-database.vala"
		_tmp3_ = rc != SQLITE_OK;
#line 325 "rygel-media-export-database.c"
	} else {
#line 114 "rygel-media-export-database.vala"
		_tmp3_ = FALSE;
#line 329 "rygel-media-export-database.c"
	}
#line 114 "rygel-media-export-database.vala"
	if (_tmp3_) {
#line 333 "rygel-media-export-database.c"
		_inner_error_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_DATABASE_ERROR, RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR, sqlite3_errmsg (self->priv->db));
		{
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
	}
	result = rc;
#line 121 "rygel-media-export-database.vala"
	return result;
#line 349 "rygel-media-export-database.c"
}


/**
     * Analyze triggers of database
     */
#line 127 "rygel-media-export-database.vala"
void rygel_media_export_database_analyze (RygelMediaExportDatabase* self) {
#line 127 "rygel-media-export-database.vala"
	g_return_if_fail (self != NULL);
#line 128 "rygel-media-export-database.vala"
	_sqlite3_exec (self->priv->db, "ANALYZE", NULL, NULL, NULL);
#line 362 "rygel-media-export-database.c"
}


/**
     * Special GValue to pass to exec or prepare_statement to bind a column to
     * NULL
     */
#line 135 "rygel-media-export-database.vala"
void rygel_media_export_database_null (GValue* result) {
#line 372 "rygel-media-export-database.c"
	GValue v = {0};
	g_value_init (&v, G_TYPE_POINTER);
#line 137 "rygel-media-export-database.vala"
	g_value_set_pointer (&v, NULL);
#line 377 "rygel-media-export-database.c"
	*result = v;
#line 139 "rygel-media-export-database.vala"
	return;
#line 381 "rygel-media-export-database.c"
}


/**
     * Start a transaction
     */
#line 145 "rygel-media-export-database.vala"
void rygel_media_export_database_begin (RygelMediaExportDatabase* self, GError** error) {
#line 390 "rygel-media-export-database.c"
	GError * _inner_error_;
#line 145 "rygel-media-export-database.vala"
	g_return_if_fail (self != NULL);
#line 394 "rygel-media-export-database.c"
	_inner_error_ = NULL;
#line 146 "rygel-media-export-database.vala"
	rygel_media_export_database_single_statement (self, "BEGIN", &_inner_error_);
#line 398 "rygel-media-export-database.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


/**
     * Commit a transaction
     */
#line 152 "rygel-media-export-database.vala"
void rygel_media_export_database_commit (RygelMediaExportDatabase* self, GError** error) {
#line 417 "rygel-media-export-database.c"
	GError * _inner_error_;
#line 152 "rygel-media-export-database.vala"
	g_return_if_fail (self != NULL);
#line 421 "rygel-media-export-database.c"
	_inner_error_ = NULL;
#line 153 "rygel-media-export-database.vala"
	rygel_media_export_database_single_statement (self, "COMMIT", &_inner_error_);
#line 425 "rygel-media-export-database.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


/**
     * Rollback a transaction
     */
#line 159 "rygel-media-export-database.vala"
void rygel_media_export_database_rollback (RygelMediaExportDatabase* self) {
#line 444 "rygel-media-export-database.c"
	GError * _inner_error_;
#line 159 "rygel-media-export-database.vala"
	g_return_if_fail (self != NULL);
#line 448 "rygel-media-export-database.c"
	_inner_error_ = NULL;
	{
#line 161 "rygel-media-export-database.vala"
		rygel_media_export_database_single_statement (self, "ROLLBACK", &_inner_error_);
#line 453 "rygel-media-export-database.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch1_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally1;
	__catch1_rygel_media_export_database_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
#line 163 "rygel-media-export-database.vala"
			g_critical (_ ("Failed to roll back transaction: %s"), _error_->message);
#line 472 "rygel-media-export-database.c"
			_g_error_free0 (_error_);
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


/**
     * Execute a single SQL statement and throw an exception on error
     *
     * @param sql SQL statement to execute
     * @throws DatabaseError if SQL statement fails
     */
#line 174 "rygel-media-export-database.vala"
static void rygel_media_export_database_single_statement (RygelMediaExportDatabase* self, const char* sql, GError** error) {
#line 493 "rygel-media-export-database.c"
	GError * _inner_error_;
#line 174 "rygel-media-export-database.vala"
	g_return_if_fail (self != NULL);
#line 174 "rygel-media-export-database.vala"
	g_return_if_fail (sql != NULL);
#line 499 "rygel-media-export-database.c"
	_inner_error_ = NULL;
#line 175 "rygel-media-export-database.vala"
	if (_sqlite3_exec (self->priv->db, sql, NULL, NULL, NULL) != SQLITE_OK) {
#line 503 "rygel-media-export-database.c"
		_inner_error_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_DATABASE_ERROR, RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR, sqlite3_errmsg (self->priv->db));
		{
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
}


/**
     * Prepare a SQLite statement from a SQL string
     *
     * This function uses the type of the GValue passed in values to determine
     * which _bind function to use.
     *
     * Supported types are: int, long, int64, string and pointer.
     * @note the only pointer supported is the null pointer as provided by
     * Database.@null. This is a special value to bind a column to NULL
     *
     * @param sql statement to execute
     * @param values array of values to bind to the SQL statement or null if
     * none
     */
#line 194 "rygel-media-export-database.vala"
static sqlite3_stmt* rygel_media_export_database_prepare_statement (RygelMediaExportDatabase* self, const char* sql, GValue* values, int values_length1, GError** error) {
#line 535 "rygel-media-export-database.c"
	sqlite3_stmt* result = NULL;
	GError * _inner_error_;
	sqlite3_stmt* statement;
	sqlite3_stmt* _tmp2_;
	gint _tmp1_;
	sqlite3_stmt* _tmp0_ = NULL;
	gint rc;
#line 194 "rygel-media-export-database.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 194 "rygel-media-export-database.vala"
	g_return_val_if_fail (sql != NULL, NULL);
#line 547 "rygel-media-export-database.c"
	_inner_error_ = NULL;
	statement = NULL;
#line 198 "rygel-media-export-database.vala"
	rc = (_tmp1_ = sqlite3_prepare_v2 (self->priv->db, sql, -1, &_tmp0_, NULL), statement = (_tmp2_ = _tmp0_, _sqlite3_finalize0 (statement), _tmp2_), _tmp1_);
#line 199 "rygel-media-export-database.vala"
	if (rc != SQLITE_OK) {
#line 554 "rygel-media-export-database.c"
		_inner_error_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_DATABASE_ERROR, RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR, sqlite3_errmsg (self->priv->db));
		{
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_sqlite3_finalize0 (statement);
				return NULL;
			} else {
				_sqlite3_finalize0 (statement);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
#line 203 "rygel-media-export-database.vala"
	if (values != NULL) {
#line 571 "rygel-media-export-database.c"
		{
			gint i;
#line 204 "rygel-media-export-database.vala"
			i = 0;
#line 576 "rygel-media-export-database.c"
			{
				gboolean _tmp3_;
#line 204 "rygel-media-export-database.vala"
				_tmp3_ = TRUE;
#line 204 "rygel-media-export-database.vala"
				while (TRUE) {
#line 583 "rygel-media-export-database.c"
					GValue _tmp4_;
#line 204 "rygel-media-export-database.vala"
					if (!_tmp3_) {
#line 204 "rygel-media-export-database.vala"
						i++;
#line 589 "rygel-media-export-database.c"
					}
#line 204 "rygel-media-export-database.vala"
					_tmp3_ = FALSE;
#line 204 "rygel-media-export-database.vala"
					if (!(i < values_length1)) {
#line 204 "rygel-media-export-database.vala"
						break;
#line 597 "rygel-media-export-database.c"
					}
#line 205 "rygel-media-export-database.vala"
					if (G_VALUE_HOLDS ((_tmp4_ = values[i], &_tmp4_), G_TYPE_INT)) {
#line 601 "rygel-media-export-database.c"
						GValue _tmp5_;
#line 206 "rygel-media-export-database.vala"
						rc = sqlite3_bind_int (statement, i + 1, g_value_get_int ((_tmp5_ = values[i], &_tmp5_)));
#line 605 "rygel-media-export-database.c"
					} else {
						GValue _tmp6_;
#line 207 "rygel-media-export-database.vala"
						if (G_VALUE_HOLDS ((_tmp6_ = values[i], &_tmp6_), G_TYPE_INT64)) {
#line 610 "rygel-media-export-database.c"
							GValue _tmp7_;
#line 208 "rygel-media-export-database.vala"
							rc = sqlite3_bind_int64 (statement, i + 1, g_value_get_int64 ((_tmp7_ = values[i], &_tmp7_)));
#line 614 "rygel-media-export-database.c"
						} else {
							GValue _tmp8_;
#line 209 "rygel-media-export-database.vala"
							if (G_VALUE_HOLDS ((_tmp8_ = values[i], &_tmp8_), G_TYPE_LONG)) {
#line 619 "rygel-media-export-database.c"
								GValue _tmp9_;
#line 210 "rygel-media-export-database.vala"
								rc = sqlite3_bind_int64 (statement, i + 1, (gint64) g_value_get_long ((_tmp9_ = values[i], &_tmp9_)));
#line 623 "rygel-media-export-database.c"
							} else {
								GValue _tmp10_;
#line 211 "rygel-media-export-database.vala"
								if (G_VALUE_HOLDS ((_tmp10_ = values[i], &_tmp10_), G_TYPE_STRING)) {
#line 628 "rygel-media-export-database.c"
									GValue _tmp11_;
#line 212 "rygel-media-export-database.vala"
									rc = sqlite3_bind_text (statement, i + 1, g_strdup (g_value_get_string ((_tmp11_ = values[i], &_tmp11_))), -1, g_free);
#line 632 "rygel-media-export-database.c"
								} else {
									GValue _tmp12_;
#line 213 "rygel-media-export-database.vala"
									if (G_VALUE_HOLDS ((_tmp12_ = values[i], &_tmp12_), G_TYPE_POINTER)) {
#line 637 "rygel-media-export-database.c"
										GValue _tmp13_;
#line 214 "rygel-media-export-database.vala"
										if (g_value_peek_pointer ((_tmp13_ = values[i], &_tmp13_)) == NULL) {
#line 215 "rygel-media-export-database.vala"
											rc = sqlite3_bind_null (statement, i + 1);
#line 643 "rygel-media-export-database.c"
										} else {
#line 217 "rygel-media-export-database.vala"
											g_assert_not_reached ();
#line 647 "rygel-media-export-database.c"
										}
									} else {
										GValue _tmp14_;
										GType t;
#line 220 "rygel-media-export-database.vala"
										t = G_VALUE_TYPE ((_tmp14_ = values[i], &_tmp14_));
#line 221 "rygel-media-export-database.vala"
										g_warning (_ ("Unsupported type %s"), g_type_name (t));
#line 222 "rygel-media-export-database.vala"
										g_assert_not_reached ();
#line 658 "rygel-media-export-database.c"
									}
								}
							}
						}
					}
#line 224 "rygel-media-export-database.vala"
					if (rc != SQLITE_OK) {
#line 666 "rygel-media-export-database.c"
						_inner_error_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_DATABASE_ERROR, RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR, sqlite3_errmsg (self->priv->db));
						{
							if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
								g_propagate_error (error, _inner_error_);
								_sqlite3_finalize0 (statement);
								return NULL;
							} else {
								_sqlite3_finalize0 (statement);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
					}
				}
			}
		}
	}
	result = statement;
#line 230 "rygel-media-export-database.vala"
	return result;
#line 688 "rygel-media-export-database.c"
}


static void rygel_media_export_database_class_init (RygelMediaExportDatabaseClass * klass) {
	rygel_media_export_database_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaExportDatabasePrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_database_finalize;
}


static void rygel_media_export_database_instance_init (RygelMediaExportDatabase * self) {
	self->priv = RYGEL_MEDIA_EXPORT_DATABASE_GET_PRIVATE (self);
}


static void rygel_media_export_database_finalize (GObject* obj) {
	RygelMediaExportDatabase * self;
	self = RYGEL_MEDIA_EXPORT_DATABASE (obj);
	_sqlite3_close0 (self->priv->db);
	G_OBJECT_CLASS (rygel_media_export_database_parent_class)->finalize (obj);
}


/**
 * This class is a thin wrapper around SQLite's database object.
 *
 * It adds statement preparation based on GValue and a cancellable exec
 * function.
 */
GType rygel_media_export_database_get_type (void) {
	static volatile gsize rygel_media_export_database_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_database_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportDatabaseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_database_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportDatabase), 0, (GInstanceInitFunc) rygel_media_export_database_instance_init, NULL };
		GType rygel_media_export_database_type_id;
		rygel_media_export_database_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportDatabase", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_database_type_id__volatile, rygel_media_export_database_type_id);
	}
	return rygel_media_export_database_type_id__volatile;
}




