/* rygel-wma-transcoder.c generated by valac, the Vala compiler
 * generated from rygel-wma-transcoder.vala, do not modify */

/*
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include <libgupnp-av/gupnp-av.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;
typedef struct _RygelTranscoderPrivate RygelTranscoderPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_WMA_TRANSCODER (rygel_wma_transcoder_get_type ())
#define RYGEL_WMA_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WMA_TRANSCODER, RygelWMATranscoder))
#define RYGEL_WMA_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_WMA_TRANSCODER, RygelWMATranscoderClass))
#define RYGEL_IS_WMA_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WMA_TRANSCODER))
#define RYGEL_IS_WMA_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_WMA_TRANSCODER))
#define RYGEL_WMA_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_WMA_TRANSCODER, RygelWMATranscoderClass))

typedef struct _RygelWMATranscoder RygelWMATranscoder;
typedef struct _RygelWMATranscoderClass RygelWMATranscoderClass;
typedef struct _RygelWMATranscoderPrivate RygelWMATranscoderPrivate;

#define RYGEL_TYPE_WMA_TRANSCODER_BIN (rygel_wma_transcoder_bin_get_type ())
#define RYGEL_WMA_TRANSCODER_BIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WMA_TRANSCODER_BIN, RygelWMATranscoderBin))
#define RYGEL_WMA_TRANSCODER_BIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_WMA_TRANSCODER_BIN, RygelWMATranscoderBinClass))
#define RYGEL_IS_WMA_TRANSCODER_BIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WMA_TRANSCODER_BIN))
#define RYGEL_IS_WMA_TRANSCODER_BIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_WMA_TRANSCODER_BIN))
#define RYGEL_WMA_TRANSCODER_BIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_WMA_TRANSCODER_BIN, RygelWMATranscoderBinClass))

typedef struct _RygelWMATranscoderBin RygelWMATranscoderBin;
typedef struct _RygelWMATranscoderBinClass RygelWMATranscoderBinClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;

#define TYPE_ENDIANNESS (endianness_get_type ())

#define RYGEL_TYPE_L16_TRANSCODER (rygel_l16_transcoder_get_type ())
#define RYGEL_L16_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_L16_TRANSCODER, RygelL16Transcoder))
#define RYGEL_L16_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_L16_TRANSCODER, RygelL16TranscoderClass))
#define RYGEL_IS_L16_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_L16_TRANSCODER))
#define RYGEL_IS_L16_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_L16_TRANSCODER))
#define RYGEL_L16_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_L16_TRANSCODER, RygelL16TranscoderClass))

typedef struct _RygelL16Transcoder RygelL16Transcoder;
typedef struct _RygelL16TranscoderClass RygelL16TranscoderClass;
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))

struct _RygelTranscoder {
	GObject parent_instance;
	RygelTranscoderPrivate * priv;
};

struct _RygelTranscoderClass {
	GObjectClass parent_class;
	GstElement* (*create_source) (RygelTranscoder* self, RygelMediaItem* item, GstElement* src, GError** error);
	GUPnPDIDLLiteResource* (*add_resource) (RygelTranscoder* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
	guint (*get_distance) (RygelTranscoder* self, RygelMediaItem* item);
};

struct _RygelWMATranscoder {
	RygelTranscoder parent_instance;
	RygelWMATranscoderPrivate * priv;
};

struct _RygelWMATranscoderClass {
	RygelTranscoderClass parent_class;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	char* id;
	char* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const char* property);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	char* author;
	char* album;
	char* date;
	char* mime_type;
	char* dlna_profile;
	glong size;
	glong duration;
	gint bitrate;
	gint sample_freq;
	gint bits_per_sample;
	gint n_audio_channels;
	gint track_number;
	gint width;
	gint height;
	gint pixel_width;
	gint pixel_height;
	gint color_depth;
	GeeArrayList* thumbnails;
	GeeArrayList* subtitles;
	gboolean place_holder;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self);
	gboolean (*should_stream) (RygelMediaItem* self);
};

typedef enum  {
	ENDIANNESS_LITTLE = G_LITTLE_ENDIAN,
	ENDIANNESS_BIG = G_BIG_ENDIAN
} Endianness;


static gpointer rygel_wma_transcoder_parent_class = NULL;

GType rygel_transcoder_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_wma_transcoder_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_WMA_TRANSCODER_DUMMY_PROPERTY
};
#define RYGEL_WMA_TRANSCODER_BITRATE 64
#define RYGEL_WMA_TRANSCODER_CONVERT_SINK_PAD "convert-sink-pad"
#define RYGEL_MEDIA_ITEM_AUDIO_CLASS "object.item.audioItem"
RygelTranscoder* rygel_transcoder_construct (GType object_type, const char* mime_type, const char* dlna_profile, const char* upnp_class);
RygelWMATranscoder* rygel_wma_transcoder_new (void);
RygelWMATranscoder* rygel_wma_transcoder_construct (GType object_type);
RygelWMATranscoderBin* rygel_wma_transcoder_bin_new (RygelMediaItem* item, GstElement* src, RygelWMATranscoder* transcoder, GError** error);
RygelWMATranscoderBin* rygel_wma_transcoder_bin_construct (GType object_type, RygelMediaItem* item, GstElement* src, RygelWMATranscoder* transcoder, GError** error);
GType rygel_wma_transcoder_bin_get_type (void) G_GNUC_CONST;
static GstElement* rygel_wma_transcoder_real_create_source (RygelTranscoder* base, RygelMediaItem* item, GstElement* src, GError** error);
GUPnPDIDLLiteResource* rygel_transcoder_add_resource (RygelTranscoder* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
static GUPnPDIDLLiteResource* rygel_wma_transcoder_real_add_resource (RygelTranscoder* base, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
GType rygel_media_container_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_ITEM_IMAGE_CLASS "object.item.imageItem"
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
gpointer rygel_subtitle_ref (gpointer instance);
void rygel_subtitle_unref (gpointer instance);
GParamSpec* rygel_param_spec_subtitle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_subtitle (GValue* value, gpointer v_object);
void rygel_value_take_subtitle (GValue* value, gpointer v_object);
gpointer rygel_value_get_subtitle (const GValue* value);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
static guint rygel_wma_transcoder_real_get_distance (RygelTranscoder* base, RygelMediaItem* item);
GType endianness_get_type (void) G_GNUC_CONST;
RygelL16Transcoder* rygel_l16_transcoder_new (Endianness endianness);
RygelL16Transcoder* rygel_l16_transcoder_construct (GType object_type, Endianness endianness);
GType rygel_l16_transcoder_get_type (void) G_GNUC_CONST;
GstElement* rygel_l16_transcoder_create_encoder (RygelL16Transcoder* self, RygelMediaItem* item, const char* src_pad_name, const char* sink_pad_name, GError** error);
GstElement* rygel_gst_utils_create_element (const char* factoryname, const char* name, GError** error);
static inline void _dynamic_set_bitrate7 (GstElement* obj, gint value);
GstElement* rygel_wma_transcoder_create_encoder (RygelWMATranscoder* self, RygelMediaItem* item, const char* src_pad_name, const char* sink_pad_name, GError** error);



#line 30 "rygel-wma-transcoder.vala"
RygelWMATranscoder* rygel_wma_transcoder_construct (GType object_type) {
#line 280 "rygel-wma-transcoder.c"
	RygelWMATranscoder * self;
#line 31 "rygel-wma-transcoder.vala"
	self = (RygelWMATranscoder*) rygel_transcoder_construct (object_type, "audio/x-wma", "WMA", RYGEL_MEDIA_ITEM_AUDIO_CLASS);
#line 284 "rygel-wma-transcoder.c"
	return self;
}


#line 30 "rygel-wma-transcoder.vala"
RygelWMATranscoder* rygel_wma_transcoder_new (void) {
#line 30 "rygel-wma-transcoder.vala"
	return rygel_wma_transcoder_construct (RYGEL_TYPE_WMA_TRANSCODER);
#line 293 "rygel-wma-transcoder.c"
}


#line 34 "rygel-wma-transcoder.vala"
static GstElement* rygel_wma_transcoder_real_create_source (RygelTranscoder* base, RygelMediaItem* item, GstElement* src, GError** error) {
#line 299 "rygel-wma-transcoder.c"
	RygelWMATranscoder * self;
	GstElement* result = NULL;
	GError * _inner_error_;
	RygelWMATranscoderBin* _tmp0_;
	self = (RygelWMATranscoder*) base;
#line 34 "rygel-wma-transcoder.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 34 "rygel-wma-transcoder.vala"
	g_return_val_if_fail (src != NULL, NULL);
#line 309 "rygel-wma-transcoder.c"
	_inner_error_ = NULL;
#line 37 "rygel-wma-transcoder.vala"
	_tmp0_ = rygel_wma_transcoder_bin_new (item, src, self, &_inner_error_);
#line 313 "rygel-wma-transcoder.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = (GstElement*) _tmp0_;
#line 37 "rygel-wma-transcoder.vala"
	return result;
#line 321 "rygel-wma-transcoder.c"
}


#line 40 "rygel-wma-transcoder.vala"
static GUPnPDIDLLiteResource* rygel_wma_transcoder_real_add_resource (RygelTranscoder* base, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error) {
#line 327 "rygel-wma-transcoder.c"
	RygelWMATranscoder * self;
	GUPnPDIDLLiteResource* result = NULL;
	GError * _inner_error_;
	GUPnPDIDLLiteResource* resource;
	self = (RygelWMATranscoder*) base;
#line 40 "rygel-wma-transcoder.vala"
	g_return_val_if_fail (didl_item != NULL, NULL);
#line 40 "rygel-wma-transcoder.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 40 "rygel-wma-transcoder.vala"
	g_return_val_if_fail (manager != NULL, NULL);
#line 339 "rygel-wma-transcoder.c"
	_inner_error_ = NULL;
#line 44 "rygel-wma-transcoder.vala"
	resource = RYGEL_TRANSCODER_CLASS (rygel_wma_transcoder_parent_class)->add_resource (RYGEL_TRANSCODER (self), didl_item, item, manager, &_inner_error_);
#line 343 "rygel-wma-transcoder.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
#line 45 "rygel-wma-transcoder.vala"
	if (resource == NULL) {
#line 350 "rygel-wma-transcoder.c"
		result = NULL;
		_g_object_unref0 (resource);
#line 46 "rygel-wma-transcoder.vala"
		return result;
#line 355 "rygel-wma-transcoder.c"
	}
#line 49 "rygel-wma-transcoder.vala"
	gupnp_didl_lite_resource_set_bitrate (resource, (RYGEL_WMA_TRANSCODER_BITRATE * 1000) / 8);
#line 359 "rygel-wma-transcoder.c"
	result = resource;
#line 51 "rygel-wma-transcoder.vala"
	return result;
#line 363 "rygel-wma-transcoder.c"
}


#line 54 "rygel-wma-transcoder.vala"
static guint rygel_wma_transcoder_real_get_distance (RygelTranscoder* base, RygelMediaItem* item) {
#line 369 "rygel-wma-transcoder.c"
	RygelWMATranscoder * self;
	guint result = 0U;
	guint distance = 0U;
	self = (RygelWMATranscoder*) base;
#line 54 "rygel-wma-transcoder.vala"
	g_return_val_if_fail (item != NULL, 0U);
#line 55 "rygel-wma-transcoder.vala"
	if (g_str_has_prefix (((RygelMediaObject*) item)->upnp_class, RYGEL_MEDIA_ITEM_IMAGE_CLASS)) {
#line 378 "rygel-wma-transcoder.c"
		result = G_MAXUINT;
#line 56 "rygel-wma-transcoder.vala"
		return result;
#line 382 "rygel-wma-transcoder.c"
	}
#line 61 "rygel-wma-transcoder.vala"
	if (g_str_has_prefix (((RygelMediaObject*) item)->upnp_class, RYGEL_MEDIA_ITEM_AUDIO_CLASS)) {
#line 62 "rygel-wma-transcoder.vala"
		distance = 0;
#line 64 "rygel-wma-transcoder.vala"
		if (item->bitrate > 0) {
#line 65 "rygel-wma-transcoder.vala"
			distance = distance + ((guint) abs (item->bitrate - RYGEL_WMA_TRANSCODER_BITRATE));
#line 392 "rygel-wma-transcoder.c"
		}
	} else {
#line 68 "rygel-wma-transcoder.vala"
		distance = G_MAXUINT / 2;
#line 397 "rygel-wma-transcoder.c"
	}
	result = distance;
#line 71 "rygel-wma-transcoder.vala"
	return result;
#line 402 "rygel-wma-transcoder.c"
}


static inline void _dynamic_set_bitrate7 (GstElement* obj, gint value) {
	g_object_set (obj, "bitrate", value, NULL);
}


static gpointer _gst_object_ref0 (gpointer self) {
	return self ? gst_object_ref (self) : NULL;
}


#line 74 "rygel-wma-transcoder.vala"
GstElement* rygel_wma_transcoder_create_encoder (RygelWMATranscoder* self, RygelMediaItem* item, const char* src_pad_name, const char* sink_pad_name, GError** error) {
#line 418 "rygel-wma-transcoder.c"
	GstElement* result = NULL;
	GError * _inner_error_;
	RygelL16Transcoder* l16_transcoder;
	GstElement* convert;
	GstElement* encoder;
	GstBin* bin;
	GstPad* pad;
	GstGhostPad* ghost;
	GstPad* _tmp0_;
	GstGhostPad* _tmp1_;
#line 74 "rygel-wma-transcoder.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 74 "rygel-wma-transcoder.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 433 "rygel-wma-transcoder.c"
	_inner_error_ = NULL;
#line 78 "rygel-wma-transcoder.vala"
	l16_transcoder = rygel_l16_transcoder_new (ENDIANNESS_LITTLE);
#line 79 "rygel-wma-transcoder.vala"
	convert = rygel_l16_transcoder_create_encoder (l16_transcoder, item, NULL, RYGEL_WMA_TRANSCODER_CONVERT_SINK_PAD, &_inner_error_);
#line 439 "rygel-wma-transcoder.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (l16_transcoder);
		return NULL;
	}
#line 84 "rygel-wma-transcoder.vala"
	encoder = rygel_gst_utils_create_element ("ffenc_wmav2", "ffenc_wmav2", &_inner_error_);
#line 447 "rygel-wma-transcoder.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_gst_object_unref0 (convert);
		_g_object_unref0 (l16_transcoder);
		return NULL;
	}
#line 86 "rygel-wma-transcoder.vala"
	_dynamic_set_bitrate7 (encoder, RYGEL_WMA_TRANSCODER_BITRATE * 1000);
#line 88 "rygel-wma-transcoder.vala"
	bin = (GstBin*) gst_bin_new ("wma-encoder-bin");
#line 89 "rygel-wma-transcoder.vala"
	gst_bin_add_many (bin, _gst_object_ref0 (convert), _gst_object_ref0 (encoder), NULL);
#line 90 "rygel-wma-transcoder.vala"
	gst_element_link (convert, encoder);
#line 92 "rygel-wma-transcoder.vala"
	pad = gst_element_get_static_pad (convert, RYGEL_WMA_TRANSCODER_CONVERT_SINK_PAD);
#line 93 "rygel-wma-transcoder.vala"
	ghost = (GstGhostPad*) gst_ghost_pad_new (sink_pad_name, pad);
#line 94 "rygel-wma-transcoder.vala"
	gst_element_add_pad ((GstElement*) bin, _gst_object_ref0 ((GstPad*) ghost));
#line 96 "rygel-wma-transcoder.vala"
	pad = (_tmp0_ = gst_element_get_static_pad (encoder, "src"), _gst_object_unref0 (pad), _tmp0_);
#line 97 "rygel-wma-transcoder.vala"
	ghost = (_tmp1_ = (GstGhostPad*) gst_ghost_pad_new (src_pad_name, pad), _gst_object_unref0 (ghost), _tmp1_);
#line 98 "rygel-wma-transcoder.vala"
	gst_element_add_pad ((GstElement*) bin, _gst_object_ref0 ((GstPad*) ghost));
#line 474 "rygel-wma-transcoder.c"
	result = (GstElement*) bin;
	_gst_object_unref0 (ghost);
	_gst_object_unref0 (pad);
	_gst_object_unref0 (encoder);
	_gst_object_unref0 (convert);
	_g_object_unref0 (l16_transcoder);
#line 100 "rygel-wma-transcoder.vala"
	return result;
#line 483 "rygel-wma-transcoder.c"
}


static void rygel_wma_transcoder_class_init (RygelWMATranscoderClass * klass) {
	rygel_wma_transcoder_parent_class = g_type_class_peek_parent (klass);
	RYGEL_TRANSCODER_CLASS (klass)->create_source = rygel_wma_transcoder_real_create_source;
	RYGEL_TRANSCODER_CLASS (klass)->add_resource = rygel_wma_transcoder_real_add_resource;
	RYGEL_TRANSCODER_CLASS (klass)->get_distance = rygel_wma_transcoder_real_get_distance;
}


static void rygel_wma_transcoder_instance_init (RygelWMATranscoder * self) {
}


GType rygel_wma_transcoder_get_type (void) {
	static volatile gsize rygel_wma_transcoder_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_wma_transcoder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelWMATranscoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_wma_transcoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelWMATranscoder), 0, (GInstanceInitFunc) rygel_wma_transcoder_instance_init, NULL };
		GType rygel_wma_transcoder_type_id;
		rygel_wma_transcoder_type_id = g_type_register_static (RYGEL_TYPE_TRANSCODER, "RygelWMATranscoder", &g_define_type_info, 0);
		g_once_init_leave (&rygel_wma_transcoder_type_id__volatile, rygel_wma_transcoder_type_id);
	}
	return rygel_wma_transcoder_type_id__volatile;
}




