/* rygel-media-objects.c generated by valac, the Vala compiler
 * generated from rygel-media-objects.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;
typedef struct _RygelMediaObjectsPrivate RygelMediaObjectsPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block3Data Block3Data;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelMediaObjects {
	GeeArrayList parent_instance;
	RygelMediaObjectsPrivate * priv;
};

struct _RygelMediaObjectsClass {
	GeeArrayListClass parent_class;
};

struct _Block3Data {
	int _ref_count_;
	RygelMediaObjects * self;
	char** sort_props;
	gint sort_props_length1;
	gint _sort_props_size_;
};


static gpointer rygel_media_objects_parent_class = NULL;

GType rygel_media_objects_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MEDIA_OBJECTS_DUMMY_PROPERTY
};
#define RYGEL_MEDIA_OBJECTS_SORT_CAPS "@id,@parentID,dc:title,upnp:class," "dc:artist,dc:author,upnp:album,dc:date"
GType rygel_media_object_get_type (void) G_GNUC_CONST;
RygelMediaObjects* rygel_media_objects_new (void);
RygelMediaObjects* rygel_media_objects_construct (GType object_type);
static GeeList* rygel_media_objects_real_slice (GeeAbstractList* base, gint start, gint stop);
static gint rygel_media_objects_compare_media_objects (RygelMediaObjects* self, RygelMediaObject* a, RygelMediaObject* b, char** sort_props, int sort_props_length1);
static gint _lambda0_ (void* a, void* b, Block3Data* _data3_);
static gint __lambda0__gcompare_data_func (void* a, void* b, gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
void rygel_media_objects_sort_by_criteria (RygelMediaObjects* self, const char* sort_criteria);
gint rygel_media_object_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const char* property);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);



#line 32 "rygel-media-objects.vala"
static GeeList* rygel_media_objects_real_slice (GeeAbstractList* base, gint start, gint stop) {
#line 102 "rygel-media-objects.c"
	RygelMediaObjects * self;
	GeeList* result = NULL;
	GeeList* slice;
	RygelMediaObjects* ret;
	self = (RygelMediaObjects*) base;
#line 33 "rygel-media-objects.vala"
	slice = GEE_ABSTRACT_LIST_CLASS (rygel_media_objects_parent_class)->slice ((GeeAbstractList*) GEE_ARRAY_LIST (self), start, stop);
#line 34 "rygel-media-objects.vala"
	ret = rygel_media_objects_new ();
#line 36 "rygel-media-objects.vala"
	gee_abstract_collection_add_all ((GeeAbstractCollection*) ret, (GeeCollection*) slice);
#line 114 "rygel-media-objects.c"
	result = (GeeList*) ret;
	_g_object_unref0 (slice);
#line 38 "rygel-media-objects.vala"
	return result;
#line 119 "rygel-media-objects.c"
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 47 "rygel-media-objects.vala"
static gint _lambda0_ (void* a, void* b, Block3Data* _data3_) {
#line 130 "rygel-media-objects.c"
	RygelMediaObjects * self;
	gint result = 0;
	void* _tmp0_;
	RygelMediaObject* object_a;
	void* _tmp1_;
	RygelMediaObject* object_b;
	self = _data3_->self;
#line 48 "rygel-media-objects.vala"
	object_a = _g_object_ref0 ((_tmp0_ = a, RYGEL_IS_MEDIA_OBJECT (_tmp0_) ? ((RygelMediaObject*) _tmp0_) : NULL));
#line 49 "rygel-media-objects.vala"
	object_b = _g_object_ref0 ((_tmp1_ = b, RYGEL_IS_MEDIA_OBJECT (_tmp1_) ? ((RygelMediaObject*) _tmp1_) : NULL));
#line 142 "rygel-media-objects.c"
	result = rygel_media_objects_compare_media_objects (self, object_a, object_b, _data3_->sort_props, _data3_->sort_props_length1);
	_g_object_unref0 (object_b);
	_g_object_unref0 (object_a);
#line 51 "rygel-media-objects.vala"
	return result;
#line 148 "rygel-media-objects.c"
}


#line 47 "rygel-media-objects.vala"
static gint __lambda0__gcompare_data_func (void* a, void* b, gpointer self) {
#line 154 "rygel-media-objects.c"
	gint result;
	result = _lambda0_ (a, b, self);
	return result;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->self);
		_data3_->sort_props = (_vala_array_free (_data3_->sort_props, _data3_->sort_props_length1, (GDestroyNotify) g_free), NULL);
		g_slice_free (Block3Data, _data3_);
	}
}


#line 41 "rygel-media-objects.vala"
void rygel_media_objects_sort_by_criteria (RygelMediaObjects* self, const char* sort_criteria) {
#line 178 "rygel-media-objects.c"
	Block3Data* _data3_;
	char** _tmp1_;
	char** _tmp0_;
#line 41 "rygel-media-objects.vala"
	g_return_if_fail (self != NULL);
#line 41 "rygel-media-objects.vala"
	g_return_if_fail (sort_criteria != NULL);
#line 186 "rygel-media-objects.c"
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_data3_->sort_props = (_tmp1_ = _tmp0_ = g_strsplit (sort_criteria, ",", 0), _data3_->sort_props_length1 = _vala_array_length (_tmp0_), _tmp1_);
#line 43 "rygel-media-objects.vala"
	if (_data3_->sort_props_length1 == 0) {
#line 193 "rygel-media-objects.c"
		block3_data_unref (_data3_);
#line 44 "rygel-media-objects.vala"
		return;
#line 197 "rygel-media-objects.c"
	}
#line 47 "rygel-media-objects.vala"
	gee_array_list_sort_with_data ((GeeArrayList*) self, __lambda0__gcompare_data_func, _data3_);
#line 201 "rygel-media-objects.c"
	block3_data_unref (_data3_);
}


#line 1085 "glib-2.0.vapi"
static char* string_substring (const char* self, glong offset, glong len) {
#line 208 "rygel-media-objects.c"
	char* result = NULL;
	glong string_length;
	const char* start;
#line 1085 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1086 "glib-2.0.vapi"
	string_length = g_utf8_strlen (self, -1);
#line 1087 "glib-2.0.vapi"
	if (offset < 0) {
#line 1088 "glib-2.0.vapi"
		offset = string_length + offset;
#line 1089 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= 0, NULL);
#line 222 "rygel-media-objects.c"
	} else {
#line 1091 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= string_length, NULL);
#line 226 "rygel-media-objects.c"
	}
#line 1093 "glib-2.0.vapi"
	if (len < 0) {
#line 1094 "glib-2.0.vapi"
		len = string_length - offset;
#line 232 "rygel-media-objects.c"
	}
#line 1096 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
#line 1097 "glib-2.0.vapi"
	start = g_utf8_offset_to_pointer (self, offset);
#line 238 "rygel-media-objects.c"
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
#line 1098 "glib-2.0.vapi"
	return result;
#line 242 "rygel-media-objects.c"
}


#line 55 "rygel-media-objects.vala"
static gint rygel_media_objects_compare_media_objects (RygelMediaObjects* self, RygelMediaObject* a, RygelMediaObject* b, char** sort_props, int sort_props_length1) {
#line 248 "rygel-media-objects.c"
	gint result = 0;
	gint i = 0;
	gint ret;
#line 55 "rygel-media-objects.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 55 "rygel-media-objects.vala"
	g_return_val_if_fail (a != NULL, 0);
#line 55 "rygel-media-objects.vala"
	g_return_val_if_fail (b != NULL, 0);
#line 59 "rygel-media-objects.vala"
	ret = 0;
#line 260 "rygel-media-objects.c"
	{
		gboolean _tmp0_;
#line 61 "rygel-media-objects.vala"
		i = 0;
#line 61 "rygel-media-objects.vala"
		_tmp0_ = TRUE;
#line 61 "rygel-media-objects.vala"
		while (TRUE) {
#line 269 "rygel-media-objects.c"
			gboolean _tmp1_ = FALSE;
			char* property;
#line 61 "rygel-media-objects.vala"
			if (!_tmp0_) {
#line 61 "rygel-media-objects.vala"
				i++;
#line 276 "rygel-media-objects.c"
			}
#line 61 "rygel-media-objects.vala"
			_tmp0_ = FALSE;
#line 61 "rygel-media-objects.vala"
			if (ret == 0) {
#line 61 "rygel-media-objects.vala"
				_tmp1_ = i < sort_props_length1;
#line 284 "rygel-media-objects.c"
			} else {
#line 61 "rygel-media-objects.vala"
				_tmp1_ = FALSE;
#line 288 "rygel-media-objects.c"
			}
#line 61 "rygel-media-objects.vala"
			if (!_tmp1_) {
#line 61 "rygel-media-objects.vala"
				break;
#line 294 "rygel-media-objects.c"
			}
#line 62 "rygel-media-objects.vala"
			property = string_substring (sort_props[i], (glong) 1, -1);
#line 64 "rygel-media-objects.vala"
			ret = rygel_media_object_compare_by_property (a, b, property);
#line 66 "rygel-media-objects.vala"
			if (g_utf8_get_char (g_utf8_offset_to_pointer (sort_props[i], 0)) == '-') {
#line 68 "rygel-media-objects.vala"
				ret = 0 - ret;
#line 304 "rygel-media-objects.c"
			}
			_g_free0 (property);
		}
	}
	result = ret;
#line 72 "rygel-media-objects.vala"
	return result;
#line 312 "rygel-media-objects.c"
}


#line 28 "rygel-media-objects.vala"
RygelMediaObjects* rygel_media_objects_construct (GType object_type) {
#line 318 "rygel-media-objects.c"
	RygelMediaObjects * self;
#line 28 "rygel-media-objects.vala"
	self = (RygelMediaObjects*) gee_array_list_construct (object_type, RYGEL_TYPE_MEDIA_OBJECT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
#line 322 "rygel-media-objects.c"
	return self;
}


#line 28 "rygel-media-objects.vala"
RygelMediaObjects* rygel_media_objects_new (void) {
#line 28 "rygel-media-objects.vala"
	return rygel_media_objects_construct (RYGEL_TYPE_MEDIA_OBJECTS);
#line 331 "rygel-media-objects.c"
}


static void rygel_media_objects_class_init (RygelMediaObjectsClass * klass) {
	rygel_media_objects_parent_class = g_type_class_peek_parent (klass);
	GEE_ABSTRACT_LIST_CLASS (klass)->slice = rygel_media_objects_real_slice;
}


static void rygel_media_objects_instance_init (RygelMediaObjects * self) {
}


GType rygel_media_objects_get_type (void) {
	static volatile gsize rygel_media_objects_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_objects_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaObjectsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_objects_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaObjects), 0, (GInstanceInitFunc) rygel_media_objects_instance_init, NULL };
		GType rygel_media_objects_type_id;
		rygel_media_objects_type_id = g_type_register_static (GEE_TYPE_ARRAY_LIST, "RygelMediaObjects", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_objects_type_id__volatile, rygel_media_objects_type_id);
	}
	return rygel_media_objects_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}




