/* rygel-gst-launch-item.c generated by valac, the Vala compiler
 * generated from rygel-gst-launch-item.vala, do not modify */

/*
 * Copyright (C) 2009 Thijs Vermeir <thijsvermeir@gmail.com>
 *
 * Author: Thijs Vermeir <thijsvermeir@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>


#define RYGEL_GST_LAUNCH_TYPE_ITEM (rygel_gst_launch_item_get_type ())
#define RYGEL_GST_LAUNCH_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_GST_LAUNCH_TYPE_ITEM, RygelGstLaunchItem))
#define RYGEL_GST_LAUNCH_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_GST_LAUNCH_TYPE_ITEM, RygelGstLaunchItemClass))
#define RYGEL_GST_LAUNCH_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_GST_LAUNCH_TYPE_ITEM))
#define RYGEL_GST_LAUNCH_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_GST_LAUNCH_TYPE_ITEM))
#define RYGEL_GST_LAUNCH_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_GST_LAUNCH_TYPE_ITEM, RygelGstLaunchItemClass))

typedef struct _RygelGstLaunchItem RygelGstLaunchItem;
typedef struct _RygelGstLaunchItemClass RygelGstLaunchItemClass;
typedef struct _RygelGstLaunchItemPrivate RygelGstLaunchItemPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelGstLaunchItem {
	RygelMediaItem parent_instance;
	RygelGstLaunchItemPrivate * priv;
};

struct _RygelGstLaunchItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelGstLaunchItemPrivate {
	char* launch_line;
};


static gpointer rygel_gst_launch_item_parent_class = NULL;

GType rygel_gst_launch_item_get_type (void) G_GNUC_CONST;
#define RYGEL_GST_LAUNCH_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_GST_LAUNCH_TYPE_ITEM, RygelGstLaunchItemPrivate))
enum  {
	RYGEL_GST_LAUNCH_ITEM_DUMMY_PROPERTY
};
RygelGstLaunchItem* rygel_gst_launch_item_new (const char* id, RygelMediaContainer* parent, const char* title, const char* mime_type, const char* launch_line);
RygelGstLaunchItem* rygel_gst_launch_item_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title, const char* mime_type, const char* launch_line);
static GstElement* rygel_gst_launch_item_real_create_stream_source (RygelMediaItem* base);
static void rygel_gst_launch_item_finalize (GObject* obj);



#line 34 "rygel-gst-launch-item.vala"
RygelGstLaunchItem* rygel_gst_launch_item_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title, const char* mime_type, const char* launch_line) {
#line 78 "rygel-gst-launch-item.c"
	RygelGstLaunchItem * self;
	char* upnp_class;
	char* _tmp2_;
	char* _tmp3_;
#line 34 "rygel-gst-launch-item.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 34 "rygel-gst-launch-item.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 34 "rygel-gst-launch-item.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 34 "rygel-gst-launch-item.vala"
	g_return_val_if_fail (mime_type != NULL, NULL);
#line 34 "rygel-gst-launch-item.vala"
	g_return_val_if_fail (launch_line != NULL, NULL);
#line 93 "rygel-gst-launch-item.c"
	upnp_class = NULL;
#line 41 "rygel-gst-launch-item.vala"
	if (g_str_has_prefix (mime_type, "audio")) {
#line 97 "rygel-gst-launch-item.c"
		char* _tmp0_;
#line 42 "rygel-gst-launch-item.vala"
		upnp_class = (_tmp0_ = g_strdup (RYGEL_MEDIA_ITEM_AUDIO_CLASS), _g_free0 (upnp_class), _tmp0_);
#line 101 "rygel-gst-launch-item.c"
	} else {
		char* _tmp1_;
#line 44 "rygel-gst-launch-item.vala"
		upnp_class = (_tmp1_ = g_strdup (RYGEL_MEDIA_ITEM_VIDEO_CLASS), _g_free0 (upnp_class), _tmp1_);
#line 106 "rygel-gst-launch-item.c"
	}
#line 47 "rygel-gst-launch-item.vala"
	self = (RygelGstLaunchItem*) rygel_media_item_construct (object_type, id, parent, title, upnp_class);
#line 49 "rygel-gst-launch-item.vala"
	((RygelMediaItem*) self)->mime_type = (_tmp2_ = g_strdup (mime_type), _g_free0 (((RygelMediaItem*) self)->mime_type), _tmp2_);
#line 50 "rygel-gst-launch-item.vala"
	self->priv->launch_line = (_tmp3_ = g_strdup (launch_line), _g_free0 (self->priv->launch_line), _tmp3_);
#line 114 "rygel-gst-launch-item.c"
	_g_free0 (upnp_class);
	return self;
}


#line 34 "rygel-gst-launch-item.vala"
RygelGstLaunchItem* rygel_gst_launch_item_new (const char* id, RygelMediaContainer* parent, const char* title, const char* mime_type, const char* launch_line) {
#line 34 "rygel-gst-launch-item.vala"
	return rygel_gst_launch_item_construct (RYGEL_GST_LAUNCH_TYPE_ITEM, id, parent, title, mime_type, launch_line);
#line 124 "rygel-gst-launch-item.c"
}


#line 53 "rygel-gst-launch-item.vala"
static GstElement* rygel_gst_launch_item_real_create_stream_source (RygelMediaItem* base) {
#line 130 "rygel-gst-launch-item.c"
	RygelGstLaunchItem * self;
	GstElement* result = NULL;
	GError * _inner_error_;
	self = (RygelGstLaunchItem*) base;
	_inner_error_ = NULL;
	{
		GstElement* _tmp0_;
#line 55 "rygel-gst-launch-item.vala"
		_tmp0_ = gst_parse_bin_from_description (self->priv->launch_line, TRUE, &_inner_error_);
#line 140 "rygel-gst-launch-item.c"
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		result = _tmp0_;
#line 55 "rygel-gst-launch-item.vala"
		return result;
#line 147 "rygel-gst-launch-item.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
#line 57 "rygel-gst-launch-item.vala"
			g_warning ("rygel-gst-launch-item.vala:57: parse launchline failed: %s", err->message);
#line 158 "rygel-gst-launch-item.c"
			result = NULL;
			_g_error_free0 (err);
#line 58 "rygel-gst-launch-item.vala"
			return result;
#line 163 "rygel-gst-launch-item.c"
		}
	}
	__finally2:
	{
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void rygel_gst_launch_item_class_init (RygelGstLaunchItemClass * klass) {
	rygel_gst_launch_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelGstLaunchItemPrivate));
	RYGEL_MEDIA_ITEM_CLASS (klass)->create_stream_source = rygel_gst_launch_item_real_create_stream_source;
	G_OBJECT_CLASS (klass)->finalize = rygel_gst_launch_item_finalize;
}


static void rygel_gst_launch_item_instance_init (RygelGstLaunchItem * self) {
	self->priv = RYGEL_GST_LAUNCH_ITEM_GET_PRIVATE (self);
}


static void rygel_gst_launch_item_finalize (GObject* obj) {
	RygelGstLaunchItem * self;
	self = RYGEL_GST_LAUNCH_ITEM (obj);
	_g_free0 (self->priv->launch_line);
	G_OBJECT_CLASS (rygel_gst_launch_item_parent_class)->finalize (obj);
}


GType rygel_gst_launch_item_get_type (void) {
	static volatile gsize rygel_gst_launch_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_gst_launch_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelGstLaunchItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_gst_launch_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelGstLaunchItem), 0, (GInstanceInitFunc) rygel_gst_launch_item_instance_init, NULL };
		GType rygel_gst_launch_item_type_id;
		rygel_gst_launch_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_ITEM, "RygelGstLaunchItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_gst_launch_item_type_id__volatile, rygel_gst_launch_item_type_id);
	}
	return rygel_gst_launch_item_type_id__volatile;
}




