/* rygel-relational-expression.c generated by valac, the Vala compiler
 * generated from rygel-relational-expression.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gst/gst.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;
typedef struct _RygelSearchExpressionPrivate RygelSearchExpressionPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_RELATIONAL_EXPRESSION (rygel_relational_expression_get_type ())
#define RYGEL_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpression))
#define RYGEL_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))
#define RYGEL_IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))

typedef struct _RygelRelationalExpression RygelRelationalExpression;
typedef struct _RygelRelationalExpressionClass RygelRelationalExpressionClass;
typedef struct _RygelRelationalExpressionPrivate RygelRelationalExpressionPrivate;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelSearchExpression {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSearchExpressionPrivate * priv;
	gpointer op;
	gpointer operand1;
	gpointer operand2;
};

struct _RygelSearchExpressionClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSearchExpression *self);
	gboolean (*satisfied_by) (RygelSearchExpression* self, RygelMediaObject* media_object);
	char* (*to_string) (RygelSearchExpression* self);
};

struct _RygelRelationalExpression {
	RygelSearchExpression parent_instance;
	RygelRelationalExpressionPrivate * priv;
};

struct _RygelRelationalExpressionClass {
	RygelSearchExpressionClass parent_class;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	char* id;
	char* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	char* author;
	char* album;
	char* date;
	char* mime_type;
	char* dlna_profile;
	glong size;
	glong duration;
	gint bitrate;
	gint sample_freq;
	gint bits_per_sample;
	gint n_audio_channels;
	gint track_number;
	gint width;
	gint height;
	gint pixel_width;
	gint pixel_height;
	gint color_depth;
	GeeArrayList* thumbnails;
	GeeArrayList* subtitles;
	gboolean place_holder;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self);
	gboolean (*should_stream) (RygelMediaItem* self);
};


static gpointer rygel_relational_expression_parent_class = NULL;

gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void);
GType rygel_media_object_get_type (void);
GType rygel_relational_expression_get_type (void);
enum  {
	RYGEL_RELATIONAL_EXPRESSION_DUMMY_PROPERTY
};
gboolean rygel_relational_expression_compare_string (RygelRelationalExpression* self, const char* str);
GType rygel_media_container_get_type (void);
const char* rygel_media_object_get_title (RygelMediaObject* self);
GType rygel_media_item_get_type (void);
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void);
GType rygel_thumbnail_get_type (void);
gpointer rygel_subtitle_ref (gpointer instance);
void rygel_subtitle_unref (gpointer instance);
GParamSpec* rygel_param_spec_subtitle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_subtitle (GValue* value, gpointer v_object);
void rygel_value_take_subtitle (GValue* value, gpointer v_object);
gpointer rygel_value_get_subtitle (const GValue* value);
GType rygel_subtitle_get_type (void);
static gboolean rygel_relational_expression_compare_resource (RygelRelationalExpression* self, RygelMediaObject* media_object);
static gboolean rygel_relational_expression_real_satisfied_by (RygelSearchExpression* base, RygelMediaObject* media_object);
static char* rygel_relational_expression_real_to_string (RygelSearchExpression* base);
RygelSearchExpression* rygel_search_expression_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GType h_type, GBoxedCopyFunc h_dup_func, GDestroyNotify h_destroy_func, GType i_type, GBoxedCopyFunc i_dup_func, GDestroyNotify i_destroy_func);
RygelRelationalExpression* rygel_relational_expression_new (void);
RygelRelationalExpression* rygel_relational_expression_construct (GType object_type);
static int _vala_strcmp0 (const char * str1, const char * str2);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 29 "rygel-relational-expression.vala"
static gboolean rygel_relational_expression_real_satisfied_by (RygelSearchExpression* base, RygelMediaObject* media_object) {
#line 243 "rygel-relational-expression.c"
	RygelRelationalExpression * self;
	gboolean result = FALSE;
	GQuark _tmp2_;
	const char* _tmp1_;
	static GQuark _tmp2__label0 = 0;
	static GQuark _tmp2__label1 = 0;
	static GQuark _tmp2__label2 = 0;
	static GQuark _tmp2__label3 = 0;
	static GQuark _tmp2__label4 = 0;
	static GQuark _tmp2__label5 = 0;
	self = (RygelRelationalExpression*) base;
#line 29 "rygel-relational-expression.vala"
	g_return_val_if_fail (media_object != NULL, FALSE);
#line 257 "rygel-relational-expression.c"
	_tmp1_ = (const char*) ((RygelSearchExpression*) self)->operand1;
	_tmp2_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp2_ == ((0 != _tmp2__label0) ? _tmp2__label0 : (_tmp2__label0 = g_quark_from_static_string ("@id"))))
	switch (0) {
		default:
		{
			result = rygel_relational_expression_compare_string (self, media_object->id);
#line 32 "rygel-relational-expression.vala"
			return result;
#line 267 "rygel-relational-expression.c"
		}
	} else if (_tmp2_ == ((0 != _tmp2__label1) ? _tmp2__label1 : (_tmp2__label1 = g_quark_from_static_string ("@parentID"))))
	switch (0) {
		default:
		{
			result = rygel_relational_expression_compare_string (self, ((RygelMediaObject*) media_object->parent)->id);
#line 34 "rygel-relational-expression.vala"
			return result;
#line 276 "rygel-relational-expression.c"
		}
	} else if (_tmp2_ == ((0 != _tmp2__label2) ? _tmp2__label2 : (_tmp2__label2 = g_quark_from_static_string ("@refID"))))
	switch (0) {
		default:
		{
			result = FALSE;
#line 36 "rygel-relational-expression.vala"
			return result;
#line 285 "rygel-relational-expression.c"
		}
	} else if (_tmp2_ == ((0 != _tmp2__label3) ? _tmp2__label3 : (_tmp2__label3 = g_quark_from_static_string ("upnp:class"))))
	switch (0) {
		default:
		{
			result = rygel_relational_expression_compare_string (self, media_object->upnp_class);
#line 38 "rygel-relational-expression.vala"
			return result;
#line 294 "rygel-relational-expression.c"
		}
	} else if (_tmp2_ == ((0 != _tmp2__label4) ? _tmp2__label4 : (_tmp2__label4 = g_quark_from_static_string ("dc:title"))))
	switch (0) {
		default:
		{
			result = rygel_relational_expression_compare_string (self, rygel_media_object_get_title (media_object));
#line 40 "rygel-relational-expression.vala"
			return result;
#line 303 "rygel-relational-expression.c"
		}
	} else if (_tmp2_ == ((0 != _tmp2__label5) ? _tmp2__label5 : (_tmp2__label5 = g_quark_from_static_string ("dc:creator"))))
	switch (0) {
		default:
		{
			RygelMediaObject* _tmp0_;
			RygelMediaItem* item;
#line 42 "rygel-relational-expression.vala"
			if (!RYGEL_IS_MEDIA_ITEM (media_object)) {
#line 313 "rygel-relational-expression.c"
				result = FALSE;
#line 43 "rygel-relational-expression.vala"
				return result;
#line 317 "rygel-relational-expression.c"
			}
#line 46 "rygel-relational-expression.vala"
			item = _g_object_ref0 ((_tmp0_ = media_object, RYGEL_IS_MEDIA_ITEM (_tmp0_) ? ((RygelMediaItem*) _tmp0_) : NULL));
#line 321 "rygel-relational-expression.c"
			result = rygel_relational_expression_compare_string (self, item->author);
			_g_object_unref0 (item);
#line 47 "rygel-relational-expression.vala"
			return result;
#line 326 "rygel-relational-expression.c"
		}
	} else
	switch (0) {
		default:
		{
#line 49 "rygel-relational-expression.vala"
			if (g_str_has_prefix ((const char*) ((RygelSearchExpression*) self)->operand1, "res")) {
#line 334 "rygel-relational-expression.c"
				result = rygel_relational_expression_compare_resource (self, media_object);
#line 50 "rygel-relational-expression.vala"
				return result;
#line 338 "rygel-relational-expression.c"
			} else {
				result = FALSE;
#line 52 "rygel-relational-expression.vala"
				return result;
#line 343 "rygel-relational-expression.c"
			}
		}
	}
}


#line 57 "rygel-relational-expression.vala"
static char* rygel_relational_expression_real_to_string (RygelSearchExpression* base) {
#line 352 "rygel-relational-expression.c"
	RygelRelationalExpression * self;
	char* result = NULL;
	self = (RygelRelationalExpression*) base;
	result = g_strdup_printf ("%s %d %s", (const char*) ((RygelSearchExpression*) self)->operand1, (gint) GPOINTER_TO_INT (((RygelSearchExpression*) self)->op), (const char*) ((RygelSearchExpression*) self)->operand2);
#line 58 "rygel-relational-expression.vala"
	return result;
#line 359 "rygel-relational-expression.c"
}


#line 61 "rygel-relational-expression.vala"
static gboolean rygel_relational_expression_compare_resource (RygelRelationalExpression* self, RygelMediaObject* media_object) {
#line 365 "rygel-relational-expression.c"
	gboolean result = FALSE;
	gboolean ret;
#line 61 "rygel-relational-expression.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 61 "rygel-relational-expression.vala"
	g_return_val_if_fail (media_object != NULL, FALSE);
#line 62 "rygel-relational-expression.vala"
	ret = FALSE;
#line 374 "rygel-relational-expression.c"
	{
		GeeIterator* _uri_it;
		_uri_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) media_object->uris);
#line 64 "rygel-relational-expression.vala"
		while (TRUE) {
#line 380 "rygel-relational-expression.c"
			char* uri;
			gboolean _tmp0_ = FALSE;
#line 64 "rygel-relational-expression.vala"
			if (!gee_iterator_next (_uri_it)) {
#line 64 "rygel-relational-expression.vala"
				break;
#line 387 "rygel-relational-expression.c"
			}
#line 64 "rygel-relational-expression.vala"
			uri = (char*) gee_iterator_get (_uri_it);
#line 65 "rygel-relational-expression.vala"
			if (_vala_strcmp0 ((const char*) ((RygelSearchExpression*) self)->operand1, "res") == 0) {
#line 65 "rygel-relational-expression.vala"
				_tmp0_ = rygel_relational_expression_compare_string (self, uri);
#line 395 "rygel-relational-expression.c"
			} else {
#line 65 "rygel-relational-expression.vala"
				_tmp0_ = FALSE;
#line 399 "rygel-relational-expression.c"
			}
#line 65 "rygel-relational-expression.vala"
			if (_tmp0_) {
#line 66 "rygel-relational-expression.vala"
				ret = TRUE;
#line 405 "rygel-relational-expression.c"
				_g_free0 (uri);
#line 67 "rygel-relational-expression.vala"
				break;
#line 409 "rygel-relational-expression.c"
			} else {
#line 68 "rygel-relational-expression.vala"
				if (_vala_strcmp0 ((const char*) ((RygelSearchExpression*) self)->operand1, "res@protocolInfo") == 0) {
#line 413 "rygel-relational-expression.c"
				}
			}
			_g_free0 (uri);
		}
		_g_object_unref0 (_uri_it);
	}
	result = ret;
#line 73 "rygel-relational-expression.vala"
	return result;
#line 423 "rygel-relational-expression.c"
}


#line 1048 "glib-2.0.vapi"
static gboolean string_contains (const char* self, const char* needle) {
#line 429 "rygel-relational-expression.c"
	gboolean result = FALSE;
#line 1048 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1048 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 435 "rygel-relational-expression.c"
	result = strstr (self, needle) != NULL;
#line 1049 "glib-2.0.vapi"
	return result;
#line 439 "rygel-relational-expression.c"
}


#line 76 "rygel-relational-expression.vala"
gboolean rygel_relational_expression_compare_string (RygelRelationalExpression* self, const char* str) {
#line 445 "rygel-relational-expression.c"
	gboolean result = FALSE;
#line 76 "rygel-relational-expression.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 77 "rygel-relational-expression.vala"
	switch (GPOINTER_TO_INT (((RygelSearchExpression*) self)->op)) {
#line 451 "rygel-relational-expression.c"
		case GUPNP_SEARCH_CRITERIA_OP_EXISTS:
		{
#line 79 "rygel-relational-expression.vala"
			if (_vala_strcmp0 ((const char*) ((RygelSearchExpression*) self)->operand2, "true") == 0) {
#line 456 "rygel-relational-expression.c"
				result = str != NULL;
#line 80 "rygel-relational-expression.vala"
				return result;
#line 460 "rygel-relational-expression.c"
			} else {
				result = str == NULL;
#line 82 "rygel-relational-expression.vala"
				return result;
#line 465 "rygel-relational-expression.c"
			}
		}
		case GUPNP_SEARCH_CRITERIA_OP_EQ:
		{
			result = _vala_strcmp0 ((const char*) ((RygelSearchExpression*) self)->operand2, str) == 0;
#line 85 "rygel-relational-expression.vala"
			return result;
#line 473 "rygel-relational-expression.c"
		}
		case GUPNP_SEARCH_CRITERIA_OP_CONTAINS:
		{
			result = string_contains (str, (const char*) ((RygelSearchExpression*) self)->operand2);
#line 87 "rygel-relational-expression.vala"
			return result;
#line 480 "rygel-relational-expression.c"
		}
		case GUPNP_SEARCH_CRITERIA_OP_DERIVED_FROM:
		{
			result = g_str_has_prefix (str, (const char*) ((RygelSearchExpression*) self)->operand2);
#line 89 "rygel-relational-expression.vala"
			return result;
#line 487 "rygel-relational-expression.c"
		}
		default:
		{
			result = FALSE;
#line 91 "rygel-relational-expression.vala"
			return result;
#line 494 "rygel-relational-expression.c"
		}
	}
}


#line 27 "rygel-relational-expression.vala"
RygelRelationalExpression* rygel_relational_expression_construct (GType object_type) {
#line 502 "rygel-relational-expression.c"
	RygelRelationalExpression* self;
#line 27 "rygel-relational-expression.vala"
	self = (RygelRelationalExpression*) rygel_search_expression_construct (object_type, GUPNP_TYPE_SEARCH_CRITERIA_OP, NULL, NULL, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free);
#line 506 "rygel-relational-expression.c"
	return self;
}


#line 27 "rygel-relational-expression.vala"
RygelRelationalExpression* rygel_relational_expression_new (void) {
#line 27 "rygel-relational-expression.vala"
	return rygel_relational_expression_construct (RYGEL_TYPE_RELATIONAL_EXPRESSION);
#line 515 "rygel-relational-expression.c"
}


static void rygel_relational_expression_class_init (RygelRelationalExpressionClass * klass) {
	rygel_relational_expression_parent_class = g_type_class_peek_parent (klass);
	RYGEL_SEARCH_EXPRESSION_CLASS (klass)->satisfied_by = rygel_relational_expression_real_satisfied_by;
	RYGEL_SEARCH_EXPRESSION_CLASS (klass)->to_string = rygel_relational_expression_real_to_string;
}


static void rygel_relational_expression_instance_init (RygelRelationalExpression * self) {
}


GType rygel_relational_expression_get_type (void) {
	static volatile gsize rygel_relational_expression_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_relational_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelRelationalExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_relational_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelRelationalExpression), 0, (GInstanceInitFunc) rygel_relational_expression_instance_init, NULL };
		GType rygel_relational_expression_type_id;
		rygel_relational_expression_type_id = g_type_register_static (RYGEL_TYPE_SEARCH_EXPRESSION, "RygelRelationalExpression", &g_define_type_info, 0);
		g_once_init_leave (&rygel_relational_expression_type_id__volatile, rygel_relational_expression_type_id);
	}
	return rygel_relational_expression_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




