/* rygel-media-db.c generated by valac, the Vala compiler
 * generated from rygel-media-db.vala, do not modify */

/*
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>
#include <gee.h>
#include <gst/gst.h>


#define RYGEL_TYPE_MEDIA_DB_OBJECT_TYPE (rygel_media_db_object_type_get_type ())

#define RYGEL_TYPE_MEDIA_DB (rygel_media_db_get_type ())
#define RYGEL_MEDIA_DB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_DB, RygelMediaDB))
#define RYGEL_MEDIA_DB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_DB, RygelMediaDBClass))
#define RYGEL_IS_MEDIA_DB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_DB))
#define RYGEL_IS_MEDIA_DB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_DB))
#define RYGEL_MEDIA_DB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_DB, RygelMediaDBClass))

typedef struct _RygelMediaDB RygelMediaDB;
typedef struct _RygelMediaDBClass RygelMediaDBClass;
typedef struct _RygelMediaDBPrivate RygelMediaDBPrivate;

#define RYGEL_TYPE_DATABASE (rygel_database_get_type ())
#define RYGEL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATABASE, RygelDatabase))
#define RYGEL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DATABASE, RygelDatabaseClass))
#define RYGEL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATABASE))
#define RYGEL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DATABASE))
#define RYGEL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DATABASE, RygelDatabaseClass))

typedef struct _RygelDatabase RygelDatabase;
typedef struct _RygelDatabaseClass RygelDatabaseClass;

#define RYGEL_TYPE_MEDIA_DB_OBJECT_FACTORY (rygel_media_db_object_factory_get_type ())
#define RYGEL_MEDIA_DB_OBJECT_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_DB_OBJECT_FACTORY, RygelMediaDBObjectFactory))
#define RYGEL_MEDIA_DB_OBJECT_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_DB_OBJECT_FACTORY, RygelMediaDBObjectFactoryClass))
#define RYGEL_IS_MEDIA_DB_OBJECT_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_DB_OBJECT_FACTORY))
#define RYGEL_IS_MEDIA_DB_OBJECT_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_DB_OBJECT_FACTORY))
#define RYGEL_MEDIA_DB_OBJECT_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_DB_OBJECT_FACTORY, RygelMediaDBObjectFactoryClass))

typedef struct _RygelMediaDBObjectFactory RygelMediaDBObjectFactory;
typedef struct _RygelMediaDBObjectFactoryClass RygelMediaDBObjectFactoryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block7Data Block7Data;
typedef struct _Block8Data Block8Data;
typedef struct _Block10Data Block10Data;
typedef struct _Block9Data Block9Data;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
typedef struct _Block11Data Block11Data;
typedef struct _Block12Data Block12Data;

typedef enum  {
	RYGEL_MEDIA_DB_ERROR_SQLITE_ERROR,
	RYGEL_MEDIA_DB_ERROR_GENERAL_ERROR,
	RYGEL_MEDIA_DB_ERROR_INVALID_TYPE
} RygelMediaDBError;
#define RYGEL_MEDIA_DB_ERROR rygel_media_db_error_quark ()
typedef enum  {
	RYGEL_MEDIA_DB_OBJECT_TYPE_CONTAINER,
	RYGEL_MEDIA_DB_OBJECT_TYPE_ITEM
} RygelMediaDBObjectType;

struct _RygelMediaDB {
	GObject parent_instance;
	RygelMediaDBPrivate * priv;
};

struct _RygelMediaDBClass {
	GObjectClass parent_class;
};

struct _RygelMediaDBPrivate {
	RygelDatabase* db;
	RygelMediaDBObjectFactory* factory;
};

typedef gboolean (*RygelDatabaseRowCallback) (sqlite3_stmt* stmt, void* user_data);
typedef enum  {
	RYGEL_DATABASE_ERROR_SQLITE_ERROR
} RygelDatabaseError;
#define RYGEL_DATABASE_ERROR rygel_database_error_quark ()
struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	char* id;
	char* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
	RygelMediaContainer* parent_ref;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
};

struct _Block4Data {
	int _ref_count_;
	RygelMediaDB * self;
	RygelMediaObject* parent;
};

struct _Block5Data {
	int _ref_count_;
	RygelMediaDB * self;
	gint count;
};

struct _Block6Data {
	int _ref_count_;
	RygelMediaDB * self;
	gboolean exists;
	gint64 tmp_timestamp;
};

struct _Block7Data {
	int _ref_count_;
	RygelMediaDB * self;
	RygelMediaContainer* parent;
	GeeArrayList* children;
};

struct _Block8Data {
	int _ref_count_;
	RygelMediaDB * self;
	GeeArrayList* children;
};

struct _Block10Data {
	int _ref_count_;
	Block9Data * _data9_;
	gint rows;
};

struct _Block9Data {
	int _ref_count_;
	RygelMediaDB * self;
	gint old_version;
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	char* author;
	char* album;
	char* date;
	char* mime_type;
	char* dlna_profile;
	glong size;
	glong duration;
	gint bitrate;
	gint sample_freq;
	gint bits_per_sample;
	gint n_audio_channels;
	gint track_number;
	gint width;
	gint height;
	gint pixel_width;
	gint pixel_height;
	gint color_depth;
	GeeArrayList* thumbnails;
	gboolean place_holder;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self);
	gboolean (*should_stream) (RygelMediaItem* self);
};

struct _Block11Data {
	int _ref_count_;
	RygelMediaDB * self;
	RygelMediaObject* obj;
};

struct _Block12Data {
	int _ref_count_;
	RygelMediaDB * self;
	GeeArrayList* children;
};


static gpointer rygel_media_db_parent_class = NULL;

GQuark rygel_media_db_error_quark (void);
GType rygel_media_db_object_type_get_type (void);
GType rygel_media_db_get_type (void);
GType rygel_database_get_type (void);
GType rygel_media_db_object_factory_get_type (void);
#define RYGEL_MEDIA_DB_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_DB, RygelMediaDBPrivate))
enum  {
	RYGEL_MEDIA_DB_DUMMY_PROPERTY
};
#define RYGEL_MEDIA_DB_schema_version "5"
#define RYGEL_MEDIA_DB_SCHEMA_STRING "CREATE TABLE schema_info (version TEXT NOT NULL); " "CREATE TABLE object_type (id INTEGER PRIMARY KEY, " "desc TEXT NOT NULL);" "CREATE TABLE meta_data (size INTEGER NOT NULL, " "mime_type TEXT NOT NULL, " "duration INTEGER, " "width INTEGER, " "height INTEGER, " "class TEXT NOT NULL, " "author TEXT, " "album TEXT, " "date TEXT, " "bitrate INTEGER, " "sample_freq INTEGER, " "bits_per_sample INTEGER, " "channels INTEGER, " "track INTEGER, " "color_depth INTEGER, " "object_fk TEXT UNIQUE CONSTRAINT " "object_fk_id REFERENCES Object(upnp_id) " "ON DELETE CASCADE);" "CREATE TABLE object (parent TEXT CONSTRAINT parent_fk_id " "REFERENCES Object(upnp_id), " "upnp_id TEXT PRIMARY KEY, " "type_fk INTEGER CONSTRAINT type_fk_id " "REFERENCES Object_Type(id), " "title TEXT NOT NULL, " "timestamp INTEGER NOT NULL);" "CREATE TABLE uri (object_fk TEXT " "CONSTRAINT object_fk_id REFERENCES Object(upnp_id) " "ON DELETE CASCADE, " "uri TEXT NOT NULL);" "INSERT INTO object_type (id, desc) VALUES (0, 'Container'); " "INSERT INTO object_type (id, desc) VALUES (1, 'Item'); " "INSERT INTO schema_info (version) VALUES ('" RYGEL_MEDIA_DB_schema_version "'); "
#define RYGEL_MEDIA_DB_CREATE_CLOSURE_TABLE "CREATE TABLE closure (ancestor TEXT, descendant TEXT, depth INTEGER)"
#define RYGEL_MEDIA_DB_CREATE_CLOSURE_TRIGGER_STRING "CREATE TRIGGER trgr_update_closure " "AFTER INSERT ON Object " "FOR EACH ROW BEGIN " "INSERT INTO Closure (ancestor, descendant, depth) " "VALUES (NEW.upnp_id, NEW.upnp_id, 0); " "INSERT INTO Closure (ancestor, descendant, depth) " "SELECT ancestor, NEW.upnp_id, depth + 1 FROM Closure " "WHERE descendant = NEW.parent;" "END;" "CREATE TRIGGER trgr_delete_closure " "AFTER DELETE ON Object " "FOR EACH ROW BEGIN " "DELETE FROM Closure WHERE descendant = OLD.upnp_id;" "END;"
#define RYGEL_MEDIA_DB_CREATE_TRIGGER_STRING "CREATE TRIGGER trgr_delete_metadata " "BEFORE DELETE ON Object " "FOR EACH ROW BEGIN " "DELETE FROM meta_data WHERE meta_data.object_fk = OLD.upnp_id; " "END;" "CREATE TRIGGER trgr_delete_uris " "BEFORE DELETE ON Object " "FOR EACH ROW BEGIN " "DELETE FROM Uri WHERE Uri.object_fk = OLD.upnp_id;" "END;"
#define RYGEL_MEDIA_DB_CREATE_INDICES_STRING "CREATE INDEX idx_parent on Object(parent);" "CREATE INDEX idx_uri_fk on Uri(object_fk);" "CREATE INDEX idx_meta_data_fk on meta_data(object_fk);" "CREATE INDEX idx_closure on Closure(descendant,depth);"
#define RYGEL_MEDIA_DB_SAVE_META_DATA_STRING "INSERT OR REPLACE INTO meta_data " "(size, mime_type, width, height, class, " "author, album, date, bitrate, " "sample_freq, bits_per_sample, channels, " "track, color_depth, duration, object_fk) VALUES " "(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)"
#define RYGEL_MEDIA_DB_INSERT_OBJECT_STRING "INSERT INTO Object (upnp_id, title, type_fk, parent, timestamp) " "VALUES (?,?,?,?,?)"
#define RYGEL_MEDIA_DB_UPDATE_OBJECT_STRING "UPDATE Object SET title = ?, timestamp = ? WHERE upnp_id = ?"
#define RYGEL_MEDIA_DB_INSERT_URI_STRING "INSERT INTO Uri (object_fk, uri) VALUES (?,?)"
#define RYGEL_MEDIA_DB_DELETE_URI_STRING "DELETE FROM Uri WHERE object_fk = ?"
#define RYGEL_MEDIA_DB_DELETE_BY_ID_STRING "DELETE FROM Object WHERE upnp_id = " "(SELECT descendant FROM closure WHERE ancestor = ?)"
#define RYGEL_MEDIA_DB_GET_OBJECT_WITH_CLOSURE "SELECT o.type_fk, o.title, m.size, m.mime_type, m.width, m.height, " "m.class, m.author, m.album, m.date, m.bitrate, m.sample_freq, " "m.bits_per_sample, m.channels, m.track, m.color_depth, " "m.duration, o.parent, o.upnp_id " "FROM Object o " "JOIN Closure c ON (o.upnp_id = c.ancestor) " "LEFT OUTER JOIN meta_data m ON (o.upnp_id = m.object_fk) " "WHERE c.descendant = ? ORDER BY c.depth DESC"
#define RYGEL_MEDIA_DB_GET_CHILDREN_STRING "SELECT o.type_fk, o.title, m.size, m.mime_type, " "m.width, m.height, m.class, m.author, m.album, " "m.date, m.bitrate, m.sample_freq, m.bits_per_sample, " "m.channels, m.track, m.color_depth, m.duration, " "o.upnp_id, o.parent, o.timestamp " "FROM Object o LEFT OUTER JOIN meta_data m " "ON o.upnp_id = m.object_fk " "WHERE o.parent = ? " "ORDER BY o.type_fk ASC, " "m.class ASC, " "m.track ASC, " "o.title ASC " "LIMIT ?,?"
#define RYGEL_MEDIA_DB_GET_OBJECTS_STRING_WITH_FILTER "SELECT o.type_fk, o.title, m.size, m.mime_type, " "m.width, m.height, m.class, m.author, m.album, " "m.date, m.bitrate, m.sample_freq, m.bits_per_sample, " "m.channels, m.track, m.color_depth, m.duration, " "o.upnp_id, o.parent, o.timestamp " "FROM Object o " "JOIN Closure c ON o.upnp_id = c.descendant AND c.ancestor = ? " "LEFT OUTER JOIN meta_data m " "ON o.upnp_id = m.object_fk " "WHERE %s " "ORDER BY o.type_fk ASC, " "m.class ASC, " "m.track ASC, " "o.title ASC " "LIMIT ?,?"
#define RYGEL_MEDIA_DB_URI_GET_STRING "SELECT uri FROM Uri WHERE Uri.object_fk = ?"
#define RYGEL_MEDIA_DB_CHILDREN_COUNT_STRING "SELECT COUNT(upnp_id) FROM Object WHERE Object.parent = ?"
#define RYGEL_MEDIA_DB_OBJECT_EXISTS_STRING "SELECT COUNT(upnp_id), timestamp FROM Object WHERE Object.upnp_id = ?"
#define RYGEL_MEDIA_DB_OBJECT_DELETE_STRING "DELETE FROM Object WHERE Object.upnp_id = ?"
#define RYGEL_MEDIA_DB_GET_CHILD_ID_STRING "SELECT upnp_id FROM OBJECT WHERE parent = ?"
#define RYGEL_MEDIA_DB_UPDATE_V3_V4_STRING_1 "ALTER TABLE meta_data ADD object_fk TEXT"
#define RYGEL_MEDIA_DB_UPDATE_V3_V4_STRING_2 "UPDATE meta_data SET object_fk = " "(SELECT upnp_id FROM Object WHERE metadata_fk = meta_data.id)"
#define RYGEL_MEDIA_DB_UPDATE_V3_V4_STRING_3 "ALTER TABLE Object ADD timestamp INTEGER"
#define RYGEL_MEDIA_DB_UPDATE_V3_V4_STRING_4 "UPDATE Object SET timestamp = 0"
RygelMediaDBObjectFactory* rygel_media_db_object_factory_new (void);
RygelMediaDBObjectFactory* rygel_media_db_object_factory_construct (GType object_type);
static RygelMediaDB* rygel_media_db_new (const char* name, RygelMediaDBObjectFactory* factory);
static RygelMediaDB* rygel_media_db_construct (GType object_type, const char* name, RygelMediaDBObjectFactory* factory);
RygelMediaDB* rygel_media_db_create (const char* name, GError** error);
RygelMediaDB* rygel_media_db_create_with_factory (const char* name, RygelMediaDBObjectFactory* factory, GError** error);
GQuark rygel_database_error_quark (void);
gint rygel_database_exec (RygelDatabase* self, const char* sql, GValue* values, int values_length1, RygelDatabaseRowCallback callback, void* callback_target, GError** error);
static void _vala_GValue_array_free (GValue* array, gint array_length);
void rygel_media_db_remove_by_id (RygelMediaDB* self, const char* id, GError** error);
GType rygel_media_object_get_type (void);
GType rygel_media_container_get_type (void);
GType rygel_media_item_get_type (void);
void rygel_media_db_remove_object (RygelMediaDB* self, RygelMediaObject* obj, GError** error);
void rygel_media_db_save_item (RygelMediaDB* self, RygelMediaItem* item, GError** error);
void rygel_media_db_save_container (RygelMediaDB* self, RygelMediaContainer* container, GError** error);
void rygel_media_db_save_object (RygelMediaDB* self, RygelMediaObject* obj, GError** error);
void rygel_database_begin (RygelDatabase* self, GError** error);
static void rygel_media_db_create_object (RygelMediaDB* self, RygelMediaObject* item, GError** error);
static void rygel_media_db_save_uris (RygelMediaDB* self, RygelMediaObject* obj, GError** error);
void rygel_database_commit (RygelDatabase* self, GError** error);
void rygel_database_rollback (RygelDatabase* self);
static void rygel_media_db_save_metadata (RygelMediaDB* self, RygelMediaItem* item, GError** error);
static void rygel_media_db_remove_uris (RygelMediaDB* self, RygelMediaObject* obj, GError** error);
static void rygel_media_db_update_object_internal (RygelMediaDB* self, RygelMediaObject* obj, GError** error);
void rygel_media_db_update_object (RygelMediaDB* self, RygelMediaObject* obj, GError** error);
static RygelMediaObject* rygel_media_db_get_object_from_statement (RygelMediaDB* self, RygelMediaContainer* parent, const char* object_id, sqlite3_stmt* statement);
static gboolean _lambda9_ (sqlite3_stmt* stmt, Block4Data* _data4_);
static gboolean __lambda9__rygel_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (Block4Data* _data4_);
RygelMediaObject* rygel_media_db_get_object (RygelMediaDB* self, const char* object_id, GError** error);
RygelMediaItem* rygel_media_db_get_item (RygelMediaDB* self, const char* item_id, GError** error);
RygelMediaContainer* rygel_media_db_get_container (RygelMediaDB* self, const char* container_id, GError** error);
static gboolean _lambda8_ (sqlite3_stmt* stmt, Block5Data* _data5_);
static gboolean __lambda8__rygel_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (Block5Data* _data5_);
gint rygel_media_db_get_child_count (RygelMediaDB* self, const char* container_id, GError** error);
static gboolean _lambda13_ (sqlite3_stmt* stmt, Block6Data* _data6_);
static gboolean __lambda13__rygel_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (Block6Data* _data6_);
gboolean rygel_media_db_exists (RygelMediaDB* self, const char* object_id, gint64* timestamp, GError** error);
static gboolean _lambda11_ (sqlite3_stmt* stmt, Block7Data* _data7_);
static gboolean __lambda11__rygel_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (Block7Data* _data7_);
GeeArrayList* rygel_media_db_get_children (RygelMediaDB* self, const char* container_id, glong offset, glong max_count, GError** error);
static gboolean _lambda12_ (sqlite3_stmt* stmt, Block8Data* _data8_);
static gboolean __lambda12__rygel_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (Block8Data* _data8_);
GeeArrayList* rygel_media_db_get_objects_by_filter (RygelMediaDB* self, const char* filter, GValueArray* args, const char* container_id, glong offset, glong max_count, GError** error);
static void rygel_media_db_open_db (RygelMediaDB* self, const char* name);
RygelDatabase* rygel_database_new (const char* name);
RygelDatabase* rygel_database_construct (GType object_type, const char* name);
static gboolean _lambda14_ (sqlite3_stmt* stmt, Block9Data* _data9_);
static gboolean __lambda14__rygel_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static void rygel_media_db_update_v3_v4 (RygelMediaDB* self);
static void rygel_media_db_update_v4_v5 (RygelMediaDB* self);
static gboolean _lambda15_ (sqlite3_stmt* stmt, Block10Data* _data10_);
static gboolean __lambda15__rygel_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static gboolean rygel_media_db_create_schema (RygelMediaDB* self);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (Block10Data* _data10_);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (Block9Data* _data9_);
void rygel_database_analyze (RygelDatabase* self);
const char* rygel_media_object_get_title (RygelMediaObject* self);
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void);
GType rygel_thumbnail_get_type (void);
void rygel_database_null (GValue* result);
void rygel_media_item_add_uri (RygelMediaItem* self, const char* uri, RygelThumbnail* thumbnail);
static gboolean _lambda10_ (sqlite3_stmt* stmt, Block11Data* _data11_);
static gboolean __lambda10__rygel_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (Block11Data* _data11_);
static void rygel_media_db_add_uris (RygelMediaDB* self, RygelMediaObject* obj, GError** error);
RygelMediaContainer* rygel_media_db_object_factory_get_container (RygelMediaDBObjectFactory* self, RygelMediaDB* media_db, const char* id, const char* title, guint child_count);
RygelMediaItem* rygel_media_db_object_factory_get_item (RygelMediaDBObjectFactory* self, RygelMediaDB* media_db, RygelMediaContainer* parent, const char* id, const char* title, const char* upnp_class);
static void rygel_media_db_fill_item (RygelMediaDB* self, sqlite3_stmt* statement, RygelMediaItem* item);
static gboolean _lambda16_ (sqlite3_stmt* stmt, Block12Data* _data12_);
static gboolean __lambda16__rygel_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (Block12Data* _data12_);
GeeArrayList* rygel_media_db_get_child_ids (RygelMediaDB* self, const char* container_id, GError** error);
static void rygel_media_db_finalize (GObject* obj);



GQuark rygel_media_db_error_quark (void) {
	return g_quark_from_static_string ("rygel_media_db_error-quark");
}



GType rygel_media_db_object_type_get_type (void) {
	static GType rygel_media_db_object_type_type_id = 0;
	if (G_UNLIKELY (rygel_media_db_object_type_type_id == 0)) {
		static const GEnumValue values[] = {{RYGEL_MEDIA_DB_OBJECT_TYPE_CONTAINER, "RYGEL_MEDIA_DB_OBJECT_TYPE_CONTAINER", "container"}, {RYGEL_MEDIA_DB_OBJECT_TYPE_ITEM, "RYGEL_MEDIA_DB_OBJECT_TYPE_ITEM", "item"}, {0, NULL, NULL}};
		rygel_media_db_object_type_type_id = g_enum_register_static ("RygelMediaDBObjectType", values);
	}
	return rygel_media_db_object_type_type_id;
}


#line 242 "rygel-media-db.vala"
RygelMediaDB* rygel_media_db_create (const char* name, GError** error) {
#line 414 "rygel-media-db.c"
	RygelMediaDB* result;
	GError * _inner_error_;
	RygelMediaDBObjectFactory* _tmp0_;
	RygelMediaDB* _tmp1_;
	RygelMediaDB* instance;
#line 242 "rygel-media-db.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 422 "rygel-media-db.c"
	_inner_error_ = NULL;
#line 243 "rygel-media-db.vala"
	instance = (_tmp1_ = rygel_media_db_new (name, _tmp0_ = rygel_media_db_object_factory_new ()), _g_object_unref0 (_tmp0_), _tmp1_);
#line 244 "rygel-media-db.vala"
	if (instance->priv->db != NULL) {
#line 428 "rygel-media-db.c"
		result = instance;
#line 245 "rygel-media-db.vala"
		return result;
#line 432 "rygel-media-db.c"
	}
	_inner_error_ = g_error_new_literal (RYGEL_MEDIA_DB_ERROR, RYGEL_MEDIA_DB_ERROR_GENERAL_ERROR, "Invalid database");
	{
		if (_inner_error_->domain == RYGEL_MEDIA_DB_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (instance);
			return NULL;
		} else {
			_g_object_unref0 (instance);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_g_object_unref0 (instance);
}


#line 251 "rygel-media-db.vala"
RygelMediaDB* rygel_media_db_create_with_factory (const char* name, RygelMediaDBObjectFactory* factory, GError** error) {
#line 453 "rygel-media-db.c"
	RygelMediaDB* result;
	GError * _inner_error_;
	RygelMediaDB* instance;
#line 251 "rygel-media-db.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 251 "rygel-media-db.vala"
	g_return_val_if_fail (factory != NULL, NULL);
#line 461 "rygel-media-db.c"
	_inner_error_ = NULL;
#line 254 "rygel-media-db.vala"
	instance = rygel_media_db_new (name, factory);
#line 255 "rygel-media-db.vala"
	if (instance->priv->db != NULL) {
#line 467 "rygel-media-db.c"
		result = instance;
#line 256 "rygel-media-db.vala"
		return result;
#line 471 "rygel-media-db.c"
	}
	_inner_error_ = g_error_new_literal (RYGEL_MEDIA_DB_ERROR, RYGEL_MEDIA_DB_ERROR_GENERAL_ERROR, "Invalid database");
	{
		if (_inner_error_->domain == RYGEL_MEDIA_DB_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (instance);
			return NULL;
		} else {
			_g_object_unref0 (instance);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_g_object_unref0 (instance);
}


static void _vala_GValue_array_free (GValue* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			g_value_unset (&array[i]);
		}
	}
	g_free (array);
}


#line 262 "rygel-media-db.vala"
void rygel_media_db_remove_by_id (RygelMediaDB* self, const char* id, GError** error) {
#line 503 "rygel-media-db.c"
	GError * _inner_error_;
	GValue* _tmp2_;
	gint values_size;
	gint values_length1;
	GValue* _tmp1_ = NULL;
	GValue _tmp0_ = {0};
	GValue* values;
#line 262 "rygel-media-db.vala"
	g_return_if_fail (self != NULL);
#line 262 "rygel-media-db.vala"
	g_return_if_fail (id != NULL);
#line 515 "rygel-media-db.c"
	_inner_error_ = NULL;
	values = (_tmp2_ = (_tmp1_ = g_new0 (GValue, 1), _tmp1_[0] = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, id), _tmp0_), _tmp1_), values_length1 = 1, values_size = values_length1, _tmp2_);
#line 264 "rygel-media-db.vala"
	rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_DELETE_BY_ID_STRING, values, values_length1, NULL, NULL, &_inner_error_);
#line 520 "rygel-media-db.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			return;
		} else {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
#line 265 "rygel-media-db.vala"
	g_signal_emit_by_name (self, "object-removed", id);
#line 535 "rygel-media-db.c"
	values = (_vala_GValue_array_free (values, values_length1), NULL);
}


#line 269 "rygel-media-db.vala"
void rygel_media_db_remove_object (RygelMediaDB* self, RygelMediaObject* obj, GError** error) {
#line 542 "rygel-media-db.c"
	GError * _inner_error_;
#line 269 "rygel-media-db.vala"
	g_return_if_fail (self != NULL);
#line 269 "rygel-media-db.vala"
	g_return_if_fail (obj != NULL);
#line 548 "rygel-media-db.c"
	_inner_error_ = NULL;
#line 271 "rygel-media-db.vala"
	rygel_media_db_remove_by_id (self, obj->id, &_inner_error_);
#line 552 "rygel-media-db.c"
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == RYGEL_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_DB_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
#line 272 "rygel-media-db.vala"
	if (RYGEL_IS_MEDIA_ITEM (obj)) {
#line 273 "rygel-media-db.vala"
		g_signal_emit_by_name (self, "item-removed", obj->id);
#line 567 "rygel-media-db.c"
	} else {
#line 274 "rygel-media-db.vala"
		if (RYGEL_IS_MEDIA_CONTAINER (obj)) {
#line 275 "rygel-media-db.vala"
			g_signal_emit_by_name (self, "container-removed", obj->id);
#line 573 "rygel-media-db.c"
		} else {
			_inner_error_ = g_error_new_literal (RYGEL_MEDIA_DB_ERROR, RYGEL_MEDIA_DB_ERROR_INVALID_TYPE, "Invalid object type");
			{
				if ((_inner_error_->domain == RYGEL_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_DB_ERROR)) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
}


#line 280 "rygel-media-db.vala"
void rygel_media_db_save_object (RygelMediaDB* self, RygelMediaObject* obj, GError** error) {
#line 593 "rygel-media-db.c"
	GError * _inner_error_;
#line 280 "rygel-media-db.vala"
	g_return_if_fail (self != NULL);
#line 280 "rygel-media-db.vala"
	g_return_if_fail (obj != NULL);
#line 599 "rygel-media-db.c"
	_inner_error_ = NULL;
#line 281 "rygel-media-db.vala"
	if (RYGEL_IS_MEDIA_ITEM (obj)) {
#line 282 "rygel-media-db.vala"
		rygel_media_db_save_item (self, RYGEL_MEDIA_ITEM (obj), &_inner_error_);
#line 605 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	} else {
#line 283 "rygel-media-db.vala"
		if (RYGEL_IS_MEDIA_CONTAINER (obj)) {
#line 284 "rygel-media-db.vala"
			rygel_media_db_save_container (self, RYGEL_MEDIA_CONTAINER (obj), &_inner_error_);
#line 615 "rygel-media-db.c"
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				return;
			}
		} else {
			_inner_error_ = g_error_new_literal (RYGEL_MEDIA_DB_ERROR, RYGEL_MEDIA_DB_ERROR_INVALID_TYPE, "Invalid object type");
			{
				g_propagate_error (error, _inner_error_);
				return;
			}
		}
	}
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


#line 290 "rygel-media-db.vala"
void rygel_media_db_save_container (RygelMediaDB* self, RygelMediaContainer* container, GError** error) {
#line 638 "rygel-media-db.c"
	GError * _inner_error_;
#line 290 "rygel-media-db.vala"
	g_return_if_fail (self != NULL);
#line 290 "rygel-media-db.vala"
	g_return_if_fail (container != NULL);
#line 644 "rygel-media-db.c"
	_inner_error_ = NULL;
	{
#line 292 "rygel-media-db.vala"
		rygel_database_begin (self->priv->db, &_inner_error_);
#line 649 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch49_rygel_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 293 "rygel-media-db.vala"
		rygel_media_db_create_object (self, (RygelMediaObject*) container, &_inner_error_);
#line 660 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch49_rygel_database_error;
			}
			goto __finally49;
		}
#line 294 "rygel-media-db.vala"
		rygel_media_db_save_uris (self, (RygelMediaObject*) container, &_inner_error_);
#line 669 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch49_rygel_database_error;
			}
			goto __finally49;
		}
#line 295 "rygel-media-db.vala"
		rygel_database_commit (self->priv->db, &_inner_error_);
#line 678 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch49_rygel_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 296 "rygel-media-db.vala"
		g_signal_emit_by_name (self, "object-added", ((RygelMediaObject*) container)->id);
#line 297 "rygel-media-db.vala"
		g_signal_emit_by_name (self, "container-added", ((RygelMediaObject*) container)->id);
#line 691 "rygel-media-db.c"
	}
	goto __finally49;
	__catch49_rygel_database_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
#line 299 "rygel-media-db.vala"
			rygel_database_rollback (self->priv->db);
#line 702 "rygel-media-db.c"
			_inner_error_ = _g_error_copy0 (err);
			{
				_g_error_free0 (err);
				goto __finally49;
			}
			_g_error_free0 (err);
		}
	}
	__finally49:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


#line 304 "rygel-media-db.vala"
void rygel_media_db_save_item (RygelMediaDB* self, RygelMediaItem* item, GError** error) {
#line 721 "rygel-media-db.c"
	GError * _inner_error_;
#line 304 "rygel-media-db.vala"
	g_return_if_fail (self != NULL);
#line 304 "rygel-media-db.vala"
	g_return_if_fail (item != NULL);
#line 727 "rygel-media-db.c"
	_inner_error_ = NULL;
	{
#line 306 "rygel-media-db.vala"
		rygel_database_begin (self->priv->db, &_inner_error_);
#line 732 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch50_rygel_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 307 "rygel-media-db.vala"
		rygel_media_db_save_metadata (self, item, &_inner_error_);
#line 743 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch50_rygel_database_error;
			}
			goto __finally50;
		}
#line 308 "rygel-media-db.vala"
		rygel_media_db_create_object (self, (RygelMediaObject*) item, &_inner_error_);
#line 752 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch50_rygel_database_error;
			}
			goto __finally50;
		}
#line 309 "rygel-media-db.vala"
		rygel_media_db_save_uris (self, (RygelMediaObject*) item, &_inner_error_);
#line 761 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch50_rygel_database_error;
			}
			goto __finally50;
		}
#line 310 "rygel-media-db.vala"
		rygel_database_commit (self->priv->db, &_inner_error_);
#line 770 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch50_rygel_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 311 "rygel-media-db.vala"
		g_signal_emit_by_name (self, "object-added", ((RygelMediaObject*) item)->id);
#line 312 "rygel-media-db.vala"
		g_signal_emit_by_name (self, "item-added", ((RygelMediaObject*) item)->id);
#line 783 "rygel-media-db.c"
	}
	goto __finally50;
	__catch50_rygel_database_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
#line 314 "rygel-media-db.vala"
			g_warning ("rygel-media-db.vala:314: Failed to add item with id %s: %s", ((RygelMediaObject*) item)->id, _error_->message);
#line 317 "rygel-media-db.vala"
			rygel_database_rollback (self->priv->db);
#line 796 "rygel-media-db.c"
			_inner_error_ = _g_error_copy0 (_error_);
			{
				_g_error_free0 (_error_);
				goto __finally50;
			}
			_g_error_free0 (_error_);
		}
	}
	__finally50:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


#line 322 "rygel-media-db.vala"
void rygel_media_db_update_object (RygelMediaDB* self, RygelMediaObject* obj, GError** error) {
#line 815 "rygel-media-db.c"
	GError * _inner_error_;
#line 322 "rygel-media-db.vala"
	g_return_if_fail (self != NULL);
#line 322 "rygel-media-db.vala"
	g_return_if_fail (obj != NULL);
#line 821 "rygel-media-db.c"
	_inner_error_ = NULL;
	{
#line 324 "rygel-media-db.vala"
		rygel_database_begin (self->priv->db, &_inner_error_);
#line 826 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			goto __catch51_g_error;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 325 "rygel-media-db.vala"
		rygel_media_db_remove_uris (self, obj, &_inner_error_);
#line 835 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			goto __catch51_g_error;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 326 "rygel-media-db.vala"
		if (RYGEL_IS_MEDIA_ITEM (obj)) {
#line 327 "rygel-media-db.vala"
			rygel_media_db_save_metadata (self, RYGEL_MEDIA_ITEM (obj), &_inner_error_);
#line 846 "rygel-media-db.c"
			if (_inner_error_ != NULL) {
				goto __catch51_g_error;
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
#line 329 "rygel-media-db.vala"
		rygel_media_db_update_object_internal (self, obj, &_inner_error_);
#line 856 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			goto __catch51_g_error;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 330 "rygel-media-db.vala"
		rygel_media_db_save_uris (self, obj, &_inner_error_);
#line 865 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			goto __catch51_g_error;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 331 "rygel-media-db.vala"
		rygel_database_commit (self->priv->db, &_inner_error_);
#line 874 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			goto __catch51_g_error;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 332 "rygel-media-db.vala"
		g_signal_emit_by_name (self, "object-updated", obj->id);
#line 333 "rygel-media-db.vala"
		if (RYGEL_IS_MEDIA_ITEM (obj)) {
#line 334 "rygel-media-db.vala"
			g_signal_emit_by_name (self, "item-updated", obj->id);
#line 887 "rygel-media-db.c"
		} else {
#line 335 "rygel-media-db.vala"
			if (RYGEL_IS_MEDIA_CONTAINER (obj)) {
#line 336 "rygel-media-db.vala"
				g_signal_emit_by_name (self, "container-updated", obj->id);
#line 893 "rygel-media-db.c"
			}
		}
	}
	goto __finally51;
	__catch51_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
#line 338 "rygel-media-db.vala"
			g_warning ("rygel-media-db.vala:338: Failed to add item with id %s: %s", obj->id, _error_->message);
#line 341 "rygel-media-db.vala"
			rygel_database_rollback (self->priv->db);
#line 908 "rygel-media-db.c"
			_inner_error_ = _g_error_copy0 (_error_);
			{
				_g_error_free0 (_error_);
				goto __finally51;
			}
			_g_error_free0 (_error_);
		}
	}
	__finally51:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 349 "rygel-media-db.vala"
static gboolean _lambda9_ (sqlite3_stmt* stmt, Block4Data* _data4_) {
#line 932 "rygel-media-db.c"
	RygelMediaDB * self;
	gboolean result;
	RygelMediaObject* obj;
	RygelMediaContainer* _tmp0_;
	RygelMediaObject* _tmp1_;
	self = _data4_->self;
#line 349 "rygel-media-db.vala"
	g_return_val_if_fail (stmt != NULL, FALSE);
#line 350 "rygel-media-db.vala"
	obj = rygel_media_db_get_object_from_statement (self, RYGEL_MEDIA_CONTAINER (_data4_->parent), sqlite3_column_text (stmt, 18), stmt);
#line 353 "rygel-media-db.vala"
	obj->parent = RYGEL_MEDIA_CONTAINER (_data4_->parent);
#line 354 "rygel-media-db.vala"
	obj->parent_ref = (_tmp0_ = _g_object_ref0 (RYGEL_MEDIA_CONTAINER (_data4_->parent)), _g_object_unref0 (obj->parent_ref), _tmp0_);
#line 355 "rygel-media-db.vala"
	_data4_->parent = (_tmp1_ = _g_object_ref0 (obj), _g_object_unref0 (_data4_->parent), _tmp1_);
#line 949 "rygel-media-db.c"
	result = TRUE;
	_g_object_unref0 (obj);
#line 356 "rygel-media-db.vala"
	return result;
#line 954 "rygel-media-db.c"
}


#line 349 "rygel-media-db.vala"
static gboolean __lambda9__rygel_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
#line 960 "rygel-media-db.c"
	return _lambda9_ (stmt, self);
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	++_data4_->_ref_count_;
	return _data4_;
}


static void block4_data_unref (Block4Data* _data4_) {
	if ((--_data4_->_ref_count_) == 0) {
		_g_object_unref0 (_data4_->self);
		_g_object_unref0 (_data4_->parent);
		g_slice_free (Block4Data, _data4_);
	}
}


#line 346 "rygel-media-db.vala"
RygelMediaObject* rygel_media_db_get_object (RygelMediaDB* self, const char* object_id, GError** error) {
#line 982 "rygel-media-db.c"
	RygelMediaObject* result;
	GError * _inner_error_;
	Block4Data* _data4_;
	GValue* _tmp2_;
	gint values_size;
	gint values_length1;
	GValue* _tmp1_ = NULL;
	GValue _tmp0_ = {0};
	GValue* values;
	RygelDatabaseRowCallback _tmp3_;
	GDestroyNotify cb_target_destroy_notify = NULL;
	void* cb_target = NULL;
	RygelDatabaseRowCallback cb;
#line 346 "rygel-media-db.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 346 "rygel-media-db.vala"
	g_return_val_if_fail (object_id != NULL, NULL);
#line 1000 "rygel-media-db.c"
	_inner_error_ = NULL;
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	values = (_tmp2_ = (_tmp1_ = g_new0 (GValue, 1), _tmp1_[0] = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, object_id), _tmp0_), _tmp1_), values_length1 = 1, values_size = values_length1, _tmp2_);
	_data4_->parent = NULL;
	cb = (_tmp3_ = __lambda9__rygel_database_row_callback, cb_target = block4_data_ref (_data4_), cb_target_destroy_notify = block4_data_unref, _tmp3_);
#line 359 "rygel-media-db.vala"
	rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_GET_OBJECT_WITH_CLOSURE, values, values_length1, cb, cb_target, &_inner_error_);
#line 1010 "rygel-media-db.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			(cb_target_destroy_notify == NULL) ? NULL : cb_target_destroy_notify (cb_target);
			cb = NULL;
			cb_target = NULL;
			cb_target_destroy_notify = NULL;
			block4_data_unref (_data4_);
			return NULL;
		} else {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			(cb_target_destroy_notify == NULL) ? NULL : cb_target_destroy_notify (cb_target);
			cb = NULL;
			cb_target = NULL;
			cb_target_destroy_notify = NULL;
			block4_data_unref (_data4_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _g_object_ref0 (_data4_->parent);
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	(cb_target_destroy_notify == NULL) ? NULL : cb_target_destroy_notify (cb_target);
	cb = NULL;
	cb_target = NULL;
	cb_target_destroy_notify = NULL;
	block4_data_unref (_data4_);
#line 360 "rygel-media-db.vala"
	return result;
#line 1042 "rygel-media-db.c"
}


#line 363 "rygel-media-db.vala"
RygelMediaItem* rygel_media_db_get_item (RygelMediaDB* self, const char* item_id, GError** error) {
#line 1048 "rygel-media-db.c"
	RygelMediaItem* result;
	GError * _inner_error_;
	RygelMediaObject* obj;
	gboolean _tmp0_ = FALSE;
#line 363 "rygel-media-db.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 363 "rygel-media-db.vala"
	g_return_val_if_fail (item_id != NULL, NULL);
#line 1057 "rygel-media-db.c"
	_inner_error_ = NULL;
#line 365 "rygel-media-db.vala"
	obj = rygel_media_db_get_object (self, item_id, &_inner_error_);
#line 1061 "rygel-media-db.c"
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == RYGEL_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_DB_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
#line 366 "rygel-media-db.vala"
	if (obj != NULL) {
#line 366 "rygel-media-db.vala"
		_tmp0_ = !RYGEL_IS_MEDIA_ITEM (obj);
#line 1076 "rygel-media-db.c"
	} else {
#line 366 "rygel-media-db.vala"
		_tmp0_ = FALSE;
#line 1080 "rygel-media-db.c"
	}
#line 366 "rygel-media-db.vala"
	if (_tmp0_) {
#line 1084 "rygel-media-db.c"
		_inner_error_ = g_error_new (RYGEL_MEDIA_DB_ERROR, RYGEL_MEDIA_DB_ERROR_INVALID_TYPE, "Object with id %s is not a" "MediaItem", item_id);
		{
			if ((_inner_error_->domain == RYGEL_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_DB_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (obj);
				return NULL;
			} else {
				_g_object_unref0 (obj);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	result = _g_object_ref0 (RYGEL_MEDIA_ITEM (obj));
	_g_object_unref0 (obj);
#line 370 "rygel-media-db.vala"
	return result;
#line 1103 "rygel-media-db.c"
}


#line 373 "rygel-media-db.vala"
RygelMediaContainer* rygel_media_db_get_container (RygelMediaDB* self, const char* container_id, GError** error) {
#line 1109 "rygel-media-db.c"
	RygelMediaContainer* result;
	GError * _inner_error_;
	RygelMediaObject* obj;
	gboolean _tmp0_ = FALSE;
#line 373 "rygel-media-db.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 373 "rygel-media-db.vala"
	g_return_val_if_fail (container_id != NULL, NULL);
#line 1118 "rygel-media-db.c"
	_inner_error_ = NULL;
#line 375 "rygel-media-db.vala"
	obj = rygel_media_db_get_object (self, container_id, &_inner_error_);
#line 1122 "rygel-media-db.c"
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == RYGEL_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_DB_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
#line 376 "rygel-media-db.vala"
	if (obj != NULL) {
#line 376 "rygel-media-db.vala"
		_tmp0_ = !RYGEL_IS_MEDIA_CONTAINER (obj);
#line 1137 "rygel-media-db.c"
	} else {
#line 376 "rygel-media-db.vala"
		_tmp0_ = FALSE;
#line 1141 "rygel-media-db.c"
	}
#line 376 "rygel-media-db.vala"
	if (_tmp0_) {
#line 1145 "rygel-media-db.c"
		_inner_error_ = g_error_new (RYGEL_MEDIA_DB_ERROR, RYGEL_MEDIA_DB_ERROR_INVALID_TYPE, "Object with id %s is not a" "MediaContainer", container_id);
		{
			if ((_inner_error_->domain == RYGEL_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_DB_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (obj);
				return NULL;
			} else {
				_g_object_unref0 (obj);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	result = _g_object_ref0 (RYGEL_MEDIA_CONTAINER (obj));
	_g_object_unref0 (obj);
#line 380 "rygel-media-db.vala"
	return result;
#line 1164 "rygel-media-db.c"
}


#line 389 "rygel-media-db.vala"
static gboolean _lambda8_ (sqlite3_stmt* stmt, Block5Data* _data5_) {
#line 1170 "rygel-media-db.c"
	RygelMediaDB * self;
	gboolean result;
	self = _data5_->self;
#line 389 "rygel-media-db.vala"
	g_return_val_if_fail (stmt != NULL, FALSE);
#line 390 "rygel-media-db.vala"
	_data5_->count = sqlite3_column_int (stmt, 0);
#line 1178 "rygel-media-db.c"
	result = FALSE;
#line 391 "rygel-media-db.vala"
	return result;
#line 1182 "rygel-media-db.c"
}


#line 389 "rygel-media-db.vala"
static gboolean __lambda8__rygel_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
#line 1188 "rygel-media-db.c"
	return _lambda8_ (stmt, self);
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	++_data5_->_ref_count_;
	return _data5_;
}


static void block5_data_unref (Block5Data* _data5_) {
	if ((--_data5_->_ref_count_) == 0) {
		_g_object_unref0 (_data5_->self);
		g_slice_free (Block5Data, _data5_);
	}
}


#line 383 "rygel-media-db.vala"
gint rygel_media_db_get_child_count (RygelMediaDB* self, const char* container_id, GError** error) {
#line 1209 "rygel-media-db.c"
	gint result;
	GError * _inner_error_;
	Block5Data* _data5_;
	GValue* _tmp2_;
	gint values_size;
	gint values_length1;
	GValue* _tmp1_ = NULL;
	GValue _tmp0_ = {0};
	GValue* values;
#line 383 "rygel-media-db.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 383 "rygel-media-db.vala"
	g_return_val_if_fail (container_id != NULL, 0);
#line 1223 "rygel-media-db.c"
	_inner_error_ = NULL;
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_data5_->count = 0;
	values = (_tmp2_ = (_tmp1_ = g_new0 (GValue, 1), _tmp1_[0] = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, container_id), _tmp0_), _tmp1_), values_length1 = 1, values_size = values_length1, _tmp2_);
#line 387 "rygel-media-db.vala"
	rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_CHILDREN_COUNT_STRING, values, values_length1, __lambda8__rygel_database_row_callback, _data5_, &_inner_error_);
#line 1232 "rygel-media-db.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			block5_data_unref (_data5_);
			return 0;
		} else {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			block5_data_unref (_data5_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = _data5_->count;
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	block5_data_unref (_data5_);
#line 394 "rygel-media-db.vala"
	return result;
#line 1252 "rygel-media-db.c"
}


#line 405 "rygel-media-db.vala"
static gboolean _lambda13_ (sqlite3_stmt* stmt, Block6Data* _data6_) {
#line 1258 "rygel-media-db.c"
	RygelMediaDB * self;
	gboolean result;
	self = _data6_->self;
#line 405 "rygel-media-db.vala"
	g_return_val_if_fail (stmt != NULL, FALSE);
#line 406 "rygel-media-db.vala"
	_data6_->exists = sqlite3_column_int (stmt, 0) == 1;
#line 407 "rygel-media-db.vala"
	_data6_->tmp_timestamp = sqlite3_column_int64 (stmt, 1);
#line 1268 "rygel-media-db.c"
	result = FALSE;
#line 408 "rygel-media-db.vala"
	return result;
#line 1272 "rygel-media-db.c"
}


#line 405 "rygel-media-db.vala"
static gboolean __lambda13__rygel_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
#line 1278 "rygel-media-db.c"
	return _lambda13_ (stmt, self);
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	++_data6_->_ref_count_;
	return _data6_;
}


static void block6_data_unref (Block6Data* _data6_) {
	if ((--_data6_->_ref_count_) == 0) {
		_g_object_unref0 (_data6_->self);
		g_slice_free (Block6Data, _data6_);
	}
}


#line 397 "rygel-media-db.vala"
gboolean rygel_media_db_exists (RygelMediaDB* self, const char* object_id, gint64* timestamp, GError** error) {
#line 1299 "rygel-media-db.c"
	gboolean result;
	GError * _inner_error_;
	Block6Data* _data6_;
	GValue* _tmp2_;
	gint values_size;
	gint values_length1;
	GValue* _tmp1_ = NULL;
	GValue _tmp0_ = {0};
	GValue* values;
#line 397 "rygel-media-db.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 397 "rygel-media-db.vala"
	g_return_val_if_fail (object_id != NULL, FALSE);
#line 1313 "rygel-media-db.c"
	_inner_error_ = NULL;
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_data6_->exists = FALSE;
	values = (_tmp2_ = (_tmp1_ = g_new0 (GValue, 1), _tmp1_[0] = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, object_id), _tmp0_), _tmp1_), values_length1 = 1, values_size = values_length1, _tmp2_);
	_data6_->tmp_timestamp = (gint64) 0;
#line 403 "rygel-media-db.vala"
	rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_OBJECT_EXISTS_STRING, values, values_length1, __lambda13__rygel_database_row_callback, _data6_, &_inner_error_);
#line 1323 "rygel-media-db.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			block6_data_unref (_data6_);
			return FALSE;
		} else {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			block6_data_unref (_data6_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
#line 412 "rygel-media-db.vala"
	*timestamp = _data6_->tmp_timestamp;
#line 1340 "rygel-media-db.c"
	result = _data6_->exists;
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	block6_data_unref (_data6_);
#line 413 "rygel-media-db.vala"
	return result;
#line 1346 "rygel-media-db.c"
}


#line 427 "rygel-media-db.vala"
static gboolean _lambda11_ (sqlite3_stmt* stmt, Block7Data* _data7_) {
#line 1352 "rygel-media-db.c"
	RygelMediaDB * self;
	gboolean result;
	char* child_id;
	RygelMediaObject* _tmp0_;
	RygelMediaObject* _tmp1_;
	RygelMediaContainer* _tmp4_;
	RygelMediaContainer* *_tmp3_;
	RygelMediaObject* _tmp2_;
	self = _data7_->self;
#line 427 "rygel-media-db.vala"
	g_return_val_if_fail (stmt != NULL, FALSE);
#line 428 "rygel-media-db.vala"
	child_id = g_strdup (sqlite3_column_text (stmt, 17));
#line 429 "rygel-media-db.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _data7_->children, _tmp0_ = rygel_media_db_get_object_from_statement (self, _data7_->parent, child_id, stmt));
#line 1368 "rygel-media-db.c"
	_g_object_unref0 (_tmp0_);
#line 432 "rygel-media-db.vala"
	(_tmp1_ = (RygelMediaObject*) gee_abstract_list_get ((GeeAbstractList*) _data7_->children, gee_collection_get_size ((GeeCollection*) _data7_->children) - 1))->parent = _data7_->parent;
#line 1372 "rygel-media-db.c"
	_g_object_unref0 (_tmp1_);
#line 433 "rygel-media-db.vala"
	_tmp3_ = &(_tmp2_ = (RygelMediaObject*) gee_abstract_list_get ((GeeAbstractList*) _data7_->children, gee_collection_get_size ((GeeCollection*) _data7_->children) - 1))->parent_ref;
#line 433 "rygel-media-db.vala"
	(*_tmp3_) = (_tmp4_ = _g_object_ref0 (_data7_->parent), _g_object_unref0 ((*_tmp3_)), _tmp4_);
#line 1378 "rygel-media-db.c"
	_g_object_unref0 (_tmp2_);
	result = TRUE;
	_g_free0 (child_id);
#line 435 "rygel-media-db.vala"
	return result;
#line 1384 "rygel-media-db.c"
}


#line 427 "rygel-media-db.vala"
static gboolean __lambda11__rygel_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
#line 1390 "rygel-media-db.c"
	return _lambda11_ (stmt, self);
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
	++_data7_->_ref_count_;
	return _data7_;
}


static void block7_data_unref (Block7Data* _data7_) {
	if ((--_data7_->_ref_count_) == 0) {
		_g_object_unref0 (_data7_->self);
		_g_object_unref0 (_data7_->parent);
		_g_object_unref0 (_data7_->children);
		g_slice_free (Block7Data, _data7_);
	}
}


#line 416 "rygel-media-db.vala"
GeeArrayList* rygel_media_db_get_children (RygelMediaDB* self, const char* container_id, glong offset, glong max_count, GError** error) {
#line 1413 "rygel-media-db.c"
	GeeArrayList* result;
	GError * _inner_error_;
	Block7Data* _data7_;
	RygelMediaObject* _tmp0_;
	RygelMediaContainer* _tmp1_;
	GValue* _tmp6_;
	gint values_size;
	gint values_length1;
	GValue* _tmp5_ = NULL;
	GValue _tmp4_ = {0};
	GValue _tmp3_ = {0};
	GValue _tmp2_ = {0};
	GValue* values;
	RygelDatabaseRowCallback _tmp7_;
	GDestroyNotify cb_target_destroy_notify = NULL;
	void* cb_target = NULL;
	RygelDatabaseRowCallback cb;
#line 416 "rygel-media-db.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 416 "rygel-media-db.vala"
	g_return_val_if_fail (container_id != NULL, NULL);
#line 1435 "rygel-media-db.c"
	_inner_error_ = NULL;
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_data7_->parent = NULL;
	_data7_->children = gee_array_list_new (RYGEL_TYPE_MEDIA_OBJECT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
#line 422 "rygel-media-db.vala"
	_tmp0_ = rygel_media_db_get_object (self, container_id, &_inner_error_);
#line 1444 "rygel-media-db.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		block7_data_unref (_data7_);
		return NULL;
	}
#line 422 "rygel-media-db.vala"
	_data7_->parent = (_tmp1_ = RYGEL_MEDIA_CONTAINER (_tmp0_), _g_object_unref0 (_data7_->parent), _tmp1_);
#line 1452 "rygel-media-db.c"
	values = (_tmp6_ = (_tmp5_ = g_new0 (GValue, 3), _tmp5_[0] = (g_value_init (&_tmp2_, G_TYPE_STRING), g_value_set_string (&_tmp2_, container_id), _tmp2_), _tmp5_[1] = (g_value_init (&_tmp3_, G_TYPE_INT64), g_value_set_int64 (&_tmp3_, (gint64) offset), _tmp3_), _tmp5_[2] = (g_value_init (&_tmp4_, G_TYPE_INT64), g_value_set_int64 (&_tmp4_, (gint64) max_count), _tmp4_), _tmp5_), values_length1 = 3, values_size = values_length1, _tmp6_);
	cb = (_tmp7_ = __lambda11__rygel_database_row_callback, cb_target = block7_data_ref (_data7_), cb_target_destroy_notify = block7_data_unref, _tmp7_);
#line 438 "rygel-media-db.vala"
	rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_GET_CHILDREN_STRING, values, values_length1, cb, cb_target, &_inner_error_);
#line 1457 "rygel-media-db.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		(cb_target_destroy_notify == NULL) ? NULL : cb_target_destroy_notify (cb_target);
		cb = NULL;
		cb_target = NULL;
		cb_target_destroy_notify = NULL;
		block7_data_unref (_data7_);
		return NULL;
	}
	result = _g_object_ref0 (_data7_->children);
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	(cb_target_destroy_notify == NULL) ? NULL : cb_target_destroy_notify (cb_target);
	cb = NULL;
	cb_target = NULL;
	cb_target_destroy_notify = NULL;
	block7_data_unref (_data7_);
#line 439 "rygel-media-db.vala"
	return result;
#line 1477 "rygel-media-db.c"
}


#line 459 "rygel-media-db.vala"
static gboolean _lambda12_ (sqlite3_stmt* stmt, Block8Data* _data8_) {
#line 1483 "rygel-media-db.c"
	RygelMediaDB * self;
	gboolean result;
	GError * _inner_error_;
	char* child_id;
	char* parent_id;
	self = _data8_->self;
#line 459 "rygel-media-db.vala"
	g_return_val_if_fail (stmt != NULL, FALSE);
#line 1492 "rygel-media-db.c"
	_inner_error_ = NULL;
#line 460 "rygel-media-db.vala"
	child_id = g_strdup (sqlite3_column_text (stmt, 17));
#line 461 "rygel-media-db.vala"
	parent_id = g_strdup (sqlite3_column_text (stmt, 18));
#line 1498 "rygel-media-db.c"
	{
		RygelMediaObject* _tmp0_;
		RygelMediaContainer* parent;
		RygelMediaObject* _tmp1_;
		RygelMediaObject* _tmp2_;
		RygelMediaContainer* _tmp5_;
		RygelMediaContainer* *_tmp4_;
		RygelMediaObject* _tmp3_;
#line 463 "rygel-media-db.vala"
		_tmp0_ = rygel_media_db_get_object (self, parent_id, &_inner_error_);
#line 1509 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch52_rygel_database_error;
			}
			_g_free0 (child_id);
			_g_free0 (parent_id);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
#line 463 "rygel-media-db.vala"
		parent = RYGEL_MEDIA_CONTAINER (_tmp0_);
#line 464 "rygel-media-db.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _data8_->children, _tmp1_ = rygel_media_db_get_object_from_statement (self, parent, child_id, stmt));
#line 1524 "rygel-media-db.c"
		_g_object_unref0 (_tmp1_);
#line 467 "rygel-media-db.vala"
		(_tmp2_ = (RygelMediaObject*) gee_abstract_list_get ((GeeAbstractList*) _data8_->children, gee_collection_get_size ((GeeCollection*) _data8_->children) - 1))->parent = parent;
#line 1528 "rygel-media-db.c"
		_g_object_unref0 (_tmp2_);
#line 468 "rygel-media-db.vala"
		_tmp4_ = &(_tmp3_ = (RygelMediaObject*) gee_abstract_list_get ((GeeAbstractList*) _data8_->children, gee_collection_get_size ((GeeCollection*) _data8_->children) - 1))->parent_ref;
#line 468 "rygel-media-db.vala"
		(*_tmp4_) = (_tmp5_ = _g_object_ref0 (parent), _g_object_unref0 ((*_tmp4_)), _tmp5_);
#line 1534 "rygel-media-db.c"
		_g_object_unref0 (_tmp3_);
		result = TRUE;
		_g_object_unref0 (parent);
		_g_free0 (child_id);
		_g_free0 (parent_id);
#line 470 "rygel-media-db.vala"
		return result;
#line 1542 "rygel-media-db.c"
	}
	goto __finally52;
	__catch52_rygel_database_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 472 "rygel-media-db.vala"
			g_warning ("rygel-media-db.vala:472: Failed to get parent item: %s", e->message);
#line 1553 "rygel-media-db.c"
			result = FALSE;
			_g_error_free0 (e);
			_g_free0 (child_id);
			_g_free0 (parent_id);
#line 473 "rygel-media-db.vala"
			return result;
#line 1560 "rygel-media-db.c"
		}
	}
	__finally52:
	if (_inner_error_ != NULL) {
		_g_free0 (child_id);
		_g_free0 (parent_id);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_g_free0 (child_id);
	_g_free0 (parent_id);
}


#line 459 "rygel-media-db.vala"
static gboolean __lambda12__rygel_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
#line 1578 "rygel-media-db.c"
	return _lambda12_ (stmt, self);
}


static Block8Data* block8_data_ref (Block8Data* _data8_) {
	++_data8_->_ref_count_;
	return _data8_;
}


static void block8_data_unref (Block8Data* _data8_) {
	if ((--_data8_->_ref_count_) == 0) {
		_g_object_unref0 (_data8_->self);
		_g_object_unref0 (_data8_->children);
		g_slice_free (Block8Data, _data8_);
	}
}


#line 442 "rygel-media-db.vala"
GeeArrayList* rygel_media_db_get_objects_by_filter (RygelMediaDB* self, const char* filter, GValueArray* args, const char* container_id, glong offset, glong max_count, GError** error) {
#line 1600 "rygel-media-db.c"
	GeeArrayList* result;
	GError * _inner_error_;
	Block8Data* _data8_;
	GValue _tmp0_ = {0};
	GValue v;
	GValue _tmp2_;
	GValue _tmp1_ = {0};
	GValue _tmp4_;
	GValue _tmp3_ = {0};
	RygelDatabaseRowCallback _tmp5_;
	GDestroyNotify cb_target_destroy_notify = NULL;
	void* cb_target = NULL;
	RygelDatabaseRowCallback cb;
	char* _tmp6_;
#line 442 "rygel-media-db.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 442 "rygel-media-db.vala"
	g_return_val_if_fail (filter != NULL, NULL);
#line 442 "rygel-media-db.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 442 "rygel-media-db.vala"
	g_return_val_if_fail (container_id != NULL, NULL);
#line 1623 "rygel-media-db.c"
	_inner_error_ = NULL;
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_data8_->children = gee_array_list_new (RYGEL_TYPE_MEDIA_OBJECT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
#line 450 "rygel-media-db.vala"
	v = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, container_id), _tmp0_);
#line 451 "rygel-media-db.vala"
	g_value_array_prepend (args, &v);
#line 452 "rygel-media-db.vala"
	v = (_tmp2_ = (g_value_init (&_tmp1_, G_TYPE_LONG), g_value_set_long (&_tmp1_, offset), _tmp1_), G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL, _tmp2_);
#line 453 "rygel-media-db.vala"
	g_value_array_append (args, &v);
#line 454 "rygel-media-db.vala"
	v = (_tmp4_ = (g_value_init (&_tmp3_, G_TYPE_LONG), g_value_set_long (&_tmp3_, max_count), _tmp3_), G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL, _tmp4_);
#line 455 "rygel-media-db.vala"
	g_value_array_append (args, &v);
#line 457 "rygel-media-db.vala"
	g_debug ("rygel-media-db.vala:457: Parameters to bind: %u", args->n_values);
#line 1643 "rygel-media-db.c"
	cb = (_tmp5_ = __lambda12__rygel_database_row_callback, cb_target = block8_data_ref (_data8_), cb_target_destroy_notify = block8_data_unref, _tmp5_);
#line 477 "rygel-media-db.vala"
	rygel_database_exec (self->priv->db, _tmp6_ = g_strdup_printf (RYGEL_MEDIA_DB_GET_OBJECTS_STRING_WITH_FILTER, filter), args->values, args->n_values, cb, cb_target, &_inner_error_);
#line 1647 "rygel-media-db.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
		(cb_target_destroy_notify == NULL) ? NULL : cb_target_destroy_notify (cb_target);
		cb = NULL;
		cb_target = NULL;
		cb_target_destroy_notify = NULL;
		block8_data_unref (_data8_);
		return NULL;
	}
	_g_free0 (_tmp6_);
	result = _g_object_ref0 (_data8_->children);
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	(cb_target_destroy_notify == NULL) ? NULL : cb_target_destroy_notify (cb_target);
	cb = NULL;
	cb_target = NULL;
	cb_target_destroy_notify = NULL;
	block8_data_unref (_data8_);
#line 480 "rygel-media-db.vala"
	return result;
#line 1668 "rygel-media-db.c"
}


#line 483 "rygel-media-db.vala"
static RygelMediaDB* rygel_media_db_construct (GType object_type, const char* name, RygelMediaDBObjectFactory* factory) {
#line 1674 "rygel-media-db.c"
	RygelMediaDB * self;
	RygelMediaDBObjectFactory* _tmp0_;
#line 483 "rygel-media-db.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 483 "rygel-media-db.vala"
	g_return_val_if_fail (factory != NULL, NULL);
#line 483 "rygel-media-db.vala"
	self = (RygelMediaDB*) g_object_new (object_type, NULL);
#line 484 "rygel-media-db.vala"
	rygel_media_db_open_db (self, name);
#line 485 "rygel-media-db.vala"
	self->priv->factory = (_tmp0_ = _g_object_ref0 (factory), _g_object_unref0 (self->priv->factory), _tmp0_);
#line 1687 "rygel-media-db.c"
	return self;
}


#line 483 "rygel-media-db.vala"
static RygelMediaDB* rygel_media_db_new (const char* name, RygelMediaDBObjectFactory* factory) {
#line 483 "rygel-media-db.vala"
	return rygel_media_db_construct (RYGEL_TYPE_MEDIA_DB, name, factory);
#line 1696 "rygel-media-db.c"
}


#line 495 "rygel-media-db.vala"
static gboolean _lambda14_ (sqlite3_stmt* stmt, Block9Data* _data9_) {
#line 1702 "rygel-media-db.c"
	RygelMediaDB * self;
	gboolean result;
	self = _data9_->self;
#line 495 "rygel-media-db.vala"
	g_return_val_if_fail (stmt != NULL, FALSE);
#line 496 "rygel-media-db.vala"
	_data9_->old_version = sqlite3_column_int (stmt, 0);
#line 1710 "rygel-media-db.c"
	result = FALSE;
#line 497 "rygel-media-db.vala"
	return result;
#line 1714 "rygel-media-db.c"
}


#line 495 "rygel-media-db.vala"
static gboolean __lambda14__rygel_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
#line 1720 "rygel-media-db.c"
	return _lambda14_ (stmt, self);
}


#line 532 "rygel-media-db.vala"
static gboolean _lambda15_ (sqlite3_stmt* stmt, Block10Data* _data10_) {
#line 1727 "rygel-media-db.c"
	Block9Data* _data9_;
	RygelMediaDB * self;
	gboolean result;
	_data9_ = _data10_->_data9_;
	self = _data9_->self;
#line 532 "rygel-media-db.vala"
	g_return_val_if_fail (stmt != NULL, FALSE);
#line 533 "rygel-media-db.vala"
	_data10_->rows = sqlite3_column_int (stmt, 0);
#line 1737 "rygel-media-db.c"
	result = FALSE;
#line 534 "rygel-media-db.vala"
	return result;
#line 1741 "rygel-media-db.c"
}


#line 532 "rygel-media-db.vala"
static gboolean __lambda15__rygel_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
#line 1747 "rygel-media-db.c"
	return _lambda15_ (stmt, self);
}


static Block10Data* block10_data_ref (Block10Data* _data10_) {
	++_data10_->_ref_count_;
	return _data10_;
}


static void block10_data_unref (Block10Data* _data10_) {
	if ((--_data10_->_ref_count_) == 0) {
		block9_data_unref (_data10_->_data9_);
		g_slice_free (Block10Data, _data10_);
	}
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
	++_data9_->_ref_count_;
	return _data9_;
}


static void block9_data_unref (Block9Data* _data9_) {
	if ((--_data9_->_ref_count_) == 0) {
		_g_object_unref0 (_data9_->self);
		g_slice_free (Block9Data, _data9_);
	}
}


#line 488 "rygel-media-db.vala"
static void rygel_media_db_open_db (RygelMediaDB* self, const char* name) {
#line 1782 "rygel-media-db.c"
	GError * _inner_error_;
	Block9Data* _data9_;
	RygelDatabase* _tmp0_;
#line 488 "rygel-media-db.vala"
	g_return_if_fail (self != NULL);
#line 488 "rygel-media-db.vala"
	g_return_if_fail (name != NULL);
#line 1790 "rygel-media-db.c"
	_inner_error_ = NULL;
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
#line 489 "rygel-media-db.vala"
	self->priv->db = (_tmp0_ = rygel_database_new (name), _g_object_unref0 (self->priv->db), _tmp0_);
#line 1797 "rygel-media-db.c"
	_data9_->old_version = -1;
	{
		gint current_version;
#line 493 "rygel-media-db.vala"
		rygel_database_exec (self->priv->db, "SELECT version FROM schema_info", NULL, 0, __lambda14__rygel_database_row_callback, _data9_, &_inner_error_);
#line 1803 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch53_rygel_database_error;
			}
			block9_data_unref (_data9_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 499 "rygel-media-db.vala"
		current_version = atoi (RYGEL_MEDIA_DB_schema_version);
#line 500 "rygel-media-db.vala"
		if (_data9_->old_version == current_version) {
#line 501 "rygel-media-db.vala"
			g_debug ("rygel-media-db.vala:501: Media DB schema has current version");
#line 1819 "rygel-media-db.c"
		} else {
#line 503 "rygel-media-db.vala"
			if (_data9_->old_version < current_version) {
#line 504 "rygel-media-db.vala"
				g_debug ("rygel-media-db.vala:504: Older schema detected. Upgrading...");
#line 505 "rygel-media-db.vala"
				switch (_data9_->old_version) {
#line 1827 "rygel-media-db.c"
					case 3:
					{
#line 507 "rygel-media-db.vala"
						rygel_media_db_update_v3_v4 (self);
#line 508 "rygel-media-db.vala"
						break;
#line 1834 "rygel-media-db.c"
					}
					case 4:
					{
#line 510 "rygel-media-db.vala"
						rygel_media_db_update_v4_v5 (self);
#line 511 "rygel-media-db.vala"
						break;
#line 1842 "rygel-media-db.c"
					}
					default:
					{
						RygelDatabase* _tmp1_;
#line 513 "rygel-media-db.vala"
						g_warning ("rygel-media-db.vala:513: Cannot upgrade");
#line 514 "rygel-media-db.vala"
						self->priv->db = (_tmp1_ = NULL, _g_object_unref0 (self->priv->db), _tmp1_);
#line 515 "rygel-media-db.vala"
						break;
#line 1853 "rygel-media-db.c"
					}
				}
			} else {
				RygelDatabase* _tmp2_;
#line 518 "rygel-media-db.vala"
				g_warning ("The version \"%d\" of the detected database" " is newer than our supported version \"%d\"", _data9_->old_version, current_version);
#line 521 "rygel-media-db.vala"
				self->priv->db = (_tmp2_ = NULL, _g_object_unref0 (self->priv->db), _tmp2_);
#line 1862 "rygel-media-db.c"
			}
		}
	}
	goto __finally53;
	__catch53_rygel_database_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
#line 525 "rygel-media-db.vala"
			g_debug ("rygel-media-db.vala:525: %s", "Could not find schema version;" " checking for empty database...");
#line 1875 "rygel-media-db.c"
			{
				Block10Data* _data10_;
				_data10_ = g_slice_new0 (Block10Data);
				_data10_->_ref_count_ = 1;
				_data10_->_data9_ = block9_data_ref (_data9_);
				_data10_->rows = -1;
#line 529 "rygel-media-db.vala"
				rygel_database_exec (self->priv->db, "SELECT count(type) FROM sqlite_master " "WHERE rowid=1", NULL, 0, __lambda15__rygel_database_row_callback, _data10_, &_inner_error_);
#line 1884 "rygel-media-db.c"
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
						goto __catch54_rygel_database_error;
					}
					block10_data_unref (_data10_);
					_g_error_free0 (err);
					block9_data_unref (_data9_);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
#line 536 "rygel-media-db.vala"
				if (_data10_->rows == 0) {
#line 537 "rygel-media-db.vala"
					g_debug ("rygel-media-db.vala:537: Empty database, creating new schema version %s", RYGEL_MEDIA_DB_schema_version);
#line 539 "rygel-media-db.vala"
					if (!rygel_media_db_create_schema (self)) {
#line 1902 "rygel-media-db.c"
						RygelDatabase* _tmp3_;
#line 540 "rygel-media-db.vala"
						self->priv->db = (_tmp3_ = NULL, _g_object_unref0 (self->priv->db), _tmp3_);
#line 1906 "rygel-media-db.c"
						block10_data_unref (_data10_);
						_g_error_free0 (err);
						block9_data_unref (_data9_);
#line 541 "rygel-media-db.vala"
						return;
#line 1912 "rygel-media-db.c"
					}
				} else {
					RygelDatabase* _tmp4_;
#line 544 "rygel-media-db.vala"
					g_warning ("rygel-media-db.vala:544: Incompatible schema... cannot proceed");
#line 545 "rygel-media-db.vala"
					self->priv->db = (_tmp4_ = NULL, _g_object_unref0 (self->priv->db), _tmp4_);
#line 1920 "rygel-media-db.c"
					block10_data_unref (_data10_);
					_g_error_free0 (err);
					block9_data_unref (_data9_);
#line 546 "rygel-media-db.vala"
					return;
#line 1926 "rygel-media-db.c"
				}
				block10_data_unref (_data10_);
			}
			goto __finally54;
			__catch54_rygel_database_error:
			{
				GError * err2;
				err2 = _inner_error_;
				_inner_error_ = NULL;
				{
					RygelDatabase* _tmp5_;
#line 549 "rygel-media-db.vala"
					g_warning ("rygel-media-db.vala:549: Something weird going on: %s", err2->message);
#line 550 "rygel-media-db.vala"
					self->priv->db = (_tmp5_ = NULL, _g_object_unref0 (self->priv->db), _tmp5_);
#line 1942 "rygel-media-db.c"
					_g_error_free0 (err2);
				}
			}
			__finally54:
			if (_inner_error_ != NULL) {
				_g_error_free0 (err);
				_g_error_free0 (err);
				block9_data_unref (_data9_);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_g_error_free0 (err);
		}
	}
	__finally53:
	if (_inner_error_ != NULL) {
		block9_data_unref (_data9_);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	block9_data_unref (_data9_);
}


#line 555 "rygel-media-db.vala"
static void rygel_media_db_update_v3_v4 (RygelMediaDB* self) {
#line 1971 "rygel-media-db.c"
	GError * _inner_error_;
#line 555 "rygel-media-db.vala"
	g_return_if_fail (self != NULL);
#line 1975 "rygel-media-db.c"
	_inner_error_ = NULL;
	{
#line 557 "rygel-media-db.vala"
		rygel_database_begin (self->priv->db, &_inner_error_);
#line 1980 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch55_rygel_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 558 "rygel-media-db.vala"
		rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_UPDATE_V3_V4_STRING_1, NULL, 0, NULL, NULL, &_inner_error_);
#line 1991 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch55_rygel_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 559 "rygel-media-db.vala"
		rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_UPDATE_V3_V4_STRING_2, NULL, 0, NULL, NULL, &_inner_error_);
#line 2002 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch55_rygel_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 560 "rygel-media-db.vala"
		rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_UPDATE_V3_V4_STRING_3, NULL, 0, NULL, NULL, &_inner_error_);
#line 2013 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch55_rygel_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 561 "rygel-media-db.vala"
		rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_UPDATE_V3_V4_STRING_4, NULL, 0, NULL, NULL, &_inner_error_);
#line 2024 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch55_rygel_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 562 "rygel-media-db.vala"
		rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_CREATE_TRIGGER_STRING, NULL, 0, NULL, NULL, &_inner_error_);
#line 2035 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch55_rygel_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 563 "rygel-media-db.vala"
		rygel_database_exec (self->priv->db, "UPDATE schema_info SET version = '4'", NULL, 0, NULL, NULL, &_inner_error_);
#line 2046 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch55_rygel_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 564 "rygel-media-db.vala"
		rygel_database_commit (self->priv->db, &_inner_error_);
#line 2057 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch55_rygel_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally55;
	__catch55_rygel_database_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			RygelDatabase* _tmp0_;
#line 566 "rygel-media-db.vala"
			rygel_database_rollback (self->priv->db);
#line 567 "rygel-media-db.vala"
			g_warning ("rygel-media-db.vala:567: Database upgrade failed: %s", err->message);
#line 568 "rygel-media-db.vala"
			self->priv->db = (_tmp0_ = NULL, _g_object_unref0 (self->priv->db), _tmp0_);
#line 2081 "rygel-media-db.c"
			_g_error_free0 (err);
		}
	}
	__finally55:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


#line 572 "rygel-media-db.vala"
static void rygel_media_db_update_v4_v5 (RygelMediaDB* self) {
#line 2096 "rygel-media-db.c"
	GError * _inner_error_;
#line 572 "rygel-media-db.vala"
	g_return_if_fail (self != NULL);
#line 2100 "rygel-media-db.c"
	_inner_error_ = NULL;
	{
#line 574 "rygel-media-db.vala"
		rygel_database_begin (self->priv->db, &_inner_error_);
#line 2105 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch56_rygel_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 575 "rygel-media-db.vala"
		rygel_database_exec (self->priv->db, "DROP TRIGGER IF EXISTS trgr_delete_children", NULL, 0, NULL, NULL, &_inner_error_);
#line 2116 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch56_rygel_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 576 "rygel-media-db.vala"
		rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_CREATE_CLOSURE_TABLE, NULL, 0, NULL, NULL, &_inner_error_);
#line 2127 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch56_rygel_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 578 "rygel-media-db.vala"
		rygel_database_exec (self->priv->db, "ALTER TABLE Object RENAME TO _Object", NULL, 0, NULL, NULL, &_inner_error_);
#line 2138 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch56_rygel_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 579 "rygel-media-db.vala"
		rygel_database_exec (self->priv->db, "CREATE TABLE Object AS SELECT * FROM _Object", NULL, 0, NULL, NULL, &_inner_error_);
#line 2149 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch56_rygel_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 580 "rygel-media-db.vala"
		rygel_database_exec (self->priv->db, "DELETE FROM Object", NULL, 0, NULL, NULL, &_inner_error_);
#line 2160 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch56_rygel_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 581 "rygel-media-db.vala"
		rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_CREATE_CLOSURE_TRIGGER_STRING, NULL, 0, NULL, NULL, &_inner_error_);
#line 2171 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch56_rygel_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 582 "rygel-media-db.vala"
		rygel_database_exec (self->priv->db, "INSERT INTO Object SELECT * FROM _Object", NULL, 0, NULL, NULL, &_inner_error_);
#line 2182 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch56_rygel_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 583 "rygel-media-db.vala"
		rygel_database_exec (self->priv->db, "DROP TABLE Object", NULL, 0, NULL, NULL, &_inner_error_);
#line 2193 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch56_rygel_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 584 "rygel-media-db.vala"
		rygel_database_exec (self->priv->db, "ALTER TABLE _Object RENAME TO Object", NULL, 0, NULL, NULL, &_inner_error_);
#line 2204 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch56_rygel_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 587 "rygel-media-db.vala"
		rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_CREATE_CLOSURE_TRIGGER_STRING, NULL, 0, NULL, NULL, &_inner_error_);
#line 2215 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch56_rygel_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 588 "rygel-media-db.vala"
		rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_CREATE_INDICES_STRING, NULL, 0, NULL, NULL, &_inner_error_);
#line 2226 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch56_rygel_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 589 "rygel-media-db.vala"
		rygel_database_exec (self->priv->db, "UPDATE schema_info SET version = '5'", NULL, 0, NULL, NULL, &_inner_error_);
#line 2237 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch56_rygel_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 590 "rygel-media-db.vala"
		rygel_database_commit (self->priv->db, &_inner_error_);
#line 2248 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch56_rygel_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 591 "rygel-media-db.vala"
		rygel_database_exec (self->priv->db, "VACUUM", NULL, 0, NULL, NULL, &_inner_error_);
#line 2259 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch56_rygel_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 592 "rygel-media-db.vala"
		rygel_database_analyze (self->priv->db);
#line 2270 "rygel-media-db.c"
	}
	goto __finally56;
	__catch56_rygel_database_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			RygelDatabase* _tmp0_;
#line 594 "rygel-media-db.vala"
			rygel_database_rollback (self->priv->db);
#line 595 "rygel-media-db.vala"
			g_warning ("rygel-media-db.vala:595: Database upgrade failed: %s", err->message);
#line 596 "rygel-media-db.vala"
			self->priv->db = (_tmp0_ = NULL, _g_object_unref0 (self->priv->db), _tmp0_);
#line 2286 "rygel-media-db.c"
			_g_error_free0 (err);
		}
	}
	__finally56:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


#line 600 "rygel-media-db.vala"
static void rygel_media_db_update_object_internal (RygelMediaDB* self, RygelMediaObject* obj, GError** error) {
#line 2301 "rygel-media-db.c"
	GError * _inner_error_;
	GValue* _tmp4_;
	gint values_size;
	gint values_length1;
	GValue* _tmp3_ = NULL;
	GValue _tmp2_ = {0};
	GValue _tmp1_ = {0};
	GValue _tmp0_ = {0};
	GValue* values;
#line 600 "rygel-media-db.vala"
	g_return_if_fail (self != NULL);
#line 600 "rygel-media-db.vala"
	g_return_if_fail (obj != NULL);
#line 2315 "rygel-media-db.c"
	_inner_error_ = NULL;
	values = (_tmp4_ = (_tmp3_ = g_new0 (GValue, 3), _tmp3_[0] = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, rygel_media_object_get_title (obj)), _tmp0_), _tmp3_[1] = (g_value_init (&_tmp1_, G_TYPE_INT64), g_value_set_int64 (&_tmp1_, (gint64) obj->modified), _tmp1_), _tmp3_[2] = (g_value_init (&_tmp2_, G_TYPE_STRING), g_value_set_string (&_tmp2_, obj->id), _tmp2_), _tmp3_), values_length1 = 3, values_size = values_length1, _tmp4_);
#line 602 "rygel-media-db.vala"
	rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_UPDATE_OBJECT_STRING, values, values_length1, NULL, NULL, &_inner_error_);
#line 2320 "rygel-media-db.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		return;
	}
	values = (_vala_GValue_array_free (values, values_length1), NULL);
}


#line 605 "rygel-media-db.vala"
static void rygel_media_db_remove_uris (RygelMediaDB* self, RygelMediaObject* obj, GError** error) {
#line 2332 "rygel-media-db.c"
	GError * _inner_error_;
	GValue* _tmp2_;
	gint values_size;
	gint values_length1;
	GValue* _tmp1_ = NULL;
	GValue _tmp0_ = {0};
	GValue* values;
#line 605 "rygel-media-db.vala"
	g_return_if_fail (self != NULL);
#line 605 "rygel-media-db.vala"
	g_return_if_fail (obj != NULL);
#line 2344 "rygel-media-db.c"
	_inner_error_ = NULL;
	values = (_tmp2_ = (_tmp1_ = g_new0 (GValue, 1), _tmp1_[0] = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, obj->id), _tmp0_), _tmp1_), values_length1 = 1, values_size = values_length1, _tmp2_);
#line 607 "rygel-media-db.vala"
	rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_DELETE_URI_STRING, values, values_length1, NULL, NULL, &_inner_error_);
#line 2349 "rygel-media-db.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		return;
	}
	values = (_vala_GValue_array_free (values, values_length1), NULL);
}


#line 610 "rygel-media-db.vala"
static void rygel_media_db_save_metadata (RygelMediaDB* self, RygelMediaItem* item, GError** error) {
#line 2361 "rygel-media-db.c"
	GError * _inner_error_;
	GValue* _tmp17_;
	gint values_size;
	gint values_length1;
	GValue* _tmp16_ = NULL;
	GValue _tmp15_ = {0};
	GValue _tmp14_ = {0};
	GValue _tmp13_ = {0};
	GValue _tmp12_ = {0};
	GValue _tmp11_ = {0};
	GValue _tmp10_ = {0};
	GValue _tmp9_ = {0};
	GValue _tmp8_ = {0};
	GValue _tmp7_ = {0};
	GValue _tmp6_ = {0};
	GValue _tmp5_ = {0};
	GValue _tmp4_ = {0};
	GValue _tmp3_ = {0};
	GValue _tmp2_ = {0};
	GValue _tmp1_ = {0};
	GValue _tmp0_ = {0};
	GValue* values;
#line 610 "rygel-media-db.vala"
	g_return_if_fail (self != NULL);
#line 610 "rygel-media-db.vala"
	g_return_if_fail (item != NULL);
#line 2388 "rygel-media-db.c"
	_inner_error_ = NULL;
	values = (_tmp17_ = (_tmp16_ = g_new0 (GValue, 16), _tmp16_[0] = (g_value_init (&_tmp0_, G_TYPE_LONG), g_value_set_long (&_tmp0_, item->size), _tmp0_), _tmp16_[1] = (g_value_init (&_tmp1_, G_TYPE_STRING), g_value_set_string (&_tmp1_, item->mime_type), _tmp1_), _tmp16_[2] = (g_value_init (&_tmp2_, G_TYPE_INT), g_value_set_int (&_tmp2_, item->width), _tmp2_), _tmp16_[3] = (g_value_init (&_tmp3_, G_TYPE_INT), g_value_set_int (&_tmp3_, item->height), _tmp3_), _tmp16_[4] = (g_value_init (&_tmp4_, G_TYPE_STRING), g_value_set_string (&_tmp4_, ((RygelMediaObject*) item)->upnp_class), _tmp4_), _tmp16_[5] = (g_value_init (&_tmp5_, G_TYPE_STRING), g_value_set_string (&_tmp5_, item->author), _tmp5_), _tmp16_[6] = (g_value_init (&_tmp6_, G_TYPE_STRING), g_value_set_string (&_tmp6_, item->album), _tmp6_), _tmp16_[7] = (g_value_init (&_tmp7_, G_TYPE_STRING), g_value_set_string (&_tmp7_, item->date), _tmp7_), _tmp16_[8] = (g_value_init (&_tmp8_, G_TYPE_INT), g_value_set_int (&_tmp8_, item->bitrate), _tmp8_), _tmp16_[9] = (g_value_init (&_tmp9_, G_TYPE_INT), g_value_set_int (&_tmp9_, item->sample_freq), _tmp9_), _tmp16_[10] = (g_value_init (&_tmp10_, G_TYPE_INT), g_value_set_int (&_tmp10_, item->bits_per_sample), _tmp10_), _tmp16_[11] = (g_value_init (&_tmp11_, G_TYPE_INT), g_value_set_int (&_tmp11_, item->n_audio_channels), _tmp11_), _tmp16_[12] = (g_value_init (&_tmp12_, G_TYPE_INT), g_value_set_int (&_tmp12_, item->track_number), _tmp12_), _tmp16_[13] = (g_value_init (&_tmp13_, G_TYPE_INT), g_value_set_int (&_tmp13_, item->color_depth), _tmp13_), _tmp16_[14] = (g_value_init (&_tmp14_, G_TYPE_LONG), g_value_set_long (&_tmp14_, item->duration), _tmp14_), _tmp16_[15] = (g_value_init (&_tmp15_, G_TYPE_STRING), g_value_set_string (&_tmp15_, ((RygelMediaObject*) item)->id), _tmp15_), _tmp16_), values_length1 = 16, values_size = values_length1, _tmp17_);
#line 627 "rygel-media-db.vala"
	rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_SAVE_META_DATA_STRING, values, values_length1, NULL, NULL, &_inner_error_);
#line 2393 "rygel-media-db.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		return;
	}
	values = (_vala_GValue_array_free (values, values_length1), NULL);
}


#line 630 "rygel-media-db.vala"
static void rygel_media_db_create_object (RygelMediaDB* self, RygelMediaObject* item, GError** error) {
#line 2405 "rygel-media-db.c"
	GError * _inner_error_;
	gint _tmp0_ = 0;
	GValue _tmp1_ = {0};
	GValue* _tmp12_;
	gint values_size;
	gint values_length1;
	GValue* _tmp11_ = NULL;
	GValue _tmp10_ = {0};
	GValue _tmp9_ = {0};
	GValue _tmp8_ = {0};
	GValue _tmp7_ = {0};
	GValue _tmp6_ = {0};
	GValue* values;
#line 630 "rygel-media-db.vala"
	g_return_if_fail (self != NULL);
#line 630 "rygel-media-db.vala"
	g_return_if_fail (item != NULL);
#line 2423 "rygel-media-db.c"
	_inner_error_ = NULL;
#line 633 "rygel-media-db.vala"
	if (RYGEL_IS_MEDIA_ITEM (item)) {
#line 634 "rygel-media-db.vala"
		_tmp0_ = (gint) RYGEL_MEDIA_DB_OBJECT_TYPE_ITEM;
#line 2429 "rygel-media-db.c"
	} else {
#line 635 "rygel-media-db.vala"
		_tmp0_ = (gint) RYGEL_MEDIA_DB_OBJECT_TYPE_CONTAINER;
#line 2433 "rygel-media-db.c"
	}
#line 636 "rygel-media-db.vala"
	if (item->parent == NULL) {
#line 2437 "rygel-media-db.c"
		GValue _tmp3_;
		GValue _tmp2_ = {0};
#line 636 "rygel-media-db.vala"
		_tmp1_ = (_tmp3_ = (rygel_database_null (&_tmp2_), _tmp2_), G_IS_VALUE (&_tmp1_) ? (g_value_unset (&_tmp1_), NULL) : NULL, _tmp3_);
#line 2442 "rygel-media-db.c"
	} else {
		GValue _tmp5_;
		GValue _tmp4_ = {0};
#line 637 "rygel-media-db.vala"
		_tmp1_ = (_tmp5_ = (g_value_init (&_tmp4_, G_TYPE_STRING), g_value_set_string (&_tmp4_, ((RygelMediaObject*) item->parent)->id), _tmp4_), G_IS_VALUE (&_tmp1_) ? (g_value_unset (&_tmp1_), NULL) : NULL, _tmp5_);
#line 2448 "rygel-media-db.c"
	}
	values = (_tmp12_ = (_tmp11_ = g_new0 (GValue, 5), _tmp11_[0] = (g_value_init (&_tmp6_, G_TYPE_STRING), g_value_set_string (&_tmp6_, item->id), _tmp6_), _tmp11_[1] = (g_value_init (&_tmp7_, G_TYPE_STRING), g_value_set_string (&_tmp7_, rygel_media_object_get_title (item)), _tmp7_), _tmp11_[2] = (g_value_init (&_tmp8_, G_TYPE_INT), g_value_set_int (&_tmp8_, _tmp0_), _tmp8_), _tmp11_[3] = G_IS_VALUE (&_tmp1_) ? (g_value_init (&_tmp9_, G_VALUE_TYPE (&_tmp1_)), g_value_copy (&_tmp1_, &_tmp9_), _tmp9_) : _tmp1_, _tmp11_[4] = (g_value_init (&_tmp10_, G_TYPE_INT64), g_value_set_int64 (&_tmp10_, (gint64) item->modified), _tmp10_), _tmp11_), values_length1 = 5, values_size = values_length1, _tmp12_);
#line 639 "rygel-media-db.vala"
	rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_INSERT_OBJECT_STRING, values, values_length1, NULL, NULL, &_inner_error_);
#line 2453 "rygel-media-db.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		G_IS_VALUE (&_tmp1_) ? (g_value_unset (&_tmp1_), NULL) : NULL;
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		return;
	}
	G_IS_VALUE (&_tmp1_) ? (g_value_unset (&_tmp1_), NULL) : NULL;
	values = (_vala_GValue_array_free (values, values_length1), NULL);
}


#line 642 "rygel-media-db.vala"
static void rygel_media_db_save_uris (RygelMediaDB* self, RygelMediaObject* obj, GError** error) {
#line 2467 "rygel-media-db.c"
	GError * _inner_error_;
#line 642 "rygel-media-db.vala"
	g_return_if_fail (self != NULL);
#line 642 "rygel-media-db.vala"
	g_return_if_fail (obj != NULL);
#line 2473 "rygel-media-db.c"
	_inner_error_ = NULL;
	{
		GeeIterator* _uri_it;
		_uri_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) obj->uris);
#line 643 "rygel-media-db.vala"
		while (TRUE) {
#line 2480 "rygel-media-db.c"
			char* uri;
			GValue* _tmp3_;
			gint values_size;
			gint values_length1;
			GValue* _tmp2_ = NULL;
			GValue _tmp1_ = {0};
			GValue _tmp0_ = {0};
			GValue* values;
#line 643 "rygel-media-db.vala"
			if (!gee_iterator_next (_uri_it)) {
#line 643 "rygel-media-db.vala"
				break;
#line 2493 "rygel-media-db.c"
			}
#line 643 "rygel-media-db.vala"
			uri = (char*) gee_iterator_get (_uri_it);
#line 2497 "rygel-media-db.c"
			values = (_tmp3_ = (_tmp2_ = g_new0 (GValue, 2), _tmp2_[0] = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, obj->id), _tmp0_), _tmp2_[1] = (g_value_init (&_tmp1_, G_TYPE_STRING), g_value_set_string (&_tmp1_, uri), _tmp1_), _tmp2_), values_length1 = 2, values_size = values_length1, _tmp3_);
#line 645 "rygel-media-db.vala"
			rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_INSERT_URI_STRING, values, values_length1, NULL, NULL, &_inner_error_);
#line 2501 "rygel-media-db.c"
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (uri);
				values = (_vala_GValue_array_free (values, values_length1), NULL);
				_g_object_unref0 (_uri_it);
				return;
			}
			_g_free0 (uri);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
		}
		_g_object_unref0 (_uri_it);
	}
}


#line 657 "rygel-media-db.vala"
static gboolean rygel_media_db_create_schema (RygelMediaDB* self) {
#line 2519 "rygel-media-db.c"
	gboolean result;
	GError * _inner_error_;
#line 657 "rygel-media-db.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 2524 "rygel-media-db.c"
	_inner_error_ = NULL;
	{
#line 659 "rygel-media-db.vala"
		rygel_database_begin (self->priv->db, &_inner_error_);
#line 2529 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			goto __catch57_g_error;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
#line 660 "rygel-media-db.vala"
		rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_SCHEMA_STRING, NULL, 0, NULL, NULL, &_inner_error_);
#line 2538 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			goto __catch57_g_error;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
#line 661 "rygel-media-db.vala"
		rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_CREATE_TRIGGER_STRING, NULL, 0, NULL, NULL, &_inner_error_);
#line 2547 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			goto __catch57_g_error;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
#line 662 "rygel-media-db.vala"
		rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_CREATE_CLOSURE_TABLE, NULL, 0, NULL, NULL, &_inner_error_);
#line 2556 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			goto __catch57_g_error;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
#line 663 "rygel-media-db.vala"
		rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_CREATE_INDICES_STRING, NULL, 0, NULL, NULL, &_inner_error_);
#line 2565 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			goto __catch57_g_error;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
#line 664 "rygel-media-db.vala"
		rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_CREATE_CLOSURE_TRIGGER_STRING, NULL, 0, NULL, NULL, &_inner_error_);
#line 2574 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			goto __catch57_g_error;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
#line 665 "rygel-media-db.vala"
		rygel_database_commit (self->priv->db, &_inner_error_);
#line 2583 "rygel-media-db.c"
		if (_inner_error_ != NULL) {
			goto __catch57_g_error;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
#line 666 "rygel-media-db.vala"
		rygel_database_analyze (self->priv->db);
#line 2592 "rygel-media-db.c"
		result = TRUE;
#line 667 "rygel-media-db.vala"
		return result;
#line 2596 "rygel-media-db.c"
	}
	goto __finally57;
	__catch57_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
#line 669 "rygel-media-db.vala"
			g_warning ("rygel-media-db.vala:669: Failed to create schema: %s", err->message);
#line 670 "rygel-media-db.vala"
			rygel_database_rollback (self->priv->db);
#line 2609 "rygel-media-db.c"
			_g_error_free0 (err);
		}
	}
	__finally57:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
#line 672 "rygel-media-db.vala"
	return result;
#line 2622 "rygel-media-db.c"
}


#line 680 "rygel-media-db.vala"
static gboolean _lambda10_ (sqlite3_stmt* stmt, Block11Data* _data11_) {
#line 2628 "rygel-media-db.c"
	RygelMediaDB * self;
	gboolean result;
	self = _data11_->self;
#line 680 "rygel-media-db.vala"
	g_return_val_if_fail (stmt != NULL, FALSE);
#line 681 "rygel-media-db.vala"
	if (RYGEL_IS_MEDIA_ITEM (_data11_->obj)) {
#line 682 "rygel-media-db.vala"
		rygel_media_item_add_uri (RYGEL_MEDIA_ITEM (_data11_->obj), sqlite3_column_text (stmt, 0), NULL);
#line 2638 "rygel-media-db.c"
	} else {
#line 685 "rygel-media-db.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _data11_->obj->uris, sqlite3_column_text (stmt, 0));
#line 2642 "rygel-media-db.c"
	}
	result = TRUE;
#line 687 "rygel-media-db.vala"
	return result;
#line 2647 "rygel-media-db.c"
}


#line 680 "rygel-media-db.vala"
static gboolean __lambda10__rygel_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
#line 2653 "rygel-media-db.c"
	return _lambda10_ (stmt, self);
}


static Block11Data* block11_data_ref (Block11Data* _data11_) {
	++_data11_->_ref_count_;
	return _data11_;
}


static void block11_data_unref (Block11Data* _data11_) {
	if ((--_data11_->_ref_count_) == 0) {
		_g_object_unref0 (_data11_->self);
		_g_object_unref0 (_data11_->obj);
		g_slice_free (Block11Data, _data11_);
	}
}


#line 676 "rygel-media-db.vala"
static void rygel_media_db_add_uris (RygelMediaDB* self, RygelMediaObject* obj, GError** error) {
#line 2675 "rygel-media-db.c"
	GError * _inner_error_;
	Block11Data* _data11_;
	GValue* _tmp2_;
	gint values_size;
	gint values_length1;
	GValue* _tmp1_ = NULL;
	GValue _tmp0_ = {0};
	GValue* values;
#line 676 "rygel-media-db.vala"
	g_return_if_fail (self != NULL);
#line 676 "rygel-media-db.vala"
	g_return_if_fail (obj != NULL);
#line 2688 "rygel-media-db.c"
	_inner_error_ = NULL;
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->self = g_object_ref (self);
	_data11_->obj = _g_object_ref0 (obj);
	values = (_tmp2_ = (_tmp1_ = g_new0 (GValue, 1), _tmp1_[0] = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, _data11_->obj->id), _tmp0_), _tmp1_), values_length1 = 1, values_size = values_length1, _tmp2_);
#line 678 "rygel-media-db.vala"
	rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_URI_GET_STRING, values, values_length1, __lambda10__rygel_database_row_callback, _data11_, &_inner_error_);
#line 2697 "rygel-media-db.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			block11_data_unref (_data11_);
			return;
		} else {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			block11_data_unref (_data11_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	block11_data_unref (_data11_);
}


#line 691 "rygel-media-db.vala"
static RygelMediaObject* rygel_media_db_get_object_from_statement (RygelMediaDB* self, RygelMediaContainer* parent, const char* object_id, sqlite3_stmt* statement) {
#line 2719 "rygel-media-db.c"
	RygelMediaObject* result;
	GError * _inner_error_;
	RygelMediaObject* obj;
#line 691 "rygel-media-db.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 691 "rygel-media-db.vala"
	g_return_val_if_fail (object_id != NULL, NULL);
#line 691 "rygel-media-db.vala"
	g_return_val_if_fail (statement != NULL, NULL);
#line 2729 "rygel-media-db.c"
	_inner_error_ = NULL;
#line 694 "rygel-media-db.vala"
	obj = NULL;
#line 695 "rygel-media-db.vala"
	switch (sqlite3_column_int (statement, 0)) {
#line 2735 "rygel-media-db.c"
		case 0:
		{
			RygelMediaObject* _tmp0_;
#line 698 "rygel-media-db.vala"
			obj = (_tmp0_ = (RygelMediaObject*) rygel_media_db_object_factory_get_container (self->priv->factory, self, object_id, sqlite3_column_text (statement, 1), (guint) 0), _g_object_unref0 (obj), _tmp0_);
#line 702 "rygel-media-db.vala"
			break;
#line 2743 "rygel-media-db.c"
		}
		case 1:
		{
			RygelMediaObject* _tmp1_;
#line 705 "rygel-media-db.vala"
			obj = (_tmp1_ = (RygelMediaObject*) rygel_media_db_object_factory_get_item (self->priv->factory, self, parent, object_id, sqlite3_column_text (statement, 1), sqlite3_column_text (statement, 6)), _g_object_unref0 (obj), _tmp1_);
#line 710 "rygel-media-db.vala"
			rygel_media_db_fill_item (self, statement, RYGEL_MEDIA_ITEM (obj));
#line 711 "rygel-media-db.vala"
			break;
#line 2754 "rygel-media-db.c"
		}
		default:
		{
#line 713 "rygel-media-db.vala"
			g_assert_not_reached ();
#line 2760 "rygel-media-db.c"
		}
	}
	{
#line 717 "rygel-media-db.vala"
		if (obj != NULL) {
#line 718 "rygel-media-db.vala"
			obj->modified = (guint64) sqlite3_column_int64 (statement, 18);
#line 719 "rygel-media-db.vala"
			rygel_media_db_add_uris (self, obj, &_inner_error_);
#line 2770 "rygel-media-db.c"
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
					goto __catch58_rygel_database_error;
				}
				_g_object_unref0 (obj);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	goto __finally58;
	__catch58_rygel_database_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			RygelMediaObject* _tmp2_;
#line 722 "rygel-media-db.vala"
			g_warning ("rygel-media-db.vala:722: Failed to load uris from database: %s", err->message);
#line 723 "rygel-media-db.vala"
			obj = (_tmp2_ = NULL, _g_object_unref0 (obj), _tmp2_);
#line 2794 "rygel-media-db.c"
			_g_error_free0 (err);
		}
	}
	__finally58:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (obj);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = obj;
#line 725 "rygel-media-db.vala"
	return result;
#line 2808 "rygel-media-db.c"
}


#line 728 "rygel-media-db.vala"
static void rygel_media_db_fill_item (RygelMediaDB* self, sqlite3_stmt* statement, RygelMediaItem* item) {
#line 2814 "rygel-media-db.c"
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
#line 728 "rygel-media-db.vala"
	g_return_if_fail (self != NULL);
#line 728 "rygel-media-db.vala"
	g_return_if_fail (statement != NULL);
#line 728 "rygel-media-db.vala"
	g_return_if_fail (item != NULL);
#line 729 "rygel-media-db.vala"
	item->author = (_tmp0_ = g_strdup (sqlite3_column_text (statement, 7)), _g_free0 (item->author), _tmp0_);
#line 730 "rygel-media-db.vala"
	item->album = (_tmp1_ = g_strdup (sqlite3_column_text (statement, 8)), _g_free0 (item->album), _tmp1_);
#line 731 "rygel-media-db.vala"
	item->date = (_tmp2_ = g_strdup (sqlite3_column_text (statement, 9)), _g_free0 (item->date), _tmp2_);
#line 732 "rygel-media-db.vala"
	item->mime_type = (_tmp3_ = g_strdup (sqlite3_column_text (statement, 3)), _g_free0 (item->mime_type), _tmp3_);
#line 733 "rygel-media-db.vala"
	item->duration = (glong) sqlite3_column_int64 (statement, 16);
#line 735 "rygel-media-db.vala"
	item->size = (glong) sqlite3_column_int64 (statement, 2);
#line 736 "rygel-media-db.vala"
	item->bitrate = sqlite3_column_int (statement, 10);
#line 738 "rygel-media-db.vala"
	item->sample_freq = sqlite3_column_int (statement, 11);
#line 739 "rygel-media-db.vala"
	item->bits_per_sample = sqlite3_column_int (statement, 12);
#line 740 "rygel-media-db.vala"
	item->n_audio_channels = sqlite3_column_int (statement, 13);
#line 741 "rygel-media-db.vala"
	item->track_number = sqlite3_column_int (statement, 14);
#line 743 "rygel-media-db.vala"
	item->width = sqlite3_column_int (statement, 4);
#line 744 "rygel-media-db.vala"
	item->height = sqlite3_column_int (statement, 5);
#line 745 "rygel-media-db.vala"
	item->color_depth = sqlite3_column_int (statement, 15);
#line 2853 "rygel-media-db.c"
}


#line 755 "rygel-media-db.vala"
static gboolean _lambda16_ (sqlite3_stmt* stmt, Block12Data* _data12_) {
#line 2859 "rygel-media-db.c"
	RygelMediaDB * self;
	gboolean result;
	self = _data12_->self;
#line 755 "rygel-media-db.vala"
	g_return_val_if_fail (stmt != NULL, FALSE);
#line 756 "rygel-media-db.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _data12_->children, sqlite3_column_text (stmt, 0));
#line 2867 "rygel-media-db.c"
	result = TRUE;
#line 757 "rygel-media-db.vala"
	return result;
#line 2871 "rygel-media-db.c"
}


#line 755 "rygel-media-db.vala"
static gboolean __lambda16__rygel_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
#line 2877 "rygel-media-db.c"
	return _lambda16_ (stmt, self);
}


static Block12Data* block12_data_ref (Block12Data* _data12_) {
	++_data12_->_ref_count_;
	return _data12_;
}


static void block12_data_unref (Block12Data* _data12_) {
	if ((--_data12_->_ref_count_) == 0) {
		_g_object_unref0 (_data12_->self);
		_g_object_unref0 (_data12_->children);
		g_slice_free (Block12Data, _data12_);
	}
}


#line 748 "rygel-media-db.vala"
GeeArrayList* rygel_media_db_get_child_ids (RygelMediaDB* self, const char* container_id, GError** error) {
#line 2899 "rygel-media-db.c"
	GeeArrayList* result;
	GError * _inner_error_;
	Block12Data* _data12_;
	GValue* _tmp2_;
	gint values_size;
	gint values_length1;
	GValue* _tmp1_ = NULL;
	GValue _tmp0_ = {0};
	GValue* values;
#line 748 "rygel-media-db.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 748 "rygel-media-db.vala"
	g_return_val_if_fail (container_id != NULL, NULL);
#line 2913 "rygel-media-db.c"
	_inner_error_ = NULL;
	_data12_ = g_slice_new0 (Block12Data);
	_data12_->_ref_count_ = 1;
	_data12_->self = g_object_ref (self);
	_data12_->children = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_equal);
	values = (_tmp2_ = (_tmp1_ = g_new0 (GValue, 1), _tmp1_[0] = (g_value_init (&_tmp0_, G_TYPE_STRING), g_value_set_string (&_tmp0_, container_id), _tmp0_), _tmp1_), values_length1 = 1, values_size = values_length1, _tmp2_);
#line 753 "rygel-media-db.vala"
	rygel_database_exec (self->priv->db, RYGEL_MEDIA_DB_GET_CHILD_ID_STRING, values, values_length1, __lambda16__rygel_database_row_callback, _data12_, &_inner_error_);
#line 2922 "rygel-media-db.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			block12_data_unref (_data12_);
			return NULL;
		} else {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			block12_data_unref (_data12_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _g_object_ref0 (_data12_->children);
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	block12_data_unref (_data12_);
#line 760 "rygel-media-db.vala"
	return result;
#line 2942 "rygel-media-db.c"
}


static void rygel_media_db_class_init (RygelMediaDBClass * klass) {
	rygel_media_db_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaDBPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_media_db_finalize;
	g_signal_new ("object_added", RYGEL_TYPE_MEDIA_DB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("object_removed", RYGEL_TYPE_MEDIA_DB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("object_updated", RYGEL_TYPE_MEDIA_DB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("item_removed", RYGEL_TYPE_MEDIA_DB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("item_added", RYGEL_TYPE_MEDIA_DB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("item_updated", RYGEL_TYPE_MEDIA_DB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("container_added", RYGEL_TYPE_MEDIA_DB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("container_removed", RYGEL_TYPE_MEDIA_DB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("container_updated", RYGEL_TYPE_MEDIA_DB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}


static void rygel_media_db_instance_init (RygelMediaDB * self) {
	self->priv = RYGEL_MEDIA_DB_GET_PRIVATE (self);
}


static void rygel_media_db_finalize (GObject* obj) {
	RygelMediaDB * self;
	self = RYGEL_MEDIA_DB (obj);
	_g_object_unref0 (self->priv->db);
	_g_object_unref0 (self->priv->factory);
	G_OBJECT_CLASS (rygel_media_db_parent_class)->finalize (obj);
}


GType rygel_media_db_get_type (void) {
	static GType rygel_media_db_type_id = 0;
	if (rygel_media_db_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaDBClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_db_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaDB), 0, (GInstanceInitFunc) rygel_media_db_instance_init, NULL };
		rygel_media_db_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaDB", &g_define_type_info, 0);
	}
	return rygel_media_db_type_id;
}




