/* rygel-tracker-interfaces.c generated by valac, the Vala compiler
 * generated from rygel-tracker-interfaces.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus.h>


#define RYGEL_TYPE_TRACKER_STATS_IFACE (rygel_tracker_stats_iface_get_type ())
#define RYGEL_TRACKER_STATS_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKER_STATS_IFACE, RygelTrackerStatsIface))
#define RYGEL_IS_TRACKER_STATS_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKER_STATS_IFACE))
#define RYGEL_TRACKER_STATS_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_TRACKER_STATS_IFACE, RygelTrackerStatsIfaceIface))

typedef struct _RygelTrackerStatsIface RygelTrackerStatsIface;
typedef struct _RygelTrackerStatsIfaceIface RygelTrackerStatsIfaceIface;
typedef struct _RygelTrackerStatsIfaceDBusProxy RygelTrackerStatsIfaceDBusProxy;
typedef DBusGProxyClass RygelTrackerStatsIfaceDBusProxyClass;
typedef struct _RygelTrackerStatsIfaceDBusProxyGetStatisticsData RygelTrackerStatsIfaceDBusProxyGetStatisticsData;

#define RYGEL_TYPE_TRACKER_RESOURCES_IFACE (rygel_tracker_resources_iface_get_type ())
#define RYGEL_TRACKER_RESOURCES_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKER_RESOURCES_IFACE, RygelTrackerResourcesIface))
#define RYGEL_IS_TRACKER_RESOURCES_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKER_RESOURCES_IFACE))
#define RYGEL_TRACKER_RESOURCES_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_TRACKER_RESOURCES_IFACE, RygelTrackerResourcesIfaceIface))

typedef struct _RygelTrackerResourcesIface RygelTrackerResourcesIface;
typedef struct _RygelTrackerResourcesIfaceIface RygelTrackerResourcesIfaceIface;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelTrackerResourcesIfaceDBusProxy RygelTrackerResourcesIfaceDBusProxy;
typedef DBusGProxyClass RygelTrackerResourcesIfaceDBusProxyClass;
typedef struct _RygelTrackerResourcesIfaceDBusProxySparqlQueryData RygelTrackerResourcesIfaceDBusProxySparqlQueryData;
typedef struct _RygelTrackerResourcesIfaceDBusProxySparqlUpdateBlankData RygelTrackerResourcesIfaceDBusProxySparqlUpdateBlankData;

#define RYGEL_TYPE_TRACKER_RESOURCES_CLASS_IFACE (rygel_tracker_resources_class_iface_get_type ())
#define RYGEL_TRACKER_RESOURCES_CLASS_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKER_RESOURCES_CLASS_IFACE, RygelTrackerResourcesClassIface))
#define RYGEL_IS_TRACKER_RESOURCES_CLASS_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKER_RESOURCES_CLASS_IFACE))
#define RYGEL_TRACKER_RESOURCES_CLASS_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_TRACKER_RESOURCES_CLASS_IFACE, RygelTrackerResourcesClassIfaceIface))

typedef struct _RygelTrackerResourcesClassIface RygelTrackerResourcesClassIface;
typedef struct _RygelTrackerResourcesClassIfaceIface RygelTrackerResourcesClassIfaceIface;
typedef struct _RygelTrackerResourcesClassIfaceDBusProxy RygelTrackerResourcesClassIfaceDBusProxy;
typedef DBusGProxyClass RygelTrackerResourcesClassIfaceDBusProxyClass;

#define RYGEL_TYPE_TRACKER_MINER_IFACE (rygel_tracker_miner_iface_get_type ())
#define RYGEL_TRACKER_MINER_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKER_MINER_IFACE, RygelTrackerMinerIface))
#define RYGEL_IS_TRACKER_MINER_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKER_MINER_IFACE))
#define RYGEL_TRACKER_MINER_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_TRACKER_MINER_IFACE, RygelTrackerMinerIfaceIface))

typedef struct _RygelTrackerMinerIface RygelTrackerMinerIface;
typedef struct _RygelTrackerMinerIfaceIface RygelTrackerMinerIfaceIface;
typedef struct _RygelTrackerMinerIfaceDBusProxy RygelTrackerMinerIfaceDBusProxy;
typedef DBusGProxyClass RygelTrackerMinerIfaceDBusProxyClass;
typedef struct _RygelTrackerMinerIfaceDBusProxyIgnoreNextUpdateData RygelTrackerMinerIfaceDBusProxyIgnoreNextUpdateData;
typedef struct _DBusObjectVTable _DBusObjectVTable;

struct _RygelTrackerStatsIfaceIface {
	GTypeInterface parent_iface;
	void (*get_statistics) (RygelTrackerStatsIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	char** (*get_statistics_finish) (RygelTrackerStatsIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
};

struct _RygelTrackerStatsIfaceDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _RygelTrackerStatsIfaceDBusProxyGetStatisticsData {
	GAsyncReadyCallback _callback_;
	gpointer _user_data_;
	DBusPendingCall* pending;
};

struct _RygelTrackerResourcesIfaceIface {
	GTypeInterface parent_iface;
	void (*sparql_query) (RygelTrackerResourcesIface* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	char** (*sparql_query_finish) (RygelTrackerResourcesIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
	void (*sparql_update_blank) (RygelTrackerResourcesIface* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable** (*sparql_update_blank_finish) (RygelTrackerResourcesIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
};

struct _RygelTrackerResourcesIfaceDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _RygelTrackerResourcesIfaceDBusProxySparqlQueryData {
	GAsyncReadyCallback _callback_;
	gpointer _user_data_;
	DBusPendingCall* pending;
};

struct _RygelTrackerResourcesIfaceDBusProxySparqlUpdateBlankData {
	GAsyncReadyCallback _callback_;
	gpointer _user_data_;
	DBusPendingCall* pending;
};

struct _RygelTrackerResourcesClassIfaceIface {
	GTypeInterface parent_iface;
};

struct _RygelTrackerResourcesClassIfaceDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _RygelTrackerMinerIfaceIface {
	GTypeInterface parent_iface;
	void (*ignore_next_update) (RygelTrackerMinerIface* self, char** urls, int urls_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*ignore_next_update_finish) (RygelTrackerMinerIface* self, GAsyncResult* _res_, GError** error);
};

struct _RygelTrackerMinerIfaceDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _RygelTrackerMinerIfaceDBusProxyIgnoreNextUpdateData {
	GAsyncReadyCallback _callback_;
	gpointer _user_data_;
	DBusPendingCall* pending;
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};



GType rygel_tracker_stats_iface_get_type (void);
void rygel_tracker_stats_iface_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _rygel_tracker_stats_iface_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult rygel_tracker_stats_iface_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_rygel_tracker_stats_iface_introspect (RygelTrackerStatsIface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_rygel_tracker_stats_iface_property_get_all (RygelTrackerStatsIface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_rygel_tracker_stats_iface_get_statistics (RygelTrackerStatsIface* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_rygel_tracker_stats_iface_get_statistics_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_);
GType rygel_tracker_stats_iface_dbus_proxy_get_type (void);
RygelTrackerStatsIface* rygel_tracker_stats_iface_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
DBusHandlerResult rygel_tracker_stats_iface_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	RYGEL_TRACKER_STATS_IFACE_DBUS_PROXY_DUMMY_PROPERTY
};
static void rygel_tracker_stats_iface_dbus_proxy_get_statistics_async (RygelTrackerStatsIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_tracker_stats_iface_dbus_proxy_get_statistics_ready (DBusPendingCall* pending, void* user_data);
static char** rygel_tracker_stats_iface_dbus_proxy_get_statistics_finish (RygelTrackerStatsIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
static void rygel_tracker_stats_iface_dbus_proxy_rygel_tracker_stats_iface__interface_init (RygelTrackerStatsIfaceIface* iface);
static void rygel_tracker_stats_iface_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void rygel_tracker_stats_iface_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType rygel_tracker_resources_iface_get_type (void);
void rygel_tracker_resources_iface_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _rygel_tracker_resources_iface_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult rygel_tracker_resources_iface_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_rygel_tracker_resources_iface_introspect (RygelTrackerResourcesIface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_rygel_tracker_resources_iface_property_get_all (RygelTrackerResourcesIface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_rygel_tracker_resources_iface_sparql_query (RygelTrackerResourcesIface* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_rygel_tracker_resources_iface_sparql_query_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_);
static DBusHandlerResult _dbus_rygel_tracker_resources_iface_sparql_update_blank (RygelTrackerResourcesIface* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_rygel_tracker_resources_iface_sparql_update_blank_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_);
GType rygel_tracker_resources_iface_dbus_proxy_get_type (void);
RygelTrackerResourcesIface* rygel_tracker_resources_iface_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
DBusHandlerResult rygel_tracker_resources_iface_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	RYGEL_TRACKER_RESOURCES_IFACE_DBUS_PROXY_DUMMY_PROPERTY
};
static void rygel_tracker_resources_iface_dbus_proxy_sparql_query_async (RygelTrackerResourcesIface* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_tracker_resources_iface_dbus_proxy_sparql_query_ready (DBusPendingCall* pending, void* user_data);
static char** rygel_tracker_resources_iface_dbus_proxy_sparql_query_finish (RygelTrackerResourcesIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
static void rygel_tracker_resources_iface_dbus_proxy_sparql_update_blank_async (RygelTrackerResourcesIface* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_tracker_resources_iface_dbus_proxy_sparql_update_blank_ready (DBusPendingCall* pending, void* user_data);
static GHashTable** rygel_tracker_resources_iface_dbus_proxy_sparql_update_blank_finish (RygelTrackerResourcesIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
static void rygel_tracker_resources_iface_dbus_proxy_rygel_tracker_resources_iface__interface_init (RygelTrackerResourcesIfaceIface* iface);
static void rygel_tracker_resources_iface_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void rygel_tracker_resources_iface_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType rygel_tracker_resources_class_iface_get_type (void);
void rygel_tracker_resources_class_iface_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _rygel_tracker_resources_class_iface_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult rygel_tracker_resources_class_iface_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_rygel_tracker_resources_class_iface_introspect (RygelTrackerResourcesClassIface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_rygel_tracker_resources_class_iface_property_get_all (RygelTrackerResourcesClassIface* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_rygel_tracker_resources_class_iface_subjects_added (GObject* _sender, char** subjects, int subjects_length1, DBusConnection* _connection);
static void _dbus_rygel_tracker_resources_class_iface_subjects_removed (GObject* _sender, char** subjects, int subjects_length1, DBusConnection* _connection);
static void _dbus_rygel_tracker_resources_class_iface_subjects_changed (GObject* _sender, char** before, int before_length1, char** after, int after_length1, DBusConnection* _connection);
GType rygel_tracker_resources_class_iface_dbus_proxy_get_type (void);
RygelTrackerResourcesClassIface* rygel_tracker_resources_class_iface_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
static void _dbus_handle_rygel_tracker_resources_class_iface_subjects_added (RygelTrackerResourcesClassIface* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_handle_rygel_tracker_resources_class_iface_subjects_removed (RygelTrackerResourcesClassIface* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_handle_rygel_tracker_resources_class_iface_subjects_changed (RygelTrackerResourcesClassIface* self, DBusConnection* connection, DBusMessage* message);
DBusHandlerResult rygel_tracker_resources_class_iface_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	RYGEL_TRACKER_RESOURCES_CLASS_IFACE_DBUS_PROXY_DUMMY_PROPERTY
};
static void rygel_tracker_resources_class_iface_dbus_proxy_rygel_tracker_resources_class_iface__interface_init (RygelTrackerResourcesClassIfaceIface* iface);
static void rygel_tracker_resources_class_iface_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void rygel_tracker_resources_class_iface_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType rygel_tracker_miner_iface_get_type (void);
void rygel_tracker_miner_iface_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _rygel_tracker_miner_iface_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult rygel_tracker_miner_iface_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_rygel_tracker_miner_iface_introspect (RygelTrackerMinerIface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_rygel_tracker_miner_iface_property_get_all (RygelTrackerMinerIface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_rygel_tracker_miner_iface_ignore_next_update (RygelTrackerMinerIface* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_rygel_tracker_miner_iface_ignore_next_update_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_);
GType rygel_tracker_miner_iface_dbus_proxy_get_type (void);
RygelTrackerMinerIface* rygel_tracker_miner_iface_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
DBusHandlerResult rygel_tracker_miner_iface_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	RYGEL_TRACKER_MINER_IFACE_DBUS_PROXY_DUMMY_PROPERTY
};
static void rygel_tracker_miner_iface_dbus_proxy_ignore_next_update_async (RygelTrackerMinerIface* self, char** urls, int urls_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_tracker_miner_iface_dbus_proxy_ignore_next_update_ready (DBusPendingCall* pending, void* user_data);
static void rygel_tracker_miner_iface_dbus_proxy_ignore_next_update_finish (RygelTrackerMinerIface* self, GAsyncResult* _res_, GError** error);
static void rygel_tracker_miner_iface_dbus_proxy_rygel_tracker_miner_iface__interface_init (RygelTrackerMinerIfaceIface* iface);
static void rygel_tracker_miner_iface_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void rygel_tracker_miner_iface_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define RYGEL_RESOURCES_CLASS_PATH "/org/freedesktop/Tracker1/" "Resources/Classes/"
#define RYGEL_MUSIC_RESOURCES_CLASS_PATH RYGEL_RESOURCES_CLASS_PATH "nmm/MusicPiece"
#define RYGEL_VIDEO_RESOURCES_CLASS_PATH RYGEL_RESOURCES_CLASS_PATH "nmm/Video"
#define RYGEL_PHOTO_RESOURCES_CLASS_PATH RYGEL_RESOURCES_CLASS_PATH "nfo/Image"
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);

static const DBusObjectPathVTable _rygel_tracker_stats_iface_dbus_path_vtable = {_rygel_tracker_stats_iface_dbus_unregister, rygel_tracker_stats_iface_dbus_message};
static const _DBusObjectVTable _rygel_tracker_stats_iface_dbus_vtable = {rygel_tracker_stats_iface_dbus_register_object};
static const DBusObjectPathVTable _rygel_tracker_resources_iface_dbus_path_vtable = {_rygel_tracker_resources_iface_dbus_unregister, rygel_tracker_resources_iface_dbus_message};
static const _DBusObjectVTable _rygel_tracker_resources_iface_dbus_vtable = {rygel_tracker_resources_iface_dbus_register_object};
static const DBusObjectPathVTable _rygel_tracker_resources_class_iface_dbus_path_vtable = {_rygel_tracker_resources_class_iface_dbus_unregister, rygel_tracker_resources_class_iface_dbus_message};
static const _DBusObjectVTable _rygel_tracker_resources_class_iface_dbus_vtable = {rygel_tracker_resources_class_iface_dbus_register_object};
static const DBusObjectPathVTable _rygel_tracker_miner_iface_dbus_path_vtable = {_rygel_tracker_miner_iface_dbus_unregister, rygel_tracker_miner_iface_dbus_message};
static const _DBusObjectVTable _rygel_tracker_miner_iface_dbus_vtable = {rygel_tracker_miner_iface_dbus_register_object};

static void g_cclosure_user_marshal_VOID__BOXED_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__BOXED_INT_BOXED_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

#line 50 "rygel-tracker-plugin-factory.vala"
void rygel_tracker_stats_iface_get_statistics (RygelTrackerStatsIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 50 "rygel-tracker-plugin-factory.vala"
	RYGEL_TRACKER_STATS_IFACE_GET_INTERFACE (self)->get_statistics (self, _callback_, _user_data_);
#line 269 "rygel-tracker-interfaces.c"
}


#line 50 "rygel-tracker-plugin-factory.vala"
char** rygel_tracker_stats_iface_get_statistics_finish (RygelTrackerStatsIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error) {
#line 50 "rygel-tracker-plugin-factory.vala"
	return RYGEL_TRACKER_STATS_IFACE_GET_INTERFACE (self)->get_statistics_finish (self, _res_, result_length1, result_length2, error);
#line 277 "rygel-tracker-interfaces.c"
}


void _rygel_tracker_stats_iface_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_rygel_tracker_stats_iface_introspect (RygelTrackerStatsIface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.Tracker1.Statistics\">\n  <method name=\"GetStatistics\">\n    <arg name=\"result\" type=\"aas\" direction=\"out\"/>\n  </method>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_rygel_tracker_stats_iface_property_get_all (RygelTrackerStatsIface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	if (strcmp (interface_name, "org.freedesktop.Tracker1.Statistics") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_rygel_tracker_stats_iface_get_statistics (RygelTrackerStatsIface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	gpointer * _user_data_;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	_user_data_ = g_new0 (gpointer, 2);
	_user_data_[0] = dbus_connection_ref (connection);
	_user_data_[1] = dbus_message_ref (message);
	rygel_tracker_stats_iface_get_statistics (self, _dbus_rygel_tracker_stats_iface_get_statistics_ready, _user_data_);
	return DBUS_HANDLER_RESULT_HANDLED;
}


static void _dbus_rygel_tracker_stats_iface_get_statistics_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_) {
	DBusConnection * connection;
	DBusMessage * message;
	DBusMessageIter iter;
	GError* error;
	char** result;
	int result_length1;
	int result_length2;
	DBusMessage* reply;
	char** _tmp1_;
	DBusMessageIter _tmp2_;
	int _tmp3_;
	connection = _user_data_[0];
	message = _user_data_[1];
	error = NULL;
	result_length1 = 0;
	result_length2 = 0;
	result = rygel_tracker_stats_iface_get_statistics_finish (source_object, _res_, &result_length1, &result_length2, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp1_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "as", &_tmp2_);
	for (_tmp3_ = 0; _tmp3_ < result_length1; _tmp3_++) {
		DBusMessageIter _tmp4_;
		int _tmp5_;
		dbus_message_iter_open_container (&_tmp2_, DBUS_TYPE_ARRAY, "s", &_tmp4_);
		for (_tmp5_ = 0; _tmp5_ < result_length2; _tmp5_++) {
			const char* _tmp6_;
			_tmp6_ = *_tmp1_;
			dbus_message_iter_append_basic (&_tmp4_, DBUS_TYPE_STRING, &_tmp6_);
			_tmp1_++;
		}
		dbus_message_iter_close_container (&_tmp2_, &_tmp4_);
	}
	dbus_message_iter_close_container (&iter, &_tmp2_);
	result = (_vala_array_free (result,  result_length1 *  result_length2, (GDestroyNotify) g_free), NULL);
	dbus_connection_send (connection, reply, NULL);
	dbus_message_unref (reply);
	dbus_connection_unref (connection);
	dbus_message_unref (message);
	g_free (_user_data_);
}


DBusHandlerResult rygel_tracker_stats_iface_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_rygel_tracker_stats_iface_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_rygel_tracker_stats_iface_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.Tracker1.Statistics", "GetStatistics")) {
		result = _dbus_rygel_tracker_stats_iface_get_statistics (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void rygel_tracker_stats_iface_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_rygel_tracker_stats_iface_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
}


static void rygel_tracker_stats_iface_base_init (RygelTrackerStatsIfaceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_type_set_qdata (RYGEL_TYPE_TRACKER_STATS_IFACE, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_rygel_tracker_stats_iface_dbus_vtable));
	}
}


GType rygel_tracker_stats_iface_get_type (void) {
	static GType rygel_tracker_stats_iface_type_id = 0;
	if (rygel_tracker_stats_iface_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerStatsIfaceIface), (GBaseInitFunc) rygel_tracker_stats_iface_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		rygel_tracker_stats_iface_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelTrackerStatsIface", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (rygel_tracker_stats_iface_type_id, DBUS_TYPE_G_PROXY);
		g_type_set_qdata (rygel_tracker_stats_iface_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &rygel_tracker_stats_iface_dbus_proxy_get_type);
	}
	return rygel_tracker_stats_iface_type_id;
}


G_DEFINE_TYPE_EXTENDED (RygelTrackerStatsIfaceDBusProxy, rygel_tracker_stats_iface_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (RYGEL_TYPE_TRACKER_STATS_IFACE, rygel_tracker_stats_iface_dbus_proxy_rygel_tracker_stats_iface__interface_init) );
RygelTrackerStatsIface* rygel_tracker_stats_iface_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	RygelTrackerStatsIface* self;
	self = g_object_new (rygel_tracker_stats_iface_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.freedesktop.Tracker1.Statistics", NULL);
	return self;
}


static GObject* rygel_tracker_stats_iface_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (rygel_tracker_stats_iface_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), rygel_tracker_stats_iface_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


DBusHandlerResult rygel_tracker_stats_iface_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void rygel_tracker_stats_iface_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((RygelTrackerStatsIfaceDBusProxy*) self)->disposed) {
		return;
	}
	((RygelTrackerStatsIfaceDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), rygel_tracker_stats_iface_dbus_proxy_filter, self);
	G_OBJECT_CLASS (rygel_tracker_stats_iface_dbus_proxy_parent_class)->dispose (self);
}


static void rygel_tracker_stats_iface_dbus_proxy_class_init (RygelTrackerStatsIfaceDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = rygel_tracker_stats_iface_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = rygel_tracker_stats_iface_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = rygel_tracker_stats_iface_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_tracker_stats_iface_dbus_proxy_set_property;
}


static void rygel_tracker_stats_iface_dbus_proxy_init (RygelTrackerStatsIfaceDBusProxy* self) {
}


static void rygel_tracker_stats_iface_dbus_proxy_get_statistics_async (RygelTrackerStatsIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DBusGConnection *_connection;
	DBusMessage *_message;
	DBusPendingCall *_pending;
	DBusMessageIter _iter;
	RygelTrackerStatsIfaceDBusProxyGetStatisticsData* _data_;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.Tracker1.Statistics", "GetStatistics");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_connection_send_with_reply (dbus_g_connection_get_connection (_connection), _message, &_pending, -1);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	_data_ = g_slice_new0 (RygelTrackerStatsIfaceDBusProxyGetStatisticsData);
	_data_->_callback_ = _callback_;
	_data_->_user_data_ = _user_data_;
	_data_->pending = _pending;
	dbus_pending_call_set_notify (_pending, rygel_tracker_stats_iface_dbus_proxy_get_statistics_ready, _data_, NULL);
}


static void rygel_tracker_stats_iface_dbus_proxy_get_statistics_ready (DBusPendingCall* pending, void* user_data) {
	RygelTrackerStatsIfaceDBusProxyGetStatisticsData* _data_;
	_data_ = user_data;
	g_simple_async_result_complete (g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _data_->_callback_, _data_->_user_data_, _data_));
}


static char** rygel_tracker_stats_iface_dbus_proxy_get_statistics_finish (RygelTrackerStatsIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error) {
	RygelTrackerStatsIfaceDBusProxyGetStatisticsData* _data_;
	DBusError _dbus_error;
	DBusMessage *_reply;
	DBusMessageIter _iter;
	char** _result;
	int _result_length1;
	int _result_length2;
	char** _tmp12_;
	int _tmp12__length;
	int _tmp12__size;
	int _tmp12__length1;
	DBusMessageIter _tmp13_;
	_data_ = g_simple_async_result_get_source_tag ((GSimpleAsyncResult *) _res_);
	dbus_error_init (&_dbus_error);
	_reply = dbus_pending_call_steal_reply (_data_->pending);
	dbus_set_error_from_message (&_dbus_error, _reply);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp11_;
			_edomain = DBUS_GERROR;
			_tmp11_ = _dbus_error.name + 27;
			if (strcmp (_tmp11_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp11_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp11_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp11_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp11_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp11_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp11_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp11_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp11_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp11_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp11_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp11_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp11_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp11_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp11_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp11_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp11_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp11_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp11_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp11_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp11_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp11_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp11_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp11_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp11_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp11_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp11_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp11_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp11_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp11_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp11_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp11_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp11_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error_literal (error, _edomain, _ecode, _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "aas")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "aas", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_result_length2 = 0;
	_tmp12_ = g_new (char*, 5);
	_tmp12__length = 0;
	_tmp12__size = 4;
	_tmp12__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp13_);
	for (; dbus_message_iter_get_arg_type (&_tmp13_); _tmp12__length1++) {
		int _tmp12__length2;
		DBusMessageIter _tmp14_;
		_tmp12__length2 = 0;
		dbus_message_iter_recurse (&_tmp13_, &_tmp14_);
		for (; dbus_message_iter_get_arg_type (&_tmp14_); _tmp12__length2++) {
			const char* _tmp15_;
			if (_tmp12__size == _tmp12__length) {
				_tmp12__size = 2 * _tmp12__size;
				_tmp12_ = g_renew (char*, _tmp12_, _tmp12__size + 1);
			}
			dbus_message_iter_get_basic (&_tmp14_, &_tmp15_);
			dbus_message_iter_next (&_tmp14_);
			_tmp12_[_tmp12__length++] = g_strdup (_tmp15_);
		}
		_result_length2 = _tmp12__length2;
		dbus_message_iter_next (&_tmp13_);
	}
	_result_length1 = _tmp12__length1;
	_tmp12_[_tmp12__length] = NULL;
	dbus_message_iter_next (&_iter);
	_result = _tmp12_;
	*result_length1 = _result_length1;
	*result_length2 = _result_length2;
	dbus_message_unref (_reply);
	return _result;
}


static void rygel_tracker_stats_iface_dbus_proxy_rygel_tracker_stats_iface__interface_init (RygelTrackerStatsIfaceIface* iface) {
	iface->get_statistics = rygel_tracker_stats_iface_dbus_proxy_get_statistics_async;
	iface->get_statistics_finish = rygel_tracker_stats_iface_dbus_proxy_get_statistics_finish;
}


static void rygel_tracker_stats_iface_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void rygel_tracker_stats_iface_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


#line 50 "rygel-tracker-plugin-factory.vala"
void rygel_tracker_resources_iface_sparql_query (RygelTrackerResourcesIface* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 50 "rygel-tracker-plugin-factory.vala"
	RYGEL_TRACKER_RESOURCES_IFACE_GET_INTERFACE (self)->sparql_query (self, query, _callback_, _user_data_);
#line 800 "rygel-tracker-interfaces.c"
}


#line 50 "rygel-tracker-plugin-factory.vala"
char** rygel_tracker_resources_iface_sparql_query_finish (RygelTrackerResourcesIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error) {
#line 50 "rygel-tracker-plugin-factory.vala"
	return RYGEL_TRACKER_RESOURCES_IFACE_GET_INTERFACE (self)->sparql_query_finish (self, _res_, result_length1, result_length2, error);
#line 808 "rygel-tracker-interfaces.c"
}


#line 50 "rygel-tracker-plugin-factory.vala"
void rygel_tracker_resources_iface_sparql_update_blank (RygelTrackerResourcesIface* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 50 "rygel-tracker-plugin-factory.vala"
	RYGEL_TRACKER_RESOURCES_IFACE_GET_INTERFACE (self)->sparql_update_blank (self, query, _callback_, _user_data_);
#line 816 "rygel-tracker-interfaces.c"
}


#line 50 "rygel-tracker-plugin-factory.vala"
GHashTable** rygel_tracker_resources_iface_sparql_update_blank_finish (RygelTrackerResourcesIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error) {
#line 50 "rygel-tracker-plugin-factory.vala"
	return RYGEL_TRACKER_RESOURCES_IFACE_GET_INTERFACE (self)->sparql_update_blank_finish (self, _res_, result_length1, result_length2, error);
#line 824 "rygel-tracker-interfaces.c"
}


void _rygel_tracker_resources_iface_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_rygel_tracker_resources_iface_introspect (RygelTrackerResourcesIface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.Tracker1.Resources\">\n  <method name=\"SparqlQuery\">\n    <arg name=\"query\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"aas\" direction=\"out\"/>\n  </method>\n  <method name=\"SparqlUpdateBlank\">\n    <arg name=\"query\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"aaa{ss}\" direction=\"out\"/>\n  </method>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_rygel_tracker_resources_iface_property_get_all (RygelTrackerResourcesIface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp16_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp16_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp16_);
	if (strcmp (interface_name, "org.freedesktop.Tracker1.Resources") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_rygel_tracker_resources_iface_sparql_query (RygelTrackerResourcesIface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	char* query = NULL;
	const char* _tmp17_;
	gpointer * _user_data_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp17_);
	dbus_message_iter_next (&iter);
	query = g_strdup (_tmp17_);
	_user_data_ = g_new0 (gpointer, 2);
	_user_data_[0] = dbus_connection_ref (connection);
	_user_data_[1] = dbus_message_ref (message);
	rygel_tracker_resources_iface_sparql_query (self, query, _dbus_rygel_tracker_resources_iface_sparql_query_ready, _user_data_);
	_g_free0 (query);
	return DBUS_HANDLER_RESULT_HANDLED;
}


static void _dbus_rygel_tracker_resources_iface_sparql_query_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_) {
	DBusConnection * connection;
	DBusMessage * message;
	DBusMessageIter iter;
	GError* error;
	char** result;
	int result_length1;
	int result_length2;
	DBusMessage* reply;
	char** _tmp18_;
	DBusMessageIter _tmp19_;
	int _tmp20_;
	connection = _user_data_[0];
	message = _user_data_[1];
	error = NULL;
	result_length1 = 0;
	result_length2 = 0;
	result = rygel_tracker_resources_iface_sparql_query_finish (source_object, _res_, &result_length1, &result_length2, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp18_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "as", &_tmp19_);
	for (_tmp20_ = 0; _tmp20_ < result_length1; _tmp20_++) {
		DBusMessageIter _tmp21_;
		int _tmp22_;
		dbus_message_iter_open_container (&_tmp19_, DBUS_TYPE_ARRAY, "s", &_tmp21_);
		for (_tmp22_ = 0; _tmp22_ < result_length2; _tmp22_++) {
			const char* _tmp23_;
			_tmp23_ = *_tmp18_;
			dbus_message_iter_append_basic (&_tmp21_, DBUS_TYPE_STRING, &_tmp23_);
			_tmp18_++;
		}
		dbus_message_iter_close_container (&_tmp19_, &_tmp21_);
	}
	dbus_message_iter_close_container (&iter, &_tmp19_);
	result = (_vala_array_free (result,  result_length1 *  result_length2, (GDestroyNotify) g_free), NULL);
	dbus_connection_send (connection, reply, NULL);
	dbus_message_unref (reply);
	dbus_connection_unref (connection);
	dbus_message_unref (message);
	g_free (_user_data_);
}


static DBusHandlerResult _dbus_rygel_tracker_resources_iface_sparql_update_blank (RygelTrackerResourcesIface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	char* query = NULL;
	const char* _tmp24_;
	gpointer * _user_data_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp24_);
	dbus_message_iter_next (&iter);
	query = g_strdup (_tmp24_);
	_user_data_ = g_new0 (gpointer, 2);
	_user_data_[0] = dbus_connection_ref (connection);
	_user_data_[1] = dbus_message_ref (message);
	rygel_tracker_resources_iface_sparql_update_blank (self, query, _dbus_rygel_tracker_resources_iface_sparql_update_blank_ready, _user_data_);
	_g_free0 (query);
	return DBUS_HANDLER_RESULT_HANDLED;
}


static void _dbus_rygel_tracker_resources_iface_sparql_update_blank_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_) {
	DBusConnection * connection;
	DBusMessage * message;
	DBusMessageIter iter;
	GError* error;
	GHashTable** result;
	int result_length1;
	int result_length2;
	DBusMessage* reply;
	GHashTable** _tmp25_;
	DBusMessageIter _tmp26_;
	int _tmp27_;
	connection = _user_data_[0];
	message = _user_data_[1];
	error = NULL;
	result_length1 = 0;
	result_length2 = 0;
	result = rygel_tracker_resources_iface_sparql_update_blank_finish (source_object, _res_, &result_length1, &result_length2, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp25_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "aa{ss}", &_tmp26_);
	for (_tmp27_ = 0; _tmp27_ < result_length1; _tmp27_++) {
		DBusMessageIter _tmp28_;
		int _tmp29_;
		dbus_message_iter_open_container (&_tmp26_, DBUS_TYPE_ARRAY, "a{ss}", &_tmp28_);
		for (_tmp29_ = 0; _tmp29_ < result_length2; _tmp29_++) {
			DBusMessageIter _tmp30_, _tmp31_;
			GHashTableIter _tmp32_;
			gpointer _tmp33_, _tmp34_;
			dbus_message_iter_open_container (&_tmp28_, DBUS_TYPE_ARRAY, "{ss}", &_tmp30_);
			g_hash_table_iter_init (&_tmp32_, *_tmp25_);
			while (g_hash_table_iter_next (&_tmp32_, &_tmp33_, &_tmp34_)) {
				char* _key;
				char* _value;
				const char* _tmp35_;
				const char* _tmp36_;
				dbus_message_iter_open_container (&_tmp30_, DBUS_TYPE_DICT_ENTRY, NULL, &_tmp31_);
				_key = (char*) _tmp33_;
				_value = (char*) _tmp34_;
				_tmp35_ = _key;
				dbus_message_iter_append_basic (&_tmp31_, DBUS_TYPE_STRING, &_tmp35_);
				_tmp36_ = _value;
				dbus_message_iter_append_basic (&_tmp31_, DBUS_TYPE_STRING, &_tmp36_);
				dbus_message_iter_close_container (&_tmp30_, &_tmp31_);
			}
			dbus_message_iter_close_container (&_tmp28_, &_tmp30_);
			_tmp25_++;
		}
		dbus_message_iter_close_container (&_tmp26_, &_tmp28_);
	}
	dbus_message_iter_close_container (&iter, &_tmp26_);
	result = (_vala_array_free (result,  result_length1 *  result_length2, (GDestroyNotify) g_hash_table_unref), NULL);
	dbus_connection_send (connection, reply, NULL);
	dbus_message_unref (reply);
	dbus_connection_unref (connection);
	dbus_message_unref (message);
	g_free (_user_data_);
}


DBusHandlerResult rygel_tracker_resources_iface_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_rygel_tracker_resources_iface_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_rygel_tracker_resources_iface_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.Tracker1.Resources", "SparqlQuery")) {
		result = _dbus_rygel_tracker_resources_iface_sparql_query (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.Tracker1.Resources", "SparqlUpdateBlank")) {
		result = _dbus_rygel_tracker_resources_iface_sparql_update_blank (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void rygel_tracker_resources_iface_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_rygel_tracker_resources_iface_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
}


static void rygel_tracker_resources_iface_base_init (RygelTrackerResourcesIfaceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_type_set_qdata (RYGEL_TYPE_TRACKER_RESOURCES_IFACE, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_rygel_tracker_resources_iface_dbus_vtable));
	}
}


GType rygel_tracker_resources_iface_get_type (void) {
	static GType rygel_tracker_resources_iface_type_id = 0;
	if (rygel_tracker_resources_iface_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerResourcesIfaceIface), (GBaseInitFunc) rygel_tracker_resources_iface_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		rygel_tracker_resources_iface_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelTrackerResourcesIface", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (rygel_tracker_resources_iface_type_id, DBUS_TYPE_G_PROXY);
		g_type_set_qdata (rygel_tracker_resources_iface_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &rygel_tracker_resources_iface_dbus_proxy_get_type);
	}
	return rygel_tracker_resources_iface_type_id;
}


G_DEFINE_TYPE_EXTENDED (RygelTrackerResourcesIfaceDBusProxy, rygel_tracker_resources_iface_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (RYGEL_TYPE_TRACKER_RESOURCES_IFACE, rygel_tracker_resources_iface_dbus_proxy_rygel_tracker_resources_iface__interface_init) );
RygelTrackerResourcesIface* rygel_tracker_resources_iface_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	RygelTrackerResourcesIface* self;
	self = g_object_new (rygel_tracker_resources_iface_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.freedesktop.Tracker1.Resources", NULL);
	return self;
}


static GObject* rygel_tracker_resources_iface_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (rygel_tracker_resources_iface_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), rygel_tracker_resources_iface_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


DBusHandlerResult rygel_tracker_resources_iface_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void rygel_tracker_resources_iface_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((RygelTrackerResourcesIfaceDBusProxy*) self)->disposed) {
		return;
	}
	((RygelTrackerResourcesIfaceDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), rygel_tracker_resources_iface_dbus_proxy_filter, self);
	G_OBJECT_CLASS (rygel_tracker_resources_iface_dbus_proxy_parent_class)->dispose (self);
}


static void rygel_tracker_resources_iface_dbus_proxy_class_init (RygelTrackerResourcesIfaceDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = rygel_tracker_resources_iface_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = rygel_tracker_resources_iface_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = rygel_tracker_resources_iface_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_tracker_resources_iface_dbus_proxy_set_property;
}


static void rygel_tracker_resources_iface_dbus_proxy_init (RygelTrackerResourcesIfaceDBusProxy* self) {
}


static void rygel_tracker_resources_iface_dbus_proxy_sparql_query_async (RygelTrackerResourcesIface* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DBusGConnection *_connection;
	DBusMessage *_message;
	DBusPendingCall *_pending;
	DBusMessageIter _iter;
	const char* _tmp37_;
	RygelTrackerResourcesIfaceDBusProxySparqlQueryData* _data_;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.Tracker1.Resources", "SparqlQuery");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp37_ = query;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp37_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_connection_send_with_reply (dbus_g_connection_get_connection (_connection), _message, &_pending, -1);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	_data_ = g_slice_new0 (RygelTrackerResourcesIfaceDBusProxySparqlQueryData);
	_data_->_callback_ = _callback_;
	_data_->_user_data_ = _user_data_;
	_data_->pending = _pending;
	dbus_pending_call_set_notify (_pending, rygel_tracker_resources_iface_dbus_proxy_sparql_query_ready, _data_, NULL);
}


static void rygel_tracker_resources_iface_dbus_proxy_sparql_query_ready (DBusPendingCall* pending, void* user_data) {
	RygelTrackerResourcesIfaceDBusProxySparqlQueryData* _data_;
	_data_ = user_data;
	g_simple_async_result_complete (g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _data_->_callback_, _data_->_user_data_, _data_));
}


static char** rygel_tracker_resources_iface_dbus_proxy_sparql_query_finish (RygelTrackerResourcesIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error) {
	RygelTrackerResourcesIfaceDBusProxySparqlQueryData* _data_;
	DBusError _dbus_error;
	DBusMessage *_reply;
	DBusMessageIter _iter;
	char** _result;
	int _result_length1;
	int _result_length2;
	char** _tmp44_;
	int _tmp44__length;
	int _tmp44__size;
	int _tmp44__length1;
	DBusMessageIter _tmp45_;
	_data_ = g_simple_async_result_get_source_tag ((GSimpleAsyncResult *) _res_);
	dbus_error_init (&_dbus_error);
	_reply = dbus_pending_call_steal_reply (_data_->pending);
	dbus_set_error_from_message (&_dbus_error, _reply);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp42_;
			_edomain = DBUS_GERROR;
			_tmp42_ = _dbus_error.name + 27;
			if (strcmp (_tmp42_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp42_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp42_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp42_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp42_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp42_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp42_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp42_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp42_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp42_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp42_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp42_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp42_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp42_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp42_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp42_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp42_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp42_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp42_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp42_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp42_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp42_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp42_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp42_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp42_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp42_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp42_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp42_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp42_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp42_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp42_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp42_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp42_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error_literal (error, _edomain, _ecode, _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "aas")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "aas", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_result_length2 = 0;
	_tmp44_ = g_new (char*, 5);
	_tmp44__length = 0;
	_tmp44__size = 4;
	_tmp44__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp45_);
	for (; dbus_message_iter_get_arg_type (&_tmp45_); _tmp44__length1++) {
		int _tmp44__length2;
		DBusMessageIter _tmp46_;
		_tmp44__length2 = 0;
		dbus_message_iter_recurse (&_tmp45_, &_tmp46_);
		for (; dbus_message_iter_get_arg_type (&_tmp46_); _tmp44__length2++) {
			const char* _tmp47_;
			if (_tmp44__size == _tmp44__length) {
				_tmp44__size = 2 * _tmp44__size;
				_tmp44_ = g_renew (char*, _tmp44_, _tmp44__size + 1);
			}
			dbus_message_iter_get_basic (&_tmp46_, &_tmp47_);
			dbus_message_iter_next (&_tmp46_);
			_tmp44_[_tmp44__length++] = g_strdup (_tmp47_);
		}
		_result_length2 = _tmp44__length2;
		dbus_message_iter_next (&_tmp45_);
	}
	_result_length1 = _tmp44__length1;
	_tmp44_[_tmp44__length] = NULL;
	dbus_message_iter_next (&_iter);
	_result = _tmp44_;
	*result_length1 = _result_length1;
	*result_length2 = _result_length2;
	dbus_message_unref (_reply);
	return _result;
}


static void rygel_tracker_resources_iface_dbus_proxy_sparql_update_blank_async (RygelTrackerResourcesIface* self, const char* query, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DBusGConnection *_connection;
	DBusMessage *_message;
	DBusPendingCall *_pending;
	DBusMessageIter _iter;
	const char* _tmp48_;
	RygelTrackerResourcesIfaceDBusProxySparqlUpdateBlankData* _data_;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.Tracker1.Resources", "SparqlUpdateBlank");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp48_ = query;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp48_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_connection_send_with_reply (dbus_g_connection_get_connection (_connection), _message, &_pending, -1);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	_data_ = g_slice_new0 (RygelTrackerResourcesIfaceDBusProxySparqlUpdateBlankData);
	_data_->_callback_ = _callback_;
	_data_->_user_data_ = _user_data_;
	_data_->pending = _pending;
	dbus_pending_call_set_notify (_pending, rygel_tracker_resources_iface_dbus_proxy_sparql_update_blank_ready, _data_, NULL);
}


static void rygel_tracker_resources_iface_dbus_proxy_sparql_update_blank_ready (DBusPendingCall* pending, void* user_data) {
	RygelTrackerResourcesIfaceDBusProxySparqlUpdateBlankData* _data_;
	_data_ = user_data;
	g_simple_async_result_complete (g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _data_->_callback_, _data_->_user_data_, _data_));
}


static GHashTable** rygel_tracker_resources_iface_dbus_proxy_sparql_update_blank_finish (RygelTrackerResourcesIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error) {
	RygelTrackerResourcesIfaceDBusProxySparqlUpdateBlankData* _data_;
	DBusError _dbus_error;
	DBusMessage *_reply;
	DBusMessageIter _iter;
	GHashTable** _result;
	int _result_length1;
	int _result_length2;
	GHashTable** _tmp59_;
	int _tmp59__length;
	int _tmp59__size;
	int _tmp59__length1;
	DBusMessageIter _tmp60_;
	_data_ = g_simple_async_result_get_source_tag ((GSimpleAsyncResult *) _res_);
	dbus_error_init (&_dbus_error);
	_reply = dbus_pending_call_steal_reply (_data_->pending);
	dbus_set_error_from_message (&_dbus_error, _reply);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp57_;
			_edomain = DBUS_GERROR;
			_tmp57_ = _dbus_error.name + 27;
			if (strcmp (_tmp57_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp57_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp57_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp57_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp57_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp57_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp57_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp57_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp57_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp57_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp57_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp57_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp57_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp57_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp57_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp57_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp57_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp57_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp57_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp57_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp57_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp57_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp57_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp57_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp57_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp57_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp57_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp57_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp57_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp57_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp57_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp57_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp57_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error_literal (error, _edomain, _ecode, _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "aaa{ss}")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "aaa{ss}", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_result_length2 = 0;
	_tmp59_ = g_new (GHashTable*, 5);
	_tmp59__length = 0;
	_tmp59__size = 4;
	_tmp59__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp60_);
	for (; dbus_message_iter_get_arg_type (&_tmp60_); _tmp59__length1++) {
		int _tmp59__length2;
		DBusMessageIter _tmp61_;
		_tmp59__length2 = 0;
		dbus_message_iter_recurse (&_tmp60_, &_tmp61_);
		for (; dbus_message_iter_get_arg_type (&_tmp61_); _tmp59__length2++) {
			GHashTable* _tmp62_;
			DBusMessageIter _tmp63_;
			DBusMessageIter _tmp64_;
			if (_tmp59__size == _tmp59__length) {
				_tmp59__size = 2 * _tmp59__size;
				_tmp59_ = g_renew (GHashTable*, _tmp59_, _tmp59__size + 1);
			}
			_tmp62_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
			dbus_message_iter_recurse (&_tmp61_, &_tmp63_);
			while (dbus_message_iter_get_arg_type (&_tmp63_)) {
				char* _key;
				char* _value;
				const char* _tmp65_;
				const char* _tmp66_;
				dbus_message_iter_recurse (&_tmp63_, &_tmp64_);
				dbus_message_iter_get_basic (&_tmp64_, &_tmp65_);
				dbus_message_iter_next (&_tmp64_);
				_key = g_strdup (_tmp65_);
				dbus_message_iter_get_basic (&_tmp64_, &_tmp66_);
				dbus_message_iter_next (&_tmp64_);
				_value = g_strdup (_tmp66_);
				g_hash_table_insert (_tmp62_, _key, _value);
				dbus_message_iter_next (&_tmp63_);
			}
			dbus_message_iter_next (&_tmp61_);
			_tmp59_[_tmp59__length++] = _tmp62_;
		}
		_result_length2 = _tmp59__length2;
		dbus_message_iter_next (&_tmp60_);
	}
	_result_length1 = _tmp59__length1;
	_tmp59_[_tmp59__length] = NULL;
	dbus_message_iter_next (&_iter);
	_result = _tmp59_;
	*result_length1 = _result_length1;
	*result_length2 = _result_length2;
	dbus_message_unref (_reply);
	return _result;
}


static void rygel_tracker_resources_iface_dbus_proxy_rygel_tracker_resources_iface__interface_init (RygelTrackerResourcesIfaceIface* iface) {
	iface->sparql_query = rygel_tracker_resources_iface_dbus_proxy_sparql_query_async;
	iface->sparql_query_finish = rygel_tracker_resources_iface_dbus_proxy_sparql_query_finish;
	iface->sparql_update_blank = rygel_tracker_resources_iface_dbus_proxy_sparql_update_blank_async;
	iface->sparql_update_blank_finish = rygel_tracker_resources_iface_dbus_proxy_sparql_update_blank_finish;
}


static void rygel_tracker_resources_iface_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void rygel_tracker_resources_iface_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


void _rygel_tracker_resources_class_iface_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_rygel_tracker_resources_class_iface_introspect (RygelTrackerResourcesClassIface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.Tracker1.Resources.Class\">\n  <signal name=\"SubjectsAdded\">\n    <arg name=\"subjects\" type=\"as\"/>\n  </signal>\n  <signal name=\"SubjectsRemoved\">\n    <arg name=\"subjects\" type=\"as\"/>\n  </signal>\n  <signal name=\"SubjectsChanged\">\n    <arg name=\"before\" type=\"as\"/>\n    <arg name=\"after\" type=\"as\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_rygel_tracker_resources_class_iface_property_get_all (RygelTrackerResourcesClassIface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp67_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp67_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp67_);
	if (strcmp (interface_name, "org.freedesktop.Tracker1.Resources.Class") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult rygel_tracker_resources_class_iface_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_rygel_tracker_resources_class_iface_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_rygel_tracker_resources_class_iface_property_get_all (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _dbus_rygel_tracker_resources_class_iface_subjects_added (GObject* _sender, char** subjects, int subjects_length1, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	char** _tmp68_;
	DBusMessageIter _tmp69_;
	int _tmp70_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.freedesktop.Tracker1.Resources.Class", "SubjectsAdded");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp68_ = subjects;
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_ARRAY, "s", &_tmp69_);
	for (_tmp70_ = 0; _tmp70_ < subjects_length1; _tmp70_++) {
		const char* _tmp71_;
		_tmp71_ = *_tmp68_;
		dbus_message_iter_append_basic (&_tmp69_, DBUS_TYPE_STRING, &_tmp71_);
		_tmp68_++;
	}
	dbus_message_iter_close_container (&_iter, &_tmp69_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


static void _dbus_rygel_tracker_resources_class_iface_subjects_removed (GObject* _sender, char** subjects, int subjects_length1, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	char** _tmp72_;
	DBusMessageIter _tmp73_;
	int _tmp74_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.freedesktop.Tracker1.Resources.Class", "SubjectsRemoved");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp72_ = subjects;
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_ARRAY, "s", &_tmp73_);
	for (_tmp74_ = 0; _tmp74_ < subjects_length1; _tmp74_++) {
		const char* _tmp75_;
		_tmp75_ = *_tmp72_;
		dbus_message_iter_append_basic (&_tmp73_, DBUS_TYPE_STRING, &_tmp75_);
		_tmp72_++;
	}
	dbus_message_iter_close_container (&_iter, &_tmp73_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


static void _dbus_rygel_tracker_resources_class_iface_subjects_changed (GObject* _sender, char** before, int before_length1, char** after, int after_length1, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	char** _tmp76_;
	DBusMessageIter _tmp77_;
	int _tmp78_;
	char** _tmp80_;
	DBusMessageIter _tmp81_;
	int _tmp82_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.freedesktop.Tracker1.Resources.Class", "SubjectsChanged");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp76_ = before;
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_ARRAY, "s", &_tmp77_);
	for (_tmp78_ = 0; _tmp78_ < before_length1; _tmp78_++) {
		const char* _tmp79_;
		_tmp79_ = *_tmp76_;
		dbus_message_iter_append_basic (&_tmp77_, DBUS_TYPE_STRING, &_tmp79_);
		_tmp76_++;
	}
	dbus_message_iter_close_container (&_iter, &_tmp77_);
	_tmp80_ = after;
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_ARRAY, "s", &_tmp81_);
	for (_tmp82_ = 0; _tmp82_ < after_length1; _tmp82_++) {
		const char* _tmp83_;
		_tmp83_ = *_tmp80_;
		dbus_message_iter_append_basic (&_tmp81_, DBUS_TYPE_STRING, &_tmp83_);
		_tmp80_++;
	}
	dbus_message_iter_close_container (&_iter, &_tmp81_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


void rygel_tracker_resources_class_iface_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_rygel_tracker_resources_class_iface_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	g_signal_connect (object, "subjects-added", (GCallback) _dbus_rygel_tracker_resources_class_iface_subjects_added, connection);
	g_signal_connect (object, "subjects-removed", (GCallback) _dbus_rygel_tracker_resources_class_iface_subjects_removed, connection);
	g_signal_connect (object, "subjects-changed", (GCallback) _dbus_rygel_tracker_resources_class_iface_subjects_changed, connection);
}


static void rygel_tracker_resources_class_iface_base_init (RygelTrackerResourcesClassIfaceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("subjects_added", RYGEL_TYPE_TRACKER_RESOURCES_CLASS_IFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED_INT, G_TYPE_NONE, 2, G_TYPE_STRV, G_TYPE_INT);
		g_signal_new ("subjects_removed", RYGEL_TYPE_TRACKER_RESOURCES_CLASS_IFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED_INT, G_TYPE_NONE, 2, G_TYPE_STRV, G_TYPE_INT);
		g_signal_new ("subjects_changed", RYGEL_TYPE_TRACKER_RESOURCES_CLASS_IFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED_INT_BOXED_INT, G_TYPE_NONE, 4, G_TYPE_STRV, G_TYPE_INT, G_TYPE_STRV, G_TYPE_INT);
		g_type_set_qdata (RYGEL_TYPE_TRACKER_RESOURCES_CLASS_IFACE, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_rygel_tracker_resources_class_iface_dbus_vtable));
	}
}


GType rygel_tracker_resources_class_iface_get_type (void) {
	static GType rygel_tracker_resources_class_iface_type_id = 0;
	if (rygel_tracker_resources_class_iface_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerResourcesClassIfaceIface), (GBaseInitFunc) rygel_tracker_resources_class_iface_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		rygel_tracker_resources_class_iface_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelTrackerResourcesClassIface", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (rygel_tracker_resources_class_iface_type_id, DBUS_TYPE_G_PROXY);
		g_type_set_qdata (rygel_tracker_resources_class_iface_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &rygel_tracker_resources_class_iface_dbus_proxy_get_type);
	}
	return rygel_tracker_resources_class_iface_type_id;
}


G_DEFINE_TYPE_EXTENDED (RygelTrackerResourcesClassIfaceDBusProxy, rygel_tracker_resources_class_iface_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (RYGEL_TYPE_TRACKER_RESOURCES_CLASS_IFACE, rygel_tracker_resources_class_iface_dbus_proxy_rygel_tracker_resources_class_iface__interface_init) );
RygelTrackerResourcesClassIface* rygel_tracker_resources_class_iface_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	RygelTrackerResourcesClassIface* self;
	self = g_object_new (rygel_tracker_resources_class_iface_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.freedesktop.Tracker1.Resources.Class", NULL);
	return self;
}


static GObject* rygel_tracker_resources_class_iface_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (rygel_tracker_resources_class_iface_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), rygel_tracker_resources_class_iface_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


static void _dbus_handle_rygel_tracker_resources_class_iface_subjects_added (RygelTrackerResourcesClassIface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	char** subjects = NULL;
	int subjects_length1;
	char** _tmp84_;
	int _tmp84__length;
	int _tmp84__size;
	int _tmp84__length1;
	DBusMessageIter _tmp85_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "as")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	subjects_length1 = 0;
	_tmp84_ = g_new (char*, 5);
	_tmp84__length = 0;
	_tmp84__size = 4;
	_tmp84__length1 = 0;
	dbus_message_iter_recurse (&iter, &_tmp85_);
	for (; dbus_message_iter_get_arg_type (&_tmp85_); _tmp84__length1++) {
		const char* _tmp86_;
		if (_tmp84__size == _tmp84__length) {
			_tmp84__size = 2 * _tmp84__size;
			_tmp84_ = g_renew (char*, _tmp84_, _tmp84__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp85_, &_tmp86_);
		dbus_message_iter_next (&_tmp85_);
		_tmp84_[_tmp84__length++] = g_strdup (_tmp86_);
	}
	subjects_length1 = _tmp84__length1;
	_tmp84_[_tmp84__length] = NULL;
	dbus_message_iter_next (&iter);
	subjects = _tmp84_;
	g_signal_emit_by_name (self, "subjects-added", subjects, subjects_length1);
}


static void _dbus_handle_rygel_tracker_resources_class_iface_subjects_removed (RygelTrackerResourcesClassIface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	char** subjects = NULL;
	int subjects_length1;
	char** _tmp87_;
	int _tmp87__length;
	int _tmp87__size;
	int _tmp87__length1;
	DBusMessageIter _tmp88_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "as")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	subjects_length1 = 0;
	_tmp87_ = g_new (char*, 5);
	_tmp87__length = 0;
	_tmp87__size = 4;
	_tmp87__length1 = 0;
	dbus_message_iter_recurse (&iter, &_tmp88_);
	for (; dbus_message_iter_get_arg_type (&_tmp88_); _tmp87__length1++) {
		const char* _tmp89_;
		if (_tmp87__size == _tmp87__length) {
			_tmp87__size = 2 * _tmp87__size;
			_tmp87_ = g_renew (char*, _tmp87_, _tmp87__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp88_, &_tmp89_);
		dbus_message_iter_next (&_tmp88_);
		_tmp87_[_tmp87__length++] = g_strdup (_tmp89_);
	}
	subjects_length1 = _tmp87__length1;
	_tmp87_[_tmp87__length] = NULL;
	dbus_message_iter_next (&iter);
	subjects = _tmp87_;
	g_signal_emit_by_name (self, "subjects-removed", subjects, subjects_length1);
}


static void _dbus_handle_rygel_tracker_resources_class_iface_subjects_changed (RygelTrackerResourcesClassIface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	char** before = NULL;
	int before_length1;
	char** _tmp90_;
	int _tmp90__length;
	int _tmp90__size;
	int _tmp90__length1;
	DBusMessageIter _tmp91_;
	char** after = NULL;
	int after_length1;
	char** _tmp93_;
	int _tmp93__length;
	int _tmp93__size;
	int _tmp93__length1;
	DBusMessageIter _tmp94_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "asas")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	before_length1 = 0;
	_tmp90_ = g_new (char*, 5);
	_tmp90__length = 0;
	_tmp90__size = 4;
	_tmp90__length1 = 0;
	dbus_message_iter_recurse (&iter, &_tmp91_);
	for (; dbus_message_iter_get_arg_type (&_tmp91_); _tmp90__length1++) {
		const char* _tmp92_;
		if (_tmp90__size == _tmp90__length) {
			_tmp90__size = 2 * _tmp90__size;
			_tmp90_ = g_renew (char*, _tmp90_, _tmp90__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp91_, &_tmp92_);
		dbus_message_iter_next (&_tmp91_);
		_tmp90_[_tmp90__length++] = g_strdup (_tmp92_);
	}
	before_length1 = _tmp90__length1;
	_tmp90_[_tmp90__length] = NULL;
	dbus_message_iter_next (&iter);
	before = _tmp90_;
	after_length1 = 0;
	_tmp93_ = g_new (char*, 5);
	_tmp93__length = 0;
	_tmp93__size = 4;
	_tmp93__length1 = 0;
	dbus_message_iter_recurse (&iter, &_tmp94_);
	for (; dbus_message_iter_get_arg_type (&_tmp94_); _tmp93__length1++) {
		const char* _tmp95_;
		if (_tmp93__size == _tmp93__length) {
			_tmp93__size = 2 * _tmp93__size;
			_tmp93_ = g_renew (char*, _tmp93_, _tmp93__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp94_, &_tmp95_);
		dbus_message_iter_next (&_tmp94_);
		_tmp93_[_tmp93__length++] = g_strdup (_tmp95_);
	}
	after_length1 = _tmp93__length1;
	_tmp93_[_tmp93__length] = NULL;
	dbus_message_iter_next (&iter);
	after = _tmp93_;
	g_signal_emit_by_name (self, "subjects-changed", before, before_length1, after, after_length1);
}


DBusHandlerResult rygel_tracker_resources_class_iface_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
		if (dbus_message_is_signal (message, "org.freedesktop.Tracker1.Resources.Class", "SubjectsAdded")) {
			_dbus_handle_rygel_tracker_resources_class_iface_subjects_added (user_data, connection, message);
		} else if (dbus_message_is_signal (message, "org.freedesktop.Tracker1.Resources.Class", "SubjectsRemoved")) {
			_dbus_handle_rygel_tracker_resources_class_iface_subjects_removed (user_data, connection, message);
		} else if (dbus_message_is_signal (message, "org.freedesktop.Tracker1.Resources.Class", "SubjectsChanged")) {
			_dbus_handle_rygel_tracker_resources_class_iface_subjects_changed (user_data, connection, message);
		}
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void rygel_tracker_resources_class_iface_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((RygelTrackerResourcesClassIfaceDBusProxy*) self)->disposed) {
		return;
	}
	((RygelTrackerResourcesClassIfaceDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), rygel_tracker_resources_class_iface_dbus_proxy_filter, self);
	G_OBJECT_CLASS (rygel_tracker_resources_class_iface_dbus_proxy_parent_class)->dispose (self);
}


static void rygel_tracker_resources_class_iface_dbus_proxy_class_init (RygelTrackerResourcesClassIfaceDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = rygel_tracker_resources_class_iface_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = rygel_tracker_resources_class_iface_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = rygel_tracker_resources_class_iface_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_tracker_resources_class_iface_dbus_proxy_set_property;
}


static void rygel_tracker_resources_class_iface_dbus_proxy_init (RygelTrackerResourcesClassIfaceDBusProxy* self) {
}


static void rygel_tracker_resources_class_iface_dbus_proxy_rygel_tracker_resources_class_iface__interface_init (RygelTrackerResourcesClassIfaceIface* iface) {
}


static void rygel_tracker_resources_class_iface_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void rygel_tracker_resources_class_iface_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


#line 50 "rygel-tracker-plugin-factory.vala"
void rygel_tracker_miner_iface_ignore_next_update (RygelTrackerMinerIface* self, char** urls, int urls_length1, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 50 "rygel-tracker-plugin-factory.vala"
	RYGEL_TRACKER_MINER_IFACE_GET_INTERFACE (self)->ignore_next_update (self, urls, urls_length1, _callback_, _user_data_);
#line 2153 "rygel-tracker-interfaces.c"
}


#line 50 "rygel-tracker-plugin-factory.vala"
void rygel_tracker_miner_iface_ignore_next_update_finish (RygelTrackerMinerIface* self, GAsyncResult* _res_, GError** error) {
#line 50 "rygel-tracker-plugin-factory.vala"
	RYGEL_TRACKER_MINER_IFACE_GET_INTERFACE (self)->ignore_next_update_finish (self, _res_, error);
#line 2161 "rygel-tracker-interfaces.c"
}


void _rygel_tracker_miner_iface_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_rygel_tracker_miner_iface_introspect (RygelTrackerMinerIface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.Tracker1.Miner\">\n  <method name=\"IgnoreNextUpdate\">\n    <arg name=\"urls\" type=\"as\" direction=\"in\"/>\n  </method>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_rygel_tracker_miner_iface_property_get_all (RygelTrackerMinerIface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp96_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp96_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp96_);
	if (strcmp (interface_name, "org.freedesktop.Tracker1.Miner") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_rygel_tracker_miner_iface_ignore_next_update (RygelTrackerMinerIface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	char** urls = NULL;
	int urls_length1;
	char** _tmp97_;
	int _tmp97__length;
	int _tmp97__size;
	int _tmp97__length1;
	DBusMessageIter _tmp98_;
	gpointer * _user_data_;
	if (strcmp (dbus_message_get_signature (message), "as")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	urls_length1 = 0;
	_tmp97_ = g_new (char*, 5);
	_tmp97__length = 0;
	_tmp97__size = 4;
	_tmp97__length1 = 0;
	dbus_message_iter_recurse (&iter, &_tmp98_);
	for (; dbus_message_iter_get_arg_type (&_tmp98_); _tmp97__length1++) {
		const char* _tmp99_;
		if (_tmp97__size == _tmp97__length) {
			_tmp97__size = 2 * _tmp97__size;
			_tmp97_ = g_renew (char*, _tmp97_, _tmp97__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp98_, &_tmp99_);
		dbus_message_iter_next (&_tmp98_);
		_tmp97_[_tmp97__length++] = g_strdup (_tmp99_);
	}
	urls_length1 = _tmp97__length1;
	_tmp97_[_tmp97__length] = NULL;
	dbus_message_iter_next (&iter);
	urls = _tmp97_;
	_user_data_ = g_new0 (gpointer, 2);
	_user_data_[0] = dbus_connection_ref (connection);
	_user_data_[1] = dbus_message_ref (message);
	rygel_tracker_miner_iface_ignore_next_update (self, urls, urls_length1, _dbus_rygel_tracker_miner_iface_ignore_next_update_ready, _user_data_);
	urls = (_vala_array_free (urls, urls_length1, (GDestroyNotify) g_free), NULL);
	return DBUS_HANDLER_RESULT_HANDLED;
}


static void _dbus_rygel_tracker_miner_iface_ignore_next_update_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_) {
	DBusConnection * connection;
	DBusMessage * message;
	DBusMessageIter iter;
	GError* error;
	DBusMessage* reply;
	connection = _user_data_[0];
	message = _user_data_[1];
	error = NULL;
	rygel_tracker_miner_iface_ignore_next_update_finish (source_object, _res_, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	dbus_connection_send (connection, reply, NULL);
	dbus_message_unref (reply);
	dbus_connection_unref (connection);
	dbus_message_unref (message);
	g_free (_user_data_);
}


DBusHandlerResult rygel_tracker_miner_iface_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_rygel_tracker_miner_iface_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_rygel_tracker_miner_iface_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.Tracker1.Miner", "IgnoreNextUpdate")) {
		result = _dbus_rygel_tracker_miner_iface_ignore_next_update (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void rygel_tracker_miner_iface_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_rygel_tracker_miner_iface_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
}


static void rygel_tracker_miner_iface_base_init (RygelTrackerMinerIfaceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_type_set_qdata (RYGEL_TYPE_TRACKER_MINER_IFACE, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_rygel_tracker_miner_iface_dbus_vtable));
	}
}


GType rygel_tracker_miner_iface_get_type (void) {
	static GType rygel_tracker_miner_iface_type_id = 0;
	if (rygel_tracker_miner_iface_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerMinerIfaceIface), (GBaseInitFunc) rygel_tracker_miner_iface_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		rygel_tracker_miner_iface_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelTrackerMinerIface", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (rygel_tracker_miner_iface_type_id, DBUS_TYPE_G_PROXY);
		g_type_set_qdata (rygel_tracker_miner_iface_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &rygel_tracker_miner_iface_dbus_proxy_get_type);
	}
	return rygel_tracker_miner_iface_type_id;
}


G_DEFINE_TYPE_EXTENDED (RygelTrackerMinerIfaceDBusProxy, rygel_tracker_miner_iface_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (RYGEL_TYPE_TRACKER_MINER_IFACE, rygel_tracker_miner_iface_dbus_proxy_rygel_tracker_miner_iface__interface_init) );
RygelTrackerMinerIface* rygel_tracker_miner_iface_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	RygelTrackerMinerIface* self;
	self = g_object_new (rygel_tracker_miner_iface_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.freedesktop.Tracker1.Miner", NULL);
	return self;
}


static GObject* rygel_tracker_miner_iface_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (rygel_tracker_miner_iface_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), rygel_tracker_miner_iface_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


DBusHandlerResult rygel_tracker_miner_iface_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void rygel_tracker_miner_iface_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((RygelTrackerMinerIfaceDBusProxy*) self)->disposed) {
		return;
	}
	((RygelTrackerMinerIfaceDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), rygel_tracker_miner_iface_dbus_proxy_filter, self);
	G_OBJECT_CLASS (rygel_tracker_miner_iface_dbus_proxy_parent_class)->dispose (self);
}


static void rygel_tracker_miner_iface_dbus_proxy_class_init (RygelTrackerMinerIfaceDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = rygel_tracker_miner_iface_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = rygel_tracker_miner_iface_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = rygel_tracker_miner_iface_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_tracker_miner_iface_dbus_proxy_set_property;
}


static void rygel_tracker_miner_iface_dbus_proxy_init (RygelTrackerMinerIfaceDBusProxy* self) {
}


static void rygel_tracker_miner_iface_dbus_proxy_ignore_next_update_async (RygelTrackerMinerIface* self, char** urls, int urls_length1, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DBusGConnection *_connection;
	DBusMessage *_message;
	DBusPendingCall *_pending;
	DBusMessageIter _iter;
	char** _tmp100_;
	DBusMessageIter _tmp101_;
	int _tmp102_;
	RygelTrackerMinerIfaceDBusProxyIgnoreNextUpdateData* _data_;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.Tracker1.Miner", "IgnoreNextUpdate");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp100_ = urls;
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_ARRAY, "s", &_tmp101_);
	for (_tmp102_ = 0; _tmp102_ < urls_length1; _tmp102_++) {
		const char* _tmp103_;
		_tmp103_ = *_tmp100_;
		dbus_message_iter_append_basic (&_tmp101_, DBUS_TYPE_STRING, &_tmp103_);
		_tmp100_++;
	}
	dbus_message_iter_close_container (&_iter, &_tmp101_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_connection_send_with_reply (dbus_g_connection_get_connection (_connection), _message, &_pending, -1);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	_data_ = g_slice_new0 (RygelTrackerMinerIfaceDBusProxyIgnoreNextUpdateData);
	_data_->_callback_ = _callback_;
	_data_->_user_data_ = _user_data_;
	_data_->pending = _pending;
	dbus_pending_call_set_notify (_pending, rygel_tracker_miner_iface_dbus_proxy_ignore_next_update_ready, _data_, NULL);
}


static void rygel_tracker_miner_iface_dbus_proxy_ignore_next_update_ready (DBusPendingCall* pending, void* user_data) {
	RygelTrackerMinerIfaceDBusProxyIgnoreNextUpdateData* _data_;
	_data_ = user_data;
	g_simple_async_result_complete (g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _data_->_callback_, _data_->_user_data_, _data_));
}


static void rygel_tracker_miner_iface_dbus_proxy_ignore_next_update_finish (RygelTrackerMinerIface* self, GAsyncResult* _res_, GError** error) {
	RygelTrackerMinerIfaceDBusProxyIgnoreNextUpdateData* _data_;
	DBusError _dbus_error;
	DBusMessage *_reply;
	DBusMessageIter _iter;
	_data_ = g_simple_async_result_get_source_tag ((GSimpleAsyncResult *) _res_);
	dbus_error_init (&_dbus_error);
	_reply = dbus_pending_call_steal_reply (_data_->pending);
	dbus_set_error_from_message (&_dbus_error, _reply);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp104_;
			_edomain = DBUS_GERROR;
			_tmp104_ = _dbus_error.name + 27;
			if (strcmp (_tmp104_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp104_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp104_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp104_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp104_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp104_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp104_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp104_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp104_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp104_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp104_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp104_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp104_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp104_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp104_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp104_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp104_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp104_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp104_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp104_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp104_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp104_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp104_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp104_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp104_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp104_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp104_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp104_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp104_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp104_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp104_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp104_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp104_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error_literal (error, _edomain, _ecode, _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void rygel_tracker_miner_iface_dbus_proxy_rygel_tracker_miner_iface__interface_init (RygelTrackerMinerIfaceIface* iface) {
	iface->ignore_next_update = rygel_tracker_miner_iface_dbus_proxy_ignore_next_update_async;
	iface->ignore_next_update_finish = rygel_tracker_miner_iface_dbus_proxy_ignore_next_update_finish;
}


static void rygel_tracker_miner_iface_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void rygel_tracker_miner_iface_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}



static void g_cclosure_user_marshal_VOID__BOXED_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOXED_INT) (gpointer data1, gpointer arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__BOXED_INT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOXED_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boxed (param_values + 1), g_value_get_int (param_values + 2), data2);
}


static void g_cclosure_user_marshal_VOID__BOXED_INT_BOXED_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOXED_INT_BOXED_INT) (gpointer data1, gpointer arg_1, gint arg_2, gpointer arg_3, gint arg_4, gpointer data2);
	register GMarshalFunc_VOID__BOXED_INT_BOXED_INT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOXED_INT_BOXED_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boxed (param_values + 1), g_value_get_int (param_values + 2), g_value_get_boxed (param_values + 3), g_value_get_int (param_values + 4), data2);
}



