/* rygel-search.c generated by valac, the Vala compiler
 * generated from rygel-search.vala, do not modify */

/*
 * Copyright (C) 2008 Nokia Corporation.
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <libgupnp-av/gupnp-av.h>
#include <gee.h>


#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_SEARCH (rygel_search_get_type ())
#define RYGEL_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH, RygelSearch))
#define RYGEL_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH, RygelSearchClass))
#define RYGEL_IS_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH))
#define RYGEL_IS_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH))
#define RYGEL_SEARCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH, RygelSearchClass))

typedef struct _RygelSearch RygelSearch;
typedef struct _RygelSearchClass RygelSearchClass;
typedef struct _RygelSearchPrivate RygelSearchPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_DIDL_LITE_WRITER (rygel_didl_lite_writer_get_type ())
#define RYGEL_DIDL_LITE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DIDL_LITE_WRITER, RygelDIDLLiteWriter))
#define RYGEL_DIDL_LITE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DIDL_LITE_WRITER, RygelDIDLLiteWriterClass))
#define RYGEL_IS_DIDL_LITE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DIDL_LITE_WRITER))
#define RYGEL_IS_DIDL_LITE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DIDL_LITE_WRITER))
#define RYGEL_DIDL_LITE_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DIDL_LITE_WRITER, RygelDIDLLiteWriterClass))

typedef struct _RygelDIDLLiteWriter RygelDIDLLiteWriter;
typedef struct _RygelDIDLLiteWriterClass RygelDIDLLiteWriterClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;
typedef struct _RygelContentDirectoryPrivate RygelContentDirectoryPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelSearchRunData RygelSearchRunData;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;
typedef struct _RygelSearchFetchContainerData RygelSearchFetchContainerData;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;

#define RYGEL_TYPE_SEARCH_CRITERIA_PARSER (rygel_search_criteria_parser_get_type ())
#define RYGEL_SEARCH_CRITERIA_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParser))
#define RYGEL_SEARCH_CRITERIA_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParserClass))
#define RYGEL_IS_SEARCH_CRITERIA_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_CRITERIA_PARSER))
#define RYGEL_IS_SEARCH_CRITERIA_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_CRITERIA_PARSER))
#define RYGEL_SEARCH_CRITERIA_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParserClass))

typedef struct _RygelSearchCriteriaParser RygelSearchCriteriaParser;
typedef struct _RygelSearchCriteriaParserClass RygelSearchCriteriaParserClass;
typedef struct _RygelSearchCriteriaParserPrivate RygelSearchCriteriaParserPrivate;
typedef struct _RygelSearchFetchResultsData RygelSearchFetchResultsData;

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelSearch {
	GObject parent_instance;
	RygelSearchPrivate * priv;
	char* container_id;
	char* search_criteria;
	char* filter;
	guint index;
	guint requested_count;
	char* sort_criteria;
	guint number_returned;
	guint total_matches;
	guint update_id;
};

struct _RygelSearchClass {
	GObjectClass parent_class;
};

struct _RygelSearchPrivate {
	RygelMediaContainer* root_container;
	guint32 system_update_id;
	GUPnPServiceAction* action;
	RygelDIDLLiteWriter* didl_writer;
	GCancellable* _cancellable;
};

struct _RygelContentDirectory {
	GUPnPService parent_instance;
	RygelContentDirectoryPrivate * priv;
	char* feature_list;
	char* sort_caps;
	RygelHTTPServer* http_server;
	RygelMediaContainer* root_container;
	GCancellable* cancellable;
	guint32 system_update_id;
};

struct _RygelContentDirectoryClass {
	GUPnPServiceClass parent_class;
	RygelMediaContainer* (*create_root_container) (RygelContentDirectory* self);
	void (*browse_cb) (RygelContentDirectory* self, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
	void (*search_cb) (RygelContentDirectory* self, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS = 720,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
struct _RygelSearchRunData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSearch* self;
	gboolean _tmp0_;
	RygelMediaContainer* container;
	GeeList* results;
	GeeIterator* _result_it;
	RygelMediaObject* _result_;
	GError * err;
	GError * _inner_error_;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	char* id;
	char* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
	RygelMediaContainer* parent_ref;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
};

struct _RygelSearchFetchContainerData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSearch* self;
	RygelMediaContainer* result;
	RygelMediaObject* media_object;
	gboolean _tmp0_;
	RygelMediaObject* _tmp1_;
	GError * _inner_error_;
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	guint child_count;
	guint32 update_id;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
	void (*get_children) (RygelMediaContainer* self, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GeeList* (*get_children_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
	void (*search) (RygelMediaContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GeeList* (*search_finish) (RygelMediaContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
};

struct _RygelSearchCriteriaParser {
	GObject parent_instance;
	RygelSearchCriteriaParserPrivate * priv;
	char* str;
	RygelSearchExpression* expression;
	GError* err;
};

struct _RygelSearchCriteriaParserClass {
	GObjectClass parent_class;
};

struct _RygelSearchFetchResultsData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSearch* self;
	RygelMediaContainer* container;
	GeeList* result;
	RygelSearchCriteriaParser* parser;
	GeeList* results;
	GError * _inner_error_;
};


static gpointer rygel_search_parent_class = NULL;
static RygelStateMachineIface* rygel_search_rygel_state_machine_parent_iface = NULL;

GType rygel_state_machine_get_type (void);
GType rygel_search_get_type (void);
GType rygel_media_object_get_type (void);
GType rygel_media_container_get_type (void);
GType rygel_didl_lite_writer_get_type (void);
#define RYGEL_SEARCH_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_SEARCH, RygelSearchPrivate))
enum  {
	RYGEL_SEARCH_DUMMY_PROPERTY,
	RYGEL_SEARCH_CANCELLABLE
};
GType rygel_content_directory_get_type (void);
GType rygel_transcode_manager_get_type (void);
GType rygel_http_server_get_type (void);
void rygel_state_machine_set_cancellable (RygelStateMachine* self, GCancellable* value);
RygelDIDLLiteWriter* rygel_didl_lite_writer_new (RygelHTTPServer* http_server);
RygelDIDLLiteWriter* rygel_didl_lite_writer_construct (GType object_type, RygelHTTPServer* http_server);
RygelSearch* rygel_search_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelSearch* rygel_search_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
static void rygel_search_real_run_data_free (gpointer _data);
static void rygel_search_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_search_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GQuark rygel_content_directory_error_quark (void);
static void rygel_search_fetch_container (RygelSearch* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static RygelMediaContainer* rygel_search_fetch_container_finish (RygelSearch* self, GAsyncResult* _res_, GError** error);
static void rygel_search_fetch_results (RygelSearch* self, RygelMediaContainer* container, GAsyncReadyCallback _callback_, gpointer _user_data_);
static GeeList* rygel_search_fetch_results_finish (RygelSearch* self, GAsyncResult* _res_, GError** error);
void rygel_didl_lite_writer_serialize (RygelDIDLLiteWriter* self, RygelMediaObject* media_object, GError** error);
static void rygel_search_conclude (RygelSearch* self);
static void rygel_search_handle_error (RygelSearch* self, GError* _error_);
static gboolean rygel_search_real_run_co (RygelSearchRunData* data);
static void rygel_search_fetch_container_data_free (gpointer _data);
static void rygel_search_fetch_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_media_container_find_object (RygelMediaContainer* self, const char* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static gboolean rygel_search_fetch_container_co (RygelSearchFetchContainerData* data);
static void rygel_search_fetch_results_data_free (gpointer _data);
static void rygel_search_fetch_results_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void);
RygelSearchCriteriaParser* rygel_search_criteria_parser_new (const char* str, GError** error);
RygelSearchCriteriaParser* rygel_search_criteria_parser_construct (GType object_type, const char* str, GError** error);
GType rygel_search_criteria_parser_get_type (void);
void rygel_state_machine_run (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_state_machine_run_finish (RygelStateMachine* self, GAsyncResult* _res_);
void rygel_media_container_search (RygelMediaContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GeeList* rygel_media_container_search_finish (RygelMediaContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static gboolean rygel_search_fetch_results_co (RygelSearchFetchResultsData* data);
static void rygel_search_finalize (GObject* obj);
static void rygel_search_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void rygel_search_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelSearch* rygel_search_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
	RygelSearch * self;
	RygelMediaContainer* _tmp0_;
	GUPnPServiceAction* _tmp1_;
	RygelDIDLLiteWriter* _tmp2_;
	g_return_val_if_fail (content_dir != NULL, NULL);
	g_return_val_if_fail (action != NULL, NULL);
	self = (RygelSearch*) g_object_new (object_type, NULL);
	self->priv->root_container = (_tmp0_ = _g_object_ref0 (content_dir->root_container), _g_object_unref0 (self->priv->root_container), _tmp0_);
	self->priv->system_update_id = content_dir->system_update_id;
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, content_dir->cancellable);
	self->priv->action = (_tmp1_ = action, action = NULL, _tmp1_);
	self->priv->didl_writer = (_tmp2_ = rygel_didl_lite_writer_new (content_dir->http_server), _g_object_unref0 (self->priv->didl_writer), _tmp2_);
	return self;
}


RygelSearch* rygel_search_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
	return rygel_search_construct (RYGEL_TYPE_SEARCH, content_dir, action);
}


static void rygel_search_real_run_data_free (gpointer _data) {
	RygelSearchRunData* data;
	data = _data;
	g_slice_free (RygelSearchRunData, data);
}


static void rygel_search_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSearch * self;
	RygelSearchRunData* _data_;
	self = (RygelSearch*) base;
	_data_ = g_slice_new0 (RygelSearchRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_search_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_search_real_run_data_free);
	_data_->self = self;
	rygel_search_real_run_co (_data_);
}


static void rygel_search_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelSearchRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_search_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSearchRunData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_search_real_run_co (data);
}


static gboolean rygel_search_real_run_co (RygelSearchRunData* data) {
	switch (data->_state_) {
		default:
		g_assert_not_reached ();
		case 0:
		{
			gupnp_service_action_get (data->self->priv->action, "ContainerID", G_TYPE_STRING, &data->self->container_id, "SearchCriteria", G_TYPE_STRING, &data->self->search_criteria, "Filter", G_TYPE_STRING, &data->self->filter, "StartingIndex", G_TYPE_UINT, &data->self->index, "RequestedCount", G_TYPE_UINT, &data->self->requested_count, "SortCriteria", G_TYPE_STRING, &data->self->sort_criteria, NULL);
			{
				if (data->self->container_id == NULL) {
					data->_tmp0_ = TRUE;
				} else {
					data->_tmp0_ = data->self->search_criteria == NULL;
				}
				if (data->_tmp0_) {
					data->_inner_error_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, "No such container");
					if (data->_inner_error_ != NULL) {
						goto __catch41_g_error;
						goto __finally41;
					}
				}
				g_debug ("rygel-search.vala:91: Executing search request: %s", data->self->search_criteria);
				rygel_search_fetch_container (data->self, rygel_search_run_ready, data);
				data->_state_ = 25;
				return FALSE;
				case 25:
				data->container = rygel_search_fetch_container_finish (data->self, data->_res_, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					goto __catch41_g_error;
					goto __finally41;
				}
				rygel_search_fetch_results (data->self, data->container, rygel_search_run_ready, data);
				data->_state_ = 26;
				return FALSE;
				case 26:
				data->results = rygel_search_fetch_results_finish (data->self, data->_res_, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					_g_object_unref0 (data->container);
					goto __catch41_g_error;
					goto __finally41;
				}
				{
					data->_result_it = gee_iterable_iterator ((GeeIterable*) data->results);
					while (TRUE) {
						if (!gee_iterator_next (data->_result_it)) {
							break;
						}
						data->_result_ = (RygelMediaObject*) gee_iterator_get (data->_result_it);
						rygel_didl_lite_writer_serialize (data->self->priv->didl_writer, data->_result_, &data->_inner_error_);
						if (data->_inner_error_ != NULL) {
							_g_object_unref0 (data->_result_);
							_g_object_unref0 (data->_result_it);
							_g_object_unref0 (data->container);
							_g_object_unref0 (data->results);
							goto __catch41_g_error;
							goto __finally41;
						}
						_g_object_unref0 (data->_result_);
					}
					_g_object_unref0 (data->_result_it);
				}
				rygel_search_conclude (data->self);
				_g_object_unref0 (data->container);
				_g_object_unref0 (data->results);
			}
			goto __finally41;
			__catch41_g_error:
			{
				data->err = data->_inner_error_;
				data->_inner_error_ = NULL;
				{
					rygel_search_handle_error (data->self, data->err);
					_g_error_free0 (data->err);
				}
			}
			__finally41:
			if (data->_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, data->_inner_error_->message);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
}


static void rygel_search_fetch_container_data_free (gpointer _data) {
	RygelSearchFetchContainerData* data;
	data = _data;
	_g_object_unref0 (data->result);
	g_slice_free (RygelSearchFetchContainerData, data);
}


static void rygel_search_fetch_container (RygelSearch* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSearchFetchContainerData* _data_;
	_data_ = g_slice_new0 (RygelSearchFetchContainerData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_search_fetch_container);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_search_fetch_container_data_free);
	_data_->self = self;
	rygel_search_fetch_container_co (_data_);
}


static RygelMediaContainer* rygel_search_fetch_container_finish (RygelSearch* self, GAsyncResult* _res_, GError** error) {
	RygelMediaContainer* result;
	RygelSearchFetchContainerData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_search_fetch_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSearchFetchContainerData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_search_fetch_container_co (data);
}


static gboolean rygel_search_fetch_container_co (RygelSearchFetchContainerData* data) {
	switch (data->_state_) {
		default:
		g_assert_not_reached ();
		case 0:
		{
			if (_vala_strcmp0 (data->self->container_id, ((RygelMediaObject*) data->self->priv->root_container)->id) == 0) {
				data->result = _g_object_ref0 (data->self->priv->root_container);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
			rygel_media_container_find_object (data->self->priv->root_container, data->self->container_id, rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self), rygel_search_fetch_container_ready, data);
			data->_state_ = 27;
			return FALSE;
			case 27:
			data->media_object = rygel_media_container_find_object_finish (data->self->priv->root_container, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
			if (data->media_object == NULL) {
				data->_tmp0_ = TRUE;
			} else {
				data->_tmp0_ = !RYGEL_IS_MEDIA_CONTAINER (data->media_object);
			}
			if (data->_tmp0_) {
				data->_inner_error_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, "Specified container does not exist.");
				if (data->_inner_error_ != NULL) {
					g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
					g_error_free (data->_inner_error_);
					_g_object_unref0 (data->media_object);
					{
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
				}
			}
			data->result = _g_object_ref0 ((data->_tmp1_ = data->media_object, RYGEL_IS_MEDIA_CONTAINER (data->_tmp1_) ? ((RygelMediaContainer*) data->_tmp1_) : NULL));
			_g_object_unref0 (data->media_object);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			_g_object_unref0 (data->media_object);
		}
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
}


static void rygel_search_fetch_results_data_free (gpointer _data) {
	RygelSearchFetchResultsData* data;
	data = _data;
	_g_object_unref0 (data->container);
	_g_object_unref0 (data->result);
	g_slice_free (RygelSearchFetchResultsData, data);
}


static void rygel_search_fetch_results (RygelSearch* self, RygelMediaContainer* container, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSearchFetchResultsData* _data_;
	_data_ = g_slice_new0 (RygelSearchFetchResultsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_search_fetch_results);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_search_fetch_results_data_free);
	_data_->self = self;
	_data_->container = _g_object_ref0 (container);
	rygel_search_fetch_results_co (_data_);
}


static GeeList* rygel_search_fetch_results_finish (RygelSearch* self, GAsyncResult* _res_, GError** error) {
	GeeList* result;
	RygelSearchFetchResultsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_search_fetch_results_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSearchFetchResultsData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_search_fetch_results_co (data);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static gboolean rygel_search_fetch_results_co (RygelSearchFetchResultsData* data) {
	switch (data->_state_) {
		default:
		g_assert_not_reached ();
		case 0:
		{
			data->self->update_id = (guint) data->container->update_id;
			data->parser = rygel_search_criteria_parser_new (data->self->search_criteria, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
			rygel_state_machine_run ((RygelStateMachine*) data->parser, rygel_search_fetch_results_ready, data);
			data->_state_ = 28;
			return FALSE;
			case 28:
			rygel_state_machine_run_finish ((RygelStateMachine*) data->parser, data->_res_);
			if (data->parser->err != NULL) {
				data->_inner_error_ = _g_error_copy0 (data->parser->err);
				if (data->_inner_error_ != NULL) {
					g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
					g_error_free (data->_inner_error_);
					_g_object_unref0 (data->parser);
					{
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
				}
			}
			rygel_media_container_search (data->container, data->parser->expression, data->self->index, data->self->requested_count, rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self), rygel_search_fetch_results_ready, data);
			data->_state_ = 29;
			return FALSE;
			case 29:
			data->results = rygel_media_container_search_finish (data->container, data->_res_, &data->self->total_matches, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_g_object_unref0 (data->parser);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
			if (gee_collection_get_size ((GeeCollection*) data->results) == 0) {
				data->_inner_error_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS, "No objects found that could setisfy" " the given search criteria.");
				if (data->_inner_error_ != NULL) {
					g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
					g_error_free (data->_inner_error_);
					_g_object_unref0 (data->parser);
					_g_object_unref0 (data->results);
					{
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
				}
			}
			data->self->number_returned = (guint) gee_collection_get_size ((GeeCollection*) data->results);
			data->result = data->results;
			_g_object_unref0 (data->parser);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			_g_object_unref0 (data->parser);
			_g_object_unref0 (data->results);
		}
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
}


static void rygel_search_conclude (RygelSearch* self) {
	char* didl;
	g_return_if_fail (self != NULL);
	gupnp_didl_lite_writer_filter ((GUPnPDIDLLiteWriter*) self->priv->didl_writer, self->filter);
	didl = gupnp_didl_lite_writer_get_string ((GUPnPDIDLLiteWriter*) self->priv->didl_writer);
	if (self->update_id == G_MAXUINT32) {
		self->update_id = (guint) self->priv->system_update_id;
	}
	gupnp_service_action_set (self->priv->action, "Result", G_TYPE_STRING, didl, "NumberReturned", G_TYPE_UINT, self->number_returned, "TotalMatches", G_TYPE_UINT, self->total_matches, "UpdateID", G_TYPE_UINT, self->update_id, NULL);
	gupnp_service_action_return (self->priv->action);
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
	_g_free0 (didl);
}


static void rygel_search_handle_error (RygelSearch* self, GError* _error_) {
	g_return_if_fail (self != NULL);
	g_warning ("rygel-search.vala:173: Failed to search in '%s': %s\n", self->container_id, _error_->message);
	if (_error_->domain == RYGEL_CONTENT_DIRECTORY_ERROR) {
		gupnp_service_action_return_error (self->priv->action, (guint) _error_->code, _error_->message);
	} else {
		gupnp_service_action_return_error (self->priv->action, (guint) 701, _error_->message);
	}
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
}


static GCancellable* rygel_search_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelSearch* self;
	self = (RygelSearch*) base;
	result = self->priv->_cancellable;
	return result;
}


static void rygel_search_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelSearch* self;
	GCancellable* _tmp0_;
	self = (RygelSearch*) base;
	self->priv->_cancellable = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_cancellable), _tmp0_);
	g_object_notify ((GObject *) self, "cancellable");
}


static void rygel_search_class_init (RygelSearchClass * klass) {
	rygel_search_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelSearchPrivate));
	G_OBJECT_CLASS (klass)->get_property = rygel_search_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_search_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_search_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_SEARCH_CANCELLABLE, "cancellable");
}


static void rygel_search_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
	rygel_search_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = rygel_search_real_run;
	iface->run_finish = rygel_search_real_run_finish;
	iface->get_cancellable = rygel_search_real_get_cancellable;
	iface->set_cancellable = rygel_search_real_set_cancellable;
}


static void rygel_search_instance_init (RygelSearch * self) {
	self->priv = RYGEL_SEARCH_GET_PRIVATE (self);
}


static void rygel_search_finalize (GObject* obj) {
	RygelSearch * self;
	self = RYGEL_SEARCH (obj);
	_g_free0 (self->container_id);
	_g_free0 (self->search_criteria);
	_g_free0 (self->filter);
	_g_free0 (self->sort_criteria);
	_g_object_unref0 (self->priv->root_container);
	_g_object_unref0 (self->priv->didl_writer);
	_g_object_unref0 (self->priv->_cancellable);
	G_OBJECT_CLASS (rygel_search_parent_class)->finalize (obj);
}


GType rygel_search_get_type (void) {
	static GType rygel_search_type_id = 0;
	if (rygel_search_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSearchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_search_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSearch), 0, (GInstanceInitFunc) rygel_search_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_search_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		rygel_search_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelSearch", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_search_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
	}
	return rygel_search_type_id;
}


static void rygel_search_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelSearch * self;
	self = RYGEL_SEARCH (object);
	switch (property_id) {
		case RYGEL_SEARCH_CANCELLABLE:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void rygel_search_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelSearch * self;
	self = RYGEL_SEARCH (object);
	switch (property_id) {
		case RYGEL_SEARCH_CANCELLABLE:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




