/* rygel-external-icon-factory.c generated by valac, the Vala compiler
 * generated from rygel-external-icon-factory.vala, do not modify */

/*
 * Copyright (C) 2009 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <rygel.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TYPE_EXTERNAL_ICON_FACTORY (rygel_external_icon_factory_get_type ())
#define RYGEL_EXTERNAL_ICON_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_EXTERNAL_ICON_FACTORY, RygelExternalIconFactory))
#define RYGEL_EXTERNAL_ICON_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_EXTERNAL_ICON_FACTORY, RygelExternalIconFactoryClass))
#define RYGEL_IS_EXTERNAL_ICON_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_EXTERNAL_ICON_FACTORY))
#define RYGEL_IS_EXTERNAL_ICON_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_EXTERNAL_ICON_FACTORY))
#define RYGEL_EXTERNAL_ICON_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_EXTERNAL_ICON_FACTORY, RygelExternalIconFactoryClass))

typedef struct _RygelExternalIconFactory RygelExternalIconFactory;
typedef struct _RygelExternalIconFactoryClass RygelExternalIconFactoryClass;
typedef struct _RygelExternalIconFactoryPrivate RygelExternalIconFactoryPrivate;
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))

#define FREE_DESKTOP_TYPE_PROPERTIES (free_desktop_properties_get_type ())
#define FREE_DESKTOP_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FREE_DESKTOP_TYPE_PROPERTIES, FreeDesktopProperties))
#define FREE_DESKTOP_IS_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FREE_DESKTOP_TYPE_PROPERTIES))
#define FREE_DESKTOP_PROPERTIES_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FREE_DESKTOP_TYPE_PROPERTIES, FreeDesktopPropertiesIface))

typedef struct _FreeDesktopProperties FreeDesktopProperties;
typedef struct _FreeDesktopPropertiesIface FreeDesktopPropertiesIface;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelExternalIconFactoryCreateData RygelExternalIconFactoryCreateData;
typedef struct _RygelParamSpecExternalIconFactory RygelParamSpecExternalIconFactory;

struct _RygelExternalIconFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelExternalIconFactoryPrivate * priv;
};

struct _RygelExternalIconFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelExternalIconFactory *self);
};

struct _RygelExternalIconFactoryPrivate {
	DBusGConnection* connection;
};

struct _FreeDesktopPropertiesIface {
	GTypeInterface parent_iface;
	void (*get_all) (FreeDesktopProperties* self, const char* iface, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable* (*get_all_finish) (FreeDesktopProperties* self, GAsyncResult* _res_, GError** error);
};

struct _RygelExternalIconFactoryCreateData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelExternalIconFactory* self;
	char* service_name;
	GHashTable* container_props;
	RygelIconInfo* result;
	GValue* value;
	char* icon_path;
	FreeDesktopProperties* props;
	GHashTable* item_props;
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	GError * err;
	GValue* _tmp2_;
	RygelIconInfo* icon;
	GValue* _tmp3_;
	char** uris;
	char** _tmp4_;
	gint uris_size;
	gint uris_length1;
	gboolean _tmp5_;
	char* _tmp6_;
	GValue* _tmp7_;
	GValue* _tmp8_;
	GValue* _tmp9_;
	GValue* _tmp10_;
	GError * _inner_error_;
};

struct _RygelParamSpecExternalIconFactory {
	GParamSpec parent_instance;
};


static char* rygel_external_icon_factory_ITEM_IFACE;
static char* rygel_external_icon_factory_ITEM_IFACE = NULL;
static gpointer rygel_external_icon_factory_parent_class = NULL;

gpointer rygel_external_icon_factory_ref (gpointer instance);
void rygel_external_icon_factory_unref (gpointer instance);
GParamSpec* rygel_param_spec_external_icon_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_external_icon_factory (GValue* value, gpointer v_object);
gpointer rygel_value_get_external_icon_factory (const GValue* value);
GType rygel_external_icon_factory_get_type (void);
#define RYGEL_EXTERNAL_ICON_FACTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_EXTERNAL_ICON_FACTORY, RygelExternalIconFactoryPrivate))
enum  {
	RYGEL_EXTERNAL_ICON_FACTORY_DUMMY_PROPERTY
};
RygelExternalIconFactory* rygel_external_icon_factory_new (DBusGConnection* connection);
RygelExternalIconFactory* rygel_external_icon_factory_construct (GType object_type, DBusGConnection* connection);
static void rygel_external_icon_factory_create_data_free (gpointer _data);
static void rygel_external_icon_factory_create_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static GValue* _g_value_dup (GValue* self);
GType free_desktop_properties_get_type (void);
void free_desktop_properties_get_all (FreeDesktopProperties* self, const char* iface, GAsyncReadyCallback _callback_, gpointer _user_data_);
GHashTable* free_desktop_properties_get_all_finish (FreeDesktopProperties* self, GAsyncResult* _res_, GError** error);
void rygel_external_icon_factory_create (RygelExternalIconFactory* self, const char* service_name, GHashTable* container_props, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelIconInfo* rygel_external_icon_factory_create_finish (RygelExternalIconFactory* self, GAsyncResult* _res_);
static gboolean rygel_external_icon_factory_create_co (RygelExternalIconFactoryCreateData* data);
static void rygel_external_icon_factory_finalize (RygelExternalIconFactory* obj);



static gpointer _dbus_g_connection_ref0 (gpointer self) {
	return self ? dbus_g_connection_ref (self) : NULL;
}


RygelExternalIconFactory* rygel_external_icon_factory_construct (GType object_type, DBusGConnection* connection) {
	RygelExternalIconFactory* self;
	DBusGConnection* _tmp0_;
	g_return_val_if_fail (connection != NULL, NULL);
	self = (RygelExternalIconFactory*) g_type_create_instance (object_type);
	self->priv->connection = (_tmp0_ = _dbus_g_connection_ref0 (connection), _dbus_g_connection_unref0 (self->priv->connection), _tmp0_);
	return self;
}


RygelExternalIconFactory* rygel_external_icon_factory_new (DBusGConnection* connection) {
	return rygel_external_icon_factory_construct (RYGEL_TYPE_EXTERNAL_ICON_FACTORY, connection);
}


static void rygel_external_icon_factory_create_data_free (gpointer _data) {
	RygelExternalIconFactoryCreateData* data;
	data = _data;
	_g_free0 (data->service_name);
	_g_hash_table_unref0 (data->container_props);
	_rygel_icon_info_unref0 (data->result);
	g_slice_free (RygelExternalIconFactoryCreateData, data);
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


void rygel_external_icon_factory_create (RygelExternalIconFactory* self, const char* service_name, GHashTable* container_props, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelExternalIconFactoryCreateData* _data_;
	_data_ = g_slice_new0 (RygelExternalIconFactoryCreateData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, rygel_external_icon_factory_create);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_external_icon_factory_create_data_free);
	_data_->self = self;
	_data_->service_name = g_strdup (service_name);
	_data_->container_props = _g_hash_table_ref0 (container_props);
	rygel_external_icon_factory_create_co (_data_);
}


RygelIconInfo* rygel_external_icon_factory_create_finish (RygelExternalIconFactory* self, GAsyncResult* _res_) {
	RygelIconInfo* result;
	RygelExternalIconFactoryCreateData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_external_icon_factory_create_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelExternalIconFactoryCreateData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_external_icon_factory_create_co (data);
}


static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer __g_value_dup0 (gpointer self) {
	return self ? _g_value_dup (self) : NULL;
}


static gboolean rygel_external_icon_factory_create_co (RygelExternalIconFactoryCreateData* data) {
	switch (data->_state_) {
		default:
		g_assert_not_reached ();
		case 0:
		{
			data->value = __g_value_dup0 ((GValue*) g_hash_table_lookup (data->container_props, "Icon"));
			if (data->value == NULL) {
				data->result = NULL;
				_g_free0 (data->value);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
			data->icon_path = g_strdup (g_value_get_string (data->value));
			data->props = free_desktop_properties_dbus_proxy_new (data->self->priv->connection, data->service_name, data->icon_path);
			{
				free_desktop_properties_get_all (data->props, rygel_external_icon_factory_ITEM_IFACE, rygel_external_icon_factory_create_ready, data);
				data->_state_ = 19;
				return FALSE;
				case 19:
				data->_tmp0_ = free_desktop_properties_get_all_finish (data->props, data->_res_, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					if (data->_inner_error_->domain == DBUS_GERROR) {
						goto __catch8_dbus_gerror;
					}
					goto __finally8;
				}
				data->item_props = (data->_tmp1_ = data->_tmp0_, _g_hash_table_unref0 (data->item_props), data->_tmp1_);
			}
			goto __finally8;
			__catch8_dbus_gerror:
			{
				data->err = data->_inner_error_;
				data->_inner_error_ = NULL;
				{
					g_warning ("rygel-external-icon-factory.vala:53: Error fetching icon properties from %s", data->service_name);
					data->result = NULL;
					_g_error_free0 (data->err);
					_g_free0 (data->value);
					_g_free0 (data->icon_path);
					_g_object_unref0 (data->props);
					_g_hash_table_unref0 (data->item_props);
					{
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
					_g_error_free0 (data->err);
				}
			}
			__finally8:
			if (data->_inner_error_ != NULL) {
				_g_free0 (data->value);
				_g_free0 (data->icon_path);
				_g_object_unref0 (data->props);
				_g_hash_table_unref0 (data->item_props);
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, data->_inner_error_->message);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
			data->value = (data->_tmp2_ = __g_value_dup0 ((GValue*) g_hash_table_lookup (data->item_props, "MIMEType")), _g_free0 (data->value), data->_tmp2_);
			data->icon = rygel_icon_info_new (g_value_get_string (data->value));
			data->value = (data->_tmp3_ = __g_value_dup0 ((GValue*) g_hash_table_lookup (data->item_props, "URLs")), _g_free0 (data->value), data->_tmp3_);
			data->uris = (data->_tmp4_ = (char**) g_value_get_boxed (data->value), data->uris_length1 = -1, data->uris_size = data->uris_length1, data->_tmp4_);
			if (data->uris != NULL) {
				data->_tmp5_ = data->uris[0] != NULL;
			} else {
				data->_tmp5_ = FALSE;
			}
			if (data->_tmp5_) {
				data->icon->uri = (data->_tmp6_ = g_strdup (data->uris[0]), _g_free0 (data->icon->uri), data->_tmp6_);
			}
			data->value = (data->_tmp7_ = __g_value_dup0 ((GValue*) g_hash_table_lookup (data->item_props, "Size")), _g_free0 (data->value), data->_tmp7_);
			if (data->value != NULL) {
				data->icon->size = (glong) g_value_get_int (data->value);
			}
			data->value = (data->_tmp8_ = __g_value_dup0 ((GValue*) g_hash_table_lookup (data->item_props, "Width")), _g_free0 (data->value), data->_tmp8_);
			if (data->value != NULL) {
				data->icon->width = g_value_get_int (data->value);
			}
			data->value = (data->_tmp9_ = __g_value_dup0 ((GValue*) g_hash_table_lookup (data->item_props, "Height")), _g_free0 (data->value), data->_tmp9_);
			if (data->value != NULL) {
				data->icon->height = g_value_get_int (data->value);
			}
			data->value = (data->_tmp10_ = __g_value_dup0 ((GValue*) g_hash_table_lookup (data->item_props, "ColorDepth")), _g_free0 (data->value), data->_tmp10_);
			if (data->value != NULL) {
				data->icon->depth = g_value_get_int (data->value);
			}
			data->result = data->icon;
			_g_free0 (data->value);
			_g_free0 (data->icon_path);
			_g_object_unref0 (data->props);
			_g_hash_table_unref0 (data->item_props);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			_g_free0 (data->value);
			_g_free0 (data->icon_path);
			_g_object_unref0 (data->props);
			_g_hash_table_unref0 (data->item_props);
			_rygel_icon_info_unref0 (data->icon);
		}
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
}


static void rygel_value_external_icon_factory_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_value_external_icon_factory_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_external_icon_factory_unref (value->data[0].v_pointer);
	}
}


static void rygel_value_external_icon_factory_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_external_icon_factory_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_value_external_icon_factory_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_value_external_icon_factory_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelExternalIconFactory* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_external_icon_factory_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_value_external_icon_factory_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelExternalIconFactory** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_external_icon_factory_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_param_spec_external_icon_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecExternalIconFactory* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_EXTERNAL_ICON_FACTORY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_value_get_external_icon_factory (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_EXTERNAL_ICON_FACTORY), NULL);
	return value->data[0].v_pointer;
}


void rygel_value_set_external_icon_factory (GValue* value, gpointer v_object) {
	RygelExternalIconFactory* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_EXTERNAL_ICON_FACTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_EXTERNAL_ICON_FACTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_external_icon_factory_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_external_icon_factory_unref (old);
	}
}


static void rygel_external_icon_factory_class_init (RygelExternalIconFactoryClass * klass) {
	rygel_external_icon_factory_parent_class = g_type_class_peek_parent (klass);
	RYGEL_EXTERNAL_ICON_FACTORY_CLASS (klass)->finalize = rygel_external_icon_factory_finalize;
	g_type_class_add_private (klass, sizeof (RygelExternalIconFactoryPrivate));
	rygel_external_icon_factory_ITEM_IFACE = g_strdup ("org.gnome.UPnP.MediaItem1");
}


static void rygel_external_icon_factory_instance_init (RygelExternalIconFactory * self) {
	self->priv = RYGEL_EXTERNAL_ICON_FACTORY_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void rygel_external_icon_factory_finalize (RygelExternalIconFactory* obj) {
	RygelExternalIconFactory * self;
	self = RYGEL_EXTERNAL_ICON_FACTORY (obj);
	_dbus_g_connection_unref0 (self->priv->connection);
}


GType rygel_external_icon_factory_get_type (void) {
	static GType rygel_external_icon_factory_type_id = 0;
	if (rygel_external_icon_factory_type_id == 0) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_external_icon_factory_init, rygel_value_external_icon_factory_free_value, rygel_value_external_icon_factory_copy_value, rygel_value_external_icon_factory_peek_pointer, "p", rygel_value_external_icon_factory_collect_value, "p", rygel_value_external_icon_factory_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelExternalIconFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_external_icon_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelExternalIconFactory), 0, (GInstanceInitFunc) rygel_external_icon_factory_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		rygel_external_icon_factory_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelExternalIconFactory", &g_define_type_info, &g_define_type_fundamental_info, 0);
	}
	return rygel_external_icon_factory_type_id;
}


gpointer rygel_external_icon_factory_ref (gpointer instance) {
	RygelExternalIconFactory* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_external_icon_factory_unref (gpointer instance) {
	RygelExternalIconFactory* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_EXTERNAL_ICON_FACTORY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}




