/*
 * Copyright (C) 2009 Nokia Corporation, all rights reserved.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __RYGEL_DIDL_LITE_WRITER_H__
#define __RYGEL_DIDL_LITE_WRITER_H__

#include <glib.h>
#include <glib-object.h>
#include <libgupnp-av/gupnp-av.h>
#include "rygel-http-server.h"
#include "rygel-media-object.h"

G_BEGIN_DECLS


#define RYGEL_TYPE_DIDL_LITE_WRITER (rygel_didl_lite_writer_get_type ())
#define RYGEL_DIDL_LITE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DIDL_LITE_WRITER, RygelDIDLLiteWriter))
#define RYGEL_DIDL_LITE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DIDL_LITE_WRITER, RygelDIDLLiteWriterClass))
#define RYGEL_IS_DIDL_LITE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DIDL_LITE_WRITER))
#define RYGEL_IS_DIDL_LITE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DIDL_LITE_WRITER))
#define RYGEL_DIDL_LITE_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DIDL_LITE_WRITER, RygelDIDLLiteWriterClass))

typedef struct _RygelDIDLLiteWriter RygelDIDLLiteWriter;
typedef struct _RygelDIDLLiteWriterClass RygelDIDLLiteWriterClass;
typedef struct _RygelDIDLLiteWriterPrivate RygelDIDLLiteWriterPrivate;

typedef enum  {
	RYGEL_DIDL_LITE_WRITER_ERROR_UNKNOWN_URI_TYPE,
	RYGEL_DIDL_LITE_WRITER_ERROR_UNSUPPORTED_OBJECT
} RygelDIDLLiteWriterError;
#define RYGEL_DIDL_LITE_WRITER_ERROR rygel_didl_lite_writer_error_quark ()
/**
 * Responsible for serializing media objects.
 */
struct _RygelDIDLLiteWriter {
	GUPnPDIDLLiteWriter parent_instance;
	RygelDIDLLiteWriterPrivate * priv;
};

struct _RygelDIDLLiteWriterClass {
	GUPnPDIDLLiteWriterClass parent_class;
};


GQuark rygel_didl_lite_writer_error_quark (void);
RygelDIDLLiteWriter* rygel_didl_lite_writer_construct (GType object_type, RygelHTTPServer* http_server);
RygelDIDLLiteWriter* rygel_didl_lite_writer_new (RygelHTTPServer* http_server);
void rygel_didl_lite_writer_serialize (RygelDIDLLiteWriter* self, RygelMediaObject* media_object, GError** error);
GType rygel_didl_lite_writer_get_type (void);


G_END_DECLS

#endif
