/*
 * Copyright (C) 2009 Nokia Corporation, all rights reserved.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __RYGEL_TRACKER_SEARCH_RESULT_H__
#define __RYGEL_TRACKER_SEARCH_RESULT_H__

#include <glib.h>
#include <glib-object.h>
#include <rygel-simple-async-result.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include "rygel-tracker-category.h"

G_BEGIN_DECLS


#define RYGEL_TYPE_TRACKER_SEARCH_RESULT (rygel_tracker_search_result_get_type ())
#define RYGEL_TRACKER_SEARCH_RESULT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKER_SEARCH_RESULT, RygelTrackerSearchResult))
#define RYGEL_TRACKER_SEARCH_RESULT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRACKER_SEARCH_RESULT, RygelTrackerSearchResultClass))
#define RYGEL_IS_TRACKER_SEARCH_RESULT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKER_SEARCH_RESULT))
#define RYGEL_IS_TRACKER_SEARCH_RESULT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRACKER_SEARCH_RESULT))
#define RYGEL_TRACKER_SEARCH_RESULT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRACKER_SEARCH_RESULT, RygelTrackerSearchResultClass))

typedef struct _RygelTrackerSearchResult RygelTrackerSearchResult;
typedef struct _RygelTrackerSearchResultClass RygelTrackerSearchResultClass;
typedef struct _RygelTrackerSearchResultPrivate RygelTrackerSearchResultPrivate;

/**
 * Handles Tracker Search.Query method results.
 *
 */
struct _RygelTrackerSearchResult {
	RygelSimpleAsyncResult parent_instance;
	RygelTrackerSearchResultPrivate * priv;
};

struct _RygelTrackerSearchResultClass {
	RygelSimpleAsyncResultClass parent_class;
};


RygelTrackerSearchResult* rygel_tracker_search_result_construct (GType object_type, RygelTrackerCategory* category, GAsyncReadyCallback callback, void* callback_target);
RygelTrackerSearchResult* rygel_tracker_search_result_new (RygelTrackerCategory* category, GAsyncReadyCallback callback, void* callback_target);
void rygel_tracker_search_result_ready (RygelTrackerSearchResult* self, char*** search_result, int search_result_length1, GError* error);
GType rygel_tracker_search_result_get_type (void);


G_END_DECLS

#endif
