/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "rygel-tracker-plugin.h"
#include <stdlib.h>
#include <string.h>
#include <rygel-resource-info.h>
#include <rygel-content-directory.h>
#include <rygel-icon-info.h>
#include "rygel-media-tracker.h"







RygelPlugin* load_plugin (void) {
	RygelPlugin* plugin;
	RygelResourceInfo* resource_info;
	RygelIconInfo* icon_info;
	RygelPlugin* _tmp0;
	plugin = rygel_plugin_new ("Tracker");
	/* We only implement a ContentDirectory service*/
	resource_info = rygel_resource_info_new (RYGEL_CONTENT_DIRECTORY_UPNP_ID, RYGEL_CONTENT_DIRECTORY_UPNP_TYPE, RYGEL_CONTENT_DIRECTORY_DESCRIPTION_PATH, RYGEL_TYPE_MEDIA_TRACKER);
	rygel_plugin_add_resource (plugin, resource_info);
	icon_info = rygel_icon_info_new ("image/png", (guint) 48, (guint) 48, (guint) 24, DATA_DIR "/icons/hicolor/48x48/apps/tracker.png");
	/* Mimetype
	 width
	 height
	 depth
	 Path*/
	rygel_plugin_add_icon (plugin, icon_info);
	_tmp0 = NULL;
	return (_tmp0 = plugin, (resource_info == NULL) ? NULL : (resource_info = (rygel_resource_info_unref (resource_info), NULL)), (icon_info == NULL) ? NULL : (icon_info = (rygel_icon_info_unref (icon_info), NULL)), _tmp0);
}




