/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008 Nokia Corporation, all rights reserved.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "rygel-tracker-category.h"
#include <gee/arraylist.h>
#include <gee/collection.h>
#include <rygel-simple-async-result.h>
#include <rygel-content-directory.h>
#include "rygel-tracker-search-result.h"
#include "rygel-tracker-get-metadata-result.h"




struct _RygelTrackerCategoryPrivate {
	GeeList* results;
};

#define RYGEL_TRACKER_CATEGORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_TRACKER_CATEGORY, RygelTrackerCategoryPrivate))
enum  {
	RYGEL_TRACKER_CATEGORY_DUMMY_PROPERTY
};
#define RYGEL_TRACKER_CATEGORY_TRACKER_SERVICE "org.freedesktop.Tracker"
#define RYGEL_TRACKER_CATEGORY_TRACKER_PATH "/org/freedesktop/Tracker"
#define RYGEL_TRACKER_CATEGORY_TRACKER_IFACE "org.freedesktop.Tracker"
#define RYGEL_TRACKER_CATEGORY_SEARCH_PATH "/org/freedesktop/Tracker/Search"
#define RYGEL_TRACKER_CATEGORY_SEARCH_IFACE "org.freedesktop.Tracker.Search"
#define RYGEL_TRACKER_CATEGORY_METADATA_PATH "/org/freedesktop/Tracker/Metadata"
#define RYGEL_TRACKER_CATEGORY_METADATA_IFACE "org.freedesktop.Tracker.Metadata"
void _dynamic_Query0 (DBusGProxy* self, gint param1, const char* param2, char** param3, int param3_length1, const char* param4, char** param5, int param5_length1, const char* param6, gboolean param7, char** param8, int param8_length1, gboolean param9, gint param10, gint param11, gpointer param12, void* param12_target, GError** error);
static void rygel_tracker_category_get_children_count (RygelTrackerCategory* self);
static void rygel_tracker_category_on_search_query_cb (RygelTrackerCategory* self, char*** search_result, int search_result_length1, GError* error);
void _dynamic_Query1 (DBusGProxy* self, gint param1, const char* param2, char** param3, int param3_length1, const char* param4, char** param5, int param5_length1, const char* param6, gboolean param7, char** param8, int param8_length1, gboolean param9, gint param10, gint param11, gpointer param12, void* param12_target, GError** error);
static void rygel_tracker_category_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback callback, void* callback_target);
static GeeList* rygel_tracker_category_real_get_children_finish (RygelMediaContainer* base, GAsyncResult* res, GError** error);
void _dynamic_Get2 (DBusGProxy* self, const char* param1, const char* param2, char** param3, int param3_length1, gpointer param4, void* param4_target, GError** error);
static void rygel_tracker_category_real_find_object (RygelMediaContainer* base, const char* id, GCancellable* cancellable, GAsyncReadyCallback callback, void* callback_target);
static RygelMediaObject* rygel_tracker_category_real_find_object_finish (RygelMediaContainer* base, GAsyncResult* res, GError** error);
static void rygel_tracker_category_create_proxies (RygelTrackerCategory* self, GError** error);
static char* rygel_tracker_category_get_item_parent_id (RygelTrackerCategory* self, const char* item_id);
static char** rygel_tracker_category_real_get_metadata_keys (RygelTrackerCategory* self, int* result_length1);
static RygelMediaItem* rygel_tracker_category_real_create_item (RygelTrackerCategory* self, const char* path, char** metadata, int metadata_length1);
static gpointer rygel_tracker_category_parent_class = NULL;
static void rygel_tracker_category_finalize (GObject* obj);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



RygelTrackerCategory* rygel_tracker_category_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title, const char* category, const char* child_class) {
	GError * inner_error;
	RygelTrackerCategory * self;
	char* _tmp1;
	const char* _tmp0;
	char* _tmp3;
	const char* _tmp2;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (category != NULL, NULL);
	g_return_val_if_fail (child_class != NULL, NULL);
	inner_error = NULL;
	self = (RygelTrackerCategory*) rygel_media_container_construct (object_type, id, parent, title, (guint) 0);
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->category = (_tmp1 = (_tmp0 = category, (_tmp0 == NULL) ? NULL : g_strdup (_tmp0)), self->category = (g_free (self->category), NULL), _tmp1);
	_tmp3 = NULL;
	_tmp2 = NULL;
	self->child_class = (_tmp3 = (_tmp2 = child_class, (_tmp2 == NULL) ? NULL : g_strdup (_tmp2)), self->child_class = (g_free (self->child_class), NULL), _tmp3);
	{
		GeeList* _tmp4;
		rygel_tracker_category_create_proxies (self, &inner_error);
		if (inner_error != NULL) {
			if (inner_error->domain == DBUS_GERROR) {
				goto __catch0_dbus_gerror;
			}
			goto __finally0;
		}
		/* FIXME: We need to hook to some tracker signals to keep
		             *        this field up2date at all times
		             */
		rygel_tracker_category_get_children_count (self);
		_tmp4 = NULL;
		self->priv->results = (_tmp4 = (GeeList*) gee_array_list_new (G_TYPE_ASYNC_RESULT, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal), (self->priv->results == NULL) ? NULL : (self->priv->results = (g_object_unref (self->priv->results), NULL)), _tmp4);
	}
	goto __finally0;
	__catch0_dbus_gerror:
	{
		GError * error;
		error = inner_error;
		inner_error = NULL;
		{
			g_critical ("rygel-tracker-category.vala:73: Failed to create to Session bus: %s\n", error->message);
			(error == NULL) ? NULL : (error = (g_error_free (error), NULL));
		}
	}
	__finally0:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
	return self;
}


RygelTrackerCategory* rygel_tracker_category_new (const char* id, RygelMediaContainer* parent, const char* title, const char* category, const char* child_class) {
	return rygel_tracker_category_construct (RYGEL_TYPE_TRACKER_CATEGORY, id, parent, title, category, child_class);
}


static void _rygel_tracker_category_on_search_query_cb_cb (DBusGProxy* proxy, DBusGProxyCall* call, void* user_data) {
	GError* error;
	GPtrArray* search_result;
	error = NULL;
	dbus_g_proxy_end_call (proxy, call, &error, dbus_g_type_get_collection ("GPtrArray", G_TYPE_STRV), &search_result, G_TYPE_INVALID);
	rygel_tracker_category_on_search_query_cb (user_data, search_result->pdata, search_result->len, error);
}


void _dynamic_Query0 (DBusGProxy* self, gint param1, const char* param2, char** param3, int param3_length1, const char* param4, char** param5, int param5_length1, const char* param6, gboolean param7, char** param8, int param8_length1, gboolean param9, gint param10, gint param11, gpointer param12, void* param12_target, GError** error) {
	dbus_g_proxy_begin_call (self, "Query", _rygel_tracker_category_on_search_query_cb_cb, param12_target, NULL, G_TYPE_INT, param1, G_TYPE_STRING, param2, G_TYPE_STRV, param3, G_TYPE_STRING, param4, G_TYPE_STRV, param5, G_TYPE_STRING, param6, G_TYPE_BOOLEAN, param7, G_TYPE_STRV, param8, G_TYPE_BOOLEAN, param9, G_TYPE_INT, param10, G_TYPE_INT, param11, G_TYPE_INVALID, G_TYPE_INVALID);
	if (*error) {
		return;
	}
}


static void rygel_tracker_category_get_children_count (RygelTrackerCategory* self) {
	GError * inner_error;
	g_return_if_fail (self != NULL);
	inner_error = NULL;
	{
		gint _tmp2_length1;
		char** _tmp2;
		gint _tmp1_length1;
		char** _tmp1;
		gint _tmp0_length1;
		char** _tmp0;
		_tmp2 = NULL;
		_tmp1 = NULL;
		_tmp0 = NULL;
		_dynamic_Query0 (self->search, 0, self->category, (_tmp0 = g_new0 (char*, 0 + 1), _tmp0_length1 = 0, _tmp0), 0, "", (_tmp1 = g_new0 (char*, 0 + 1), _tmp1_length1 = 0, _tmp1), 0, "", FALSE, (_tmp2 = g_new0 (char*, 0 + 1), _tmp2_length1 = 0, _tmp2), 0, FALSE, 0, -1, rygel_tracker_category_on_search_query_cb, self, &inner_error);
		if (inner_error != NULL) {
			goto __catch1_g_error;
			goto __finally1;
		}
		_tmp2 = (_vala_array_free (_tmp2, _tmp2_length1, (GDestroyNotify) g_free), NULL);
		_tmp1 = (_vala_array_free (_tmp1, _tmp1_length1, (GDestroyNotify) g_free), NULL);
		_tmp0 = (_vala_array_free (_tmp0, _tmp0_length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * error;
		error = inner_error;
		inner_error = NULL;
		{
			g_critical ("rygel-tracker-category.vala:93: error getting items under category '%s': %s", self->category, error->message);
			(error == NULL) ? NULL : (error = (g_error_free (error), NULL));
			return;
		}
	}
	__finally1:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
}


static void rygel_tracker_category_on_search_query_cb (RygelTrackerCategory* self, char*** search_result, int search_result_length1, GError* error) {
	g_return_if_fail (self != NULL);
	if (error != NULL) {
		g_critical ("rygel-tracker-category.vala:104: error getting items under category '%s': %s", self->category, error->message);
		return;
	}
	((RygelMediaContainer*) self)->child_count = (guint) search_result_length1;
	rygel_media_container_updated ((RygelMediaContainer*) self);
}


static void _rygel_tracker_search_result_ready_cb (DBusGProxy* proxy, DBusGProxyCall* call, void* user_data) {
	GError* error;
	GPtrArray* search_result;
	error = NULL;
	dbus_g_proxy_end_call (proxy, call, &error, dbus_g_type_get_collection ("GPtrArray", G_TYPE_STRV), &search_result, G_TYPE_INVALID);
	rygel_tracker_search_result_ready (user_data, search_result->pdata, search_result->len, error);
}


void _dynamic_Query1 (DBusGProxy* self, gint param1, const char* param2, char** param3, int param3_length1, const char* param4, char** param5, int param5_length1, const char* param6, gboolean param7, char** param8, int param8_length1, gboolean param9, gint param10, gint param11, gpointer param12, void* param12_target, GError** error) {
	dbus_g_proxy_begin_call (self, "Query", _rygel_tracker_search_result_ready_cb, param12_target, NULL, G_TYPE_INT, param1, G_TYPE_STRING, param2, G_TYPE_STRV, param3, G_TYPE_STRING, param4, G_TYPE_STRV, param5, G_TYPE_STRING, param6, G_TYPE_BOOLEAN, param7, G_TYPE_STRV, param8, G_TYPE_BOOLEAN, param9, G_TYPE_INT, param10, G_TYPE_INT, param11, G_TYPE_INVALID, G_TYPE_INVALID);
	if (*error) {
		return;
	}
}


static void rygel_tracker_category_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback callback, void* callback_target) {
	RygelTrackerCategory * self;
	GError * inner_error;
	RygelTrackerSearchResult* res;
	self = (RygelTrackerCategory*) base;
	inner_error = NULL;
	res = rygel_tracker_search_result_new (self, callback, callback_target);
	gee_collection_add ((GeeCollection*) self->priv->results, (GAsyncResult*) res);
	{
		char** _tmp4;
		gint _tmp3_length1;
		char** _tmp3;
		gint _tmp2_length1;
		char** _tmp2;
		gint _tmp1_length1;
		char** _tmp1;
		gint _tmp0;
		_tmp4 = NULL;
		_tmp3 = NULL;
		_tmp2 = NULL;
		_tmp1 = NULL;
		_tmp4 = (_tmp1 = rygel_tracker_category_get_metadata_keys (self, &_tmp0), _tmp1_length1 = _tmp0, _tmp1);
		_dynamic_Query1 (self->search, 0, self->category, _tmp4, _tmp0, "", (_tmp2 = g_new0 (char*, 0 + 1), _tmp2_length1 = 0, _tmp2), 0, "", FALSE, (_tmp3 = g_new0 (char*, 0 + 1), _tmp3_length1 = 0, _tmp3), 0, FALSE, (gint) offset, (gint) max_count, rygel_tracker_search_result_ready, res, &inner_error);
		if (inner_error != NULL) {
			goto __catch2_g_error;
			goto __finally2;
		}
		_tmp3 = (_vala_array_free (_tmp3, _tmp3_length1, (GDestroyNotify) g_free), NULL);
		_tmp2 = (_vala_array_free (_tmp2, _tmp2_length1, (GDestroyNotify) g_free), NULL);
		_tmp1 = (_vala_array_free (_tmp1, _tmp1_length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError * error;
		error = inner_error;
		inner_error = NULL;
		{
			GError* _tmp6;
			GError* _tmp5;
			_tmp6 = NULL;
			_tmp5 = NULL;
			((RygelSimpleAsyncResult*) res)->error = (_tmp6 = (_tmp5 = error, (_tmp5 == NULL) ? ((gpointer) _tmp5) : g_error_copy (_tmp5)), (((RygelSimpleAsyncResult*) res)->error == NULL) ? NULL : (((RygelSimpleAsyncResult*) res)->error = (g_error_free (((RygelSimpleAsyncResult*) res)->error), NULL)), _tmp6);
			rygel_simple_async_result_complete_in_idle ((RygelSimpleAsyncResult*) res);
			(error == NULL) ? NULL : (error = (g_error_free (error), NULL));
		}
	}
	__finally2:
	if (inner_error != NULL) {
		(res == NULL) ? NULL : (res = (g_object_unref (res), NULL));
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
	(res == NULL) ? NULL : (res = (g_object_unref (res), NULL));
}


static GeeList* rygel_tracker_category_real_get_children_finish (RygelMediaContainer* base, GAsyncResult* res, GError** error) {
	RygelTrackerCategory * self;
	GError * inner_error;
	RygelTrackerSearchResult* _tmp0;
	RygelTrackerSearchResult* search_res;
	self = (RygelTrackerCategory*) base;
	g_return_val_if_fail (res != NULL, NULL);
	inner_error = NULL;
	_tmp0 = NULL;
	search_res = (_tmp0 = RYGEL_TRACKER_SEARCH_RESULT (res), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
	gee_collection_remove ((GeeCollection*) self->priv->results, (GAsyncResult*) search_res);
	if (((RygelSimpleAsyncResult*) search_res)->error != NULL) {
		GError* _tmp1;
		_tmp1 = NULL;
		inner_error = (_tmp1 = ((RygelSimpleAsyncResult*) search_res)->error, (_tmp1 == NULL) ? ((gpointer) _tmp1) : g_error_copy (_tmp1));
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			(search_res == NULL) ? NULL : (search_res = (g_object_unref (search_res), NULL));
			return NULL;
		}
	} else {
		GeeList* _tmp2;
		GeeList* _tmp3;
		_tmp2 = NULL;
		_tmp3 = NULL;
		return (_tmp3 = (_tmp2 = (GeeList*) ((RygelSimpleAsyncResult*) search_res)->data, (_tmp2 == NULL) ? NULL : g_object_ref (_tmp2)), (search_res == NULL) ? NULL : (search_res = (g_object_unref (search_res), NULL)), _tmp3);
	}
	(search_res == NULL) ? NULL : (search_res = (g_object_unref (search_res), NULL));
}


static void _rygel_tracker_get_metadata_result_ready_cb (DBusGProxy* proxy, DBusGProxyCall* call, void* user_data) {
	GError* error;
	char** metadata;
	error = NULL;
	dbus_g_proxy_end_call (proxy, call, &error, G_TYPE_STRV, &metadata, G_TYPE_INVALID);
	rygel_tracker_get_metadata_result_ready (user_data, metadata, g_strv_length (metadata), error);
}


void _dynamic_Get2 (DBusGProxy* self, const char* param1, const char* param2, char** param3, int param3_length1, gpointer param4, void* param4_target, GError** error) {
	dbus_g_proxy_begin_call (self, "Get", _rygel_tracker_get_metadata_result_ready_cb, param4_target, NULL, G_TYPE_STRING, param1, G_TYPE_STRING, param2, G_TYPE_STRV, param3, G_TYPE_INVALID, G_TYPE_INVALID);
	if (*error) {
		return;
	}
}


static void rygel_tracker_category_real_find_object (RygelMediaContainer* base, const char* id, GCancellable* cancellable, GAsyncReadyCallback callback, void* callback_target) {
	RygelTrackerCategory * self;
	GError * inner_error;
	RygelTrackerGetMetadataResult* res;
	self = (RygelTrackerCategory*) base;
	g_return_if_fail (id != NULL);
	inner_error = NULL;
	res = rygel_tracker_get_metadata_result_new (self, callback, callback_target, id);
	gee_collection_add ((GeeCollection*) self->priv->results, (GAsyncResult*) res);
	{
		char* path;
		char** _tmp1;
		gint keys_size;
		gint keys_length1;
		gint _tmp0;
		char** keys;
		path = rygel_tracker_category_get_item_path (self, id);
		if (path == NULL) {
			inner_error = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, "No such object");
			if (inner_error != NULL) {
				path = (g_free (path), NULL);
				goto __catch3_g_error;
				goto __finally3;
			}
		}
		_tmp1 = NULL;
		keys = (_tmp1 = rygel_tracker_category_get_metadata_keys (self, &_tmp0), keys_length1 = _tmp0, keys_size = keys_length1, _tmp1);
		_dynamic_Get2 (self->metadata, self->category, path, keys, keys_length1, rygel_tracker_get_metadata_result_ready, res, &inner_error);
		if (inner_error != NULL) {
			path = (g_free (path), NULL);
			keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
			goto __catch3_g_error;
			goto __finally3;
		}
		path = (g_free (path), NULL);
		keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError * error;
		error = inner_error;
		inner_error = NULL;
		{
			GError* _tmp3;
			GError* _tmp2;
			_tmp3 = NULL;
			_tmp2 = NULL;
			((RygelSimpleAsyncResult*) res)->error = (_tmp3 = (_tmp2 = error, (_tmp2 == NULL) ? ((gpointer) _tmp2) : g_error_copy (_tmp2)), (((RygelSimpleAsyncResult*) res)->error == NULL) ? NULL : (((RygelSimpleAsyncResult*) res)->error = (g_error_free (((RygelSimpleAsyncResult*) res)->error), NULL)), _tmp3);
			rygel_simple_async_result_complete_in_idle ((RygelSimpleAsyncResult*) res);
			(error == NULL) ? NULL : (error = (g_error_free (error), NULL));
		}
	}
	__finally3:
	if (inner_error != NULL) {
		(res == NULL) ? NULL : (res = (g_object_unref (res), NULL));
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
	(res == NULL) ? NULL : (res = (g_object_unref (res), NULL));
}


static RygelMediaObject* rygel_tracker_category_real_find_object_finish (RygelMediaContainer* base, GAsyncResult* res, GError** error) {
	RygelTrackerCategory * self;
	GError * inner_error;
	RygelTrackerGetMetadataResult* _tmp0;
	RygelTrackerGetMetadataResult* metadata_res;
	self = (RygelTrackerCategory*) base;
	g_return_val_if_fail (res != NULL, NULL);
	inner_error = NULL;
	_tmp0 = NULL;
	metadata_res = (_tmp0 = RYGEL_TRACKER_GET_METADATA_RESULT (res), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
	if (((RygelSimpleAsyncResult*) metadata_res)->error != NULL) {
		GError* _tmp1;
		_tmp1 = NULL;
		inner_error = (_tmp1 = ((RygelSimpleAsyncResult*) metadata_res)->error, (_tmp1 == NULL) ? ((gpointer) _tmp1) : g_error_copy (_tmp1));
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			(metadata_res == NULL) ? NULL : (metadata_res = (g_object_unref (metadata_res), NULL));
			return NULL;
		}
	} else {
		RygelMediaObject* _tmp2;
		RygelMediaObject* _tmp3;
		_tmp2 = NULL;
		_tmp3 = NULL;
		return (_tmp3 = (_tmp2 = (RygelMediaObject*) ((RygelSimpleAsyncResult*) metadata_res)->data, (_tmp2 == NULL) ? NULL : g_object_ref (_tmp2)), (metadata_res == NULL) ? NULL : (metadata_res = (g_object_unref (metadata_res), NULL)), _tmp3);
	}
	(metadata_res == NULL) ? NULL : (metadata_res = (g_object_unref (metadata_res), NULL));
}


gboolean rygel_tracker_category_is_thy_child (RygelTrackerCategory* self, const char* item_id) {
	char* parent_id;
	gboolean _tmp0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item_id != NULL, FALSE);
	parent_id = rygel_tracker_category_get_item_parent_id (self, item_id);
	_tmp0 = FALSE;
	if (parent_id != NULL) {
		_tmp0 = _vala_strcmp0 (parent_id, ((RygelMediaObject*) self)->id) == 0;
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		gboolean _tmp1;
		return (_tmp1 = TRUE, parent_id = (g_free (parent_id), NULL), _tmp1);
	} else {
		gboolean _tmp2;
		return (_tmp2 = FALSE, parent_id = (g_free (parent_id), NULL), _tmp2);
	}
	parent_id = (g_free (parent_id), NULL);
}


char* rygel_tracker_category_get_item_path (RygelTrackerCategory* self, const char* item_id) {
	char** _tmp1;
	gint tokens_size;
	gint tokens_length1;
	char** _tmp0;
	char** tokens;
	gboolean _tmp2;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item_id != NULL, NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	tokens = (_tmp1 = _tmp0 = g_strsplit (item_id, ":", 2), tokens_length1 = _vala_array_length (_tmp0), tokens_size = tokens_length1, _tmp1);
	_tmp2 = FALSE;
	if (tokens[0] != NULL) {
		_tmp2 = tokens[1] != NULL;
	} else {
		_tmp2 = FALSE;
	}
	if (_tmp2) {
		const char* _tmp3;
		char* _tmp4;
		_tmp3 = NULL;
		_tmp4 = NULL;
		return (_tmp4 = (_tmp3 = tokens[1], (_tmp3 == NULL) ? NULL : g_strdup (_tmp3)), tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL), _tmp4);
	} else {
		char* _tmp5;
		_tmp5 = NULL;
		return (_tmp5 = NULL, tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL), _tmp5);
	}
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
}


static void rygel_tracker_category_create_proxies (RygelTrackerCategory* self, GError** error) {
	GError * inner_error;
	DBusGConnection* connection;
	DBusGProxy* _tmp0;
	DBusGProxy* _tmp1;
	DBusGProxy* _tmp2;
	g_return_if_fail (self != NULL);
	inner_error = NULL;
	connection = dbus_g_bus_get (DBUS_BUS_SESSION, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return;
	}
	_tmp0 = NULL;
	self->metadata = (_tmp0 = dbus_g_proxy_new_for_name (connection, RYGEL_TRACKER_CATEGORY_TRACKER_SERVICE, RYGEL_TRACKER_CATEGORY_METADATA_PATH, RYGEL_TRACKER_CATEGORY_METADATA_IFACE), (self->metadata == NULL) ? NULL : (self->metadata = (g_object_unref (self->metadata), NULL)), _tmp0);
	_tmp1 = NULL;
	self->search = (_tmp1 = dbus_g_proxy_new_for_name (connection, RYGEL_TRACKER_CATEGORY_TRACKER_SERVICE, RYGEL_TRACKER_CATEGORY_SEARCH_PATH, RYGEL_TRACKER_CATEGORY_SEARCH_IFACE), (self->search == NULL) ? NULL : (self->search = (g_object_unref (self->search), NULL)), _tmp1);
	_tmp2 = NULL;
	self->tracker = (_tmp2 = dbus_g_proxy_new_for_name (connection, RYGEL_TRACKER_CATEGORY_TRACKER_SERVICE, RYGEL_TRACKER_CATEGORY_TRACKER_PATH, RYGEL_TRACKER_CATEGORY_TRACKER_IFACE), (self->tracker == NULL) ? NULL : (self->tracker = (g_object_unref (self->tracker), NULL)), _tmp2);
	(connection == NULL) ? NULL : (connection = (dbus_g_connection_unref (connection), NULL));
}


static char* rygel_tracker_category_get_item_parent_id (RygelTrackerCategory* self, const char* item_id) {
	char** _tmp1;
	gint tokens_size;
	gint tokens_length1;
	char** _tmp0;
	char** tokens;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item_id != NULL, NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	tokens = (_tmp1 = _tmp0 = g_strsplit (item_id, ":", 2), tokens_length1 = _vala_array_length (_tmp0), tokens_size = tokens_length1, _tmp1);
	if (tokens[0] != NULL) {
		const char* _tmp2;
		char* _tmp3;
		_tmp2 = NULL;
		_tmp3 = NULL;
		return (_tmp3 = (_tmp2 = tokens[0], (_tmp2 == NULL) ? NULL : g_strdup (_tmp2)), tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL), _tmp3);
	} else {
		char* _tmp4;
		_tmp4 = NULL;
		return (_tmp4 = NULL, tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL), _tmp4);
	}
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
}


static char** rygel_tracker_category_real_get_metadata_keys (RygelTrackerCategory* self, int* result_length1) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `rygel_tracker_category_get_metadata_keys'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


char** rygel_tracker_category_get_metadata_keys (RygelTrackerCategory* self, int* result_length1) {
	return RYGEL_TRACKER_CATEGORY_GET_CLASS (self)->get_metadata_keys (self, result_length1);
}


static RygelMediaItem* rygel_tracker_category_real_create_item (RygelTrackerCategory* self, const char* path, char** metadata, int metadata_length1) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `rygel_tracker_category_create_item'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


RygelMediaItem* rygel_tracker_category_create_item (RygelTrackerCategory* self, const char* path, char** metadata, int metadata_length1) {
	return RYGEL_TRACKER_CATEGORY_GET_CLASS (self)->create_item (self, path, metadata, metadata_length1);
}


static void rygel_tracker_category_class_init (RygelTrackerCategoryClass * klass) {
	rygel_tracker_category_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelTrackerCategoryPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_tracker_category_finalize;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children = rygel_tracker_category_real_get_children;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children_finish = rygel_tracker_category_real_get_children_finish;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object = rygel_tracker_category_real_find_object;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object_finish = rygel_tracker_category_real_find_object_finish;
	RYGEL_TRACKER_CATEGORY_CLASS (klass)->get_metadata_keys = rygel_tracker_category_real_get_metadata_keys;
	RYGEL_TRACKER_CATEGORY_CLASS (klass)->create_item = rygel_tracker_category_real_create_item;
}


static void rygel_tracker_category_instance_init (RygelTrackerCategory * self) {
	self->priv = RYGEL_TRACKER_CATEGORY_GET_PRIVATE (self);
}


static void rygel_tracker_category_finalize (GObject* obj) {
	RygelTrackerCategory * self;
	self = RYGEL_TRACKER_CATEGORY (obj);
	(self->metadata == NULL) ? NULL : (self->metadata = (g_object_unref (self->metadata), NULL));
	(self->search == NULL) ? NULL : (self->search = (g_object_unref (self->search), NULL));
	(self->tracker == NULL) ? NULL : (self->tracker = (g_object_unref (self->tracker), NULL));
	self->category = (g_free (self->category), NULL);
	self->child_class = (g_free (self->child_class), NULL);
	(self->priv->results == NULL) ? NULL : (self->priv->results = (g_object_unref (self->priv->results), NULL));
	G_OBJECT_CLASS (rygel_tracker_category_parent_class)->finalize (obj);
}


GType rygel_tracker_category_get_type (void) {
	static GType rygel_tracker_category_type_id = 0;
	if (rygel_tracker_category_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerCategoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_tracker_category_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTrackerCategory), 0, (GInstanceInitFunc) rygel_tracker_category_instance_init, NULL };
		rygel_tracker_category_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_CONTAINER, "RygelTrackerCategory", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return rygel_tracker_category_type_id;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




