/*
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2008 Nokia Corporation, all rights reserved.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "rygel-test-root-container.h"
#include <gee/arraylist.h>
#include <rygel-media-item.h>
#include <gee/collection.h>
#include <rygel-simple-async-result.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include "rygel-test-audio-item.h"
#include "rygel-test-video-item.h"




struct _RygelTestRootContainerPrivate {
	GeeArrayList* items;
};

#define RYGEL_TEST_ROOT_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_TEST_ROOT_CONTAINER, RygelTestRootContainerPrivate))
enum  {
	RYGEL_TEST_ROOT_CONTAINER_DUMMY_PROPERTY
};
static void rygel_test_root_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback callback, void* callback_target);
static GeeList* rygel_test_root_container_real_get_children_finish (RygelMediaContainer* base, GAsyncResult* res, GError** error);
static void rygel_test_root_container_real_find_object (RygelMediaContainer* base, const char* id, GCancellable* cancellable, GAsyncReadyCallback callback, void* callback_target);
static RygelMediaObject* rygel_test_root_container_real_find_object_finish (RygelMediaContainer* base, GAsyncResult* res, GError** error);
static gpointer rygel_test_root_container_parent_class = NULL;
static void rygel_test_root_container_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



RygelTestRootContainer* rygel_test_root_container_construct (GType object_type, const char* title) {
	RygelTestRootContainer * self;
	GeeArrayList* _tmp0;
	RygelTestAudioItem* _tmp1;
	RygelTestVideoItem* _tmp2;
	g_return_val_if_fail (title != NULL, NULL);
	self = (RygelTestRootContainer*) rygel_media_container_construct_root (object_type, title, (guint) 0);
	_tmp0 = NULL;
	self->priv->items = (_tmp0 = gee_array_list_new (RYGEL_TYPE_MEDIA_ITEM, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal), (self->priv->items == NULL) ? NULL : (self->priv->items = (g_object_unref (self->priv->items), NULL)), _tmp0);
	_tmp1 = NULL;
	gee_collection_add ((GeeCollection*) self->priv->items, (RygelMediaItem*) (_tmp1 = rygel_test_audio_item_new ("sinewave", (RygelMediaContainer*) self, "Sine Wave")));
	(_tmp1 == NULL) ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL));
	_tmp2 = NULL;
	gee_collection_add ((GeeCollection*) self->priv->items, (RygelMediaItem*) (_tmp2 = rygel_test_video_item_new ("smtpe", (RygelMediaContainer*) self, "SMTPE")));
	(_tmp2 == NULL) ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL));
	((RygelMediaContainer*) self)->child_count = (guint) gee_collection_get_size ((GeeCollection*) self->priv->items);
	return self;
}


RygelTestRootContainer* rygel_test_root_container_new (const char* title) {
	return rygel_test_root_container_construct (RYGEL_TYPE_TEST_ROOT_CONTAINER, title);
}


static void rygel_test_root_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback callback, void* callback_target) {
	RygelTestRootContainer * self;
	guint stop;
	GeeList* children;
	RygelSimpleAsyncResult* res;
	GeeList* _tmp1;
	GeeList* _tmp0;
	self = (RygelTestRootContainer*) base;
	stop = offset + max_count;
	stop = CLAMP (stop, (guint) 0, ((RygelMediaContainer*) self)->child_count);
	children = gee_list_slice ((GeeList*) self->priv->items, (gint) offset, (gint) stop);
	res = rygel_simple_async_result_new (GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GObject*) self, callback, callback_target);
	_tmp1 = NULL;
	_tmp0 = NULL;
	res->data = (_tmp1 = (_tmp0 = children, (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0)), (res->data == NULL) ? NULL : (res->data = (g_object_unref (res->data), NULL)), _tmp1);
	rygel_simple_async_result_complete_in_idle (res);
	(children == NULL) ? NULL : (children = (g_object_unref (children), NULL));
	(res == NULL) ? NULL : (res = (g_object_unref (res), NULL));
}


static GeeList* rygel_test_root_container_real_get_children_finish (RygelMediaContainer* base, GAsyncResult* res, GError** error) {
	RygelTestRootContainer * self;
	RygelSimpleAsyncResult* _tmp0;
	RygelSimpleAsyncResult* simple_res;
	GeeList* _tmp1;
	GeeList* _tmp2;
	self = (RygelTestRootContainer*) base;
	g_return_val_if_fail (res != NULL, NULL);
	_tmp0 = NULL;
	simple_res = (_tmp0 = RYGEL_SIMPLE_ASYNC_RESULT (res), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
	_tmp1 = NULL;
	_tmp2 = NULL;
	return (_tmp2 = (_tmp1 = (GeeList*) simple_res->data, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (simple_res == NULL) ? NULL : (simple_res = (g_object_unref (simple_res), NULL)), _tmp2);
}


static void rygel_test_root_container_real_find_object (RygelMediaContainer* base, const char* id, GCancellable* cancellable, GAsyncReadyCallback callback, void* callback_target) {
	RygelTestRootContainer * self;
	RygelSimpleAsyncResult* res;
	char* _tmp1;
	const char* _tmp0;
	self = (RygelTestRootContainer*) base;
	g_return_if_fail (id != NULL);
	res = rygel_simple_async_result_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, (GObject*) self, callback, callback_target);
	_tmp1 = NULL;
	_tmp0 = NULL;
	res->data = (_tmp1 = (_tmp0 = id, (_tmp0 == NULL) ? NULL : g_strdup (_tmp0)), res->data = (g_free (res->data), NULL), _tmp1);
	rygel_simple_async_result_complete_in_idle (res);
	(res == NULL) ? NULL : (res = (g_object_unref (res), NULL));
}


static RygelMediaObject* rygel_test_root_container_real_find_object_finish (RygelMediaContainer* base, GAsyncResult* res, GError** error) {
	RygelTestRootContainer * self;
	RygelMediaItem* item;
	const char* _tmp0;
	char* id;
	RygelMediaObject* _tmp3;
	self = (RygelTestRootContainer*) base;
	g_return_val_if_fail (res != NULL, NULL);
	item = NULL;
	_tmp0 = NULL;
	id = (_tmp0 = (const char*) RYGEL_SIMPLE_ASYNC_RESULT (res)->data, (_tmp0 == NULL) ? NULL : g_strdup (_tmp0));
	{
		GeeIterator* _tmp_it;
		_tmp_it = gee_iterable_iterator ((GeeIterable*) self->priv->items);
		while (gee_iterator_next (_tmp_it)) {
			RygelMediaItem* tmp;
			tmp = (RygelMediaItem*) gee_iterator_get (_tmp_it);
			if (_vala_strcmp0 (id, ((RygelMediaObject*) tmp)->id) == 0) {
				RygelMediaItem* _tmp2;
				RygelMediaItem* _tmp1;
				_tmp2 = NULL;
				_tmp1 = NULL;
				item = (_tmp2 = (_tmp1 = tmp, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (item == NULL) ? NULL : (item = (g_object_unref (item), NULL)), _tmp2);
				(tmp == NULL) ? NULL : (tmp = (g_object_unref (tmp), NULL));
				break;
			}
			(tmp == NULL) ? NULL : (tmp = (g_object_unref (tmp), NULL));
		}
		(_tmp_it == NULL) ? NULL : (_tmp_it = (g_object_unref (_tmp_it), NULL));
	}
	_tmp3 = NULL;
	return (_tmp3 = (RygelMediaObject*) item, id = (g_free (id), NULL), _tmp3);
}


static void rygel_test_root_container_class_init (RygelTestRootContainerClass * klass) {
	rygel_test_root_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelTestRootContainerPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_test_root_container_finalize;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children = rygel_test_root_container_real_get_children;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children_finish = rygel_test_root_container_real_get_children_finish;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object = rygel_test_root_container_real_find_object;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object_finish = rygel_test_root_container_real_find_object_finish;
}


static void rygel_test_root_container_instance_init (RygelTestRootContainer * self) {
	self->priv = RYGEL_TEST_ROOT_CONTAINER_GET_PRIVATE (self);
}


static void rygel_test_root_container_finalize (GObject* obj) {
	RygelTestRootContainer * self;
	self = RYGEL_TEST_ROOT_CONTAINER (obj);
	(self->priv->items == NULL) ? NULL : (self->priv->items = (g_object_unref (self->priv->items), NULL));
	G_OBJECT_CLASS (rygel_test_root_container_parent_class)->finalize (obj);
}


GType rygel_test_root_container_get_type (void) {
	static GType rygel_test_root_container_type_id = 0;
	if (rygel_test_root_container_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTestRootContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_test_root_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTestRootContainer), 0, (GInstanceInitFunc) rygel_test_root_container_instance_init, NULL };
		rygel_test_root_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_CONTAINER, "RygelTestRootContainer", &g_define_type_info, 0);
	}
	return rygel_test_root_container_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




