/* rygel-l16-transcoder.c generated by valac 0.14.0, the Vala compiler
 * generated from rygel-l16-transcoder.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include <libgupnp-av/gupnp-av.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define TYPE_ENDIANNESS (endianness_get_type ())

#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;
typedef struct _RygelTranscoderPrivate RygelTranscoderPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_L16_TRANSCODER (rygel_l16_transcoder_get_type ())
#define RYGEL_L16_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_L16_TRANSCODER, RygelL16Transcoder))
#define RYGEL_L16_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_L16_TRANSCODER, RygelL16TranscoderClass))
#define RYGEL_IS_L16_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_L16_TRANSCODER))
#define RYGEL_IS_L16_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_L16_TRANSCODER))
#define RYGEL_L16_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_L16_TRANSCODER, RygelL16TranscoderClass))

typedef struct _RygelL16Transcoder RygelL16Transcoder;
typedef struct _RygelL16TranscoderClass RygelL16TranscoderClass;
typedef struct _RygelL16TranscoderPrivate RygelL16TranscoderPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_L16_TRANSCODER_BIN (rygel_l16_transcoder_bin_get_type ())
#define RYGEL_L16_TRANSCODER_BIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_L16_TRANSCODER_BIN, RygelL16TranscoderBin))
#define RYGEL_L16_TRANSCODER_BIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_L16_TRANSCODER_BIN, RygelL16TranscoderBinClass))
#define RYGEL_IS_L16_TRANSCODER_BIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_L16_TRANSCODER_BIN))
#define RYGEL_IS_L16_TRANSCODER_BIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_L16_TRANSCODER_BIN))
#define RYGEL_L16_TRANSCODER_BIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_L16_TRANSCODER_BIN, RygelL16TranscoderBinClass))

typedef struct _RygelL16TranscoderBin RygelL16TranscoderBin;
typedef struct _RygelL16TranscoderBinClass RygelL16TranscoderBinClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))

typedef enum  {
	ENDIANNESS_LITTLE = G_LITTLE_ENDIAN,
	ENDIANNESS_BIG = G_BIG_ENDIAN
} Endianness;

struct _RygelTranscoder {
	GObject parent_instance;
	RygelTranscoderPrivate * priv;
};

struct _RygelTranscoderClass {
	GObjectClass parent_class;
	GstElement* (*create_source) (RygelTranscoder* self, RygelMediaItem* item, GstElement* src, GError** error);
	GUPnPDIDLLiteResource* (*add_resource) (RygelTranscoder* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
	guint (*get_distance) (RygelTranscoder* self, RygelMediaItem* item);
};

struct _RygelL16Transcoder {
	RygelTranscoder parent_instance;
	RygelL16TranscoderPrivate * priv;
};

struct _RygelL16TranscoderClass {
	RygelTranscoderClass parent_class;
};

struct _RygelL16TranscoderPrivate {
	Endianness endianness;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	gchar* date;
	gchar* mime_type;
	gchar* dlna_profile;
	GRegex* address_regex;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_uri) (RygelMediaItem* self, const gchar* uri);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
	glong duration;
	gint bitrate;
	gint sample_freq;
	gint bits_per_sample;
	gint channels;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};


static gpointer rygel_l16_transcoder_parent_class = NULL;

GType endianness_get_type (void) G_GNUC_CONST;
GType rygel_transcoder_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_l16_transcoder_get_type (void) G_GNUC_CONST;
#define RYGEL_L16_TRANSCODER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_L16_TRANSCODER, RygelL16TranscoderPrivate))
enum  {
	RYGEL_L16_TRANSCODER_DUMMY_PROPERTY
};
#define RYGEL_L16_TRANSCODER_CHANNELS 2
#define RYGEL_L16_TRANSCODER_FREQUENCY 44100
#define RYGEL_L16_TRANSCODER_WIDTH 16
#define RYGEL_L16_TRANSCODER_DEPTH 16
#define RYGEL_L16_TRANSCODER_SIGNED TRUE
#define RYGEL_L16_TRANSCODER_AUDIO_CONVERT "audioconvert"
#define RYGEL_L16_TRANSCODER_AUDIO_RESAMPLE "audioresample"
#define RYGEL_L16_TRANSCODER_AUDIO_RATE "audiorate"
#define RYGEL_L16_TRANSCODER_CAPS_FILTER "capsfilter"
RygelL16Transcoder* rygel_l16_transcoder_new (Endianness endianness);
RygelL16Transcoder* rygel_l16_transcoder_construct (GType object_type, Endianness endianness);
#define RYGEL_AUDIO_ITEM_UPNP_CLASS "object.item.audioItem"
RygelTranscoder* rygel_transcoder_construct (GType object_type, const gchar* mime_type, const gchar* dlna_profile, const gchar* upnp_class);
static GstElement* rygel_l16_transcoder_real_create_source (RygelTranscoder* base, RygelMediaItem* item, GstElement* src, GError** error);
RygelL16TranscoderBin* rygel_l16_transcoder_bin_new (RygelMediaItem* item, GstElement* src, RygelL16Transcoder* transcoder, GError** error);
RygelL16TranscoderBin* rygel_l16_transcoder_bin_construct (GType object_type, RygelMediaItem* item, GstElement* src, RygelL16Transcoder* transcoder, GError** error);
GType rygel_l16_transcoder_bin_get_type (void) G_GNUC_CONST;
static GUPnPDIDLLiteResource* rygel_l16_transcoder_real_add_resource (RygelTranscoder* base, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
GUPnPDIDLLiteResource* rygel_transcoder_add_resource (RygelTranscoder* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
static guint rygel_l16_transcoder_real_get_distance (RygelTranscoder* base, RygelMediaItem* item);
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_video_item_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GstElement* rygel_l16_transcoder_create_encoder (RygelL16Transcoder* self, RygelMediaItem* item, const gchar* src_pad_name, const gchar* sink_pad_name, GError** error);
GstElement* rygel_gst_utils_create_element (const gchar* factoryname, const gchar* name, GError** error);
static inline void _dynamic_set_caps3 (GstElement* obj, GstCaps* value);
static void rygel_l16_transcoder_finalize (GObject* obj);


GType endianness_get_type (void) {
	static volatile gsize endianness_type_id__volatile = 0;
	if (g_once_init_enter (&endianness_type_id__volatile)) {
		static const GEnumValue values[] = {{ENDIANNESS_LITTLE, "ENDIANNESS_LITTLE", "little"}, {ENDIANNESS_BIG, "ENDIANNESS_BIG", "big"}, {0, NULL, NULL}};
		GType endianness_type_id;
		endianness_type_id = g_enum_register_static ("Endianness", values);
		g_once_init_leave (&endianness_type_id__volatile, endianness_type_id);
	}
	return endianness_type_id__volatile;
}


RygelL16Transcoder* rygel_l16_transcoder_construct (GType object_type, Endianness endianness) {
	RygelL16Transcoder * self = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* mime_type;
	Endianness _tmp16_;
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp0_ = g_strdup_printf ("%i", RYGEL_L16_TRANSCODER_WIDTH);
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp1_ = _tmp0_;
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp2_ = g_strconcat ("audio/L", _tmp1_, NULL);
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp3_ = _tmp2_;
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp4_ = g_strconcat (_tmp3_, ";rate=", NULL);
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp5_ = _tmp4_;
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp6_ = g_strdup_printf ("%i", RYGEL_L16_TRANSCODER_FREQUENCY);
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp7_ = _tmp6_;
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp8_ = g_strconcat (_tmp5_, _tmp7_, NULL);
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp9_ = _tmp8_;
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp10_ = g_strconcat (_tmp9_, ";channels=", NULL);
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp11_ = _tmp10_;
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp12_ = g_strdup_printf ("%i", RYGEL_L16_TRANSCODER_CHANNELS);
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp13_ = _tmp12_;
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp14_ = g_strconcat (_tmp11_, _tmp13_, NULL);
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp15_ = _tmp14_;
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_g_free0 (_tmp13_);
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_g_free0 (_tmp11_);
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_g_free0 (_tmp9_);
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_g_free0 (_tmp7_);
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_g_free0 (_tmp5_);
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_g_free0 (_tmp3_);
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_g_free0 (_tmp1_);
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	mime_type = _tmp15_;
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	self = (RygelL16Transcoder*) rygel_transcoder_construct (object_type, mime_type, "LPCM", RYGEL_AUDIO_ITEM_UPNP_CLASS);
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp16_ = endianness;
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	self->priv->endianness = _tmp16_;
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_g_free0 (mime_type);
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	return self;
#line 363 "rygel-l16-transcoder.c"
}


RygelL16Transcoder* rygel_l16_transcoder_new (Endianness endianness) {
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	return rygel_l16_transcoder_construct (RYGEL_TYPE_L16_TRANSCODER, endianness);
#line 370 "rygel-l16-transcoder.c"
}


static GstElement* rygel_l16_transcoder_real_create_source (RygelTranscoder* base, RygelMediaItem* item, GstElement* src, GError** error) {
	RygelL16Transcoder * self;
	GstElement* result = NULL;
	RygelMediaItem* _tmp0_;
	GstElement* _tmp1_;
	RygelL16TranscoderBin* _tmp2_;
	RygelL16TranscoderBin* _tmp3_;
	GError * _inner_error_ = NULL;
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	self = (RygelL16Transcoder*) base;
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	g_return_val_if_fail (src != NULL, NULL);
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp0_ = item;
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp1_ = src;
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp2_ = rygel_l16_transcoder_bin_new (_tmp0_, _tmp1_, self, &_inner_error_);
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	gst_object_ref_sink (_tmp2_);
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp3_ = _tmp2_;
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	if (_inner_error_ != NULL) {
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		g_propagate_error (error, _inner_error_);
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		return NULL;
#line 404 "rygel-l16-transcoder.c"
	}
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	gst_object_ref_sink (_tmp3_);
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	result = (GstElement*) _tmp3_;
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	return result;
#line 412 "rygel-l16-transcoder.c"
}


static GUPnPDIDLLiteResource* rygel_l16_transcoder_real_add_resource (RygelTranscoder* base, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error) {
	RygelL16Transcoder * self;
	GUPnPDIDLLiteResource* result = NULL;
	GUPnPDIDLLiteItem* _tmp0_;
	RygelMediaItem* _tmp1_;
	RygelTranscodeManager* _tmp2_;
	GUPnPDIDLLiteResource* _tmp3_ = NULL;
	GUPnPDIDLLiteResource* resource;
	GError * _inner_error_ = NULL;
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	self = (RygelL16Transcoder*) base;
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	g_return_val_if_fail (didl_item != NULL, NULL);
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	g_return_val_if_fail (manager != NULL, NULL);
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp0_ = didl_item;
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp1_ = item;
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp2_ = manager;
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp3_ = RYGEL_TRANSCODER_CLASS (rygel_l16_transcoder_parent_class)->add_resource (RYGEL_TRANSCODER (self), _tmp0_, _tmp1_, _tmp2_, &_inner_error_);
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	resource = _tmp3_;
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	if (_inner_error_ != NULL) {
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		g_propagate_error (error, _inner_error_);
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		return NULL;
#line 449 "rygel-l16-transcoder.c"
	}
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	if (resource == NULL) {
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		result = NULL;
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		_g_object_unref0 (resource);
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		return result;
#line 459 "rygel-l16-transcoder.c"
	}
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	gupnp_didl_lite_resource_set_sample_freq (resource, RYGEL_L16_TRANSCODER_FREQUENCY);
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	gupnp_didl_lite_resource_set_audio_channels (resource, RYGEL_L16_TRANSCODER_CHANNELS);
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	gupnp_didl_lite_resource_set_bits_per_sample (resource, RYGEL_L16_TRANSCODER_WIDTH);
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	gupnp_didl_lite_resource_set_bitrate (resource, ((RYGEL_L16_TRANSCODER_FREQUENCY * RYGEL_L16_TRANSCODER_CHANNELS) * RYGEL_L16_TRANSCODER_WIDTH) / 8);
#line 82 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	result = resource;
#line 82 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	return result;
#line 473 "rygel-l16-transcoder.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 90 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	return self ? g_object_ref (self) : NULL;
#line 480 "rygel-l16-transcoder.c"
}


static guint rygel_l16_transcoder_real_get_distance (RygelTranscoder* base, RygelMediaItem* item) {
	RygelL16Transcoder * self;
	guint result = 0U;
	gboolean _tmp0_ = FALSE;
	RygelMediaItem* _tmp1_;
	gboolean _tmp3_;
	RygelMediaItem* _tmp5_;
	RygelAudioItem* _tmp6_;
	RygelAudioItem* audio_item;
	guint _tmp7_;
	guint distance;
	RygelAudioItem* _tmp8_;
	gint _tmp9_;
	RygelAudioItem* _tmp14_;
	gint _tmp15_;
	RygelAudioItem* _tmp20_;
	gint _tmp21_;
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	self = (RygelL16Transcoder*) base;
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	g_return_val_if_fail (item != NULL, 0U);
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp1_ = item;
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	if (!RYGEL_IS_AUDIO_ITEM (_tmp1_)) {
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		_tmp0_ = TRUE;
#line 511 "rygel-l16-transcoder.c"
	} else {
		RygelMediaItem* _tmp2_;
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		_tmp2_ = item;
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		_tmp0_ = RYGEL_IS_VIDEO_ITEM (_tmp2_);
#line 518 "rygel-l16-transcoder.c"
	}
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp3_ = _tmp0_;
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	if (_tmp3_) {
#line 524 "rygel-l16-transcoder.c"
		guint _tmp4_;
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		_tmp4_ = G_MAXUINT;
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		result = _tmp4_;
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		return result;
#line 532 "rygel-l16-transcoder.c"
	}
#line 90 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp5_ = item;
#line 90 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp6_ = _g_object_ref0 (RYGEL_IS_AUDIO_ITEM (_tmp5_) ? ((RygelAudioItem*) _tmp5_) : NULL);
#line 90 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	audio_item = _tmp6_;
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp7_ = 0;
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	distance = _tmp7_;
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp8_ = audio_item;
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp9_ = _tmp8_->sample_freq;
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	if (_tmp9_ > 0) {
#line 550 "rygel-l16-transcoder.c"
		guint _tmp10_;
		RygelAudioItem* _tmp11_;
		gint _tmp12_;
		gint _tmp13_ = 0;
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		_tmp10_ = distance;
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		_tmp11_ = audio_item;
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		_tmp12_ = _tmp11_->sample_freq;
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		_tmp13_ = abs (_tmp12_ - RYGEL_L16_TRANSCODER_FREQUENCY);
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		distance = _tmp10_ + _tmp13_;
#line 565 "rygel-l16-transcoder.c"
	}
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp14_ = audio_item;
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp15_ = _tmp14_->channels;
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	if (_tmp15_ > 0) {
#line 573 "rygel-l16-transcoder.c"
		guint _tmp16_;
		RygelAudioItem* _tmp17_;
		gint _tmp18_;
		gint _tmp19_ = 0;
#line 98 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		_tmp16_ = distance;
#line 98 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		_tmp17_ = audio_item;
#line 98 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		_tmp18_ = _tmp17_->channels;
#line 98 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		_tmp19_ = abs (_tmp18_ - RYGEL_L16_TRANSCODER_CHANNELS);
#line 98 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		distance = _tmp16_ + _tmp19_;
#line 588 "rygel-l16-transcoder.c"
	}
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp20_ = audio_item;
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp21_ = _tmp20_->bits_per_sample;
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	if (_tmp21_ > 0) {
#line 596 "rygel-l16-transcoder.c"
		guint _tmp22_;
		RygelAudioItem* _tmp23_;
		gint _tmp24_;
		gint _tmp25_ = 0;
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		_tmp22_ = distance;
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		_tmp23_ = audio_item;
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		_tmp24_ = _tmp23_->bits_per_sample;
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		_tmp25_ = abs (_tmp24_ - RYGEL_L16_TRANSCODER_WIDTH);
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		distance = _tmp22_ + _tmp25_;
#line 611 "rygel-l16-transcoder.c"
	}
#line 105 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	result = distance;
#line 105 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_g_object_unref0 (audio_item);
#line 105 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	return result;
#line 619 "rygel-l16-transcoder.c"
}


static gpointer _gst_object_ref0 (gpointer self) {
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	return self ? gst_object_ref (self) : NULL;
#line 626 "rygel-l16-transcoder.c"
}


static inline void _dynamic_set_caps3 (GstElement* obj, GstCaps* value) {
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	g_object_set (obj, "caps", value, NULL);
#line 633 "rygel-l16-transcoder.c"
}


GstElement* rygel_l16_transcoder_create_encoder (RygelL16Transcoder* self, RygelMediaItem* item, const gchar* src_pad_name, const gchar* sink_pad_name, GError** error) {
	GstElement* result = NULL;
	GstElement* _tmp0_ = NULL;
	GstElement* convert1;
	GstElement* _tmp1_ = NULL;
	GstElement* resample;
	GstElement* _tmp2_ = NULL;
	GstElement* audiorate;
	GstElement* _tmp3_ = NULL;
	GstElement* convert2;
	GstElement* _tmp4_ = NULL;
	GstElement* capsfilter;
	GstBin* _tmp5_;
	GstBin* bin;
	GstBin* _tmp6_;
	GstElement* _tmp7_;
	GstElement* _tmp8_;
	GstElement* _tmp9_;
	GstElement* _tmp10_;
	GstElement* _tmp11_;
	GstElement* _tmp12_;
	GstElement* _tmp13_;
	GstElement* _tmp14_;
	GstElement* _tmp15_;
	GstElement* _tmp16_;
	GstElement* _tmp17_;
	Endianness _tmp18_;
	GstCaps* _tmp19_;
	GstCaps* _tmp20_;
	GstElement* _tmp21_;
	GstElement* _tmp22_;
	GstElement* _tmp23_;
	GstElement* _tmp24_;
	GstElement* _tmp25_;
	GstElement* _tmp26_;
	GstPad* _tmp27_ = NULL;
	GstPad* pad;
	const gchar* _tmp28_;
	GstPad* _tmp29_;
	GstGhostPad* _tmp30_;
	GstGhostPad* ghost;
	GstBin* _tmp31_;
	GstGhostPad* _tmp32_;
	GstPad* _tmp33_;
	GstElement* _tmp34_;
	GstPad* _tmp35_ = NULL;
	const gchar* _tmp36_;
	GstPad* _tmp37_;
	GstGhostPad* _tmp38_;
	GstBin* _tmp39_;
	GstGhostPad* _tmp40_;
	GstPad* _tmp41_;
	GError * _inner_error_ = NULL;
#line 108 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 108 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp0_ = rygel_gst_utils_create_element (RYGEL_L16_TRANSCODER_AUDIO_CONVERT, NULL, &_inner_error_);
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	convert1 = _tmp0_;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	if (_inner_error_ != NULL) {
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		g_propagate_error (error, _inner_error_);
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		return NULL;
#line 704 "rygel-l16-transcoder.c"
	}
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp1_ = rygel_gst_utils_create_element (RYGEL_L16_TRANSCODER_AUDIO_RESAMPLE, RYGEL_L16_TRANSCODER_AUDIO_RESAMPLE, &_inner_error_);
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	resample = _tmp1_;
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	if (_inner_error_ != NULL) {
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		g_propagate_error (error, _inner_error_);
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		_gst_object_unref0 (convert1);
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		return NULL;
#line 718 "rygel-l16-transcoder.c"
	}
#line 116 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp2_ = rygel_gst_utils_create_element (RYGEL_L16_TRANSCODER_AUDIO_RATE, NULL, &_inner_error_);
#line 116 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	audiorate = _tmp2_;
#line 116 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	if (_inner_error_ != NULL) {
#line 116 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		g_propagate_error (error, _inner_error_);
#line 116 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		_gst_object_unref0 (resample);
#line 116 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		_gst_object_unref0 (convert1);
#line 116 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		return NULL;
#line 734 "rygel-l16-transcoder.c"
	}
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp3_ = rygel_gst_utils_create_element (RYGEL_L16_TRANSCODER_AUDIO_CONVERT, NULL, &_inner_error_);
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	convert2 = _tmp3_;
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	if (_inner_error_ != NULL) {
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		g_propagate_error (error, _inner_error_);
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		_gst_object_unref0 (audiorate);
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		_gst_object_unref0 (resample);
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		_gst_object_unref0 (convert1);
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		return NULL;
#line 752 "rygel-l16-transcoder.c"
	}
#line 119 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp4_ = rygel_gst_utils_create_element (RYGEL_L16_TRANSCODER_CAPS_FILTER, RYGEL_L16_TRANSCODER_CAPS_FILTER, &_inner_error_);
#line 119 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	capsfilter = _tmp4_;
#line 119 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	if (_inner_error_ != NULL) {
#line 119 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		g_propagate_error (error, _inner_error_);
#line 119 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		_gst_object_unref0 (convert2);
#line 119 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		_gst_object_unref0 (audiorate);
#line 119 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		_gst_object_unref0 (resample);
#line 119 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		_gst_object_unref0 (convert1);
#line 119 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
		return NULL;
#line 772 "rygel-l16-transcoder.c"
	}
#line 122 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp5_ = (GstBin*) gst_bin_new ("l16-encoder-bin");
#line 122 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	gst_object_ref_sink (_tmp5_);
#line 122 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	bin = _tmp5_;
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp6_ = bin;
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp7_ = convert1;
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp8_ = _gst_object_ref0 (_tmp7_);
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp9_ = resample;
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp10_ = _gst_object_ref0 (_tmp9_);
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp11_ = audiorate;
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp12_ = _gst_object_ref0 (_tmp11_);
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp13_ = convert2;
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp14_ = _gst_object_ref0 (_tmp13_);
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp15_ = capsfilter;
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp16_ = _gst_object_ref0 (_tmp15_);
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	gst_bin_add_many (_tmp6_, _tmp8_, _tmp10_, _tmp12_, _tmp14_, _tmp16_, NULL);
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp17_ = capsfilter;
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp18_ = self->priv->endianness;
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp19_ = gst_caps_new_simple ("audio/x-raw-int", "channels", G_TYPE_INT, RYGEL_L16_TRANSCODER_CHANNELS, "rate", G_TYPE_INT, RYGEL_L16_TRANSCODER_FREQUENCY, "width", G_TYPE_INT, RYGEL_L16_TRANSCODER_WIDTH, "depth", G_TYPE_INT, RYGEL_L16_TRANSCODER_DEPTH, "signed", G_TYPE_BOOLEAN, RYGEL_L16_TRANSCODER_SIGNED, "endianness", G_TYPE_INT, _tmp18_, NULL);
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp20_ = _tmp19_;
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_dynamic_set_caps3 (_tmp17_, _tmp20_);
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_gst_caps_unref0 (_tmp20_);
#line 135 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp21_ = convert1;
#line 135 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp22_ = resample;
#line 135 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp23_ = audiorate;
#line 135 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp24_ = convert2;
#line 135 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp25_ = capsfilter;
#line 135 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	gst_element_link_many (_tmp21_, _tmp22_, _tmp23_, _tmp24_, _tmp25_, NULL);
#line 137 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp26_ = convert1;
#line 137 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp27_ = gst_element_get_static_pad (_tmp26_, "sink");
#line 137 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	pad = _tmp27_;
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp28_ = sink_pad_name;
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp29_ = pad;
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp30_ = (GstGhostPad*) gst_ghost_pad_new (_tmp28_, _tmp29_);
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	gst_object_ref_sink (_tmp30_);
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	ghost = _tmp30_;
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp31_ = bin;
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp32_ = ghost;
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp33_ = _gst_object_ref0 ((GstPad*) _tmp32_);
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	gst_element_add_pad ((GstElement*) _tmp31_, _tmp33_);
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp34_ = capsfilter;
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp35_ = gst_element_get_static_pad (_tmp34_, "src");
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_gst_object_unref0 (pad);
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	pad = _tmp35_;
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp36_ = src_pad_name;
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp37_ = pad;
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp38_ = (GstGhostPad*) gst_ghost_pad_new (_tmp36_, _tmp37_);
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	gst_object_ref_sink (_tmp38_);
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_gst_object_unref0 (ghost);
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	ghost = _tmp38_;
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp39_ = bin;
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp40_ = ghost;
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_tmp41_ = _gst_object_ref0 ((GstPad*) _tmp40_);
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	gst_element_add_pad ((GstElement*) _tmp39_, _tmp41_);
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	result = (GstElement*) bin;
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_gst_object_unref0 (ghost);
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_gst_object_unref0 (pad);
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_gst_object_unref0 (capsfilter);
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_gst_object_unref0 (convert2);
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_gst_object_unref0 (audiorate);
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_gst_object_unref0 (resample);
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	_gst_object_unref0 (convert1);
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	return result;
#line 898 "rygel-l16-transcoder.c"
}


static void rygel_l16_transcoder_class_init (RygelL16TranscoderClass * klass) {
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	rygel_l16_transcoder_parent_class = g_type_class_peek_parent (klass);
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	g_type_class_add_private (klass, sizeof (RygelL16TranscoderPrivate));
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	RYGEL_TRANSCODER_CLASS (klass)->create_source = rygel_l16_transcoder_real_create_source;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	RYGEL_TRANSCODER_CLASS (klass)->add_resource = rygel_l16_transcoder_real_add_resource;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	RYGEL_TRANSCODER_CLASS (klass)->get_distance = rygel_l16_transcoder_real_get_distance;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_l16_transcoder_finalize;
#line 915 "rygel-l16-transcoder.c"
}


static void rygel_l16_transcoder_instance_init (RygelL16Transcoder * self) {
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	self->priv = RYGEL_L16_TRANSCODER_GET_PRIVATE (self);
#line 922 "rygel-l16-transcoder.c"
}


static void rygel_l16_transcoder_finalize (GObject* obj) {
	RygelL16Transcoder * self;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	self = RYGEL_L16_TRANSCODER (obj);
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-l16-transcoder.vala"
	G_OBJECT_CLASS (rygel_l16_transcoder_parent_class)->finalize (obj);
#line 932 "rygel-l16-transcoder.c"
}


/**
 * Transcoder for linear PCM audio (LPCM). This element uses L16TrancoderBin for
 * actual transcoding.
 */
GType rygel_l16_transcoder_get_type (void) {
	static volatile gsize rygel_l16_transcoder_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_l16_transcoder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelL16TranscoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_l16_transcoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelL16Transcoder), 0, (GInstanceInitFunc) rygel_l16_transcoder_instance_init, NULL };
		GType rygel_l16_transcoder_type_id;
		rygel_l16_transcoder_type_id = g_type_register_static (RYGEL_TYPE_TRANSCODER, "RygelL16Transcoder", &g_define_type_info, 0);
		g_once_init_leave (&rygel_l16_transcoder_type_id__volatile, rygel_l16_transcoder_type_id);
	}
	return rygel_l16_transcoder_type_id__volatile;
}



