/* rygel-item-creator.c generated by valac 0.13.4, the Vala compiler
 * generated from rygel-item-creator.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <libgupnp/gupnp.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <gst/gst.h>
#include <libgupnp-dlna/gupnp-dlna-discoverer.h>
#include <libgupnp-dlna/gupnp-dlna-profile.h>


#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_ITEM_CREATOR (rygel_item_creator_get_type ())
#define RYGEL_ITEM_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ITEM_CREATOR, RygelItemCreator))
#define RYGEL_ITEM_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ITEM_CREATOR, RygelItemCreatorClass))
#define RYGEL_IS_ITEM_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ITEM_CREATOR))
#define RYGEL_IS_ITEM_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ITEM_CREATOR))
#define RYGEL_ITEM_CREATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ITEM_CREATOR, RygelItemCreatorClass))

typedef struct _RygelItemCreator RygelItemCreator;
typedef struct _RygelItemCreatorClass RygelItemCreatorClass;
typedef struct _RygelItemCreatorPrivate RygelItemCreatorPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelContentDirectoryPrivate RygelContentDirectoryPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_WRITABLE_CONTAINER (rygel_writable_container_get_type ())
#define RYGEL_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainer))
#define RYGEL_IS_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER))
#define RYGEL_WRITABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainerIface))

typedef struct _RygelWritableContainer RygelWritableContainer;
typedef struct _RygelWritableContainerIface RygelWritableContainerIface;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_ITEM_REMOVAL_QUEUE (rygel_item_removal_queue_get_type ())
#define RYGEL_ITEM_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueue))
#define RYGEL_ITEM_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueueClass))
#define RYGEL_IS_ITEM_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE))
#define RYGEL_IS_ITEM_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ITEM_REMOVAL_QUEUE))
#define RYGEL_ITEM_REMOVAL_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueueClass))

typedef struct _RygelItemRemovalQueue RygelItemRemovalQueue;
typedef struct _RygelItemRemovalQueueClass RygelItemRemovalQueueClass;
typedef struct _RygelItemCreatorRunData RygelItemCreatorRunData;
typedef struct _RygelItemCreatorParseArgsData RygelItemCreatorParseArgsData;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;

#define RYGEL_TYPE_RELATIONAL_EXPRESSION (rygel_relational_expression_get_type ())
#define RYGEL_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpression))
#define RYGEL_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))
#define RYGEL_IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))

typedef struct _RygelRelationalExpression RygelRelationalExpression;
typedef struct _RygelRelationalExpressionClass RygelRelationalExpressionClass;
typedef struct _RygelSearchExpressionPrivate RygelSearchExpressionPrivate;

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerIface))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerIface RygelSearchableContainerIface;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
typedef struct _RygelItemCreatorFetchContainerData RygelItemCreatorFetchContainerData;

#define RYGEL_TYPE_IMAGE_ITEM (rygel_image_item_get_type ())
#define RYGEL_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_IMAGE_ITEM, RygelImageItem))
#define RYGEL_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_IMAGE_ITEM, RygelImageItemClass))
#define RYGEL_IS_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_IMAGE_ITEM))
#define RYGEL_IS_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_IMAGE_ITEM))
#define RYGEL_IMAGE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_IMAGE_ITEM, RygelImageItemClass))

typedef struct _RygelImageItem RygelImageItem;
typedef struct _RygelImageItemClass RygelImageItemClass;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;

#define RYGEL_TYPE_PHOTO_ITEM (rygel_photo_item_get_type ())
#define RYGEL_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItem))
#define RYGEL_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItemClass))
#define RYGEL_IS_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PHOTO_ITEM))
#define RYGEL_IS_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PHOTO_ITEM))
#define RYGEL_PHOTO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItemClass))

typedef struct _RygelPhotoItem RygelPhotoItem;
typedef struct _RygelPhotoItemClass RygelPhotoItemClass;

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _RygelItemCreatorCreateUriData RygelItemCreatorCreateUriData;
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
typedef struct _RygelItemCreatorWaitForItemData RygelItemCreatorWaitForItemData;

typedef enum  {
	RYGEL_ITEM_CREATOR_ERROR_PARSE
} RygelItemCreatorError;
#define RYGEL_ITEM_CREATOR_ERROR rygel_item_creator_error_quark ()
struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelItemCreator {
	GObject parent_instance;
	RygelItemCreatorPrivate * priv;
	gchar* container_id;
	gchar* elements;
	GUPnPDIDLLiteItem* didl_item;
	RygelMediaItem* item;
};

struct _RygelItemCreatorClass {
	GObjectClass parent_class;
};

struct _RygelItemCreatorPrivate {
	RygelContentDirectory* content_dir;
	GUPnPServiceAction* action;
	GUPnPDIDLLiteWriter* didl_writer;
	GUPnPDIDLLiteParser* didl_parser;
	GCancellable* _cancellable;
};

struct _RygelContentDirectory {
	GUPnPService parent_instance;
	RygelContentDirectoryPrivate * priv;
	gchar* feature_list;
	RygelHTTPServer* http_server;
	RygelMediaContainer* root_container;
	GCancellable* cancellable;
	guint32 system_update_id;
};

struct _RygelContentDirectoryClass {
	GUPnPServiceClass parent_class;
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SORT_CRITERIA = 709,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT = 711,
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA = 712,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT = 713,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_DESTINATION_RESOURCE = 718,
	RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS = 720,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
struct _RygelWritableContainerIface {
	GTypeInterface parent_iface;
	void (*add_item) (RygelWritableContainer* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*remove_item) (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	GeeArrayList* (*get_create_classes) (RygelWritableContainer* self);
	void (*set_create_classes) (RygelWritableContainer* self, GeeArrayList* value);
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	gchar* date;
	gchar* mime_type;
	gchar* dlna_profile;
	GRegex* address_regex;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_uri) (RygelMediaItem* self, const gchar* uri);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelItemCreatorRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemCreator* self;
	GUPnPDIDLLiteParser* _tmp0_;
	GUPnPDIDLLiteParser* _tmp1_;
	const gchar* _tmp2_;
	GError* parse_err;
	GError* _tmp3_;
	GUPnPDIDLLiteItem* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* message;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GError* _tmp9_;
	gboolean _tmp10_;
	GUPnPDIDLLiteItem* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	GUPnPDIDLLiteItem* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gboolean _tmp17_;
	GError* _tmp18_;
	GUPnPDIDLLiteItem* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	GError* _tmp22_;
	GUPnPDIDLLiteItem* _tmp23_;
	GUPnPOCMFlags _tmp24_;
	GUPnPOCMFlags _tmp25_;
	GError* _tmp26_;
	gboolean _tmp27_;
	gboolean _tmp28_;
	GUPnPDIDLLiteItem* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	GUPnPDIDLLiteItem* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	gboolean _tmp35_;
	GUPnPDIDLLiteItem* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	gboolean _tmp39_;
	gboolean _tmp40_;
	GError* _tmp41_;
	GUPnPDIDLLiteItem* _tmp42_;
	gboolean _tmp43_;
	gboolean _tmp44_;
	GError* _tmp45_;
	RygelWritableContainer* _tmp46_;
	RygelWritableContainer* container;
	gboolean _tmp47_;
	RygelWritableContainer* _tmp48_;
	GeeArrayList* _tmp49_;
	GeeArrayList* _tmp50_;
	GUPnPDIDLLiteItem* _tmp51_;
	const gchar* _tmp52_;
	const gchar* _tmp53_;
	gboolean _tmp54_;
	const gchar* _tmp55_;
	gboolean _tmp56_;
	GUPnPDIDLLiteItem* _tmp57_;
	const gchar* _tmp58_;
	const gchar* _tmp59_;
	RygelWritableContainer* _tmp60_;
	const gchar* _tmp61_;
	GError* _tmp62_;
	GUPnPDIDLLiteItem* _tmp63_;
	const gchar* _tmp64_;
	const gchar* _tmp65_;
	RygelWritableContainer* _tmp66_;
	GUPnPDIDLLiteItem* _tmp67_;
	const gchar* _tmp68_;
	const gchar* _tmp69_;
	GUPnPDIDLLiteItem* _tmp70_;
	const gchar* _tmp71_;
	const gchar* _tmp72_;
	RygelMediaItem* _tmp73_;
	RygelMediaItem* _tmp74_;
	GUPnPDIDLLiteItem* _tmp75_;
	GList* _tmp76_;
	GList* resources;
	gboolean _tmp77_;
	GList* _tmp78_;
	GList* _tmp79_;
	guint _tmp80_;
	gboolean _tmp81_;
	GList* _tmp82_;
	GList* _tmp83_;
	gconstpointer _tmp84_;
	GUPnPDIDLLiteResource* _tmp85_;
	GUPnPDIDLLiteResource* resource;
	GUPnPDIDLLiteResource* _tmp86_;
	GUPnPProtocolInfo* _tmp87_;
	GUPnPProtocolInfo* _tmp88_;
	GUPnPProtocolInfo* _tmp89_;
	GUPnPProtocolInfo* info;
	GUPnPProtocolInfo* _tmp90_;
	GUPnPProtocolInfo* _tmp91_;
	const gchar* _tmp92_;
	const gchar* _tmp93_;
	GUPnPProtocolInfo* _tmp94_;
	const gchar* _tmp95_;
	const gchar* _tmp96_;
	gboolean _tmp97_;
	GUPnPProtocolInfo* _tmp98_;
	const gchar* _tmp99_;
	const gchar* _tmp100_;
	GError* _tmp101_;
	RygelMediaItem* _tmp102_;
	GUPnPProtocolInfo* _tmp103_;
	const gchar* _tmp104_;
	const gchar* _tmp105_;
	gchar* _tmp106_;
	GUPnPProtocolInfo* _tmp107_;
	const gchar* _tmp108_;
	const gchar* _tmp109_;
	RygelMediaItem* _tmp110_;
	GUPnPProtocolInfo* _tmp111_;
	const gchar* _tmp112_;
	const gchar* _tmp113_;
	gchar* _tmp114_;
	GUPnPDIDLLiteResource* _tmp115_;
	const gchar* _tmp116_;
	const gchar* _tmp117_;
	gboolean _tmp118_;
	RygelMediaItem* _tmp119_;
	GUPnPDIDLLiteResource* _tmp120_;
	const gchar* _tmp121_;
	const gchar* _tmp122_;
	GUPnPDIDLLiteResource* _tmp123_;
	glong _tmp124_;
	glong _tmp125_;
	RygelMediaItem* _tmp126_;
	GUPnPDIDLLiteResource* _tmp127_;
	glong _tmp128_;
	glong _tmp129_;
	RygelMediaItem* _tmp130_;
	const gchar* _tmp131_;
	RygelMediaItem* _tmp132_;
	gchar* _tmp133_;
	RygelMediaItem* _tmp134_;
	gint64 _tmp135_;
	gint64 _tmp136_;
	RygelMediaItem* _tmp137_;
	RygelMediaItem* _tmp138_;
	GeeArrayList* _tmp139_;
	gint _tmp140_;
	gint _tmp141_;
	RygelWritableContainer* _tmp142_;
	RygelMediaItem* _tmp143_;
	const gchar* _tmp144_;
	const gchar* _tmp145_;
	gchar* _tmp146_;
	gchar* uri;
	RygelMediaItem* _tmp147_;
	GeeArrayList* _tmp148_;
	const gchar* _tmp149_;
	RygelMediaItem* _tmp150_;
	RygelMediaItem* _tmp151_;
	GeeArrayList* _tmp152_;
	gpointer _tmp153_;
	gchar* _tmp154_;
	GFile* _tmp155_;
	GFile* _tmp156_;
	GFile* file;
	RygelMediaItem* _tmp157_;
	GFile* _tmp158_;
	gboolean _tmp159_;
	RygelMediaItem* _tmp160_;
	RygelMediaItem* _tmp161_;
	GeeArrayList* _tmp162_;
	gpointer _tmp163_;
	RygelWritableContainer* _tmp164_;
	RygelMediaItem* _tmp165_;
	GCancellable* _tmp166_;
	GCancellable* _tmp167_;
	RygelWritableContainer* _tmp168_;
	RygelMediaItem* _tmp169_;
	GUPnPDIDLLiteWriter* _tmp170_;
	RygelContentDirectory* _tmp171_;
	RygelHTTPServer* _tmp172_;
	GUPnPDIDLLiteObject* _tmp173_;
	GUPnPDIDLLiteObject* _tmp174_;
	gboolean _tmp175_;
	const gchar* _tmp176_;
	RygelMediaItem* _tmp177_;
	gboolean _tmp178_;
	gboolean _tmp179_;
	gboolean _tmp180_;
	RygelItemRemovalQueue* _tmp181_;
	RygelItemRemovalQueue* queue;
	RygelItemRemovalQueue* _tmp182_;
	RygelMediaItem* _tmp183_;
	GCancellable* _tmp184_;
	GCancellable* _tmp185_;
	GError* err;
	GError* _tmp186_;
	GError * _inner_error_;
};

struct _RygelItemCreatorParseArgsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemCreator* self;
	GUPnPServiceAction* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GError* _tmp3_;
	GPatternSpec* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_;
	const gchar* _tmp7_;
	GError* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	GError* _tmp11_;
	GError * _inner_error_;
};

struct _RygelSearchExpression {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSearchExpressionPrivate * priv;
	gpointer op;
	gpointer operand1;
	gpointer operand2;
};

struct _RygelSearchExpressionClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSearchExpression *self);
	gboolean (*satisfied_by) (RygelSearchExpression* self, RygelMediaObject* media_object);
	gchar* (*to_string) (RygelSearchExpression* self);
};

struct _RygelSearchableContainerIface {
	GTypeInterface parent_iface;
	void (*search) (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	GeeArrayList* (*get_search_classes) (RygelSearchableContainer* self);
	void (*set_search_classes) (RygelSearchableContainer* self, GeeArrayList* value);
};

struct _RygelItemCreatorFetchContainerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemCreator* self;
	RygelWritableContainer* result;
	RygelMediaObject* media_object;
	const gchar* _tmp0_;
	GUPnPDIDLLiteItem* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* upnp_class;
	const gchar* _tmp5_;
	RygelRelationalExpression* _tmp6_;
	RygelRelationalExpression* expression;
	RygelRelationalExpression* _tmp7_;
	RygelRelationalExpression* _tmp8_;
	gchar* _tmp9_;
	RygelRelationalExpression* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	guint total_matches;
	RygelContentDirectory* _tmp13_;
	RygelMediaContainer* _tmp14_;
	RygelSearchableContainer* _tmp15_;
	RygelSearchableContainer* container;
	RygelSearchableContainer* _tmp16_;
	RygelSearchableContainer* _tmp17_;
	RygelRelationalExpression* _tmp18_;
	GCancellable* _tmp19_;
	GCancellable* _tmp20_;
	guint _tmp21_;
	RygelMediaObjects* _tmp22_;
	RygelMediaObjects* _result_;
	RygelMediaObjects* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	RygelMediaObjects* _tmp26_;
	gpointer _tmp27_;
	GUPnPDIDLLiteItem* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	GUPnPDIDLLiteItem* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	GError* _tmp34_;
	RygelContentDirectory* _tmp35_;
	RygelMediaContainer* _tmp36_;
	const gchar* _tmp37_;
	GCancellable* _tmp38_;
	GCancellable* _tmp39_;
	RygelMediaObject* _tmp40_;
	RygelMediaObject* _tmp41_;
	RygelMediaObject* _tmp42_;
	const gchar* _tmp43_;
	GError* _tmp44_;
	gboolean _tmp45_;
	RygelMediaObject* _tmp46_;
	RygelMediaObject* _tmp47_;
	GUPnPOCMFlags _tmp48_;
	GUPnPOCMFlags _tmp49_;
	gboolean _tmp50_;
	const gchar* _tmp51_;
	RygelMediaObject* _tmp52_;
	const gchar* _tmp53_;
	GError* _tmp54_;
	RygelMediaObject* _tmp55_;
	RygelWritableContainer* _tmp56_;
	GError * _inner_error_;
};

struct _RygelItemCreatorCreateUriData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemCreator* self;
	RygelWritableContainer* container;
	gchar* title;
	gchar* result;
	RygelWritableContainer* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	GFile* _tmp3_;
	GFile* dir;
	GFile* _tmp4_;
	const gchar* _tmp5_;
	RygelWritableContainer* _tmp6_;
	const gchar* _tmp7_;
	GError* _tmp8_;
	GDateTime* _tmp9_;
	GDateTime* now;
	GFile* _tmp10_;
	const gchar* _tmp11_;
	GFile* _tmp12_;
	GFile* file;
	GFile* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GDateTime* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GError * _inner_error_;
};

struct _Block5Data {
	int _ref_count_;
	RygelItemCreator * self;
	RygelWritableContainer* container;
	gpointer _async_data_;
};

struct _Block6Data {
	int _ref_count_;
	Block5Data * _data5_;
	guint timeout;
};

struct _RygelItemCreatorWaitForItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemCreator* self;
	RygelWritableContainer* container;
	Block5Data* _data5_;
	RygelWritableContainer* _tmp0_;
	RygelWritableContainer* _tmp1_;
	RygelWritableContainer* _tmp2_;
	const gchar* _tmp3_;
	RygelMediaItem* item;
	RygelMediaItem* _tmp4_;
	RygelMediaItem* _tmp5_;
	Block6Data* _data6_;
	RygelWritableContainer* _tmp6_;
	gulong _tmp7_;
	gulong id;
	guint _tmp8_;
	RygelWritableContainer* _tmp9_;
	gulong _tmp10_;
	RygelWritableContainer* _tmp11_;
	RygelMediaItem* _tmp12_;
	const gchar* _tmp13_;
	GCancellable* _tmp14_;
	GCancellable* _tmp15_;
	RygelMediaObject* _tmp16_;
	RygelMediaObject* _tmp17_;
	GError* _error_;
	RygelWritableContainer* _tmp18_;
	const gchar* _tmp19_;
	RygelMediaItem* _tmp20_;
	const gchar* _tmp21_;
	guint _tmp22_;
	guint _tmp23_;
	RygelWritableContainer* _tmp24_;
	const gchar* _tmp25_;
	GError * _inner_error_;
};


static gpointer rygel_item_creator_parent_class = NULL;
static GPatternSpec* rygel_item_creator_comment_pattern;
static GPatternSpec* rygel_item_creator_comment_pattern = NULL;
static RygelStateMachineIface* rygel_item_creator_rygel_state_machine_parent_iface = NULL;

GQuark rygel_item_creator_error_quark (void);
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_item_creator_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
#define RYGEL_ITEM_CREATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_ITEM_CREATOR, RygelItemCreatorPrivate))
enum  {
	RYGEL_ITEM_CREATOR_DUMMY_PROPERTY,
	RYGEL_ITEM_CREATOR_CANCELLABLE
};
RygelItemCreator* rygel_item_creator_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelItemCreator* rygel_item_creator_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
void rygel_state_machine_set_cancellable (RygelStateMachine* self, GCancellable* value);
static void rygel_item_creator_real_run_data_free (gpointer _data);
static void rygel_item_creator_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_item_creator_real_run_co (RygelItemCreatorRunData* _data_);
static void rygel_item_creator_parse_args (RygelItemCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_item_creator_parse_args_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error);
static void ___lambda9_ (RygelItemCreator* self, GUPnPDIDLLiteItem* didl_item);
static void ____lambda9__gupnp_didl_lite_parser_item_available (GUPnPDIDLLiteParser* _sender, GUPnPDIDLLiteItem* item, gpointer self);
GQuark rygel_content_directory_error_quark (void);
static void rygel_item_creator_fetch_container (RygelItemCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
GType rygel_writable_container_get_type (void) G_GNUC_CONST;
static RygelWritableContainer* rygel_item_creator_fetch_container_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error);
static void rygel_item_creator_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GeeArrayList* rygel_writable_container_get_create_classes (RygelWritableContainer* self);
static RygelMediaItem* rygel_item_creator_create_item (RygelItemCreator* self, const gchar* id, RygelWritableContainer* parent, const gchar* title, const gchar* upnp_class, GError** error);
static gboolean rygel_item_creator_is_profile_valid (RygelItemCreator* self, const gchar* profile);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static gboolean rygel_item_creator_is_valid_uri (RygelItemCreator* self, const gchar* uri);
void rygel_media_item_add_uri (RygelMediaItem* self, const gchar* uri);
void rygel_media_item_set_size (RygelMediaItem* self, gint64 value);
static gchar* rygel_item_creator_get_generic_mime_type (RygelItemCreator* self);
gint64 rygel_media_item_get_size (RygelMediaItem* self);
static void rygel_item_creator_create_uri (RygelItemCreator* self, RygelWritableContainer* container, const gchar* title, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gchar* rygel_item_creator_create_uri_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error);
const gchar* rygel_media_object_get_title (RygelMediaObject* self);
void rygel_media_item_set_place_holder (RygelMediaItem* self, gboolean value);
void rygel_writable_container_add_item (RygelWritableContainer* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_writable_container_add_item_finish (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static void rygel_item_creator_wait_for_item (RygelItemCreator* self, RygelWritableContainer* container, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_item_creator_wait_for_item_finish (RygelItemCreator* self, GAsyncResult* _res_);
GUPnPDIDLLiteObject* rygel_media_object_serialize (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
static void rygel_item_creator_conclude (RygelItemCreator* self);
gboolean rygel_media_item_get_place_holder (RygelMediaItem* self);
GType rygel_item_removal_queue_get_type (void) G_GNUC_CONST;
RygelItemRemovalQueue* rygel_item_removal_queue_get_default (void);
void rygel_item_removal_queue_queue (RygelItemRemovalQueue* self, RygelMediaItem* item, GCancellable* cancellable);
static void rygel_item_creator_handle_error (RygelItemCreator* self, GError* _error_);
static void rygel_item_creator_parse_args_data_free (gpointer _data);
static gboolean rygel_item_creator_parse_args_co (RygelItemCreatorParseArgsData* _data_);
static void rygel_item_creator_generalize_upnp_class (RygelItemCreator* self, gchar** upnp_class);
static void rygel_item_creator_fetch_container_data_free (gpointer _data);
static gboolean rygel_item_creator_fetch_container_co (RygelItemCreatorFetchContainerData* _data_);
RygelRelationalExpression* rygel_relational_expression_new (void);
RygelRelationalExpression* rygel_relational_expression_construct (GType object_type);
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
GType rygel_relational_expression_get_type (void) G_GNUC_CONST;
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
void rygel_searchable_container_search (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_searchable_container_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static void rygel_item_creator_fetch_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
GUPnPOCMFlags rygel_media_object_get_ocm_flags (RygelMediaObject* self);
GType rygel_image_item_get_type (void) G_GNUC_CONST;
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_video_item_get_type (void) G_GNUC_CONST;
#define RYGEL_IMAGE_ITEM_UPNP_CLASS "object.item.imageItem"
#define RYGEL_PHOTO_ITEM_UPNP_CLASS "object.item.imageItem.photo"
#define RYGEL_VIDEO_ITEM_UPNP_CLASS "object.item.videoItem"
#define RYGEL_AUDIO_ITEM_UPNP_CLASS "object.item.audioItem"
#define RYGEL_MUSIC_ITEM_UPNP_CLASS "object.item.audioItem.musicTrack"
RygelImageItem* rygel_image_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelImageItem* rygel_image_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelPhotoItem* rygel_photo_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelPhotoItem* rygel_photo_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_photo_item_get_type (void) G_GNUC_CONST;
RygelVideoItem* rygel_video_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelVideoItem* rygel_video_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelAudioItem* rygel_audio_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelAudioItem* rygel_audio_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMusicItem* rygel_music_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMusicItem* rygel_music_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_music_item_get_type (void) G_GNUC_CONST;
static void rygel_item_creator_create_uri_data_free (gpointer _data);
static gboolean rygel_item_creator_create_uri_co (RygelItemCreatorCreateUriData* _data_);
void rygel_media_object_get_writable (RygelMediaObject* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GFile* rygel_media_object_get_writable_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error);
static void rygel_item_creator_create_uri_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_item_creator_wait_for_item_data_free (gpointer _data);
static gboolean rygel_item_creator_wait_for_item_co (RygelItemCreatorWaitForItemData* _data_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (Block5Data* _data5_);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (Block6Data* _data6_);
static void ____lambda10_ (Block6Data* _data6_, RygelMediaContainer* container);
static void _____lambda10__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self);
static gboolean ____lambda11_ (Block6Data* _data6_);
static gboolean _____lambda11__gsource_func (gpointer self);
static void rygel_item_creator_wait_for_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_item_creator_finalize (GObject* obj);
static void _vala_rygel_item_creator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_item_creator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GQuark rygel_item_creator_error_quark (void) {
	return g_quark_from_static_string ("rygel_item_creator_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	return self ? g_object_ref (self) : NULL;
#line 896 "rygel-item-creator.c"
}


RygelItemCreator* rygel_item_creator_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
	RygelItemCreator * self = NULL;
	RygelContentDirectory* _tmp0_;
	RygelContentDirectory* _tmp1_;
	RygelContentDirectory* _tmp2_;
	GCancellable* _tmp3_;
	GUPnPServiceAction* _tmp4_;
	GUPnPDIDLLiteWriter* _tmp5_;
	GUPnPDIDLLiteParser* _tmp6_;
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_return_val_if_fail (content_dir != NULL, NULL);
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_return_val_if_fail (action != NULL, NULL);
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	self = (RygelItemCreator*) g_object_new (object_type, NULL);
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp0_ = content_dir;
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (self->priv->content_dir);
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	self->priv->content_dir = _tmp1_;
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp2_ = content_dir;
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp3_ = _tmp2_->cancellable;
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp3_);
#line 54 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp4_ = action;
#line 54 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	action = NULL;
#line 54 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	self->priv->action = _tmp4_;
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp5_ = gupnp_didl_lite_writer_new (NULL);
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (self->priv->didl_writer);
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	self->priv->didl_writer = _tmp5_;
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp6_ = gupnp_didl_lite_parser_new ();
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (self->priv->didl_parser);
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	self->priv->didl_parser = _tmp6_;
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	return self;
#line 949 "rygel-item-creator.c"
}


RygelItemCreator* rygel_item_creator_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	return rygel_item_creator_construct (RYGEL_TYPE_ITEM_CREATOR, content_dir, action);
#line 956 "rygel-item-creator.c"
}


static void rygel_item_creator_real_run_data_free (gpointer _data) {
	RygelItemCreatorRunData* _data_;
	_data_ = _data;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (_data_->self);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_slice_free (RygelItemCreatorRunData, _data_);
#line 967 "rygel-item-creator.c"
}


static void rygel_item_creator_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemCreator * self;
	RygelItemCreatorRunData* _data_;
	RygelItemCreator* _tmp0_;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	self = (RygelItemCreator*) base;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_ = g_slice_new0 (RygelItemCreatorRunData);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_creator_real_run);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_creator_real_run_data_free);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->self = _tmp0_;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	rygel_item_creator_real_run_co (_data_);
#line 989 "rygel-item-creator.c"
}


static void rygel_item_creator_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelItemCreatorRunData* _data_;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 997 "rygel-item-creator.c"
}


static void ___lambda9_ (RygelItemCreator* self, GUPnPDIDLLiteItem* didl_item) {
	GUPnPDIDLLiteItem* _tmp0_;
	GUPnPDIDLLiteItem* _tmp1_;
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_return_if_fail (didl_item != NULL);
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp0_ = didl_item;
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (self->didl_item);
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	self->didl_item = _tmp1_;
#line 1014 "rygel-item-creator.c"
}


static void ____lambda9__gupnp_didl_lite_parser_item_available (GUPnPDIDLLiteParser* _sender, GUPnPDIDLLiteItem* item, gpointer self) {
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	___lambda9_ (self, item);
#line 1021 "rygel-item-creator.c"
}


static void rygel_item_creator_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemCreatorRunData* _data_;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_ = _user_data_;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_source_object_ = source_object;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_res_ = _res_;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	rygel_item_creator_real_run_co (_data_);
#line 1035 "rygel-item-creator.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 1042 "rygel-item-creator.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_list_free (self);
#line 1051 "rygel-item-creator.c"
}


static gboolean rygel_item_creator_real_run_co (RygelItemCreatorRunData* _data_) {
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	switch (_data_->_state_) {
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		case 0:
#line 1060 "rygel-item-creator.c"
		goto _state_0;
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		case 1:
#line 1064 "rygel-item-creator.c"
		goto _state_1;
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		case 2:
#line 1068 "rygel-item-creator.c"
		goto _state_2;
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		case 3:
#line 1072 "rygel-item-creator.c"
		goto _state_3;
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		case 4:
#line 1076 "rygel-item-creator.c"
		goto _state_4;
		default:
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_assert_not_reached ();
#line 1081 "rygel-item-creator.c"
	}
	_state_0:
	{
#line 61 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		rygel_item_creator_parse_args (_data_->self, NULL, NULL);
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp0_ = _data_->self->priv->didl_parser;
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_signal_connect_object (_data_->_tmp0_, "item-available", (GCallback) ____lambda9__gupnp_didl_lite_parser_item_available, _data_->self, 0);
#line 1091 "rygel-item-creator.c"
		{
#line 68 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp1_ = _data_->self->priv->didl_parser;
#line 68 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp2_ = _data_->self->elements;
#line 68 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			gupnp_didl_lite_parser_parse_didl (_data_->_tmp1_, _data_->_tmp2_, &_data_->_inner_error_);
#line 68 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			if (_data_->_inner_error_ != NULL) {
#line 1101 "rygel-item-creator.c"
				goto __catch71_g_error;
			}
		}
		goto __finally71;
		__catch71_g_error:
		{
#line 67 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->parse_err = _data_->_inner_error_;
#line 67 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_inner_error_ = NULL;
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp3_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "Bad metadata");
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_inner_error_ = _data_->_tmp3_;
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_g_error_free0 (_data_->parse_err);
#line 1118 "rygel-item-creator.c"
			goto __finally71;
		}
		__finally71:
#line 67 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_inner_error_ != NULL) {
#line 1124 "rygel-item-creator.c"
			goto __catch70_g_error;
		}
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp4_ = _data_->self->didl_item;
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_tmp4_ == NULL) {
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp5_ = NULL;
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp5_ = _ ("No items in DIDL-Lite from client: '%s'");
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp6_ = g_strdup (_data_->_tmp5_);
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->message = _data_->_tmp6_;
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp7_ = _data_->message;
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp8_ = _data_->self->elements;
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp9_ = g_error_new (RYGEL_ITEM_CREATOR_ERROR, RYGEL_ITEM_CREATOR_ERROR_PARSE, _data_->_tmp7_, _data_->_tmp8_);
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_inner_error_ = _data_->_tmp9_;
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_g_free0 (_data_->message);
#line 1149 "rygel-item-creator.c"
			goto __catch70_g_error;
		}
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp11_ = _data_->self->didl_item;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp12_ = gupnp_didl_lite_object_get_id ((GUPnPDIDLLiteObject*) _data_->_tmp11_);
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp13_ = _data_->_tmp12_;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_tmp13_ == NULL) {
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp10_ = TRUE;
#line 1162 "rygel-item-creator.c"
		} else {
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp14_ = _data_->self->didl_item;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp15_ = gupnp_didl_lite_object_get_id ((GUPnPDIDLLiteObject*) _data_->_tmp14_);
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp16_ = _data_->_tmp15_;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp10_ = g_strcmp0 (_data_->_tmp16_, "") != 0;
#line 1172 "rygel-item-creator.c"
		}
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp17_ = _data_->_tmp10_;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_tmp17_) {
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp18_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "@id must be set to \"\" in " "CreateItem");
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_inner_error_ = _data_->_tmp18_;
#line 1182 "rygel-item-creator.c"
			goto __catch70_g_error;
		}
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp19_ = _data_->self->didl_item;
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp20_ = gupnp_didl_lite_object_get_title ((GUPnPDIDLLiteObject*) _data_->_tmp19_);
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp21_ = _data_->_tmp20_;
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_tmp21_ == NULL) {
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp22_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "dc:title must be set in " "CreateItem");
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_inner_error_ = _data_->_tmp22_;
#line 1197 "rygel-item-creator.c"
			goto __catch70_g_error;
		}
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp23_ = _data_->self->didl_item;
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp24_ = gupnp_didl_lite_object_get_dlna_managed ((GUPnPDIDLLiteObject*) _data_->_tmp23_);
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp25_ = _data_->_tmp24_;
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if ((_data_->_tmp25_ & ((GUPNP_OCM_FLAGS_UPLOAD | GUPNP_OCM_FLAGS_CREATE_CONTAINER) | GUPNP_OCM_FLAGS_UPLOAD_DESTROYABLE)) != 0) {
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp26_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "Flags that must not be set " "were found in 'dlnaManaged'");
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_inner_error_ = _data_->_tmp26_;
#line 1212 "rygel-item-creator.c"
			goto __catch70_g_error;
		}
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp29_ = _data_->self->didl_item;
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp30_ = gupnp_didl_lite_object_get_upnp_class ((GUPnPDIDLLiteObject*) _data_->_tmp29_);
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp31_ = _data_->_tmp30_;
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_tmp31_ == NULL) {
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp28_ = TRUE;
#line 1225 "rygel-item-creator.c"
		} else {
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp32_ = _data_->self->didl_item;
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp33_ = gupnp_didl_lite_object_get_upnp_class ((GUPnPDIDLLiteObject*) _data_->_tmp32_);
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp34_ = _data_->_tmp33_;
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp28_ = g_strcmp0 (_data_->_tmp34_, "") == 0;
#line 1235 "rygel-item-creator.c"
		}
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp35_ = _data_->_tmp28_;
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_tmp35_) {
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp27_ = TRUE;
#line 1243 "rygel-item-creator.c"
		} else {
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp36_ = _data_->self->didl_item;
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp37_ = gupnp_didl_lite_object_get_upnp_class ((GUPnPDIDLLiteObject*) _data_->_tmp36_);
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp38_ = _data_->_tmp37_;
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp39_ = FALSE;
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp39_ = g_str_has_prefix (_data_->_tmp38_, "object.item");
#line 102 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp27_ = !_data_->_tmp39_;
#line 1257 "rygel-item-creator.c"
		}
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp40_ = _data_->_tmp27_;
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_tmp40_) {
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp41_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "Invalid upnp:class given ");
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_inner_error_ = _data_->_tmp41_;
#line 1267 "rygel-item-creator.c"
			goto __catch70_g_error;
		}
#line 107 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp42_ = _data_->self->didl_item;
#line 107 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp43_ = gupnp_didl_lite_object_get_restricted ((GUPnPDIDLLiteObject*) _data_->_tmp42_);
#line 107 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp44_ = _data_->_tmp43_;
#line 107 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_tmp44_) {
#line 108 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp45_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, "Cannot create restricted item");
#line 108 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_inner_error_ = _data_->_tmp45_;
#line 1282 "rygel-item-creator.c"
			goto __catch70_g_error;
		}
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_state_ = 1;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		rygel_item_creator_fetch_container (_data_->self, rygel_item_creator_run_ready, _data_);
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		return FALSE;
#line 1291 "rygel-item-creator.c"
		_state_1:
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp46_ = NULL;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp46_ = rygel_item_creator_fetch_container_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->container = _data_->_tmp46_;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_inner_error_ != NULL) {
#line 1301 "rygel-item-creator.c"
			goto __catch70_g_error;
		}
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp48_ = _data_->container;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp49_ = rygel_writable_container_get_create_classes (_data_->_tmp48_);
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp50_ = _data_->_tmp49_;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp51_ = _data_->self->didl_item;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp52_ = gupnp_didl_lite_object_get_upnp_class ((GUPnPDIDLLiteObject*) _data_->_tmp51_);
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp53_ = _data_->_tmp52_;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp54_ = FALSE;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp54_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _data_->_tmp50_, _data_->_tmp53_);
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (!_data_->_tmp54_) {
#line 122 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp55_ = _data_->self->container_id;
#line 122 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp47_ = g_strcmp0 (_data_->_tmp55_, "DLNA_ORG.AnyContainer") != 0;
#line 1326 "rygel-item-creator.c"
		} else {
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp47_ = FALSE;
#line 1330 "rygel-item-creator.c"
		}
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp56_ = _data_->_tmp47_;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_tmp56_) {
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp57_ = _data_->self->didl_item;
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp58_ = gupnp_didl_lite_object_get_upnp_class ((GUPnPDIDLLiteObject*) _data_->_tmp57_);
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp59_ = _data_->_tmp58_;
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp60_ = _data_->container;
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp61_ = ((RygelMediaObject*) _data_->_tmp60_)->id;
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp62_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "Creating of objects with class %s " "is not supported in %s", _data_->_tmp59_, _data_->_tmp61_);
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_inner_error_ = _data_->_tmp62_;
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_g_object_unref0 (_data_->container);
#line 1352 "rygel-item-creator.c"
			goto __catch70_g_error;
		}
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp63_ = _data_->self->didl_item;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp64_ = gupnp_didl_lite_object_get_id ((GUPnPDIDLLiteObject*) _data_->_tmp63_);
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp65_ = _data_->_tmp64_;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp66_ = _data_->container;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp67_ = _data_->self->didl_item;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp68_ = gupnp_didl_lite_object_get_title ((GUPnPDIDLLiteObject*) _data_->_tmp67_);
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp69_ = _data_->_tmp68_;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp70_ = _data_->self->didl_item;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp71_ = gupnp_didl_lite_object_get_upnp_class ((GUPnPDIDLLiteObject*) _data_->_tmp70_);
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp72_ = _data_->_tmp71_;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp73_ = NULL;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp73_ = rygel_item_creator_create_item (_data_->self, _data_->_tmp65_, _data_->_tmp66_, _data_->_tmp69_, _data_->_tmp72_, &_data_->_inner_error_);
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp74_ = _data_->_tmp73_;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_inner_error_ != NULL) {
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_g_object_unref0 (_data_->container);
#line 1385 "rygel-item-creator.c"
			goto __catch70_g_error;
		}
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_g_object_unref0 (_data_->self->item);
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->self->item = _data_->_tmp74_;
#line 135 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp75_ = _data_->self->didl_item;
#line 135 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp76_ = NULL;
#line 135 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp76_ = gupnp_didl_lite_object_get_resources ((GUPnPDIDLLiteObject*) _data_->_tmp75_);
#line 135 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->resources = _data_->_tmp76_;
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp78_ = _data_->resources;
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_tmp78_ != NULL) {
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp79_ = _data_->resources;
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp80_ = 0U;
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp80_ = g_list_length (_data_->_tmp79_);
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp77_ = _data_->_tmp80_ > ((guint) 0);
#line 1412 "rygel-item-creator.c"
		} else {
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp77_ = FALSE;
#line 1416 "rygel-item-creator.c"
		}
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp81_ = _data_->_tmp77_;
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_tmp81_) {
#line 137 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp82_ = _data_->resources;
#line 137 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp83_ = NULL;
#line 137 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp83_ = g_list_nth (_data_->_tmp82_, (guint) 0);
#line 137 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp84_ = _data_->_tmp83_->data;
#line 137 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp85_ = _g_object_ref0 ((GUPnPDIDLLiteResource*) _data_->_tmp84_);
#line 137 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->resource = _data_->_tmp85_;
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp86_ = _data_->resource;
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp87_ = gupnp_didl_lite_resource_get_protocol_info (_data_->_tmp86_);
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp88_ = _data_->_tmp87_;
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp89_ = _g_object_ref0 (_data_->_tmp88_);
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->info = _data_->_tmp89_;
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp90_ = _data_->info;
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			if (_data_->_tmp90_ != NULL) {
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp91_ = _data_->info;
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp92_ = gupnp_protocol_info_get_dlna_profile (_data_->_tmp91_);
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp93_ = _data_->_tmp92_;
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				if (_data_->_tmp93_ != NULL) {
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->_tmp94_ = _data_->info;
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->_tmp95_ = gupnp_protocol_info_get_dlna_profile (_data_->_tmp94_);
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->_tmp96_ = _data_->_tmp95_;
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->_tmp97_ = FALSE;
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->_tmp97_ = rygel_item_creator_is_profile_valid (_data_->self, _data_->_tmp96_);
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					if (!_data_->_tmp97_) {
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
						_data_->_tmp98_ = _data_->info;
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
						_data_->_tmp99_ = gupnp_protocol_info_get_dlna_profile (_data_->_tmp98_);
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
						_data_->_tmp100_ = _data_->_tmp99_;
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
						_data_->_tmp101_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "'%s' DLNA profile unsupported", _data_->_tmp100_);
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
						_data_->_inner_error_ = _data_->_tmp101_;
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
						_g_object_unref0 (_data_->info);
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
						_g_object_unref0 (_data_->resource);
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
						__g_list_free__g_object_unref0_0 (_data_->resources);
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
						_g_object_unref0 (_data_->container);
#line 1486 "rygel-item-creator.c"
						goto __catch70_g_error;
					}
#line 148 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->_tmp102_ = _data_->self->item;
#line 148 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->_tmp103_ = _data_->info;
#line 148 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->_tmp104_ = gupnp_protocol_info_get_dlna_profile (_data_->_tmp103_);
#line 148 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->_tmp105_ = _data_->_tmp104_;
#line 148 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->_tmp106_ = g_strdup (_data_->_tmp105_);
#line 148 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_g_free0 (_data_->_tmp102_->dlna_profile);
#line 148 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->_tmp102_->dlna_profile = _data_->_tmp106_;
#line 1503 "rygel-item-creator.c"
				}
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp107_ = _data_->info;
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp108_ = gupnp_protocol_info_get_mime_type (_data_->_tmp107_);
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp109_ = _data_->_tmp108_;
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				if (_data_->_tmp109_ != NULL) {
#line 152 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->_tmp110_ = _data_->self->item;
#line 152 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->_tmp111_ = _data_->info;
#line 152 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->_tmp112_ = gupnp_protocol_info_get_mime_type (_data_->_tmp111_);
#line 152 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->_tmp113_ = _data_->_tmp112_;
#line 152 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->_tmp114_ = g_strdup (_data_->_tmp113_);
#line 152 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_g_free0 (_data_->_tmp110_->mime_type);
#line 152 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->_tmp110_->mime_type = _data_->_tmp114_;
#line 1527 "rygel-item-creator.c"
				}
			}
#line 156 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp115_ = _data_->resource;
#line 156 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp116_ = gupnp_didl_lite_resource_get_uri (_data_->_tmp115_);
#line 156 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp117_ = _data_->_tmp116_;
#line 156 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp118_ = FALSE;
#line 156 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp118_ = rygel_item_creator_is_valid_uri (_data_->self, _data_->_tmp117_);
#line 156 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			if (_data_->_tmp118_) {
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp119_ = _data_->self->item;
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp120_ = _data_->resource;
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp121_ = gupnp_didl_lite_resource_get_uri (_data_->_tmp120_);
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp122_ = _data_->_tmp121_;
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				rygel_media_item_add_uri (_data_->_tmp119_, _data_->_tmp122_);
#line 1552 "rygel-item-creator.c"
			}
#line 160 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp123_ = _data_->resource;
#line 160 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp124_ = gupnp_didl_lite_resource_get_size (_data_->_tmp123_);
#line 160 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp125_ = _data_->_tmp124_;
#line 160 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			if (_data_->_tmp125_ >= ((glong) 0)) {
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp126_ = _data_->self->item;
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp127_ = _data_->resource;
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp128_ = gupnp_didl_lite_resource_get_size (_data_->_tmp127_);
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp129_ = _data_->_tmp128_;
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				rygel_media_item_set_size (_data_->_tmp126_, (gint64) _data_->_tmp129_);
#line 1572 "rygel-item-creator.c"
			}
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_g_object_unref0 (_data_->info);
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_g_object_unref0 (_data_->resource);
#line 1578 "rygel-item-creator.c"
		}
#line 165 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp130_ = _data_->self->item;
#line 165 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp131_ = _data_->_tmp130_->mime_type;
#line 165 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_tmp131_ == NULL) {
#line 166 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp132_ = _data_->self->item;
#line 166 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp133_ = NULL;
#line 166 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp133_ = rygel_item_creator_get_generic_mime_type (_data_->self);
#line 166 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_g_free0 (_data_->_tmp132_->mime_type);
#line 166 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp132_->mime_type = _data_->_tmp133_;
#line 1596 "rygel-item-creator.c"
		}
#line 169 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp134_ = _data_->self->item;
#line 169 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp135_ = rygel_media_item_get_size (_data_->_tmp134_);
#line 169 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp136_ = _data_->_tmp135_;
#line 169 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_tmp136_ < ((gint64) 0)) {
#line 170 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp137_ = _data_->self->item;
#line 170 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			rygel_media_item_set_size (_data_->_tmp137_, (gint64) 0);
#line 1610 "rygel-item-creator.c"
		}
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp138_ = _data_->self->item;
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp139_ = ((RygelMediaObject*) _data_->_tmp138_)->uris;
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp140_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp139_);
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp141_ = _data_->_tmp140_;
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_tmp141_ == 0) {
#line 174 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp142_ = _data_->container;
#line 174 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp143_ = _data_->self->item;
#line 174 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp144_ = rygel_media_object_get_title ((RygelMediaObject*) _data_->_tmp143_);
#line 174 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp145_ = _data_->_tmp144_;
#line 174 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_state_ = 2;
#line 174 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			rygel_item_creator_create_uri (_data_->self, _data_->_tmp142_, _data_->_tmp145_, rygel_item_creator_run_ready, _data_);
#line 174 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			return FALSE;
#line 1636 "rygel-item-creator.c"
			_state_2:
#line 174 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp146_ = NULL;
#line 174 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp146_ = rygel_item_creator_create_uri_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 174 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->uri = _data_->_tmp146_;
#line 174 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			if (_data_->_inner_error_ != NULL) {
#line 174 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				__g_list_free__g_object_unref0_0 (_data_->resources);
#line 174 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_g_object_unref0 (_data_->container);
#line 1650 "rygel-item-creator.c"
				goto __catch70_g_error;
			}
#line 175 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp147_ = _data_->self->item;
#line 175 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp148_ = ((RygelMediaObject*) _data_->_tmp147_)->uris;
#line 175 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp149_ = _data_->uri;
#line 175 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp148_, _data_->_tmp149_);
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp150_ = _data_->self->item;
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			rygel_media_item_set_place_holder (_data_->_tmp150_, TRUE);
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_g_free0 (_data_->uri);
#line 1667 "rygel-item-creator.c"
		} else {
#line 178 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp151_ = _data_->self->item;
#line 178 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp152_ = ((RygelMediaObject*) _data_->_tmp151_)->uris;
#line 178 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp153_ = NULL;
#line 178 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp153_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp152_, 0);
#line 178 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp154_ = (gchar*) _data_->_tmp153_;
#line 178 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp155_ = NULL;
#line 178 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp155_ = g_file_new_for_uri (_data_->_tmp154_);
#line 178 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp156_ = _data_->_tmp155_;
#line 178 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_g_free0 (_data_->_tmp154_);
#line 178 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->file = _data_->_tmp156_;
#line 179 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp157_ = _data_->self->item;
#line 179 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp158_ = _data_->file;
#line 179 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp159_ = FALSE;
#line 179 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp159_ = g_file_is_native (_data_->_tmp158_);
#line 179 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			rygel_media_item_set_place_holder (_data_->_tmp157_, !_data_->_tmp159_);
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_g_object_unref0 (_data_->file);
#line 1701 "rygel-item-creator.c"
		}
#line 182 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp160_ = _data_->self->item;
#line 182 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp161_ = _data_->self->item;
#line 182 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp162_ = ((RygelMediaObject*) _data_->_tmp161_)->uris;
#line 182 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp163_ = NULL;
#line 182 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp163_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp162_, 0);
#line 182 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_g_free0 (((RygelMediaObject*) _data_->_tmp160_)->id);
#line 182 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		((RygelMediaObject*) _data_->_tmp160_)->id = (gchar*) _data_->_tmp163_;
#line 184 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp164_ = _data_->container;
#line 184 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp165_ = _data_->self->item;
#line 184 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp166_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 184 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp167_ = _data_->_tmp166_;
#line 184 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_state_ = 3;
#line 184 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		rygel_writable_container_add_item (_data_->_tmp164_, _data_->_tmp165_, _data_->_tmp167_, rygel_item_creator_run_ready, _data_);
#line 184 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		return FALSE;
#line 1731 "rygel-item-creator.c"
		_state_3:
#line 184 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		rygel_writable_container_add_item_finish (_data_->_tmp164_, _data_->_res_, &_data_->_inner_error_);
#line 184 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_inner_error_ != NULL) {
#line 184 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			__g_list_free__g_object_unref0_0 (_data_->resources);
#line 184 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_g_object_unref0 (_data_->container);
#line 1741 "rygel-item-creator.c"
			goto __catch70_g_error;
		}
#line 186 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp168_ = _data_->container;
#line 186 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_state_ = 4;
#line 186 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		rygel_item_creator_wait_for_item (_data_->self, _data_->_tmp168_, rygel_item_creator_run_ready, _data_);
#line 186 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		return FALSE;
#line 1752 "rygel-item-creator.c"
		_state_4:
#line 186 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		rygel_item_creator_wait_for_item_finish (_data_->self, _data_->_res_);
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp169_ = _data_->self->item;
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp170_ = _data_->self->priv->didl_writer;
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp171_ = _data_->self->priv->content_dir;
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp172_ = _data_->_tmp171_->http_server;
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp173_ = NULL;
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp173_ = rygel_media_object_serialize ((RygelMediaObject*) _data_->_tmp169_, _data_->_tmp170_, _data_->_tmp172_, &_data_->_inner_error_);
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp174_ = _data_->_tmp173_;
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_g_object_unref0 (_data_->_tmp174_);
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_inner_error_ != NULL) {
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			__g_list_free__g_object_unref0_0 (_data_->resources);
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_g_object_unref0 (_data_->container);
#line 1778 "rygel-item-creator.c"
			goto __catch70_g_error;
		}
#line 191 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		rygel_item_creator_conclude (_data_->self);
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp176_ = _data_->self->container_id;
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (g_strcmp0 (_data_->_tmp176_, "DLNA.ORG_AnyContainer") == 0) {
#line 194 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp177_ = _data_->self->item;
#line 194 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp178_ = rygel_media_item_get_place_holder (_data_->_tmp177_);
#line 194 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp179_ = _data_->_tmp178_;
#line 194 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp175_ = _data_->_tmp179_;
#line 1795 "rygel-item-creator.c"
		} else {
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp175_ = FALSE;
#line 1799 "rygel-item-creator.c"
		}
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp180_ = _data_->_tmp175_;
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_tmp180_) {
#line 195 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp181_ = NULL;
#line 195 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp181_ = rygel_item_removal_queue_get_default ();
#line 195 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->queue = _data_->_tmp181_;
#line 197 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp182_ = _data_->queue;
#line 197 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp183_ = _data_->self->item;
#line 197 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp184_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 197 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp185_ = _data_->_tmp184_;
#line 197 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			rygel_item_removal_queue_queue (_data_->_tmp182_, _data_->_tmp183_, _data_->_tmp185_);
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_g_object_unref0 (_data_->queue);
#line 1823 "rygel-item-creator.c"
		}
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		__g_list_free__g_object_unref0_0 (_data_->resources);
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_g_object_unref0 (_data_->container);
#line 1829 "rygel-item-creator.c"
	}
	goto __finally70;
	__catch70_g_error:
	{
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->err = _data_->_inner_error_;
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_inner_error_ = NULL;
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp186_ = _data_->err;
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		rygel_item_creator_handle_error (_data_->self, _data_->_tmp186_);
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_g_error_free0 (_data_->err);
#line 1844 "rygel-item-creator.c"
	}
	__finally70:
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (_data_->_inner_error_ != NULL) {
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_clear_error (&_data_->_inner_error_);
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		return FALSE;
#line 1855 "rygel-item-creator.c"
	}
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (_data_->_state_ == 0) {
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1861 "rygel-item-creator.c"
	} else {
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1865 "rygel-item-creator.c"
	}
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_object_unref (_data_->_async_result);
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	return FALSE;
#line 1871 "rygel-item-creator.c"
}


static void rygel_item_creator_parse_args_data_free (gpointer _data) {
	RygelItemCreatorParseArgsData* _data_;
	_data_ = _data;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (_data_->self);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_slice_free (RygelItemCreatorParseArgsData, _data_);
#line 1882 "rygel-item-creator.c"
}


static void rygel_item_creator_parse_args (RygelItemCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemCreatorParseArgsData* _data_;
	RygelItemCreator* _tmp0_;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_ = g_slice_new0 (RygelItemCreatorParseArgsData);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_creator_parse_args);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_creator_parse_args_data_free);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->self = _tmp0_;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	rygel_item_creator_parse_args_co (_data_);
#line 1901 "rygel-item-creator.c"
}


static void rygel_item_creator_parse_args_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error) {
	RygelItemCreatorParseArgsData* _data_;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		return;
#line 1911 "rygel-item-creator.c"
	}
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1915 "rygel-item-creator.c"
}


static gboolean rygel_item_creator_parse_args_co (RygelItemCreatorParseArgsData* _data_) {
#line 204 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	switch (_data_->_state_) {
#line 204 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		case 0:
#line 1924 "rygel-item-creator.c"
		goto _state_0;
		default:
#line 204 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_assert_not_reached ();
#line 1929 "rygel-item-creator.c"
	}
	_state_0:
#line 206 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp0_ = _data_->self->priv->action;
#line 206 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	gupnp_service_action_get (_data_->_tmp0_, "ContainerID", G_TYPE_STRING, &_data_->self->container_id, "Elements", G_TYPE_STRING, &_data_->self->elements, NULL);
#line 209 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp1_ = _data_->self->elements;
#line 209 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (_data_->_tmp1_ == NULL) {
#line 210 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp2_ = NULL;
#line 210 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp2_ = _ ("'Elements' argument missing.");
#line 210 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp3_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _data_->_tmp2_);
#line 210 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_inner_error_ = _data_->_tmp3_;
#line 210 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 210 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_error_free (_data_->_inner_error_);
#line 210 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_state_ == 0) {
#line 210 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1956 "rygel-item-creator.c"
		} else {
#line 210 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1960 "rygel-item-creator.c"
		}
#line 210 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_object_unref (_data_->_async_result);
#line 210 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		return FALSE;
#line 1966 "rygel-item-creator.c"
	} else {
#line 212 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp4_ = rygel_item_creator_comment_pattern;
#line 212 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp5_ = _data_->self->elements;
#line 212 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp6_ = FALSE;
#line 212 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp6_ = g_pattern_match_string (_data_->_tmp4_, _data_->_tmp5_);
#line 212 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_tmp6_) {
#line 213 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp7_ = NULL;
#line 213 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp7_ = _ ("Comments not allowed in XML");
#line 213 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp8_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _data_->_tmp7_);
#line 213 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_inner_error_ = _data_->_tmp8_;
#line 213 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 213 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_error_free (_data_->_inner_error_);
#line 213 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			if (_data_->_state_ == 0) {
#line 213 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1994 "rygel-item-creator.c"
			} else {
#line 213 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1998 "rygel-item-creator.c"
			}
#line 213 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_object_unref (_data_->_async_result);
#line 213 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			return FALSE;
#line 2004 "rygel-item-creator.c"
		}
	}
#line 217 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp9_ = _data_->self->container_id;
#line 217 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (_data_->_tmp9_ == NULL) {
#line 219 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp10_ = NULL;
#line 219 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp10_ = _ ("No such object");
#line 219 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp11_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, _data_->_tmp10_);
#line 219 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_inner_error_ = _data_->_tmp11_;
#line 219 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 219 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_error_free (_data_->_inner_error_);
#line 219 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_state_ == 0) {
#line 219 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2027 "rygel-item-creator.c"
		} else {
#line 219 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2031 "rygel-item-creator.c"
		}
#line 219 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_object_unref (_data_->_async_result);
#line 219 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		return FALSE;
#line 2037 "rygel-item-creator.c"
	}
#line 204 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (_data_->_state_ == 0) {
#line 204 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2043 "rygel-item-creator.c"
	} else {
#line 204 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2047 "rygel-item-creator.c"
	}
#line 204 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_object_unref (_data_->_async_result);
#line 204 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	return FALSE;
#line 2053 "rygel-item-creator.c"
}


static void rygel_item_creator_generalize_upnp_class (RygelItemCreator* self, gchar** upnp_class) {
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* needle;
	gchar* _tmp2_;
#line 224 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_return_if_fail (self != NULL);
#line 224 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_return_if_fail (upnp_class != NULL);
#line 225 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp0_ = *upnp_class;
#line 225 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp1_ = g_strrstr_len (_tmp0_, (gssize) (-1), ".");
#line 225 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	needle = _tmp1_;
#line 226 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp2_ = needle;
#line 226 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (_tmp2_ != NULL) {
#line 2076 "rygel-item-creator.c"
		gchar* _tmp3_;
		gchar _tmp4_;
#line 227 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_tmp3_ = needle;
#line 227 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		*_tmp3_ = '\0';
#line 227 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_tmp4_ = *_tmp3_;
#line 2085 "rygel-item-creator.c"
	}
}


static void rygel_item_creator_fetch_container_data_free (gpointer _data) {
	RygelItemCreatorFetchContainerData* _data_;
	_data_ = _data;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (_data_->result);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (_data_->self);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_slice_free (RygelItemCreatorFetchContainerData, _data_);
#line 2099 "rygel-item-creator.c"
}


static void rygel_item_creator_fetch_container (RygelItemCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemCreatorFetchContainerData* _data_;
	RygelItemCreator* _tmp0_;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_ = g_slice_new0 (RygelItemCreatorFetchContainerData);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_creator_fetch_container);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_creator_fetch_container_data_free);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->self = _tmp0_;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	rygel_item_creator_fetch_container_co (_data_);
#line 2118 "rygel-item-creator.c"
}


static RygelWritableContainer* rygel_item_creator_fetch_container_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error) {
	RygelWritableContainer* result;
	RygelItemCreatorFetchContainerData* _data_;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		return NULL;
#line 2129 "rygel-item-creator.c"
	}
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	result = _data_->result;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->result = NULL;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	return result;
#line 2139 "rygel-item-creator.c"
}


static void rygel_item_creator_fetch_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemCreatorFetchContainerData* _data_;
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_ = _user_data_;
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_source_object_ = source_object;
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_res_ = _res_;
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	rygel_item_creator_fetch_container_co (_data_);
#line 2153 "rygel-item-creator.c"
}


static gboolean rygel_item_creator_fetch_container_co (RygelItemCreatorFetchContainerData* _data_) {
#line 231 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	switch (_data_->_state_) {
#line 231 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		case 0:
#line 2162 "rygel-item-creator.c"
		goto _state_0;
#line 231 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		case 1:
#line 2166 "rygel-item-creator.c"
		goto _state_1;
#line 231 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		case 2:
#line 2170 "rygel-item-creator.c"
		goto _state_2;
		default:
#line 231 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_assert_not_reached ();
#line 2175 "rygel-item-creator.c"
	}
	_state_0:
#line 232 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->media_object = NULL;
#line 234 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp0_ = _data_->self->container_id;
#line 234 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (g_strcmp0 (_data_->_tmp0_, "DLNA.ORG_AnyContainer") == 0) {
#line 235 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp1_ = _data_->self->didl_item;
#line 235 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp2_ = gupnp_didl_lite_object_get_upnp_class ((GUPnPDIDLLiteObject*) _data_->_tmp1_);
#line 235 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp3_ = _data_->_tmp2_;
#line 235 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp4_ = g_strdup (_data_->_tmp3_);
#line 235 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->upnp_class = _data_->_tmp4_;
#line 237 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		while (TRUE) {
#line 237 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp5_ = _data_->upnp_class;
#line 237 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			if (!(g_strcmp0 (_data_->_tmp5_, "object.item") != 0)) {
#line 237 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				break;
#line 2202 "rygel-item-creator.c"
			}
#line 238 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp6_ = rygel_relational_expression_new ();
#line 238 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->expression = _data_->_tmp6_;
#line 239 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp7_ = _data_->expression;
#line 239 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			((RygelSearchExpression*) _data_->_tmp7_)->op = GINT_TO_POINTER (GUPNP_SEARCH_CRITERIA_OP_DERIVED_FROM);
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp8_ = _data_->expression;
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp9_ = g_strdup ("upnp:createClass");
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_g_free0 (((RygelSearchExpression*) _data_->_tmp8_)->operand1);
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			((RygelSearchExpression*) _data_->_tmp8_)->operand1 = _data_->_tmp9_;
#line 241 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp10_ = _data_->expression;
#line 241 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp11_ = _data_->upnp_class;
#line 241 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp12_ = g_strdup (_data_->_tmp11_);
#line 241 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_g_free0 (((RygelSearchExpression*) _data_->_tmp10_)->operand2);
#line 241 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			((RygelSearchExpression*) _data_->_tmp10_)->operand2 = _data_->_tmp12_;
#line 245 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp13_ = _data_->self->priv->content_dir;
#line 245 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp14_ = _data_->_tmp13_->root_container;
#line 245 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp15_ = _g_object_ref0 (RYGEL_IS_SEARCHABLE_CONTAINER (_data_->_tmp14_) ? ((RygelSearchableContainer*) _data_->_tmp14_) : NULL);
#line 245 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->container = _data_->_tmp15_;
#line 248 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp16_ = _data_->container;
#line 248 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			if (_data_->_tmp16_ != NULL) {
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp17_ = _data_->container;
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp18_ = _data_->expression;
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp19_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp20_ = _data_->_tmp19_;
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp21_ = 0U;
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_state_ = 1;
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				rygel_searchable_container_search (_data_->_tmp17_, (RygelSearchExpression*) _data_->_tmp18_, (guint) 0, (guint) 1, _data_->_tmp20_, rygel_item_creator_fetch_container_ready, _data_);
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				return FALSE;
#line 2258 "rygel-item-creator.c"
				_state_1:
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp22_ = NULL;
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp22_ = rygel_searchable_container_search_finish (_data_->_tmp17_, _data_->_res_, &_data_->_tmp21_, &_data_->_inner_error_);
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->total_matches = _data_->_tmp21_;
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_result_ = _data_->_tmp22_;
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				if (_data_->_inner_error_ != NULL) {
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					g_error_free (_data_->_inner_error_);
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_g_object_unref0 (_data_->container);
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_rygel_search_expression_unref0 (_data_->expression);
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_g_free0 (_data_->upnp_class);
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_g_object_unref0 (_data_->media_object);
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					if (_data_->_state_ == 0) {
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
						g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2286 "rygel-item-creator.c"
					} else {
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
						g_simple_async_result_complete (_data_->_async_result);
#line 2290 "rygel-item-creator.c"
					}
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					g_object_unref (_data_->_async_result);
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					return FALSE;
#line 2296 "rygel-item-creator.c"
				}
#line 254 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp23_ = _data_->_result_;
#line 254 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp24_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp23_);
#line 254 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp25_ = _data_->_tmp24_;
#line 254 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				if (_data_->_tmp25_ > 0) {
#line 255 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->_tmp26_ = _data_->_result_;
#line 255 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->_tmp27_ = NULL;
#line 255 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->_tmp27_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp26_, 0);
#line 255 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_g_object_unref0 (_data_->media_object);
#line 255 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->media_object = (RygelMediaObject*) _data_->_tmp27_;
#line 256 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->_tmp28_ = _data_->self->didl_item;
#line 256 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_data_->_tmp29_ = _data_->upnp_class;
#line 256 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					gupnp_didl_lite_object_set_upnp_class ((GUPnPDIDLLiteObject*) _data_->_tmp28_, _data_->_tmp29_);
#line 257 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_g_object_unref0 (_data_->_result_);
#line 257 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_g_object_unref0 (_data_->container);
#line 257 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_rygel_search_expression_unref0 (_data_->expression);
#line 257 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					break;
#line 2330 "rygel-item-creator.c"
				} else {
#line 259 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					rygel_item_creator_generalize_upnp_class (_data_->self, &_data_->upnp_class);
#line 2334 "rygel-item-creator.c"
				}
#line 248 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_g_object_unref0 (_data_->_result_);
#line 2338 "rygel-item-creator.c"
			} else {
#line 262 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_g_object_unref0 (_data_->container);
#line 262 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_rygel_search_expression_unref0 (_data_->expression);
#line 262 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				break;
#line 2346 "rygel-item-creator.c"
			}
#line 237 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_g_object_unref0 (_data_->container);
#line 237 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_rygel_search_expression_unref0 (_data_->expression);
#line 2352 "rygel-item-creator.c"
		}
#line 266 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp30_ = _data_->upnp_class;
#line 266 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (g_strcmp0 (_data_->_tmp30_, "object.item") == 0) {
#line 267 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp31_ = _data_->self->didl_item;
#line 267 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp32_ = gupnp_didl_lite_object_get_upnp_class ((GUPnPDIDLLiteObject*) _data_->_tmp31_);
#line 267 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp33_ = _data_->_tmp32_;
#line 267 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp34_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "'%s' UPnP class unsupported", _data_->_tmp33_);
#line 267 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_inner_error_ = _data_->_tmp34_;
#line 267 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 267 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_error_free (_data_->_inner_error_);
#line 267 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_g_free0 (_data_->upnp_class);
#line 267 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_g_object_unref0 (_data_->media_object);
#line 267 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			if (_data_->_state_ == 0) {
#line 267 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2380 "rygel-item-creator.c"
			} else {
#line 267 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 2384 "rygel-item-creator.c"
			}
#line 267 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_object_unref (_data_->_async_result);
#line 267 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			return FALSE;
#line 2390 "rygel-item-creator.c"
		}
#line 234 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_g_free0 (_data_->upnp_class);
#line 2394 "rygel-item-creator.c"
	} else {
#line 272 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp35_ = _data_->self->priv->content_dir;
#line 272 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp36_ = _data_->_tmp35_->root_container;
#line 272 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp37_ = _data_->self->container_id;
#line 272 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp38_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 272 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp39_ = _data_->_tmp38_;
#line 272 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_state_ = 2;
#line 272 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		rygel_media_container_find_object (_data_->_tmp36_, _data_->_tmp37_, _data_->_tmp39_, rygel_item_creator_fetch_container_ready, _data_);
#line 272 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		return FALSE;
#line 2412 "rygel-item-creator.c"
		_state_2:
#line 272 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp40_ = NULL;
#line 272 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp40_ = rygel_media_container_find_object_finish (_data_->_tmp36_, _data_->_res_, &_data_->_inner_error_);
#line 272 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp41_ = _data_->_tmp40_;
#line 272 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_inner_error_ != NULL) {
#line 272 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 272 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_error_free (_data_->_inner_error_);
#line 272 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_g_object_unref0 (_data_->media_object);
#line 272 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			if (_data_->_state_ == 0) {
#line 272 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2432 "rygel-item-creator.c"
			} else {
#line 272 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 2436 "rygel-item-creator.c"
			}
#line 272 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_object_unref (_data_->_async_result);
#line 272 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			return FALSE;
#line 2442 "rygel-item-creator.c"
		}
#line 272 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_g_object_unref0 (_data_->media_object);
#line 272 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->media_object = _data_->_tmp41_;
#line 2448 "rygel-item-creator.c"
	}
#line 276 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp42_ = _data_->media_object;
#line 276 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (_data_->_tmp42_ == NULL) {
#line 277 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp43_ = NULL;
#line 277 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp43_ = _ ("No such object");
#line 277 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp44_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, _data_->_tmp43_);
#line 277 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_inner_error_ = _data_->_tmp44_;
#line 277 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 277 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_error_free (_data_->_inner_error_);
#line 277 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_g_object_unref0 (_data_->media_object);
#line 277 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_state_ == 0) {
#line 277 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2472 "rygel-item-creator.c"
		} else {
#line 277 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2476 "rygel-item-creator.c"
		}
#line 277 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_object_unref (_data_->_async_result);
#line 277 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		return FALSE;
#line 2482 "rygel-item-creator.c"
	} else {
#line 279 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp46_ = _data_->media_object;
#line 279 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (!RYGEL_IS_MEDIA_CONTAINER (_data_->_tmp46_)) {
#line 279 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp45_ = TRUE;
#line 2490 "rygel-item-creator.c"
		} else {
#line 280 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp47_ = _data_->media_object;
#line 280 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp48_ = rygel_media_object_get_ocm_flags (_data_->_tmp47_);
#line 280 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp49_ = _data_->_tmp48_;
#line 280 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp45_ = !((_data_->_tmp49_ & GUPNP_OCM_FLAGS_UPLOAD) == GUPNP_OCM_FLAGS_UPLOAD);
#line 2500 "rygel-item-creator.c"
		}
#line 279 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp50_ = _data_->_tmp45_;
#line 279 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_tmp50_) {
#line 281 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp51_ = NULL;
#line 281 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp51_ = _ ("Object creation in %s not allowed");
#line 281 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp52_ = _data_->media_object;
#line 281 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp53_ = _data_->_tmp52_->id;
#line 281 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp54_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT, _data_->_tmp51_, _data_->_tmp53_);
#line 281 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_inner_error_ = _data_->_tmp54_;
#line 281 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 281 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_error_free (_data_->_inner_error_);
#line 281 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_g_object_unref0 (_data_->media_object);
#line 281 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			if (_data_->_state_ == 0) {
#line 281 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2528 "rygel-item-creator.c"
			} else {
#line 281 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 2532 "rygel-item-creator.c"
			}
#line 281 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_object_unref (_data_->_async_result);
#line 281 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			return FALSE;
#line 2538 "rygel-item-creator.c"
		}
	}
#line 286 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp55_ = _data_->media_object;
#line 286 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp56_ = _g_object_ref0 (RYGEL_IS_WRITABLE_CONTAINER (_data_->_tmp55_) ? ((RygelWritableContainer*) _data_->_tmp55_) : NULL);
#line 286 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->result = _data_->_tmp56_;
#line 286 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (_data_->media_object);
#line 286 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (_data_->_state_ == 0) {
#line 286 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2553 "rygel-item-creator.c"
	} else {
#line 286 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2557 "rygel-item-creator.c"
	}
#line 286 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_object_unref (_data_->_async_result);
#line 286 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	return FALSE;
#line 231 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (_data_->media_object);
#line 231 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (_data_->_state_ == 0) {
#line 231 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2569 "rygel-item-creator.c"
	} else {
#line 231 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2573 "rygel-item-creator.c"
	}
#line 231 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_object_unref (_data_->_async_result);
#line 231 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	return FALSE;
#line 2579 "rygel-item-creator.c"
}


static void rygel_item_creator_conclude (RygelItemCreator* self) {
	GUPnPDIDLLiteWriter* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* didl;
	GUPnPServiceAction* _tmp2_;
	RygelMediaItem* _tmp3_;
	const gchar* _tmp4_;
	GUPnPServiceAction* _tmp5_;
#line 289 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_return_if_fail (self != NULL);
#line 291 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp0_ = self->priv->didl_writer;
#line 291 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp1_ = gupnp_didl_lite_writer_get_string (_tmp0_);
#line 291 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	didl = _tmp1_;
#line 294 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp2_ = self->priv->action;
#line 294 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp3_ = self->item;
#line 294 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp4_ = ((RygelMediaObject*) _tmp3_)->id;
#line 294 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	gupnp_service_action_set (_tmp2_, "ObjectID", G_TYPE_STRING, _tmp4_, "Result", G_TYPE_STRING, didl, NULL);
#line 297 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp5_ = self->priv->action;
#line 297 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	gupnp_service_action_return (_tmp5_);
#line 298 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
#line 289 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_free0 (didl);
#line 2615 "rygel-item-creator.c"
}


static void rygel_item_creator_handle_error (RygelItemCreator* self, GError* _error_) {
	GError* _tmp0_;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_;
	GError* _tmp11_;
	const gchar* _tmp12_;
#line 301 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_return_if_fail (self != NULL);
#line 302 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp0_ = _error_;
#line 302 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (_tmp0_->domain == RYGEL_CONTENT_DIRECTORY_ERROR) {
#line 2631 "rygel-item-creator.c"
		GUPnPServiceAction* _tmp1_;
		GError* _tmp2_;
		gint _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
#line 303 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_tmp1_ = self->priv->action;
#line 303 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_tmp2_ = _error_;
#line 303 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_tmp3_ = _tmp2_->code;
#line 303 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_tmp4_ = _error_;
#line 303 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_tmp5_ = _tmp4_->message;
#line 303 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		gupnp_service_action_return_error (_tmp1_, (guint) _tmp3_, _tmp5_);
#line 2649 "rygel-item-creator.c"
	} else {
		GUPnPServiceAction* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
#line 305 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_tmp6_ = self->priv->action;
#line 305 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_tmp7_ = _error_;
#line 305 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_tmp8_ = _tmp7_->message;
#line 305 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		gupnp_service_action_return_error (_tmp6_, (guint) 701, _tmp8_);
#line 2662 "rygel-item-creator.c"
	}
#line 308 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp9_ = _ ("Failed to create item under '%s': %s");
#line 308 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp10_ = self->container_id;
#line 308 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp11_ = _error_;
#line 308 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp12_ = _tmp11_->message;
#line 308 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_warning (_tmp9_, _tmp10_, _tmp12_);
#line 312 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
#line 2676 "rygel-item-creator.c"
}


static gchar* rygel_item_creator_get_generic_mime_type (RygelItemCreator* self) {
	gchar* result = NULL;
	RygelMediaItem* _tmp0_;
#line 315 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 316 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp0_ = self->item;
#line 316 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (RYGEL_IS_IMAGE_ITEM (_tmp0_)) {
#line 2689 "rygel-item-creator.c"
		gchar* _tmp1_;
#line 317 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_tmp1_ = g_strdup ("image");
#line 317 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		result = _tmp1_;
#line 317 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		return result;
#line 2697 "rygel-item-creator.c"
	} else {
		RygelMediaItem* _tmp2_;
#line 318 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_tmp2_ = self->item;
#line 318 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (RYGEL_IS_VIDEO_ITEM (_tmp2_)) {
#line 2704 "rygel-item-creator.c"
			gchar* _tmp3_;
#line 319 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_tmp3_ = g_strdup ("video");
#line 319 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			result = _tmp3_;
#line 319 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			return result;
#line 2712 "rygel-item-creator.c"
		} else {
			gchar* _tmp4_;
#line 321 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_tmp4_ = g_strdup ("audio");
#line 321 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			result = _tmp4_;
#line 321 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			return result;
#line 2721 "rygel-item-creator.c"
		}
	}
}


static RygelMediaItem* rygel_item_creator_create_item (RygelItemCreator* self, const gchar* id, RygelWritableContainer* parent, const gchar* title, const gchar* upnp_class, GError** error) {
	RygelMediaItem* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	GError * _inner_error_ = NULL;
#line 325 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 325 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 325 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 325 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 325 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_return_val_if_fail (upnp_class != NULL, NULL);
#line 329 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp0_ = upnp_class;
#line 329 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp1_ = _tmp0_;
#line 329 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 329 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (_tmp3_ == g_quark_from_string (RYGEL_IMAGE_ITEM_UPNP_CLASS)) {
#line 329 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		switch (0) {
#line 2753 "rygel-item-creator.c"
			default:
			{
				const gchar* _tmp4_;
				RygelWritableContainer* _tmp5_;
				const gchar* _tmp6_;
				RygelImageItem* _tmp7_;
#line 331 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp4_ = id;
#line 331 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp5_ = parent;
#line 331 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp6_ = title;
#line 331 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp7_ = rygel_image_item_new (_tmp4_, (RygelMediaContainer*) _tmp5_, _tmp6_, RYGEL_IMAGE_ITEM_UPNP_CLASS);
#line 331 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				result = (RygelMediaItem*) _tmp7_;
#line 331 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				return result;
#line 2772 "rygel-item-creator.c"
			}
		}
	} else if (_tmp3_ == g_quark_from_string (RYGEL_PHOTO_ITEM_UPNP_CLASS)) {
#line 329 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		switch (0) {
#line 2778 "rygel-item-creator.c"
			default:
			{
				const gchar* _tmp8_;
				RygelWritableContainer* _tmp9_;
				const gchar* _tmp10_;
				RygelPhotoItem* _tmp11_;
#line 333 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp8_ = id;
#line 333 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp9_ = parent;
#line 333 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp10_ = title;
#line 333 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp11_ = rygel_photo_item_new (_tmp8_, (RygelMediaContainer*) _tmp9_, _tmp10_, RYGEL_PHOTO_ITEM_UPNP_CLASS);
#line 333 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				result = (RygelMediaItem*) _tmp11_;
#line 333 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				return result;
#line 2797 "rygel-item-creator.c"
			}
		}
	} else if (_tmp3_ == g_quark_from_string (RYGEL_VIDEO_ITEM_UPNP_CLASS)) {
#line 329 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		switch (0) {
#line 2803 "rygel-item-creator.c"
			default:
			{
				const gchar* _tmp12_;
				RygelWritableContainer* _tmp13_;
				const gchar* _tmp14_;
				RygelVideoItem* _tmp15_;
#line 335 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp12_ = id;
#line 335 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp13_ = parent;
#line 335 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp14_ = title;
#line 335 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp15_ = rygel_video_item_new (_tmp12_, (RygelMediaContainer*) _tmp13_, _tmp14_, RYGEL_VIDEO_ITEM_UPNP_CLASS);
#line 335 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				result = (RygelMediaItem*) _tmp15_;
#line 335 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				return result;
#line 2822 "rygel-item-creator.c"
			}
		}
	} else if (_tmp3_ == g_quark_from_string (RYGEL_AUDIO_ITEM_UPNP_CLASS)) {
#line 329 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		switch (0) {
#line 2828 "rygel-item-creator.c"
			default:
			{
				const gchar* _tmp16_;
				RygelWritableContainer* _tmp17_;
				const gchar* _tmp18_;
				RygelAudioItem* _tmp19_;
#line 337 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp16_ = id;
#line 337 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp17_ = parent;
#line 337 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp18_ = title;
#line 337 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp19_ = rygel_audio_item_new (_tmp16_, (RygelMediaContainer*) _tmp17_, _tmp18_, RYGEL_AUDIO_ITEM_UPNP_CLASS);
#line 337 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				result = (RygelMediaItem*) _tmp19_;
#line 337 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				return result;
#line 2847 "rygel-item-creator.c"
			}
		}
	} else if (_tmp3_ == g_quark_from_string (RYGEL_MUSIC_ITEM_UPNP_CLASS)) {
#line 329 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		switch (0) {
#line 2853 "rygel-item-creator.c"
			default:
			{
				const gchar* _tmp20_;
				RygelWritableContainer* _tmp21_;
				const gchar* _tmp22_;
				RygelMusicItem* _tmp23_;
#line 339 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp20_ = id;
#line 339 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp21_ = parent;
#line 339 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp22_ = title;
#line 339 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp23_ = rygel_music_item_new (_tmp20_, (RygelMediaContainer*) _tmp21_, _tmp22_, RYGEL_MUSIC_ITEM_UPNP_CLASS);
#line 339 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				result = (RygelMediaItem*) _tmp23_;
#line 339 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				return result;
#line 2872 "rygel-item-creator.c"
			}
		}
	} else {
#line 329 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		switch (0) {
#line 2878 "rygel-item-creator.c"
			default:
			{
				const gchar* _tmp24_;
				GError* _tmp25_;
#line 341 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp24_ = upnp_class;
#line 341 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp25_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "Creation of item of class '%s' " "not supported.", _tmp24_);
#line 341 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_inner_error_ = _tmp25_;
#line 341 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				g_propagate_error (error, _inner_error_);
#line 341 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				return NULL;
#line 2893 "rygel-item-creator.c"
			}
		}
	}
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_;
	gunichar _tmp1_ = 0U;
#line 1148 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0U);
#line 1149 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 1149 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
#line 1149 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 1149 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	return result;
#line 2914 "rygel-item-creator.c"
}


static gboolean rygel_item_creator_is_valid_uri (RygelItemCreator* self, const gchar* uri) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp3_;
#line 350 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 351 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp1_ = uri;
#line 351 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (_tmp1_ == NULL) {
#line 351 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_tmp0_ = TRUE;
#line 2931 "rygel-item-creator.c"
	} else {
		const gchar* _tmp2_;
#line 351 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_tmp2_ = uri;
#line 351 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_tmp0_ = g_strcmp0 (_tmp2_, "") == 0;
#line 2938 "rygel-item-creator.c"
	}
#line 351 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp3_ = _tmp0_;
#line 351 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (_tmp3_) {
#line 352 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		result = FALSE;
#line 352 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		return result;
#line 2948 "rygel-item-creator.c"
	}
	{
		const gchar* _tmp4_;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gchar* next;
#line 355 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_tmp4_ = uri;
#line 355 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_tmp5_ = g_utf8_next_char (_tmp4_);
#line 355 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_tmp6_ = g_strdup (_tmp5_);
#line 355 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		next = _tmp6_;
#line 2963 "rygel-item-creator.c"
		{
			gboolean _tmp7_;
#line 355 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_tmp7_ = TRUE;
#line 355 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			while (TRUE) {
#line 2970 "rygel-item-creator.c"
				gboolean _tmp8_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				gunichar _tmp14_ = 0U;
				gboolean _tmp15_ = FALSE;
#line 355 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp8_ = _tmp7_;
#line 355 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				if (!_tmp8_) {
#line 2980 "rygel-item-creator.c"
					const gchar* _tmp9_;
					const gchar* _tmp10_ = NULL;
					gchar* _tmp11_;
#line 357 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_tmp9_ = next;
#line 357 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_tmp10_ = g_utf8_next_char (_tmp9_);
#line 357 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_tmp11_ = g_strdup (_tmp10_);
#line 357 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_g_free0 (next);
#line 357 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					next = _tmp11_;
#line 2994 "rygel-item-creator.c"
				}
#line 355 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp7_ = FALSE;
#line 356 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp12_ = next;
#line 356 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				if (!(g_strcmp0 (_tmp12_, "") != 0)) {
#line 356 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					break;
#line 3004 "rygel-item-creator.c"
				}
#line 358 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp13_ = next;
#line 358 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp14_ = string_get_char (_tmp13_, (glong) 0);
#line 358 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp15_ = g_unichar_isspace (_tmp14_);
#line 358 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				if (_tmp15_) {
#line 359 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					result = FALSE;
#line 359 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					_g_free0 (next);
#line 359 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					return result;
#line 3020 "rygel-item-creator.c"
				}
			}
		}
#line 355 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_g_free0 (next);
#line 3026 "rygel-item-creator.c"
	}
#line 363 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	result = TRUE;
#line 363 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	return result;
#line 3032 "rygel-item-creator.c"
}


static void rygel_item_creator_create_uri_data_free (gpointer _data) {
	RygelItemCreatorCreateUriData* _data_;
	_data_ = _data;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (_data_->container);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_free0 (_data_->title);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_free0 (_data_->result);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (_data_->self);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_slice_free (RygelItemCreatorCreateUriData, _data_);
#line 3049 "rygel-item-creator.c"
}


static void rygel_item_creator_create_uri (RygelItemCreator* self, RygelWritableContainer* container, const gchar* title, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemCreatorCreateUriData* _data_;
	RygelItemCreator* _tmp0_;
	RygelWritableContainer* _tmp1_;
	RygelWritableContainer* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_ = g_slice_new0 (RygelItemCreatorCreateUriData);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_creator_create_uri);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_creator_create_uri_data_free);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->self = _tmp0_;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp1_ = container;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->container = _tmp2_;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp3_ = title;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->title = _tmp4_;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	rygel_item_creator_create_uri_co (_data_);
#line 3084 "rygel-item-creator.c"
}


static gchar* rygel_item_creator_create_uri_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error) {
	gchar* result;
	RygelItemCreatorCreateUriData* _data_;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		return NULL;
#line 3095 "rygel-item-creator.c"
	}
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	result = _data_->result;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->result = NULL;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	return result;
#line 3105 "rygel-item-creator.c"
}


static void rygel_item_creator_create_uri_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemCreatorCreateUriData* _data_;
#line 368 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_ = _user_data_;
#line 368 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_source_object_ = source_object;
#line 368 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_res_ = _res_;
#line 368 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	rygel_item_creator_create_uri_co (_data_);
#line 3119 "rygel-item-creator.c"
}


static gboolean rygel_item_creator_create_uri_co (RygelItemCreatorCreateUriData* _data_) {
#line 366 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	switch (_data_->_state_) {
#line 366 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		case 0:
#line 3128 "rygel-item-creator.c"
		goto _state_0;
#line 366 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		case 1:
#line 3132 "rygel-item-creator.c"
		goto _state_1;
		default:
#line 366 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_assert_not_reached ();
#line 3137 "rygel-item-creator.c"
	}
	_state_0:
#line 368 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp0_ = _data_->container;
#line 368 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp1_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 368 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 368 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_state_ = 1;
#line 368 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	rygel_media_object_get_writable ((RygelMediaObject*) _data_->_tmp0_, _data_->_tmp2_, rygel_item_creator_create_uri_ready, _data_);
#line 368 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	return FALSE;
#line 3152 "rygel-item-creator.c"
	_state_1:
#line 368 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp3_ = NULL;
#line 368 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp3_ = rygel_media_object_get_writable_finish ((RygelMediaObject*) _data_->_tmp0_, _data_->_res_, &_data_->_inner_error_);
#line 368 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->dir = _data_->_tmp3_;
#line 368 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (_data_->_inner_error_ != NULL) {
#line 368 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 368 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_error_free (_data_->_inner_error_);
#line 368 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_state_ == 0) {
#line 368 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3170 "rygel-item-creator.c"
		} else {
#line 368 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 3174 "rygel-item-creator.c"
		}
#line 368 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_object_unref (_data_->_async_result);
#line 368 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		return FALSE;
#line 3180 "rygel-item-creator.c"
	}
#line 369 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp4_ = _data_->dir;
#line 369 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (_data_->_tmp4_ == NULL) {
#line 370 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp5_ = NULL;
#line 370 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp5_ = _ ("Object creation in %s not allowed");
#line 370 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp6_ = _data_->container;
#line 370 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp7_ = ((RygelMediaObject*) _data_->_tmp6_)->id;
#line 370 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp8_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT, _data_->_tmp5_, _data_->_tmp7_);
#line 370 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_inner_error_ = _data_->_tmp8_;
#line 370 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 370 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_error_free (_data_->_inner_error_);
#line 370 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_g_object_unref0 (_data_->dir);
#line 370 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_state_ == 0) {
#line 370 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3208 "rygel-item-creator.c"
		} else {
#line 370 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 3212 "rygel-item-creator.c"
		}
#line 370 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_object_unref (_data_->_async_result);
#line 370 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		return FALSE;
#line 3218 "rygel-item-creator.c"
	}
#line 375 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp9_ = g_date_time_new_now_utc ();
#line 375 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->now = _data_->_tmp9_;
#line 376 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp10_ = _data_->dir;
#line 376 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp11_ = _data_->title;
#line 376 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp12_ = NULL;
#line 376 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp12_ = g_file_get_child_for_display_name (_data_->_tmp10_, _data_->_tmp11_, &_data_->_inner_error_);
#line 376 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->file = _data_->_tmp12_;
#line 376 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (_data_->_inner_error_ != NULL) {
#line 376 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 376 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_error_free (_data_->_inner_error_);
#line 376 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_g_date_time_unref0 (_data_->now);
#line 376 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_g_object_unref0 (_data_->dir);
#line 376 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_state_ == 0) {
#line 376 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3248 "rygel-item-creator.c"
		} else {
#line 376 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 3252 "rygel-item-creator.c"
		}
#line 376 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_object_unref (_data_->_async_result);
#line 376 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		return FALSE;
#line 3258 "rygel-item-creator.c"
	}
#line 378 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp13_ = _data_->file;
#line 378 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp14_ = NULL;
#line 378 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp14_ = g_file_get_uri (_data_->_tmp13_);
#line 378 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp15_ = _data_->_tmp14_;
#line 378 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp16_ = _data_->now;
#line 378 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp17_ = NULL;
#line 378 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp17_ = g_date_time_format (_data_->_tmp16_, "%s");
#line 378 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp18_ = _data_->_tmp17_;
#line 378 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp19_ = g_strconcat (_data_->_tmp15_, _data_->_tmp18_, NULL);
#line 378 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp20_ = _data_->_tmp19_;
#line 378 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_free0 (_data_->_tmp18_);
#line 378 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_free0 (_data_->_tmp15_);
#line 378 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->result = _data_->_tmp20_;
#line 378 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (_data_->file);
#line 378 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_date_time_unref0 (_data_->now);
#line 378 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (_data_->dir);
#line 378 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (_data_->_state_ == 0) {
#line 378 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3296 "rygel-item-creator.c"
	} else {
#line 378 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 3300 "rygel-item-creator.c"
	}
#line 378 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_object_unref (_data_->_async_result);
#line 378 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	return FALSE;
#line 366 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (_data_->file);
#line 366 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_date_time_unref0 (_data_->now);
#line 366 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (_data_->dir);
#line 366 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (_data_->_state_ == 0) {
#line 366 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3316 "rygel-item-creator.c"
	} else {
#line 366 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 3320 "rygel-item-creator.c"
	}
#line 366 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_object_unref (_data_->_async_result);
#line 366 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	return FALSE;
#line 3326 "rygel-item-creator.c"
}


static void rygel_item_creator_wait_for_item_data_free (gpointer _data) {
	RygelItemCreatorWaitForItemData* _data_;
	_data_ = _data;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (_data_->container);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (_data_->self);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_slice_free (RygelItemCreatorWaitForItemData, _data_);
#line 3339 "rygel-item-creator.c"
}


static void rygel_item_creator_wait_for_item (RygelItemCreator* self, RygelWritableContainer* container, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemCreatorWaitForItemData* _data_;
	RygelItemCreator* _tmp0_;
	RygelWritableContainer* _tmp1_;
	RygelWritableContainer* _tmp2_;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_ = g_slice_new0 (RygelItemCreatorWaitForItemData);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_creator_wait_for_item);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_creator_wait_for_item_data_free);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->self = _tmp0_;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp1_ = container;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->container = _tmp2_;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	rygel_item_creator_wait_for_item_co (_data_);
#line 3366 "rygel-item-creator.c"
}


static void rygel_item_creator_wait_for_item_finish (RygelItemCreator* self, GAsyncResult* _res_) {
	RygelItemCreatorWaitForItemData* _data_;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 3374 "rygel-item-creator.c"
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_atomic_int_inc (&_data5_->_ref_count_);
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	return _data5_;
#line 3383 "rygel-item-creator.c"
}


static void block5_data_unref (Block5Data* _data5_) {
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_g_object_unref0 (_data5_->self);
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_g_object_unref0 (_data5_->container);
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_slice_free (Block5Data, _data5_);
#line 3396 "rygel-item-creator.c"
	}
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
#line 388 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_atomic_int_inc (&_data6_->_ref_count_);
#line 388 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	return _data6_;
#line 3406 "rygel-item-creator.c"
}


static void block6_data_unref (Block6Data* _data6_) {
#line 388 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
#line 388 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		block5_data_unref (_data6_->_data5_);
#line 388 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data6_->_data5_ = NULL;
#line 388 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_slice_free (Block6Data, _data6_);
#line 3419 "rygel-item-creator.c"
	}
}


static void ____lambda10_ (Block6Data* _data6_, RygelMediaContainer* container) {
	Block5Data* _data5_;
	RygelItemCreator * self;
#line 389 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data5_ = _data6_->_data5_;
#line 389 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	self = _data5_->self;
#line 389 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_return_if_fail (container != NULL);
#line 390 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	rygel_item_creator_wait_for_item_co (_data5_->_async_data_);
#line 3435 "rygel-item-creator.c"
}


static void _____lambda10__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self) {
#line 389 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	____lambda10_ (self, container);
#line 3442 "rygel-item-creator.c"
}


static gboolean ____lambda11_ (Block6Data* _data6_) {
	Block5Data* _data5_;
	RygelItemCreator * self;
	gboolean result = FALSE;
	RygelWritableContainer* _tmp0_;
	const gchar* _tmp1_;
#line 394 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data5_ = _data6_->_data5_;
#line 394 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	self = _data5_->self;
#line 395 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp0_ = _data5_->container;
#line 395 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp1_ = ((RygelMediaObject*) _tmp0_)->id;
#line 395 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_debug ("rygel-item-creator.vala:395: Timeout on waiting for 'updated' signal o" \
"n '%s'.", _tmp1_);
#line 397 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	rygel_item_creator_wait_for_item_co (_data5_->_async_data_);
#line 398 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data6_->timeout = (guint) 0;
#line 400 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	result = FALSE;
#line 400 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	return result;
#line 3470 "rygel-item-creator.c"
}


static gboolean _____lambda11__gsource_func (gpointer self) {
	gboolean result;
	result = ____lambda11_ (self);
#line 394 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	return result;
#line 3479 "rygel-item-creator.c"
}


static void rygel_item_creator_wait_for_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemCreatorWaitForItemData* _data_;
#line 408 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_ = _user_data_;
#line 408 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_source_object_ = source_object;
#line 408 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_res_ = _res_;
#line 408 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	rygel_item_creator_wait_for_item_co (_data_);
#line 3493 "rygel-item-creator.c"
}


static gboolean rygel_item_creator_wait_for_item_co (RygelItemCreatorWaitForItemData* _data_) {
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	switch (_data_->_state_) {
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		case 0:
#line 3502 "rygel-item-creator.c"
		goto _state_0;
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		case 1:
#line 3506 "rygel-item-creator.c"
		goto _state_1;
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		case 2:
#line 3510 "rygel-item-creator.c"
		goto _state_2;
		default:
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_assert_not_reached ();
#line 3515 "rygel-item-creator.c"
	}
	_state_0:
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_data5_ = g_slice_new0 (Block5Data);
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_data5_->_ref_count_ = 1;
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_data5_->self = g_object_ref (_data_->self);
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp0_ = _data_->container;
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp1_ = _g_object_ref0 (_data_->_tmp0_);
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_data5_->container = _data_->_tmp1_;
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_data5_->_async_data_ = _data_;
#line 382 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp2_ = _data_->_data5_->container;
#line 382 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp3_ = ((RygelMediaObject*) _data_->_tmp2_)->id;
#line 382 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_debug ("rygel-item-creator.vala:382: Waiting for new item to appear under cont" \
"ainer '%s'..", _data_->_tmp3_);
#line 385 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->item = NULL;
#line 387 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	while (TRUE) {
#line 387 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp4_ = _data_->item;
#line 387 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (!(_data_->_tmp4_ == NULL)) {
#line 387 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			break;
#line 3548 "rygel-item-creator.c"
		}
#line 388 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		_data_->_tmp5_ = _data_->item;
#line 388 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		if (_data_->_tmp5_ == NULL) {
#line 388 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_data6_ = g_slice_new0 (Block6Data);
#line 388 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_data6_->_ref_count_ = 1;
#line 388 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_data6_->_data5_ = block5_data_ref (_data_->_data5_);
#line 389 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp6_ = _data_->_data5_->container;
#line 389 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp7_ = 0UL;
#line 389 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp7_ = g_signal_connect_data ((RygelMediaContainer*) _data_->_tmp6_, "container-updated", (GCallback) _____lambda10__rygel_media_container_container_updated, block6_data_ref (_data_->_data6_), (GClosureNotify) block6_data_unref, 0);
#line 389 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->id = _data_->_tmp7_;
#line 393 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_data6_->timeout = (guint) 0;
#line 394 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp8_ = 0U;
#line 394 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp8_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, _____lambda11__gsource_func, block6_data_ref (_data_->_data6_), block6_data_unref);
#line 394 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_data6_->timeout = _data_->_tmp8_;
#line 403 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_state_ = 1;
#line 403 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			return FALSE;
#line 3580 "rygel-item-creator.c"
			_state_1:
			;
#line 405 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp9_ = _data_->_data5_->container;
#line 405 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp10_ = _data_->id;
#line 405 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			g_signal_handler_disconnect ((GObject*) _data_->_tmp9_, _data_->_tmp10_);
#line 3589 "rygel-item-creator.c"
			{
#line 408 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp11_ = _data_->_data5_->container;
#line 408 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp12_ = _data_->self->item;
#line 408 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp13_ = ((RygelMediaObject*) _data_->_tmp12_)->id;
#line 408 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp14_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 408 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp15_ = _data_->_tmp14_;
#line 408 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_state_ = 2;
#line 408 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				rygel_media_container_find_object ((RygelMediaContainer*) _data_->_tmp11_, _data_->_tmp13_, _data_->_tmp15_, rygel_item_creator_wait_for_item_ready, _data_);
#line 408 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				return FALSE;
#line 3607 "rygel-item-creator.c"
				_state_2:
#line 408 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp16_ = NULL;
#line 408 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp16_ = rygel_media_container_find_object_finish ((RygelMediaContainer*) _data_->_tmp11_, _data_->_res_, &_data_->_inner_error_);
#line 408 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp17_ = _data_->_tmp16_;
#line 408 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				if (_data_->_inner_error_ != NULL) {
#line 3617 "rygel-item-creator.c"
					goto __catch72_g_error;
				}
#line 408 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_g_object_unref0 (_data_->item);
#line 408 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->item = RYGEL_IS_MEDIA_ITEM (_data_->_tmp17_) ? ((RygelMediaItem*) _data_->_tmp17_) : NULL;
#line 3624 "rygel-item-creator.c"
			}
			goto __finally72;
			__catch72_g_error:
			{
#line 407 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_error_ = _data_->_inner_error_;
#line 407 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_inner_error_ = NULL;
#line 412 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp18_ = _data_->_data5_->container;
#line 412 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp19_ = ((RygelMediaObject*) _data_->_tmp18_)->id;
#line 412 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp20_ = _data_->self->item;
#line 412 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp21_ = ((RygelMediaObject*) _data_->_tmp20_)->id;
#line 412 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				g_warning ("Error from container '%s' on trying to find newly " "added child item '%s' in it", _data_->_tmp19_, _data_->_tmp21_);
#line 407 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_g_error_free0 (_data_->_error_);
#line 3645 "rygel-item-creator.c"
			}
			__finally72:
#line 407 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			if (_data_->_inner_error_ != NULL) {
#line 407 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				block6_data_unref (_data_->_data6_);
#line 407 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_data6_ = NULL;
#line 407 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_g_object_unref0 (_data_->item);
#line 407 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				block5_data_unref (_data_->_data5_);
#line 407 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_data5_ = NULL;
#line 407 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 407 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				g_clear_error (&_data_->_inner_error_);
#line 407 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				return FALSE;
#line 3666 "rygel-item-creator.c"
			}
#line 419 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_tmp22_ = _data_->_data6_->timeout;
#line 419 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			if (_data_->_tmp22_ != ((guint) 0)) {
#line 420 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_tmp23_ = _data_->_data6_->timeout;
#line 420 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				g_source_remove (_data_->_tmp23_);
#line 3676 "rygel-item-creator.c"
			} else {
#line 422 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				block6_data_unref (_data_->_data6_);
#line 422 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_data_->_data6_ = NULL;
#line 422 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				break;
#line 3684 "rygel-item-creator.c"
			}
#line 388 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			block6_data_unref (_data_->_data6_);
#line 388 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			_data_->_data6_ = NULL;
#line 3690 "rygel-item-creator.c"
		}
	}
#line 426 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp24_ = _data_->_data5_->container;
#line 426 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_tmp25_ = ((RygelMediaObject*) _data_->_tmp24_)->id;
#line 426 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_debug ("rygel-item-creator.vala:426: Finished waiting for new item to appear u" \
"nder container '%s'", _data_->_tmp25_);
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (_data_->item);
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	block5_data_unref (_data_->_data5_);
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_data_->_data5_ = NULL;
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	if (_data_->_state_ == 0) {
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3709 "rygel-item-creator.c"
	} else {
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 3713 "rygel-item-creator.c"
	}
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_object_unref (_data_->_async_result);
#line 381 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	return FALSE;
#line 3719 "rygel-item-creator.c"
}


static gboolean rygel_item_creator_is_profile_valid (RygelItemCreator* self, const gchar* profile) {
	gboolean result = FALSE;
	GUPnPDLNADiscoverer* _tmp0_;
	GUPnPDLNADiscoverer* discoverer;
	gboolean valid;
	GUPnPDLNADiscoverer* _tmp1_;
	GList* _tmp2_ = NULL;
#line 430 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 430 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_return_val_if_fail (profile != NULL, FALSE);
#line 431 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp0_ = gupnp_dlna_discoverer_new ((GstClockTime) GST_SECOND, TRUE, FALSE);
#line 431 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	discoverer = _tmp0_;
#line 435 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	valid = FALSE;
#line 436 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp1_ = discoverer;
#line 436 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp2_ = gupnp_dlna_discoverer_list_profiles (_tmp1_);
#line 3744 "rygel-item-creator.c"
	{
		GList* known_profile_collection = NULL;
		GList* known_profile_it = NULL;
#line 436 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		known_profile_collection = _tmp2_;
#line 436 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		for (known_profile_it = known_profile_collection; known_profile_it != NULL; known_profile_it = known_profile_it->next) {
#line 3752 "rygel-item-creator.c"
			GUPnPDLNAProfile* known_profile = NULL;
#line 436 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
			known_profile = (GUPnPDLNAProfile*) known_profile_it->data;
#line 3756 "rygel-item-creator.c"
			{
				GUPnPDLNAProfile* _tmp3_;
				const gchar* _tmp4_;
				const gchar* _tmp5_;
				const gchar* _tmp6_;
#line 437 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp3_ = known_profile;
#line 437 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp4_ = gupnp_dlna_profile_get_name (_tmp3_);
#line 437 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp5_ = _tmp4_;
#line 437 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				_tmp6_ = profile;
#line 437 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
				if (g_strcmp0 (_tmp5_, _tmp6_) == 0) {
#line 438 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					valid = TRUE;
#line 440 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
					break;
#line 3776 "rygel-item-creator.c"
				}
			}
		}
	}
#line 444 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	result = valid;
#line 444 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (discoverer);
#line 444 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	return result;
#line 3787 "rygel-item-creator.c"
}


static GCancellable* rygel_item_creator_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelItemCreator* self;
	GCancellable* _tmp0_;
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	self = (RygelItemCreator*) base;
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp0_ = self->priv->_cancellable;
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	result = _tmp0_;
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	return result;
#line 3803 "rygel-item-creator.c"
}


static void rygel_item_creator_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelItemCreator* self;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	self = (RygelItemCreator*) base;
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp0_ = value;
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	self->priv->_cancellable = _tmp1_;
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_object_notify ((GObject *) self, "cancellable");
#line 3823 "rygel-item-creator.c"
}


static void rygel_item_creator_class_init (RygelItemCreatorClass * klass) {
	GPatternSpec* _tmp0_;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	rygel_item_creator_parent_class = g_type_class_peek_parent (klass);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_type_class_add_private (klass, sizeof (RygelItemCreatorPrivate));
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_item_creator_get_property;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_item_creator_set_property;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_item_creator_finalize;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_ITEM_CREATOR_CANCELLABLE, "cancellable");
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_tmp0_ = g_pattern_spec_new ("*<!--*-->*");
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	rygel_item_creator_comment_pattern = _tmp0_;
#line 3845 "rygel-item-creator.c"
}


static void rygel_item_creator_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	rygel_item_creator_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	iface->run = (void (*)(RygelStateMachine*)) rygel_item_creator_real_run;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	iface->run_finish = rygel_item_creator_real_run_finish;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	iface->get_cancellable = rygel_item_creator_real_get_cancellable;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	iface->set_cancellable = rygel_item_creator_real_set_cancellable;
#line 3860 "rygel-item-creator.c"
}


static void rygel_item_creator_instance_init (RygelItemCreator * self) {
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	self->priv = RYGEL_ITEM_CREATOR_GET_PRIVATE (self);
#line 3867 "rygel-item-creator.c"
}


static void rygel_item_creator_finalize (GObject* obj) {
	RygelItemCreator * self;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	self = RYGEL_ITEM_CREATOR (obj);
#line 37 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_free0 (self->container_id);
#line 38 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_free0 (self->elements);
#line 40 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (self->didl_item);
#line 41 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (self->item);
#line 43 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (self->priv->content_dir);
#line 45 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (self->priv->didl_writer);
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (self->priv->didl_parser);
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	G_OBJECT_CLASS (rygel_item_creator_parent_class)->finalize (obj);
#line 3893 "rygel-item-creator.c"
}


/**
 * CreateObject action implementation.
 */
GType rygel_item_creator_get_type (void) {
	static volatile gsize rygel_item_creator_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_item_creator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelItemCreatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_item_creator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelItemCreator), 0, (GInstanceInitFunc) rygel_item_creator_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_item_creator_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_item_creator_type_id;
		rygel_item_creator_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelItemCreator", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_item_creator_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_item_creator_type_id__volatile, rygel_item_creator_type_id);
	}
	return rygel_item_creator_type_id__volatile;
}


static void _vala_rygel_item_creator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelItemCreator * self;
	self = RYGEL_ITEM_CREATOR (object);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	switch (property_id) {
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		case RYGEL_ITEM_CREATOR_CANCELLABLE:
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		break;
#line 3925 "rygel-item-creator.c"
		default:
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		break;
#line 3931 "rygel-item-creator.c"
	}
}


static void _vala_rygel_item_creator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelItemCreator * self;
	self = RYGEL_ITEM_CREATOR (object);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
	switch (property_id) {
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		case RYGEL_ITEM_CREATOR_CANCELLABLE:
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		break;
#line 3947 "rygel-item-creator.c"
		default:
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-item-creator.vala"
		break;
#line 3953 "rygel-item-creator.c"
	}
}



