/* rygel-media-export-media-cache.c generated by valac 0.13.3, the Vala compiler
 * generated from rygel-media-export-media-cache.vala, do not modify */

/*
 * Copyright (C) 2009,2010 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>
#include <gee.h>
#include <stdlib.h>
#include <gio/gio.h>
#include <rygel.h>
#include <glib/gi18n-lib.h>
#include <sqlite3.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_MEDIA_EXPORT_TYPE_OBJECT_TYPE (rygel_media_export_object_type_get_type ())

#define RYGEL_MEDIA_EXPORT_TYPE_EXISTS_CACHE_ENTRY (rygel_media_export_exists_cache_entry_get_type ())
typedef struct _RygelMediaExportExistsCacheEntry RygelMediaExportExistsCacheEntry;

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;
typedef struct _RygelMediaExportMediaCachePrivate RygelMediaExportMediaCachePrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER (rygel_media_export_sqlite_wrapper_get_type ())
#define RYGEL_MEDIA_EXPORT_SQLITE_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER, RygelMediaExportSqliteWrapper))
#define RYGEL_MEDIA_EXPORT_SQLITE_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER, RygelMediaExportSqliteWrapperClass))
#define RYGEL_MEDIA_EXPORT_IS_SQLITE_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER))
#define RYGEL_MEDIA_EXPORT_IS_SQLITE_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER))
#define RYGEL_MEDIA_EXPORT_SQLITE_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER, RygelMediaExportSqliteWrapperClass))

typedef struct _RygelMediaExportSqliteWrapper RygelMediaExportSqliteWrapper;
typedef struct _RygelMediaExportSqliteWrapperClass RygelMediaExportSqliteWrapperClass;

#define RYGEL_MEDIA_EXPORT_TYPE_DATABASE (rygel_media_export_database_get_type ())
#define RYGEL_MEDIA_EXPORT_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabase))
#define RYGEL_MEDIA_EXPORT_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabaseClass))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE))
#define RYGEL_MEDIA_EXPORT_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabaseClass))

typedef struct _RygelMediaExportDatabase RygelMediaExportDatabase;
typedef struct _RygelMediaExportDatabaseClass RygelMediaExportDatabaseClass;

#define RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY (rygel_media_export_object_factory_get_type ())
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactory))
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactoryClass))
#define RYGEL_MEDIA_EXPORT_IS_OBJECT_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY))
#define RYGEL_MEDIA_EXPORT_IS_OBJECT_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY))
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactoryClass))

typedef struct _RygelMediaExportObjectFactory RygelMediaExportObjectFactory;
typedef struct _RygelMediaExportObjectFactoryClass RygelMediaExportObjectFactoryClass;

#define RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY (rygel_media_export_sql_factory_get_type ())
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY, RygelMediaExportSQLFactory))
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY, RygelMediaExportSQLFactoryClass))
#define RYGEL_MEDIA_EXPORT_IS_SQL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY))
#define RYGEL_MEDIA_EXPORT_IS_SQL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY))
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY, RygelMediaExportSQLFactoryClass))

typedef struct _RygelMediaExportSQLFactory RygelMediaExportSQLFactory;
typedef struct _RygelMediaExportSQLFactoryClass RygelMediaExportSQLFactoryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_MEDIA_EXPORT_TYPE_SQL_STRING (rygel_media_export_sql_string_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR (rygel_media_export_database_cursor_get_type ())
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR, RygelMediaExportDatabaseCursor))
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR, RygelMediaExportDatabaseCursorClass))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR))
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR, RygelMediaExportDatabaseCursorClass))

typedef struct _RygelMediaExportDatabaseCursor RygelMediaExportDatabaseCursor;
typedef struct _RygelMediaExportDatabaseCursorClass RygelMediaExportDatabaseCursorClass;

#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_TYPE_ITERATOR (rygel_media_export_database_cursor_iterator_get_type ())
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_TYPE_ITERATOR, RygelMediaExportDatabaseCursorIterator))
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_TYPE_ITERATOR, RygelMediaExportDatabaseCursorIteratorClass))
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_TYPE_ITERATOR))
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_TYPE_ITERATOR))
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_TYPE_ITERATOR, RygelMediaExportDatabaseCursorIteratorClass))

typedef struct _RygelMediaExportDatabaseCursorIterator RygelMediaExportDatabaseCursorIterator;
typedef struct _RygelMediaExportDatabaseCursorIteratorClass RygelMediaExportDatabaseCursorIteratorClass;
#define _rygel_media_export_database_cursor_iterator_unref0(var) ((var == NULL) ? NULL : (var = (rygel_media_export_database_cursor_iterator_unref (var), NULL)))
#define _rygel_media_export_exists_cache_entry_free0(var) ((var == NULL) ? NULL : (var = (rygel_media_export_exists_cache_entry_free (var), NULL)))
#define _g_value_array_free0(var) ((var == NULL) ? NULL : (var = (g_value_array_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_DETAIL_COLUMN (rygel_media_export_detail_column_get_type ())

#define RYGEL_TYPE_NULL_CONTAINER (rygel_null_container_get_type ())
#define RYGEL_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainer))
#define RYGEL_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))
#define RYGEL_IS_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_IS_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_NULL_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))

typedef struct _RygelNullContainer RygelNullContainer;
typedef struct _RygelNullContainerClass RygelNullContainerClass;

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER (rygel_media_export_media_cache_upgrader_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgrader))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgraderClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_UPGRADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_UPGRADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgraderClass))

typedef struct _RygelMediaExportMediaCacheUpgrader RygelMediaExportMediaCacheUpgrader;
typedef struct _RygelMediaExportMediaCacheUpgraderClass RygelMediaExportMediaCacheUpgraderClass;
#define _rygel_media_export_media_cache_upgrader_unref0(var) ((var == NULL) ? NULL : (var = (rygel_media_export_media_cache_upgrader_unref (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER (rygel_media_export_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainer))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))

typedef struct _RygelMediaExportDBContainer RygelMediaExportDBContainer;
typedef struct _RygelMediaExportDBContainerClass RygelMediaExportDBContainerClass;
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_SQL_OPERATOR (rygel_media_export_sql_operator_get_type ())
#define RYGEL_MEDIA_EXPORT_SQL_OPERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_OPERATOR, RygelMediaExportSqlOperator))
#define RYGEL_MEDIA_EXPORT_SQL_OPERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_OPERATOR, RygelMediaExportSqlOperatorClass))
#define RYGEL_MEDIA_EXPORT_IS_SQL_OPERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_OPERATOR))
#define RYGEL_MEDIA_EXPORT_IS_SQL_OPERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_OPERATOR))
#define RYGEL_MEDIA_EXPORT_SQL_OPERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_OPERATOR, RygelMediaExportSqlOperatorClass))

typedef struct _RygelMediaExportSqlOperator RygelMediaExportSqlOperator;
typedef struct _RygelMediaExportSqlOperatorClass RygelMediaExportSqlOperatorClass;

#define RYGEL_MEDIA_EXPORT_TYPE_SQL_FUNCTION (rygel_media_export_sql_function_get_type ())
#define RYGEL_MEDIA_EXPORT_SQL_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FUNCTION, RygelMediaExportSqlFunction))
#define RYGEL_MEDIA_EXPORT_SQL_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_FUNCTION, RygelMediaExportSqlFunctionClass))
#define RYGEL_MEDIA_EXPORT_IS_SQL_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FUNCTION))
#define RYGEL_MEDIA_EXPORT_IS_SQL_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_FUNCTION))
#define RYGEL_MEDIA_EXPORT_SQL_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FUNCTION, RygelMediaExportSqlFunctionClass))

typedef struct _RygelMediaExportSqlFunction RygelMediaExportSqlFunction;
typedef struct _RygelMediaExportSqlFunctionClass RygelMediaExportSqlFunctionClass;

typedef enum  {
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_SQLITE_ERROR,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_INVALID_TYPE,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_UNSUPPORTED_SEARCH
} RygelMediaExportMediaCacheError;
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR rygel_media_export_media_cache_error_quark ()
typedef enum  {
	RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER,
	RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM
} RygelMediaExportObjectType;

struct _RygelMediaExportExistsCacheEntry {
	gint64 mtime;
	gint64 size;
};

struct _RygelMediaExportMediaCache {
	GObject parent_instance;
	RygelMediaExportMediaCachePrivate * priv;
};

struct _RygelMediaExportMediaCacheClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportMediaCachePrivate {
	RygelMediaExportDatabase* db;
	RygelMediaExportObjectFactory* factory;
	RygelMediaExportSQLFactory* sql;
	GeeHashMap* exists_cache;
};

typedef enum  {
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_IO_ERROR,
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR
} RygelMediaExportDatabaseError;
#define RYGEL_MEDIA_EXPORT_DATABASE_ERROR rygel_media_export_database_error_quark ()
typedef enum  {
	RYGEL_MEDIA_EXPORT_SQL_STRING_SAVE_METADATA,
	RYGEL_MEDIA_EXPORT_SQL_STRING_INSERT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_DELETE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_CHILDREN,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECTS_BY_FILTER,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT_COUNT_BY_FILTER,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_META_DATA_COLUMN,
	RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_COUNT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS,
	RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_IDS,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_METADATA,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_CLOSURE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_CLOSURE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_COMMON,
	RYGEL_MEDIA_EXPORT_SQL_STRING_INDEX_COMMON,
	RYGEL_MEDIA_EXPORT_SQL_STRING_SCHEMA,
	RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS_CACHE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_STATISTICS
} RygelMediaExportSQLString;

typedef enum  {
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TYPE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TITLE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_SIZE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_MIME_TYPE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_WIDTH,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_HEIGHT,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CLASS,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_AUTHOR,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ALBUM,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DATE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_BITRATE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_SAMPLE_FREQ,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_BITS_PER_SAMPLE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CHANNELS,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TRACK,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_COLOR_DEPTH,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DURATION,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ID,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_PARENT,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TIMESTAMP,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_URI,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DLNA_PROFILE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_GENRE
} RygelMediaExportDetailColumn;


static gpointer rygel_media_export_media_cache_parent_class = NULL;
static RygelMediaExportMediaCache* rygel_media_export_media_cache_instance;
static RygelMediaExportMediaCache* rygel_media_export_media_cache_instance = NULL;

GQuark rygel_media_export_media_cache_error_quark (void);
GType rygel_media_export_object_type_get_type (void) G_GNUC_CONST;
GType rygel_media_export_exists_cache_entry_get_type (void) G_GNUC_CONST;
RygelMediaExportExistsCacheEntry* rygel_media_export_exists_cache_entry_dup (const RygelMediaExportExistsCacheEntry* self);
void rygel_media_export_exists_cache_entry_free (RygelMediaExportExistsCacheEntry* self);
GType rygel_media_export_media_cache_get_type (void) G_GNUC_CONST;
GType rygel_media_export_sqlite_wrapper_get_type (void) G_GNUC_CONST;
GType rygel_media_export_database_get_type (void) G_GNUC_CONST;
GType rygel_media_export_object_factory_get_type (void) G_GNUC_CONST;
GType rygel_media_export_sql_factory_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCachePrivate))
enum  {
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_DUMMY_PROPERTY
};
static RygelMediaExportMediaCache* rygel_media_export_media_cache_new (GError** error);
static RygelMediaExportMediaCache* rygel_media_export_media_cache_construct (GType object_type, GError** error);
RygelMediaExportSQLFactory* rygel_media_export_sql_factory_new (void);
RygelMediaExportSQLFactory* rygel_media_export_sql_factory_construct (GType object_type);
static void rygel_media_export_media_cache_open_db (RygelMediaExportMediaCache* self, const gchar* name, GError** error);
RygelMediaExportObjectFactory* rygel_media_export_object_factory_new (void);
RygelMediaExportObjectFactory* rygel_media_export_object_factory_construct (GType object_type);
GQuark rygel_media_export_database_error_quark (void);
static void rygel_media_export_media_cache_get_exists_cache (RygelMediaExportMediaCache* self, GError** error);
gchar* rygel_media_export_media_cache_get_id (GFile* file);
RygelMediaExportMediaCache* rygel_media_export_media_cache_get_default (GError** error);
void rygel_media_export_media_cache_remove_by_id (RygelMediaExportMediaCache* self, const gchar* id, GError** error);
void rygel_media_export_database_exec (RygelMediaExportDatabase* self, const gchar* sql, GValue* arguments, int arguments_length1, GError** error);
GType rygel_media_export_sql_string_get_type (void) G_GNUC_CONST;
const gchar* rygel_media_export_sql_factory_make (RygelMediaExportSQLFactory* self, RygelMediaExportSQLString query);
static void _vala_GValue_array_free (GValue* array, gint array_length);
void rygel_media_export_media_cache_remove_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, GError** error);
void rygel_media_export_media_cache_save_container (RygelMediaExportMediaCache* self, RygelMediaContainer* container, GError** error);
void rygel_media_export_database_begin (RygelMediaExportDatabase* self, GError** error);
static void rygel_media_export_media_cache_create_object (RygelMediaExportMediaCache* self, RygelMediaObject* item, GError** error);
void rygel_media_export_database_commit (RygelMediaExportDatabase* self, GError** error);
void rygel_media_export_database_rollback (RygelMediaExportDatabase* self);
void rygel_media_export_media_cache_save_item (RygelMediaExportMediaCache* self, RygelMediaItem* item, GError** error);
static void rygel_media_export_media_cache_save_metadata (RygelMediaExportMediaCache* self, RygelMediaItem* item, GError** error);
RygelMediaObject* rygel_media_export_media_cache_get_object (RygelMediaExportMediaCache* self, const gchar* object_id, GError** error);
GType rygel_media_export_database_cursor_get_type (void) G_GNUC_CONST;
static RygelMediaExportDatabaseCursor* rygel_media_export_media_cache_exec_cursor (RygelMediaExportMediaCache* self, RygelMediaExportSQLString id, GValue* values, int values_length1, GError** error);
gpointer rygel_media_export_database_cursor_iterator_ref (gpointer instance);
void rygel_media_export_database_cursor_iterator_unref (gpointer instance);
GParamSpec* rygel_media_export_database_cursor_param_spec_iterator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_media_export_database_cursor_value_set_iterator (GValue* value, gpointer v_object);
void rygel_media_export_database_cursor_value_take_iterator (GValue* value, gpointer v_object);
gpointer rygel_media_export_database_cursor_value_get_iterator (const GValue* value);
GType rygel_media_export_database_cursor_iterator_get_type (void) G_GNUC_CONST;
RygelMediaExportDatabaseCursorIterator* rygel_media_export_database_cursor_iterator (RygelMediaExportDatabaseCursor* self);
gboolean rygel_media_export_database_cursor_iterator_next (RygelMediaExportDatabaseCursorIterator* self);
sqlite3_stmt* rygel_media_export_database_cursor_iterator_get (RygelMediaExportDatabaseCursorIterator* self, GError** error);
static RygelMediaObject* rygel_media_export_media_cache_get_object_from_statement (RygelMediaExportMediaCache* self, RygelMediaContainer* parent, sqlite3_stmt* statement);
RygelMediaContainer* rygel_media_export_media_cache_get_container (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error);
gint rygel_media_export_media_cache_get_child_count (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error);
static gint rygel_media_export_media_cache_query_value (RygelMediaExportMediaCache* self, RygelMediaExportSQLString id, GValue* values, int values_length1, GError** error);
gboolean rygel_media_export_media_cache_exists (RygelMediaExportMediaCache* self, GFile* file, gint64* timestamp, gint64* size, GError** error);
sqlite3_stmt* rygel_media_export_database_cursor_next (RygelMediaExportDatabaseCursor* self, GError** error);
RygelMediaObjects* rygel_media_export_media_cache_get_children (RygelMediaExportMediaCache* self, RygelMediaContainer* container, glong offset, glong max_count, GError** error);
RygelMediaObjects* rygel_media_export_media_cache_get_objects_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const gchar* container_id, guint offset, guint max_count, guint* total_matches, GError** error);
static gchar* rygel_media_export_media_cache_translate_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, GValueArray* args, const gchar* prefix, GError** error);
static guint rygel_media_export_media_cache_modify_limit (RygelMediaExportMediaCache* self, guint max_count);
glong rygel_media_export_media_cache_get_object_count_by_filter (RygelMediaExportMediaCache* self, const gchar* filter, GValueArray* args, const gchar* container_id, GError** error);
RygelMediaObjects* rygel_media_export_media_cache_get_objects_by_filter (RygelMediaExportMediaCache* self, const gchar* filter, GValueArray* args, const gchar* container_id, glong offset, glong max_count, GError** error);
glong rygel_media_export_media_cache_get_object_count_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const gchar* container_id, GError** error);
gint rygel_media_export_database_query_value (RygelMediaExportDatabase* self, const gchar* sql, GValue* args, int args_length1, GError** error);
RygelMediaExportDatabaseCursor* rygel_media_export_database_exec_cursor (RygelMediaExportDatabase* self, const gchar* sql, GValue* arguments, int arguments_length1, GError** error);
GType rygel_media_export_detail_column_get_type (void) G_GNUC_CONST;
RygelNullContainer* rygel_null_container_new (void);
RygelNullContainer* rygel_null_container_construct (GType object_type);
GType rygel_null_container_get_type (void) G_GNUC_CONST;
void rygel_media_export_media_cache_debug_statistics (RygelMediaExportMediaCache* self);
GeeArrayList* rygel_media_export_media_cache_get_child_ids (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error);
GeeList* rygel_media_export_media_cache_get_meta_data_column_by_filter (RygelMediaExportMediaCache* self, const gchar* column, const gchar* filter, GValueArray* args, glong offset, glong max_count, GError** error);
GeeList* rygel_media_export_media_cache_get_object_attribute_by_search_expression (RygelMediaExportMediaCache* self, const gchar* attribute, RygelSearchExpression* expression, glong offset, guint max_count, GError** error);
static gchar* rygel_media_export_media_cache_map_operand_to_column (RygelMediaExportMediaCache* self, const gchar* operand, gchar** collate, GError** error);
void rygel_media_export_media_cache_flag_object (RygelMediaExportMediaCache* self, GFile* file, const gchar* flag, GError** error);
GeeList* rygel_media_export_media_cache_get_flagged_uris (RygelMediaExportMediaCache* self, const gchar* flag, GError** error);
RygelMediaExportDatabase* rygel_media_export_database_new (const gchar* name, GError** error);
RygelMediaExportDatabase* rygel_media_export_database_construct (GType object_type, const gchar* name, GError** error);
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY_schema_version "10"
RygelMediaExportMediaCacheUpgrader* rygel_media_export_media_cache_upgrader_new (RygelMediaExportDatabase* database, RygelMediaExportSQLFactory* sql);
RygelMediaExportMediaCacheUpgrader* rygel_media_export_media_cache_upgrader_construct (GType object_type, RygelMediaExportDatabase* database, RygelMediaExportSQLFactory* sql);
gpointer rygel_media_export_media_cache_upgrader_ref (gpointer instance);
void rygel_media_export_media_cache_upgrader_unref (gpointer instance);
GParamSpec* rygel_media_export_param_spec_media_cache_upgrader (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_media_export_value_set_media_cache_upgrader (GValue* value, gpointer v_object);
void rygel_media_export_value_take_media_cache_upgrader (GValue* value, gpointer v_object);
gpointer rygel_media_export_value_get_media_cache_upgrader (const GValue* value);
GType rygel_media_export_media_cache_upgrader_get_type (void) G_GNUC_CONST;
gboolean rygel_media_export_media_cache_upgrader_needs_upgrade (RygelMediaExportMediaCacheUpgrader* self, gint* current_version, GError** error);
void rygel_media_export_media_cache_upgrader_upgrade (RygelMediaExportMediaCacheUpgrader* self, gint old_version);
void rygel_media_export_media_cache_upgrader_fix_schema (RygelMediaExportMediaCacheUpgrader* self, GError** error);
void rygel_media_export_media_cache_upgrader_ensure_indices (RygelMediaExportMediaCacheUpgrader* self);
static gboolean rygel_media_export_media_cache_create_schema (RygelMediaExportMediaCache* self);
void rygel_media_export_database_null (GValue* result);
void rygel_media_export_database_analyze (RygelMediaExportDatabase* self);
GType rygel_media_export_db_container_get_type (void) G_GNUC_CONST;
RygelMediaExportDBContainer* rygel_media_export_object_factory_get_container (RygelMediaExportObjectFactory* self, RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* title, guint child_count, const gchar* uri);
RygelMediaItem* rygel_media_export_object_factory_get_item (RygelMediaExportObjectFactory* self, RygelMediaExportMediaCache* media_db, RygelMediaContainer* parent, const gchar* id, const gchar* title, const gchar* upnp_class);
static void rygel_media_export_media_cache_fill_item (RygelMediaExportMediaCache* self, sqlite3_stmt* statement, RygelMediaItem* item);
static gchar* rygel_media_export_media_cache_search_expression_to_sql (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, GValueArray* args, GError** error);
static gchar* rygel_media_export_media_cache_logical_expression_to_sql (RygelMediaExportMediaCache* self, RygelLogicalExpression* expression, GValueArray* args, GError** error);
static gchar* rygel_media_export_media_cache_relational_expression_to_sql (RygelMediaExportMediaCache* self, RygelRelationalExpression* exp, GValueArray* args, GError** error);
static void _vala_GValue_free (GValue* self);
GType rygel_media_export_sql_operator_get_type (void) G_GNUC_CONST;
RygelMediaExportSqlOperator* rygel_media_export_sql_operator_new_from_search_criteria_op (GUPnPSearchCriteriaOp op, const gchar* arg, const gchar* collate);
RygelMediaExportSqlOperator* rygel_media_export_sql_operator_construct_from_search_criteria_op (GType object_type, GUPnPSearchCriteriaOp op, const gchar* arg, const gchar* collate);
RygelMediaExportSqlFunction* rygel_media_export_sql_function_new (const gchar* name, const gchar* arg);
RygelMediaExportSqlFunction* rygel_media_export_sql_function_construct (GType object_type, const gchar* name, const gchar* arg);
GType rygel_media_export_sql_function_get_type (void) G_GNUC_CONST;
RygelMediaExportSqlOperator* rygel_media_export_sql_operator_new (const gchar* name, const gchar* arg, const gchar* collate);
RygelMediaExportSqlOperator* rygel_media_export_sql_operator_construct (GType object_type, const gchar* name, const gchar* arg, const gchar* collate);
gchar* rygel_media_export_sql_operator_to_string (RygelMediaExportSqlOperator* self);
static void rygel_media_export_media_cache_finalize (GObject* obj);


GQuark rygel_media_export_media_cache_error_quark (void) {
	return g_quark_from_static_string ("rygel_media_export_media_cache_error-quark");
}


GType rygel_media_export_object_type_get_type (void) {
	static volatile gsize rygel_media_export_object_type_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_object_type_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER, "RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER", "container"}, {RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM, "RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM", "item"}, {0, NULL, NULL}};
		GType rygel_media_export_object_type_type_id;
		rygel_media_export_object_type_type_id = g_enum_register_static ("RygelMediaExportObjectType", values);
		g_once_init_leave (&rygel_media_export_object_type_type_id__volatile, rygel_media_export_object_type_type_id);
	}
	return rygel_media_export_object_type_type_id__volatile;
}


RygelMediaExportExistsCacheEntry* rygel_media_export_exists_cache_entry_dup (const RygelMediaExportExistsCacheEntry* self) {
	RygelMediaExportExistsCacheEntry* dup;
#line 40 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	dup = g_new0 (RygelMediaExportExistsCacheEntry, 1);
#line 40 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	memcpy (dup, self, sizeof (RygelMediaExportExistsCacheEntry));
#line 40 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return dup;
#line 409 "rygel-media-export-media-cache.c"
}


void rygel_media_export_exists_cache_entry_free (RygelMediaExportExistsCacheEntry* self) {
#line 40 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_free (self);
#line 416 "rygel-media-export-media-cache.c"
}


GType rygel_media_export_exists_cache_entry_get_type (void) {
	static volatile gsize rygel_media_export_exists_cache_entry_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_exists_cache_entry_type_id__volatile)) {
		GType rygel_media_export_exists_cache_entry_type_id;
		rygel_media_export_exists_cache_entry_type_id = g_boxed_type_register_static ("RygelMediaExportExistsCacheEntry", (GBoxedCopyFunc) rygel_media_export_exists_cache_entry_dup, (GBoxedFreeFunc) rygel_media_export_exists_cache_entry_free);
		g_once_init_leave (&rygel_media_export_exists_cache_entry_type_id__volatile, rygel_media_export_exists_cache_entry_type_id);
	}
	return rygel_media_export_exists_cache_entry_type_id__volatile;
}


static RygelMediaExportMediaCache* rygel_media_export_media_cache_construct (GType object_type, GError** error) {
	RygelMediaExportMediaCache * self = NULL;
	RygelMediaExportSQLFactory* _tmp0_;
	RygelMediaExportObjectFactory* _tmp1_;
	GError * _inner_error_ = NULL;
#line 61 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	self = (RygelMediaExportMediaCache*) g_object_new (object_type, NULL);
#line 62 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = rygel_media_export_sql_factory_new ();
#line 62 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (self->priv->sql);
#line 62 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	self->priv->sql = _tmp0_;
#line 63 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_media_cache_open_db (self, "media-export", &_inner_error_);
#line 63 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 63 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 63 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (self);
#line 63 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 454 "rygel-media-export-media-cache.c"
	}
#line 64 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = rygel_media_export_object_factory_new ();
#line 64 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (self->priv->factory);
#line 64 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	self->priv->factory = _tmp1_;
#line 65 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_media_cache_get_exists_cache (self, &_inner_error_);
#line 65 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 65 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 65 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (self);
#line 65 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 472 "rygel-media-export-media-cache.c"
	}
#line 61 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return self;
#line 476 "rygel-media-export-media-cache.c"
}


static RygelMediaExportMediaCache* rygel_media_export_media_cache_new (GError** error) {
#line 61 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return rygel_media_export_media_cache_construct (RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, error);
#line 483 "rygel-media-export-media-cache.c"
}


gchar* rygel_media_export_media_cache_get_id (GFile* file) {
	gchar* result = NULL;
	GFile* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
#line 69 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = file;
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = g_file_get_uri (_tmp0_);
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = _tmp1_;
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp2_, (gsize) (-1));
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = _tmp3_;
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (_tmp2_);
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp4_;
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 512 "rygel-media-export-media-cache.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 79 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return self ? g_object_ref (self) : NULL;
#line 519 "rygel-media-export-media-cache.c"
}


RygelMediaExportMediaCache* rygel_media_export_media_cache_get_default (GError** error) {
	RygelMediaExportMediaCache* result = NULL;
	RygelMediaExportMediaCache* _tmp0_;
	RygelMediaExportMediaCache* _tmp3_;
	RygelMediaExportMediaCache* _tmp4_;
	GError * _inner_error_ = NULL;
#line 75 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = rygel_media_export_media_cache_instance;
#line 75 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp0_ == NULL) {
#line 533 "rygel-media-export-media-cache.c"
		RygelMediaExportMediaCache* _tmp1_;
		RygelMediaExportMediaCache* _tmp2_;
#line 76 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp1_ = rygel_media_export_media_cache_new (&_inner_error_);
#line 76 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp2_ = _tmp1_;
#line 76 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 76 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 76 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 546 "rygel-media-export-media-cache.c"
		}
#line 76 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (rygel_media_export_media_cache_instance);
#line 76 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_media_cache_instance = _tmp2_;
#line 552 "rygel-media-export-media-cache.c"
	}
#line 79 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = rygel_media_export_media_cache_instance;
#line 79 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 79 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp4_;
#line 79 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 562 "rygel-media-export-media-cache.c"
}


static void _vala_GValue_array_free (GValue* array, gint array_length) {
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (array != NULL) {
#line 569 "rygel-media-export-media-cache.c"
		int i;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_unset (&array[i]);
#line 575 "rygel-media-export-media-cache.c"
		}
	}
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_free (array);
#line 580 "rygel-media-export-media-cache.c"
}


void rygel_media_export_media_cache_remove_by_id (RygelMediaExportMediaCache* self, const gchar* id, GError** error) {
	const gchar* _tmp0_;
	GValue _tmp1_ = {0};
	GValue* _tmp2_ = NULL;
	GValue* values;
	gint values_length1;
	gint _values_size_;
	RygelMediaExportDatabase* _tmp3_;
	RygelMediaExportSQLFactory* _tmp4_;
	const gchar* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 83 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 83 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (id != NULL);
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = id;
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp1_, G_TYPE_STRING);
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp1_, _tmp0_);
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = g_new0 (GValue, 1);
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_[0] = _tmp1_;
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = _tmp2_;
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values_length1 = 1;
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_values_size_ = values_length1;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = self->priv->db;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = self->priv->sql;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = rygel_media_export_sql_factory_make (_tmp4_, RYGEL_MEDIA_EXPORT_SQL_STRING_DELETE);
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (_tmp3_, _tmp5_, values, values_length1, &_inner_error_);
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 633 "rygel-media-export-media-cache.c"
		} else {
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 643 "rygel-media-export-media-cache.c"
		}
	}
#line 83 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 648 "rygel-media-export-media-cache.c"
}


void rygel_media_export_media_cache_remove_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, GError** error) {
	RygelMediaObject* _tmp0_;
	const gchar* _tmp1_;
	GError * _inner_error_ = NULL;
#line 88 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 88 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (object != NULL);
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = object;
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = _tmp0_->id;
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_media_cache_remove_by_id (self, _tmp1_, &_inner_error_);
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if ((_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR)) {
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 674 "rygel-media-export-media-cache.c"
		} else {
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 682 "rygel-media-export-media-cache.c"
		}
	}
}


static gpointer _g_error_copy0 (gpointer self) {
#line 101 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return self ? g_error_copy (self) : NULL;
#line 691 "rygel-media-export-media-cache.c"
}


void rygel_media_export_media_cache_save_container (RygelMediaExportMediaCache* self, RygelMediaContainer* container, GError** error) {
	GError * _inner_error_ = NULL;
#line 93 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 93 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (container != NULL);
#line 701 "rygel-media-export-media-cache.c"
	{
		RygelMediaExportDatabase* _tmp0_;
		RygelMediaContainer* _tmp1_;
		RygelMediaExportDatabase* _tmp2_;
#line 95 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp0_ = self->priv->db;
#line 95 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_begin (_tmp0_, &_inner_error_);
#line 95 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 95 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 714 "rygel-media-export-media-cache.c"
				goto __catch5_rygel_media_export_database_error;
			}
#line 95 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 95 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 95 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 723 "rygel-media-export-media-cache.c"
		}
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp1_ = container;
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_media_cache_create_object (self, (RygelMediaObject*) _tmp1_, &_inner_error_);
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 733 "rygel-media-export-media-cache.c"
				goto __catch5_rygel_media_export_database_error;
			}
			goto __finally5;
		}
#line 97 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp2_ = self->priv->db;
#line 97 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_commit (_tmp2_, &_inner_error_);
#line 97 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 97 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 746 "rygel-media-export-media-cache.c"
				goto __catch5_rygel_media_export_database_error;
			}
#line 97 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 97 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 97 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 755 "rygel-media-export-media-cache.c"
		}
	}
	goto __finally5;
	__catch5_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		RygelMediaExportDatabase* _tmp3_;
		GError* _tmp4_;
		GError* _tmp5_;
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_error_ = _inner_error_;
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = NULL;
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp3_ = self->priv->db;
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_rollback (_tmp3_);
#line 101 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4_ = _error_;
#line 101 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = _g_error_copy0 (_tmp4_);
#line 101 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = _tmp5_;
#line 101 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_error_free0 (_error_);
#line 781 "rygel-media-export-media-cache.c"
		goto __finally5;
	}
	__finally5:
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return;
#line 791 "rygel-media-export-media-cache.c"
	}
}


void rygel_media_export_media_cache_save_item (RygelMediaExportMediaCache* self, RygelMediaItem* item, GError** error) {
	GError * _inner_error_ = NULL;
#line 105 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 105 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (item != NULL);
#line 802 "rygel-media-export-media-cache.c"
	{
		RygelMediaExportDatabase* _tmp0_;
		RygelMediaItem* _tmp1_;
		RygelMediaItem* _tmp2_;
		RygelMediaExportDatabase* _tmp3_;
#line 107 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp0_ = self->priv->db;
#line 107 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_begin (_tmp0_, &_inner_error_);
#line 107 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 107 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 816 "rygel-media-export-media-cache.c"
				goto __catch6_rygel_media_export_database_error;
			}
#line 107 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 107 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 107 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 825 "rygel-media-export-media-cache.c"
		}
#line 108 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp1_ = item;
#line 108 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_media_cache_save_metadata (self, _tmp1_, &_inner_error_);
#line 108 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 108 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 835 "rygel-media-export-media-cache.c"
				goto __catch6_rygel_media_export_database_error;
			}
			goto __finally6;
		}
#line 109 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp2_ = item;
#line 109 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_media_cache_create_object (self, (RygelMediaObject*) _tmp2_, &_inner_error_);
#line 109 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 109 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 848 "rygel-media-export-media-cache.c"
				goto __catch6_rygel_media_export_database_error;
			}
			goto __finally6;
		}
#line 110 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp3_ = self->priv->db;
#line 110 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_commit (_tmp3_, &_inner_error_);
#line 110 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 110 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 861 "rygel-media-export-media-cache.c"
				goto __catch6_rygel_media_export_database_error;
			}
#line 110 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 110 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 110 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 870 "rygel-media-export-media-cache.c"
		}
	}
	goto __finally6;
	__catch6_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp4_ = NULL;
		RygelMediaItem* _tmp5_;
		const gchar* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		RygelMediaExportDatabase* _tmp9_;
		GError* _tmp10_;
		GError* _tmp11_;
#line 106 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_error_ = _inner_error_;
#line 106 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = NULL;
#line 112 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4_ = _ ("Failed to add item with ID %s: %s");
#line 112 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = item;
#line 112 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = ((RygelMediaObject*) _tmp5_)->id;
#line 112 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_ = _error_;
#line 112 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp8_ = _tmp7_->message;
#line 112 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_warning (_tmp4_, _tmp6_, _tmp8_);
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp9_ = self->priv->db;
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_rollback (_tmp9_);
#line 117 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp10_ = _error_;
#line 117 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp11_ = _g_error_copy0 (_tmp10_);
#line 117 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = _tmp11_;
#line 117 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_error_free0 (_error_);
#line 913 "rygel-media-export-media-cache.c"
		goto __finally6;
	}
	__finally6:
#line 106 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 106 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 106 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return;
#line 923 "rygel-media-export-media-cache.c"
	}
}


RygelMediaObject* rygel_media_export_media_cache_get_object (RygelMediaExportMediaCache* self, const gchar* object_id, GError** error) {
	RygelMediaObject* result = NULL;
	const gchar* _tmp0_;
	GValue _tmp1_ = {0};
	GValue* _tmp2_ = NULL;
	GValue* values;
	gint values_length1;
	gint _values_size_;
	RygelMediaObject* parent;
	GValue* _tmp3_;
	gint _tmp3__length1;
	RygelMediaExportDatabaseCursor* _tmp4_ = NULL;
	RygelMediaExportDatabaseCursor* cursor;
	GError * _inner_error_ = NULL;
#line 121 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 121 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (object_id != NULL, NULL);
#line 122 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = object_id;
#line 122 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp1_, G_TYPE_STRING);
#line 122 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp1_, _tmp0_);
#line 122 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = g_new0 (GValue, 1);
#line 122 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_[0] = _tmp1_;
#line 122 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = _tmp2_;
#line 122 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values_length1 = 1;
#line 122 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_values_size_ = values_length1;
#line 123 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	parent = NULL;
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = values;
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3__length1 = values_length1;
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT, _tmp3_, _tmp3__length1, &_inner_error_);
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	cursor = _tmp4_;
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (parent);
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 984 "rygel-media-export-media-cache.c"
		} else {
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (parent);
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 996 "rygel-media-export-media-cache.c"
		}
	}
	{
		RygelMediaExportDatabaseCursor* _tmp5_;
		RygelMediaExportDatabaseCursorIterator* _tmp6_ = NULL;
		RygelMediaExportDatabaseCursorIterator* _statement_it;
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = cursor;
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = rygel_media_export_database_cursor_iterator (_tmp5_);
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_statement_it = _tmp6_;
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		while (TRUE) {
#line 1011 "rygel-media-export-media-cache.c"
			RygelMediaExportDatabaseCursorIterator* _tmp7_;
			gboolean _tmp8_ = FALSE;
			RygelMediaExportDatabaseCursorIterator* _tmp9_;
			sqlite3_stmt* _tmp10_ = NULL;
			sqlite3_stmt* statement;
			RygelMediaObject* _tmp11_;
			RygelMediaContainer* _tmp12_;
			RygelMediaContainer* parent_container;
			RygelMediaContainer* _tmp13_;
			sqlite3_stmt* _tmp14_;
			RygelMediaObject* _tmp15_ = NULL;
			RygelMediaObject* object;
			RygelMediaObject* _tmp16_;
			RygelMediaContainer* _tmp17_;
			RygelMediaObject* _tmp18_;
			RygelMediaObject* _tmp19_;
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp7_ = _statement_it;
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp8_ = rygel_media_export_database_cursor_iterator_next (_tmp7_);
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (!_tmp8_) {
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 1036 "rygel-media-export-media-cache.c"
			}
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp9_ = _statement_it;
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp10_ = rygel_media_export_database_cursor_iterator_get (_tmp9_, &_inner_error_);
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			statement = _tmp10_;
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_ != NULL) {
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_propagate_error (error, _inner_error_);
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (cursor);
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (parent);
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					return NULL;
#line 1060 "rygel-media-export-media-cache.c"
				} else {
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (cursor);
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (parent);
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_clear_error (&_inner_error_);
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					return NULL;
#line 1076 "rygel-media-export-media-cache.c"
				}
			}
#line 128 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp11_ = parent;
#line 128 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp12_ = _g_object_ref0 (RYGEL_IS_MEDIA_CONTAINER (_tmp11_) ? ((RygelMediaContainer*) _tmp11_) : NULL);
#line 128 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			parent_container = _tmp12_;
#line 129 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp13_ = parent_container;
#line 129 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp14_ = statement;
#line 129 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp15_ = rygel_media_export_media_cache_get_object_from_statement (self, _tmp13_, _tmp14_);
#line 129 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			object = _tmp15_;
#line 132 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp16_ = object;
#line 132 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp17_ = parent_container;
#line 132 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			rygel_media_object_set_parent_ref (_tmp16_, _tmp17_);
#line 133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp18_ = object;
#line 133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp19_ = _g_object_ref0 (_tmp18_);
#line 133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (parent);
#line 133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			parent = _tmp19_;
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (object);
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (parent_container);
#line 1111 "rygel-media-export-media-cache.c"
		}
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 1115 "rygel-media-export-media-cache.c"
	}
#line 136 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = parent;
#line 136 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (cursor);
#line 136 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 136 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 1125 "rygel-media-export-media-cache.c"
}


RygelMediaContainer* rygel_media_export_media_cache_get_container (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error) {
	RygelMediaContainer* result = NULL;
	const gchar* _tmp0_;
	RygelMediaObject* _tmp1_ = NULL;
	RygelMediaObject* object;
	gboolean _tmp2_ = FALSE;
	RygelMediaObject* _tmp3_;
	gboolean _tmp5_;
	RygelMediaObject* _tmp8_;
	RygelMediaContainer* _tmp9_;
	GError * _inner_error_ = NULL;
#line 139 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 139 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (container_id != NULL, NULL);
#line 142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = container_id;
#line 142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = rygel_media_export_media_cache_get_object (self, _tmp0_, &_inner_error_);
#line 142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	object = _tmp1_;
#line 142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if ((_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR)) {
#line 142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 1158 "rygel-media-export-media-cache.c"
		} else {
#line 142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 1166 "rygel-media-export-media-cache.c"
		}
	}
#line 143 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = object;
#line 143 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp3_ != NULL) {
#line 1173 "rygel-media-export-media-cache.c"
		RygelMediaObject* _tmp4_;
#line 143 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4_ = object;
#line 143 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp2_ = !RYGEL_IS_MEDIA_CONTAINER (_tmp4_);
#line 1179 "rygel-media-export-media-cache.c"
	} else {
#line 143 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp2_ = FALSE;
#line 1183 "rygel-media-export-media-cache.c"
	}
#line 143 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = _tmp2_;
#line 143 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp5_) {
#line 1189 "rygel-media-export-media-cache.c"
		const gchar* _tmp6_;
		GError* _tmp7_;
#line 144 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = container_id;
#line 144 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_ = g_error_new (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_INVALID_TYPE, "Object with id %s is " "not a MediaContainer", _tmp6_);
#line 144 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = _tmp7_;
#line 144 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if ((_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR)) {
#line 144 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 144 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (object);
#line 144 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 1206 "rygel-media-export-media-cache.c"
		} else {
#line 144 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (object);
#line 144 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 144 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 144 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 1216 "rygel-media-export-media-cache.c"
		}
	}
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp8_ = object;
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_ = _g_object_ref0 (RYGEL_IS_MEDIA_CONTAINER (_tmp8_) ? ((RygelMediaContainer*) _tmp8_) : NULL);
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp9_;
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (object);
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 1229 "rygel-media-export-media-cache.c"
}


gint rygel_media_export_media_cache_get_child_count (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error) {
	gint result = 0;
	const gchar* _tmp0_;
	GValue _tmp1_ = {0};
	GValue* _tmp2_ = NULL;
	GValue* values;
	gint values_length1;
	gint _values_size_;
	gint _tmp3_ = 0;
	gint _tmp4_;
	GError * _inner_error_ = NULL;
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (container_id != NULL, 0);
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = container_id;
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp1_, G_TYPE_STRING);
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp1_, _tmp0_);
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = g_new0 (GValue, 1);
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_[0] = _tmp1_;
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = _tmp2_;
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values_length1 = 1;
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_values_size_ = values_length1;
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = rygel_media_export_media_cache_query_value (self, RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_COUNT, values, values_length1, &_inner_error_);
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = _tmp3_;
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return 0;
#line 1278 "rygel-media-export-media-cache.c"
		} else {
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return 0;
#line 1288 "rygel-media-export-media-cache.c"
		}
	}
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp4_;
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 1297 "rygel-media-export-media-cache.c"
}


gboolean rygel_media_export_media_cache_exists (RygelMediaExportMediaCache* self, GFile* file, gint64* timestamp, gint64* size, GError** error) {
	gint64 _vala_timestamp = 0LL;
	gint64 _vala_size = 0LL;
	gboolean result = FALSE;
	GFile* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* uri;
	const gchar* _tmp2_;
	GValue _tmp3_ = {0};
	GValue* _tmp4_ = NULL;
	GValue* values;
	gint values_length1;
	gint _values_size_;
	GeeHashMap* _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GValue* _tmp17_;
	gint _tmp17__length1;
	RygelMediaExportDatabaseCursor* _tmp18_ = NULL;
	RygelMediaExportDatabaseCursor* cursor;
	RygelMediaExportDatabaseCursor* _tmp19_;
	sqlite3_stmt* _tmp20_ = NULL;
	sqlite3_stmt* statement;
	sqlite3_stmt* _tmp21_;
	gint64 _tmp22_ = 0LL;
	sqlite3_stmt* _tmp23_;
	gint64 _tmp24_ = 0LL;
	sqlite3_stmt* _tmp25_;
	gint _tmp26_ = 0;
	GError * _inner_error_ = NULL;
#line 159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (file != NULL, FALSE);
#line 162 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = file;
#line 162 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = g_file_get_uri (_tmp0_);
#line 162 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	uri = _tmp1_;
#line 163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = uri;
#line 163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp3_, G_TYPE_STRING);
#line 163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp3_, _tmp2_);
#line 163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = g_new0 (GValue, 1);
#line 163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_[0] = _tmp3_;
#line 163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = _tmp4_;
#line 163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values_length1 = 1;
#line 163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_values_size_ = values_length1;
#line 165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = self->priv->exists_cache;
#line 165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = uri;
#line 165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp5_, _tmp6_);
#line 165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp7_) {
#line 1365 "rygel-media-export-media-cache.c"
		GeeHashMap* _tmp8_;
		const gchar* _tmp9_;
		gpointer _tmp10_ = NULL;
		RygelMediaExportExistsCacheEntry* entry;
		GeeHashMap* _tmp11_;
		const gchar* _tmp12_;
		RygelMediaExportExistsCacheEntry* _tmp13_;
		gint64 _tmp14_;
		RygelMediaExportExistsCacheEntry* _tmp15_;
		gint64 _tmp16_;
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp8_ = self->priv->exists_cache;
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp9_ = uri;
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp10_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp8_, _tmp9_);
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		entry = (RygelMediaExportExistsCacheEntry*) _tmp10_;
#line 167 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp11_ = self->priv->exists_cache;
#line 167 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp12_ = uri;
#line 167 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp11_, _tmp12_, NULL);
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp13_ = entry;
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp14_ = (*_tmp13_).mtime;
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_vala_timestamp = _tmp14_;
#line 169 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp15_ = entry;
#line 169 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp16_ = (*_tmp15_).size;
#line 169 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_vala_size = _tmp16_;
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		result = TRUE;
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_rygel_media_export_exists_cache_entry_free0 (entry);
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (uri);
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (timestamp) {
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			*timestamp = _vala_timestamp;
#line 1414 "rygel-media-export-media-cache.c"
		}
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (size) {
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			*size = _vala_size;
#line 1420 "rygel-media-export-media-cache.c"
		}
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return result;
#line 1424 "rygel-media-export-media-cache.c"
	}
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp17_ = values;
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp17__length1 = values_length1;
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp18_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS, _tmp17_, _tmp17__length1, &_inner_error_);
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	cursor = _tmp18_;
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (uri);
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return FALSE;
#line 1446 "rygel-media-export-media-cache.c"
		} else {
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (uri);
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return FALSE;
#line 1458 "rygel-media-export-media-cache.c"
		}
	}
#line 175 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp19_ = cursor;
#line 175 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp20_ = rygel_media_export_database_cursor_next (_tmp19_, &_inner_error_);
#line 175 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	statement = _tmp20_;
#line 175 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 175 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 175 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 175 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (cursor);
#line 175 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 175 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (uri);
#line 175 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return FALSE;
#line 1481 "rygel-media-export-media-cache.c"
		} else {
#line 175 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (cursor);
#line 175 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 175 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (uri);
#line 175 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 175 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 175 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return FALSE;
#line 1495 "rygel-media-export-media-cache.c"
		}
	}
#line 176 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp21_ = statement;
#line 176 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp22_ = sqlite3_column_int64 (_tmp21_, 1);
#line 176 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_vala_timestamp = _tmp22_;
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp23_ = statement;
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp24_ = sqlite3_column_int64 (_tmp23_, 2);
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_vala_size = _tmp24_;
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp25_ = statement;
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_ = sqlite3_column_int (_tmp25_, 0);
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp26_ == 1;
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (cursor);
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (uri);
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (timestamp) {
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		*timestamp = _vala_timestamp;
#line 1526 "rygel-media-export-media-cache.c"
	}
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (size) {
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		*size = _vala_size;
#line 1532 "rygel-media-export-media-cache.c"
	}
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 1536 "rygel-media-export-media-cache.c"
}


RygelMediaObjects* rygel_media_export_media_cache_get_children (RygelMediaExportMediaCache* self, RygelMediaContainer* container, glong offset, glong max_count, GError** error) {
	RygelMediaObjects* result = NULL;
	RygelMediaObjects* _tmp0_;
	RygelMediaObjects* children;
	RygelMediaContainer* _tmp1_;
	const gchar* _tmp2_;
	GValue _tmp3_ = {0};
	glong _tmp4_;
	GValue _tmp5_ = {0};
	glong _tmp6_;
	GValue _tmp7_ = {0};
	GValue* _tmp8_ = NULL;
	GValue* values;
	gint values_length1;
	gint _values_size_;
	GValue* _tmp9_;
	gint _tmp9__length1;
	RygelMediaExportDatabaseCursor* _tmp10_ = NULL;
	RygelMediaExportDatabaseCursor* cursor;
	GError * _inner_error_ = NULL;
#line 182 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 182 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (container != NULL, NULL);
#line 186 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = rygel_media_objects_new ();
#line 186 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	children = _tmp0_;
#line 188 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = container;
#line 188 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = ((RygelMediaObject*) _tmp1_)->id;
#line 188 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp3_, G_TYPE_STRING);
#line 188 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp3_, _tmp2_);
#line 188 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = offset;
#line 188 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp5_, G_TYPE_LONG);
#line 188 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_long (&_tmp5_, _tmp4_);
#line 188 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = max_count;
#line 188 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp7_, G_TYPE_LONG);
#line 188 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_long (&_tmp7_, _tmp6_);
#line 188 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp8_ = g_new0 (GValue, 3);
#line 188 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp8_[0] = _tmp3_;
#line 188 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp8_[1] = _tmp5_;
#line 188 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp8_[2] = _tmp7_;
#line 188 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = _tmp8_;
#line 188 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values_length1 = 3;
#line 188 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_values_size_ = values_length1;
#line 192 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_ = values;
#line 192 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9__length1 = values_length1;
#line 192 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp10_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_CHILDREN, _tmp9_, _tmp9__length1, &_inner_error_);
#line 192 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	cursor = _tmp10_;
#line 192 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 192 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 192 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 192 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (children);
#line 192 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 1620 "rygel-media-export-media-cache.c"
	}
	{
		RygelMediaExportDatabaseCursor* _tmp11_;
		RygelMediaExportDatabaseCursorIterator* _tmp12_ = NULL;
		RygelMediaExportDatabaseCursorIterator* _statement_it;
#line 194 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp11_ = cursor;
#line 194 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp12_ = rygel_media_export_database_cursor_iterator (_tmp11_);
#line 194 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_statement_it = _tmp12_;
#line 194 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		while (TRUE) {
#line 1634 "rygel-media-export-media-cache.c"
			RygelMediaExportDatabaseCursorIterator* _tmp13_;
			gboolean _tmp14_ = FALSE;
			RygelMediaExportDatabaseCursorIterator* _tmp15_;
			sqlite3_stmt* _tmp16_ = NULL;
			sqlite3_stmt* statement;
			RygelMediaObjects* _tmp17_;
			RygelMediaContainer* _tmp18_;
			sqlite3_stmt* _tmp19_;
			RygelMediaObject* _tmp20_ = NULL;
			RygelMediaObject* _tmp21_;
			RygelMediaObjects* _tmp22_;
			gpointer _tmp23_ = NULL;
			RygelMediaObject* _tmp24_;
			RygelMediaContainer* _tmp25_;
#line 194 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp13_ = _statement_it;
#line 194 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp14_ = rygel_media_export_database_cursor_iterator_next (_tmp13_);
#line 194 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (!_tmp14_) {
#line 194 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 1657 "rygel-media-export-media-cache.c"
			}
#line 194 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp15_ = _statement_it;
#line 194 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp16_ = rygel_media_export_database_cursor_iterator_get (_tmp15_, &_inner_error_);
#line 194 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			statement = _tmp16_;
#line 194 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_ != NULL) {
#line 194 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_propagate_error (error, _inner_error_);
#line 194 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 194 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (cursor);
#line 194 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 194 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (children);
#line 194 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				return NULL;
#line 1679 "rygel-media-export-media-cache.c"
			}
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp17_ = children;
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp18_ = container;
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp19_ = statement;
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp20_ = rygel_media_export_media_cache_get_object_from_statement (self, _tmp18_, _tmp19_);
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp21_ = _tmp20_;
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, _tmp21_);
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (_tmp21_);
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp22_ = children;
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp23_ = gee_abstract_list_last ((GeeAbstractList*) _tmp22_);
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp24_ = (RygelMediaObject*) _tmp23_;
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp25_ = container;
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			rygel_media_object_set_parent_ref (_tmp24_, _tmp25_);
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (_tmp24_);
#line 1707 "rygel-media-export-media-cache.c"
		}
#line 194 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 1711 "rygel-media-export-media-cache.c"
	}
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = children;
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (cursor);
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 1721 "rygel-media-export-media-cache.c"
}


RygelMediaObjects* rygel_media_export_media_cache_get_objects_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const gchar* container_id, guint offset, guint max_count, guint* total_matches, GError** error) {
	guint _vala_total_matches = 0U;
	RygelMediaObjects* result = NULL;
	GValueArray* _tmp0_;
	GValueArray* args;
	RygelSearchExpression* _tmp1_;
	GValueArray* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* filter;
	RygelSearchExpression* _tmp4_;
	guint _tmp21_;
	guint _tmp22_ = 0U;
	guint max_objects;
	const gchar* _tmp23_;
	GValueArray* _tmp24_;
	const gchar* _tmp25_;
	glong _tmp26_ = 0L;
	glong _tmp27_;
	const gchar* _tmp28_;
	GValueArray* _tmp29_;
	const gchar* _tmp30_;
	guint _tmp31_;
	guint _tmp32_;
	RygelMediaObjects* _tmp33_ = NULL;
	RygelMediaObjects* _tmp34_;
	GError * _inner_error_ = NULL;
#line 203 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 203 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (container_id != NULL, NULL);
#line 210 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = g_value_array_new ((guint) 0);
#line 210 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	args = _tmp0_;
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = expression;
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = args;
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = rygel_media_export_media_cache_translate_search_expression (self, _tmp1_, _tmp2_, "WHERE", &_inner_error_);
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	filter = _tmp3_;
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_value_array_free0 (args);
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 1775 "rygel-media-export-media-cache.c"
	}
#line 213 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = expression;
#line 213 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp4_ != NULL) {
#line 1781 "rygel-media-export-media-cache.c"
		RygelSearchExpression* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		const gchar* _tmp8_;
#line 214 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = expression;
#line 214 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = rygel_search_expression_to_string (_tmp5_);
#line 214 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_ = _tmp6_;
#line 214 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_debug ("rygel-media-export-media-cache.vala:214: Original search: %s", _tmp7_);
#line 214 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (_tmp7_);
#line 215 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp8_ = filter;
#line 215 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_debug ("rygel-media-export-media-cache.vala:215: Parsed search expression: %s", _tmp8_);
#line 1800 "rygel-media-export-media-cache.c"
	}
	{
		gint i;
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		i = 0;
#line 1806 "rygel-media-export-media-cache.c"
		{
			gboolean _tmp9_;
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp9_ = TRUE;
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			while (TRUE) {
#line 1813 "rygel-media-export-media-cache.c"
				gboolean _tmp10_;
				gint _tmp12_;
				GValueArray* _tmp13_;
				guint _tmp14_;
				gint _tmp15_;
				GValueArray* _tmp16_;
				gint _tmp17_;
				GValue* _tmp18_ = NULL;
				GValue _tmp19_;
				const gchar* _tmp20_ = NULL;
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp10_ = _tmp9_;
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (!_tmp10_) {
#line 1828 "rygel-media-export-media-cache.c"
					gint _tmp11_;
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp11_ = i;
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					i = _tmp11_ + 1;
#line 1834 "rygel-media-export-media-cache.c"
				}
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp9_ = FALSE;
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp12_ = i;
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp13_ = args;
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp14_ = _tmp13_->n_values;
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (!(((guint) _tmp12_) < _tmp14_)) {
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					break;
#line 1848 "rygel-media-export-media-cache.c"
				}
#line 219 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp15_ = i;
#line 219 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp16_ = args;
#line 219 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp17_ = i;
#line 219 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp18_ = g_value_array_get_nth (_tmp16_, (guint) _tmp17_);
#line 219 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp19_ = *_tmp18_;
#line 219 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp20_ = g_value_get_string (&_tmp19_);
#line 219 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_debug ("rygel-media-export-media-cache.vala:219: Arg %d: %s", _tmp15_, _tmp20_);
#line 1864 "rygel-media-export-media-cache.c"
			}
		}
	}
#line 222 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp21_ = max_count;
#line 222 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp22_ = rygel_media_export_media_cache_modify_limit (self, _tmp21_);
#line 222 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	max_objects = _tmp22_;
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp23_ = filter;
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp24_ = args;
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp25_ = container_id;
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_ = rygel_media_export_media_cache_get_object_count_by_filter (self, _tmp23_, _tmp24_, _tmp25_, &_inner_error_);
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp27_ = _tmp26_;
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (filter);
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_value_array_free0 (args);
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 1894 "rygel-media-export-media-cache.c"
	}
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_vala_total_matches = (guint) _tmp27_;
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp28_ = filter;
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp29_ = args;
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp30_ = container_id;
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp31_ = offset;
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_ = max_objects;
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp33_ = rygel_media_export_media_cache_get_objects_by_filter (self, _tmp28_, _tmp29_, _tmp30_, (glong) _tmp31_, (glong) _tmp32_, &_inner_error_);
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp34_ = _tmp33_;
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (filter);
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_value_array_free0 (args);
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 1922 "rygel-media-export-media-cache.c"
	}
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp34_;
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (filter);
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_value_array_free0 (args);
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (total_matches) {
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		*total_matches = _vala_total_matches;
#line 1934 "rygel-media-export-media-cache.c"
	}
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 1938 "rygel-media-export-media-cache.c"
}


glong rygel_media_export_media_cache_get_object_count_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const gchar* container_id, GError** error) {
	glong result = 0L;
	GValueArray* _tmp0_;
	GValueArray* args;
	RygelSearchExpression* _tmp1_;
	GValueArray* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* filter;
	RygelSearchExpression* _tmp4_;
	const gchar* _tmp21_;
	GValueArray* _tmp22_;
	const gchar* _tmp23_;
	glong _tmp24_ = 0L;
	glong _tmp25_;
	GError * _inner_error_ = NULL;
#line 234 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, 0L);
#line 234 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (container_id != NULL, 0L);
#line 238 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = g_value_array_new ((guint) 0);
#line 238 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	args = _tmp0_;
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = expression;
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = args;
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = rygel_media_export_media_cache_translate_search_expression (self, _tmp1_, _tmp2_, "WHERE", &_inner_error_);
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	filter = _tmp3_;
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_value_array_free0 (args);
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return 0L;
#line 1981 "rygel-media-export-media-cache.c"
	}
#line 241 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = expression;
#line 241 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp4_ != NULL) {
#line 1987 "rygel-media-export-media-cache.c"
		RygelSearchExpression* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		const gchar* _tmp8_;
#line 242 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = expression;
#line 242 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = rygel_search_expression_to_string (_tmp5_);
#line 242 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_ = _tmp6_;
#line 242 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_debug ("rygel-media-export-media-cache.vala:242: Original search: %s", _tmp7_);
#line 242 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (_tmp7_);
#line 243 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp8_ = filter;
#line 243 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_debug ("rygel-media-export-media-cache.vala:243: Parsed search expression: %s", _tmp8_);
#line 2006 "rygel-media-export-media-cache.c"
	}
	{
		gint i;
#line 246 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		i = 0;
#line 2012 "rygel-media-export-media-cache.c"
		{
			gboolean _tmp9_;
#line 246 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp9_ = TRUE;
#line 246 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			while (TRUE) {
#line 2019 "rygel-media-export-media-cache.c"
				gboolean _tmp10_;
				gint _tmp12_;
				GValueArray* _tmp13_;
				guint _tmp14_;
				gint _tmp15_;
				GValueArray* _tmp16_;
				gint _tmp17_;
				GValue* _tmp18_ = NULL;
				GValue _tmp19_;
				const gchar* _tmp20_ = NULL;
#line 246 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp10_ = _tmp9_;
#line 246 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (!_tmp10_) {
#line 2034 "rygel-media-export-media-cache.c"
					gint _tmp11_;
#line 246 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_tmp11_ = i;
#line 246 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					i = _tmp11_ + 1;
#line 2040 "rygel-media-export-media-cache.c"
				}
#line 246 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp9_ = FALSE;
#line 246 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp12_ = i;
#line 246 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp13_ = args;
#line 246 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp14_ = _tmp13_->n_values;
#line 246 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (!(((guint) _tmp12_) < _tmp14_)) {
#line 246 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					break;
#line 2054 "rygel-media-export-media-cache.c"
				}
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp15_ = i;
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp16_ = args;
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp17_ = i;
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp18_ = g_value_array_get_nth (_tmp16_, (guint) _tmp17_);
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp19_ = *_tmp18_;
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp20_ = g_value_get_string (&_tmp19_);
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_debug ("rygel-media-export-media-cache.vala:247: Arg %d: %s", _tmp15_, _tmp20_);
#line 2070 "rygel-media-export-media-cache.c"
			}
		}
	}
#line 250 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp21_ = filter;
#line 250 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp22_ = args;
#line 250 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp23_ = container_id;
#line 250 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp24_ = rygel_media_export_media_cache_get_object_count_by_filter (self, _tmp21_, _tmp22_, _tmp23_, &_inner_error_);
#line 250 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp25_ = _tmp24_;
#line 250 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 250 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 250 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (filter);
#line 250 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_value_array_free0 (args);
#line 250 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return 0L;
#line 2094 "rygel-media-export-media-cache.c"
	}
#line 250 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp25_;
#line 250 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (filter);
#line 250 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_value_array_free0 (args);
#line 250 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 2104 "rygel-media-export-media-cache.c"
}


glong rygel_media_export_media_cache_get_object_count_by_filter (RygelMediaExportMediaCache* self, const gchar* filter, GValueArray* args, const gchar* container_id, GError** error) {
	glong result = 0L;
	const gchar* _tmp0_;
	GValue _tmp1_ = {0};
	GValue v;
	GValueArray* _tmp2_;
	GValue _tmp3_;
	GValueArray* _tmp4_;
	guint _tmp5_;
	RygelMediaExportSQLFactory* _tmp6_;
	const gchar* _tmp7_ = NULL;
	const gchar* pattern;
	RygelMediaExportDatabase* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	GValueArray* _tmp12_;
	GValue* _tmp13_;
	gint _tmp13__length1;
	gint _tmp14_ = 0;
	gint _tmp15_;
	gint _tmp16_;
	GError * _inner_error_ = NULL;
#line 255 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, 0L);
#line 255 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (filter != NULL, 0L);
#line 255 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, 0L);
#line 255 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (container_id != NULL, 0L);
#line 260 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = container_id;
#line 260 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp1_, G_TYPE_STRING);
#line 260 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp1_, _tmp0_);
#line 260 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	v = _tmp1_;
#line 261 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = args;
#line 261 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = v;
#line 261 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_array_prepend (_tmp2_, &_tmp3_);
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = args;
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = _tmp4_->n_values;
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_debug ("rygel-media-export-media-cache.vala:263: Parameters to bind: %u", _tmp5_);
#line 264 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = self->priv->sql;
#line 264 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = rygel_media_export_sql_factory_make (_tmp6_, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT_COUNT_BY_FILTER);
#line 264 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	pattern = _tmp7_;
#line 267 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp8_ = self->priv->db;
#line 267 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_ = filter;
#line 267 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp10_ = g_strdup_printf (pattern, _tmp9_);
#line 267 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp11_ = _tmp10_;
#line 267 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp12_ = args;
#line 267 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp13_ = _tmp12_->values;
#line 267 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp13__length1 = (gint) _tmp12_->n_values;
#line 267 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp14_ = rygel_media_export_database_query_value (_tmp8_, _tmp11_, _tmp13_, _tmp13__length1, &_inner_error_);
#line 267 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp15_ = _tmp14_;
#line 267 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (_tmp11_);
#line 267 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp16_ = _tmp15_;
#line 267 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 267 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 267 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
#line 267 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return 0L;
#line 2195 "rygel-media-export-media-cache.c"
	}
#line 267 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = (glong) _tmp16_;
#line 267 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
#line 267 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 2203 "rygel-media-export-media-cache.c"
}


RygelMediaObjects* rygel_media_export_media_cache_get_objects_by_filter (RygelMediaExportMediaCache* self, const gchar* filter, GValueArray* args, const gchar* container_id, glong offset, glong max_count, GError** error) {
	RygelMediaObjects* result = NULL;
	RygelMediaObjects* _tmp0_;
	RygelMediaObjects* children;
	glong _tmp1_;
	GValue _tmp2_ = {0};
	GValue v;
	GValueArray* _tmp3_;
	GValue _tmp4_;
	glong _tmp5_;
	GValue _tmp6_ = {0};
	GValueArray* _tmp7_;
	GValue _tmp8_;
	RygelMediaContainer* parent;
	GValueArray* _tmp9_;
	guint _tmp10_;
	RygelMediaExportSQLFactory* _tmp11_;
	const gchar* _tmp12_ = NULL;
	const gchar* sql;
	RygelMediaExportDatabase* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	GValueArray* _tmp18_;
	GValue* _tmp19_;
	gint _tmp19__length1;
	RygelMediaExportDatabaseCursor* _tmp20_ = NULL;
	RygelMediaExportDatabaseCursor* _tmp21_;
	RygelMediaExportDatabaseCursor* cursor;
	GError * _inner_error_ = NULL;
#line 271 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 271 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (filter != NULL, NULL);
#line 271 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 271 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (container_id != NULL, NULL);
#line 277 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = rygel_media_objects_new ();
#line 277 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	children = _tmp0_;
#line 278 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = offset;
#line 278 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp2_, G_TYPE_LONG);
#line 278 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_long (&_tmp2_, _tmp1_);
#line 278 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	v = _tmp2_;
#line 279 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = args;
#line 279 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = v;
#line 279 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_array_append (_tmp3_, &_tmp4_);
#line 280 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = max_count;
#line 280 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp6_, G_TYPE_LONG);
#line 280 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_long (&_tmp6_, _tmp5_);
#line 280 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
#line 280 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	v = _tmp6_;
#line 281 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = args;
#line 281 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp8_ = v;
#line 281 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_array_append (_tmp7_, &_tmp8_);
#line 282 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	parent = NULL;
#line 284 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_ = args;
#line 284 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp10_ = _tmp9_->n_values;
#line 284 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_debug ("rygel-media-export-media-cache.vala:284: Parameters to bind: %u", _tmp10_);
#line 286 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp11_ = self->priv->sql;
#line 286 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp12_ = rygel_media_export_sql_factory_make (_tmp11_, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECTS_BY_FILTER);
#line 286 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	sql = _tmp12_;
#line 287 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp13_ = self->priv->db;
#line 287 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp14_ = sql;
#line 287 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp15_ = filter;
#line 287 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp16_ = g_strdup_printf (_tmp14_, _tmp15_);
#line 287 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp17_ = _tmp16_;
#line 287 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp18_ = args;
#line 287 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp19_ = _tmp18_->values;
#line 287 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp19__length1 = (gint) _tmp18_->n_values;
#line 287 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp20_ = rygel_media_export_database_exec_cursor (_tmp13_, _tmp17_, _tmp19_, _tmp19__length1, &_inner_error_);
#line 287 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp21_ = _tmp20_;
#line 287 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (_tmp17_);
#line 287 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	cursor = _tmp21_;
#line 287 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 287 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 287 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (parent);
#line 287 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
#line 287 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (children);
#line 287 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 2330 "rygel-media-export-media-cache.c"
	}
	{
		RygelMediaExportDatabaseCursor* _tmp22_;
		RygelMediaExportDatabaseCursorIterator* _tmp23_ = NULL;
		RygelMediaExportDatabaseCursorIterator* _statement_it;
#line 288 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp22_ = cursor;
#line 288 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp23_ = rygel_media_export_database_cursor_iterator (_tmp22_);
#line 288 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_statement_it = _tmp23_;
#line 288 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		while (TRUE) {
#line 2344 "rygel-media-export-media-cache.c"
			RygelMediaExportDatabaseCursorIterator* _tmp24_;
			gboolean _tmp25_ = FALSE;
			RygelMediaExportDatabaseCursorIterator* _tmp26_;
			sqlite3_stmt* _tmp27_ = NULL;
			sqlite3_stmt* statement;
			sqlite3_stmt* _tmp28_;
			const gchar* _tmp29_ = NULL;
			const gchar* parent_id;
			gboolean _tmp30_ = FALSE;
			RygelMediaContainer* _tmp31_;
			gboolean _tmp35_;
			RygelMediaContainer* _tmp40_;
#line 288 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp24_ = _statement_it;
#line 288 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp25_ = rygel_media_export_database_cursor_iterator_next (_tmp24_);
#line 288 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (!_tmp25_) {
#line 288 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 2365 "rygel-media-export-media-cache.c"
			}
#line 288 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp26_ = _statement_it;
#line 288 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp27_ = rygel_media_export_database_cursor_iterator_get (_tmp26_, &_inner_error_);
#line 288 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			statement = _tmp27_;
#line 288 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_ != NULL) {
#line 288 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_propagate_error (error, _inner_error_);
#line 288 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 288 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (cursor);
#line 288 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (parent);
#line 288 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
#line 288 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (children);
#line 288 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				return NULL;
#line 2389 "rygel-media-export-media-cache.c"
			}
#line 289 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp28_ = statement;
#line 289 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp29_ = sqlite3_column_text (_tmp28_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_PARENT);
#line 289 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			parent_id = _tmp29_;
#line 291 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp31_ = parent;
#line 291 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_tmp31_ == NULL) {
#line 291 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp30_ = TRUE;
#line 2403 "rygel-media-export-media-cache.c"
			} else {
				const gchar* _tmp32_;
				RygelMediaContainer* _tmp33_;
				const gchar* _tmp34_;
#line 291 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp32_ = parent_id;
#line 291 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp33_ = parent;
#line 291 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp34_ = ((RygelMediaObject*) _tmp33_)->id;
#line 291 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp30_ = g_strcmp0 (_tmp32_, _tmp34_) != 0;
#line 2416 "rygel-media-export-media-cache.c"
			}
#line 291 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp35_ = _tmp30_;
#line 291 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_tmp35_) {
#line 2422 "rygel-media-export-media-cache.c"
				RygelNullContainer* _tmp36_;
				RygelMediaContainer* _tmp37_;
				const gchar* _tmp38_;
				gchar* _tmp39_;
#line 292 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp36_ = rygel_null_container_new ();
#line 292 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (parent);
#line 292 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				parent = (RygelMediaContainer*) _tmp36_;
#line 293 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp37_ = parent;
#line 293 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp38_ = parent_id;
#line 293 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp39_ = g_strdup (_tmp38_);
#line 293 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (((RygelMediaObject*) _tmp37_)->id);
#line 293 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				((RygelMediaObject*) _tmp37_)->id = _tmp39_;
#line 2443 "rygel-media-export-media-cache.c"
			}
#line 296 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp40_ = parent;
#line 296 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_tmp40_ != NULL) {
#line 2449 "rygel-media-export-media-cache.c"
				RygelMediaObjects* _tmp41_;
				RygelMediaContainer* _tmp42_;
				sqlite3_stmt* _tmp43_;
				RygelMediaObject* _tmp44_ = NULL;
				RygelMediaObject* _tmp45_;
				RygelMediaObjects* _tmp46_;
				gpointer _tmp47_ = NULL;
				RygelMediaObject* _tmp48_;
				RygelMediaContainer* _tmp49_;
#line 297 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp41_ = children;
#line 297 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp42_ = parent;
#line 297 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp43_ = statement;
#line 297 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp44_ = rygel_media_export_media_cache_get_object_from_statement (self, _tmp42_, _tmp43_);
#line 297 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp45_ = _tmp44_;
#line 297 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp41_, _tmp45_);
#line 297 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (_tmp45_);
#line 299 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp46_ = children;
#line 299 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp47_ = gee_abstract_list_last ((GeeAbstractList*) _tmp46_);
#line 299 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp48_ = (RygelMediaObject*) _tmp47_;
#line 299 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp49_ = parent;
#line 299 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				rygel_media_object_set_parent_ref (_tmp48_, _tmp49_);
#line 299 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (_tmp48_);
#line 2485 "rygel-media-export-media-cache.c"
			} else {
				sqlite3_stmt* _tmp50_;
				const gchar* _tmp51_ = NULL;
				const gchar* _tmp52_;
#line 301 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp50_ = statement;
#line 301 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp51_ = sqlite3_column_text (_tmp50_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ID);
#line 301 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp52_ = parent_id;
#line 301 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_warning ("Inconsistent database: item %s " "has no parent %s", _tmp51_, _tmp52_);
#line 2498 "rygel-media-export-media-cache.c"
			}
		}
#line 288 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 2503 "rygel-media-export-media-cache.c"
	}
#line 308 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = children;
#line 308 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (cursor);
#line 308 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (parent);
#line 308 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
#line 308 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 2515 "rygel-media-export-media-cache.c"
}


void rygel_media_export_media_cache_debug_statistics (RygelMediaExportMediaCache* self) {
	GError * _inner_error_ = NULL;
#line 311 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 2523 "rygel-media-export-media-cache.c"
	{
		RygelMediaExportDatabaseCursor* _tmp0_ = NULL;
		RygelMediaExportDatabaseCursor* cursor;
#line 313 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_debug ("rygel-media-export-media-cache.vala:313: Database statistics:");
#line 314 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp0_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_STATISTICS, NULL, 0, &_inner_error_);
#line 314 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		cursor = _tmp0_;
#line 314 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 2535 "rygel-media-export-media-cache.c"
			goto __catch7_g_error;
		}
		{
			RygelMediaExportDatabaseCursor* _tmp1_;
			RygelMediaExportDatabaseCursorIterator* _tmp2_ = NULL;
			RygelMediaExportDatabaseCursorIterator* _statement_it;
#line 315 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp1_ = cursor;
#line 315 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp2_ = rygel_media_export_database_cursor_iterator (_tmp1_);
#line 315 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_statement_it = _tmp2_;
#line 315 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			while (TRUE) {
#line 2550 "rygel-media-export-media-cache.c"
				RygelMediaExportDatabaseCursorIterator* _tmp3_;
				gboolean _tmp4_ = FALSE;
				RygelMediaExportDatabaseCursorIterator* _tmp5_;
				sqlite3_stmt* _tmp6_ = NULL;
				sqlite3_stmt* statement;
				sqlite3_stmt* _tmp7_;
				const gchar* _tmp8_ = NULL;
				sqlite3_stmt* _tmp9_;
				gint _tmp10_ = 0;
#line 315 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp3_ = _statement_it;
#line 315 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp4_ = rygel_media_export_database_cursor_iterator_next (_tmp3_);
#line 315 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (!_tmp4_) {
#line 315 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					break;
#line 2568 "rygel-media-export-media-cache.c"
				}
#line 315 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp5_ = _statement_it;
#line 315 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp6_ = rygel_media_export_database_cursor_iterator_get (_tmp5_, &_inner_error_);
#line 315 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				statement = _tmp6_;
#line 315 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_inner_error_ != NULL) {
#line 315 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 315 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (cursor);
#line 2582 "rygel-media-export-media-cache.c"
					goto __catch7_g_error;
				}
#line 316 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp7_ = statement;
#line 316 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp8_ = sqlite3_column_text (_tmp7_, 0);
#line 316 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp9_ = statement;
#line 316 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp10_ = sqlite3_column_int (_tmp9_, 1);
#line 316 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_debug ("rygel-media-export-media-cache.vala:316: %s: %d", _tmp8_, _tmp10_);
#line 2595 "rygel-media-export-media-cache.c"
			}
#line 315 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 2599 "rygel-media-export-media-cache.c"
		}
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (cursor);
#line 2603 "rygel-media-export-media-cache.c"
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* _error_ = NULL;
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_error_ = _inner_error_;
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = NULL;
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_error_free0 (_error_);
#line 2615 "rygel-media-export-media-cache.c"
	}
	__finally7:
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_clear_error (&_inner_error_);
#line 312 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return;
#line 2626 "rygel-media-export-media-cache.c"
	}
}


GeeArrayList* rygel_media_export_media_cache_get_child_ids (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error) {
	GeeArrayList* result = NULL;
	GEqualFunc _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* children;
	const gchar* _tmp2_;
	GValue _tmp3_ = {0};
	GValue* _tmp4_ = NULL;
	GValue* values;
	gint values_length1;
	gint _values_size_;
	GValue* _tmp5_;
	gint _tmp5__length1;
	RygelMediaExportDatabaseCursor* _tmp6_ = NULL;
	RygelMediaExportDatabaseCursor* cursor;
	GError * _inner_error_ = NULL;
#line 323 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 323 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (container_id != NULL, NULL);
#line 325 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = g_str_equal;
#line 325 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _tmp0_);
#line 325 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	children = _tmp1_;
#line 326 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = container_id;
#line 326 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp3_, G_TYPE_STRING);
#line 326 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp3_, _tmp2_);
#line 326 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = g_new0 (GValue, 1);
#line 326 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_[0] = _tmp3_;
#line 326 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = _tmp4_;
#line 326 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values_length1 = 1;
#line 326 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_values_size_ = values_length1;
#line 328 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = values;
#line 328 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5__length1 = values_length1;
#line 328 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_IDS, _tmp5_, _tmp5__length1, &_inner_error_);
#line 328 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	cursor = _tmp6_;
#line 328 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 328 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 328 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 328 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 328 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (children);
#line 328 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 2693 "rygel-media-export-media-cache.c"
		} else {
#line 328 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 328 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (children);
#line 328 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 328 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 328 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 2705 "rygel-media-export-media-cache.c"
		}
	}
	{
		RygelMediaExportDatabaseCursor* _tmp7_;
		RygelMediaExportDatabaseCursorIterator* _tmp8_ = NULL;
		RygelMediaExportDatabaseCursorIterator* _statement_it;
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_ = cursor;
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp8_ = rygel_media_export_database_cursor_iterator (_tmp7_);
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_statement_it = _tmp8_;
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		while (TRUE) {
#line 2720 "rygel-media-export-media-cache.c"
			RygelMediaExportDatabaseCursorIterator* _tmp9_;
			gboolean _tmp10_ = FALSE;
			RygelMediaExportDatabaseCursorIterator* _tmp11_;
			sqlite3_stmt* _tmp12_ = NULL;
			sqlite3_stmt* statement;
			GeeArrayList* _tmp13_;
			sqlite3_stmt* _tmp14_;
			const gchar* _tmp15_ = NULL;
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp9_ = _statement_it;
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp10_ = rygel_media_export_database_cursor_iterator_next (_tmp9_);
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (!_tmp10_) {
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 2737 "rygel-media-export-media-cache.c"
			}
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp11_ = _statement_it;
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp12_ = rygel_media_export_database_cursor_iterator_get (_tmp11_, &_inner_error_);
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			statement = _tmp12_;
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_ != NULL) {
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_propagate_error (error, _inner_error_);
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (cursor);
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (children);
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					return NULL;
#line 2761 "rygel-media-export-media-cache.c"
				} else {
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (cursor);
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (children);
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_clear_error (&_inner_error_);
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					return NULL;
#line 2777 "rygel-media-export-media-cache.c"
				}
			}
#line 330 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp13_ = children;
#line 330 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp14_ = statement;
#line 330 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp15_ = sqlite3_column_text (_tmp14_, 0);
#line 330 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp15_);
#line 2788 "rygel-media-export-media-cache.c"
		}
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 2792 "rygel-media-export-media-cache.c"
	}
#line 333 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = children;
#line 333 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (cursor);
#line 333 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 333 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 2802 "rygel-media-export-media-cache.c"
}


GeeList* rygel_media_export_media_cache_get_meta_data_column_by_filter (RygelMediaExportMediaCache* self, const gchar* column, const gchar* filter, GValueArray* args, glong offset, glong max_count, GError** error) {
	GeeList* result = NULL;
	glong _tmp0_;
	GValue _tmp1_ = {0};
	GValue v;
	GValueArray* _tmp2_;
	GValue _tmp3_;
	glong _tmp4_;
	GValue _tmp5_ = {0};
	GValueArray* _tmp6_;
	GValue _tmp7_;
	GeeArrayList* _tmp8_;
	GeeArrayList* data;
	RygelMediaExportSQLFactory* _tmp9_;
	const gchar* _tmp10_ = NULL;
	const gchar* sql;
	RygelMediaExportDatabase* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_;
	GValueArray* _tmp17_;
	GValue* _tmp18_;
	gint _tmp18__length1;
	RygelMediaExportDatabaseCursor* _tmp19_ = NULL;
	RygelMediaExportDatabaseCursor* _tmp20_;
	RygelMediaExportDatabaseCursor* cursor;
	GError * _inner_error_ = NULL;
#line 336 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 336 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (column != NULL, NULL);
#line 336 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (filter != NULL, NULL);
#line 336 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 343 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = offset;
#line 343 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp1_, G_TYPE_LONG);
#line 343 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_long (&_tmp1_, _tmp0_);
#line 343 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	v = _tmp1_;
#line 344 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = args;
#line 344 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = v;
#line 344 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_array_append (_tmp2_, &_tmp3_);
#line 345 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = max_count;
#line 345 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp5_, G_TYPE_LONG);
#line 345 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_long (&_tmp5_, _tmp4_);
#line 345 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
#line 345 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	v = _tmp5_;
#line 346 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = args;
#line 346 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = v;
#line 346 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_array_append (_tmp6_, &_tmp7_);
#line 348 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp8_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
#line 348 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	data = _tmp8_;
#line 350 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_ = self->priv->sql;
#line 350 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp10_ = rygel_media_export_sql_factory_make (_tmp9_, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_META_DATA_COLUMN);
#line 350 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	sql = _tmp10_;
#line 351 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp11_ = self->priv->db;
#line 351 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp12_ = sql;
#line 351 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp13_ = column;
#line 351 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp14_ = filter;
#line 351 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp15_ = g_strdup_printf (_tmp12_, _tmp13_, _tmp14_);
#line 351 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp16_ = _tmp15_;
#line 351 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp17_ = args;
#line 351 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp18_ = _tmp17_->values;
#line 351 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp18__length1 = (gint) _tmp17_->n_values;
#line 351 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp19_ = rygel_media_export_database_exec_cursor (_tmp11_, _tmp16_, _tmp18_, _tmp18__length1, &_inner_error_);
#line 351 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp20_ = _tmp19_;
#line 351 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (_tmp16_);
#line 351 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	cursor = _tmp20_;
#line 351 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 351 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 351 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (data);
#line 351 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
#line 351 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 2919 "rygel-media-export-media-cache.c"
	}
	{
		RygelMediaExportDatabaseCursor* _tmp21_;
		RygelMediaExportDatabaseCursorIterator* _tmp22_ = NULL;
		RygelMediaExportDatabaseCursorIterator* _statement_it;
#line 353 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp21_ = cursor;
#line 353 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp22_ = rygel_media_export_database_cursor_iterator (_tmp21_);
#line 353 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_statement_it = _tmp22_;
#line 353 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		while (TRUE) {
#line 2933 "rygel-media-export-media-cache.c"
			RygelMediaExportDatabaseCursorIterator* _tmp23_;
			gboolean _tmp24_ = FALSE;
			RygelMediaExportDatabaseCursorIterator* _tmp25_;
			sqlite3_stmt* _tmp26_ = NULL;
			sqlite3_stmt* statement;
			GeeArrayList* _tmp27_;
			sqlite3_stmt* _tmp28_;
			const gchar* _tmp29_ = NULL;
#line 353 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp23_ = _statement_it;
#line 353 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp24_ = rygel_media_export_database_cursor_iterator_next (_tmp23_);
#line 353 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (!_tmp24_) {
#line 353 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 2950 "rygel-media-export-media-cache.c"
			}
#line 353 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp25_ = _statement_it;
#line 353 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp26_ = rygel_media_export_database_cursor_iterator_get (_tmp25_, &_inner_error_);
#line 353 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			statement = _tmp26_;
#line 353 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_ != NULL) {
#line 353 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_propagate_error (error, _inner_error_);
#line 353 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 353 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (cursor);
#line 353 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (data);
#line 353 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
#line 353 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				return NULL;
#line 2972 "rygel-media-export-media-cache.c"
			}
#line 354 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp27_ = data;
#line 354 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp28_ = statement;
#line 354 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp29_ = sqlite3_column_text (_tmp28_, 0);
#line 354 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, _tmp29_);
#line 2982 "rygel-media-export-media-cache.c"
		}
#line 353 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 2986 "rygel-media-export-media-cache.c"
	}
#line 357 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = (GeeList*) data;
#line 357 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (cursor);
#line 357 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
#line 357 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 2996 "rygel-media-export-media-cache.c"
}


GeeList* rygel_media_export_media_cache_get_object_attribute_by_search_expression (RygelMediaExportMediaCache* self, const gchar* attribute, RygelSearchExpression* expression, glong offset, guint max_count, GError** error) {
	GeeList* result = NULL;
	GValueArray* _tmp0_;
	GValueArray* args;
	RygelSearchExpression* _tmp1_;
	GValueArray* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* filter;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* column;
	guint _tmp7_;
	guint _tmp8_ = 0U;
	guint max_objects;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	GValueArray* _tmp11_;
	glong _tmp12_;
	guint _tmp13_;
	GeeList* _tmp14_ = NULL;
	GeeList* _tmp15_;
	GError * _inner_error_ = NULL;
#line 360 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 360 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (attribute != NULL, NULL);
#line 366 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = g_value_array_new ((guint) 0);
#line 366 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	args = _tmp0_;
#line 367 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = expression;
#line 367 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = args;
#line 367 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = rygel_media_export_media_cache_translate_search_expression (self, _tmp1_, _tmp2_, "AND", &_inner_error_);
#line 367 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	filter = _tmp3_;
#line 367 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 367 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 367 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_value_array_free0 (args);
#line 367 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 3047 "rygel-media-export-media-cache.c"
	}
#line 371 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = filter;
#line 371 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_debug ("rygel-media-export-media-cache.vala:371: Parsed filter: %s", _tmp4_);
#line 373 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = attribute;
#line 373 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = rygel_media_export_media_cache_map_operand_to_column (self, _tmp5_, NULL, &_inner_error_);
#line 373 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	column = _tmp6_;
#line 373 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 373 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 373 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (filter);
#line 373 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_value_array_free0 (args);
#line 373 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 3069 "rygel-media-export-media-cache.c"
	}
#line 374 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = max_count;
#line 374 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp8_ = rygel_media_export_media_cache_modify_limit (self, _tmp7_);
#line 374 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	max_objects = _tmp8_;
#line 376 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_ = column;
#line 376 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp10_ = filter;
#line 376 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp11_ = args;
#line 376 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp12_ = offset;
#line 376 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp13_ = max_objects;
#line 376 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp14_ = rygel_media_export_media_cache_get_meta_data_column_by_filter (self, _tmp9_, _tmp10_, _tmp11_, _tmp12_, (glong) _tmp13_, &_inner_error_);
#line 376 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp15_ = _tmp14_;
#line 376 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 376 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 376 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (column);
#line 376 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (filter);
#line 376 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_value_array_free0 (args);
#line 376 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 3103 "rygel-media-export-media-cache.c"
	}
#line 376 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp15_;
#line 376 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (column);
#line 376 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (filter);
#line 376 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_value_array_free0 (args);
#line 376 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 3115 "rygel-media-export-media-cache.c"
}


void rygel_media_export_media_cache_flag_object (RygelMediaExportMediaCache* self, GFile* file, const gchar* flag, GError** error) {
	const gchar* _tmp0_;
	GValue _tmp1_ = {0};
	GFile* _tmp2_;
	gchar* _tmp3_ = NULL;
	GValue _tmp4_ = {0};
	GValue* _tmp5_ = NULL;
	GValue* args;
	gint args_length1;
	gint _args_size_;
	RygelMediaExportDatabase* _tmp6_;
	GError * _inner_error_ = NULL;
#line 383 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 383 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (file != NULL);
#line 383 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (flag != NULL);
#line 384 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = flag;
#line 384 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp1_, G_TYPE_STRING);
#line 384 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp1_, _tmp0_);
#line 384 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = file;
#line 384 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = g_file_get_uri (_tmp2_);
#line 384 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp4_, G_TYPE_STRING);
#line 384 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_take_string (&_tmp4_, _tmp3_);
#line 384 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = g_new0 (GValue, 2);
#line 384 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_[0] = _tmp1_;
#line 384 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_[1] = _tmp4_;
#line 384 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	args = _tmp5_;
#line 384 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	args_length1 = 2;
#line 384 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_args_size_ = args_length1;
#line 385 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = self->priv->db;
#line 385 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (_tmp6_, "UPDATE Object SET flags = ? WHERE uri = ?", args, args_length1, &_inner_error_);
#line 385 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 385 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 385 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		args = (_vala_GValue_array_free (args, args_length1), NULL);
#line 385 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return;
#line 3175 "rygel-media-export-media-cache.c"
	}
#line 383 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	args = (_vala_GValue_array_free (args, args_length1), NULL);
#line 3179 "rygel-media-export-media-cache.c"
}


GeeList* rygel_media_export_media_cache_get_flagged_uris (RygelMediaExportMediaCache* self, const gchar* flag, GError** error) {
	GeeList* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* uris;
#line 390 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static const char query[] = "SELECT uri FROM object WHERE flags = ?";
#line 3189 "rygel-media-export-media-cache.c"
	const gchar* _tmp1_;
	GValue _tmp2_ = {0};
	GValue* _tmp3_ = NULL;
	GValue* args;
	gint args_length1;
	gint _args_size_;
	RygelMediaExportDatabase* _tmp4_;
	GValue* _tmp5_;
	gint _tmp5__length1;
	RygelMediaExportDatabaseCursor* _tmp6_ = NULL;
	RygelMediaExportDatabaseCursor* cursor;
	GError * _inner_error_ = NULL;
#line 388 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 388 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (flag != NULL, NULL);
#line 389 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
#line 389 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	uris = _tmp0_;
#line 392 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = flag;
#line 392 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp2_, G_TYPE_STRING);
#line 392 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp2_, _tmp1_);
#line 392 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = g_new0 (GValue, 1);
#line 392 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_[0] = _tmp2_;
#line 392 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	args = _tmp3_;
#line 392 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	args_length1 = 1;
#line 392 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_args_size_ = args_length1;
#line 394 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = self->priv->db;
#line 394 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = args;
#line 394 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5__length1 = args_length1;
#line 394 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = rygel_media_export_database_exec_cursor (_tmp4_, query, _tmp5_, _tmp5__length1, &_inner_error_);
#line 394 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	cursor = _tmp6_;
#line 394 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 394 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 394 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		args = (_vala_GValue_array_free (args, args_length1), NULL);
#line 394 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (uris);
#line 394 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 3246 "rygel-media-export-media-cache.c"
	}
	{
		RygelMediaExportDatabaseCursor* _tmp7_;
		RygelMediaExportDatabaseCursorIterator* _tmp8_ = NULL;
		RygelMediaExportDatabaseCursorIterator* _statement_it;
#line 395 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_ = cursor;
#line 395 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp8_ = rygel_media_export_database_cursor_iterator (_tmp7_);
#line 395 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_statement_it = _tmp8_;
#line 395 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		while (TRUE) {
#line 3260 "rygel-media-export-media-cache.c"
			RygelMediaExportDatabaseCursorIterator* _tmp9_;
			gboolean _tmp10_ = FALSE;
			RygelMediaExportDatabaseCursorIterator* _tmp11_;
			sqlite3_stmt* _tmp12_ = NULL;
			sqlite3_stmt* statement;
			GeeArrayList* _tmp13_;
			sqlite3_stmt* _tmp14_;
			const gchar* _tmp15_ = NULL;
#line 395 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp9_ = _statement_it;
#line 395 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp10_ = rygel_media_export_database_cursor_iterator_next (_tmp9_);
#line 395 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (!_tmp10_) {
#line 395 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 3277 "rygel-media-export-media-cache.c"
			}
#line 395 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp11_ = _statement_it;
#line 395 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp12_ = rygel_media_export_database_cursor_iterator_get (_tmp11_, &_inner_error_);
#line 395 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			statement = _tmp12_;
#line 395 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_ != NULL) {
#line 395 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_propagate_error (error, _inner_error_);
#line 395 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 395 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (cursor);
#line 395 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				args = (_vala_GValue_array_free (args, args_length1), NULL);
#line 395 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (uris);
#line 395 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				return NULL;
#line 3299 "rygel-media-export-media-cache.c"
			}
#line 396 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp13_ = uris;
#line 396 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp14_ = statement;
#line 396 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp15_ = sqlite3_column_text (_tmp14_, 0);
#line 396 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp15_);
#line 3309 "rygel-media-export-media-cache.c"
		}
#line 395 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 3313 "rygel-media-export-media-cache.c"
	}
#line 399 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = (GeeList*) uris;
#line 399 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (cursor);
#line 399 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	args = (_vala_GValue_array_free (args, args_length1), NULL);
#line 399 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 3323 "rygel-media-export-media-cache.c"
}


static void rygel_media_export_media_cache_get_exists_cache (RygelMediaExportMediaCache* self, GError** error) {
	GeeHashMap* _tmp0_;
	RygelMediaExportDatabaseCursor* _tmp1_ = NULL;
	RygelMediaExportDatabaseCursor* cursor;
	GError * _inner_error_ = NULL;
#line 403 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 404 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, RYGEL_MEDIA_EXPORT_TYPE_EXISTS_CACHE_ENTRY, (GBoxedCopyFunc) rygel_media_export_exists_cache_entry_dup, rygel_media_export_exists_cache_entry_free, NULL, NULL, NULL);
#line 404 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (self->priv->exists_cache);
#line 404 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	self->priv->exists_cache = _tmp0_;
#line 405 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS_CACHE, NULL, 0, &_inner_error_);
#line 405 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	cursor = _tmp1_;
#line 405 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 405 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 405 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 405 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 3352 "rygel-media-export-media-cache.c"
		} else {
#line 405 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 405 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 405 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return;
#line 3360 "rygel-media-export-media-cache.c"
		}
	}
	{
		RygelMediaExportDatabaseCursor* _tmp2_;
		RygelMediaExportDatabaseCursorIterator* _tmp3_ = NULL;
		RygelMediaExportDatabaseCursorIterator* _statement_it;
#line 406 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp2_ = cursor;
#line 406 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp3_ = rygel_media_export_database_cursor_iterator (_tmp2_);
#line 406 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_statement_it = _tmp3_;
#line 406 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		while (TRUE) {
#line 3375 "rygel-media-export-media-cache.c"
			RygelMediaExportDatabaseCursorIterator* _tmp4_;
			gboolean _tmp5_ = FALSE;
			RygelMediaExportDatabaseCursorIterator* _tmp6_;
			sqlite3_stmt* _tmp7_ = NULL;
			sqlite3_stmt* statement;
			RygelMediaExportExistsCacheEntry entry = {0};
			sqlite3_stmt* _tmp8_;
			gint64 _tmp9_ = 0LL;
			sqlite3_stmt* _tmp10_;
			gint64 _tmp11_ = 0LL;
			GeeHashMap* _tmp12_;
			sqlite3_stmt* _tmp13_;
			const gchar* _tmp14_ = NULL;
			RygelMediaExportExistsCacheEntry _tmp15_;
#line 406 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp4_ = _statement_it;
#line 406 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp5_ = rygel_media_export_database_cursor_iterator_next (_tmp4_);
#line 406 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (!_tmp5_) {
#line 406 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 3398 "rygel-media-export-media-cache.c"
			}
#line 406 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp6_ = _statement_it;
#line 406 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp7_ = rygel_media_export_database_cursor_iterator_get (_tmp6_, &_inner_error_);
#line 406 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			statement = _tmp7_;
#line 406 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_ != NULL) {
#line 406 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 406 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_propagate_error (error, _inner_error_);
#line 406 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 406 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (cursor);
#line 406 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					return;
#line 3418 "rygel-media-export-media-cache.c"
				} else {
#line 406 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 406 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (cursor);
#line 406 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 406 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					g_clear_error (&_inner_error_);
#line 406 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					return;
#line 3430 "rygel-media-export-media-cache.c"
				}
			}
#line 407 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			memset (&entry, 0, sizeof (RygelMediaExportExistsCacheEntry));
#line 408 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp8_ = statement;
#line 408 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp9_ = sqlite3_column_int64 (_tmp8_, 1);
#line 408 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			entry.mtime = _tmp9_;
#line 409 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp10_ = statement;
#line 409 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp11_ = sqlite3_column_int64 (_tmp10_, 0);
#line 409 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			entry.size = _tmp11_;
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp12_ = self->priv->exists_cache;
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp13_ = statement;
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp14_ = sqlite3_column_text (_tmp13_, 2);
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp15_ = entry;
#line 410 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			gee_abstract_map_set ((GeeAbstractMap*) _tmp12_, _tmp14_, &_tmp15_);
#line 3457 "rygel-media-export-media-cache.c"
		}
#line 406 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
#line 3461 "rygel-media-export-media-cache.c"
	}
#line 403 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (cursor);
#line 3465 "rygel-media-export-media-cache.c"
}


static guint rygel_media_export_media_cache_modify_limit (RygelMediaExportMediaCache* self, guint max_count) {
	guint result = 0U;
	guint _tmp0_;
#line 414 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 415 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = max_count;
#line 415 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp0_ == ((guint) 0)) {
#line 416 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		result = (guint) (-1);
#line 416 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return result;
#line 3482 "rygel-media-export-media-cache.c"
	} else {
		guint _tmp1_;
#line 418 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp1_ = max_count;
#line 418 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		result = _tmp1_;
#line 418 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return result;
#line 3491 "rygel-media-export-media-cache.c"
	}
}


static void rygel_media_export_media_cache_open_db (RygelMediaExportMediaCache* self, const gchar* name, GError** error) {
	const gchar* _tmp0_;
	RygelMediaExportDatabase* _tmp1_;
	RygelMediaExportDatabase* _tmp2_;
	gint old_version;
	gint _tmp3_ = 0;
	gint current_version;
	GError * _inner_error_ = NULL;
#line 422 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 422 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (name != NULL);
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = name;
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = rygel_media_export_database_new (_tmp0_, &_inner_error_);
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = _tmp1_;
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return;
#line 3520 "rygel-media-export-media-cache.c"
	}
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (self->priv->db);
#line 423 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	self->priv->db = _tmp2_;
#line 424 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	old_version = -1;
#line 425 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = atoi (RYGEL_MEDIA_EXPORT_SQL_FACTORY_schema_version);
#line 425 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	current_version = _tmp3_;
#line 3532 "rygel-media-export-media-cache.c"
	{
		RygelMediaExportDatabase* _tmp4_;
		RygelMediaExportSQLFactory* _tmp5_;
		RygelMediaExportMediaCacheUpgrader* _tmp6_;
		RygelMediaExportMediaCacheUpgrader* upgrader;
		RygelMediaExportMediaCacheUpgrader* _tmp7_;
		gint _tmp8_ = 0;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_;
		RygelMediaExportMediaCacheUpgrader* _tmp19_;
#line 428 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4_ = self->priv->db;
#line 428 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = self->priv->sql;
#line 428 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = rygel_media_export_media_cache_upgrader_new (_tmp4_, _tmp5_);
#line 428 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		upgrader = _tmp6_;
#line 429 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_ = upgrader;
#line 429 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp9_ = rygel_media_export_media_cache_upgrader_needs_upgrade (_tmp7_, &_tmp8_, &_inner_error_);
#line 429 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		old_version = _tmp8_;
#line 429 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp10_ = _tmp9_;
#line 429 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 429 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_rygel_media_export_media_cache_upgrader_unref0 (upgrader);
#line 429 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 3565 "rygel-media-export-media-cache.c"
				goto __catch8_rygel_media_export_database_error;
			}
			goto __finally8;
		}
#line 429 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_tmp10_) {
#line 3572 "rygel-media-export-media-cache.c"
			RygelMediaExportMediaCacheUpgrader* _tmp11_;
			gint _tmp12_;
#line 430 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp11_ = upgrader;
#line 430 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp12_ = old_version;
#line 430 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			rygel_media_export_media_cache_upgrader_upgrade (_tmp11_, _tmp12_);
#line 3581 "rygel-media-export-media-cache.c"
		} else {
			gint _tmp13_;
			gint _tmp14_;
#line 431 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp13_ = old_version;
#line 431 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp14_ = current_version;
#line 431 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_tmp13_ == _tmp14_) {
#line 3591 "rygel-media-export-media-cache.c"
				RygelMediaExportMediaCacheUpgrader* _tmp15_;
#line 432 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp15_ = upgrader;
#line 432 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				rygel_media_export_media_cache_upgrader_fix_schema (_tmp15_, &_inner_error_);
#line 432 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_inner_error_ != NULL) {
#line 432 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_rygel_media_export_media_cache_upgrader_unref0 (upgrader);
#line 432 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 3603 "rygel-media-export-media-cache.c"
						goto __catch8_rygel_media_export_database_error;
					}
					goto __finally8;
				}
			} else {
				gint _tmp16_;
				gint _tmp17_;
				GError* _tmp18_;
#line 434 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp16_ = old_version;
#line 434 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp17_ = current_version;
#line 434 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_warning ("The version \"%d\" of the detected database" " is newer than our supported version \"%d\"", _tmp16_, _tmp17_);
#line 438 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (self->priv->db);
#line 438 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				self->priv->db = NULL;
#line 440 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp18_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR, "Database format" " not supported");
#line 440 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_inner_error_ = _tmp18_;
#line 440 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_rygel_media_export_media_cache_upgrader_unref0 (upgrader);
#line 440 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 3630 "rygel-media-export-media-cache.c"
					goto __catch8_rygel_media_export_database_error;
				}
				goto __finally8;
			}
		}
#line 443 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp19_ = upgrader;
#line 443 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_media_cache_upgrader_ensure_indices (_tmp19_);
#line 427 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_rygel_media_export_media_cache_upgrader_unref0 (upgrader);
#line 3642 "rygel-media-export-media-cache.c"
	}
	goto __finally8;
	__catch8_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
#line 427 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_error_ = _inner_error_;
#line 427 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = NULL;
#line 445 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_debug ("rygel-media-export-media-cache.vala:445: %s", "Could not find schema version;" " checking for empty database...");
#line 3654 "rygel-media-export-media-cache.c"
		{
			RygelMediaExportDatabase* _tmp20_;
			gint _tmp21_ = 0;
			gint rows;
			gint _tmp22_;
#line 448 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp20_ = self->priv->db;
#line 448 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp21_ = rygel_media_export_database_query_value (_tmp20_, "SELECT count(type) FROM " "sqlite_master WHERE rowid=1", NULL, 0, &_inner_error_);
#line 448 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			rows = _tmp21_;
#line 448 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_inner_error_ != NULL) {
#line 448 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 3670 "rygel-media-export-media-cache.c"
					goto __catch9_rygel_media_export_database_error;
				}
#line 448 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_error_free0 (_error_);
#line 448 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 448 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_clear_error (&_inner_error_);
#line 448 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				return;
#line 3681 "rygel-media-export-media-cache.c"
			}
#line 450 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp22_ = rows;
#line 450 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_tmp22_ == 0) {
#line 3687 "rygel-media-export-media-cache.c"
				gboolean _tmp23_ = FALSE;
#line 451 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_debug ("rygel-media-export-media-cache.vala:451: Empty database, creating new " \
"schema version %s", RYGEL_MEDIA_EXPORT_SQL_FACTORY_schema_version);
#line 453 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp23_ = rygel_media_export_media_cache_create_schema (self);
#line 453 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				if (!_tmp23_) {
#line 454 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_object_unref0 (self->priv->db);
#line 454 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					self->priv->db = NULL;
#line 456 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					_g_error_free0 (_error_);
#line 456 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
					return;
#line 3703 "rygel-media-export-media-cache.c"
				}
			} else {
#line 459 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_warning ("rygel-media-export-media-cache.vala:459: Incompatible schema... cannot" \
" proceed");
#line 460 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_object_unref0 (self->priv->db);
#line 460 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				self->priv->db = NULL;
#line 462 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_error_free0 (_error_);
#line 462 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				return;
#line 3716 "rygel-media-export-media-cache.c"
			}
		}
		goto __finally9;
		__catch9_rygel_media_export_database_error:
		{
			GError* _error_ = NULL;
			GError* _tmp24_;
			const gchar* _tmp25_;
			GError* _tmp26_;
#line 447 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_error_ = _inner_error_;
#line 447 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_inner_error_ = NULL;
#line 465 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp24_ = _error_;
#line 465 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp25_ = _tmp24_->message;
#line 465 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_warning ("rygel-media-export-media-cache.vala:465: Something weird going on: %s", _tmp25_);
#line 466 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (self->priv->db);
#line 466 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			self->priv->db = NULL;
#line 468 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp26_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR, "Invalid database");
#line 468 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_inner_error_ = _tmp26_;
#line 468 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_error_free0 (_error_);
#line 3746 "rygel-media-export-media-cache.c"
			goto __finally9;
		}
		__finally9:
#line 447 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 447 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_error_free0 (_error_);
#line 3754 "rygel-media-export-media-cache.c"
			goto __finally8;
		}
#line 427 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_error_free0 (_error_);
#line 3759 "rygel-media-export-media-cache.c"
	}
	__finally8:
#line 427 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 427 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 427 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return;
#line 3768 "rygel-media-export-media-cache.c"
	}
}


static void rygel_media_export_media_cache_save_metadata (RygelMediaExportMediaCache* self, RygelMediaItem* item, GError** error) {
	RygelMediaItem* _tmp0_;
	gint64 _tmp1_;
	gint64 _tmp2_;
	GValue _tmp3_ = {0};
	RygelMediaItem* _tmp4_;
	const gchar* _tmp5_;
	GValue _tmp6_ = {0};
	GValue _tmp7_ = {0};
	GValue _tmp8_ = {0};
	RygelMediaItem* _tmp9_;
	const gchar* _tmp10_;
	GValue _tmp11_ = {0};
	GValue _tmp12_ = {0};
	GValue _tmp13_ = {0};
	GValue _tmp14_ = {0};
	GValue _tmp15_ = {0};
	RygelMediaItem* _tmp16_;
	const gchar* _tmp17_;
	GValue _tmp18_ = {0};
	GValue _tmp19_ = {0};
	GValue _tmp20_ = {0};
	GValue _tmp21_ = {0};
	GValue _tmp22_ = {0};
	GValue _tmp23_ = {0};
	GValue _tmp24_ = {0};
	GValue _tmp25_ = {0};
	RygelMediaItem* _tmp26_;
	const gchar* _tmp27_;
	GValue _tmp28_ = {0};
	RygelMediaItem* _tmp29_;
	const gchar* _tmp30_;
	GValue _tmp31_ = {0};
	GValue _tmp32_ = {0};
	GValue _tmp33_ = {0};
	GValue* _tmp34_ = NULL;
	GValue* values;
	gint values_length1;
	gint _values_size_;
	RygelMediaItem* _tmp35_;
	RygelMediaItem* _tmp86_;
	RygelMediaExportDatabase* _tmp115_;
	RygelMediaExportSQLFactory* _tmp116_;
	const gchar* _tmp117_ = NULL;
	GValue* _tmp118_;
	gint _tmp118__length1;
	GError * _inner_error_ = NULL;
#line 473 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 473 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (item != NULL);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = item;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = rygel_media_item_get_size (_tmp0_);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = _tmp1_;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp3_, G_TYPE_INT64);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int64 (&_tmp3_, _tmp2_);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = item;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = _tmp4_->mime_type;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp6_, G_TYPE_STRING);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp6_, _tmp5_);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp7_, G_TYPE_INT);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp7_, -1);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp8_, G_TYPE_INT);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp8_, -1);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_ = item;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp10_ = ((RygelMediaObject*) _tmp9_)->upnp_class;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp11_, G_TYPE_STRING);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp11_, _tmp10_);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_database_null (&_tmp12_);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp13_ = _tmp12_;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_database_null (&_tmp14_);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp15_ = _tmp14_;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp16_ = item;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp17_ = _tmp16_->date;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp18_, G_TYPE_STRING);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp18_, _tmp17_);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp19_, G_TYPE_INT);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp19_, -1);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp20_, G_TYPE_INT);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp20_, -1);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp21_, G_TYPE_INT);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp21_, -1);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp22_, G_TYPE_INT);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp22_, -1);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp23_, G_TYPE_INT);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp23_, -1);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp24_, G_TYPE_INT);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp24_, -1);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp25_, G_TYPE_INT);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp25_, -1);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_ = item;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp27_ = ((RygelMediaObject*) _tmp26_)->id;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp28_, G_TYPE_STRING);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp28_, _tmp27_);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp29_ = item;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp30_ = _tmp29_->dlna_profile;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp31_, G_TYPE_STRING);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp31_, _tmp30_);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_database_null (&_tmp32_);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp33_ = _tmp32_;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp34_ = g_new0 (GValue, 18);
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp34_[0] = _tmp3_;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp34_[1] = _tmp6_;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp34_[2] = _tmp7_;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp34_[3] = _tmp8_;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp34_[4] = _tmp11_;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp34_[5] = _tmp13_;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp34_[6] = _tmp15_;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp34_[7] = _tmp18_;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp34_[8] = _tmp19_;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp34_[9] = _tmp20_;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp34_[10] = _tmp21_;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp34_[11] = _tmp22_;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp34_[12] = _tmp23_;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp34_[13] = _tmp24_;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp34_[14] = _tmp25_;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp34_[15] = _tmp28_;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp34_[16] = _tmp31_;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp34_[17] = _tmp33_;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = _tmp34_;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values_length1 = 18;
#line 475 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_values_size_ = values_length1;
#line 494 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp35_ = item;
#line 494 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (RYGEL_IS_AUDIO_ITEM (_tmp35_)) {
#line 3970 "rygel-media-export-media-cache.c"
		RygelMediaItem* _tmp36_;
		RygelAudioItem* _tmp37_;
		RygelAudioItem* audio_item;
		GValue* _tmp38_;
		gint _tmp38__length1;
		RygelAudioItem* _tmp39_;
		glong _tmp40_;
		GValue _tmp41_ = {0};
		GValue _tmp42_;
		GValue* _tmp43_;
		gint _tmp43__length1;
		RygelAudioItem* _tmp44_;
		gint _tmp45_;
		GValue _tmp46_ = {0};
		GValue _tmp47_;
		GValue* _tmp48_;
		gint _tmp48__length1;
		RygelAudioItem* _tmp49_;
		gint _tmp50_;
		GValue _tmp51_ = {0};
		GValue _tmp52_;
		GValue* _tmp53_;
		gint _tmp53__length1;
		RygelAudioItem* _tmp54_;
		gint _tmp55_;
		GValue _tmp56_ = {0};
		GValue _tmp57_;
		GValue* _tmp58_;
		gint _tmp58__length1;
		RygelAudioItem* _tmp59_;
		gint _tmp60_;
		GValue _tmp61_ = {0};
		GValue _tmp62_;
		RygelMediaItem* _tmp63_;
#line 495 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp36_ = item;
#line 495 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp37_ = _g_object_ref0 (RYGEL_IS_AUDIO_ITEM (_tmp36_) ? ((RygelAudioItem*) _tmp36_) : NULL);
#line 495 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		audio_item = _tmp37_;
#line 496 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp38_ = values;
#line 496 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp38__length1 = values_length1;
#line 496 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp39_ = audio_item;
#line 496 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp40_ = _tmp39_->duration;
#line 496 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp41_, G_TYPE_LONG);
#line 496 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_long (&_tmp41_, _tmp40_);
#line 496 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&_tmp38_[14]) ? (g_value_unset (&_tmp38_[14]), NULL) : NULL;
#line 496 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp38_[14] = _tmp41_;
#line 496 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp42_ = _tmp38_[14];
#line 497 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp43_ = values;
#line 497 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp43__length1 = values_length1;
#line 497 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp44_ = audio_item;
#line 497 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp45_ = _tmp44_->bitrate;
#line 497 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp46_, G_TYPE_INT);
#line 497 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_int (&_tmp46_, _tmp45_);
#line 497 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&_tmp43_[8]) ? (g_value_unset (&_tmp43_[8]), NULL) : NULL;
#line 497 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp43_[8] = _tmp46_;
#line 497 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp47_ = _tmp43_[8];
#line 498 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp48_ = values;
#line 498 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp48__length1 = values_length1;
#line 498 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp49_ = audio_item;
#line 498 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp50_ = _tmp49_->sample_freq;
#line 498 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp51_, G_TYPE_INT);
#line 498 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_int (&_tmp51_, _tmp50_);
#line 498 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&_tmp48_[9]) ? (g_value_unset (&_tmp48_[9]), NULL) : NULL;
#line 498 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp48_[9] = _tmp51_;
#line 498 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp52_ = _tmp48_[9];
#line 499 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp53_ = values;
#line 499 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp53__length1 = values_length1;
#line 499 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp54_ = audio_item;
#line 499 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp55_ = _tmp54_->bits_per_sample;
#line 499 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp56_, G_TYPE_INT);
#line 499 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_int (&_tmp56_, _tmp55_);
#line 499 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&_tmp53_[10]) ? (g_value_unset (&_tmp53_[10]), NULL) : NULL;
#line 499 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp53_[10] = _tmp56_;
#line 499 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp57_ = _tmp53_[10];
#line 500 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp58_ = values;
#line 500 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp58__length1 = values_length1;
#line 500 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp59_ = audio_item;
#line 500 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp60_ = _tmp59_->channels;
#line 500 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp61_, G_TYPE_INT);
#line 500 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_int (&_tmp61_, _tmp60_);
#line 500 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&_tmp58_[11]) ? (g_value_unset (&_tmp58_[11]), NULL) : NULL;
#line 500 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp58_[11] = _tmp61_;
#line 500 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp62_ = _tmp58_[11];
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp63_ = item;
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (RYGEL_IS_MUSIC_ITEM (_tmp63_)) {
#line 4105 "rygel-media-export-media-cache.c"
			RygelMediaItem* _tmp64_;
			RygelMusicItem* _tmp65_;
			RygelMusicItem* music_item;
			GValue* _tmp66_;
			gint _tmp66__length1;
			RygelMusicItem* _tmp67_;
			const gchar* _tmp68_;
			GValue _tmp69_ = {0};
			GValue _tmp70_;
			GValue* _tmp71_;
			gint _tmp71__length1;
			RygelMusicItem* _tmp72_;
			const gchar* _tmp73_;
			GValue _tmp74_ = {0};
			GValue _tmp75_;
			GValue* _tmp76_;
			gint _tmp76__length1;
			RygelMusicItem* _tmp77_;
			const gchar* _tmp78_;
			GValue _tmp79_ = {0};
			GValue _tmp80_;
			GValue* _tmp81_;
			gint _tmp81__length1;
			RygelMusicItem* _tmp82_;
			gint _tmp83_;
			GValue _tmp84_ = {0};
			GValue _tmp85_;
#line 502 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp64_ = item;
#line 502 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp65_ = _g_object_ref0 (RYGEL_IS_MUSIC_ITEM (_tmp64_) ? ((RygelMusicItem*) _tmp64_) : NULL);
#line 502 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			music_item = _tmp65_;
#line 503 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp66_ = values;
#line 503 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp66__length1 = values_length1;
#line 503 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp67_ = music_item;
#line 503 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp68_ = _tmp67_->artist;
#line 503 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_init (&_tmp69_, G_TYPE_STRING);
#line 503 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_set_string (&_tmp69_, _tmp68_);
#line 503 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			G_IS_VALUE (&_tmp66_[5]) ? (g_value_unset (&_tmp66_[5]), NULL) : NULL;
#line 503 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp66_[5] = _tmp69_;
#line 503 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp70_ = _tmp66_[5];
#line 504 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp71_ = values;
#line 504 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp71__length1 = values_length1;
#line 504 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp72_ = music_item;
#line 504 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp73_ = _tmp72_->album;
#line 504 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_init (&_tmp74_, G_TYPE_STRING);
#line 504 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_set_string (&_tmp74_, _tmp73_);
#line 504 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			G_IS_VALUE (&_tmp71_[6]) ? (g_value_unset (&_tmp71_[6]), NULL) : NULL;
#line 504 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp71_[6] = _tmp74_;
#line 504 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp75_ = _tmp71_[6];
#line 505 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp76_ = values;
#line 505 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp76__length1 = values_length1;
#line 505 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp77_ = music_item;
#line 505 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp78_ = _tmp77_->genre;
#line 505 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_init (&_tmp79_, G_TYPE_STRING);
#line 505 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_set_string (&_tmp79_, _tmp78_);
#line 505 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			G_IS_VALUE (&_tmp76_[17]) ? (g_value_unset (&_tmp76_[17]), NULL) : NULL;
#line 505 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp76_[17] = _tmp79_;
#line 505 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp80_ = _tmp76_[17];
#line 506 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp81_ = values;
#line 506 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp81__length1 = values_length1;
#line 506 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp82_ = music_item;
#line 506 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp83_ = _tmp82_->track_number;
#line 506 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_init (&_tmp84_, G_TYPE_INT);
#line 506 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_set_int (&_tmp84_, _tmp83_);
#line 506 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			G_IS_VALUE (&_tmp81_[12]) ? (g_value_unset (&_tmp81_[12]), NULL) : NULL;
#line 506 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp81_[12] = _tmp84_;
#line 506 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp85_ = _tmp81_[12];
#line 501 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (music_item);
#line 4213 "rygel-media-export-media-cache.c"
		}
#line 494 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (audio_item);
#line 4217 "rygel-media-export-media-cache.c"
	}
#line 510 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp86_ = item;
#line 510 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (RYGEL_IS_VISUAL_ITEM (_tmp86_)) {
#line 4223 "rygel-media-export-media-cache.c"
		RygelMediaItem* _tmp87_;
		RygelVisualItem* _tmp88_;
		RygelVisualItem* visual_item;
		GValue* _tmp89_;
		gint _tmp89__length1;
		RygelVisualItem* _tmp90_;
		gint _tmp91_;
		gint _tmp92_;
		GValue _tmp93_ = {0};
		GValue _tmp94_;
		GValue* _tmp95_;
		gint _tmp95__length1;
		RygelVisualItem* _tmp96_;
		gint _tmp97_;
		gint _tmp98_;
		GValue _tmp99_ = {0};
		GValue _tmp100_;
		GValue* _tmp101_;
		gint _tmp101__length1;
		RygelVisualItem* _tmp102_;
		gint _tmp103_;
		gint _tmp104_;
		GValue _tmp105_ = {0};
		GValue _tmp106_;
		RygelMediaItem* _tmp107_;
#line 511 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp87_ = item;
#line 511 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp88_ = _g_object_ref0 (RYGEL_IS_VISUAL_ITEM (_tmp87_) ? ((RygelVisualItem*) _tmp87_) : NULL);
#line 511 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		visual_item = _tmp88_;
#line 512 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp89_ = values;
#line 512 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp89__length1 = values_length1;
#line 512 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp90_ = visual_item;
#line 512 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp91_ = rygel_visual_item_get_width (_tmp90_);
#line 512 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp92_ = _tmp91_;
#line 512 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp93_, G_TYPE_INT);
#line 512 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_int (&_tmp93_, _tmp92_);
#line 512 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&_tmp89_[2]) ? (g_value_unset (&_tmp89_[2]), NULL) : NULL;
#line 512 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp89_[2] = _tmp93_;
#line 512 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp94_ = _tmp89_[2];
#line 513 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp95_ = values;
#line 513 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp95__length1 = values_length1;
#line 513 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp96_ = visual_item;
#line 513 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp97_ = rygel_visual_item_get_height (_tmp96_);
#line 513 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp98_ = _tmp97_;
#line 513 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp99_, G_TYPE_INT);
#line 513 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_int (&_tmp99_, _tmp98_);
#line 513 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&_tmp95_[3]) ? (g_value_unset (&_tmp95_[3]), NULL) : NULL;
#line 513 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp95_[3] = _tmp99_;
#line 513 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp100_ = _tmp95_[3];
#line 514 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp101_ = values;
#line 514 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp101__length1 = values_length1;
#line 514 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp102_ = visual_item;
#line 514 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp103_ = rygel_visual_item_get_color_depth (_tmp102_);
#line 514 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp104_ = _tmp103_;
#line 514 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp105_, G_TYPE_INT);
#line 514 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_int (&_tmp105_, _tmp104_);
#line 514 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&_tmp101_[13]) ? (g_value_unset (&_tmp101_[13]), NULL) : NULL;
#line 514 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp101_[13] = _tmp105_;
#line 514 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp106_ = _tmp101_[13];
#line 515 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp107_ = item;
#line 515 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (RYGEL_IS_VIDEO_ITEM (_tmp107_)) {
#line 4319 "rygel-media-export-media-cache.c"
			RygelMediaItem* _tmp108_;
			RygelVideoItem* _tmp109_;
			RygelVideoItem* video_item;
			GValue* _tmp110_;
			gint _tmp110__length1;
			RygelVideoItem* _tmp111_;
			const gchar* _tmp112_;
			GValue _tmp113_ = {0};
			GValue _tmp114_;
#line 516 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp108_ = item;
#line 516 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp109_ = _g_object_ref0 (RYGEL_IS_VIDEO_ITEM (_tmp108_) ? ((RygelVideoItem*) _tmp108_) : NULL);
#line 516 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			video_item = _tmp109_;
#line 517 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp110_ = values;
#line 517 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp110__length1 = values_length1;
#line 517 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp111_ = video_item;
#line 517 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp112_ = _tmp111_->author;
#line 517 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_init (&_tmp113_, G_TYPE_STRING);
#line 517 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_set_string (&_tmp113_, _tmp112_);
#line 517 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			G_IS_VALUE (&_tmp110_[5]) ? (g_value_unset (&_tmp110_[5]), NULL) : NULL;
#line 517 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp110_[5] = _tmp113_;
#line 517 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp114_ = _tmp110_[5];
#line 515 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (video_item);
#line 4355 "rygel-media-export-media-cache.c"
		}
#line 510 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (visual_item);
#line 4359 "rygel-media-export-media-cache.c"
	}
#line 521 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp115_ = self->priv->db;
#line 521 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp116_ = self->priv->sql;
#line 521 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp117_ = rygel_media_export_sql_factory_make (_tmp116_, RYGEL_MEDIA_EXPORT_SQL_STRING_SAVE_METADATA);
#line 521 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp118_ = values;
#line 521 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp118__length1 = values_length1;
#line 521 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (_tmp115_, _tmp117_, _tmp118_, _tmp118__length1, &_inner_error_);
#line 521 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 521 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 521 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 521 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return;
#line 4381 "rygel-media-export-media-cache.c"
	}
#line 473 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 4385 "rygel-media-export-media-cache.c"
}


static void rygel_media_export_media_cache_create_object (RygelMediaExportMediaCache* self, RygelMediaObject* item, GError** error) {
	gint type;
	GValue parent = {0};
	RygelMediaObject* _tmp0_;
	RygelMediaObject* _tmp1_;
	RygelMediaContainer* _tmp2_;
	gchar* _tmp9_ = NULL;
	RygelMediaObject* _tmp10_;
	GeeArrayList* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	RygelMediaObject* _tmp17_;
	const gchar* _tmp18_;
	GValue _tmp19_ = {0};
	RygelMediaObject* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	GValue _tmp23_ = {0};
	gint _tmp24_;
	GValue _tmp25_ = {0};
	GValue _tmp26_;
	GValue _tmp27_ = {0};
	RygelMediaObject* _tmp28_;
	guint64 _tmp29_;
	GValue _tmp30_ = {0};
	const gchar* _tmp31_;
	GValue _tmp32_ = {0};
	GValue* _tmp33_ = NULL;
	GValue* values;
	gint values_length1;
	gint _values_size_;
	RygelMediaExportDatabase* _tmp34_;
	RygelMediaExportSQLFactory* _tmp35_;
	const gchar* _tmp36_ = NULL;
	GError * _inner_error_ = NULL;
#line 524 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 524 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (item != NULL);
#line 525 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	type = (gint) RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER;
#line 528 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = item;
#line 528 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (RYGEL_IS_MEDIA_ITEM (_tmp0_)) {
#line 529 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		type = (gint) RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM;
#line 4436 "rygel-media-export-media-cache.c"
	}
#line 532 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = item;
#line 532 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = _tmp1_->parent;
#line 532 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp2_ == NULL) {
#line 4444 "rygel-media-export-media-cache.c"
		GValue _tmp3_ = {0};
		GValue _tmp4_ = {0};
#line 533 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_null (&_tmp3_);
#line 533 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4_ = _tmp3_;
#line 533 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
#line 533 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		parent = _tmp4_;
#line 4455 "rygel-media-export-media-cache.c"
	} else {
		RygelMediaObject* _tmp5_;
		RygelMediaContainer* _tmp6_;
		const gchar* _tmp7_;
		GValue _tmp8_ = {0};
#line 535 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = item;
#line 535 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = _tmp5_->parent;
#line 535 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_ = ((RygelMediaObject*) _tmp6_)->id;
#line 535 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp8_, G_TYPE_STRING);
#line 535 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_set_string (&_tmp8_, _tmp7_);
#line 535 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
#line 535 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		parent = _tmp8_;
#line 4475 "rygel-media-export-media-cache.c"
	}
#line 543 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp10_ = item;
#line 543 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp11_ = _tmp10_->uris;
#line 543 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp12_ = gee_collection_get_size ((GeeCollection*) _tmp11_);
#line 543 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp13_ = _tmp12_;
#line 543 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp13_ == 0) {
#line 543 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (_tmp9_);
#line 543 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp9_ = NULL;
#line 4491 "rygel-media-export-media-cache.c"
	} else {
		RygelMediaObject* _tmp14_;
		GeeArrayList* _tmp15_;
		gpointer _tmp16_ = NULL;
#line 543 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp14_ = item;
#line 543 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp15_ = _tmp14_->uris;
#line 543 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, 0);
#line 543 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (_tmp9_);
#line 543 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp9_ = (gchar*) _tmp16_;
#line 4506 "rygel-media-export-media-cache.c"
	}
#line 538 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp17_ = item;
#line 538 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp18_ = _tmp17_->id;
#line 538 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp19_, G_TYPE_STRING);
#line 538 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp19_, _tmp18_);
#line 538 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp20_ = item;
#line 538 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp21_ = rygel_media_object_get_title (_tmp20_);
#line 538 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp22_ = _tmp21_;
#line 538 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp23_, G_TYPE_STRING);
#line 538 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp23_, _tmp22_);
#line 538 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp24_ = type;
#line 538 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp25_, G_TYPE_INT);
#line 538 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_int (&_tmp25_, _tmp24_);
#line 538 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp26_ = parent;
#line 538 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (G_IS_VALUE (&_tmp26_)) {
#line 538 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_init (&_tmp27_, G_VALUE_TYPE (&_tmp26_));
#line 538 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_copy (&_tmp26_, &_tmp27_);
#line 4540 "rygel-media-export-media-cache.c"
	} else {
#line 538 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp27_ = _tmp26_;
#line 4544 "rygel-media-export-media-cache.c"
	}
#line 538 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp28_ = item;
#line 538 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp29_ = _tmp28_->modified;
#line 538 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp30_, G_TYPE_UINT64);
#line 538 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_uint64 (&_tmp30_, _tmp29_);
#line 538 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp31_ = _tmp9_;
#line 538 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_init (&_tmp32_, G_TYPE_STRING);
#line 538 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_set_string (&_tmp32_, _tmp31_);
#line 538 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp33_ = g_new0 (GValue, 6);
#line 538 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp33_[0] = _tmp19_;
#line 538 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp33_[1] = _tmp23_;
#line 538 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp33_[2] = _tmp25_;
#line 538 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp33_[3] = _tmp27_;
#line 538 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp33_[4] = _tmp30_;
#line 538 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp33_[5] = _tmp32_;
#line 538 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = _tmp33_;
#line 538 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values_length1 = 6;
#line 538 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_values_size_ = values_length1;
#line 545 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp34_ = self->priv->db;
#line 545 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp35_ = self->priv->sql;
#line 545 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp36_ = rygel_media_export_sql_factory_make (_tmp35_, RYGEL_MEDIA_EXPORT_SQL_STRING_INSERT);
#line 545 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_database_exec (_tmp34_, _tmp36_, values, values_length1, &_inner_error_);
#line 545 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 545 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 545 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 545 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (_tmp9_);
#line 545 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
#line 545 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return;
#line 4600 "rygel-media-export-media-cache.c"
	}
#line 524 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	values = (_vala_GValue_array_free (values, values_length1), NULL);
#line 524 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (_tmp9_);
#line 524 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
#line 4608 "rygel-media-export-media-cache.c"
}


/**
     * Create the current schema.
     *
     * If schema creation fails, schema will be rolled back
     * completely.
     *
     * @returns: true on success, false on failure
     */
static gboolean rygel_media_export_media_cache_create_schema (RygelMediaExportMediaCache* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 556 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 4625 "rygel-media-export-media-cache.c"
	{
		RygelMediaExportDatabase* _tmp0_;
		RygelMediaExportDatabase* _tmp1_;
		RygelMediaExportSQLFactory* _tmp2_;
		const gchar* _tmp3_ = NULL;
		RygelMediaExportDatabase* _tmp4_;
		RygelMediaExportSQLFactory* _tmp5_;
		const gchar* _tmp6_ = NULL;
		RygelMediaExportDatabase* _tmp7_;
		RygelMediaExportSQLFactory* _tmp8_;
		const gchar* _tmp9_ = NULL;
		RygelMediaExportDatabase* _tmp10_;
		RygelMediaExportSQLFactory* _tmp11_;
		const gchar* _tmp12_ = NULL;
		RygelMediaExportDatabase* _tmp13_;
		RygelMediaExportSQLFactory* _tmp14_;
		const gchar* _tmp15_ = NULL;
		RygelMediaExportDatabase* _tmp16_;
		RygelMediaExportDatabase* _tmp17_;
#line 558 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp0_ = self->priv->db;
#line 558 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_begin (_tmp0_, &_inner_error_);
#line 558 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 4651 "rygel-media-export-media-cache.c"
			goto __catch10_g_error;
		}
#line 559 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp1_ = self->priv->db;
#line 559 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp2_ = self->priv->sql;
#line 559 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp3_ = rygel_media_export_sql_factory_make (_tmp2_, RYGEL_MEDIA_EXPORT_SQL_STRING_SCHEMA);
#line 559 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (_tmp1_, _tmp3_, NULL, 0, &_inner_error_);
#line 559 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 4664 "rygel-media-export-media-cache.c"
			goto __catch10_g_error;
		}
#line 560 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4_ = self->priv->db;
#line 560 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = self->priv->sql;
#line 560 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = rygel_media_export_sql_factory_make (_tmp5_, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_COMMON);
#line 560 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (_tmp4_, _tmp6_, NULL, 0, &_inner_error_);
#line 560 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 4677 "rygel-media-export-media-cache.c"
			goto __catch10_g_error;
		}
#line 561 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_ = self->priv->db;
#line 561 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp8_ = self->priv->sql;
#line 561 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp9_ = rygel_media_export_sql_factory_make (_tmp8_, RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_CLOSURE);
#line 561 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (_tmp7_, _tmp9_, NULL, 0, &_inner_error_);
#line 561 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 4690 "rygel-media-export-media-cache.c"
			goto __catch10_g_error;
		}
#line 562 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp10_ = self->priv->db;
#line 562 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp11_ = self->priv->sql;
#line 562 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp12_ = rygel_media_export_sql_factory_make (_tmp11_, RYGEL_MEDIA_EXPORT_SQL_STRING_INDEX_COMMON);
#line 562 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (_tmp10_, _tmp12_, NULL, 0, &_inner_error_);
#line 562 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 4703 "rygel-media-export-media-cache.c"
			goto __catch10_g_error;
		}
#line 563 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp13_ = self->priv->db;
#line 563 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp14_ = self->priv->sql;
#line 563 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp15_ = rygel_media_export_sql_factory_make (_tmp14_, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_CLOSURE);
#line 563 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_exec (_tmp13_, _tmp15_, NULL, 0, &_inner_error_);
#line 563 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 4716 "rygel-media-export-media-cache.c"
			goto __catch10_g_error;
		}
#line 564 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp16_ = self->priv->db;
#line 564 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_commit (_tmp16_, &_inner_error_);
#line 564 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 4725 "rygel-media-export-media-cache.c"
			goto __catch10_g_error;
		}
#line 565 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp17_ = self->priv->db;
#line 565 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_analyze (_tmp17_);
#line 567 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		result = TRUE;
#line 567 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return result;
#line 4736 "rygel-media-export-media-cache.c"
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* err = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
		RygelMediaExportDatabase* _tmp20_;
#line 557 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		err = _inner_error_;
#line 557 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_inner_error_ = NULL;
#line 569 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp18_ = err;
#line 569 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp19_ = _tmp18_->message;
#line 569 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_warning ("rygel-media-export-media-cache.vala:569: Failed to create schema: %s", _tmp19_);
#line 570 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp20_ = self->priv->db;
#line 570 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_media_export_database_rollback (_tmp20_);
#line 557 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_error_free0 (err);
#line 4761 "rygel-media-export-media-cache.c"
	}
	__finally10:
#line 557 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 557 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 557 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_clear_error (&_inner_error_);
#line 557 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return FALSE;
#line 4772 "rygel-media-export-media-cache.c"
	}
#line 573 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = FALSE;
#line 573 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 4778 "rygel-media-export-media-cache.c"
}


static RygelMediaObject* rygel_media_export_media_cache_get_object_from_statement (RygelMediaExportMediaCache* self, RygelMediaContainer* parent, sqlite3_stmt* statement) {
	RygelMediaObject* result = NULL;
	RygelMediaObject* object;
	sqlite3_stmt* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* title;
	sqlite3_stmt* _tmp2_;
	const gchar* _tmp3_ = NULL;
	const gchar* object_id;
	sqlite3_stmt* _tmp4_;
	const gchar* _tmp5_ = NULL;
	const gchar* uri;
	sqlite3_stmt* _tmp6_;
	gint _tmp7_ = 0;
	RygelMediaObject* _tmp32_;
#line 576 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 576 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (statement != NULL, NULL);
#line 578 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	object = NULL;
#line 579 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = statement;
#line 579 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = sqlite3_column_text (_tmp0_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TITLE);
#line 579 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	title = _tmp1_;
#line 580 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = statement;
#line 580 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = sqlite3_column_text (_tmp2_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ID);
#line 580 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	object_id = _tmp3_;
#line 581 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = statement;
#line 581 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = sqlite3_column_text (_tmp4_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_URI);
#line 581 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	uri = _tmp5_;
#line 583 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = statement;
#line 583 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = sqlite3_column_int (_tmp6_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TYPE);
#line 583 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	switch (_tmp7_) {
#line 583 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case 0:
#line 4829 "rygel-media-export-media-cache.c"
		{
			RygelMediaExportObjectFactory* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			RygelMediaExportDBContainer* _tmp12_ = NULL;
			RygelMediaObject* _tmp13_;
			RygelMediaContainer* _tmp14_;
			RygelMediaContainer* container;
			const gchar* _tmp15_;
#line 586 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp8_ = self->priv->factory;
#line 586 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp9_ = object_id;
#line 586 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp10_ = title;
#line 586 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp11_ = uri;
#line 586 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp12_ = rygel_media_export_object_factory_get_container (_tmp8_, self, _tmp9_, _tmp10_, (guint) 0, _tmp11_);
#line 586 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (object);
#line 586 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			object = (RygelMediaObject*) _tmp12_;
#line 588 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp13_ = object;
#line 588 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp14_ = _g_object_ref0 (RYGEL_IS_MEDIA_CONTAINER (_tmp13_) ? ((RygelMediaContainer*) _tmp13_) : NULL);
#line 588 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			container = _tmp14_;
#line 589 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp15_ = uri;
#line 589 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_tmp15_ != NULL) {
#line 4864 "rygel-media-export-media-cache.c"
				RygelMediaContainer* _tmp16_;
				GeeArrayList* _tmp17_;
				const gchar* _tmp18_;
#line 590 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp16_ = container;
#line 590 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp17_ = ((RygelMediaObject*) _tmp16_)->uris;
#line 590 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp18_ = uri;
#line 590 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, _tmp18_);
#line 4876 "rygel-media-export-media-cache.c"
			}
#line 592 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (container);
#line 592 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			break;
#line 4882 "rygel-media-export-media-cache.c"
		}
#line 583 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case 1:
#line 4886 "rygel-media-export-media-cache.c"
		{
			sqlite3_stmt* _tmp19_;
			const gchar* _tmp20_ = NULL;
			const gchar* upnp_class;
			RygelMediaExportObjectFactory* _tmp21_;
			RygelMediaContainer* _tmp22_;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			const gchar* _tmp25_;
			RygelMediaItem* _tmp26_ = NULL;
			sqlite3_stmt* _tmp27_;
			RygelMediaObject* _tmp28_;
			const gchar* _tmp29_;
#line 595 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp19_ = statement;
#line 595 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp20_ = sqlite3_column_text (_tmp19_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CLASS);
#line 595 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			upnp_class = _tmp20_;
#line 597 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp21_ = self->priv->factory;
#line 597 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp22_ = parent;
#line 597 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp23_ = object_id;
#line 597 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp24_ = title;
#line 597 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp25_ = upnp_class;
#line 597 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp26_ = rygel_media_export_object_factory_get_item (_tmp21_, self, _tmp22_, _tmp23_, _tmp24_, _tmp25_);
#line 597 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (object);
#line 597 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			object = (RygelMediaObject*) _tmp26_;
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp27_ = statement;
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp28_ = object;
#line 602 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			rygel_media_export_media_cache_fill_item (self, _tmp27_, RYGEL_IS_MEDIA_ITEM (_tmp28_) ? ((RygelMediaItem*) _tmp28_) : NULL);
#line 604 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp29_ = uri;
#line 604 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (_tmp29_ != NULL) {
#line 4932 "rygel-media-export-media-cache.c"
				RygelMediaObject* _tmp30_;
				const gchar* _tmp31_;
#line 605 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp30_ = object;
#line 605 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp31_ = uri;
#line 605 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				rygel_media_item_add_uri (RYGEL_IS_MEDIA_ITEM (_tmp30_) ? ((RygelMediaItem*) _tmp30_) : NULL, _tmp31_);
#line 4941 "rygel-media-export-media-cache.c"
			}
#line 607 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			break;
#line 4945 "rygel-media-export-media-cache.c"
		}
		default:
		{
#line 609 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_assert_not_reached ();
#line 4951 "rygel-media-export-media-cache.c"
		}
	}
#line 612 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp32_ = object;
#line 612 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp32_ != NULL) {
#line 4958 "rygel-media-export-media-cache.c"
		RygelMediaObject* _tmp33_;
		sqlite3_stmt* _tmp34_;
		gint64 _tmp35_ = 0LL;
#line 613 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp33_ = object;
#line 613 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp34_ = statement;
#line 613 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp35_ = sqlite3_column_int64 (_tmp34_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TIMESTAMP);
#line 613 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp33_->modified = (guint64) _tmp35_;
#line 4970 "rygel-media-export-media-cache.c"
	}
#line 616 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = object;
#line 616 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 4976 "rygel-media-export-media-cache.c"
}


static void rygel_media_export_media_cache_fill_item (RygelMediaExportMediaCache* self, sqlite3_stmt* statement, RygelMediaItem* item) {
	RygelMediaItem* _tmp0_;
	sqlite3_stmt* _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	RygelMediaItem* _tmp4_;
	sqlite3_stmt* _tmp5_;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	RygelMediaItem* _tmp8_;
	sqlite3_stmt* _tmp9_;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	RygelMediaItem* _tmp12_;
	sqlite3_stmt* _tmp13_;
	gint64 _tmp14_ = 0LL;
	RygelMediaItem* _tmp15_;
	RygelMediaItem* _tmp52_;
#line 619 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (self != NULL);
#line 619 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (statement != NULL);
#line 619 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_if_fail (item != NULL);
#line 621 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = item;
#line 621 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = statement;
#line 621 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = sqlite3_column_text (_tmp1_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DATE);
#line 621 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 621 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (_tmp0_->date);
#line 621 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_->date = _tmp3_;
#line 622 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = item;
#line 622 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = statement;
#line 622 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = sqlite3_column_text (_tmp5_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_MIME_TYPE);
#line 622 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 622 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (_tmp4_->mime_type);
#line 622 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_->mime_type = _tmp7_;
#line 623 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp8_ = item;
#line 623 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_ = statement;
#line 623 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp10_ = sqlite3_column_text (_tmp9_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DLNA_PROFILE);
#line 623 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp11_ = g_strdup (_tmp10_);
#line 623 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (_tmp8_->dlna_profile);
#line 623 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp8_->dlna_profile = _tmp11_;
#line 624 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp12_ = item;
#line 624 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp13_ = statement;
#line 624 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp14_ = sqlite3_column_int64 (_tmp13_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_SIZE);
#line 624 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_item_set_size (_tmp12_, _tmp14_);
#line 626 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp15_ = item;
#line 626 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (RYGEL_IS_AUDIO_ITEM (_tmp15_)) {
#line 5052 "rygel-media-export-media-cache.c"
		RygelMediaItem* _tmp16_;
		RygelAudioItem* _tmp17_;
		RygelAudioItem* audio_item;
		RygelAudioItem* _tmp18_;
		sqlite3_stmt* _tmp19_;
		gint64 _tmp20_ = 0LL;
		RygelAudioItem* _tmp21_;
		sqlite3_stmt* _tmp22_;
		gint _tmp23_ = 0;
		RygelAudioItem* _tmp24_;
		sqlite3_stmt* _tmp25_;
		gint _tmp26_ = 0;
		RygelAudioItem* _tmp27_;
		sqlite3_stmt* _tmp28_;
		gint _tmp29_ = 0;
		RygelAudioItem* _tmp30_;
		sqlite3_stmt* _tmp31_;
		gint _tmp32_ = 0;
		RygelMediaItem* _tmp33_;
#line 627 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp16_ = item;
#line 627 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp17_ = _g_object_ref0 (RYGEL_IS_AUDIO_ITEM (_tmp16_) ? ((RygelAudioItem*) _tmp16_) : NULL);
#line 627 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		audio_item = _tmp17_;
#line 628 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp18_ = audio_item;
#line 628 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp19_ = statement;
#line 628 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp20_ = sqlite3_column_int64 (_tmp19_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DURATION);
#line 628 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp18_->duration = (glong) _tmp20_;
#line 630 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp21_ = audio_item;
#line 630 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp22_ = statement;
#line 630 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp23_ = sqlite3_column_int (_tmp22_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_BITRATE);
#line 630 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp21_->bitrate = _tmp23_;
#line 631 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp24_ = audio_item;
#line 631 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp25_ = statement;
#line 631 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp26_ = sqlite3_column_int (_tmp25_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_SAMPLE_FREQ);
#line 631 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp24_->sample_freq = _tmp26_;
#line 633 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp27_ = audio_item;
#line 633 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp28_ = statement;
#line 633 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp29_ = sqlite3_column_int (_tmp28_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_BITS_PER_SAMPLE);
#line 633 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp27_->bits_per_sample = _tmp29_;
#line 635 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp30_ = audio_item;
#line 635 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp31_ = statement;
#line 635 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp32_ = sqlite3_column_int (_tmp31_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CHANNELS);
#line 635 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp30_->channels = _tmp32_;
#line 636 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp33_ = item;
#line 636 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (RYGEL_IS_MUSIC_ITEM (_tmp33_)) {
#line 5122 "rygel-media-export-media-cache.c"
			RygelMediaItem* _tmp34_;
			RygelMusicItem* _tmp35_;
			RygelMusicItem* music_item;
			RygelMusicItem* _tmp36_;
			sqlite3_stmt* _tmp37_;
			const gchar* _tmp38_ = NULL;
			gchar* _tmp39_;
			RygelMusicItem* _tmp40_;
			sqlite3_stmt* _tmp41_;
			const gchar* _tmp42_ = NULL;
			gchar* _tmp43_;
			RygelMusicItem* _tmp44_;
			sqlite3_stmt* _tmp45_;
			const gchar* _tmp46_ = NULL;
			gchar* _tmp47_;
			RygelMusicItem* _tmp48_;
			sqlite3_stmt* _tmp49_;
			gint _tmp50_ = 0;
			RygelMusicItem* _tmp51_;
#line 637 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp34_ = item;
#line 637 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp35_ = _g_object_ref0 (RYGEL_IS_MUSIC_ITEM (_tmp34_) ? ((RygelMusicItem*) _tmp34_) : NULL);
#line 637 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			music_item = _tmp35_;
#line 638 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp36_ = music_item;
#line 638 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp37_ = statement;
#line 638 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp38_ = sqlite3_column_text (_tmp37_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_AUTHOR);
#line 638 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp39_ = g_strdup (_tmp38_);
#line 638 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (_tmp36_->artist);
#line 638 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp36_->artist = _tmp39_;
#line 639 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp40_ = music_item;
#line 639 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp41_ = statement;
#line 639 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp42_ = sqlite3_column_text (_tmp41_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ALBUM);
#line 639 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp43_ = g_strdup (_tmp42_);
#line 639 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (_tmp40_->album);
#line 639 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp40_->album = _tmp43_;
#line 640 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp44_ = music_item;
#line 640 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp45_ = statement;
#line 640 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp46_ = sqlite3_column_text (_tmp45_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_GENRE);
#line 640 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp47_ = g_strdup (_tmp46_);
#line 640 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (_tmp44_->genre);
#line 640 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp44_->genre = _tmp47_;
#line 641 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp48_ = music_item;
#line 641 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp49_ = statement;
#line 641 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp50_ = sqlite3_column_int (_tmp49_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TRACK);
#line 641 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp48_->track_number = _tmp50_;
#line 643 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp51_ = music_item;
#line 643 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			rygel_music_item_lookup_album_art (_tmp51_);
#line 636 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (music_item);
#line 5198 "rygel-media-export-media-cache.c"
		}
#line 626 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (audio_item);
#line 5202 "rygel-media-export-media-cache.c"
	}
#line 647 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp52_ = item;
#line 647 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (RYGEL_IS_VISUAL_ITEM (_tmp52_)) {
#line 5208 "rygel-media-export-media-cache.c"
		RygelMediaItem* _tmp53_;
		RygelVisualItem* _tmp54_;
		RygelVisualItem* visual_item;
		RygelVisualItem* _tmp55_;
		sqlite3_stmt* _tmp56_;
		gint _tmp57_ = 0;
		RygelVisualItem* _tmp58_;
		sqlite3_stmt* _tmp59_;
		gint _tmp60_ = 0;
		RygelVisualItem* _tmp61_;
		sqlite3_stmt* _tmp62_;
		gint _tmp63_ = 0;
		RygelMediaItem* _tmp64_;
#line 648 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp53_ = item;
#line 648 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp54_ = _g_object_ref0 (RYGEL_IS_VISUAL_ITEM (_tmp53_) ? ((RygelVisualItem*) _tmp53_) : NULL);
#line 648 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		visual_item = _tmp54_;
#line 649 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp55_ = visual_item;
#line 649 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp56_ = statement;
#line 649 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp57_ = sqlite3_column_int (_tmp56_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_WIDTH);
#line 649 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_visual_item_set_width (_tmp55_, _tmp57_);
#line 650 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp58_ = visual_item;
#line 650 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp59_ = statement;
#line 650 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp60_ = sqlite3_column_int (_tmp59_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_HEIGHT);
#line 650 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_visual_item_set_height (_tmp58_, _tmp60_);
#line 651 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp61_ = visual_item;
#line 651 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp62_ = statement;
#line 651 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp63_ = sqlite3_column_int (_tmp62_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_COLOR_DEPTH);
#line 651 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		rygel_visual_item_set_color_depth (_tmp61_, _tmp63_);
#line 653 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp64_ = item;
#line 653 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (RYGEL_IS_VIDEO_ITEM (_tmp64_)) {
#line 5256 "rygel-media-export-media-cache.c"
			RygelMediaItem* _tmp65_;
			RygelVideoItem* _tmp66_;
			RygelVideoItem* video_item;
			RygelVideoItem* _tmp67_;
			sqlite3_stmt* _tmp68_;
			const gchar* _tmp69_ = NULL;
			gchar* _tmp70_;
#line 654 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp65_ = item;
#line 654 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp66_ = _g_object_ref0 (RYGEL_IS_VIDEO_ITEM (_tmp65_) ? ((RygelVideoItem*) _tmp65_) : NULL);
#line 654 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			video_item = _tmp66_;
#line 655 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp67_ = video_item;
#line 655 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp68_ = statement;
#line 655 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp69_ = sqlite3_column_text (_tmp68_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_AUTHOR);
#line 655 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp70_ = g_strdup (_tmp69_);
#line 655 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (_tmp67_->author);
#line 655 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp67_->author = _tmp70_;
#line 653 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (video_item);
#line 5284 "rygel-media-export-media-cache.c"
		}
#line 647 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_object_unref0 (visual_item);
#line 5288 "rygel-media-export-media-cache.c"
	}
}


static gchar* rygel_media_export_media_cache_translate_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, GValueArray* args, const gchar* prefix, GError** error) {
	gchar* result = NULL;
	RygelSearchExpression* _tmp0_;
	RygelSearchExpression* _tmp2_;
	GValueArray* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* filter;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
#line 660 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 660 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 660 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (prefix != NULL, NULL);
#line 665 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = expression;
#line 665 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp0_ == NULL) {
#line 5314 "rygel-media-export-media-cache.c"
		gchar* _tmp1_;
#line 666 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp1_ = g_strdup ("");
#line 666 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		result = _tmp1_;
#line 666 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return result;
#line 5322 "rygel-media-export-media-cache.c"
	}
#line 669 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = expression;
#line 669 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = args;
#line 669 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = rygel_media_export_media_cache_search_expression_to_sql (self, _tmp2_, _tmp3_, &_inner_error_);
#line 669 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	filter = _tmp4_;
#line 669 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 669 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 669 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 5338 "rygel-media-export-media-cache.c"
	}
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = prefix;
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = filter;
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = g_strdup_printf (" %s %s", _tmp5_, _tmp6_);
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp7_;
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (filter);
#line 671 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 5352 "rygel-media-export-media-cache.c"
}


static gchar* rygel_media_export_media_cache_search_expression_to_sql (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, GValueArray* args, GError** error) {
	gchar* result = NULL;
	RygelSearchExpression* _tmp0_;
	RygelSearchExpression* _tmp2_;
	GError * _inner_error_ = NULL;
#line 674 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 674 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 677 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = expression;
#line 677 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp0_ == NULL) {
#line 5369 "rygel-media-export-media-cache.c"
		gchar* _tmp1_;
#line 678 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp1_ = g_strdup ("");
#line 678 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		result = _tmp1_;
#line 678 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return result;
#line 5377 "rygel-media-export-media-cache.c"
	}
#line 681 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = expression;
#line 681 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (RYGEL_IS_LOGICAL_EXPRESSION (_tmp2_)) {
#line 5383 "rygel-media-export-media-cache.c"
		RygelSearchExpression* _tmp3_;
		GValueArray* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
#line 682 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp3_ = expression;
#line 682 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp4_ = args;
#line 682 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp5_ = rygel_media_export_media_cache_logical_expression_to_sql (self, RYGEL_IS_LOGICAL_EXPRESSION (_tmp3_) ? ((RygelLogicalExpression*) _tmp3_) : NULL, _tmp4_, &_inner_error_);
#line 682 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp6_ = _tmp5_;
#line 682 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 682 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 682 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 5402 "rygel-media-export-media-cache.c"
		}
#line 682 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		result = _tmp6_;
#line 682 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return result;
#line 5408 "rygel-media-export-media-cache.c"
	} else {
		RygelSearchExpression* _tmp7_;
		GValueArray* _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
#line 685 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp7_ = expression;
#line 685 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp8_ = args;
#line 685 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp9_ = rygel_media_export_media_cache_relational_expression_to_sql (self, RYGEL_IS_RELATIONAL_EXPRESSION (_tmp7_) ? ((RygelRelationalExpression*) _tmp7_) : NULL, _tmp8_, &_inner_error_);
#line 685 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp10_ = _tmp9_;
#line 685 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_ != NULL) {
#line 685 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 685 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 5428 "rygel-media-export-media-cache.c"
		}
#line 685 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		result = _tmp10_;
#line 685 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return result;
#line 5434 "rygel-media-export-media-cache.c"
	}
}


static gchar* rygel_media_export_media_cache_logical_expression_to_sql (RygelMediaExportMediaCache* self, RygelLogicalExpression* expression, GValueArray* args, GError** error) {
	gchar* result = NULL;
	RygelLogicalExpression* _tmp0_;
	gconstpointer _tmp1_;
	GValueArray* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* left_sql_string;
	RygelLogicalExpression* _tmp4_;
	gconstpointer _tmp5_;
	GValueArray* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* right_sql_string;
	gchar* _tmp8_;
	gchar* operator_sql_string;
	RygelLogicalExpression* _tmp9_;
	gconstpointer _tmp10_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_ = NULL;
	GError * _inner_error_ = NULL;
#line 691 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 691 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 694 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = expression;
#line 694 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = ((RygelSearchExpression*) _tmp0_)->operand1;
#line 694 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = args;
#line 694 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = rygel_media_export_media_cache_search_expression_to_sql (self, (RygelSearchExpression*) _tmp1_, _tmp2_, &_inner_error_);
#line 694 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	left_sql_string = _tmp3_;
#line 694 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 694 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 694 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 5480 "rygel-media-export-media-cache.c"
	}
#line 696 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = expression;
#line 696 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = ((RygelSearchExpression*) _tmp4_)->operand2;
#line 696 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = args;
#line 696 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp7_ = rygel_media_export_media_cache_search_expression_to_sql (self, (RygelSearchExpression*) _tmp5_, _tmp6_, &_inner_error_);
#line 696 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	right_sql_string = _tmp7_;
#line 696 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 696 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 696 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (left_sql_string);
#line 696 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 5500 "rygel-media-export-media-cache.c"
	}
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp8_ = g_strdup ("OR");
#line 698 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	operator_sql_string = _tmp8_;
#line 700 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp9_ = expression;
#line 700 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp10_ = ((RygelSearchExpression*) _tmp9_)->op;
#line 700 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (GPOINTER_TO_INT (_tmp10_) == RYGEL_LOGICAL_OPERATOR_AND) {
#line 5512 "rygel-media-export-media-cache.c"
		gchar* _tmp11_;
#line 701 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp11_ = g_strdup ("AND");
#line 701 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (operator_sql_string);
#line 701 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		operator_sql_string = _tmp11_;
#line 5520 "rygel-media-export-media-cache.c"
	}
#line 704 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp12_ = left_sql_string;
#line 704 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp13_ = operator_sql_string;
#line 704 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp14_ = right_sql_string;
#line 704 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp15_ = g_strdup_printf ("(%s %s %s)", _tmp12_, _tmp13_, _tmp14_);
#line 704 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp15_;
#line 704 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (operator_sql_string);
#line 704 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (right_sql_string);
#line 704 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (left_sql_string);
#line 704 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 5540 "rygel-media-export-media-cache.c"
}


static gchar* rygel_media_export_media_cache_map_operand_to_column (RygelMediaExportMediaCache* self, const gchar* operand, gchar** collate, GError** error) {
	gchar* _vala_collate = NULL;
	gchar* result = NULL;
	gchar* column;
	gboolean use_collation;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
#line 715 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label0 = 0;
#line 715 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label1 = 0;
#line 715 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label2 = 0;
#line 715 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label3 = 0;
#line 715 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label4 = 0;
#line 715 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label5 = 0;
#line 715 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label6 = 0;
#line 715 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label7 = 0;
#line 715 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label8 = 0;
#line 715 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label9 = 0;
#line 715 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label10 = 0;
#line 715 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label11 = 0;
#line 715 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	static GQuark _tmp2_label12 = 0;
#line 5578 "rygel-media-export-media-cache.c"
	gboolean _tmp19_;
	GError * _inner_error_ = NULL;
#line 709 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 709 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (operand != NULL, NULL);
#line 712 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	column = NULL;
#line 713 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	use_collation = FALSE;
#line 715 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = operand;
#line 715 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = _tmp0_;
#line 715 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 715 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("res")))) {
#line 715 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 5599 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp4_;
#line 717 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp4_ = g_strdup ("o.uri");
#line 717 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 717 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp4_;
#line 718 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 5611 "rygel-media-export-media-cache.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("res@duration")))) {
#line 715 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 5617 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp5_;
#line 720 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp5_ = g_strdup ("m.duration");
#line 720 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 720 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp5_;
#line 721 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 5629 "rygel-media-export-media-cache.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("@refID")))) {
#line 715 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 5635 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp6_;
#line 723 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp6_ = g_strdup ("NULL");
#line 723 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 723 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp6_;
#line 724 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 5647 "rygel-media-export-media-cache.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("@id")))) {
#line 715 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 5653 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp7_;
#line 726 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp7_ = g_strdup ("o.upnp_id");
#line 726 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 726 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp7_;
#line 727 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 5665 "rygel-media-export-media-cache.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("@parentID")))) {
#line 715 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 5671 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp8_;
#line 729 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp8_ = g_strdup ("o.parent");
#line 729 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 729 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp8_;
#line 730 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 5683 "rygel-media-export-media-cache.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("upnp:class")))) {
#line 715 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 5689 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp9_;
#line 732 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp9_ = g_strdup ("m.class");
#line 732 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 732 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp9_;
#line 733 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 5701 "rygel-media-export-media-cache.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("dc:title")))) {
#line 715 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 5707 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp10_;
#line 735 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp10_ = g_strdup ("o.title");
#line 735 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 735 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp10_;
#line 736 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				use_collation = TRUE;
#line 737 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 5721 "rygel-media-export-media-cache.c"
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("upnp:artist")))) || (_tmp3_ == ((0 != _tmp2_label8) ? _tmp2_label8 : (_tmp2_label8 = g_quark_from_static_string ("dc:creator"))))) {
#line 715 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 5727 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp11_;
#line 740 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp11_ = g_strdup ("m.author");
#line 740 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 740 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp11_;
#line 741 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				use_collation = TRUE;
#line 742 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 5741 "rygel-media-export-media-cache.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label9) ? _tmp2_label9 : (_tmp2_label9 = g_quark_from_static_string ("dc:date")))) {
#line 715 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 5747 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp12_;
#line 744 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp12_ = g_strdup ("strftime(\"%Y\", m.date)");
#line 744 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 744 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp12_;
#line 745 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 5759 "rygel-media-export-media-cache.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label10) ? _tmp2_label10 : (_tmp2_label10 = g_quark_from_static_string ("upnp:album")))) {
#line 715 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 5765 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp13_;
#line 747 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp13_ = g_strdup ("m.album");
#line 747 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 747 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp13_;
#line 748 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				use_collation = TRUE;
#line 749 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 5779 "rygel-media-export-media-cache.c"
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label11) ? _tmp2_label11 : (_tmp2_label11 = g_quark_from_static_string ("upnp:genre")))) || (_tmp3_ == ((0 != _tmp2_label12) ? _tmp2_label12 : (_tmp2_label12 = g_quark_from_static_string ("dc:genre"))))) {
#line 715 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 5785 "rygel-media-export-media-cache.c"
			default:
			{
				gchar* _tmp14_;
#line 753 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp14_ = g_strdup ("m.genre");
#line 753 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 753 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				column = _tmp14_;
#line 754 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				use_collation = TRUE;
#line 755 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				break;
#line 5799 "rygel-media-export-media-cache.c"
			}
		}
	} else {
#line 715 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		switch (0) {
#line 5805 "rygel-media-export-media-cache.c"
			default:
			{
				const gchar* _tmp15_;
				gchar* _tmp16_ = NULL;
				gchar* message;
				const gchar* _tmp17_;
				GError* _tmp18_;
#line 757 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp15_ = operand;
#line 757 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp16_ = g_strdup_printf ("Unsupported column %s", _tmp15_);
#line 757 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				message = _tmp16_;
#line 759 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp17_ = message;
#line 759 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp18_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_UNSUPPORTED_SEARCH, _tmp17_);
#line 759 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_inner_error_ = _tmp18_;
#line 759 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				g_propagate_error (error, _inner_error_);
#line 759 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (message);
#line 759 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (column);
#line 759 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				return NULL;
#line 5833 "rygel-media-export-media-cache.c"
			}
		}
	}
#line 762 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp19_ = use_collation;
#line 762 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp19_) {
#line 5841 "rygel-media-export-media-cache.c"
		gchar* _tmp20_;
#line 763 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp20_ = g_strdup ("COLLATE CASEFOLD");
#line 763 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (_vala_collate);
#line 763 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_vala_collate = _tmp20_;
#line 5849 "rygel-media-export-media-cache.c"
	} else {
		gchar* _tmp21_;
#line 765 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp21_ = g_strdup ("");
#line 765 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (_vala_collate);
#line 765 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_vala_collate = _tmp21_;
#line 5858 "rygel-media-export-media-cache.c"
	}
#line 768 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = column;
#line 768 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (collate) {
#line 768 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		*collate = _vala_collate;
#line 5866 "rygel-media-export-media-cache.c"
	} else {
#line 768 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (_vala_collate);
#line 5870 "rygel-media-export-media-cache.c"
	}
#line 768 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 5874 "rygel-media-export-media-cache.c"
}


static void _vala_GValue_free (GValue* self) {
#line 777 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_value_unset (self);
#line 777 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_free (self);
#line 5883 "rygel-media-export-media-cache.c"
}


static gchar* rygel_media_export_media_cache_relational_expression_to_sql (RygelMediaExportMediaCache* self, RygelRelationalExpression* exp, GValueArray* args, GError** error) {
	gchar* result = NULL;
	GValue* v;
	gchar* collate;
	RygelRelationalExpression* _tmp0_;
	gconstpointer _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* column;
	RygelMediaExportSqlOperator* operator = NULL;
	RygelRelationalExpression* _tmp4_;
	gconstpointer _tmp5_;
	GValue* _tmp40_;
	RygelMediaExportSqlOperator* _tmp44_;
	gchar* _tmp45_ = NULL;
	GError * _inner_error_ = NULL;
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 771 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 774 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	v = NULL;
#line 775 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	collate = NULL;
#line 777 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = exp;
#line 777 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = ((RygelSearchExpression*) _tmp0_)->operand1;
#line 777 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = rygel_media_export_media_cache_map_operand_to_column (self, (const gchar*) _tmp1_, &_tmp2_, &_inner_error_);
#line 777 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (collate);
#line 777 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	collate = _tmp2_;
#line 777 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	column = _tmp3_;
#line 777 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 777 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 777 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_g_free0 (collate);
#line 777 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		__vala_GValue_free0 (v);
#line 777 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		return NULL;
#line 5933 "rygel-media-export-media-cache.c"
	}
#line 780 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = exp;
#line 780 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = ((RygelSearchExpression*) _tmp4_)->op;
#line 780 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	switch (GPOINTER_TO_INT (_tmp5_)) {
#line 780 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case GUPNP_SEARCH_CRITERIA_OP_EXISTS:
#line 5943 "rygel-media-export-media-cache.c"
		{
			gchar* sql_function = NULL;
			RygelRelationalExpression* _tmp6_;
			gconstpointer _tmp7_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_ = NULL;
#line 783 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp6_ = exp;
#line 783 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp7_ = ((RygelSearchExpression*) _tmp6_)->operand2;
#line 783 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			if (g_strcmp0 ((const gchar*) _tmp7_, "true") == 0) {
#line 5958 "rygel-media-export-media-cache.c"
				gchar* _tmp8_;
#line 784 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp8_ = g_strdup ("%s IS NOT NULL AND %s != ''");
#line 784 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (sql_function);
#line 784 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				sql_function = _tmp8_;
#line 5966 "rygel-media-export-media-cache.c"
			} else {
				gchar* _tmp9_;
#line 786 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_tmp9_ = g_strdup ("%s IS NULL OR %s = ''");
#line 786 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				_g_free0 (sql_function);
#line 786 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
				sql_function = _tmp9_;
#line 5975 "rygel-media-export-media-cache.c"
			}
#line 789 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp10_ = sql_function;
#line 789 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp11_ = column;
#line 789 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp12_ = column;
#line 789 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp13_ = g_strdup_printf (_tmp10_, _tmp11_, _tmp12_);
#line 789 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			result = _tmp13_;
#line 789 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (sql_function);
#line 789 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (operator);
#line 789 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (column);
#line 789 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (collate);
#line 789 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			__vala_GValue_free0 (v);
#line 789 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return result;
#line 5999 "rygel-media-export-media-cache.c"
		}
#line 780 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case GUPNP_SEARCH_CRITERIA_OP_EQ:
#line 780 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case GUPNP_SEARCH_CRITERIA_OP_NEQ:
#line 780 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case GUPNP_SEARCH_CRITERIA_OP_LESS:
#line 780 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case GUPNP_SEARCH_CRITERIA_OP_LEQ:
#line 780 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case GUPNP_SEARCH_CRITERIA_OP_GREATER:
#line 780 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case GUPNP_SEARCH_CRITERIA_OP_GEQ:
#line 6013 "rygel-media-export-media-cache.c"
		{
			RygelRelationalExpression* _tmp14_;
			gconstpointer _tmp15_;
			GValue* _tmp16_ = NULL;
			RygelRelationalExpression* _tmp17_;
			gconstpointer _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			RygelMediaExportSqlOperator* _tmp21_;
#line 796 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp14_ = exp;
#line 796 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp15_ = ((RygelSearchExpression*) _tmp14_)->operand2;
#line 796 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp16_ = g_new0 (GValue, 1);
#line 796 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_init (_tmp16_, G_TYPE_STRING);
#line 796 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_set_string (_tmp16_, (const gchar*) _tmp15_);
#line 796 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			__vala_GValue_free0 (v);
#line 796 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			v = _tmp16_;
#line 797 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp17_ = exp;
#line 797 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp18_ = ((RygelSearchExpression*) _tmp17_)->op;
#line 797 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp19_ = column;
#line 797 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp20_ = collate;
#line 797 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp21_ = rygel_media_export_sql_operator_new_from_search_criteria_op (GPOINTER_TO_INT (_tmp18_), _tmp19_, _tmp20_);
#line 797 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (operator);
#line 797 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			operator = _tmp21_;
#line 799 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			break;
#line 6053 "rygel-media-export-media-cache.c"
		}
#line 780 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case GUPNP_SEARCH_CRITERIA_OP_CONTAINS:
#line 6057 "rygel-media-export-media-cache.c"
		{
			const gchar* _tmp22_;
			RygelMediaExportSqlFunction* _tmp23_;
			RygelRelationalExpression* _tmp24_;
			gconstpointer _tmp25_;
			GValue* _tmp26_ = NULL;
#line 801 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp22_ = column;
#line 801 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp23_ = rygel_media_export_sql_function_new ("contains", _tmp22_);
#line 801 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (operator);
#line 801 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			operator = (RygelMediaExportSqlOperator*) _tmp23_;
#line 802 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp24_ = exp;
#line 802 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp25_ = ((RygelSearchExpression*) _tmp24_)->operand2;
#line 802 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp26_ = g_new0 (GValue, 1);
#line 802 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_init (_tmp26_, G_TYPE_STRING);
#line 802 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_set_string (_tmp26_, (const gchar*) _tmp25_);
#line 802 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			__vala_GValue_free0 (v);
#line 802 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			v = _tmp26_;
#line 803 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			break;
#line 6088 "rygel-media-export-media-cache.c"
		}
#line 780 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case GUPNP_SEARCH_CRITERIA_OP_DOES_NOT_CONTAIN:
#line 6092 "rygel-media-export-media-cache.c"
		{
			const gchar* _tmp27_;
			RygelMediaExportSqlFunction* _tmp28_;
			RygelRelationalExpression* _tmp29_;
			gconstpointer _tmp30_;
			GValue* _tmp31_ = NULL;
#line 805 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp27_ = column;
#line 805 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp28_ = rygel_media_export_sql_function_new ("NOT contains", _tmp27_);
#line 805 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (operator);
#line 805 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			operator = (RygelMediaExportSqlOperator*) _tmp28_;
#line 806 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp29_ = exp;
#line 806 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp30_ = ((RygelSearchExpression*) _tmp29_)->operand2;
#line 806 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp31_ = g_new0 (GValue, 1);
#line 806 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_init (_tmp31_, G_TYPE_STRING);
#line 806 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_set_string (_tmp31_, (const gchar*) _tmp30_);
#line 806 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			__vala_GValue_free0 (v);
#line 806 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			v = _tmp31_;
#line 807 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			break;
#line 6123 "rygel-media-export-media-cache.c"
		}
#line 780 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		case GUPNP_SEARCH_CRITERIA_OP_DERIVED_FROM:
#line 6127 "rygel-media-export-media-cache.c"
		{
			const gchar* _tmp32_;
			RygelMediaExportSqlOperator* _tmp33_;
			RygelRelationalExpression* _tmp34_;
			gconstpointer _tmp35_;
			gchar* _tmp36_ = NULL;
			GValue* _tmp37_ = NULL;
#line 809 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp32_ = column;
#line 809 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp33_ = rygel_media_export_sql_operator_new ("LIKE", _tmp32_, "");
#line 809 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (operator);
#line 809 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			operator = _tmp33_;
#line 810 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp34_ = exp;
#line 810 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp35_ = ((RygelSearchExpression*) _tmp34_)->operand2;
#line 810 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp36_ = g_strdup_printf ("%s%%", (const gchar*) _tmp35_);
#line 810 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp37_ = g_new0 (GValue, 1);
#line 810 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_init (_tmp37_, G_TYPE_STRING);
#line 810 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_value_take_string (_tmp37_, _tmp36_);
#line 810 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			__vala_GValue_free0 (v);
#line 810 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			v = _tmp37_;
#line 811 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			break;
#line 6161 "rygel-media-export-media-cache.c"
		}
		default:
		{
			RygelRelationalExpression* _tmp38_;
			gconstpointer _tmp39_;
#line 813 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp38_ = exp;
#line 813 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_tmp39_ = ((RygelSearchExpression*) _tmp38_)->op;
#line 813 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_warning ("rygel-media-export-media-cache.vala:813: Unsupported op %d", (gint) GPOINTER_TO_INT (_tmp39_));
#line 814 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			result = NULL;
#line 814 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_object_unref0 (operator);
#line 814 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (column);
#line 814 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			_g_free0 (collate);
#line 814 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			__vala_GValue_free0 (v);
#line 814 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return result;
#line 6185 "rygel-media-export-media-cache.c"
		}
	}
#line 817 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp40_ = v;
#line 817 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_tmp40_ != NULL) {
#line 6192 "rygel-media-export-media-cache.c"
		GValueArray* _tmp41_;
		GValue* _tmp42_;
		GValue _tmp43_;
#line 818 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp41_ = args;
#line 818 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp42_ = v;
#line 818 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		_tmp43_ = *_tmp42_;
#line 818 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		g_value_array_append (_tmp41_, &_tmp43_);
#line 6204 "rygel-media-export-media-cache.c"
	}
#line 821 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp44_ = operator;
#line 821 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp45_ = rygel_media_export_sql_operator_to_string (_tmp44_);
#line 821 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp45_;
#line 821 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (operator);
#line 821 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (column);
#line 821 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_free0 (collate);
#line 821 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	__vala_GValue_free0 (v);
#line 821 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 6222 "rygel-media-export-media-cache.c"
}


static RygelMediaExportDatabaseCursor* rygel_media_export_media_cache_exec_cursor (RygelMediaExportMediaCache* self, RygelMediaExportSQLString id, GValue* values, int values_length1, GError** error) {
	RygelMediaExportDatabaseCursor* result = NULL;
	RygelMediaExportDatabase* _tmp0_;
	RygelMediaExportSQLFactory* _tmp1_;
	RygelMediaExportSQLString _tmp2_;
	const gchar* _tmp3_ = NULL;
	GValue* _tmp4_;
	gint _tmp4__length1;
	RygelMediaExportDatabaseCursor* _tmp5_ = NULL;
	RygelMediaExportDatabaseCursor* _tmp6_;
	GError * _inner_error_ = NULL;
#line 824 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 827 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = self->priv->db;
#line 827 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = self->priv->sql;
#line 827 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = id;
#line 827 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = rygel_media_export_sql_factory_make (_tmp1_, _tmp2_);
#line 827 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = values;
#line 827 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4__length1 = values_length1;
#line 827 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = rygel_media_export_database_exec_cursor (_tmp0_, _tmp3_, _tmp4_, _tmp4__length1, &_inner_error_);
#line 827 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = _tmp5_;
#line 827 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 827 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 827 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 827 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 6263 "rygel-media-export-media-cache.c"
		} else {
#line 827 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 827 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 827 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return NULL;
#line 6271 "rygel-media-export-media-cache.c"
		}
	}
#line 827 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp6_;
#line 827 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 6278 "rygel-media-export-media-cache.c"
}


static gint rygel_media_export_media_cache_query_value (RygelMediaExportMediaCache* self, RygelMediaExportSQLString id, GValue* values, int values_length1, GError** error) {
	gint result = 0;
	RygelMediaExportDatabase* _tmp0_;
	RygelMediaExportSQLFactory* _tmp1_;
	RygelMediaExportSQLString _tmp2_;
	const gchar* _tmp3_ = NULL;
	GValue* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_ = 0;
	gint _tmp6_;
	GError * _inner_error_ = NULL;
#line 830 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 833 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp0_ = self->priv->db;
#line 833 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp1_ = self->priv->sql;
#line 833 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp2_ = id;
#line 833 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp3_ = rygel_media_export_sql_factory_make (_tmp1_, _tmp2_);
#line 833 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4_ = values;
#line 833 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp4__length1 = values_length1;
#line 833 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp5_ = rygel_media_export_database_query_value (_tmp0_, _tmp3_, _tmp4_, _tmp4__length1, &_inner_error_);
#line 833 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_tmp6_ = _tmp5_;
#line 833 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	if (_inner_error_ != NULL) {
#line 833 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 833 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 833 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return 0;
#line 6319 "rygel-media-export-media-cache.c"
		} else {
#line 833 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 833 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			g_clear_error (&_inner_error_);
#line 833 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
			return 0;
#line 6327 "rygel-media-export-media-cache.c"
		}
	}
#line 833 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	result = _tmp6_;
#line 833 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	return result;
#line 6334 "rygel-media-export-media-cache.c"
}


static void rygel_media_export_media_cache_class_init (RygelMediaExportMediaCacheClass * klass) {
#line 50 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	rygel_media_export_media_cache_parent_class = g_type_class_peek_parent (klass);
#line 50 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	g_type_class_add_private (klass, sizeof (RygelMediaExportMediaCachePrivate));
#line 50 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_media_cache_finalize;
#line 6345 "rygel-media-export-media-cache.c"
}


static void rygel_media_export_media_cache_instance_init (RygelMediaExportMediaCache * self) {
#line 50 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	self->priv = RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_PRIVATE (self);
#line 6352 "rygel-media-export-media-cache.c"
}


static void rygel_media_export_media_cache_finalize (GObject* obj) {
	RygelMediaExportMediaCache * self;
#line 50 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	self = RYGEL_MEDIA_EXPORT_MEDIA_CACHE (obj);
#line 52 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (self->priv->db);
#line 53 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (self->priv->factory);
#line 54 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (self->priv->sql);
#line 55 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	_g_object_unref0 (self->priv->exists_cache);
#line 50 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-media-cache.vala"
	G_OBJECT_CLASS (rygel_media_export_media_cache_parent_class)->finalize (obj);
#line 6370 "rygel-media-export-media-cache.c"
}


/**
 * Persistent storage of media objects
 *
 *  MediaExportDB is a sqlite3 backed persistent storage of media objects
 */
GType rygel_media_export_media_cache_get_type (void) {
	static volatile gsize rygel_media_export_media_cache_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_media_cache_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportMediaCacheClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_media_cache_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportMediaCache), 0, (GInstanceInitFunc) rygel_media_export_media_cache_instance_init, NULL };
		GType rygel_media_export_media_cache_type_id;
		rygel_media_export_media_cache_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportMediaCache", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_media_cache_type_id__volatile, rygel_media_export_media_cache_type_id);
	}
	return rygel_media_export_media_cache_type_id__volatile;
}



