/* rygel-plugin-loader.c generated by valac 0.12.0, the Vala compiler
 * generated from rygel-plugin-loader.vala, do not modify */

/*
 * Copyright (C) 2008 Nokia Corporation.
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <gmodule.h>
#include <config.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_PLUGIN_LOADER (rygel_plugin_loader_get_type ())
#define RYGEL_PLUGIN_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN_LOADER, RygelPluginLoader))
#define RYGEL_PLUGIN_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN_LOADER, RygelPluginLoaderClass))
#define RYGEL_IS_PLUGIN_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN_LOADER))
#define RYGEL_IS_PLUGIN_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN_LOADER))
#define RYGEL_PLUGIN_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN_LOADER, RygelPluginLoaderClass))

typedef struct _RygelPluginLoader RygelPluginLoader;
typedef struct _RygelPluginLoaderClass RygelPluginLoaderClass;
typedef struct _RygelPluginLoaderPrivate RygelPluginLoaderPrivate;

#define RYGEL_TYPE_PLUGIN (rygel_plugin_get_type ())
#define RYGEL_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN, RygelPlugin))
#define RYGEL_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN, RygelPluginClass))
#define RYGEL_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN))
#define RYGEL_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN))
#define RYGEL_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN, RygelPluginClass))

typedef struct _RygelPlugin RygelPlugin;
typedef struct _RygelPluginClass RygelPluginClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_META_CONFIG (rygel_meta_config_get_type ())
#define RYGEL_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfig))
#define RYGEL_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))
#define RYGEL_IS_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_META_CONFIG))
#define RYGEL_IS_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_META_CONFIG))
#define RYGEL_META_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))

typedef struct _RygelMetaConfig RygelMetaConfig;
typedef struct _RygelMetaConfigClass RygelMetaConfigClass;

#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelPluginPrivate RygelPluginPrivate;

#define RYGEL_TYPE_RESOURCE_INFO (rygel_resource_info_get_type ())
#define RYGEL_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfo))
#define RYGEL_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))
#define RYGEL_IS_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_IS_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_RESOURCE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))

typedef struct _RygelResourceInfo RygelResourceInfo;
typedef struct _RygelResourceInfoClass RygelResourceInfoClass;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _RygelPluginLoaderLoadModulesFromDirData RygelPluginLoaderLoadModulesFromDirData;
#define _g_module_close0(var) ((var == NULL) ? NULL : (var = (g_module_close (var), NULL)))

struct _RygelPluginLoader {
	GObject parent_instance;
	RygelPluginLoaderPrivate * priv;
};

struct _RygelPluginLoaderClass {
	GObjectClass parent_class;
};

struct _RygelPluginLoaderPrivate {
	GeeHashMap* plugin_hash;
};

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gboolean (*get_upnp_enabled) (RygelConfiguration* self, GError** error);
	gchar* (*get_interface) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp3_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp2ts_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_lpcm_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_wmv_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_upload) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_deletion) (RygelConfiguration* self, GError** error);
	gchar* (*get_log_levels) (RygelConfiguration* self, GError** error);
	gchar* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_video_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_music_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_picture_upload_folder) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_title) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_string) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
};

struct _RygelPlugin {
	GUPnPResourceFactory parent_instance;
	RygelPluginPrivate * priv;
	gchar* name;
	gchar* title;
	gchar* description;
	gchar* desc_path;
	GeeArrayList* resource_infos;
	GeeArrayList* icon_infos;
	GeeArrayList* default_icons;
};

struct _RygelPluginClass {
	GUPnPResourceFactoryClass parent_class;
};

struct _RygelPluginLoaderLoadModulesFromDirData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelPluginLoader* self;
	GFile* dir;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* attributes;
	GList* infos;
	GFileEnumerator* enumerator;
	GFileEnumerator* _tmp3_;
	GFileEnumerator* _tmp4_;
	GList* _tmp5_;
	GList* _tmp6_;
	GError * _error_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GList* info_collection;
	GList* info_it;
	GFileInfo* _tmp10_;
	GFileInfo* info;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* file_name;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* file_path;
	GFile* _tmp17_;
	GFile* file;
	GFileType _tmp18_;
	GFileType file_type;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* content_type;
	gchar* _tmp21_;
	gchar* mime;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GError * _inner_error_;
};

typedef void (*RygelPluginLoaderModuleInitFunc) (RygelPluginLoader* loader, void* user_data);

static gpointer rygel_plugin_loader_parent_class = NULL;

GType rygel_plugin_loader_get_type (void) G_GNUC_CONST;
GType rygel_plugin_get_type (void) G_GNUC_CONST;
#define RYGEL_PLUGIN_LOADER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_PLUGIN_LOADER, RygelPluginLoaderPrivate))
enum  {
	RYGEL_PLUGIN_LOADER_DUMMY_PROPERTY
};
RygelPluginLoader* rygel_plugin_loader_new (void);
RygelPluginLoader* rygel_plugin_loader_construct (GType object_type);
void rygel_plugin_loader_load_plugins (RygelPluginLoader* self);
GType rygel_meta_config_get_type (void) G_GNUC_CONST;
RygelMetaConfig* rygel_meta_config_get_default (void);
GType rygel_configuration_get_type (void) G_GNUC_CONST;
gchar* rygel_configuration_get_plugin_path (RygelConfiguration* self, GError** error);
static gboolean rygel_plugin_loader_is_dir (GFile* file);
static void rygel_plugin_loader_load_modules_from_dir (RygelPluginLoader* self, GFile* dir, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_plugin_loader_load_modules_from_dir_finish (RygelPluginLoader* self, GAsyncResult* _res_);
gboolean rygel_plugin_loader_plugin_disabled (RygelPluginLoader* self, const gchar* name);
gboolean rygel_configuration_get_enabled (RygelConfiguration* self, const gchar* section, GError** error);
void rygel_plugin_loader_add_plugin (RygelPluginLoader* self, RygelPlugin* plugin);
gpointer rygel_resource_info_ref (gpointer instance);
void rygel_resource_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_resource_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_resource_info (GValue* value, gpointer v_object);
void rygel_value_take_resource_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_resource_info (const GValue* value);
GType rygel_resource_info_get_type (void) G_GNUC_CONST;
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
RygelPlugin* rygel_plugin_loader_get_plugin_by_name (RygelPluginLoader* self, const gchar* name);
GeeCollection* rygel_plugin_loader_list_plugins (RygelPluginLoader* self);
static void rygel_plugin_loader_load_modules_from_dir_data_free (gpointer _data);
static gboolean rygel_plugin_loader_load_modules_from_dir_co (RygelPluginLoaderLoadModulesFromDirData* data);
static void rygel_plugin_loader_load_modules_from_dir_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void rygel_plugin_loader_load_module_from_file (RygelPluginLoader* self, const gchar* file_path);
static void rygel_plugin_loader_finalize (GObject* obj);


RygelPluginLoader* rygel_plugin_loader_construct (GType object_type) {
	RygelPluginLoader * self = NULL;
	GeeHashMap* _tmp0_ = NULL;
	self = (RygelPluginLoader*) g_object_new (object_type, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, RYGEL_TYPE_PLUGIN, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_str_hash, g_str_equal, NULL);
	_g_object_unref0 (self->priv->plugin_hash);
	self->priv->plugin_hash = _tmp0_;
	return self;
}


RygelPluginLoader* rygel_plugin_loader_new (void) {
	return rygel_plugin_loader_construct (RYGEL_TYPE_PLUGIN_LOADER);
}


void rygel_plugin_loader_load_plugins (RygelPluginLoader* self) {
	gboolean _tmp0_;
	gchar* path = NULL;
	RygelMetaConfig* _tmp1_ = NULL;
	RygelMetaConfig* config;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	GFile* _tmp5_ = NULL;
	GFile* dir;
	gboolean _tmp6_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_module_supported ();
	g_assert (_tmp0_);
	_tmp1_ = rygel_meta_config_get_default ();
	config = _tmp1_;
	_tmp2_ = rygel_configuration_get_plugin_path ((RygelConfiguration*) config, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (config);
		goto __catch42_g_error;
	}
	_g_free0 (path);
	path = _tmp3_;
	_g_object_unref0 (config);
	goto __finally42;
	__catch42_g_error:
	{
		GError * _error_;
		gchar* _tmp4_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = g_strdup (PLUGIN_DIR);
		_g_free0 (path);
		path = _tmp4_;
		_g_error_free0 (_error_);
	}
	__finally42:
	if (_inner_error_ != NULL) {
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp5_ = g_file_new_for_path (path);
	dir = _tmp5_;
	if (dir != NULL) {
		gboolean _tmp7_;
		_tmp7_ = rygel_plugin_loader_is_dir (dir);
		_tmp6_ = _tmp7_;
	} else {
		_tmp6_ = FALSE;
	}
	g_assert (_tmp6_);
	rygel_plugin_loader_load_modules_from_dir (self, dir, NULL, NULL);
	_g_object_unref0 (dir);
	_g_free0 (path);
}


/**
     * Checks if a plugin is disabled by user
     *
     * @param name the name of plugin to check for.
     *
     * return true if plugin is disabled, false if not.
     */
gboolean rygel_plugin_loader_plugin_disabled (RygelPluginLoader* self, const gchar* name) {
	gboolean result = FALSE;
	gboolean enabled;
	RygelMetaConfig* _tmp0_ = NULL;
	RygelMetaConfig* config;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	enabled = TRUE;
	_tmp0_ = rygel_meta_config_get_default ();
	config = _tmp0_;
	_tmp1_ = rygel_configuration_get_enabled ((RygelConfiguration*) config, name, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (config);
		goto __catch43_g_error;
	}
	enabled = _tmp2_;
	_g_object_unref0 (config);
	goto __finally43;
	__catch43_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (err);
	}
	__finally43:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = !enabled;
	return result;
}


void rygel_plugin_loader_add_plugin (RygelPluginLoader* self, RygelPlugin* plugin) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (plugin != NULL);
	_tmp0_ = _ ("New plugin '%s' available");
	g_message (_tmp0_, plugin->name);
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->plugin_hash, plugin->name, plugin);
	g_signal_emit_by_name (self, "plugin-available", plugin);
}


RygelPlugin* rygel_plugin_loader_get_plugin_by_name (RygelPluginLoader* self, const gchar* name) {
	RygelPlugin* result = NULL;
	gpointer _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->plugin_hash, name);
	result = (RygelPlugin*) _tmp0_;
	return result;
}


GeeCollection* rygel_plugin_loader_list_plugins (RygelPluginLoader* self) {
	GeeCollection* result = NULL;
	GeeCollection* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_map_get_values ((GeeMap*) self->priv->plugin_hash);
	result = _tmp0_;
	return result;
}


static void rygel_plugin_loader_load_modules_from_dir_data_free (gpointer _data) {
	RygelPluginLoaderLoadModulesFromDirData* data;
	data = _data;
	_g_object_unref0 (data->dir);
	_g_object_unref0 (data->self);
	g_slice_free (RygelPluginLoaderLoadModulesFromDirData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_plugin_loader_load_modules_from_dir (RygelPluginLoader* self, GFile* dir, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelPluginLoaderLoadModulesFromDirData* _data_;
	_data_ = g_slice_new0 (RygelPluginLoaderLoadModulesFromDirData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_plugin_loader_load_modules_from_dir);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_plugin_loader_load_modules_from_dir_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->dir = _g_object_ref0 (dir);
	rygel_plugin_loader_load_modules_from_dir_co (_data_);
}


static void rygel_plugin_loader_load_modules_from_dir_finish (RygelPluginLoader* self, GAsyncResult* _res_) {
	RygelPluginLoaderLoadModulesFromDirData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_plugin_loader_load_modules_from_dir_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelPluginLoaderLoadModulesFromDirData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_plugin_loader_load_modules_from_dir_co (data);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gboolean rygel_plugin_loader_load_modules_from_dir_co (RygelPluginLoaderLoadModulesFromDirData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_file_get_path (data->dir);
	data->_tmp1_ = data->_tmp0_;
	g_debug ("rygel-plugin-loader.vala:97: Searching for modules in folder '%s'.", data->_tmp1_);
	_g_free0 (data->_tmp1_);
	data->_tmp2_ = g_strdup (G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE);
	data->attributes = data->_tmp2_;
	data->_state_ = 1;
	g_file_enumerate_children_async (data->dir, data->attributes, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, NULL, rygel_plugin_loader_load_modules_from_dir_ready, data);
	return FALSE;
	_state_1:
	data->_tmp3_ = NULL;
	data->_tmp3_ = g_file_enumerate_children_finish (data->dir, data->_res_, &data->_inner_error_);
	data->_tmp4_ = data->_tmp3_;
	if (data->_inner_error_ != NULL) {
		goto __catch44_g_error;
	}
	_g_object_unref0 (data->enumerator);
	data->enumerator = data->_tmp4_;
	data->_state_ = 2;
	g_file_enumerator_next_files_async (data->enumerator, G_MAXINT, G_PRIORITY_DEFAULT, NULL, rygel_plugin_loader_load_modules_from_dir_ready, data);
	return FALSE;
	_state_2:
	data->_tmp5_ = NULL;
	data->_tmp5_ = g_file_enumerator_next_files_finish (data->enumerator, data->_res_, &data->_inner_error_);
	data->_tmp6_ = data->_tmp5_;
	if (data->_inner_error_ != NULL) {
		goto __catch44_g_error;
	}
	__g_list_free__g_object_unref0_0 (data->infos);
	data->infos = data->_tmp6_;
	goto __finally44;
	__catch44_g_error:
	{
		data->_error_ = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp7_ = NULL;
		data->_tmp7_ = _ ("Error listing contents of folder '%s': %s");
		data->_tmp8_ = NULL;
		data->_tmp8_ = g_file_get_path (data->dir);
		data->_tmp9_ = data->_tmp8_;
		g_critical (data->_tmp7_, data->_tmp9_, data->_error_->message);
		_g_free0 (data->_tmp9_);
		_g_error_free0 (data->_error_);
		_g_object_unref0 (data->enumerator);
		__g_list_free__g_object_unref0_0 (data->infos);
		_g_free0 (data->attributes);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	__finally44:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->enumerator);
		__g_list_free__g_object_unref0_0 (data->infos);
		_g_free0 (data->attributes);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	{
		data->info_collection = data->infos;
		for (data->info_it = data->info_collection; data->info_it != NULL; data->info_it = data->info_it->next) {
			data->_tmp10_ = _g_object_ref0 ((GFileInfo*) data->info_it->data);
			data->info = data->_tmp10_;
			{
				data->_tmp11_ = NULL;
				data->_tmp11_ = g_file_info_get_name (data->info);
				data->_tmp12_ = g_strdup (data->_tmp11_);
				data->file_name = data->_tmp12_;
				data->_tmp13_ = NULL;
				data->_tmp13_ = g_file_get_path (data->dir);
				data->_tmp14_ = data->_tmp13_;
				data->_tmp15_ = NULL;
				data->_tmp15_ = g_build_filename (data->_tmp14_, data->file_name, NULL);
				data->_tmp16_ = data->_tmp15_;
				_g_free0 (data->_tmp14_);
				data->file_path = data->_tmp16_;
				data->_tmp17_ = NULL;
				data->_tmp17_ = g_file_new_for_path (data->file_path);
				data->file = data->_tmp17_;
				data->_tmp18_ = g_file_info_get_file_type (data->info);
				data->file_type = data->_tmp18_;
				data->_tmp19_ = NULL;
				data->_tmp19_ = g_file_info_get_content_type (data->info);
				data->_tmp20_ = g_strdup (data->_tmp19_);
				data->content_type = data->_tmp20_;
				data->_tmp21_ = NULL;
				data->_tmp21_ = g_content_type_get_mime_type (data->content_type);
				data->mime = data->_tmp21_;
				if (data->file_type == G_FILE_TYPE_DIRECTORY) {
					rygel_plugin_loader_load_modules_from_dir (data->self, data->file, NULL, NULL);
				} else {
					if (g_strcmp0 (data->mime, "application/x-sharedlib") == 0) {
						rygel_plugin_loader_load_module_from_file (data->self, data->file_path);
					}
				}
				_g_free0 (data->mime);
				_g_free0 (data->content_type);
				_g_object_unref0 (data->file);
				_g_free0 (data->file_path);
				_g_free0 (data->file_name);
				_g_object_unref0 (data->info);
			}
		}
	}
	data->_tmp22_ = NULL;
	data->_tmp22_ = g_file_get_path (data->dir);
	data->_tmp23_ = data->_tmp22_;
	g_debug ("rygel-plugin-loader.vala:142: Finished searching for modules in folder" \
" '%s'", data->_tmp23_);
	_g_free0 (data->_tmp23_);
	_g_object_unref0 (data->enumerator);
	__g_list_free__g_object_unref0_0 (data->infos);
	_g_free0 (data->attributes);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_plugin_loader_load_module_from_file (RygelPluginLoader* self, const gchar* file_path) {
	GModule* _tmp0_ = NULL;
	GModule* module;
	void* function = NULL;
	void* _tmp3_ = NULL;
	gboolean _tmp4_;
	RygelPluginLoaderModuleInitFunc _tmp7_;
	RygelPluginLoaderModuleInitFunc module_init;
	void* module_init_target = NULL;
	GDestroyNotify module_init_target_destroy_notify = NULL;
	const gchar* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file_path != NULL);
	_tmp0_ = g_module_open (file_path, G_MODULE_BIND_LOCAL);
	module = _tmp0_;
	if (module == NULL) {
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		_tmp1_ = _ ("Failed to load module from path '%s': %s");
		_tmp2_ = g_module_error ();
		g_warning (_tmp1_, file_path, _tmp2_);
		_g_module_close0 (module);
		return;
	}
	_tmp4_ = g_module_symbol (module, "module_init", &_tmp3_);
	function = _tmp3_;
	if (!_tmp4_) {
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		_tmp5_ = _ ("Failed to find entry point function '%s' in '%s': %s");
		_tmp6_ = g_module_error ();
		g_warning (_tmp5_, "module_init", file_path, _tmp6_);
		_g_module_close0 (module);
		return;
	}
	_tmp7_ = (RygelPluginLoaderModuleInitFunc) function;
	module_init = _tmp7_;
	module_init_target = NULL;
	module_init_target_destroy_notify = NULL;
	g_assert (module_init != NULL);
	g_module_make_resident (module);
	module_init (self, module_init_target);
	_tmp8_ = g_module_name (module);
	g_debug ("rygel-plugin-loader.vala:175: Loaded module source: '%s'", _tmp8_);
	(module_init_target_destroy_notify == NULL) ? NULL : (module_init_target_destroy_notify (module_init_target), NULL);
	module_init = NULL;
	module_init_target = NULL;
	module_init_target_destroy_notify = NULL;
	_g_module_close0 (module);
}


static gboolean rygel_plugin_loader_is_dir (GFile* file) {
	gboolean result = FALSE;
	GFileInfo* file_info = NULL;
	GFileInfo* _tmp0_ = NULL;
	GFileInfo* _tmp1_;
	GFileType _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (file != NULL, FALSE);
	_tmp0_ = g_file_query_info (file, G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch45_g_error;
	}
	_g_object_unref0 (file_info);
	file_info = _tmp1_;
	goto __finally45;
	__catch45_g_error:
	{
		GError * _error_;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _ ("Failed to query content type for '%s'");
		_tmp3_ = g_file_get_path (file);
		_tmp4_ = _tmp3_;
		g_critical (_tmp2_, _tmp4_);
		_g_free0 (_tmp4_);
		result = FALSE;
		_g_error_free0 (_error_);
		_g_object_unref0 (file_info);
		return result;
	}
	__finally45:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (file_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp5_ = g_file_info_get_file_type (file_info);
	result = _tmp5_ == G_FILE_TYPE_DIRECTORY;
	_g_object_unref0 (file_info);
	return result;
}


static void rygel_plugin_loader_class_init (RygelPluginLoaderClass * klass) {
	rygel_plugin_loader_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelPluginLoaderPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_plugin_loader_finalize;
	g_signal_new ("plugin_available", RYGEL_TYPE_PLUGIN_LOADER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, RYGEL_TYPE_PLUGIN);
}


static void rygel_plugin_loader_instance_init (RygelPluginLoader * self) {
	self->priv = RYGEL_PLUGIN_LOADER_GET_PRIVATE (self);
}


static void rygel_plugin_loader_finalize (GObject* obj) {
	RygelPluginLoader * self;
	self = RYGEL_PLUGIN_LOADER (obj);
	_g_object_unref0 (self->priv->plugin_hash);
	G_OBJECT_CLASS (rygel_plugin_loader_parent_class)->finalize (obj);
}


/**
 * Responsible for plugin loading. Probes for shared library files in a specific
 * directry and tries to grab a function with a specific name and signature,
 * calls it. The loaded module can then add plugins to Rygel by calling the
 * add_plugin method. NOTE: The module SHOULD make sure that plugin is not
 * disabled by user using plugin_disabled method before creating the plugin
 * instance and resources related to that instance.
 */
GType rygel_plugin_loader_get_type (void) {
	static volatile gsize rygel_plugin_loader_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_plugin_loader_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelPluginLoaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_plugin_loader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelPluginLoader), 0, (GInstanceInitFunc) rygel_plugin_loader_instance_init, NULL };
		GType rygel_plugin_loader_type_id;
		rygel_plugin_loader_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelPluginLoader", &g_define_type_info, 0);
		g_once_init_leave (&rygel_plugin_loader_type_id__volatile, rygel_plugin_loader_type_id);
	}
	return rygel_plugin_loader_type_id__volatile;
}



