/* rygel-item-creator.c generated by valac 0.12.0, the Vala compiler
 * generated from rygel-item-creator.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <libgupnp/gupnp.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <gst/gst.h>
#include <libgupnp-dlna/gupnp-dlna-discoverer.h>
#include <libgupnp-dlna/gupnp-dlna-profile.h>


#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_ITEM_CREATOR (rygel_item_creator_get_type ())
#define RYGEL_ITEM_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ITEM_CREATOR, RygelItemCreator))
#define RYGEL_ITEM_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ITEM_CREATOR, RygelItemCreatorClass))
#define RYGEL_IS_ITEM_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ITEM_CREATOR))
#define RYGEL_IS_ITEM_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ITEM_CREATOR))
#define RYGEL_ITEM_CREATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ITEM_CREATOR, RygelItemCreatorClass))

typedef struct _RygelItemCreator RygelItemCreator;
typedef struct _RygelItemCreatorClass RygelItemCreatorClass;
typedef struct _RygelItemCreatorPrivate RygelItemCreatorPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelContentDirectoryPrivate RygelContentDirectoryPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_WRITABLE_CONTAINER (rygel_writable_container_get_type ())
#define RYGEL_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainer))
#define RYGEL_IS_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER))
#define RYGEL_WRITABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainerIface))

typedef struct _RygelWritableContainer RygelWritableContainer;
typedef struct _RygelWritableContainerIface RygelWritableContainerIface;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_ITEM_REMOVAL_QUEUE (rygel_item_removal_queue_get_type ())
#define RYGEL_ITEM_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueue))
#define RYGEL_ITEM_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueueClass))
#define RYGEL_IS_ITEM_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE))
#define RYGEL_IS_ITEM_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ITEM_REMOVAL_QUEUE))
#define RYGEL_ITEM_REMOVAL_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueueClass))

typedef struct _RygelItemRemovalQueue RygelItemRemovalQueue;
typedef struct _RygelItemRemovalQueueClass RygelItemRemovalQueueClass;
typedef struct _RygelItemCreatorRunData RygelItemCreatorRunData;
typedef struct _RygelItemCreatorParseArgsData RygelItemCreatorParseArgsData;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;

#define RYGEL_TYPE_RELATIONAL_EXPRESSION (rygel_relational_expression_get_type ())
#define RYGEL_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpression))
#define RYGEL_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))
#define RYGEL_IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))

typedef struct _RygelRelationalExpression RygelRelationalExpression;
typedef struct _RygelRelationalExpressionClass RygelRelationalExpressionClass;
typedef struct _RygelSearchExpressionPrivate RygelSearchExpressionPrivate;

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerIface))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerIface RygelSearchableContainerIface;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
typedef struct _RygelItemCreatorFetchContainerData RygelItemCreatorFetchContainerData;

#define RYGEL_TYPE_IMAGE_ITEM (rygel_image_item_get_type ())
#define RYGEL_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_IMAGE_ITEM, RygelImageItem))
#define RYGEL_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_IMAGE_ITEM, RygelImageItemClass))
#define RYGEL_IS_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_IMAGE_ITEM))
#define RYGEL_IS_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_IMAGE_ITEM))
#define RYGEL_IMAGE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_IMAGE_ITEM, RygelImageItemClass))

typedef struct _RygelImageItem RygelImageItem;
typedef struct _RygelImageItemClass RygelImageItemClass;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;

#define RYGEL_TYPE_PHOTO_ITEM (rygel_photo_item_get_type ())
#define RYGEL_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItem))
#define RYGEL_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItemClass))
#define RYGEL_IS_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PHOTO_ITEM))
#define RYGEL_IS_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PHOTO_ITEM))
#define RYGEL_PHOTO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItemClass))

typedef struct _RygelPhotoItem RygelPhotoItem;
typedef struct _RygelPhotoItemClass RygelPhotoItemClass;

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _RygelItemCreatorCreateUriData RygelItemCreatorCreateUriData;
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
typedef struct _RygelItemCreatorWaitForItemData RygelItemCreatorWaitForItemData;

typedef enum  {
	RYGEL_ITEM_CREATOR_ERROR_PARSE
} RygelItemCreatorError;
#define RYGEL_ITEM_CREATOR_ERROR rygel_item_creator_error_quark ()
struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelItemCreator {
	GObject parent_instance;
	RygelItemCreatorPrivate * priv;
	gchar* container_id;
	gchar* elements;
	GUPnPDIDLLiteItem* didl_item;
	RygelMediaItem* item;
};

struct _RygelItemCreatorClass {
	GObjectClass parent_class;
};

struct _RygelItemCreatorPrivate {
	RygelContentDirectory* content_dir;
	GUPnPServiceAction* action;
	GUPnPDIDLLiteWriter* didl_writer;
	GUPnPDIDLLiteParser* didl_parser;
	GCancellable* _cancellable;
};

struct _RygelContentDirectory {
	GUPnPService parent_instance;
	RygelContentDirectoryPrivate * priv;
	gchar* feature_list;
	RygelHTTPServer* http_server;
	RygelMediaContainer* root_container;
	GCancellable* cancellable;
	guint32 system_update_id;
};

struct _RygelContentDirectoryClass {
	GUPnPServiceClass parent_class;
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SORT_CRITERIA = 709,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT = 711,
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA = 712,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT = 713,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_DESTINATION_RESOURCE = 718,
	RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS = 720,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
struct _RygelWritableContainerIface {
	GTypeInterface parent_iface;
	void (*add_item) (RygelWritableContainer* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*remove_item) (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	GeeArrayList* (*get_create_classes) (RygelWritableContainer* self);
	void (*set_create_classes) (RygelWritableContainer* self, GeeArrayList* value);
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	gchar* date;
	gchar* mime_type;
	gchar* dlna_profile;
	GRegex* address_regex;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_uri) (RygelMediaItem* self, const gchar* uri);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelItemCreatorRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemCreator* self;
	GError * parse_err;
	GError* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* message;
	GError* _tmp3_;
	gboolean _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GError* _tmp7_;
	const gchar* _tmp8_;
	GError* _tmp9_;
	GUPnPOCMFlags _tmp10_;
	GError* _tmp11_;
	gboolean _tmp12_;
	GError* _tmp13_;
	RygelWritableContainer* _tmp14_;
	RygelWritableContainer* container;
	GeeArrayList* _tmp15_;
	const gchar* _tmp16_;
	gboolean _tmp17_;
	const gchar* _tmp18_;
	GError* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	RygelMediaItem* _tmp23_;
	RygelMediaItem* _tmp24_;
	GList* _tmp25_;
	GList* resources;
	gboolean _tmp26_;
	guint _tmp27_;
	GList* _tmp28_;
	GUPnPDIDLLiteResource* _tmp29_;
	GUPnPDIDLLiteResource* resource;
	GUPnPProtocolInfo* _tmp30_;
	GUPnPProtocolInfo* _tmp31_;
	GUPnPProtocolInfo* info;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	gboolean _tmp34_;
	const gchar* _tmp35_;
	GError* _tmp36_;
	const gchar* _tmp37_;
	gchar* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	const gchar* _tmp42_;
	gboolean _tmp43_;
	const gchar* _tmp44_;
	glong _tmp45_;
	glong _tmp46_;
	gchar* _tmp47_;
	gint64 _tmp48_;
	gint _tmp49_;
	const gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* uri;
	gpointer _tmp52_;
	gchar* _tmp53_;
	GFile* _tmp54_;
	GFile* _tmp55_;
	GFile* file;
	gboolean _tmp56_;
	gpointer _tmp57_;
	GCancellable* _tmp58_;
	GUPnPDIDLLiteObject* _tmp59_;
	GUPnPDIDLLiteObject* _tmp60_;
	gboolean _tmp61_;
	gboolean _tmp62_;
	RygelItemRemovalQueue* _tmp63_;
	RygelItemRemovalQueue* queue;
	GCancellable* _tmp64_;
	GError * err;
	GError * _inner_error_;
};

struct _RygelItemCreatorParseArgsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemCreator* self;
	const gchar* _tmp0_;
	GError* _tmp1_;
	gboolean _tmp2_;
	const gchar* _tmp3_;
	GError* _tmp4_;
	const gchar* _tmp5_;
	GError* _tmp6_;
	GError * _inner_error_;
};

struct _RygelSearchExpression {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSearchExpressionPrivate * priv;
	gpointer op;
	gpointer operand1;
	gpointer operand2;
};

struct _RygelSearchExpressionClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSearchExpression *self);
	gboolean (*satisfied_by) (RygelSearchExpression* self, RygelMediaObject* media_object);
	gchar* (*to_string) (RygelSearchExpression* self);
};

struct _RygelSearchableContainerIface {
	GTypeInterface parent_iface;
	void (*search) (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	GeeArrayList* (*get_search_classes) (RygelSearchableContainer* self);
	void (*set_search_classes) (RygelSearchableContainer* self, GeeArrayList* value);
};

struct _RygelItemCreatorFetchContainerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemCreator* self;
	RygelWritableContainer* result;
	RygelMediaObject* media_object;
	RygelRelationalExpression* _tmp0_;
	RygelRelationalExpression* expression;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	guint total_matches;
	RygelMediaContainer* _tmp4_;
	RygelSearchableContainer* _tmp5_;
	RygelSearchableContainer* container;
	GCancellable* _tmp6_;
	guint _tmp7_;
	RygelMediaObjects* _tmp8_;
	RygelMediaObjects* _result_;
	gint _tmp9_;
	gpointer _tmp10_;
	const gchar* _tmp11_;
	GError* _tmp12_;
	GCancellable* _tmp13_;
	RygelMediaObject* _tmp14_;
	RygelMediaObject* _tmp15_;
	const gchar* _tmp16_;
	GError* _tmp17_;
	gboolean _tmp18_;
	GUPnPOCMFlags _tmp19_;
	const gchar* _tmp20_;
	GError* _tmp21_;
	RygelMediaObject* _tmp22_;
	RygelWritableContainer* _tmp23_;
	GError * _inner_error_;
};

struct _RygelItemCreatorCreateUriData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemCreator* self;
	RygelWritableContainer* container;
	gchar* title;
	gchar* result;
	GCancellable* _tmp0_;
	GFile* _tmp1_;
	GFile* dir;
	const gchar* _tmp2_;
	GError* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* now;
	GFile* _tmp5_;
	GFile* file;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GError * _inner_error_;
};

struct _Block5Data {
	int _ref_count_;
	RygelItemCreator * self;
	RygelWritableContainer* container;
	gpointer _async_data_;
};

struct _Block6Data {
	int _ref_count_;
	Block5Data * _data5_;
	guint timeout;
};

struct _RygelItemCreatorWaitForItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemCreator* self;
	RygelWritableContainer* container;
	Block5Data* _data5_;
	RygelMediaItem* item;
	Block6Data* _data6_;
	gulong _tmp0_;
	gulong id;
	guint _tmp1_;
	GCancellable* _tmp2_;
	RygelMediaObject* _tmp3_;
	RygelMediaObject* _tmp4_;
	RygelMediaObject* _tmp5_;
	GError * _error_;
	GError * _inner_error_;
};


static gpointer rygel_item_creator_parent_class = NULL;
static GPatternSpec* rygel_item_creator_comment_pattern;
static GPatternSpec* rygel_item_creator_comment_pattern = NULL;
static RygelStateMachineIface* rygel_item_creator_rygel_state_machine_parent_iface = NULL;

GQuark rygel_item_creator_error_quark (void);
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_item_creator_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
#define RYGEL_ITEM_CREATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_ITEM_CREATOR, RygelItemCreatorPrivate))
enum  {
	RYGEL_ITEM_CREATOR_DUMMY_PROPERTY,
	RYGEL_ITEM_CREATOR_CANCELLABLE
};
RygelItemCreator* rygel_item_creator_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelItemCreator* rygel_item_creator_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
void rygel_state_machine_set_cancellable (RygelStateMachine* self, GCancellable* value);
static void rygel_item_creator_real_run_data_free (gpointer _data);
static void rygel_item_creator_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_item_creator_real_run_co (RygelItemCreatorRunData* data);
static void rygel_item_creator_parse_args (RygelItemCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_item_creator_parse_args_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error);
static void _lambda9_ (GUPnPDIDLLiteItem* didl_item, RygelItemCreator* self);
static void __lambda9__gupnp_didl_lite_parser_item_available (GUPnPDIDLLiteParser* _sender, GUPnPDIDLLiteItem* item, gpointer self);
GQuark rygel_content_directory_error_quark (void);
static void rygel_item_creator_fetch_container (RygelItemCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
GType rygel_writable_container_get_type (void) G_GNUC_CONST;
static RygelWritableContainer* rygel_item_creator_fetch_container_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error);
static void rygel_item_creator_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GeeArrayList* rygel_writable_container_get_create_classes (RygelWritableContainer* self);
static RygelMediaItem* rygel_item_creator_create_item (RygelItemCreator* self, const gchar* id, RygelWritableContainer* parent, const gchar* title, const gchar* upnp_class, GError** error);
static gboolean rygel_item_creator_is_profile_valid (RygelItemCreator* self, const gchar* profile);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static gboolean rygel_item_creator_is_valid_uri (RygelItemCreator* self, const gchar* uri);
void rygel_media_item_add_uri (RygelMediaItem* self, const gchar* uri);
void rygel_media_item_set_size (RygelMediaItem* self, gint64 value);
static gchar* rygel_item_creator_get_generic_mime_type (RygelItemCreator* self);
gint64 rygel_media_item_get_size (RygelMediaItem* self);
static void rygel_item_creator_create_uri (RygelItemCreator* self, RygelWritableContainer* container, const gchar* title, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gchar* rygel_item_creator_create_uri_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error);
const gchar* rygel_media_object_get_title (RygelMediaObject* self);
void rygel_media_item_set_place_holder (RygelMediaItem* self, gboolean value);
void rygel_writable_container_add_item (RygelWritableContainer* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_writable_container_add_item_finish (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static void rygel_item_creator_wait_for_item (RygelItemCreator* self, RygelWritableContainer* container, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_item_creator_wait_for_item_finish (RygelItemCreator* self, GAsyncResult* _res_);
GUPnPDIDLLiteObject* rygel_media_object_serialize (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
static void rygel_item_creator_conclude (RygelItemCreator* self);
gboolean rygel_media_item_get_place_holder (RygelMediaItem* self);
GType rygel_item_removal_queue_get_type (void) G_GNUC_CONST;
RygelItemRemovalQueue* rygel_item_removal_queue_get_default (void);
void rygel_item_removal_queue_queue (RygelItemRemovalQueue* self, RygelMediaItem* item, GCancellable* cancellable);
static void rygel_item_creator_handle_error (RygelItemCreator* self, GError* _error_);
static void rygel_item_creator_parse_args_data_free (gpointer _data);
static gboolean rygel_item_creator_parse_args_co (RygelItemCreatorParseArgsData* data);
static void rygel_item_creator_fetch_container_data_free (gpointer _data);
static gboolean rygel_item_creator_fetch_container_co (RygelItemCreatorFetchContainerData* data);
RygelRelationalExpression* rygel_relational_expression_new (void);
RygelRelationalExpression* rygel_relational_expression_construct (GType object_type);
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
GType rygel_relational_expression_get_type (void) G_GNUC_CONST;
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
void rygel_searchable_container_search (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_searchable_container_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static void rygel_item_creator_fetch_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
GUPnPOCMFlags rygel_media_object_get_ocm_flags (RygelMediaObject* self);
GType rygel_image_item_get_type (void) G_GNUC_CONST;
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_video_item_get_type (void) G_GNUC_CONST;
#define RYGEL_IMAGE_ITEM_UPNP_CLASS "object.item.imageItem"
#define RYGEL_PHOTO_ITEM_UPNP_CLASS "object.item.imageItem.photo"
#define RYGEL_VIDEO_ITEM_UPNP_CLASS "object.item.videoItem"
#define RYGEL_AUDIO_ITEM_UPNP_CLASS "object.item.audioItem"
#define RYGEL_MUSIC_ITEM_UPNP_CLASS "object.item.audioItem.musicTrack"
RygelImageItem* rygel_image_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelImageItem* rygel_image_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelPhotoItem* rygel_photo_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelPhotoItem* rygel_photo_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_photo_item_get_type (void) G_GNUC_CONST;
RygelVideoItem* rygel_video_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelVideoItem* rygel_video_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelAudioItem* rygel_audio_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelAudioItem* rygel_audio_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMusicItem* rygel_music_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMusicItem* rygel_music_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_music_item_get_type (void) G_GNUC_CONST;
static void rygel_item_creator_create_uri_data_free (gpointer _data);
static gboolean rygel_item_creator_create_uri_co (RygelItemCreatorCreateUriData* data);
void rygel_media_object_get_writable (RygelMediaObject* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GFile* rygel_media_object_get_writable_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error);
static void rygel_item_creator_create_uri_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_item_creator_wait_for_item_data_free (gpointer _data);
static gboolean rygel_item_creator_wait_for_item_co (RygelItemCreatorWaitForItemData* data);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (Block5Data* _data5_);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (Block6Data* _data6_);
static void _lambda10_ (RygelMediaContainer* container, Block6Data* _data6_);
static void __lambda10__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self);
static gboolean _lambda11_ (Block6Data* _data6_);
static gboolean __lambda11__gsource_func (gpointer self);
static void rygel_item_creator_wait_for_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_item_creator_finalize (GObject* obj);
static void _vala_rygel_item_creator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_item_creator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GQuark rygel_item_creator_error_quark (void) {
	return g_quark_from_static_string ("rygel_item_creator_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelItemCreator* rygel_item_creator_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
	RygelItemCreator * self = NULL;
	RygelContentDirectory* _tmp0_;
	GUPnPServiceAction* _tmp1_;
	GUPnPDIDLLiteWriter* _tmp2_ = NULL;
	GUPnPDIDLLiteParser* _tmp3_ = NULL;
	g_return_val_if_fail (content_dir != NULL, NULL);
	g_return_val_if_fail (action != NULL, NULL);
	self = (RygelItemCreator*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (content_dir);
	_g_object_unref0 (self->priv->content_dir);
	self->priv->content_dir = _tmp0_;
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, content_dir->cancellable);
	_tmp1_ = action;
	action = NULL;
	self->priv->action = _tmp1_;
	_tmp2_ = gupnp_didl_lite_writer_new (NULL);
	_g_object_unref0 (self->priv->didl_writer);
	self->priv->didl_writer = _tmp2_;
	_tmp3_ = gupnp_didl_lite_parser_new ();
	_g_object_unref0 (self->priv->didl_parser);
	self->priv->didl_parser = _tmp3_;
	return self;
}


RygelItemCreator* rygel_item_creator_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
	return rygel_item_creator_construct (RYGEL_TYPE_ITEM_CREATOR, content_dir, action);
}


static void rygel_item_creator_real_run_data_free (gpointer _data) {
	RygelItemCreatorRunData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (RygelItemCreatorRunData, data);
}


static void rygel_item_creator_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemCreator * self;
	RygelItemCreatorRunData* _data_;
	self = (RygelItemCreator*) base;
	_data_ = g_slice_new0 (RygelItemCreatorRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_creator_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_creator_real_run_data_free);
	_data_->self = _g_object_ref0 (self);
	rygel_item_creator_real_run_co (_data_);
}


static void rygel_item_creator_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelItemCreatorRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _lambda9_ (GUPnPDIDLLiteItem* didl_item, RygelItemCreator* self) {
	GUPnPDIDLLiteItem* _tmp0_;
	g_return_if_fail (didl_item != NULL);
	_tmp0_ = _g_object_ref0 (didl_item);
	_g_object_unref0 (self->didl_item);
	self->didl_item = _tmp0_;
}


static void __lambda9__gupnp_didl_lite_parser_item_available (GUPnPDIDLLiteParser* _sender, GUPnPDIDLLiteItem* item, gpointer self) {
	_lambda9_ (item, self);
}


static void rygel_item_creator_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemCreatorRunData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_item_creator_real_run_co (data);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gboolean rygel_item_creator_real_run_co (RygelItemCreatorRunData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	rygel_item_creator_parse_args (data->self, NULL, NULL);
	g_signal_connect_object (data->self->priv->didl_parser, "item-available", (GCallback) __lambda9__gupnp_didl_lite_parser_item_available, data->self, 0);
	gupnp_didl_lite_parser_parse_didl (data->self->priv->didl_parser, data->self->elements, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch69_g_error;
	}
	goto __finally69;
	__catch69_g_error:
	{
		data->parse_err = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp0_ = NULL;
		data->_tmp0_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "Bad metadata");
		data->_inner_error_ = data->_tmp0_;
		_g_error_free0 (data->parse_err);
		goto __finally69;
	}
	__finally69:
	if (data->_inner_error_ != NULL) {
		goto __catch68_g_error;
	}
	if (data->self->didl_item == NULL) {
		data->_tmp1_ = NULL;
		data->_tmp1_ = _ ("No items in DIDL-Lite from client: '%s'");
		data->_tmp2_ = g_strdup (data->_tmp1_);
		data->message = data->_tmp2_;
		data->_tmp3_ = NULL;
		data->_tmp3_ = g_error_new (RYGEL_ITEM_CREATOR_ERROR, RYGEL_ITEM_CREATOR_ERROR_PARSE, data->message, data->self->elements);
		data->_inner_error_ = data->_tmp3_;
		_g_free0 (data->message);
		goto __catch68_g_error;
	}
	data->_tmp5_ = NULL;
	data->_tmp5_ = gupnp_didl_lite_object_get_id ((GUPnPDIDLLiteObject*) data->self->didl_item);
	if (data->_tmp5_ == NULL) {
		data->_tmp4_ = TRUE;
	} else {
		data->_tmp6_ = NULL;
		data->_tmp6_ = gupnp_didl_lite_object_get_id ((GUPnPDIDLLiteObject*) data->self->didl_item);
		data->_tmp4_ = g_strcmp0 (data->_tmp6_, "") != 0;
	}
	if (data->_tmp4_) {
		data->_tmp7_ = NULL;
		data->_tmp7_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "@id must be set to \"\" in " "CreateItem");
		data->_inner_error_ = data->_tmp7_;
		goto __catch68_g_error;
	}
	data->_tmp8_ = NULL;
	data->_tmp8_ = gupnp_didl_lite_object_get_title ((GUPnPDIDLLiteObject*) data->self->didl_item);
	if (data->_tmp8_ == NULL) {
		data->_tmp9_ = NULL;
		data->_tmp9_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "dc:title must be set in " "CreateItem");
		data->_inner_error_ = data->_tmp9_;
		goto __catch68_g_error;
	}
	data->_tmp10_ = gupnp_didl_lite_object_get_dlna_managed ((GUPnPDIDLLiteObject*) data->self->didl_item);
	if ((data->_tmp10_ & ((GUPNP_OCM_FLAGS_UPLOAD | GUPNP_OCM_FLAGS_CREATE_CONTAINER) | GUPNP_OCM_FLAGS_UPLOAD_DESTROYABLE)) != 0) {
		data->_tmp11_ = NULL;
		data->_tmp11_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "Flags that must not be set " "were found in 'dlnaManaged'");
		data->_inner_error_ = data->_tmp11_;
		goto __catch68_g_error;
	}
	data->_tmp12_ = gupnp_didl_lite_object_get_restricted ((GUPnPDIDLLiteObject*) data->self->didl_item);
	if (data->_tmp12_) {
		data->_tmp13_ = NULL;
		data->_tmp13_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, "Cannot create restricted item");
		data->_inner_error_ = data->_tmp13_;
		goto __catch68_g_error;
	}
	data->_state_ = 1;
	rygel_item_creator_fetch_container (data->self, rygel_item_creator_run_ready, data);
	return FALSE;
	_state_1:
	data->_tmp14_ = NULL;
	data->_tmp14_ = rygel_item_creator_fetch_container_finish (data->self, data->_res_, &data->_inner_error_);
	data->container = data->_tmp14_;
	if (data->_inner_error_ != NULL) {
		goto __catch68_g_error;
	}
	data->_tmp15_ = NULL;
	data->_tmp15_ = rygel_writable_container_get_create_classes (data->container);
	data->_tmp16_ = NULL;
	data->_tmp16_ = gupnp_didl_lite_object_get_upnp_class ((GUPnPDIDLLiteObject*) data->self->didl_item);
	data->_tmp17_ = gee_abstract_collection_contains ((GeeAbstractCollection*) data->_tmp15_, data->_tmp16_);
	if (!data->_tmp17_) {
		data->_tmp18_ = NULL;
		data->_tmp18_ = gupnp_didl_lite_object_get_upnp_class ((GUPnPDIDLLiteObject*) data->self->didl_item);
		data->_tmp19_ = NULL;
		data->_tmp19_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "Creating of objects with class %s " "is not supported in %s", data->_tmp18_, ((RygelMediaObject*) data->container)->id);
		data->_inner_error_ = data->_tmp19_;
		_g_object_unref0 (data->container);
		goto __catch68_g_error;
	}
	data->_tmp20_ = NULL;
	data->_tmp20_ = gupnp_didl_lite_object_get_id ((GUPnPDIDLLiteObject*) data->self->didl_item);
	data->_tmp21_ = NULL;
	data->_tmp21_ = gupnp_didl_lite_object_get_title ((GUPnPDIDLLiteObject*) data->self->didl_item);
	data->_tmp22_ = NULL;
	data->_tmp22_ = gupnp_didl_lite_object_get_upnp_class ((GUPnPDIDLLiteObject*) data->self->didl_item);
	data->_tmp23_ = NULL;
	data->_tmp23_ = rygel_item_creator_create_item (data->self, data->_tmp20_, data->container, data->_tmp21_, data->_tmp22_, &data->_inner_error_);
	data->_tmp24_ = data->_tmp23_;
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->container);
		goto __catch68_g_error;
	}
	_g_object_unref0 (data->self->item);
	data->self->item = data->_tmp24_;
	data->_tmp25_ = NULL;
	data->_tmp25_ = gupnp_didl_lite_object_get_resources ((GUPnPDIDLLiteObject*) data->self->didl_item);
	data->resources = data->_tmp25_;
	if (data->resources != NULL) {
		data->_tmp27_ = g_list_length (data->resources);
		data->_tmp26_ = data->_tmp27_ > 0;
	} else {
		data->_tmp26_ = FALSE;
	}
	if (data->_tmp26_) {
		data->_tmp28_ = NULL;
		data->_tmp28_ = g_list_nth (data->resources, (guint) 0);
		data->_tmp29_ = _g_object_ref0 ((GUPnPDIDLLiteResource*) data->_tmp28_->data);
		data->resource = data->_tmp29_;
		data->_tmp30_ = NULL;
		data->_tmp30_ = gupnp_didl_lite_resource_get_protocol_info (data->resource);
		data->_tmp31_ = _g_object_ref0 (data->_tmp30_);
		data->info = data->_tmp31_;
		if (data->info != NULL) {
			data->_tmp32_ = NULL;
			data->_tmp32_ = gupnp_protocol_info_get_dlna_profile (data->info);
			if (data->_tmp32_ != NULL) {
				data->_tmp33_ = NULL;
				data->_tmp33_ = gupnp_protocol_info_get_dlna_profile (data->info);
				data->_tmp34_ = rygel_item_creator_is_profile_valid (data->self, data->_tmp33_);
				if (!data->_tmp34_) {
					data->_tmp35_ = NULL;
					data->_tmp35_ = gupnp_protocol_info_get_dlna_profile (data->info);
					data->_tmp36_ = NULL;
					data->_tmp36_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "'%s' DLNA profile unsupported", data->_tmp35_);
					data->_inner_error_ = data->_tmp36_;
					_g_object_unref0 (data->info);
					_g_object_unref0 (data->resource);
					__g_list_free__g_object_unref0_0 (data->resources);
					_g_object_unref0 (data->container);
					goto __catch68_g_error;
				}
				data->_tmp37_ = NULL;
				data->_tmp37_ = gupnp_protocol_info_get_dlna_profile (data->info);
				data->_tmp38_ = g_strdup (data->_tmp37_);
				_g_free0 (data->self->item->dlna_profile);
				data->self->item->dlna_profile = data->_tmp38_;
			}
			data->_tmp39_ = NULL;
			data->_tmp39_ = gupnp_protocol_info_get_mime_type (data->info);
			if (data->_tmp39_ != NULL) {
				data->_tmp40_ = NULL;
				data->_tmp40_ = gupnp_protocol_info_get_mime_type (data->info);
				data->_tmp41_ = g_strdup (data->_tmp40_);
				_g_free0 (data->self->item->mime_type);
				data->self->item->mime_type = data->_tmp41_;
			}
		}
		data->_tmp42_ = NULL;
		data->_tmp42_ = gupnp_didl_lite_resource_get_uri (data->resource);
		data->_tmp43_ = rygel_item_creator_is_valid_uri (data->self, data->_tmp42_);
		if (data->_tmp43_) {
			data->_tmp44_ = NULL;
			data->_tmp44_ = gupnp_didl_lite_resource_get_uri (data->resource);
			rygel_media_item_add_uri (data->self->item, data->_tmp44_);
		}
		data->_tmp45_ = gupnp_didl_lite_resource_get_size (data->resource);
		if (data->_tmp45_ >= 0) {
			data->_tmp46_ = gupnp_didl_lite_resource_get_size (data->resource);
			rygel_media_item_set_size (data->self->item, (gint64) data->_tmp46_);
		}
		_g_object_unref0 (data->info);
		_g_object_unref0 (data->resource);
	}
	if (data->self->item->mime_type == NULL) {
		data->_tmp47_ = NULL;
		data->_tmp47_ = rygel_item_creator_get_generic_mime_type (data->self);
		_g_free0 (data->self->item->mime_type);
		data->self->item->mime_type = data->_tmp47_;
	}
	data->_tmp48_ = rygel_media_item_get_size (data->self->item);
	if (data->_tmp48_ < 0) {
		rygel_media_item_set_size (data->self->item, (gint64) 0);
	}
	data->_tmp49_ = gee_collection_get_size ((GeeCollection*) ((RygelMediaObject*) data->self->item)->uris);
	if (data->_tmp49_ == 0) {
		data->_tmp50_ = NULL;
		data->_tmp50_ = rygel_media_object_get_title ((RygelMediaObject*) data->self->item);
		data->_state_ = 2;
		rygel_item_creator_create_uri (data->self, data->container, data->_tmp50_, rygel_item_creator_run_ready, data);
		return FALSE;
		_state_2:
		data->_tmp51_ = NULL;
		data->_tmp51_ = rygel_item_creator_create_uri_finish (data->self, data->_res_, &data->_inner_error_);
		data->uri = data->_tmp51_;
		if (data->_inner_error_ != NULL) {
			__g_list_free__g_object_unref0_0 (data->resources);
			_g_object_unref0 (data->container);
			goto __catch68_g_error;
		}
		gee_abstract_collection_add ((GeeAbstractCollection*) ((RygelMediaObject*) data->self->item)->uris, data->uri);
		rygel_media_item_set_place_holder (data->self->item, TRUE);
		_g_free0 (data->uri);
	} else {
		data->_tmp52_ = NULL;
		data->_tmp52_ = gee_abstract_list_get ((GeeAbstractList*) ((RygelMediaObject*) data->self->item)->uris, 0);
		data->_tmp53_ = (gchar*) data->_tmp52_;
		data->_tmp54_ = NULL;
		data->_tmp54_ = g_file_new_for_uri (data->_tmp53_);
		data->_tmp55_ = data->_tmp54_;
		_g_free0 (data->_tmp53_);
		data->file = data->_tmp55_;
		data->_tmp56_ = g_file_is_native (data->file);
		rygel_media_item_set_place_holder (data->self->item, !data->_tmp56_);
		_g_object_unref0 (data->file);
	}
	data->_tmp57_ = NULL;
	data->_tmp57_ = gee_abstract_list_get ((GeeAbstractList*) ((RygelMediaObject*) data->self->item)->uris, 0);
	_g_free0 (((RygelMediaObject*) data->self->item)->id);
	((RygelMediaObject*) data->self->item)->id = (gchar*) data->_tmp57_;
	data->_tmp58_ = NULL;
	data->_tmp58_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self);
	data->_state_ = 3;
	rygel_writable_container_add_item (data->container, data->self->item, data->_tmp58_, rygel_item_creator_run_ready, data);
	return FALSE;
	_state_3:
	rygel_writable_container_add_item_finish (data->container, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		__g_list_free__g_object_unref0_0 (data->resources);
		_g_object_unref0 (data->container);
		goto __catch68_g_error;
	}
	data->_state_ = 4;
	rygel_item_creator_wait_for_item (data->self, data->container, rygel_item_creator_run_ready, data);
	return FALSE;
	_state_4:
	rygel_item_creator_wait_for_item_finish (data->self, data->_res_);
	data->_tmp59_ = NULL;
	data->_tmp59_ = rygel_media_object_serialize ((RygelMediaObject*) data->self->item, data->self->priv->didl_writer, data->self->priv->content_dir->http_server, &data->_inner_error_);
	data->_tmp60_ = data->_tmp59_;
	_g_object_unref0 (data->_tmp60_);
	if (data->_inner_error_ != NULL) {
		__g_list_free__g_object_unref0_0 (data->resources);
		_g_object_unref0 (data->container);
		goto __catch68_g_error;
	}
	rygel_item_creator_conclude (data->self);
	if (g_strcmp0 (data->self->container_id, "DLNA.ORG_AnyContainer") == 0) {
		data->_tmp62_ = rygel_media_item_get_place_holder (data->self->item);
		data->_tmp61_ = data->_tmp62_;
	} else {
		data->_tmp61_ = FALSE;
	}
	if (data->_tmp61_) {
		data->_tmp63_ = NULL;
		data->_tmp63_ = rygel_item_removal_queue_get_default ();
		data->queue = data->_tmp63_;
		data->_tmp64_ = NULL;
		data->_tmp64_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self);
		rygel_item_removal_queue_queue (data->queue, data->self->item, data->_tmp64_);
		_g_object_unref0 (data->queue);
	}
	__g_list_free__g_object_unref0_0 (data->resources);
	_g_object_unref0 (data->container);
	goto __finally68;
	__catch68_g_error:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		rygel_item_creator_handle_error (data->self, data->err);
		_g_error_free0 (data->err);
	}
	__finally68:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_item_creator_parse_args_data_free (gpointer _data) {
	RygelItemCreatorParseArgsData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (RygelItemCreatorParseArgsData, data);
}


static void rygel_item_creator_parse_args (RygelItemCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemCreatorParseArgsData* _data_;
	_data_ = g_slice_new0 (RygelItemCreatorParseArgsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_creator_parse_args);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_creator_parse_args_data_free);
	_data_->self = _g_object_ref0 (self);
	rygel_item_creator_parse_args_co (_data_);
}


static void rygel_item_creator_parse_args_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error) {
	RygelItemCreatorParseArgsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean rygel_item_creator_parse_args_co (RygelItemCreatorParseArgsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	gupnp_service_action_get (data->self->priv->action, "ContainerID", G_TYPE_STRING, &data->self->container_id, "Elements", G_TYPE_STRING, &data->self->elements, NULL);
	if (data->self->elements == NULL) {
		data->_tmp0_ = NULL;
		data->_tmp0_ = _ ("'Elements' argument missing.");
		data->_tmp1_ = NULL;
		data->_tmp1_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, data->_tmp0_);
		data->_inner_error_ = data->_tmp1_;
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	} else {
		data->_tmp2_ = g_pattern_match_string (rygel_item_creator_comment_pattern, data->self->elements);
		if (data->_tmp2_) {
			data->_tmp3_ = NULL;
			data->_tmp3_ = _ ("Comments not allowed in XML");
			data->_tmp4_ = NULL;
			data->_tmp4_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, data->_tmp3_);
			data->_inner_error_ = data->_tmp4_;
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	if (data->self->container_id == NULL) {
		data->_tmp5_ = NULL;
		data->_tmp5_ = _ ("No such object");
		data->_tmp6_ = NULL;
		data->_tmp6_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, data->_tmp5_);
		data->_inner_error_ = data->_tmp6_;
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_item_creator_fetch_container_data_free (gpointer _data) {
	RygelItemCreatorFetchContainerData* data;
	data = _data;
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (RygelItemCreatorFetchContainerData, data);
}


static void rygel_item_creator_fetch_container (RygelItemCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemCreatorFetchContainerData* _data_;
	_data_ = g_slice_new0 (RygelItemCreatorFetchContainerData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_creator_fetch_container);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_creator_fetch_container_data_free);
	_data_->self = _g_object_ref0 (self);
	rygel_item_creator_fetch_container_co (_data_);
}


static RygelWritableContainer* rygel_item_creator_fetch_container_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error) {
	RygelWritableContainer* result;
	RygelItemCreatorFetchContainerData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_item_creator_fetch_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemCreatorFetchContainerData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_item_creator_fetch_container_co (data);
}


static gboolean rygel_item_creator_fetch_container_co (RygelItemCreatorFetchContainerData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->media_object = NULL;
	if (g_strcmp0 (data->self->container_id, "DLNA.ORG_AnyContainer") == 0) {
		data->_tmp0_ = NULL;
		data->_tmp0_ = rygel_relational_expression_new ();
		data->expression = data->_tmp0_;
		((RygelSearchExpression*) data->expression)->op = GINT_TO_POINTER (GUPNP_SEARCH_CRITERIA_OP_DERIVED_FROM);
		data->_tmp1_ = g_strdup ("upnp:createClass");
		_g_free0 (((RygelSearchExpression*) data->expression)->operand1);
		((RygelSearchExpression*) data->expression)->operand1 = data->_tmp1_;
		data->_tmp2_ = NULL;
		data->_tmp2_ = gupnp_didl_lite_object_get_upnp_class ((GUPnPDIDLLiteObject*) data->self->didl_item);
		data->_tmp3_ = g_strdup (data->_tmp2_);
		_g_free0 (((RygelSearchExpression*) data->expression)->operand2);
		((RygelSearchExpression*) data->expression)->operand2 = data->_tmp3_;
		data->_tmp4_ = data->self->priv->content_dir->root_container;
		data->_tmp5_ = _g_object_ref0 (RYGEL_IS_SEARCHABLE_CONTAINER (data->_tmp4_) ? ((RygelSearchableContainer*) data->_tmp4_) : NULL);
		data->container = data->_tmp5_;
		if (data->container != NULL) {
			data->_tmp6_ = NULL;
			data->_tmp6_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self);
			data->_state_ = 1;
			rygel_searchable_container_search (data->container, (RygelSearchExpression*) data->expression, (guint) 0, (guint) 1, data->_tmp6_, rygel_item_creator_fetch_container_ready, data);
			return FALSE;
			_state_1:
			data->_tmp8_ = NULL;
			data->_tmp8_ = rygel_searchable_container_search_finish (data->container, data->_res_, &data->_tmp7_, &data->_inner_error_);
			data->total_matches = data->_tmp7_;
			data->_result_ = data->_tmp8_;
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_g_object_unref0 (data->container);
				_rygel_search_expression_unref0 (data->expression);
				_g_object_unref0 (data->media_object);
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			data->_tmp9_ = gee_collection_get_size ((GeeCollection*) data->_result_);
			if (data->_tmp9_ > 0) {
				data->_tmp10_ = NULL;
				data->_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) data->_result_, 0);
				_g_object_unref0 (data->media_object);
				data->media_object = (RygelMediaObject*) data->_tmp10_;
			} else {
				data->_tmp11_ = NULL;
				data->_tmp11_ = gupnp_didl_lite_object_get_upnp_class ((GUPnPDIDLLiteObject*) data->self->didl_item);
				data->_tmp12_ = NULL;
				data->_tmp12_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "'%s' UPnP class unsupported", data->_tmp11_);
				data->_inner_error_ = data->_tmp12_;
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_g_object_unref0 (data->_result_);
				_g_object_unref0 (data->container);
				_rygel_search_expression_unref0 (data->expression);
				_g_object_unref0 (data->media_object);
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			_g_object_unref0 (data->_result_);
		}
		_g_object_unref0 (data->container);
		_rygel_search_expression_unref0 (data->expression);
	} else {
		data->_tmp13_ = NULL;
		data->_tmp13_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self);
		data->_state_ = 2;
		rygel_media_container_find_object (data->self->priv->content_dir->root_container, data->self->container_id, data->_tmp13_, rygel_item_creator_fetch_container_ready, data);
		return FALSE;
		_state_2:
		data->_tmp14_ = NULL;
		data->_tmp14_ = rygel_media_container_find_object_finish (data->self->priv->content_dir->root_container, data->_res_, &data->_inner_error_);
		data->_tmp15_ = data->_tmp14_;
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->media_object);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		_g_object_unref0 (data->media_object);
		data->media_object = data->_tmp15_;
	}
	if (data->media_object == NULL) {
		data->_tmp16_ = NULL;
		data->_tmp16_ = _ ("No such object");
		data->_tmp17_ = NULL;
		data->_tmp17_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, data->_tmp16_);
		data->_inner_error_ = data->_tmp17_;
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_object_unref0 (data->media_object);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	} else {
		if (!RYGEL_IS_MEDIA_CONTAINER (data->media_object)) {
			data->_tmp18_ = TRUE;
		} else {
			data->_tmp19_ = rygel_media_object_get_ocm_flags (data->media_object);
			data->_tmp18_ = !((data->_tmp19_ & GUPNP_OCM_FLAGS_UPLOAD) == GUPNP_OCM_FLAGS_UPLOAD);
		}
		if (data->_tmp18_) {
			data->_tmp20_ = NULL;
			data->_tmp20_ = _ ("Object creation in %s not allowed");
			data->_tmp21_ = NULL;
			data->_tmp21_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT, data->_tmp20_, data->media_object->id);
			data->_inner_error_ = data->_tmp21_;
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->media_object);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	data->_tmp22_ = data->media_object;
	data->_tmp23_ = _g_object_ref0 (RYGEL_IS_WRITABLE_CONTAINER (data->_tmp22_) ? ((RygelWritableContainer*) data->_tmp22_) : NULL);
	data->result = data->_tmp23_;
	_g_object_unref0 (data->media_object);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_object_unref0 (data->media_object);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_item_creator_conclude (RygelItemCreator* self) {
	gchar* _tmp0_ = NULL;
	gchar* didl;
	g_return_if_fail (self != NULL);
	_tmp0_ = gupnp_didl_lite_writer_get_string (self->priv->didl_writer);
	didl = _tmp0_;
	gupnp_service_action_set (self->priv->action, "ObjectID", G_TYPE_STRING, ((RygelMediaObject*) self->item)->id, "Result", G_TYPE_STRING, didl, NULL);
	gupnp_service_action_return (self->priv->action);
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
	_g_free0 (didl);
}


static void rygel_item_creator_handle_error (RygelItemCreator* self, GError* _error_) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	if (_error_->domain == RYGEL_CONTENT_DIRECTORY_ERROR) {
		gupnp_service_action_return_error (self->priv->action, (guint) _error_->code, _error_->message);
	} else {
		gupnp_service_action_return_error (self->priv->action, (guint) 701, _error_->message);
	}
	_tmp0_ = _ ("Failed to create item under '%s': %s");
	g_warning (_tmp0_, self->container_id, _error_->message);
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
}


static gchar* rygel_item_creator_get_generic_mime_type (RygelItemCreator* self) {
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (RYGEL_IS_IMAGE_ITEM (self->item)) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("image");
		result = _tmp0_;
		return result;
	} else {
		if (RYGEL_IS_VIDEO_ITEM (self->item)) {
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("video");
			result = _tmp1_;
			return result;
		} else {
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("audio");
			result = _tmp2_;
			return result;
		}
	}
}


static RygelMediaItem* rygel_item_creator_create_item (RygelItemCreator* self, const gchar* id, RygelWritableContainer* parent, const gchar* title, const gchar* upnp_class, GError** error) {
	RygelMediaItem* result = NULL;
	const gchar* _tmp0_;
	GQuark _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (upnp_class != NULL, NULL);
	_tmp0_ = upnp_class;
	_tmp1_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp1_ == g_quark_from_string (RYGEL_IMAGE_ITEM_UPNP_CLASS)) {
		switch (0) {
			default:
			{
				RygelImageItem* _tmp2_ = NULL;
				_tmp2_ = rygel_image_item_new (id, (RygelMediaContainer*) parent, title, RYGEL_IMAGE_ITEM_UPNP_CLASS);
				result = (RygelMediaItem*) _tmp2_;
				return result;
			}
		}
	} else if (_tmp1_ == g_quark_from_string (RYGEL_PHOTO_ITEM_UPNP_CLASS)) {
		switch (0) {
			default:
			{
				RygelPhotoItem* _tmp3_ = NULL;
				_tmp3_ = rygel_photo_item_new (id, (RygelMediaContainer*) parent, title, RYGEL_PHOTO_ITEM_UPNP_CLASS);
				result = (RygelMediaItem*) _tmp3_;
				return result;
			}
		}
	} else if (_tmp1_ == g_quark_from_string (RYGEL_VIDEO_ITEM_UPNP_CLASS)) {
		switch (0) {
			default:
			{
				RygelVideoItem* _tmp4_ = NULL;
				_tmp4_ = rygel_video_item_new (id, (RygelMediaContainer*) parent, title, RYGEL_VIDEO_ITEM_UPNP_CLASS);
				result = (RygelMediaItem*) _tmp4_;
				return result;
			}
		}
	} else if (_tmp1_ == g_quark_from_string (RYGEL_AUDIO_ITEM_UPNP_CLASS)) {
		switch (0) {
			default:
			{
				RygelAudioItem* _tmp5_ = NULL;
				_tmp5_ = rygel_audio_item_new (id, (RygelMediaContainer*) parent, title, RYGEL_AUDIO_ITEM_UPNP_CLASS);
				result = (RygelMediaItem*) _tmp5_;
				return result;
			}
		}
	} else if (_tmp1_ == g_quark_from_string (RYGEL_MUSIC_ITEM_UPNP_CLASS)) {
		switch (0) {
			default:
			{
				RygelMusicItem* _tmp6_ = NULL;
				_tmp6_ = rygel_music_item_new (id, (RygelMediaContainer*) parent, title, RYGEL_MUSIC_ITEM_UPNP_CLASS);
				result = (RygelMediaItem*) _tmp6_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				GError* _tmp7_ = NULL;
				_tmp7_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "Creation of item of class '%s' " "not supported.", upnp_class);
				_inner_error_ = _tmp7_;
				g_propagate_error (error, _inner_error_);
				return NULL;
			}
		}
	}
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	gunichar _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = g_utf8_get_char (((gchar*) self) + index);
	result = _tmp0_;
	return result;
}


static gboolean rygel_item_creator_is_valid_uri (RygelItemCreator* self, const gchar* uri) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (uri == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (uri, "") == 0;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	{
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		gchar* next;
		_tmp1_ = g_utf8_next_char (uri);
		_tmp2_ = g_strdup (_tmp1_);
		next = _tmp2_;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gunichar _tmp6_;
				gboolean _tmp7_;
				if (!_tmp3_) {
					const gchar* _tmp4_ = NULL;
					gchar* _tmp5_;
					_tmp4_ = g_utf8_next_char (next);
					_tmp5_ = g_strdup (_tmp4_);
					_g_free0 (next);
					next = _tmp5_;
				}
				_tmp3_ = FALSE;
				if (!(g_strcmp0 (next, "") != 0)) {
					break;
				}
				_tmp6_ = string_get_char (next, (glong) 0);
				_tmp7_ = g_unichar_isspace (_tmp6_);
				if (_tmp7_) {
					result = FALSE;
					_g_free0 (next);
					return result;
				}
			}
		}
		_g_free0 (next);
	}
	result = TRUE;
	return result;
}


static void rygel_item_creator_create_uri_data_free (gpointer _data) {
	RygelItemCreatorCreateUriData* data;
	data = _data;
	_g_object_unref0 (data->container);
	_g_free0 (data->title);
	_g_free0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (RygelItemCreatorCreateUriData, data);
}


static void rygel_item_creator_create_uri (RygelItemCreator* self, RygelWritableContainer* container, const gchar* title, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemCreatorCreateUriData* _data_;
	_data_ = g_slice_new0 (RygelItemCreatorCreateUriData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_creator_create_uri);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_creator_create_uri_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->container = _g_object_ref0 (container);
	_data_->title = g_strdup (title);
	rygel_item_creator_create_uri_co (_data_);
}


static gchar* rygel_item_creator_create_uri_finish (RygelItemCreator* self, GAsyncResult* _res_, GError** error) {
	gchar* result;
	RygelItemCreatorCreateUriData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_item_creator_create_uri_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemCreatorCreateUriData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_item_creator_create_uri_co (data);
}


static gboolean rygel_item_creator_create_uri_co (RygelItemCreatorCreateUriData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self);
	data->_state_ = 1;
	rygel_media_object_get_writable ((RygelMediaObject*) data->container, data->_tmp0_, rygel_item_creator_create_uri_ready, data);
	return FALSE;
	_state_1:
	data->_tmp1_ = NULL;
	data->_tmp1_ = rygel_media_object_get_writable_finish ((RygelMediaObject*) data->container, data->_res_, &data->_inner_error_);
	data->dir = data->_tmp1_;
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	if (data->dir == NULL) {
		data->_tmp2_ = NULL;
		data->_tmp2_ = _ ("Object creation in %s not allowed");
		data->_tmp3_ = NULL;
		data->_tmp3_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT, data->_tmp2_, ((RygelMediaObject*) data->container)->id);
		data->_inner_error_ = data->_tmp3_;
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_object_unref0 (data->dir);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp4_ = NULL;
	data->_tmp4_ = g_date_time_new_now_utc ();
	data->now = data->_tmp4_;
	data->_tmp5_ = NULL;
	data->_tmp5_ = g_file_get_child_for_display_name (data->dir, data->title, &data->_inner_error_);
	data->file = data->_tmp5_;
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_date_time_unref0 (data->now);
		_g_object_unref0 (data->dir);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp6_ = NULL;
	data->_tmp6_ = g_file_get_uri (data->file);
	data->_tmp7_ = data->_tmp6_;
	data->_tmp8_ = NULL;
	data->_tmp8_ = g_date_time_format (data->now, "%s");
	data->_tmp9_ = data->_tmp8_;
	data->_tmp10_ = g_strconcat (data->_tmp7_, data->_tmp9_, NULL);
	data->_tmp11_ = data->_tmp10_;
	_g_free0 (data->_tmp9_);
	_g_free0 (data->_tmp7_);
	data->result = data->_tmp11_;
	_g_object_unref0 (data->file);
	_g_date_time_unref0 (data->now);
	_g_object_unref0 (data->dir);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_object_unref0 (data->file);
	_g_date_time_unref0 (data->now);
	_g_object_unref0 (data->dir);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_item_creator_wait_for_item_data_free (gpointer _data) {
	RygelItemCreatorWaitForItemData* data;
	data = _data;
	_g_object_unref0 (data->container);
	_g_object_unref0 (data->self);
	g_slice_free (RygelItemCreatorWaitForItemData, data);
}


static void rygel_item_creator_wait_for_item (RygelItemCreator* self, RygelWritableContainer* container, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemCreatorWaitForItemData* _data_;
	_data_ = g_slice_new0 (RygelItemCreatorWaitForItemData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_creator_wait_for_item);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_creator_wait_for_item_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->container = _g_object_ref0 (container);
	rygel_item_creator_wait_for_item_co (_data_);
}


static void rygel_item_creator_wait_for_item_finish (RygelItemCreator* self, GAsyncResult* _res_) {
	RygelItemCreatorWaitForItemData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (Block5Data* _data5_) {
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		_g_object_unref0 (_data5_->self);
		_g_object_unref0 (_data5_->container);
		g_slice_free (Block5Data, _data5_);
	}
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (Block6Data* _data6_) {
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		block5_data_unref (_data6_->_data5_);
		_data6_->_data5_ = NULL;
		g_slice_free (Block6Data, _data6_);
	}
}


static void _lambda10_ (RygelMediaContainer* container, Block6Data* _data6_) {
	Block5Data* _data5_;
	RygelItemCreator * self;
	_data5_ = _data6_->_data5_;
	self = _data5_->self;
	g_return_if_fail (container != NULL);
	rygel_item_creator_wait_for_item_co (_data5_->_async_data_);
}


static void __lambda10__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self) {
	_lambda10_ (container, self);
}


static gboolean _lambda11_ (Block6Data* _data6_) {
	Block5Data* _data5_;
	RygelItemCreator * self;
	gboolean result = FALSE;
	_data5_ = _data6_->_data5_;
	self = _data5_->self;
	g_debug ("rygel-item-creator.vala:363: Timeout on waiting for 'updated' signal o" \
"n '%s'.", ((RygelMediaObject*) _data5_->container)->id);
	rygel_item_creator_wait_for_item_co (_data5_->_async_data_);
	_data6_->timeout = (guint) 0;
	result = FALSE;
	return result;
}


static gboolean __lambda11__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda11_ (self);
	return result;
}


static void rygel_item_creator_wait_for_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemCreatorWaitForItemData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_item_creator_wait_for_item_co (data);
}


static gboolean rygel_item_creator_wait_for_item_co (RygelItemCreatorWaitForItemData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_data5_ = g_slice_new0 (Block5Data);
	data->_data5_->_ref_count_ = 1;
	data->_data5_->self = g_object_ref (data->self);
	data->_data5_->container = _g_object_ref0 (data->container);
	data->_data5_->_async_data_ = data;
	g_debug ("rygel-item-creator.vala:350: Waiting for new item to appear under cont" \
"ainer '%s'..", ((RygelMediaObject*) data->_data5_->container)->id);
	data->item = NULL;
	while (TRUE) {
		if (!(data->item == NULL)) {
			break;
		}
		if (data->item == NULL) {
			data->_data6_ = g_slice_new0 (Block6Data);
			data->_data6_->_ref_count_ = 1;
			data->_data6_->_data5_ = block5_data_ref (data->_data5_);
			data->_tmp0_ = g_signal_connect_data ((RygelMediaContainer*) data->_data5_->container, "container-updated", (GCallback) __lambda10__rygel_media_container_container_updated, block6_data_ref (data->_data6_), (GClosureNotify) block6_data_unref, 0);
			data->id = data->_tmp0_;
			data->_data6_->timeout = (guint) 0;
			data->_tmp1_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, __lambda11__gsource_func, block6_data_ref (data->_data6_), block6_data_unref);
			data->_data6_->timeout = data->_tmp1_;
			data->_state_ = 1;
			return FALSE;
			_state_1:
			;
			g_signal_handler_disconnect ((GObject*) data->_data5_->container, data->id);
			data->_tmp2_ = NULL;
			data->_tmp2_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self);
			data->_state_ = 2;
			rygel_media_container_find_object ((RygelMediaContainer*) data->_data5_->container, ((RygelMediaObject*) data->self->item)->id, data->_tmp2_, rygel_item_creator_wait_for_item_ready, data);
			return FALSE;
			_state_2:
			data->_tmp3_ = NULL;
			data->_tmp3_ = rygel_media_container_find_object_finish ((RygelMediaContainer*) data->_data5_->container, data->_res_, &data->_inner_error_);
			data->_tmp4_ = data->_tmp3_;
			if (data->_inner_error_ != NULL) {
				goto __catch70_g_error;
			}
			data->_tmp5_ = data->_tmp4_;
			_g_object_unref0 (data->item);
			data->item = RYGEL_IS_MEDIA_ITEM (data->_tmp5_) ? ((RygelMediaItem*) data->_tmp5_) : NULL;
			goto __finally70;
			__catch70_g_error:
			{
				data->_error_ = data->_inner_error_;
				data->_inner_error_ = NULL;
				g_warning ("Error from container '%s' on trying to find newly " "added child item '%s' in it", ((RygelMediaObject*) data->_data5_->container)->id, ((RygelMediaObject*) data->self->item)->id);
				_g_error_free0 (data->_error_);
			}
			__finally70:
			if (data->_inner_error_ != NULL) {
				block6_data_unref (data->_data6_);
				data->_data6_ = NULL;
				_g_object_unref0 (data->item);
				block5_data_unref (data->_data5_);
				data->_data5_ = NULL;
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
			if (data->_data6_->timeout != 0) {
				g_source_remove (data->_data6_->timeout);
			} else {
				block6_data_unref (data->_data6_);
				data->_data6_ = NULL;
				break;
			}
			block6_data_unref (data->_data6_);
			data->_data6_ = NULL;
		}
	}
	g_debug ("rygel-item-creator.vala:394: Finished waiting for new item to appear u" \
"nder container '%s'", ((RygelMediaObject*) data->_data5_->container)->id);
	_g_object_unref0 (data->item);
	block5_data_unref (data->_data5_);
	data->_data5_ = NULL;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static gboolean rygel_item_creator_is_profile_valid (RygelItemCreator* self, const gchar* profile) {
	gboolean result = FALSE;
	GUPnPDLNADiscoverer* _tmp0_ = NULL;
	GUPnPDLNADiscoverer* discoverer;
	gboolean valid;
	GList* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (profile != NULL, FALSE);
	_tmp0_ = gupnp_dlna_discoverer_new ((GstClockTime) GST_SECOND, TRUE, FALSE);
	discoverer = _tmp0_;
	valid = FALSE;
	_tmp1_ = gupnp_dlna_discoverer_list_profiles (discoverer);
	{
		GList* known_profile_collection;
		GList* known_profile_it;
		known_profile_collection = _tmp1_;
		for (known_profile_it = known_profile_collection; known_profile_it != NULL; known_profile_it = known_profile_it->next) {
			GUPnPDLNAProfile* known_profile;
			known_profile = (GUPnPDLNAProfile*) known_profile_it->data;
			{
				const gchar* _tmp2_ = NULL;
				_tmp2_ = gupnp_dlna_profile_get_name (known_profile);
				if (g_strcmp0 (_tmp2_, profile) == 0) {
					valid = TRUE;
					break;
				}
			}
		}
	}
	result = valid;
	_g_object_unref0 (discoverer);
	return result;
}


static GCancellable* rygel_item_creator_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelItemCreator* self;
	self = (RygelItemCreator*) base;
	result = self->priv->_cancellable;
	return result;
}


static void rygel_item_creator_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelItemCreator* self;
	GCancellable* _tmp0_;
	self = (RygelItemCreator*) base;
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_cancellable);
	self->priv->_cancellable = _tmp0_;
	g_object_notify ((GObject *) self, "cancellable");
}


static void rygel_item_creator_class_init (RygelItemCreatorClass * klass) {
	GPatternSpec* _tmp0_ = NULL;
	rygel_item_creator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelItemCreatorPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_item_creator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_item_creator_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_item_creator_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_ITEM_CREATOR_CANCELLABLE, "cancellable");
	_tmp0_ = g_pattern_spec_new ("*<!--*-->*");
	rygel_item_creator_comment_pattern = _tmp0_;
}


static void rygel_item_creator_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
	rygel_item_creator_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = (void (*)(RygelStateMachine*)) rygel_item_creator_real_run;
	iface->run_finish = rygel_item_creator_real_run_finish;
	iface->get_cancellable = rygel_item_creator_real_get_cancellable;
	iface->set_cancellable = rygel_item_creator_real_set_cancellable;
}


static void rygel_item_creator_instance_init (RygelItemCreator * self) {
	self->priv = RYGEL_ITEM_CREATOR_GET_PRIVATE (self);
}


static void rygel_item_creator_finalize (GObject* obj) {
	RygelItemCreator * self;
	self = RYGEL_ITEM_CREATOR (obj);
	_g_free0 (self->container_id);
	_g_free0 (self->elements);
	_g_object_unref0 (self->didl_item);
	_g_object_unref0 (self->item);
	_g_object_unref0 (self->priv->content_dir);
	_g_object_unref0 (self->priv->didl_writer);
	_g_object_unref0 (self->priv->didl_parser);
	_g_object_unref0 (self->priv->_cancellable);
	G_OBJECT_CLASS (rygel_item_creator_parent_class)->finalize (obj);
}


/**
 * CreateObject action implementation.
 */
GType rygel_item_creator_get_type (void) {
	static volatile gsize rygel_item_creator_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_item_creator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelItemCreatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_item_creator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelItemCreator), 0, (GInstanceInitFunc) rygel_item_creator_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_item_creator_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_item_creator_type_id;
		rygel_item_creator_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelItemCreator", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_item_creator_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_item_creator_type_id__volatile, rygel_item_creator_type_id);
	}
	return rygel_item_creator_type_id__volatile;
}


static void _vala_rygel_item_creator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelItemCreator * self;
	self = RYGEL_ITEM_CREATOR (object);
	switch (property_id) {
		case RYGEL_ITEM_CREATOR_CANCELLABLE:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_item_creator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelItemCreator * self;
	self = RYGEL_ITEM_CREATOR (object);
	switch (property_id) {
		case RYGEL_ITEM_CREATOR_CANCELLABLE:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



