/* rygel-media-export-harvester.c generated by valac 0.12.0, the Vala compiler
 * generated from rygel-media-export-harvester.vala, do not modify */

/*
 * Copyright (C) 2010 Jens Georg <mail@jensge.org>.
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <gio/gio.h>
#include <rygel.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define RYGEL_MEDIA_EXPORT_TYPE_HARVESTER (rygel_media_export_harvester_get_type ())
#define RYGEL_MEDIA_EXPORT_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvester))
#define RYGEL_MEDIA_EXPORT_HARVESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterClass))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER))
#define RYGEL_MEDIA_EXPORT_HARVESTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterClass))

typedef struct _RygelMediaExportHarvester RygelMediaExportHarvester;
typedef struct _RygelMediaExportHarvesterClass RygelMediaExportHarvesterClass;
typedef struct _RygelMediaExportHarvesterPrivate RygelMediaExportHarvesterPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK (rygel_media_export_harvesting_task_get_type ())
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTask))
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTaskClass))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTING_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTING_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK))
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTaskClass))

typedef struct _RygelMediaExportHarvestingTask RygelMediaExportHarvestingTask;
typedef struct _RygelMediaExportHarvestingTaskClass RygelMediaExportHarvestingTaskClass;

#define RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR (rygel_media_export_metadata_extractor_get_type ())
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractor))
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorClass))
#define RYGEL_MEDIA_EXPORT_IS_METADATA_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_IS_METADATA_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorClass))

typedef struct _RygelMediaExportMetadataExtractor RygelMediaExportMetadataExtractor;
typedef struct _RygelMediaExportMetadataExtractorClass RygelMediaExportMetadataExtractorClass;

#define RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR (rygel_media_export_recursive_file_monitor_get_type ())
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitor))
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitorClass))
#define RYGEL_MEDIA_EXPORT_IS_RECURSIVE_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR))
#define RYGEL_MEDIA_EXPORT_IS_RECURSIVE_FILE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR))
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitorClass))

typedef struct _RygelMediaExportRecursiveFileMonitor RygelMediaExportRecursiveFileMonitor;
typedef struct _RygelMediaExportRecursiveFileMonitorClass RygelMediaExportRecursiveFileMonitorClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _RygelMediaExportHarvestingTaskPrivate RygelMediaExportHarvestingTaskPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;
typedef struct _Block16Data Block16Data;

struct _RygelMediaExportHarvester {
	GObject parent_instance;
	RygelMediaExportHarvesterPrivate * priv;
};

struct _RygelMediaExportHarvesterClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportHarvesterPrivate {
	GeeHashMap* tasks;
	GeeHashMap* extraction_grace_timers;
	RygelMediaExportMetadataExtractor* extractor;
	RygelMediaExportRecursiveFileMonitor* monitor;
	GRegex* file_filter;
	GCancellable* cancellable;
};

struct _RygelMediaExportHarvestingTask {
	GObject parent_instance;
	RygelMediaExportHarvestingTaskPrivate * priv;
	GFile* origin;
};

struct _RygelMediaExportHarvestingTaskClass {
	GObjectClass parent_class;
};

typedef enum  {
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_IO_ERROR,
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR
} RygelMediaExportDatabaseError;
#define RYGEL_MEDIA_EXPORT_DATABASE_ERROR rygel_media_export_database_error_quark ()
typedef enum  {
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_SQLITE_ERROR,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_INVALID_TYPE,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_UNSUPPORTED_SEARCH
} RygelMediaExportMediaCacheError;
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR rygel_media_export_media_cache_error_quark ()
struct _Block16Data {
	int _ref_count_;
	RygelMediaExportHarvester * self;
	GFile* file;
};


static gpointer rygel_media_export_harvester_parent_class = NULL;

GType rygel_media_export_harvester_get_type (void) G_GNUC_CONST;
GType rygel_media_export_harvesting_task_get_type (void) G_GNUC_CONST;
GType rygel_media_export_metadata_extractor_get_type (void) G_GNUC_CONST;
GType rygel_media_export_recursive_file_monitor_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_HARVESTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_HARVESTER_DUMMY_PROPERTY
};
#define RYGEL_MEDIA_EXPORT_HARVESTER_FILE_CHANGE_DEFAULT_GRACE_PERIOD ((guint) 5)
RygelMediaExportHarvester* rygel_media_export_harvester_new (GCancellable* cancellable);
RygelMediaExportHarvester* rygel_media_export_harvester_construct (GType object_type, GCancellable* cancellable);
RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_new (void);
RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_construct (GType object_type);
RygelMediaExportRecursiveFileMonitor* rygel_media_export_recursive_file_monitor_new (GCancellable* cancellable);
RygelMediaExportRecursiveFileMonitor* rygel_media_export_recursive_file_monitor_construct (GType object_type, GCancellable* cancellable);
static void rygel_media_export_harvester_on_file_changed (RygelMediaExportHarvester* self, GFile* file, GFile* other, GFileMonitorEvent event);
static void _rygel_media_export_harvester_on_file_changed_rygel_media_export_recursive_file_monitor_changed (RygelMediaExportRecursiveFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
static void rygel_media_export_harvester_create_file_filter (RygelMediaExportHarvester* self);
void rygel_media_export_harvester_schedule (RygelMediaExportHarvester* self, GFile* file, RygelMediaContainer* parent, const gchar* flag);
void rygel_media_export_harvester_cancel (RygelMediaExportHarvester* self, GFile* file);
RygelMediaExportHarvestingTask* rygel_media_export_harvesting_task_new (RygelMediaExportMetadataExtractor* extractor, RygelMediaExportRecursiveFileMonitor* monitor, GRegex* file_filter, GFile* file, RygelMediaContainer* parent, const gchar* flag);
RygelMediaExportHarvestingTask* rygel_media_export_harvesting_task_construct (GType object_type, RygelMediaExportMetadataExtractor* extractor, RygelMediaExportRecursiveFileMonitor* monitor, GRegex* file_filter, GFile* file, RygelMediaContainer* parent, const gchar* flag);
static void rygel_media_export_harvester_on_file_harvested (RygelMediaExportHarvester* self, RygelStateMachine* state_machine);
static void _rygel_media_export_harvester_on_file_harvested_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self);
void rygel_media_export_harvesting_task_cancel (RygelMediaExportHarvestingTask* self);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void rygel_media_export_harvester_on_changes_done (RygelMediaExportHarvester* self, GFile* file, GError** error);
static void rygel_media_export_harvester_on_file_removed (RygelMediaExportHarvester* self, GFile* file, GError** error);
static void rygel_media_export_harvester_on_file_added (RygelMediaExportHarvester* self, GFile* file);
GType rygel_media_export_media_cache_get_type (void) G_GNUC_CONST;
RygelMediaExportMediaCache* rygel_media_export_media_cache_get_default (GError** error);
gchar* rygel_media_export_media_cache_get_id (GFile* file);
GQuark rygel_media_export_database_error_quark (void);
RygelMediaObject* rygel_media_export_media_cache_get_object (RygelMediaExportMediaCache* self, const gchar* object_id, GError** error);
GQuark rygel_media_export_media_cache_error_quark (void);
void rygel_media_export_media_cache_remove_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, GError** error);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (Block16Data* _data16_);
static gboolean _lambda15_ (Block16Data* _data16_);
static gboolean __lambda15__gsource_func (gpointer self);
static void rygel_media_export_harvester_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
     * Create a new instance of the meta-data extraction manager.
     */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _rygel_media_export_harvester_on_file_changed_rygel_media_export_recursive_file_monitor_changed (RygelMediaExportRecursiveFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
	rygel_media_export_harvester_on_file_changed (self, file, other_file, event_type);
}


RygelMediaExportHarvester* rygel_media_export_harvester_construct (GType object_type, GCancellable* cancellable) {
	RygelMediaExportHarvester * self = NULL;
	GCancellable* _tmp0_;
	RygelMediaExportMetadataExtractor* _tmp1_ = NULL;
	RygelMediaExportRecursiveFileMonitor* _tmp2_ = NULL;
	GeeHashMap* _tmp3_ = NULL;
	GeeHashMap* _tmp4_ = NULL;
	g_return_val_if_fail (cancellable != NULL, NULL);
	self = (RygelMediaExportHarvester*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp0_;
	_tmp1_ = rygel_media_export_metadata_extractor_new ();
	_g_object_unref0 (self->priv->extractor);
	self->priv->extractor = _tmp1_;
	_tmp2_ = rygel_media_export_recursive_file_monitor_new (cancellable);
	_g_object_unref0 (self->priv->monitor);
	self->priv->monitor = _tmp2_;
	g_signal_connect_object (self->priv->monitor, "changed", (GCallback) _rygel_media_export_harvester_on_file_changed_rygel_media_export_recursive_file_monitor_changed, self, 0);
	_tmp3_ = gee_hash_map_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_file_hash, g_file_equal, NULL);
	_g_object_unref0 (self->priv->tasks);
	self->priv->tasks = _tmp3_;
	_tmp4_ = gee_hash_map_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, G_TYPE_UINT, NULL, NULL, g_file_hash, g_file_equal, NULL);
	_g_object_unref0 (self->priv->extraction_grace_timers);
	self->priv->extraction_grace_timers = _tmp4_;
	rygel_media_export_harvester_create_file_filter (self);
	return self;
}


RygelMediaExportHarvester* rygel_media_export_harvester_new (GCancellable* cancellable) {
	return rygel_media_export_harvester_construct (RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, cancellable);
}


/**
     * Put a file on queue for meta-data extraction
     *
     * @param file the file to investigate
     * @param parent container of the filer to be harvested
     * @param flag optional flag for the container to set in the database
     */
static void _rygel_media_export_harvester_on_file_harvested_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self) {
	rygel_media_export_harvester_on_file_harvested (self, _sender);
}


void rygel_media_export_harvester_schedule (RygelMediaExportHarvester* self, GFile* file, RygelMediaContainer* parent, const gchar* flag) {
	RygelMediaExportHarvestingTask* _tmp1_ = NULL;
	RygelMediaExportHarvestingTask* task;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (parent != NULL);
	gee_abstract_map_unset ((GeeAbstractMap*) self->priv->extraction_grace_timers, file, NULL);
	if (self->priv->extractor == NULL) {
		const gchar* _tmp0_ = NULL;
		_tmp0_ = _ ("No metadata extractor available. Will not crawl.");
		g_warning ("rygel-media-export-harvester.vala:66: %s", _tmp0_);
		return;
	}
	rygel_media_export_harvester_cancel (self, file);
	_tmp1_ = rygel_media_export_harvesting_task_new (self->priv->extractor, self->priv->monitor, self->priv->file_filter, file, parent, flag);
	task = _tmp1_;
	rygel_state_machine_set_cancellable ((RygelStateMachine*) task, self->priv->cancellable);
	g_signal_connect_object ((RygelStateMachine*) task, "completed", (GCallback) _rygel_media_export_harvester_on_file_harvested_rygel_state_machine_completed, self, 0);
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->tasks, file, task);
	rygel_state_machine_run ((RygelStateMachine*) task, NULL, NULL);
	_g_object_unref0 (task);
}


/**
     * Cancel a running meta-data extraction run
     *
     * @param file file cancel the current run for
     */
void rygel_media_export_harvester_cancel (RygelMediaExportHarvester* self, GFile* file) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->tasks, file);
	if (_tmp0_) {
		gpointer _tmp1_ = NULL;
		RygelMediaExportHarvestingTask* task;
		guint _tmp2_;
		_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->tasks, file);
		task = (RygelMediaExportHarvestingTask*) _tmp1_;
		g_signal_parse_name ("completed", RYGEL_TYPE_STATE_MACHINE, &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((RygelStateMachine*) task, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _rygel_media_export_harvester_on_file_harvested_rygel_state_machine_completed, self);
		gee_abstract_map_unset ((GeeAbstractMap*) self->priv->tasks, file, NULL);
		rygel_media_export_harvesting_task_cancel (task);
		_g_object_unref0 (task);
	}
}


/**
     * Callback for finished harvester.
     *
     * Updates book-keeping hash.
     * @param state_machine HarvestingTask sending the event
     */
static void rygel_media_export_harvester_on_file_harvested (RygelMediaExportHarvester* self, RygelStateMachine* state_machine) {
	RygelStateMachine* _tmp0_;
	RygelMediaExportHarvestingTask* _tmp1_;
	RygelMediaExportHarvestingTask* task;
	GFile* _tmp2_;
	GFile* file;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (state_machine != NULL);
	_tmp0_ = state_machine;
	_tmp1_ = _g_object_ref0 (RYGEL_MEDIA_EXPORT_IS_HARVESTING_TASK (_tmp0_) ? ((RygelMediaExportHarvestingTask*) _tmp0_) : NULL);
	task = _tmp1_;
	_tmp2_ = _g_object_ref0 (task->origin);
	file = _tmp2_;
	_tmp3_ = _ ("'%s' harvested");
	_tmp4_ = g_file_get_uri (file);
	_tmp5_ = _tmp4_;
	g_message (_tmp3_, _tmp5_);
	_g_free0 (_tmp5_);
	gee_abstract_map_unset ((GeeAbstractMap*) self->priv->tasks, file, NULL);
	_tmp6_ = gee_abstract_map_get_is_empty ((GeeAbstractMap*) self->priv->tasks);
	if (_tmp6_) {
		g_signal_emit_by_name (self, "done");
	}
	_g_object_unref0 (file);
	_g_object_unref0 (task);
}


/**
     * Construct positive filter from config
     *
     * Takes a list of file extensions from config, escapes them and builds a
     * regular expression to match against the files encountered.
     */
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void rygel_media_export_harvester_create_file_filter (RygelMediaExportHarvester* self) {
	RygelMetaConfig* _tmp0_ = NULL;
	RygelMetaConfig* config;
	GeeArrayList* _tmp1_ = NULL;
	GeeArrayList* extensions;
	gchar** _tmp2_ = NULL;
	gchar** escaped_extensions;
	gint escaped_extensions_length1;
	gint _escaped_extensions_size_;
	gchar* _tmp7_ = NULL;
	gchar* list;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	GRegex* _tmp10_ = NULL;
	GRegex* _tmp11_;
	GRegex* _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = rygel_meta_config_get_default ();
	config = _tmp0_;
	_tmp1_ = rygel_configuration_get_string_list ((RygelConfiguration*) config, "MediaExport", "include-filter", &_inner_error_);
	extensions = _tmp1_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (config);
		goto __catch42_g_error;
	}
	_tmp2_ = g_new0 (gchar*, 0 + 1);
	escaped_extensions = _tmp2_;
	escaped_extensions_length1 = 0;
	_escaped_extensions_size_ = 0;
	{
		GeeArrayList* _tmp3_;
		GeeArrayList* _extension_list;
		gint _tmp4_;
		gint _extension_size;
		gint _extension_index;
		_tmp3_ = _g_object_ref0 (extensions);
		_extension_list = _tmp3_;
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _extension_list);
		_extension_size = _tmp4_;
		_extension_index = -1;
		while (TRUE) {
			gpointer _tmp5_ = NULL;
			gchar* extension;
			gchar* _tmp6_ = NULL;
			_extension_index = _extension_index + 1;
			if (!(_extension_index < _extension_size)) {
				break;
			}
			_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _extension_list, _extension_index);
			extension = (gchar*) _tmp5_;
			_tmp6_ = g_regex_escape_string (extension, -1);
			_vala_array_add1 (&escaped_extensions, &escaped_extensions_length1, &_escaped_extensions_size_, _tmp6_);
			_g_free0 (extension);
		}
		_g_object_unref0 (_extension_list);
	}
	_tmp7_ = g_strjoinv ("|", escaped_extensions);
	list = _tmp7_;
	_tmp8_ = g_strdup_printf ("(%s)$", list);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_regex_new (_tmp9_, G_REGEX_CASELESS | G_REGEX_OPTIMIZE, 0, &_inner_error_);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp9_);
	_tmp12_ = _tmp11_;
	if (_inner_error_ != NULL) {
		_g_free0 (list);
		escaped_extensions = (_vala_array_free (escaped_extensions, escaped_extensions_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (extensions);
		_g_object_unref0 (config);
		goto __catch42_g_error;
	}
	_g_regex_unref0 (self->priv->file_filter);
	self->priv->file_filter = _tmp12_;
	_g_free0 (list);
	escaped_extensions = (_vala_array_free (escaped_extensions, escaped_extensions_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (extensions);
	_g_object_unref0 (config);
	goto __finally42;
	__catch42_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_regex_unref0 (self->priv->file_filter);
		self->priv->file_filter = NULL;
		_g_error_free0 (_error_);
	}
	__finally42:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_media_export_harvester_on_file_changed (RygelMediaExportHarvester* self, GFile* file, GFile* other, GFileMonitorEvent event) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	switch (event) {
		case G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT:
		{
			rygel_media_export_harvester_on_changes_done (self, file, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch43_g_error;
			}
			break;
		}
		case G_FILE_MONITOR_EVENT_DELETED:
		{
			rygel_media_export_harvester_on_file_removed (self, file, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch43_g_error;
			}
			break;
		}
		default:
		{
			break;
		}
	}
	goto __finally43;
	__catch43_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally43:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_media_export_harvester_on_file_added (RygelMediaExportHarvester* self, GFile* file) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	RygelMediaExportMediaCache* _tmp2_ = NULL;
	RygelMediaExportMediaCache* cache;
	GFileType _tmp3_;
	GFileType type;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = g_file_get_uri (file);
	_tmp1_ = _tmp0_;
	g_debug ("rygel-media-export-harvester.vala:163: Filesystem events settled for %" \
"s, scheduling extraction…", _tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = rygel_media_export_media_cache_get_default (&_inner_error_);
	cache = _tmp2_;
	if (_inner_error_ != NULL) {
		goto __catch44_g_error;
	}
	_tmp3_ = g_file_query_file_type (file, G_FILE_QUERY_INFO_NONE, self->priv->cancellable);
	type = _tmp3_;
	if (type == G_FILE_TYPE_DIRECTORY) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = self->priv->file_filter == NULL;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		gboolean _tmp8_;
		_tmp6_ = g_file_get_uri (file);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_regex_match (self->priv->file_filter, _tmp7_, 0, NULL);
		_tmp4_ = _tmp8_;
		_g_free0 (_tmp7_);
	}
	if (_tmp4_) {
		gchar* id = NULL;
		RygelMediaContainer* parent_container;
		GFile* _tmp9_;
		GFile* current;
		parent_container = NULL;
		_tmp9_ = _g_object_ref0 (file);
		current = _tmp9_;
		{
			gboolean _tmp10_;
			_tmp10_ = TRUE;
			while (TRUE) {
				GFile* _tmp11_ = NULL;
				GFile* parent;
				gchar* _tmp12_ = NULL;
				RygelMediaObject* _tmp13_ = NULL;
				RygelMediaObject* _tmp14_;
				RygelMediaObject* _tmp15_;
				if (!_tmp10_) {
					if (!(parent_container == NULL)) {
						break;
					}
				}
				_tmp10_ = FALSE;
				_tmp11_ = g_file_get_parent (current);
				parent = _tmp11_;
				_tmp12_ = rygel_media_export_media_cache_get_id (parent);
				_g_free0 (id);
				id = _tmp12_;
				_tmp13_ = rygel_media_export_media_cache_get_object (cache, id, &_inner_error_);
				_tmp14_ = _tmp13_;
				if (_inner_error_ != NULL) {
					_g_object_unref0 (parent);
					_g_object_unref0 (current);
					_g_object_unref0 (parent_container);
					if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
						goto __catch45_rygel_media_export_database_error;
					}
					_g_object_unref0 (parent);
					_g_object_unref0 (current);
					_g_object_unref0 (parent_container);
					_g_free0 (id);
					_g_object_unref0 (cache);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp15_ = _tmp14_;
				_g_object_unref0 (parent_container);
				parent_container = RYGEL_IS_MEDIA_CONTAINER (_tmp15_) ? ((RygelMediaContainer*) _tmp15_) : NULL;
				if (parent_container == NULL) {
					GFile* _tmp16_;
					_tmp16_ = _g_object_ref0 (parent);
					_g_object_unref0 (current);
					current = _tmp16_;
				}
				_g_object_unref0 (parent);
			}
		}
		rygel_media_export_harvester_schedule (self, current, parent_container, NULL);
		_g_object_unref0 (current);
		_g_object_unref0 (parent_container);
		goto __finally45;
		__catch45_rygel_media_export_database_error:
		{
			GError * _error_;
			const gchar* _tmp17_ = NULL;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			_tmp17_ = _ ("Error fetching object '%s' from database: %s");
			g_warning (_tmp17_, id, _error_->message);
			_g_error_free0 (_error_);
		}
		__finally45:
		if (_inner_error_ != NULL) {
			_g_free0 (id);
			_g_object_unref0 (cache);
			goto __catch44_g_error;
		}
		_g_free0 (id);
	}
	_g_object_unref0 (cache);
	goto __finally44;
	__catch44_g_error:
	{
		GError * _error_;
		const gchar* _tmp18_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp18_ = _ ("Failed to access media cache: %s");
		g_warning (_tmp18_, _error_->message);
		_g_error_free0 (_error_);
	}
	__finally44:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_media_export_harvester_on_file_removed (RygelMediaExportHarvester* self, GFile* file, GError** error) {
	RygelMediaExportMediaCache* _tmp0_ = NULL;
	RygelMediaExportMediaCache* cache;
	gboolean _tmp1_;
	gchar* _tmp3_ = NULL;
	gchar* id;
	RygelMediaObject* _tmp4_ = NULL;
	RygelMediaObject* object;
	gpointer _tmp5_;
	RygelMediaContainer* _tmp6_;
	RygelMediaContainer* parent;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = rygel_media_export_media_cache_get_default (&_inner_error_);
	cache = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp1_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->extraction_grace_timers, file);
	if (_tmp1_) {
		gpointer _tmp2_ = NULL;
		_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->extraction_grace_timers, file);
		g_source_remove (GPOINTER_TO_UINT (_tmp2_));
		gee_abstract_map_unset ((GeeAbstractMap*) self->priv->extraction_grace_timers, file, NULL);
	}
	rygel_media_export_harvester_cancel (self, file);
	_tmp3_ = rygel_media_export_media_cache_get_id (file);
	id = _tmp3_;
	_tmp4_ = rygel_media_export_media_cache_get_object (cache, id, &_inner_error_);
	object = _tmp4_;
	if (_inner_error_ != NULL) {
		_g_free0 (id);
		goto __catch46_g_error;
	}
	_tmp5_ = NULL;
	_tmp6_ = _g_object_ref0 (RYGEL_IS_MEDIA_CONTAINER (_tmp5_) ? ((RygelMediaContainer*) _tmp5_) : NULL);
	parent = _tmp6_;
	while (TRUE) {
		RygelMediaContainer* _tmp7_;
		RygelMediaObject* _tmp8_;
		if (!(object != NULL)) {
			break;
		}
		_tmp7_ = _g_object_ref0 (object->parent);
		_g_object_unref0 (parent);
		parent = _tmp7_;
		rygel_media_export_media_cache_remove_object (cache, object, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (parent);
			_g_object_unref0 (object);
			_g_free0 (id);
			goto __catch46_g_error;
		}
		if (parent == NULL) {
			break;
		}
		parent->child_count--;
		if (parent->child_count != 0) {
			break;
		}
		_tmp8_ = _g_object_ref0 ((RygelMediaObject*) parent);
		_g_object_unref0 (object);
		object = _tmp8_;
	}
	if (parent != NULL) {
		rygel_media_container_updated (parent);
	}
	_g_object_unref0 (parent);
	_g_object_unref0 (object);
	_g_free0 (id);
	goto __finally46;
	__catch46_g_error:
	{
		GError * _error_;
		const gchar* _tmp9_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = _ ("Error removing object from database: %s");
		g_warning (_tmp9_, _error_->message);
		_g_error_free0 (_error_);
	}
	__finally46:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (cache);
		return;
	}
	_g_object_unref0 (cache);
}


static Block16Data* block16_data_ref (Block16Data* _data16_) {
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}


static void block16_data_unref (Block16Data* _data16_) {
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		_g_object_unref0 (_data16_->self);
		_g_object_unref0 (_data16_->file);
		g_slice_free (Block16Data, _data16_);
	}
}


static gboolean _lambda15_ (Block16Data* _data16_) {
	RygelMediaExportHarvester * self;
	gboolean result = FALSE;
	self = _data16_->self;
	rygel_media_export_harvester_on_file_added (self, _data16_->file);
	result = FALSE;
	return result;
}


static gboolean __lambda15__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda15_ (self);
	return result;
}


static void rygel_media_export_harvester_on_changes_done (RygelMediaExportHarvester* self, GFile* file, GError** error) {
	Block16Data* _data16_;
	gboolean _tmp0_;
	GSourceFunc callback;
	void* callback_target = NULL;
	GDestroyNotify callback_target_destroy_notify = NULL;
	GSourceFunc _tmp4_;
	guint _tmp5_;
	guint timeout;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_data16_ = g_slice_new0 (Block16Data);
	_data16_->_ref_count_ = 1;
	_data16_->self = g_object_ref (self);
	_data16_->file = _g_object_ref0 (file);
	_tmp0_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->extraction_grace_timers, _data16_->file);
	if (_tmp0_) {
		gpointer _tmp1_ = NULL;
		_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->extraction_grace_timers, _data16_->file);
		g_source_remove (GPOINTER_TO_UINT (_tmp1_));
	} else {
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		_tmp2_ = g_file_get_uri (_data16_->file);
		_tmp3_ = _tmp2_;
		g_debug ("rygel-media-export-harvester.vala:242: Starting grace timer for harves" \
"ting %s…", _tmp3_);
		_g_free0 (_tmp3_);
	}
	callback = __lambda15__gsource_func;
	callback_target = block16_data_ref (_data16_);
	callback_target_destroy_notify = block16_data_unref;
	_tmp4_ = callback;
	_tmp5_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, RYGEL_MEDIA_EXPORT_HARVESTER_FILE_CHANGE_DEFAULT_GRACE_PERIOD, _tmp4_, callback_target, NULL);
	timeout = _tmp5_;
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->extraction_grace_timers, _data16_->file, GUINT_TO_POINTER (timeout));
	(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
	callback = NULL;
	callback_target = NULL;
	callback_target_destroy_notify = NULL;
	block16_data_unref (_data16_);
	_data16_ = NULL;
}


static void rygel_media_export_harvester_class_init (RygelMediaExportHarvesterClass * klass) {
	rygel_media_export_harvester_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaExportHarvesterPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_harvester_finalize;
	g_signal_new ("done", RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void rygel_media_export_harvester_instance_init (RygelMediaExportHarvester * self) {
	self->priv = RYGEL_MEDIA_EXPORT_HARVESTER_GET_PRIVATE (self);
}


static void rygel_media_export_harvester_finalize (GObject* obj) {
	RygelMediaExportHarvester * self;
	self = RYGEL_MEDIA_EXPORT_HARVESTER (obj);
	_g_object_unref0 (self->priv->tasks);
	_g_object_unref0 (self->priv->extraction_grace_timers);
	_g_object_unref0 (self->priv->extractor);
	_g_object_unref0 (self->priv->monitor);
	_g_regex_unref0 (self->priv->file_filter);
	_g_object_unref0 (self->priv->cancellable);
	G_OBJECT_CLASS (rygel_media_export_harvester_parent_class)->finalize (obj);
}


/**
 * This class takes care of the book-keeping of running and finished
 * extraction tasks running within the media-export plugin
 */
GType rygel_media_export_harvester_get_type (void) {
	static volatile gsize rygel_media_export_harvester_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_harvester_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportHarvesterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_harvester_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportHarvester), 0, (GInstanceInitFunc) rygel_media_export_harvester_instance_init, NULL };
		GType rygel_media_export_harvester_type_id;
		rygel_media_export_harvester_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportHarvester", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_harvester_type_id__volatile, rygel_media_export_harvester_type_id);
	}
	return rygel_media_export_harvester_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



