/* rygel-video-item.c generated by valac 0.12.0, the Vala compiler
 * generated from rygel-video-item.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp-av/gupnp-av.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gst/gst.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;

#define RYGEL_TYPE_VISUAL_ITEM (rygel_visual_item_get_type ())
#define RYGEL_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItem))
#define RYGEL_IS_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_VISUAL_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemIface))

typedef struct _RygelVisualItem RygelVisualItem;
typedef struct _RygelVisualItemIface RygelVisualItemIface;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;
typedef struct _RygelVideoItemPrivate RygelVideoItemPrivate;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_SUBTITLE_MANAGER (rygel_subtitle_manager_get_type ())
#define RYGEL_SUBTITLE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManager))
#define RYGEL_SUBTITLE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManagerClass))
#define RYGEL_IS_SUBTITLE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE_MANAGER))
#define RYGEL_IS_SUBTITLE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE_MANAGER))
#define RYGEL_SUBTITLE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManagerClass))

typedef struct _RygelSubtitleManager RygelSubtitleManager;
typedef struct _RygelSubtitleManagerClass RygelSubtitleManagerClass;
#define _rygel_subtitle_unref0(var) ((var == NULL) ? NULL : (var = (rygel_subtitle_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelSubtitlePrivate RygelSubtitlePrivate;

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	gchar* date;
	gchar* mime_type;
	gchar* dlna_profile;
	GRegex* address_regex;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_uri) (RygelMediaItem* self, const gchar* uri);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
	glong duration;
	gint bitrate;
	gint sample_freq;
	gint bits_per_sample;
	gint channels;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelVisualItemIface {
	GTypeInterface parent_iface;
	gint (*get_width) (RygelVisualItem* self);
	void (*set_width) (RygelVisualItem* self, gint value);
	gint (*get_height) (RygelVisualItem* self);
	void (*set_height) (RygelVisualItem* self, gint value);
	gint (*get_pixel_width) (RygelVisualItem* self);
	void (*set_pixel_width) (RygelVisualItem* self, gint value);
	gint (*get_pixel_height) (RygelVisualItem* self);
	void (*set_pixel_height) (RygelVisualItem* self, gint value);
	gint (*get_color_depth) (RygelVisualItem* self);
	void (*set_color_depth) (RygelVisualItem* self, gint value);
	GeeArrayList* (*get_thumbnails) (RygelVisualItem* self);
	void (*set_thumbnails) (RygelVisualItem* self, GeeArrayList* value);
};

struct _RygelVideoItem {
	RygelAudioItem parent_instance;
	RygelVideoItemPrivate * priv;
	gchar* author;
	GeeArrayList* subtitles;
};

struct _RygelVideoItemClass {
	RygelAudioItemClass parent_class;
};

struct _RygelVideoItemPrivate {
	gint _width;
	gint _height;
	gint _pixel_width;
	gint _pixel_height;
	gint _color_depth;
	GeeArrayList* _thumbnails;
};

struct _RygelSubtitle {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSubtitlePrivate * priv;
	gchar* uri;
	gchar* mime_type;
	gchar* caption_type;
	gint64 size;
};

struct _RygelSubtitleClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSubtitle *self);
};


static gpointer rygel_video_item_parent_class = NULL;
static RygelVisualItemIface* rygel_video_item_rygel_visual_item_parent_iface = NULL;

GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
GType rygel_visual_item_get_type (void) G_GNUC_CONST;
GType rygel_video_item_get_type (void) G_GNUC_CONST;
gpointer rygel_subtitle_ref (gpointer instance);
void rygel_subtitle_unref (gpointer instance);
GParamSpec* rygel_param_spec_subtitle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_subtitle (GValue* value, gpointer v_object);
void rygel_value_take_subtitle (GValue* value, gpointer v_object);
gpointer rygel_value_get_subtitle (const GValue* value);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
#define RYGEL_VIDEO_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemPrivate))
enum  {
	RYGEL_VIDEO_ITEM_DUMMY_PROPERTY,
	RYGEL_VIDEO_ITEM_WIDTH,
	RYGEL_VIDEO_ITEM_HEIGHT,
	RYGEL_VIDEO_ITEM_PIXEL_WIDTH,
	RYGEL_VIDEO_ITEM_PIXEL_HEIGHT,
	RYGEL_VIDEO_ITEM_COLOR_DEPTH,
	RYGEL_VIDEO_ITEM_THUMBNAILS
};
#define RYGEL_VIDEO_ITEM_UPNP_CLASS "object.item.videoItem"
RygelVideoItem* rygel_video_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelVideoItem* rygel_video_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelAudioItem* rygel_audio_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelAudioItem* rygel_audio_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
void rygel_visual_item_set_thumbnails (RygelVisualItem* self, GeeArrayList* value);
static gboolean rygel_video_item_real_streamable (RygelMediaItem* base);
static void rygel_video_item_real_add_uri (RygelMediaItem* base, const gchar* uri);
void rygel_media_item_add_uri (RygelMediaItem* self, const gchar* uri);
void rygel_visual_item_add_thumbnail_for_uri (RygelVisualItem* self, const gchar* uri);
GType rygel_subtitle_manager_get_type (void) G_GNUC_CONST;
RygelSubtitleManager* rygel_subtitle_manager_get_default (void);
RygelSubtitle* rygel_subtitle_manager_get_subtitle (RygelSubtitleManager* self, const gchar* uri, GError** error);
static void rygel_video_item_real_add_resources (RygelMediaItem* base, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
gchar* rygel_media_item_get_protocol_for_uri (RygelMediaItem* self, const gchar* uri, GError** error);
void rygel_subtitle_add_didl_node (RygelSubtitle* self, GUPnPDIDLLiteItem* didl_item);
void rygel_media_item_add_resources (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
void rygel_visual_item_add_thumbnail_resources (RygelVisualItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
static GUPnPDIDLLiteResource* rygel_video_item_real_add_resource (RygelMediaItem* base, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
GUPnPDIDLLiteResource* rygel_media_item_add_resource (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
void rygel_visual_item_add_visual_props (RygelVisualItem* self, GUPnPDIDLLiteResource* res);
static gint rygel_video_item_real_compare_by_property (RygelMediaObject* base, RygelMediaObject* media_object, const gchar* property);
gint rygel_media_object_compare_string_props (RygelMediaObject* self, const gchar* prop1, const gchar* prop2);
gint rygel_media_object_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
static GUPnPDIDLLiteObject* rygel_video_item_real_serialize (RygelMediaObject* base, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
GUPnPDIDLLiteObject* rygel_media_object_serialize (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
static void rygel_video_item_real_add_proxy_resources (RygelMediaItem* base, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
gboolean rygel_media_item_get_place_holder (RygelMediaItem* self);
gboolean rygel_http_server_need_proxy (RygelHTTPServer* self, const gchar* uri);
gchar* rygel_transcode_manager_create_uri_for_item (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
void rygel_media_item_add_proxy_resources (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
void rygel_visual_item_add_thumbnail_proxy_resources (RygelVisualItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
static void rygel_video_item_finalize (GObject* obj);
gint rygel_visual_item_get_width (RygelVisualItem* self);
gint rygel_visual_item_get_height (RygelVisualItem* self);
gint rygel_visual_item_get_pixel_width (RygelVisualItem* self);
gint rygel_visual_item_get_pixel_height (RygelVisualItem* self);
gint rygel_visual_item_get_color_depth (RygelVisualItem* self);
GeeArrayList* rygel_visual_item_get_thumbnails (RygelVisualItem* self);
static void _vala_rygel_video_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void rygel_visual_item_set_width (RygelVisualItem* self, gint value);
void rygel_visual_item_set_height (RygelVisualItem* self, gint value);
void rygel_visual_item_set_pixel_width (RygelVisualItem* self, gint value);
void rygel_visual_item_set_pixel_height (RygelVisualItem* self, gint value);
void rygel_visual_item_set_color_depth (RygelVisualItem* self, gint value);
static void _vala_rygel_video_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


RygelVideoItem* rygel_video_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class) {
	RygelVideoItem * self = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_ = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (upnp_class != NULL, NULL);
	self = (RygelVideoItem*) rygel_audio_item_construct (object_type, id, parent, title, upnp_class);
	_tmp0_ = gee_array_list_new (RYGEL_TYPE_THUMBNAIL, (GBoxedCopyFunc) rygel_icon_info_ref, rygel_icon_info_unref, NULL);
	_tmp1_ = _tmp0_;
	rygel_visual_item_set_thumbnails ((RygelVisualItem*) self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = gee_array_list_new (RYGEL_TYPE_SUBTITLE, (GBoxedCopyFunc) rygel_subtitle_ref, rygel_subtitle_unref, NULL);
	_g_object_unref0 (self->subtitles);
	self->subtitles = _tmp2_;
	return self;
}


RygelVideoItem* rygel_video_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class) {
	return rygel_video_item_construct (RYGEL_TYPE_VIDEO_ITEM, id, parent, title, upnp_class);
}


static gboolean rygel_video_item_real_streamable (RygelMediaItem* base) {
	RygelVideoItem * self;
	gboolean result = FALSE;
	self = (RygelVideoItem*) base;
	result = TRUE;
	return result;
}


static void rygel_video_item_real_add_uri (RygelMediaItem* base, const gchar* uri) {
	RygelVideoItem * self;
	RygelSubtitleManager* _tmp0_ = NULL;
	RygelSubtitleManager* subtitle_manager;
	GError * _inner_error_ = NULL;
	self = (RygelVideoItem*) base;
	g_return_if_fail (uri != NULL);
	RYGEL_MEDIA_ITEM_CLASS (rygel_video_item_parent_class)->add_uri ((RygelMediaItem*) RYGEL_AUDIO_ITEM (self), uri);
	rygel_visual_item_add_thumbnail_for_uri ((RygelVisualItem*) self, uri);
	_tmp0_ = rygel_subtitle_manager_get_default ();
	subtitle_manager = _tmp0_;
	if (subtitle_manager != NULL) {
		RygelSubtitle* _tmp1_ = NULL;
		RygelSubtitle* subtitle;
		_tmp1_ = rygel_subtitle_manager_get_subtitle (subtitle_manager, uri, &_inner_error_);
		subtitle = _tmp1_;
		if (_inner_error_ != NULL) {
			goto __catch50_g_error;
		}
		gee_abstract_collection_add ((GeeAbstractCollection*) self->subtitles, subtitle);
		_rygel_subtitle_unref0 (subtitle);
		goto __finally50;
		__catch50_g_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (err);
		}
		__finally50:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (subtitle_manager);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (subtitle_manager);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_video_item_real_add_resources (RygelMediaItem* base, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error) {
	RygelVideoItem * self;
	GError * _inner_error_ = NULL;
	self = (RygelVideoItem*) base;
	g_return_if_fail (didl_item != NULL);
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _subtitle_list;
		gint _tmp1_;
		gint _subtitle_size;
		gint _subtitle_index;
		_tmp0_ = _g_object_ref0 (self->subtitles);
		_subtitle_list = _tmp0_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _subtitle_list);
		_subtitle_size = _tmp1_;
		_subtitle_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			RygelSubtitle* subtitle;
			gchar* _tmp3_ = NULL;
			gchar* protocol;
			gboolean _tmp4_ = FALSE;
			_subtitle_index = _subtitle_index + 1;
			if (!(_subtitle_index < _subtitle_size)) {
				break;
			}
			_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _subtitle_list, _subtitle_index);
			subtitle = (RygelSubtitle*) _tmp2_;
			_tmp3_ = rygel_media_item_get_protocol_for_uri ((RygelMediaItem*) self, subtitle->uri, &_inner_error_);
			protocol = _tmp3_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_rygel_subtitle_unref0 (subtitle);
				_g_object_unref0 (_subtitle_list);
				return;
			}
			if (allow_internal) {
				_tmp4_ = TRUE;
			} else {
				_tmp4_ = g_strcmp0 (protocol, "internal") != 0;
			}
			if (_tmp4_) {
				rygel_subtitle_add_didl_node (subtitle, didl_item);
			}
			_g_free0 (protocol);
			_rygel_subtitle_unref0 (subtitle);
		}
		_g_object_unref0 (_subtitle_list);
	}
	RYGEL_MEDIA_ITEM_CLASS (rygel_video_item_parent_class)->add_resources ((RygelMediaItem*) RYGEL_AUDIO_ITEM (self), didl_item, allow_internal, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	rygel_visual_item_add_thumbnail_resources ((RygelVisualItem*) self, didl_item, allow_internal, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static GUPnPDIDLLiteResource* rygel_video_item_real_add_resource (RygelMediaItem* base, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error) {
	RygelVideoItem * self;
	GUPnPDIDLLiteResource* result = NULL;
	GUPnPDIDLLiteResource* _tmp0_ = NULL;
	GUPnPDIDLLiteResource* res;
	GError * _inner_error_ = NULL;
	self = (RygelVideoItem*) base;
	g_return_val_if_fail (didl_item != NULL, NULL);
	g_return_val_if_fail (protocol != NULL, NULL);
	_tmp0_ = RYGEL_MEDIA_ITEM_CLASS (rygel_video_item_parent_class)->add_resource ((RygelMediaItem*) RYGEL_AUDIO_ITEM (self), didl_item, uri, protocol, import_uri, &_inner_error_);
	res = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	rygel_visual_item_add_visual_props ((RygelVisualItem*) self, res);
	result = res;
	return result;
}


static gint rygel_video_item_real_compare_by_property (RygelMediaObject* base, RygelMediaObject* media_object, const gchar* property) {
	RygelVideoItem * self;
	gint result = 0;
	RygelMediaObject* _tmp0_;
	RygelVideoItem* _tmp1_;
	RygelVideoItem* item;
	const gchar* _tmp2_;
	GQuark _tmp3_;
	static GQuark _tmp3__label0 = 0;
	self = (RygelVideoItem*) base;
	g_return_val_if_fail (media_object != NULL, 0);
	g_return_val_if_fail (property != NULL, 0);
	if (!RYGEL_IS_VIDEO_ITEM (media_object)) {
		result = 1;
		return result;
	}
	_tmp0_ = media_object;
	_tmp1_ = _g_object_ref0 (RYGEL_IS_VIDEO_ITEM (_tmp0_) ? ((RygelVideoItem*) _tmp0_) : NULL);
	item = _tmp1_;
	_tmp2_ = property;
	_tmp3_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if (_tmp3_ == ((0 != _tmp3__label0) ? _tmp3__label0 : (_tmp3__label0 = g_quark_from_static_string ("dc:author")))) {
		switch (0) {
			default:
			{
				gint _tmp4_;
				_tmp4_ = rygel_media_object_compare_string_props ((RygelMediaObject*) self, self->author, item->author);
				result = _tmp4_;
				_g_object_unref0 (item);
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gint _tmp5_;
				_tmp5_ = RYGEL_MEDIA_OBJECT_CLASS (rygel_video_item_parent_class)->compare_by_property ((RygelMediaObject*) RYGEL_AUDIO_ITEM (self), (RygelMediaObject*) item, property);
				result = _tmp5_;
				_g_object_unref0 (item);
				return result;
			}
		}
	}
	_g_object_unref0 (item);
}


static GUPnPDIDLLiteObject* rygel_video_item_real_serialize (RygelMediaObject* base, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error) {
	RygelVideoItem * self;
	GUPnPDIDLLiteObject* result = NULL;
	GUPnPDIDLLiteObject* _tmp0_ = NULL;
	GUPnPDIDLLiteObject* didl_item;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (RygelVideoItem*) base;
	g_return_val_if_fail (writer != NULL, NULL);
	g_return_val_if_fail (http_server != NULL, NULL);
	_tmp0_ = RYGEL_MEDIA_OBJECT_CLASS (rygel_video_item_parent_class)->serialize ((RygelMediaObject*) RYGEL_AUDIO_ITEM (self), writer, http_server, &_inner_error_);
	didl_item = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	if (self->author != NULL) {
		_tmp1_ = g_strcmp0 (self->author, "") != 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GUPnPDIDLLiteContributor* _tmp2_ = NULL;
		GUPnPDIDLLiteContributor* contributor;
		_tmp2_ = gupnp_didl_lite_object_add_author (didl_item);
		contributor = _tmp2_;
		gupnp_didl_lite_contributor_set_name (contributor, self->author);
		_g_object_unref0 (contributor);
	}
	result = didl_item;
	return result;
}


static void rygel_video_item_real_add_proxy_resources (RygelMediaItem* base, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error) {
	RygelVideoItem * self;
	gboolean _tmp0_;
	gboolean _tmp9_;
	GError * _inner_error_ = NULL;
	self = (RygelVideoItem*) base;
	g_return_if_fail (server != NULL);
	g_return_if_fail (didl_item != NULL);
	_tmp0_ = rygel_media_item_get_place_holder ((RygelMediaItem*) self);
	if (!_tmp0_) {
		{
			GeeArrayList* _tmp1_;
			GeeArrayList* _subtitle_list;
			gint _tmp2_;
			gint _subtitle_size;
			gint _subtitle_index;
			_tmp1_ = _g_object_ref0 (self->subtitles);
			_subtitle_list = _tmp1_;
			_tmp2_ = gee_collection_get_size ((GeeCollection*) _subtitle_list);
			_subtitle_size = _tmp2_;
			_subtitle_index = -1;
			while (TRUE) {
				gpointer _tmp3_ = NULL;
				RygelSubtitle* subtitle;
				gboolean _tmp4_;
				gchar* _tmp5_;
				gchar* uri;
				gint _tmp6_;
				gint index;
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_;
				_subtitle_index = _subtitle_index + 1;
				if (!(_subtitle_index < _subtitle_size)) {
					break;
				}
				_tmp3_ = gee_abstract_list_get ((GeeAbstractList*) _subtitle_list, _subtitle_index);
				subtitle = (RygelSubtitle*) _tmp3_;
				_tmp4_ = rygel_http_server_need_proxy (server, subtitle->uri);
				if (!_tmp4_) {
					_rygel_subtitle_unref0 (subtitle);
					continue;
				}
				_tmp5_ = g_strdup (subtitle->uri);
				uri = _tmp5_;
				_tmp6_ = gee_abstract_list_index_of ((GeeAbstractList*) self->subtitles, subtitle);
				index = _tmp6_;
				_tmp7_ = rygel_transcode_manager_create_uri_for_item ((RygelTranscodeManager*) server, (RygelMediaItem*) self, -1, index, NULL);
				_g_free0 (subtitle->uri);
				subtitle->uri = _tmp7_;
				rygel_subtitle_add_didl_node (subtitle, didl_item);
				_tmp8_ = g_strdup (uri);
				_g_free0 (subtitle->uri);
				subtitle->uri = _tmp8_;
				_g_free0 (uri);
				_rygel_subtitle_unref0 (subtitle);
			}
			_g_object_unref0 (_subtitle_list);
		}
	}
	RYGEL_MEDIA_ITEM_CLASS (rygel_video_item_parent_class)->add_proxy_resources ((RygelMediaItem*) RYGEL_AUDIO_ITEM (self), server, didl_item, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp9_ = rygel_media_item_get_place_holder ((RygelMediaItem*) self);
	if (!_tmp9_) {
		rygel_visual_item_add_thumbnail_proxy_resources ((RygelVisualItem*) self, server, didl_item, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
}


static gint rygel_video_item_real_get_width (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	self = (RygelVideoItem*) base;
	result = self->priv->_width;
	return result;
}


static void rygel_video_item_real_set_width (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	self = (RygelVideoItem*) base;
	self->priv->_width = value;
	g_object_notify ((GObject *) self, "width");
}


static gint rygel_video_item_real_get_height (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	self = (RygelVideoItem*) base;
	result = self->priv->_height;
	return result;
}


static void rygel_video_item_real_set_height (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	self = (RygelVideoItem*) base;
	self->priv->_height = value;
	g_object_notify ((GObject *) self, "height");
}


static gint rygel_video_item_real_get_pixel_width (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	self = (RygelVideoItem*) base;
	result = self->priv->_pixel_width;
	return result;
}


static void rygel_video_item_real_set_pixel_width (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	self = (RygelVideoItem*) base;
	self->priv->_pixel_width = value;
	g_object_notify ((GObject *) self, "pixel-width");
}


static gint rygel_video_item_real_get_pixel_height (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	self = (RygelVideoItem*) base;
	result = self->priv->_pixel_height;
	return result;
}


static void rygel_video_item_real_set_pixel_height (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	self = (RygelVideoItem*) base;
	self->priv->_pixel_height = value;
	g_object_notify ((GObject *) self, "pixel-height");
}


static gint rygel_video_item_real_get_color_depth (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	self = (RygelVideoItem*) base;
	result = self->priv->_color_depth;
	return result;
}


static void rygel_video_item_real_set_color_depth (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	self = (RygelVideoItem*) base;
	self->priv->_color_depth = value;
	g_object_notify ((GObject *) self, "color-depth");
}


static GeeArrayList* rygel_video_item_real_get_thumbnails (RygelVisualItem* base) {
	GeeArrayList* result;
	RygelVideoItem* self;
	self = (RygelVideoItem*) base;
	result = self->priv->_thumbnails;
	return result;
}


static void rygel_video_item_real_set_thumbnails (RygelVisualItem* base, GeeArrayList* value) {
	RygelVideoItem* self;
	GeeArrayList* _tmp0_;
	self = (RygelVideoItem*) base;
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_thumbnails);
	self->priv->_thumbnails = _tmp0_;
	g_object_notify ((GObject *) self, "thumbnails");
}


static void rygel_video_item_class_init (RygelVideoItemClass * klass) {
	rygel_video_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelVideoItemPrivate));
	RYGEL_MEDIA_ITEM_CLASS (klass)->streamable = rygel_video_item_real_streamable;
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_uri = rygel_video_item_real_add_uri;
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_resources = rygel_video_item_real_add_resources;
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_resource = rygel_video_item_real_add_resource;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->compare_by_property = rygel_video_item_real_compare_by_property;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->serialize = rygel_video_item_real_serialize;
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_proxy_resources = rygel_video_item_real_add_proxy_resources;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_video_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_video_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_video_item_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_VIDEO_ITEM_WIDTH, "width");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_VIDEO_ITEM_HEIGHT, "height");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_VIDEO_ITEM_PIXEL_WIDTH, "pixel-width");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_VIDEO_ITEM_PIXEL_HEIGHT, "pixel-height");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_VIDEO_ITEM_COLOR_DEPTH, "color-depth");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_VIDEO_ITEM_THUMBNAILS, "thumbnails");
}


static void rygel_video_item_rygel_visual_item_interface_init (RygelVisualItemIface * iface) {
	rygel_video_item_rygel_visual_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_width = rygel_video_item_real_get_width;
	iface->set_width = rygel_video_item_real_set_width;
	iface->get_height = rygel_video_item_real_get_height;
	iface->set_height = rygel_video_item_real_set_height;
	iface->get_pixel_width = rygel_video_item_real_get_pixel_width;
	iface->set_pixel_width = rygel_video_item_real_set_pixel_width;
	iface->get_pixel_height = rygel_video_item_real_get_pixel_height;
	iface->set_pixel_height = rygel_video_item_real_set_pixel_height;
	iface->get_color_depth = rygel_video_item_real_get_color_depth;
	iface->set_color_depth = rygel_video_item_real_set_color_depth;
	iface->get_thumbnails = rygel_video_item_real_get_thumbnails;
	iface->set_thumbnails = rygel_video_item_real_set_thumbnails;
}


static void rygel_video_item_instance_init (RygelVideoItem * self) {
	self->priv = RYGEL_VIDEO_ITEM_GET_PRIVATE (self);
	self->priv->_width = -1;
	self->priv->_height = -1;
	self->priv->_pixel_width = -1;
	self->priv->_pixel_height = -1;
	self->priv->_color_depth = -1;
}


static void rygel_video_item_finalize (GObject* obj) {
	RygelVideoItem * self;
	self = RYGEL_VIDEO_ITEM (obj);
	_g_free0 (self->author);
	_g_object_unref0 (self->priv->_thumbnails);
	_g_object_unref0 (self->subtitles);
	G_OBJECT_CLASS (rygel_video_item_parent_class)->finalize (obj);
}


/**
 * Represents a video item.
 */
GType rygel_video_item_get_type (void) {
	static volatile gsize rygel_video_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_video_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelVideoItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_video_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelVideoItem), 0, (GInstanceInitFunc) rygel_video_item_instance_init, NULL };
		static const GInterfaceInfo rygel_visual_item_info = { (GInterfaceInitFunc) rygel_video_item_rygel_visual_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_video_item_type_id;
		rygel_video_item_type_id = g_type_register_static (RYGEL_TYPE_AUDIO_ITEM, "RygelVideoItem", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_video_item_type_id, RYGEL_TYPE_VISUAL_ITEM, &rygel_visual_item_info);
		g_once_init_leave (&rygel_video_item_type_id__volatile, rygel_video_item_type_id);
	}
	return rygel_video_item_type_id__volatile;
}


static void _vala_rygel_video_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelVideoItem * self;
	self = RYGEL_VIDEO_ITEM (object);
	switch (property_id) {
		case RYGEL_VIDEO_ITEM_WIDTH:
		g_value_set_int (value, rygel_visual_item_get_width ((RygelVisualItem*) self));
		break;
		case RYGEL_VIDEO_ITEM_HEIGHT:
		g_value_set_int (value, rygel_visual_item_get_height ((RygelVisualItem*) self));
		break;
		case RYGEL_VIDEO_ITEM_PIXEL_WIDTH:
		g_value_set_int (value, rygel_visual_item_get_pixel_width ((RygelVisualItem*) self));
		break;
		case RYGEL_VIDEO_ITEM_PIXEL_HEIGHT:
		g_value_set_int (value, rygel_visual_item_get_pixel_height ((RygelVisualItem*) self));
		break;
		case RYGEL_VIDEO_ITEM_COLOR_DEPTH:
		g_value_set_int (value, rygel_visual_item_get_color_depth ((RygelVisualItem*) self));
		break;
		case RYGEL_VIDEO_ITEM_THUMBNAILS:
		g_value_set_object (value, rygel_visual_item_get_thumbnails ((RygelVisualItem*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_video_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelVideoItem * self;
	self = RYGEL_VIDEO_ITEM (object);
	switch (property_id) {
		case RYGEL_VIDEO_ITEM_WIDTH:
		rygel_visual_item_set_width ((RygelVisualItem*) self, g_value_get_int (value));
		break;
		case RYGEL_VIDEO_ITEM_HEIGHT:
		rygel_visual_item_set_height ((RygelVisualItem*) self, g_value_get_int (value));
		break;
		case RYGEL_VIDEO_ITEM_PIXEL_WIDTH:
		rygel_visual_item_set_pixel_width ((RygelVisualItem*) self, g_value_get_int (value));
		break;
		case RYGEL_VIDEO_ITEM_PIXEL_HEIGHT:
		rygel_visual_item_set_pixel_height ((RygelVisualItem*) self, g_value_get_int (value));
		break;
		case RYGEL_VIDEO_ITEM_COLOR_DEPTH:
		rygel_visual_item_set_color_depth ((RygelVisualItem*) self, g_value_get_int (value));
		break;
		case RYGEL_VIDEO_ITEM_THUMBNAILS:
		rygel_visual_item_set_thumbnails ((RygelVisualItem*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



