/* rygel-http-response-test.c generated by valac 0.12.0, the Vala compiler
 * generated from rygel-http-response-test.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>
#include <libgupnp/gupnp.h>
#include <libgssdp/gssdp.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TYPE_HTTP_RESPONSE_TEST (rygel_http_response_test_get_type ())
#define RYGEL_HTTP_RESPONSE_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE_TEST, RygelHTTPResponseTest))
#define RYGEL_HTTP_RESPONSE_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE_TEST, RygelHTTPResponseTestClass))
#define RYGEL_IS_HTTP_RESPONSE_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE_TEST))
#define RYGEL_IS_HTTP_RESPONSE_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE_TEST))
#define RYGEL_HTTP_RESPONSE_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE_TEST, RygelHTTPResponseTestClass))

typedef struct _RygelHTTPResponseTest RygelHTTPResponseTest;
typedef struct _RygelHTTPResponseTestClass RygelHTTPResponseTestClass;
typedef struct _RygelHTTPResponseTestPrivate RygelHTTPResponseTestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_CLIENT (rygel_http_client_get_type ())
#define RYGEL_HTTP_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClient))
#define RYGEL_HTTP_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientClass))
#define RYGEL_IS_HTTP_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_CLIENT))
#define RYGEL_IS_HTTP_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_CLIENT))
#define RYGEL_HTTP_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientClass))

typedef struct _RygelHTTPClient RygelHTTPClient;
typedef struct _RygelHTTPClientClass RygelHTTPClientClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _rygel_media_item_unref0(var) ((var == NULL) ? NULL : (var = (rygel_media_item_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;

#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;

#define RYGEL_TYPE_HTTP_BYTE_SEEK (rygel_http_byte_seek_get_type ())
#define RYGEL_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeek))
#define RYGEL_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))
#define RYGEL_IS_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_IS_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_HTTP_BYTE_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))

typedef struct _RygelHTTPByteSeek RygelHTTPByteSeek;
typedef struct _RygelHTTPByteSeekClass RygelHTTPByteSeekClass;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;

#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))
typedef struct _RygelHTTPClientPrivate RygelHTTPClientPrivate;
typedef struct _Block1Data Block1Data;
typedef struct _RygelHttpClientRunData RygelHttpClientRunData;
typedef struct _RygelHTTPSeekPrivate RygelHTTPSeekPrivate;
typedef struct _RygelHTTPByteSeekPrivate RygelHTTPByteSeekPrivate;

#define RYGEL_TYPE_HTTP_TIME_SEEK (rygel_http_time_seek_get_type ())
#define RYGEL_HTTP_TIME_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeek))
#define RYGEL_HTTP_TIME_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeekClass))
#define RYGEL_IS_HTTP_TIME_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TIME_SEEK))
#define RYGEL_IS_HTTP_TIME_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TIME_SEEK))
#define RYGEL_HTTP_TIME_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeekClass))

typedef struct _RygelHTTPTimeSeek RygelHTTPTimeSeek;
typedef struct _RygelHTTPTimeSeekClass RygelHTTPTimeSeekClass;
typedef struct _RygelHTTPTimeSeekPrivate RygelHTTPTimeSeekPrivate;
typedef struct _RygelHTTPGetPrivate RygelHTTPGetPrivate;
typedef struct _RygelHTTPGetHandlerPrivate RygelHTTPGetHandlerPrivate;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
typedef struct _RygelParamSpecMediaItem RygelParamSpecMediaItem;

typedef enum  {
	RYGEL_TEST_ERROR_SKIP = 77,
	RYGEL_TEST_ERROR_TIMEOUT
} RygelTestError;
#define RYGEL_TEST_ERROR rygel_test_error_quark ()
typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHTTPResponseTest {
	GObject parent_instance;
	RygelHTTPResponseTestPrivate * priv;
	RygelHTTPServer* server;
	RygelHTTPClient* client;
	GCancellable* cancellable;
};

struct _RygelHTTPResponseTestClass {
	GObjectClass parent_class;
	void (*run) (RygelHTTPResponseTest* self, GError** error);
};

struct _RygelHTTPResponseTestPrivate {
	gboolean server_done;
	gboolean client_done;
	RygelMediaItem* item;
	GMainLoop* main_loop;
	GError* error;
};

struct _RygelHTTPServer {
	GObject parent_instance;
	RygelHTTPServerPrivate * priv;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	GObjectClass parent_class;
};

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPClient {
	GObject parent_instance;
	RygelHTTPClientPrivate * priv;
	GUPnPContext* context;
	SoupMessage* msg;
	gsize total_bytes;
};

struct _RygelHTTPClientClass {
	GObjectClass parent_class;
};

struct _RygelHTTPClientPrivate {
	GCancellable* _cancellable;
};

struct _Block1Data {
	int _ref_count_;
	RygelHTTPClient * self;
	GSourceFunc run_continue;
	gpointer run_continue_target;
	GDestroyNotify run_continue_target_destroy_notify;
	gsize bytes_received;
	gpointer _async_data_;
};

struct _RygelHttpClientRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPClient* self;
	Block1Data* _data1_;
	SoupSession* _tmp0_;
	SoupMessage* _tmp1_;
};

struct _RygelHTTPSeek {
	GObject parent_instance;
	RygelHTTPSeekPrivate * priv;
};

struct _RygelHTTPSeekClass {
	GObjectClass parent_class;
};

struct _RygelHTTPSeekPrivate {
	gint64 _start;
	gint64 _stop;
	gint64 _length;
	gint64 _total_length;
};

struct _RygelHTTPByteSeek {
	RygelHTTPSeek parent_instance;
	RygelHTTPByteSeekPrivate * priv;
};

struct _RygelHTTPByteSeekClass {
	RygelHTTPSeekClass parent_class;
};

struct _RygelHTTPTimeSeek {
	RygelHTTPSeek parent_instance;
	RygelHTTPTimeSeekPrivate * priv;
};

struct _RygelHTTPTimeSeekClass {
	RygelHTTPSeekClass parent_class;
};

struct _RygelHTTPGet {
	GObject parent_instance;
	RygelHTTPGetPrivate * priv;
	SoupServer* server;
	SoupMessage* msg;
	GCancellable* cancellable;
	RygelMediaItem* item;
	RygelHTTPSeek* seek;
};

struct _RygelHTTPGetClass {
	GObjectClass parent_class;
};

struct _RygelHTTPGetHandler {
	GObject parent_instance;
	RygelHTTPGetHandlerPrivate * priv;
	GCancellable* cancellable;
};

struct _RygelHTTPGetHandlerClass {
	GObjectClass parent_class;
};

struct _RygelMediaItem {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelMediaItemPrivate * priv;
};

struct _RygelMediaItemClass {
	GTypeClass parent_class;
	void (*finalize) (RygelMediaItem *self);
};

struct _RygelMediaItemPrivate {
	GstElement* src;
};

struct _RygelParamSpecMediaItem {
	GParamSpec parent_instance;
};


static gpointer rygel_http_response_test_parent_class = NULL;
static gpointer rygel_http_server_parent_class = NULL;
static gpointer rygel_http_client_parent_class = NULL;
static RygelStateMachineIface* rygel_http_client_rygel_state_machine_parent_iface = NULL;
static gpointer rygel_http_seek_parent_class = NULL;
static gpointer rygel_http_byte_seek_parent_class = NULL;
static gpointer rygel_http_time_seek_parent_class = NULL;
static gpointer rygel_http_get_parent_class = NULL;
static gpointer rygel_http_get_handler_parent_class = NULL;
static gpointer rygel_media_item_parent_class = NULL;

GQuark rygel_test_error_quark (void);
GQuark rygel_http_request_error_quark (void);
GType rygel_http_response_test_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_client_get_type (void) G_GNUC_CONST;
gpointer rygel_media_item_ref (gpointer instance);
void rygel_media_item_unref (gpointer instance);
GParamSpec* rygel_param_spec_media_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_media_item (GValue* value, gpointer v_object);
void rygel_value_take_media_item (GValue* value, gpointer v_object);
gpointer rygel_value_get_media_item (const GValue* value);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_RESPONSE_TEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_RESPONSE_TEST, RygelHTTPResponseTestPrivate))
enum  {
	RYGEL_HTTP_RESPONSE_TEST_DUMMY_PROPERTY
};
#define RYGEL_HTTP_RESPONSE_TEST_MAX_BYTES ((glong) 102400)
gint rygel_http_response_test_main (gchar** args, int args_length1);
RygelHTTPResponseTest* rygel_http_response_test_new_complete (GError** error);
RygelHTTPResponseTest* rygel_http_response_test_construct_complete (GType object_type, GError** error);
void rygel_http_response_test_run (RygelHTTPResponseTest* self, GError** error);
RygelHTTPResponseTest* rygel_http_response_test_new_abort (GError** error);
RygelHTTPResponseTest* rygel_http_response_test_construct_abort (GType object_type, GError** error);
RygelHTTPResponseTest* rygel_http_response_test_new (GCancellable* cancellable, GError** error);
RygelHTTPResponseTest* rygel_http_response_test_construct (GType object_type, GCancellable* cancellable, GError** error);
RygelHTTPServer* rygel_http_server_new (GError** error);
RygelHTTPServer* rygel_http_server_construct (GType object_type, GError** error);
gchar* rygel_http_server_get_uri (RygelHTTPServer* self);
RygelHTTPClient* rygel_http_client_new (GUPnPContext* context, const gchar* uri, gsize total_bytes, gboolean active);
RygelHTTPClient* rygel_http_client_construct (GType object_type, GUPnPContext* context, const gchar* uri, gsize total_bytes, gboolean active);
RygelMediaItem* rygel_media_item_new_fixed_size (void);
RygelMediaItem* rygel_media_item_construct_fixed_size (GType object_type);
RygelMediaItem* rygel_media_item_new (void);
RygelMediaItem* rygel_media_item_construct (GType object_type);
static void rygel_http_response_test_real_run (RygelHTTPResponseTest* self, GError** error);
static gboolean rygel_http_response_test_on_timeout (RygelHTTPResponseTest* self);
static gboolean _rygel_http_response_test_on_timeout_gsource_func (gpointer self);
static void rygel_http_response_test_on_message_received (RygelHTTPResponseTest* self, RygelHTTPServer* server, SoupMessage* msg);
static void _rygel_http_response_test_on_message_received_rygel_http_server_message_received (RygelHTTPServer* _sender, SoupMessage* message, gpointer self);
static void rygel_http_response_test_on_message_aborted (RygelHTTPResponseTest* self, RygelHTTPServer* server, SoupMessage* msg);
static void _rygel_http_response_test_on_message_aborted_rygel_http_server_message_aborted (RygelHTTPServer* _sender, SoupMessage* message, gpointer self);
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
static void rygel_http_response_test_on_client_completed (RygelHTTPResponseTest* self, RygelStateMachine* client);
static void _rygel_http_response_test_on_client_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self);
void rygel_state_machine_run (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_state_machine_run_finish (RygelStateMachine* self, GAsyncResult* _res_);
GType rygel_http_response_get_type (void) G_GNUC_CONST;
static RygelHTTPResponse* rygel_http_response_test_create_response (RygelHTTPResponseTest* self, SoupMessage* msg, GError** error);
GType rygel_http_seek_get_type (void) G_GNUC_CONST;
gboolean rygel_media_item_is_live_stream (RygelMediaItem* self);
gint64 rygel_media_item_get_size (RygelMediaItem* self);
RygelHTTPByteSeek* rygel_http_byte_seek_new (gint64 start, gint64 stop, gint64 total_length);
RygelHTTPByteSeek* rygel_http_byte_seek_construct (GType object_type, gint64 start, gint64 stop, gint64 total_length);
GType rygel_http_byte_seek_get_type (void) G_GNUC_CONST;
gint64 rygel_http_seek_get_length (RygelHTTPSeek* self);
RygelHTTPGet* rygel_http_get_new (SoupServer* server, SoupMessage* msg, RygelMediaItem* item, RygelHTTPSeek* seek, GCancellable* cancellable);
RygelHTTPGet* rygel_http_get_construct (GType object_type, SoupServer* server, SoupMessage* msg, RygelMediaItem* item, RygelHTTPSeek* seek, GCancellable* cancellable);
GType rygel_http_get_get_type (void) G_GNUC_CONST;
RygelHTTPGetHandler* rygel_http_get_handler_new (GCancellable* cancellable);
RygelHTTPGetHandler* rygel_http_get_handler_construct (GType object_type, GCancellable* cancellable);
GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
GstElement* rygel_media_item_create_stream_source (RygelMediaItem* self);
RygelHTTPResponse* rygel_http_response_new (RygelHTTPGet* request, RygelHTTPGetHandler* request_handler, GstElement* src, GError** error);
RygelHTTPResponse* rygel_http_response_construct (GType object_type, RygelHTTPGet* request, RygelHTTPGetHandler* request_handler, GstElement* src, GError** error);
static void rygel_http_response_test_on_response_completed (RygelHTTPResponseTest* self, RygelStateMachine* response);
static void _rygel_http_response_test_on_response_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self);
static void rygel_http_response_test_finalize (GObject* obj);
enum  {
	RYGEL_HTTP_SERVER_DUMMY_PROPERTY,
	RYGEL_HTTP_SERVER_URI
};
#define RYGEL_HTTP_SERVER_SERVER_PATH "/RygelHTTPServer/Rygel/Test"
static void rygel_http_server_server_cb (RygelHTTPServer* self, SoupServer* server, SoupMessage* msg, const gchar* path, GHashTable* query, SoupClientContext* client);
static void _rygel_http_server_server_cb_soup_server_callback (SoupServer* server, SoupMessage* msg, const gchar* path, GHashTable* query, SoupClientContext* client, gpointer self);
static void rygel_http_server_on_request_aborted (RygelHTTPServer* self, SoupServer* server, SoupMessage* message, SoupClientContext* client);
static void _rygel_http_server_on_request_aborted_soup_server_request_aborted (SoupServer* _sender, SoupMessage* msg, SoupClientContext* client, gpointer self);
static void rygel_http_server_finalize (GObject* obj);
static void _vala_rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
#define RYGEL_HTTP_CLIENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientPrivate))
enum  {
	RYGEL_HTTP_CLIENT_DUMMY_PROPERTY,
	RYGEL_HTTP_CLIENT_CANCELLABLE
};
void rygel_state_machine_set_cancellable (RygelStateMachine* self, GCancellable* value);
static void rygel_http_client_on_cancelled (RygelHTTPClient* self, GCancellable* cancellable);
static void _rygel_http_client_on_cancelled_g_cancellable_cancelled (GCancellable* _sender, gpointer self);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static void rygel_http_client_real_run_data_free (gpointer _data);
static void rygel_http_client_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_client_real_run_co (RygelHttpClientRunData* data);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static gboolean _rygel_http_client_real_run_co_gsource_func (gpointer self);
static void _lambda0_ (SoupMessage* msg, SoupBuffer* chunk, Block1Data* _data1_);
static void __lambda0__soup_message_got_chunk (SoupMessage* _sender, SoupBuffer* chunk, gpointer self);
static void _lambda1_ (SoupSession* session, SoupMessage* msg, Block1Data* _data1_);
static void __lambda1__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self);
static void rygel_http_client_finalize (GObject* obj);
static void _vala_rygel_http_client_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_http_client_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define RYGEL_HTTP_SEEK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekPrivate))
enum  {
	RYGEL_HTTP_SEEK_DUMMY_PROPERTY,
	RYGEL_HTTP_SEEK_START,
	RYGEL_HTTP_SEEK_STOP,
	RYGEL_HTTP_SEEK_LENGTH,
	RYGEL_HTTP_SEEK_TOTAL_LENGTH
};
RygelHTTPSeek* rygel_http_seek_new (gint64 start, gint64 stop, gint64 total_length);
RygelHTTPSeek* rygel_http_seek_construct (GType object_type, gint64 start, gint64 stop, gint64 total_length);
static void rygel_http_seek_set_start (RygelHTTPSeek* self, gint64 value);
static void rygel_http_seek_set_stop (RygelHTTPSeek* self, gint64 value);
static void rygel_http_seek_set_total_length (RygelHTTPSeek* self, gint64 value);
static void rygel_http_seek_set_length (RygelHTTPSeek* self, gint64 value);
gint64 rygel_http_seek_get_start (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_stop (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_total_length (RygelHTTPSeek* self);
static void rygel_http_seek_finalize (GObject* obj);
static void _vala_rygel_http_seek_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_http_seek_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	RYGEL_HTTP_BYTE_SEEK_DUMMY_PROPERTY
};
GType rygel_http_time_seek_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_TIME_SEEK_DUMMY_PROPERTY
};
RygelHTTPTimeSeek* rygel_http_time_seek_new (gint64 start, gint64 stop, gint64 total_length);
RygelHTTPTimeSeek* rygel_http_time_seek_construct (GType object_type, gint64 start, gint64 stop, gint64 total_length);
enum  {
	RYGEL_HTTP_GET_DUMMY_PROPERTY
};
static void rygel_http_get_finalize (GObject* obj);
enum  {
	RYGEL_HTTP_GET_HANDLER_DUMMY_PROPERTY
};
static void rygel_http_get_handler_finalize (GObject* obj);
#define RYGEL_MEDIA_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemPrivate))
enum  {
	RYGEL_MEDIA_ITEM_DUMMY_PROPERTY
};
#define RYGEL_MEDIA_ITEM_BLOCK_SIZE ((RYGEL_HTTP_RESPONSE_TEST_MAX_BYTES / 16) + 1)
#define RYGEL_MEDIA_ITEM_MAX_BUFFERS ((glong) 25)
GstElement* rygel_gst_utils_create_element (const gchar* factoryname, const gchar* name, GError** error);
static inline void _dynamic_set_sizetype0 (GstElement* obj, gint value);
static inline void _dynamic_set_blocksize1 (GstElement* obj, glong value);
static inline void _dynamic_set_num_buffers2 (GstElement* obj, glong value);
static inline void _dynamic_set_sizemax3 (GstElement* obj, glong value);
static inline GstElement* _dynamic_get_num_buffers4 (GstElement* obj);
static void rygel_media_item_finalize (RygelMediaItem* obj);


GQuark rygel_test_error_quark (void) {
	return g_quark_from_static_string ("rygel_test_error-quark");
}


GQuark rygel_http_request_error_quark (void) {
	return g_quark_from_static_string ("rygel_http_request_error-quark");
}


gint rygel_http_response_test_main (gchar** args, int args_length1) {
	gint result = 0;
	RygelHTTPResponseTest* _tmp0_ = NULL;
	RygelHTTPResponseTest* test;
	RygelHTTPResponseTest* _tmp1_ = NULL;
	RygelHTTPResponseTest* _tmp2_;
	GError * _inner_error_ = NULL;
	gst_init (&args_length1, &args);
	_tmp0_ = rygel_http_response_test_new_complete (&_inner_error_);
	test = _tmp0_;
	if (_inner_error_ != NULL) {
		if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
			goto __catch0_rygel_test_error_skip;
		}
		goto __catch0_g_error;
	}
	rygel_http_response_test_run (test, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (test);
		if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
			goto __catch0_rygel_test_error_skip;
		}
		goto __catch0_g_error;
	}
	_tmp1_ = rygel_http_response_test_new_abort (&_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (test);
		if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
			goto __catch0_rygel_test_error_skip;
		}
		goto __catch0_g_error;
	}
	_g_object_unref0 (test);
	test = _tmp2_;
	rygel_http_response_test_run (test, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (test);
		if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
			goto __catch0_rygel_test_error_skip;
		}
		goto __catch0_g_error;
	}
	_g_object_unref0 (test);
	goto __finally0;
	__catch0_rygel_test_error_skip:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		result = _error_->code;
		_g_error_free0 (_error_);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("rygel-http-response-test.vala:64: %s", _error_->message);
		result = -1;
		_g_error_free0 (_error_);
		return result;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_thread_init (NULL);
	g_type_init ();
	return rygel_http_response_test_main (argv, argc);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelHTTPResponseTest* rygel_http_response_test_construct (GType object_type, GCancellable* cancellable, GError** error) {
	RygelHTTPResponseTest * self = NULL;
	GCancellable* _tmp0_;
	RygelHTTPServer* _tmp1_ = NULL;
	RygelHTTPServer* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	RygelHTTPClient* _tmp5_ = NULL;
	GMainLoop* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelHTTPResponseTest*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (self->cancellable);
	self->cancellable = _tmp0_;
	_tmp1_ = rygel_http_server_new (&_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	_g_object_unref0 (self->server);
	self->server = _tmp2_;
	_tmp3_ = rygel_http_server_get_uri (self->server);
	_tmp4_ = _tmp3_;
	_tmp5_ = rygel_http_client_new (self->server->context, _tmp4_, (gsize) RYGEL_HTTP_RESPONSE_TEST_MAX_BYTES, cancellable != NULL);
	_g_object_unref0 (self->client);
	self->client = _tmp5_;
	_g_free0 (_tmp4_);
	_tmp6_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->main_loop);
	self->priv->main_loop = _tmp6_;
	return self;
}


RygelHTTPResponseTest* rygel_http_response_test_new (GCancellable* cancellable, GError** error) {
	return rygel_http_response_test_construct (RYGEL_TYPE_HTTP_RESPONSE_TEST, cancellable, error);
}


RygelHTTPResponseTest* rygel_http_response_test_construct_complete (GType object_type, GError** error) {
	RygelHTTPResponseTest * self = NULL;
	RygelMediaItem* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelHTTPResponseTest*) rygel_http_response_test_construct (object_type, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp0_ = rygel_media_item_new_fixed_size ();
	_rygel_media_item_unref0 (self->priv->item);
	self->priv->item = _tmp0_;
	return self;
}


RygelHTTPResponseTest* rygel_http_response_test_new_complete (GError** error) {
	return rygel_http_response_test_construct_complete (RYGEL_TYPE_HTTP_RESPONSE_TEST, error);
}


RygelHTTPResponseTest* rygel_http_response_test_construct_abort (GType object_type, GError** error) {
	RygelHTTPResponseTest * self = NULL;
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_;
	RygelMediaItem* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_cancellable_new ();
	_tmp1_ = _tmp0_;
	self = (RygelHTTPResponseTest*) rygel_http_response_test_construct (object_type, _tmp1_, &_inner_error_);
	_g_object_unref0 (_tmp1_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp2_ = rygel_media_item_new ();
	_rygel_media_item_unref0 (self->priv->item);
	self->priv->item = _tmp2_;
	return self;
}


RygelHTTPResponseTest* rygel_http_response_test_new_abort (GError** error) {
	return rygel_http_response_test_construct_abort (RYGEL_TYPE_HTTP_RESPONSE_TEST, error);
}


static gboolean _rygel_http_response_test_on_timeout_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_http_response_test_on_timeout (self);
	return result;
}


static void _rygel_http_response_test_on_message_received_rygel_http_server_message_received (RygelHTTPServer* _sender, SoupMessage* message, gpointer self) {
	rygel_http_response_test_on_message_received (self, _sender, message);
}


static void _rygel_http_response_test_on_message_aborted_rygel_http_server_message_aborted (RygelHTTPServer* _sender, SoupMessage* message, gpointer self) {
	rygel_http_response_test_on_message_aborted (self, _sender, message);
}


static void _rygel_http_response_test_on_client_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self) {
	rygel_http_response_test_on_client_completed (self, _sender);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static void rygel_http_response_test_real_run (RygelHTTPResponseTest* self, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 3, _rygel_http_response_test_on_timeout_gsource_func, g_object_ref (self), g_object_unref);
	g_signal_connect_object (self->server, "message-received", (GCallback) _rygel_http_response_test_on_message_received_rygel_http_server_message_received, self, 0);
	g_signal_connect_object (self->server, "message-aborted", (GCallback) _rygel_http_response_test_on_message_aborted_rygel_http_server_message_aborted, self, 0);
	if (self->cancellable == NULL) {
		g_signal_connect_object ((RygelStateMachine*) self->client, "completed", (GCallback) _rygel_http_response_test_on_client_completed_rygel_state_machine_completed, self, 0);
	} else {
		self->priv->client_done = TRUE;
	}
	rygel_state_machine_run ((RygelStateMachine*) self->client, NULL, NULL);
	g_main_loop_run (self->priv->main_loop);
	if (self->priv->error != NULL) {
		GError* _tmp0_;
		_tmp0_ = _g_error_copy0 (self->priv->error);
		_inner_error_ = _tmp0_;
		g_propagate_error (error, _inner_error_);
		return;
	}
}


void rygel_http_response_test_run (RygelHTTPResponseTest* self, GError** error) {
	RYGEL_HTTP_RESPONSE_TEST_GET_CLASS (self)->run (self, error);
}


static RygelHTTPResponse* rygel_http_response_test_create_response (RygelHTTPResponseTest* self, SoupMessage* msg, GError** error) {
	RygelHTTPResponse* result = NULL;
	gpointer _tmp0_;
	RygelHTTPSeek* _tmp1_;
	RygelHTTPSeek* seek;
	gboolean _tmp2_;
	SoupServer* _tmp6_ = NULL;
	RygelHTTPGet* _tmp7_ = NULL;
	RygelHTTPGet* request;
	RygelHTTPGetHandler* _tmp8_ = NULL;
	RygelHTTPGetHandler* handler;
	GstElement* _tmp9_ = NULL;
	GstElement* src;
	RygelHTTPResponse* _tmp10_ = NULL;
	RygelHTTPResponse* _tmp11_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (msg != NULL, NULL);
	_tmp0_ = NULL;
	_tmp1_ = _g_object_ref0 (RYGEL_IS_HTTP_SEEK (_tmp0_) ? ((RygelHTTPSeek*) _tmp0_) : NULL);
	seek = _tmp1_;
	_tmp2_ = rygel_media_item_is_live_stream (self->priv->item);
	if (!_tmp2_) {
		gint64 _tmp3_;
		RygelHTTPByteSeek* _tmp4_ = NULL;
		gint64 _tmp5_;
		_tmp3_ = rygel_media_item_get_size (self->priv->item);
		_tmp4_ = rygel_http_byte_seek_new ((gint64) 0, (gint64) (RYGEL_HTTP_RESPONSE_TEST_MAX_BYTES - 1), _tmp3_);
		_g_object_unref0 (seek);
		seek = (RygelHTTPSeek*) _tmp4_;
		_tmp5_ = rygel_http_seek_get_length (seek);
		soup_message_headers_set_content_length (msg->response_headers, _tmp5_);
	}
	_tmp6_ = gupnp_context_get_server (self->server->context);
	_tmp7_ = rygel_http_get_new (_tmp6_, msg, self->priv->item, seek, self->cancellable);
	request = _tmp7_;
	_tmp8_ = rygel_http_get_handler_new (self->cancellable);
	handler = _tmp8_;
	_tmp9_ = rygel_media_item_create_stream_source (self->priv->item);
	src = _tmp9_;
	_tmp10_ = rygel_http_response_new (request, handler, src, &_inner_error_);
	_tmp11_ = _tmp10_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_gst_object_unref0 (src);
		_g_object_unref0 (handler);
		_g_object_unref0 (request);
		_g_object_unref0 (seek);
		return NULL;
	}
	result = _tmp11_;
	_gst_object_unref0 (src);
	_g_object_unref0 (handler);
	_g_object_unref0 (request);
	_g_object_unref0 (seek);
	return result;
}


static void rygel_http_response_test_on_client_completed (RygelHTTPResponseTest* self, RygelStateMachine* client) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (client != NULL);
	if (self->priv->server_done) {
		g_main_loop_quit (self->priv->main_loop);
	}
	self->priv->client_done = TRUE;
}


static void rygel_http_response_test_on_response_completed (RygelHTTPResponseTest* self, RygelStateMachine* response) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (response != NULL);
	if (self->priv->client_done) {
		g_main_loop_quit (self->priv->main_loop);
	}
	self->priv->server_done = TRUE;
}


static void _rygel_http_response_test_on_response_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self) {
	rygel_http_response_test_on_response_completed (self, _sender);
}


static void rygel_http_response_test_on_message_received (RygelHTTPResponseTest* self, RygelHTTPServer* server, SoupMessage* msg) {
	RygelHTTPResponse* _tmp0_ = NULL;
	RygelHTTPResponse* response;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (server != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = rygel_http_response_test_create_response (self, msg, &_inner_error_);
	response = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch1_g_error;
	}
	rygel_state_machine_run ((RygelStateMachine*) response, NULL, NULL);
	g_signal_connect_object ((RygelStateMachine*) response, "completed", (GCallback) _rygel_http_response_test_on_response_completed_rygel_state_machine_completed, self, 0);
	_g_object_unref0 (response);
	goto __finally1;
	__catch1_g_error:
	{
		GError * _error_;
		GError* _tmp1_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = _g_error_copy0 (_error_);
		_g_error_free0 (self->priv->error);
		self->priv->error = _tmp1_;
		g_main_loop_quit (self->priv->main_loop);
		_g_error_free0 (_error_);
		return;
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_http_response_test_on_message_aborted (RygelHTTPResponseTest* self, RygelHTTPServer* server, SoupMessage* msg) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (server != NULL);
	g_return_if_fail (msg != NULL);
	g_cancellable_cancel (self->cancellable);
}


static gboolean rygel_http_response_test_on_timeout (RygelHTTPResponseTest* self) {
	gboolean result = FALSE;
	GError* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_error_new_literal (RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_TIMEOUT, "Timeout");
	_g_error_free0 (self->priv->error);
	self->priv->error = _tmp0_;
	g_main_loop_quit (self->priv->main_loop);
	result = FALSE;
	return result;
}


static void rygel_http_response_test_class_init (RygelHTTPResponseTestClass * klass) {
	rygel_http_response_test_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPResponseTestPrivate));
	RYGEL_HTTP_RESPONSE_TEST_CLASS (klass)->run = rygel_http_response_test_real_run;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_response_test_finalize;
}


static void rygel_http_response_test_instance_init (RygelHTTPResponseTest * self) {
	self->priv = RYGEL_HTTP_RESPONSE_TEST_GET_PRIVATE (self);
}


static void rygel_http_response_test_finalize (GObject* obj) {
	RygelHTTPResponseTest * self;
	self = RYGEL_HTTP_RESPONSE_TEST (obj);
	_g_object_unref0 (self->server);
	_g_object_unref0 (self->client);
	_rygel_media_item_unref0 (self->priv->item);
	_g_main_loop_unref0 (self->priv->main_loop);
	_g_object_unref0 (self->cancellable);
	_g_error_free0 (self->priv->error);
	G_OBJECT_CLASS (rygel_http_response_test_parent_class)->finalize (obj);
}


GType rygel_http_response_test_get_type (void) {
	static volatile gsize rygel_http_response_test_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_response_test_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPResponseTestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_response_test_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPResponseTest), 0, (GInstanceInitFunc) rygel_http_response_test_instance_init, NULL };
		GType rygel_http_response_test_type_id;
		rygel_http_response_test_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPResponseTest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_response_test_type_id__volatile, rygel_http_response_test_type_id);
	}
	return rygel_http_response_test_type_id__volatile;
}


static void _rygel_http_server_server_cb_soup_server_callback (SoupServer* server, SoupMessage* msg, const gchar* path, GHashTable* query, SoupClientContext* client, gpointer self) {
	rygel_http_server_server_cb (self, server, msg, path, query, client);
}


static void _rygel_http_server_on_request_aborted_soup_server_request_aborted (SoupServer* _sender, SoupMessage* msg, SoupClientContext* client, gpointer self) {
	rygel_http_server_on_request_aborted (self, _sender, msg, client);
}


RygelHTTPServer* rygel_http_server_construct (GType object_type, GError** error) {
	RygelHTTPServer * self = NULL;
	GUPnPContext* _tmp0_ = NULL;
	GUPnPContext* _tmp1_;
	const gchar* _tmp3_ = NULL;
	guint _tmp4_;
	SoupServer* _tmp5_ = NULL;
	SoupServer* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelHTTPServer*) g_object_new (object_type, NULL);
	_tmp0_ = gupnp_context_new (NULL, "lo", (guint) 0, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch2_g_error;
	}
	_g_object_unref0 (self->context);
	self->context = _tmp1_;
	goto __finally2;
	__catch2_g_error:
	{
		GError * _error_;
		GError* _tmp2_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = g_error_new_literal (RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP, "Network context not available");
		_inner_error_ = _tmp2_;
		_g_error_free0 (_error_);
		goto __finally2;
	}
	__finally2:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_TEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	g_assert (self->context != NULL);
	_tmp3_ = gssdp_client_get_host_ip ((GSSDPClient*) self->context);
	g_assert (_tmp3_ != NULL);
	_tmp4_ = gupnp_context_get_port (self->context);
	g_assert (_tmp4_ > 0);
	_tmp5_ = gupnp_context_get_server (self->context);
	soup_server_add_handler (_tmp5_, RYGEL_HTTP_SERVER_SERVER_PATH, _rygel_http_server_server_cb_soup_server_callback, g_object_ref (self), g_object_unref);
	_tmp6_ = gupnp_context_get_server (self->context);
	g_signal_connect_object (_tmp6_, "request-aborted", (GCallback) _rygel_http_server_on_request_aborted_soup_server_request_aborted, self, 0);
	return self;
}


RygelHTTPServer* rygel_http_server_new (GError** error) {
	return rygel_http_server_construct (RYGEL_TYPE_HTTP_SERVER, error);
}


static void rygel_http_server_server_cb (RygelHTTPServer* self, SoupServer* server, SoupMessage* msg, const gchar* path, GHashTable* query, SoupClientContext* client) {
	SoupServer* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (server != NULL);
	g_return_if_fail (msg != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (client != NULL);
	_tmp0_ = gupnp_context_get_server (self->context);
	soup_server_pause_message (_tmp0_, msg);
	g_signal_emit_by_name (self, "message-received", msg);
}


static void rygel_http_server_on_request_aborted (RygelHTTPServer* self, SoupServer* server, SoupMessage* message, SoupClientContext* client) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (server != NULL);
	g_return_if_fail (message != NULL);
	g_return_if_fail (client != NULL);
	g_signal_emit_by_name (self, "message-aborted", message);
}


gchar* rygel_http_server_get_uri (RygelHTTPServer* self) {
	gchar* result;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	guint _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gssdp_client_get_host_ip ((GSSDPClient*) self->context);
	_tmp1_ = g_strconcat ("http://", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, ":", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = gupnp_context_get_port (self->context);
	_tmp6_ = g_strdup_printf ("%u", _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp4_, _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, RYGEL_HTTP_SERVER_SERVER_PATH, NULL);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	result = _tmp11_;
	return result;
}


static void rygel_http_server_class_init (RygelHTTPServerClass * klass) {
	rygel_http_server_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_server_get_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_server_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SERVER_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("message_received", RYGEL_TYPE_HTTP_SERVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, SOUP_TYPE_MESSAGE);
	g_signal_new ("message_aborted", RYGEL_TYPE_HTTP_SERVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, SOUP_TYPE_MESSAGE);
}


static void rygel_http_server_instance_init (RygelHTTPServer * self) {
}


static void rygel_http_server_finalize (GObject* obj) {
	RygelHTTPServer * self;
	self = RYGEL_HTTP_SERVER (obj);
	_g_object_unref0 (self->context);
	G_OBJECT_CLASS (rygel_http_server_parent_class)->finalize (obj);
}


GType rygel_http_server_get_type (void) {
	static volatile gsize rygel_http_server_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_server_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPServerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_server_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPServer), 0, (GInstanceInitFunc) rygel_http_server_instance_init, NULL };
		GType rygel_http_server_type_id;
		rygel_http_server_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPServer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_server_type_id__volatile, rygel_http_server_type_id);
	}
	return rygel_http_server_type_id__volatile;
}


static void _vala_rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPServer * self;
	self = RYGEL_HTTP_SERVER (object);
	switch (property_id) {
		case RYGEL_HTTP_SERVER_URI:
		g_value_take_string (value, rygel_http_server_get_uri (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _rygel_http_client_on_cancelled_g_cancellable_cancelled (GCancellable* _sender, gpointer self) {
	rygel_http_client_on_cancelled (self, _sender);
}


RygelHTTPClient* rygel_http_client_construct (GType object_type, GUPnPContext* context, const gchar* uri, gsize total_bytes, gboolean active) {
	RygelHTTPClient * self = NULL;
	GUPnPContext* _tmp0_;
	SoupMessage* _tmp1_ = NULL;
	g_return_val_if_fail (context != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	self = (RygelHTTPClient*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (context);
	_g_object_unref0 (self->context);
	self->context = _tmp0_;
	self->total_bytes = total_bytes;
	_tmp1_ = soup_message_new ("HTTP", uri);
	_g_object_unref0 (self->msg);
	self->msg = _tmp1_;
	g_assert (self->msg != NULL);
	soup_message_body_set_accumulate (self->msg->response_body, FALSE);
	if (active) {
		GCancellable* _tmp2_ = NULL;
		GCancellable* _tmp3_;
		GCancellable* _tmp4_ = NULL;
		_tmp2_ = g_cancellable_new ();
		_tmp3_ = _tmp2_;
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp3_);
		_g_object_unref0 (_tmp3_);
		_tmp4_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
		g_signal_connect_object (_tmp4_, "cancelled", (GCallback) _rygel_http_client_on_cancelled_g_cancellable_cancelled, self, 0);
	}
	return self;
}


RygelHTTPClient* rygel_http_client_new (GUPnPContext* context, const gchar* uri, gsize total_bytes, gboolean active) {
	return rygel_http_client_construct (RYGEL_TYPE_HTTP_CLIENT, context, uri, total_bytes, active);
}


static void rygel_http_client_real_run_data_free (gpointer _data) {
	RygelHttpClientRunData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (RygelHttpClientRunData, data);
}


static void rygel_http_client_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPClient * self;
	RygelHttpClientRunData* _data_;
	self = (RygelHTTPClient*) base;
	_data_ = g_slice_new0 (RygelHttpClientRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_client_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_client_real_run_data_free);
	_data_->self = _g_object_ref0 (self);
	rygel_http_client_real_run_co (_data_);
}


static void rygel_http_client_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelHttpClientRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		(_data1_->run_continue_target_destroy_notify == NULL) ? NULL : (_data1_->run_continue_target_destroy_notify (_data1_->run_continue_target), NULL);
		_data1_->run_continue = NULL;
		_data1_->run_continue_target = NULL;
		_data1_->run_continue_target_destroy_notify = NULL;
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean _rygel_http_client_real_run_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_http_client_real_run_co (self);
	return result;
}


static void _lambda0_ (SoupMessage* msg, SoupBuffer* chunk, Block1Data* _data1_) {
	RygelHTTPClient * self;
	gboolean _tmp0_ = FALSE;
	self = _data1_->self;
	g_return_if_fail (msg != NULL);
	g_return_if_fail (chunk != NULL);
	_data1_->bytes_received = _data1_->bytes_received + chunk->length;
	if (_data1_->bytes_received >= self->total_bytes) {
		GCancellable* _tmp1_ = NULL;
		_tmp1_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
		_tmp0_ = _tmp1_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GCancellable* _tmp2_ = NULL;
		_tmp2_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
		g_cancellable_cancel (_tmp2_);
	}
}


static void __lambda0__soup_message_got_chunk (SoupMessage* _sender, SoupBuffer* chunk, gpointer self) {
	_lambda0_ (_sender, chunk, self);
}


static void _lambda1_ (SoupSession* session, SoupMessage* msg, Block1Data* _data1_) {
	RygelHTTPClient * self;
	gboolean _tmp0_ = FALSE;
	GCancellable* _tmp1_ = NULL;
	self = _data1_->self;
	g_return_if_fail (session != NULL);
	g_return_if_fail (msg != NULL);
	_tmp1_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
	if (_tmp1_ != NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = _data1_->bytes_received == self->total_bytes;
	}
	g_assert (_tmp0_);
	_data1_->run_continue (_data1_->run_continue_target);
}


static void __lambda1__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self) {
	_lambda1_ (session, msg, self);
}


static gboolean rygel_http_client_real_run_co (RygelHttpClientRunData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_data1_ = g_slice_new0 (Block1Data);
	data->_data1_->_ref_count_ = 1;
	data->_data1_->self = g_object_ref (data->self);
	data->_data1_->_async_data_ = data;
	data->_data1_->run_continue = _rygel_http_client_real_run_co_gsource_func;
	data->_data1_->run_continue_target = data;
	data->_data1_->run_continue_target_destroy_notify = NULL;
	data->_data1_->bytes_received = (gsize) 0;
	g_signal_connect_data (data->self->msg, "got-chunk", (GCallback) __lambda0__soup_message_got_chunk, block1_data_ref (data->_data1_), (GClosureNotify) block1_data_unref, 0);
	data->_tmp0_ = NULL;
	data->_tmp0_ = gupnp_context_get_session (data->self->context);
	data->_tmp1_ = _g_object_ref0 (data->self->msg);
	soup_session_queue_message (data->_tmp0_, data->_tmp1_, __lambda1__soup_session_callback, data->_data1_);
	data->_state_ = 1;
	return FALSE;
	_state_1:
	;
	g_signal_emit_by_name ((RygelStateMachine*) data->self, "completed");
	block1_data_unref (data->_data1_);
	data->_data1_ = NULL;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_http_client_on_cancelled (RygelHTTPClient* self, GCancellable* cancellable) {
	SoupSession* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cancellable != NULL);
	_tmp0_ = gupnp_context_get_session (self->context);
	soup_session_cancel_message (_tmp0_, self->msg, (guint) SOUP_STATUS_CANCELLED);
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
}


static GCancellable* rygel_http_client_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelHTTPClient* self;
	self = (RygelHTTPClient*) base;
	result = self->priv->_cancellable;
	return result;
}


static void rygel_http_client_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelHTTPClient* self;
	GCancellable* _tmp0_;
	self = (RygelHTTPClient*) base;
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_cancellable);
	self->priv->_cancellable = _tmp0_;
	g_object_notify ((GObject *) self, "cancellable");
}


static void rygel_http_client_class_init (RygelHTTPClientClass * klass) {
	rygel_http_client_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPClientPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_client_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_client_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_client_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_CLIENT_CANCELLABLE, "cancellable");
}


static void rygel_http_client_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
	rygel_http_client_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = (void (*)(RygelStateMachine*)) rygel_http_client_real_run;
	iface->run_finish = rygel_http_client_real_run_finish;
	iface->get_cancellable = rygel_http_client_real_get_cancellable;
	iface->set_cancellable = rygel_http_client_real_set_cancellable;
}


static void rygel_http_client_instance_init (RygelHTTPClient * self) {
	self->priv = RYGEL_HTTP_CLIENT_GET_PRIVATE (self);
}


static void rygel_http_client_finalize (GObject* obj) {
	RygelHTTPClient * self;
	self = RYGEL_HTTP_CLIENT (obj);
	_g_object_unref0 (self->context);
	_g_object_unref0 (self->msg);
	_g_object_unref0 (self->priv->_cancellable);
	G_OBJECT_CLASS (rygel_http_client_parent_class)->finalize (obj);
}


GType rygel_http_client_get_type (void) {
	static volatile gsize rygel_http_client_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_client_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPClientClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_client_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPClient), 0, (GInstanceInitFunc) rygel_http_client_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_http_client_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_http_client_type_id;
		rygel_http_client_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPClient", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_http_client_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_http_client_type_id__volatile, rygel_http_client_type_id);
	}
	return rygel_http_client_type_id__volatile;
}


static void _vala_rygel_http_client_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPClient * self;
	self = RYGEL_HTTP_CLIENT (object);
	switch (property_id) {
		case RYGEL_HTTP_CLIENT_CANCELLABLE:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_http_client_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPClient * self;
	self = RYGEL_HTTP_CLIENT (object);
	switch (property_id) {
		case RYGEL_HTTP_CLIENT_CANCELLABLE:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


RygelHTTPSeek* rygel_http_seek_construct (GType object_type, gint64 start, gint64 stop, gint64 total_length) {
	RygelHTTPSeek * self = NULL;
	self = (RygelHTTPSeek*) g_object_new (object_type, NULL);
	rygel_http_seek_set_start (self, start);
	rygel_http_seek_set_stop (self, stop);
	rygel_http_seek_set_total_length (self, total_length);
	rygel_http_seek_set_length (self, (stop - start) + 1);
	return self;
}


RygelHTTPSeek* rygel_http_seek_new (gint64 start, gint64 stop, gint64 total_length) {
	return rygel_http_seek_construct (RYGEL_TYPE_HTTP_SEEK, start, stop, total_length);
}


gint64 rygel_http_seek_get_start (RygelHTTPSeek* self) {
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_start;
	return result;
}


static void rygel_http_seek_set_start (RygelHTTPSeek* self, gint64 value) {
	g_return_if_fail (self != NULL);
	self->priv->_start = value;
	g_object_notify ((GObject *) self, "start");
}


gint64 rygel_http_seek_get_stop (RygelHTTPSeek* self) {
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_stop;
	return result;
}


static void rygel_http_seek_set_stop (RygelHTTPSeek* self, gint64 value) {
	g_return_if_fail (self != NULL);
	self->priv->_stop = value;
	g_object_notify ((GObject *) self, "stop");
}


gint64 rygel_http_seek_get_length (RygelHTTPSeek* self) {
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_length;
	return result;
}


static void rygel_http_seek_set_length (RygelHTTPSeek* self, gint64 value) {
	g_return_if_fail (self != NULL);
	self->priv->_length = value;
	g_object_notify ((GObject *) self, "length");
}


gint64 rygel_http_seek_get_total_length (RygelHTTPSeek* self) {
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_total_length;
	return result;
}


static void rygel_http_seek_set_total_length (RygelHTTPSeek* self, gint64 value) {
	g_return_if_fail (self != NULL);
	self->priv->_total_length = value;
	g_object_notify ((GObject *) self, "total-length");
}


static void rygel_http_seek_class_init (RygelHTTPSeekClass * klass) {
	rygel_http_seek_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPSeekPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_seek_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_seek_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_seek_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SEEK_START, g_param_spec_int64 ("start", "start", "start", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SEEK_STOP, g_param_spec_int64 ("stop", "stop", "stop", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SEEK_LENGTH, g_param_spec_int64 ("length", "length", "length", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SEEK_TOTAL_LENGTH, g_param_spec_int64 ("total-length", "total-length", "total-length", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void rygel_http_seek_instance_init (RygelHTTPSeek * self) {
	self->priv = RYGEL_HTTP_SEEK_GET_PRIVATE (self);
}


static void rygel_http_seek_finalize (GObject* obj) {
	RygelHTTPSeek * self;
	self = RYGEL_HTTP_SEEK (obj);
	G_OBJECT_CLASS (rygel_http_seek_parent_class)->finalize (obj);
}


GType rygel_http_seek_get_type (void) {
	static volatile gsize rygel_http_seek_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_seek_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPSeekClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_seek_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPSeek), 0, (GInstanceInitFunc) rygel_http_seek_instance_init, NULL };
		GType rygel_http_seek_type_id;
		rygel_http_seek_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPSeek", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_seek_type_id__volatile, rygel_http_seek_type_id);
	}
	return rygel_http_seek_type_id__volatile;
}


static void _vala_rygel_http_seek_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPSeek * self;
	self = RYGEL_HTTP_SEEK (object);
	switch (property_id) {
		case RYGEL_HTTP_SEEK_START:
		g_value_set_int64 (value, rygel_http_seek_get_start (self));
		break;
		case RYGEL_HTTP_SEEK_STOP:
		g_value_set_int64 (value, rygel_http_seek_get_stop (self));
		break;
		case RYGEL_HTTP_SEEK_LENGTH:
		g_value_set_int64 (value, rygel_http_seek_get_length (self));
		break;
		case RYGEL_HTTP_SEEK_TOTAL_LENGTH:
		g_value_set_int64 (value, rygel_http_seek_get_total_length (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_http_seek_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPSeek * self;
	self = RYGEL_HTTP_SEEK (object);
	switch (property_id) {
		case RYGEL_HTTP_SEEK_START:
		rygel_http_seek_set_start (self, g_value_get_int64 (value));
		break;
		case RYGEL_HTTP_SEEK_STOP:
		rygel_http_seek_set_stop (self, g_value_get_int64 (value));
		break;
		case RYGEL_HTTP_SEEK_LENGTH:
		rygel_http_seek_set_length (self, g_value_get_int64 (value));
		break;
		case RYGEL_HTTP_SEEK_TOTAL_LENGTH:
		rygel_http_seek_set_total_length (self, g_value_get_int64 (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


RygelHTTPByteSeek* rygel_http_byte_seek_construct (GType object_type, gint64 start, gint64 stop, gint64 total_length) {
	RygelHTTPByteSeek * self = NULL;
	self = (RygelHTTPByteSeek*) rygel_http_seek_construct (object_type, start, stop, total_length);
	return self;
}


RygelHTTPByteSeek* rygel_http_byte_seek_new (gint64 start, gint64 stop, gint64 total_length) {
	return rygel_http_byte_seek_construct (RYGEL_TYPE_HTTP_BYTE_SEEK, start, stop, total_length);
}


static void rygel_http_byte_seek_class_init (RygelHTTPByteSeekClass * klass) {
	rygel_http_byte_seek_parent_class = g_type_class_peek_parent (klass);
}


static void rygel_http_byte_seek_instance_init (RygelHTTPByteSeek * self) {
}


GType rygel_http_byte_seek_get_type (void) {
	static volatile gsize rygel_http_byte_seek_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_byte_seek_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPByteSeekClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_byte_seek_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPByteSeek), 0, (GInstanceInitFunc) rygel_http_byte_seek_instance_init, NULL };
		GType rygel_http_byte_seek_type_id;
		rygel_http_byte_seek_type_id = g_type_register_static (RYGEL_TYPE_HTTP_SEEK, "RygelHTTPByteSeek", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_byte_seek_type_id__volatile, rygel_http_byte_seek_type_id);
	}
	return rygel_http_byte_seek_type_id__volatile;
}


RygelHTTPTimeSeek* rygel_http_time_seek_construct (GType object_type, gint64 start, gint64 stop, gint64 total_length) {
	RygelHTTPTimeSeek * self = NULL;
	self = (RygelHTTPTimeSeek*) rygel_http_seek_construct (object_type, start, stop, total_length);
	return self;
}


RygelHTTPTimeSeek* rygel_http_time_seek_new (gint64 start, gint64 stop, gint64 total_length) {
	return rygel_http_time_seek_construct (RYGEL_TYPE_HTTP_TIME_SEEK, start, stop, total_length);
}


static void rygel_http_time_seek_class_init (RygelHTTPTimeSeekClass * klass) {
	rygel_http_time_seek_parent_class = g_type_class_peek_parent (klass);
}


static void rygel_http_time_seek_instance_init (RygelHTTPTimeSeek * self) {
}


GType rygel_http_time_seek_get_type (void) {
	static volatile gsize rygel_http_time_seek_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_time_seek_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPTimeSeekClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_time_seek_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPTimeSeek), 0, (GInstanceInitFunc) rygel_http_time_seek_instance_init, NULL };
		GType rygel_http_time_seek_type_id;
		rygel_http_time_seek_type_id = g_type_register_static (RYGEL_TYPE_HTTP_SEEK, "RygelHTTPTimeSeek", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_time_seek_type_id__volatile, rygel_http_time_seek_type_id);
	}
	return rygel_http_time_seek_type_id__volatile;
}


static gpointer _rygel_media_item_ref0 (gpointer self) {
	return self ? rygel_media_item_ref (self) : NULL;
}


RygelHTTPGet* rygel_http_get_construct (GType object_type, SoupServer* server, SoupMessage* msg, RygelMediaItem* item, RygelHTTPSeek* seek, GCancellable* cancellable) {
	RygelHTTPGet * self = NULL;
	SoupServer* _tmp0_;
	SoupMessage* _tmp1_;
	RygelMediaItem* _tmp2_;
	RygelHTTPSeek* _tmp3_;
	GCancellable* _tmp4_;
	g_return_val_if_fail (server != NULL, NULL);
	g_return_val_if_fail (msg != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	self = (RygelHTTPGet*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (server);
	_g_object_unref0 (self->server);
	self->server = _tmp0_;
	_tmp1_ = _g_object_ref0 (msg);
	_g_object_unref0 (self->msg);
	self->msg = _tmp1_;
	_tmp2_ = _rygel_media_item_ref0 (item);
	_rygel_media_item_unref0 (self->item);
	self->item = _tmp2_;
	_tmp3_ = _g_object_ref0 (seek);
	_g_object_unref0 (self->seek);
	self->seek = _tmp3_;
	_tmp4_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (self->cancellable);
	self->cancellable = _tmp4_;
	return self;
}


RygelHTTPGet* rygel_http_get_new (SoupServer* server, SoupMessage* msg, RygelMediaItem* item, RygelHTTPSeek* seek, GCancellable* cancellable) {
	return rygel_http_get_construct (RYGEL_TYPE_HTTP_GET, server, msg, item, seek, cancellable);
}


static void rygel_http_get_class_init (RygelHTTPGetClass * klass) {
	rygel_http_get_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_http_get_finalize;
}


static void rygel_http_get_instance_init (RygelHTTPGet * self) {
}


static void rygel_http_get_finalize (GObject* obj) {
	RygelHTTPGet * self;
	self = RYGEL_HTTP_GET (obj);
	_g_object_unref0 (self->server);
	_g_object_unref0 (self->msg);
	_g_object_unref0 (self->cancellable);
	_rygel_media_item_unref0 (self->item);
	_g_object_unref0 (self->seek);
	G_OBJECT_CLASS (rygel_http_get_parent_class)->finalize (obj);
}


GType rygel_http_get_get_type (void) {
	static volatile gsize rygel_http_get_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_get_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPGetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_get_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPGet), 0, (GInstanceInitFunc) rygel_http_get_instance_init, NULL };
		GType rygel_http_get_type_id;
		rygel_http_get_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPGet", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_get_type_id__volatile, rygel_http_get_type_id);
	}
	return rygel_http_get_type_id__volatile;
}


RygelHTTPGetHandler* rygel_http_get_handler_construct (GType object_type, GCancellable* cancellable) {
	RygelHTTPGetHandler * self = NULL;
	GCancellable* _tmp0_;
	self = (RygelHTTPGetHandler*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (self->cancellable);
	self->cancellable = _tmp0_;
	return self;
}


RygelHTTPGetHandler* rygel_http_get_handler_new (GCancellable* cancellable) {
	return rygel_http_get_handler_construct (RYGEL_TYPE_HTTP_GET_HANDLER, cancellable);
}


static void rygel_http_get_handler_class_init (RygelHTTPGetHandlerClass * klass) {
	rygel_http_get_handler_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_http_get_handler_finalize;
}


static void rygel_http_get_handler_instance_init (RygelHTTPGetHandler * self) {
}


static void rygel_http_get_handler_finalize (GObject* obj) {
	RygelHTTPGetHandler * self;
	self = RYGEL_HTTP_GET_HANDLER (obj);
	_g_object_unref0 (self->cancellable);
	G_OBJECT_CLASS (rygel_http_get_handler_parent_class)->finalize (obj);
}


GType rygel_http_get_handler_get_type (void) {
	static volatile gsize rygel_http_get_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_get_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPGetHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_get_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPGetHandler), 0, (GInstanceInitFunc) rygel_http_get_handler_instance_init, NULL };
		GType rygel_http_get_handler_type_id;
		rygel_http_get_handler_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPGetHandler", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_get_handler_type_id__volatile, rygel_http_get_handler_type_id);
	}
	return rygel_http_get_handler_type_id__volatile;
}


static inline void _dynamic_set_sizetype0 (GstElement* obj, gint value) {
	g_object_set (obj, "sizetype", value, NULL);
}


RygelMediaItem* rygel_media_item_construct (GType object_type) {
	RygelMediaItem* self = NULL;
	GstElement* _tmp0_ = NULL;
	GstElement* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelMediaItem*) g_type_create_instance (object_type);
	_tmp0_ = rygel_gst_utils_create_element ("fakesrc", NULL, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_gst_object_unref0 (self->priv->src);
	self->priv->src = _tmp1_;
	_dynamic_set_sizetype0 (self->priv->src, 2);
	return self;
}


RygelMediaItem* rygel_media_item_new (void) {
	return rygel_media_item_construct (RYGEL_TYPE_MEDIA_ITEM);
}


static inline void _dynamic_set_blocksize1 (GstElement* obj, glong value) {
	g_object_set (obj, "blocksize", value, NULL);
}


static inline void _dynamic_set_num_buffers2 (GstElement* obj, glong value) {
	g_object_set (obj, "num-buffers", value, NULL);
}


static inline void _dynamic_set_sizemax3 (GstElement* obj, glong value) {
	g_object_set (obj, "sizemax", value, NULL);
}


RygelMediaItem* rygel_media_item_construct_fixed_size (GType object_type) {
	RygelMediaItem* self = NULL;
	self = (RygelMediaItem*) g_type_create_instance (object_type);
	self = (RygelMediaItem*) rygel_media_item_construct (object_type);
	_dynamic_set_blocksize1 (self->priv->src, RYGEL_MEDIA_ITEM_BLOCK_SIZE);
	_dynamic_set_num_buffers2 (self->priv->src, RYGEL_MEDIA_ITEM_MAX_BUFFERS);
	_dynamic_set_sizemax3 (self->priv->src, RYGEL_MEDIA_ITEM_MAX_BUFFERS * RYGEL_MEDIA_ITEM_BLOCK_SIZE);
	return self;
}


RygelMediaItem* rygel_media_item_new_fixed_size (void) {
	return rygel_media_item_construct_fixed_size (RYGEL_TYPE_MEDIA_ITEM);
}


static gpointer _gst_object_ref0 (gpointer self) {
	return self ? gst_object_ref (self) : NULL;
}


GstElement* rygel_media_item_create_stream_source (RygelMediaItem* self) {
	GstElement* result = NULL;
	GstElement* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _gst_object_ref0 (self->priv->src);
	result = _tmp0_;
	return result;
}


static inline GstElement* _dynamic_get_num_buffers4 (GstElement* obj) {
	GstElement* result;
	g_object_get (obj, "num-buffers", &result, NULL);
	return result;
}


gboolean rygel_media_item_is_live_stream (RygelMediaItem* self) {
	gboolean result = FALSE;
	GstElement* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = _dynamic_get_num_buffers4 (self->priv->src);
	result = ((gint) _tmp0_) < 0;
	return result;
}


gint64 rygel_media_item_get_size (RygelMediaItem* self) {
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = (gint64) (RYGEL_MEDIA_ITEM_MAX_BUFFERS * RYGEL_MEDIA_ITEM_BLOCK_SIZE);
	return result;
}


static void rygel_value_media_item_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_value_media_item_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_media_item_unref (value->data[0].v_pointer);
	}
}


static void rygel_value_media_item_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_media_item_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_value_media_item_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_value_media_item_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelMediaItem* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_media_item_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_value_media_item_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelMediaItem** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_media_item_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_param_spec_media_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecMediaItem* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_MEDIA_ITEM), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_value_get_media_item (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_MEDIA_ITEM), NULL);
	return value->data[0].v_pointer;
}


void rygel_value_set_media_item (GValue* value, gpointer v_object) {
	RygelMediaItem* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_MEDIA_ITEM));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_MEDIA_ITEM));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_media_item_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_media_item_unref (old);
	}
}


void rygel_value_take_media_item (GValue* value, gpointer v_object) {
	RygelMediaItem* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_MEDIA_ITEM));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_MEDIA_ITEM));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_media_item_unref (old);
	}
}


static void rygel_media_item_class_init (RygelMediaItemClass * klass) {
	rygel_media_item_parent_class = g_type_class_peek_parent (klass);
	RYGEL_MEDIA_ITEM_CLASS (klass)->finalize = rygel_media_item_finalize;
	g_type_class_add_private (klass, sizeof (RygelMediaItemPrivate));
}


static void rygel_media_item_instance_init (RygelMediaItem * self) {
	self->priv = RYGEL_MEDIA_ITEM_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void rygel_media_item_finalize (RygelMediaItem* obj) {
	RygelMediaItem * self;
	self = RYGEL_MEDIA_ITEM (obj);
	_gst_object_unref0 (self->priv->src);
}


GType rygel_media_item_get_type (void) {
	static volatile gsize rygel_media_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_item_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_media_item_init, rygel_value_media_item_free_value, rygel_value_media_item_copy_value, rygel_value_media_item_peek_pointer, "p", rygel_value_media_item_collect_value, "p", rygel_value_media_item_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaItem), 0, (GInstanceInitFunc) rygel_media_item_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_media_item_type_id;
		rygel_media_item_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelMediaItem", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_media_item_type_id__volatile, rygel_media_item_type_id);
	}
	return rygel_media_item_type_id__volatile;
}


gpointer rygel_media_item_ref (gpointer instance) {
	RygelMediaItem* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_media_item_unref (gpointer instance) {
	RygelMediaItem* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_MEDIA_ITEM_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



