/* rygel-environment-config.c generated by valac 0.12.0, the Vala compiler
 * generated from rygel-environment-config.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Nokia Corporation.
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;

#define RYGEL_TYPE_ENVIRONMENT_CONFIG (rygel_environment_config_get_type ())
#define RYGEL_ENVIRONMENT_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ENVIRONMENT_CONFIG, RygelEnvironmentConfig))
#define RYGEL_ENVIRONMENT_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ENVIRONMENT_CONFIG, RygelEnvironmentConfigClass))
#define RYGEL_IS_ENVIRONMENT_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ENVIRONMENT_CONFIG))
#define RYGEL_IS_ENVIRONMENT_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ENVIRONMENT_CONFIG))
#define RYGEL_ENVIRONMENT_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ENVIRONMENT_CONFIG, RygelEnvironmentConfigClass))

typedef struct _RygelEnvironmentConfig RygelEnvironmentConfig;
typedef struct _RygelEnvironmentConfigClass RygelEnvironmentConfigClass;
typedef struct _RygelEnvironmentConfigPrivate RygelEnvironmentConfigPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gboolean (*get_upnp_enabled) (RygelConfiguration* self, GError** error);
	gchar* (*get_interface) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp3_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp2ts_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_lpcm_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_wmv_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_upload) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_deletion) (RygelConfiguration* self, GError** error);
	gchar* (*get_log_levels) (RygelConfiguration* self, GError** error);
	gchar* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_title) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_string) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
};

struct _RygelEnvironmentConfig {
	GObject parent_instance;
	RygelEnvironmentConfigPrivate * priv;
};

struct _RygelEnvironmentConfigClass {
	GObjectClass parent_class;
};

typedef enum  {
	RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET,
	RYGEL_CONFIGURATION_ERROR_VALUE_OUT_OF_RANGE
} RygelConfigurationError;
#define RYGEL_CONFIGURATION_ERROR rygel_configuration_error_quark ()

static gpointer rygel_environment_config_parent_class = NULL;
static gchar* rygel_environment_config_RYGEL_PREFIX;
static gchar* rygel_environment_config_RYGEL_PREFIX = NULL;
static gchar* rygel_environment_config_TITLE_KEY;
static gchar* rygel_environment_config_TITLE_KEY = NULL;
static gchar* rygel_environment_config_DISABLE_PREFIX;
static gchar* rygel_environment_config_DISABLE_PREFIX = NULL;
static gchar* rygel_environment_config_ENABLED_KEY;
static gchar* rygel_environment_config_ENABLED_KEY = NULL;
static gchar* rygel_environment_config_INTERFACE_ENV;
static gchar* rygel_environment_config_INTERFACE_ENV = NULL;
static gchar* rygel_environment_config_PORT_ENV;
static gchar* rygel_environment_config_PORT_ENV = NULL;
static gchar* rygel_environment_config_DISABLE_UPNP_ENV;
static gchar* rygel_environment_config_DISABLE_UPNP_ENV = NULL;
static gchar* rygel_environment_config_TRANSCODING_ENV;
static gchar* rygel_environment_config_TRANSCODING_ENV = NULL;
static gchar* rygel_environment_config_MP3_TRANSCODING_ENV;
static gchar* rygel_environment_config_MP3_TRANSCODING_ENV = NULL;
static gchar* rygel_environment_config_LPCM_TRANSCODING_ENV;
static gchar* rygel_environment_config_LPCM_TRANSCODING_ENV = NULL;
static gchar* rygel_environment_config_MP2TS_TRANSCODING_ENV;
static gchar* rygel_environment_config_MP2TS_TRANSCODING_ENV = NULL;
static gchar* rygel_environment_config_WMV_TRANSCODING_ENV;
static gchar* rygel_environment_config_WMV_TRANSCODING_ENV = NULL;
static gchar* rygel_environment_config_DISALLOW_UPLOAD_ENV;
static gchar* rygel_environment_config_DISALLOW_UPLOAD_ENV = NULL;
static gchar* rygel_environment_config_DISALLOW_DELETION_ENV;
static gchar* rygel_environment_config_DISALLOW_DELETION_ENV = NULL;
static gchar* rygel_environment_config_LOG_LEVELS_ENV;
static gchar* rygel_environment_config_LOG_LEVELS_ENV = NULL;
static gchar* rygel_environment_config_PLUGIN_PATH_ENV;
static gchar* rygel_environment_config_PLUGIN_PATH_ENV = NULL;
static RygelEnvironmentConfig* rygel_environment_config_config;
static RygelEnvironmentConfig* rygel_environment_config_config = NULL;
static RygelConfigurationIface* rygel_environment_config_rygel_configuration_parent_iface = NULL;

GType rygel_configuration_get_type (void) G_GNUC_CONST;
GType rygel_environment_config_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_ENVIRONMENT_CONFIG_DUMMY_PROPERTY
};
RygelEnvironmentConfig* rygel_environment_config_get_default (void);
RygelEnvironmentConfig* rygel_environment_config_new (void);
RygelEnvironmentConfig* rygel_environment_config_construct (GType object_type);
static gboolean rygel_environment_config_real_get_upnp_enabled (RygelConfiguration* base, GError** error);
static gboolean rygel_environment_config_get_bool_variable (RygelEnvironmentConfig* self, const gchar* variable, GError** error);
static gchar* rygel_environment_config_real_get_interface (RygelConfiguration* base, GError** error);
static gchar* rygel_environment_config_get_string_variable (RygelEnvironmentConfig* self, const gchar* variable, GError** error);
static gint rygel_environment_config_real_get_port (RygelConfiguration* base, GError** error);
static gint rygel_environment_config_get_int_variable (RygelEnvironmentConfig* self, const gchar* variable, gint min, gint max, GError** error);
static gboolean rygel_environment_config_real_get_transcoding (RygelConfiguration* base, GError** error);
static gboolean rygel_environment_config_real_get_mp3_transcoder (RygelConfiguration* base, GError** error);
static gboolean rygel_environment_config_real_get_mp2ts_transcoder (RygelConfiguration* base, GError** error);
static gboolean rygel_environment_config_real_get_wmv_transcoder (RygelConfiguration* base, GError** error);
static gboolean rygel_environment_config_real_get_lpcm_transcoder (RygelConfiguration* base, GError** error);
static gboolean rygel_environment_config_real_get_allow_upload (RygelConfiguration* base, GError** error);
static gboolean rygel_environment_config_real_get_allow_deletion (RygelConfiguration* base, GError** error);
static gchar* rygel_environment_config_real_get_log_levels (RygelConfiguration* base, GError** error);
static gchar* rygel_environment_config_real_get_plugin_path (RygelConfiguration* base, GError** error);
static gboolean rygel_environment_config_real_get_enabled (RygelConfiguration* base, const gchar* section, GError** error);
gboolean rygel_configuration_get_bool (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
static gchar* rygel_environment_config_real_get_title (RygelConfiguration* base, const gchar* section, GError** error);
gchar* rygel_configuration_get_string (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
static gchar* rygel_environment_config_real_get_string (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error);
static GeeArrayList* rygel_environment_config_real_get_string_list (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error);
static gint rygel_environment_config_real_get_int (RygelConfiguration* base, const gchar* section, const gchar* key, gint min, gint max, GError** error);
static GeeArrayList* rygel_environment_config_real_get_int_list (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error);
static gboolean rygel_environment_config_real_get_bool (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error);
GQuark rygel_configuration_error_quark (void);
static void rygel_environment_config_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelEnvironmentConfig* rygel_environment_config_get_default (void) {
	RygelEnvironmentConfig* result = NULL;
	RygelEnvironmentConfig* _tmp1_;
	if (rygel_environment_config_config == NULL) {
		RygelEnvironmentConfig* _tmp0_ = NULL;
		_tmp0_ = rygel_environment_config_new ();
		_g_object_unref0 (rygel_environment_config_config);
		rygel_environment_config_config = _tmp0_;
	}
	_tmp1_ = _g_object_ref0 (rygel_environment_config_config);
	result = _tmp1_;
	return result;
}


static gboolean rygel_environment_config_real_get_upnp_enabled (RygelConfiguration* base, GError** error) {
	RygelEnvironmentConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelEnvironmentConfig*) base;
	_tmp0_ = rygel_environment_config_get_bool_variable (self, rygel_environment_config_DISABLE_UPNP_ENV, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = !_tmp1_;
	return result;
}


static gchar* rygel_environment_config_real_get_interface (RygelConfiguration* base, GError** error) {
	RygelEnvironmentConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelEnvironmentConfig*) base;
	_tmp0_ = rygel_environment_config_get_string_variable (self, rygel_environment_config_INTERFACE_ENV, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = _tmp1_;
	return result;
}


static gint rygel_environment_config_real_get_port (RygelConfiguration* base, GError** error) {
	RygelEnvironmentConfig * self;
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelEnvironmentConfig*) base;
	_tmp0_ = rygel_environment_config_get_int_variable (self, rygel_environment_config_PORT_ENV, 0, (gint) G_MAXINT16, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return 0;
	}
	result = _tmp1_;
	return result;
}


static gboolean rygel_environment_config_real_get_transcoding (RygelConfiguration* base, GError** error) {
	RygelEnvironmentConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelEnvironmentConfig*) base;
	_tmp0_ = rygel_environment_config_get_bool_variable (self, rygel_environment_config_TRANSCODING_ENV, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = !_tmp1_;
	return result;
}


static gboolean rygel_environment_config_real_get_mp3_transcoder (RygelConfiguration* base, GError** error) {
	RygelEnvironmentConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelEnvironmentConfig*) base;
	_tmp0_ = rygel_environment_config_get_bool_variable (self, rygel_environment_config_MP3_TRANSCODING_ENV, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = !_tmp1_;
	return result;
}


static gboolean rygel_environment_config_real_get_mp2ts_transcoder (RygelConfiguration* base, GError** error) {
	RygelEnvironmentConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelEnvironmentConfig*) base;
	_tmp0_ = rygel_environment_config_get_bool_variable (self, rygel_environment_config_MP2TS_TRANSCODING_ENV, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = !_tmp1_;
	return result;
}


static gboolean rygel_environment_config_real_get_wmv_transcoder (RygelConfiguration* base, GError** error) {
	RygelEnvironmentConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelEnvironmentConfig*) base;
	_tmp0_ = rygel_environment_config_get_bool_variable (self, rygel_environment_config_WMV_TRANSCODING_ENV, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = !_tmp1_;
	return result;
}


static gboolean rygel_environment_config_real_get_lpcm_transcoder (RygelConfiguration* base, GError** error) {
	RygelEnvironmentConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelEnvironmentConfig*) base;
	_tmp0_ = rygel_environment_config_get_bool_variable (self, rygel_environment_config_LPCM_TRANSCODING_ENV, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = !_tmp1_;
	return result;
}


static gboolean rygel_environment_config_real_get_allow_upload (RygelConfiguration* base, GError** error) {
	RygelEnvironmentConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelEnvironmentConfig*) base;
	_tmp0_ = rygel_environment_config_get_bool_variable (self, rygel_environment_config_DISALLOW_UPLOAD_ENV, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = !_tmp1_;
	return result;
}


static gboolean rygel_environment_config_real_get_allow_deletion (RygelConfiguration* base, GError** error) {
	RygelEnvironmentConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelEnvironmentConfig*) base;
	_tmp0_ = rygel_environment_config_get_bool_variable (self, rygel_environment_config_DISALLOW_DELETION_ENV, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = !_tmp1_;
	return result;
}


static gchar* rygel_environment_config_real_get_log_levels (RygelConfiguration* base, GError** error) {
	RygelEnvironmentConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelEnvironmentConfig*) base;
	_tmp0_ = rygel_environment_config_get_string_variable (self, rygel_environment_config_LOG_LEVELS_ENV, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = _tmp1_;
	return result;
}


static gchar* rygel_environment_config_real_get_plugin_path (RygelConfiguration* base, GError** error) {
	RygelEnvironmentConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelEnvironmentConfig*) base;
	_tmp0_ = rygel_environment_config_get_string_variable (self, rygel_environment_config_PLUGIN_PATH_ENV, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = _tmp1_;
	return result;
}


static gboolean rygel_environment_config_real_get_enabled (RygelConfiguration* base, const gchar* section, GError** error) {
	RygelEnvironmentConfig * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	self = (RygelEnvironmentConfig*) base;
	g_return_val_if_fail (section != NULL, FALSE);
	_tmp0_ = rygel_configuration_get_bool ((RygelConfiguration*) self, section, rygel_environment_config_ENABLED_KEY, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp1_;
	return result;
}


static gchar* rygel_environment_config_real_get_title (RygelConfiguration* base, const gchar* section, GError** error) {
	RygelEnvironmentConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GError * _inner_error_ = NULL;
	self = (RygelEnvironmentConfig*) base;
	g_return_val_if_fail (section != NULL, NULL);
	_tmp0_ = g_strconcat (rygel_environment_config_RYGEL_PREFIX, "_", NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, section, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = rygel_configuration_get_string ((RygelConfiguration*) self, _tmp3_, rygel_environment_config_TITLE_KEY, &_inner_error_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp6_ = _tmp5_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = _tmp6_;
	return result;
}


static gchar* rygel_environment_config_real_get_string (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error) {
	RygelEnvironmentConfig * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GError * _inner_error_ = NULL;
	self = (RygelEnvironmentConfig*) base;
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = g_strconcat (rygel_environment_config_RYGEL_PREFIX, "_", NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_utf8_strup (section, (gssize) (-1));
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp1_, _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp5_, "_", NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_utf8_strup (key, (gssize) (-1));
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp7_, _tmp9_, NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = rygel_environment_config_get_string_variable (self, _tmp11_, &_inner_error_);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp14_ = _tmp13_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = _tmp14_;
	return result;
}


static GeeArrayList* rygel_environment_config_real_get_string_list (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error) {
	RygelEnvironmentConfig * self;
	GeeArrayList* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* str;
	GeeArrayList* _tmp1_ = NULL;
	GeeArrayList* value;
	gchar** _tmp2_;
	gchar** _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelEnvironmentConfig*) base;
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = rygel_configuration_get_string ((RygelConfiguration*) self, section, key, &_inner_error_);
	str = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	value = _tmp1_;
	_tmp3_ = _tmp2_ = g_strsplit (str, ",", -1);
	{
		gchar** token_collection;
		int token_collection_length1;
		int token_it;
		token_collection = _tmp3_;
		token_collection_length1 = _vala_array_length (_tmp2_);
		for (token_it = 0; token_it < _vala_array_length (_tmp2_); token_it = token_it + 1) {
			gchar* _tmp4_;
			gchar* token;
			_tmp4_ = g_strdup (token_collection[token_it]);
			token = _tmp4_;
			{
				gee_abstract_collection_add ((GeeAbstractCollection*) value, token);
				_g_free0 (token);
			}
		}
		token_collection = (_vala_array_free (token_collection, token_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	result = value;
	_g_free0 (str);
	return result;
}


static gint rygel_environment_config_real_get_int (RygelConfiguration* base, const gchar* section, const gchar* key, gint min, gint max, GError** error) {
	RygelEnvironmentConfig * self;
	gint result = 0;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	GError * _inner_error_ = NULL;
	self = (RygelEnvironmentConfig*) base;
	g_return_val_if_fail (section != NULL, 0);
	g_return_val_if_fail (key != NULL, 0);
	_tmp0_ = g_strconcat (rygel_environment_config_RYGEL_PREFIX, "_", NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_utf8_strup (section, (gssize) (-1));
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp1_, _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp5_, "_", NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, key, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = rygel_environment_config_get_int_variable (self, _tmp9_, min, max, &_inner_error_);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp12_ = _tmp11_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return 0;
	}
	result = _tmp12_;
	return result;
}


static GeeArrayList* rygel_environment_config_real_get_int_list (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error) {
	RygelEnvironmentConfig * self;
	GeeArrayList* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* str;
	GeeArrayList* _tmp1_ = NULL;
	GeeArrayList* value;
	gchar** _tmp2_;
	gchar** _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelEnvironmentConfig*) base;
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = rygel_configuration_get_string ((RygelConfiguration*) self, section, key, &_inner_error_);
	str = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp1_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL);
	value = _tmp1_;
	_tmp3_ = _tmp2_ = g_strsplit (str, ",", -1);
	{
		gchar** token_collection;
		int token_collection_length1;
		int token_it;
		token_collection = _tmp3_;
		token_collection_length1 = _vala_array_length (_tmp2_);
		for (token_it = 0; token_it < _vala_array_length (_tmp2_); token_it = token_it + 1) {
			gchar* _tmp4_;
			gchar* token;
			_tmp4_ = g_strdup (token_collection[token_it]);
			token = _tmp4_;
			{
				gint _tmp5_;
				_tmp5_ = atoi (token);
				gee_abstract_collection_add ((GeeAbstractCollection*) value, GINT_TO_POINTER (_tmp5_));
				_g_free0 (token);
			}
		}
		token_collection = (_vala_array_free (token_collection, token_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	result = value;
	_g_free0 (str);
	return result;
}


static gboolean rygel_environment_config_real_get_bool (RygelConfiguration* base, const gchar* section, const gchar* key, GError** error) {
	RygelEnvironmentConfig * self;
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	GError * _inner_error_ = NULL;
	self = (RygelEnvironmentConfig*) base;
	g_return_val_if_fail (section != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = g_strconcat (rygel_environment_config_RYGEL_PREFIX, "_", NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_utf8_strup (section, (gssize) (-1));
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp1_, _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp5_, "_", NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, key, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = rygel_environment_config_get_bool_variable (self, _tmp9_, &_inner_error_);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp12_ = _tmp11_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp12_;
	return result;
}


static gchar* rygel_environment_config_get_string_variable (RygelEnvironmentConfig* self, const gchar* variable, GError** error) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* str;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (variable != NULL, NULL);
	_tmp0_ = g_getenv (variable);
	_tmp1_ = g_strdup (_tmp0_);
	str = _tmp1_;
	if (str == NULL) {
		GError* _tmp2_ = NULL;
		_tmp2_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, "No value available");
		_inner_error_ = _tmp2_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (str);
		return NULL;
	}
	result = str;
	return result;
}


static gint rygel_environment_config_get_int_variable (RygelEnvironmentConfig* self, const gchar* variable, gint min, gint max, GError** error) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* val;
	gint _tmp3_;
	gint _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (variable != NULL, 0);
	_tmp0_ = g_getenv (variable);
	_tmp1_ = g_strdup (_tmp0_);
	val = _tmp1_;
	if (val == NULL) {
		GError* _tmp2_ = NULL;
		_tmp2_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, "No value available");
		_inner_error_ = _tmp2_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (val);
		return 0;
	}
	_tmp3_ = atoi (val);
	_tmp4_ = CLAMP (_tmp3_, min, max);
	result = _tmp4_;
	_g_free0 (val);
	return result;
}


static gboolean rygel_environment_config_get_bool_variable (RygelEnvironmentConfig* self, const gchar* variable, GError** error) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* enabled;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (variable != NULL, FALSE);
	_tmp0_ = g_getenv (variable);
	_tmp1_ = g_strdup (_tmp0_);
	enabled = _tmp1_;
	if (enabled == NULL) {
		GError* _tmp2_ = NULL;
		_tmp2_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, "No value available");
		_inner_error_ = _tmp2_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (enabled);
		return FALSE;
	}
	result = TRUE;
	_g_free0 (enabled);
	return result;
}


RygelEnvironmentConfig* rygel_environment_config_construct (GType object_type) {
	RygelEnvironmentConfig * self = NULL;
	self = (RygelEnvironmentConfig*) g_object_new (object_type, NULL);
	return self;
}


RygelEnvironmentConfig* rygel_environment_config_new (void) {
	return rygel_environment_config_construct (RYGEL_TYPE_ENVIRONMENT_CONFIG);
}


static void rygel_environment_config_class_init (RygelEnvironmentConfigClass * klass) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	rygel_environment_config_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_environment_config_finalize;
	_tmp0_ = g_strdup ("RYGEL");
	rygel_environment_config_RYGEL_PREFIX = _tmp0_;
	_tmp1_ = g_strconcat (rygel_environment_config_RYGEL_PREFIX, "_TITLE", NULL);
	rygel_environment_config_TITLE_KEY = _tmp1_;
	_tmp2_ = g_strconcat (rygel_environment_config_RYGEL_PREFIX, "_DISABLE", NULL);
	rygel_environment_config_DISABLE_PREFIX = _tmp2_;
	_tmp3_ = g_strdup ("ENABLED");
	rygel_environment_config_ENABLED_KEY = _tmp3_;
	_tmp4_ = g_strconcat (rygel_environment_config_RYGEL_PREFIX, "_IFACE", NULL);
	rygel_environment_config_INTERFACE_ENV = _tmp4_;
	_tmp5_ = g_strconcat (rygel_environment_config_RYGEL_PREFIX, "_PORT", NULL);
	rygel_environment_config_PORT_ENV = _tmp5_;
	_tmp6_ = g_strconcat (rygel_environment_config_DISABLE_PREFIX, "_UPNP", NULL);
	rygel_environment_config_DISABLE_UPNP_ENV = _tmp6_;
	_tmp7_ = g_strconcat (rygel_environment_config_DISABLE_PREFIX, "_TRANSCODING", NULL);
	rygel_environment_config_TRANSCODING_ENV = _tmp7_;
	_tmp8_ = g_strconcat (rygel_environment_config_DISABLE_PREFIX, "_MP3_TRANS", NULL);
	rygel_environment_config_MP3_TRANSCODING_ENV = _tmp8_;
	_tmp9_ = g_strconcat (rygel_environment_config_DISABLE_PREFIX, "_LPCM_TRANS", NULL);
	rygel_environment_config_LPCM_TRANSCODING_ENV = _tmp9_;
	_tmp10_ = g_strconcat (rygel_environment_config_DISABLE_PREFIX, "_MP2TS_TRANS", NULL);
	rygel_environment_config_MP2TS_TRANSCODING_ENV = _tmp10_;
	_tmp11_ = g_strconcat (rygel_environment_config_DISABLE_PREFIX, "_WMV_TRANS", NULL);
	rygel_environment_config_WMV_TRANSCODING_ENV = _tmp11_;
	_tmp12_ = g_strconcat (rygel_environment_config_DISABLE_PREFIX, "_UPLOAD", NULL);
	rygel_environment_config_DISALLOW_UPLOAD_ENV = _tmp12_;
	_tmp13_ = g_strconcat (rygel_environment_config_DISABLE_PREFIX, "_DELETION", NULL);
	rygel_environment_config_DISALLOW_DELETION_ENV = _tmp13_;
	_tmp14_ = g_strconcat (rygel_environment_config_RYGEL_PREFIX, "_LOG", NULL);
	rygel_environment_config_LOG_LEVELS_ENV = _tmp14_;
	_tmp15_ = g_strconcat (rygel_environment_config_RYGEL_PREFIX, "_PLUGIN_PATH", NULL);
	rygel_environment_config_PLUGIN_PATH_ENV = _tmp15_;
}


static void rygel_environment_config_rygel_configuration_interface_init (RygelConfigurationIface * iface) {
	rygel_environment_config_rygel_configuration_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_upnp_enabled = (gboolean (*)(RygelConfiguration* ,GError**)) rygel_environment_config_real_get_upnp_enabled;
	iface->get_interface = (gchar* (*)(RygelConfiguration* ,GError**)) rygel_environment_config_real_get_interface;
	iface->get_port = (gint (*)(RygelConfiguration* ,GError**)) rygel_environment_config_real_get_port;
	iface->get_transcoding = (gboolean (*)(RygelConfiguration* ,GError**)) rygel_environment_config_real_get_transcoding;
	iface->get_mp3_transcoder = (gboolean (*)(RygelConfiguration* ,GError**)) rygel_environment_config_real_get_mp3_transcoder;
	iface->get_mp2ts_transcoder = (gboolean (*)(RygelConfiguration* ,GError**)) rygel_environment_config_real_get_mp2ts_transcoder;
	iface->get_wmv_transcoder = (gboolean (*)(RygelConfiguration* ,GError**)) rygel_environment_config_real_get_wmv_transcoder;
	iface->get_lpcm_transcoder = (gboolean (*)(RygelConfiguration* ,GError**)) rygel_environment_config_real_get_lpcm_transcoder;
	iface->get_allow_upload = (gboolean (*)(RygelConfiguration* ,GError**)) rygel_environment_config_real_get_allow_upload;
	iface->get_allow_deletion = (gboolean (*)(RygelConfiguration* ,GError**)) rygel_environment_config_real_get_allow_deletion;
	iface->get_log_levels = (gchar* (*)(RygelConfiguration* ,GError**)) rygel_environment_config_real_get_log_levels;
	iface->get_plugin_path = (gchar* (*)(RygelConfiguration* ,GError**)) rygel_environment_config_real_get_plugin_path;
	iface->get_enabled = (gboolean (*)(RygelConfiguration* ,const gchar* ,GError**)) rygel_environment_config_real_get_enabled;
	iface->get_title = (gchar* (*)(RygelConfiguration* ,const gchar* ,GError**)) rygel_environment_config_real_get_title;
	iface->get_string = (gchar* (*)(RygelConfiguration* ,const gchar* ,const gchar* ,GError**)) rygel_environment_config_real_get_string;
	iface->get_string_list = (GeeArrayList* (*)(RygelConfiguration* ,const gchar* ,const gchar* ,GError**)) rygel_environment_config_real_get_string_list;
	iface->get_int = (gint (*)(RygelConfiguration* ,const gchar* ,const gchar* ,gint ,gint ,GError**)) rygel_environment_config_real_get_int;
	iface->get_int_list = (GeeArrayList* (*)(RygelConfiguration* ,const gchar* ,const gchar* ,GError**)) rygel_environment_config_real_get_int_list;
	iface->get_bool = (gboolean (*)(RygelConfiguration* ,const gchar* ,const gchar* ,GError**)) rygel_environment_config_real_get_bool;
}


static void rygel_environment_config_instance_init (RygelEnvironmentConfig * self) {
}


static void rygel_environment_config_finalize (GObject* obj) {
	RygelEnvironmentConfig * self;
	self = RYGEL_ENVIRONMENT_CONFIG (obj);
	G_OBJECT_CLASS (rygel_environment_config_parent_class)->finalize (obj);
}


/**
 * Manages configuration from Environment.
 */
GType rygel_environment_config_get_type (void) {
	static volatile gsize rygel_environment_config_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_environment_config_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelEnvironmentConfigClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_environment_config_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelEnvironmentConfig), 0, (GInstanceInitFunc) rygel_environment_config_instance_init, NULL };
		static const GInterfaceInfo rygel_configuration_info = { (GInterfaceInitFunc) rygel_environment_config_rygel_configuration_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_environment_config_type_id;
		rygel_environment_config_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelEnvironmentConfig", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_environment_config_type_id, RYGEL_TYPE_CONFIGURATION, &rygel_configuration_info);
		g_once_init_leave (&rygel_environment_config_type_id__volatile, rygel_environment_config_type_id);
	}
	return rygel_environment_config_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



