/* rygel-tracker-metadata-values.c generated by valac 0.12.0, the Vala compiler
 * generated from rygel-tracker-metadata-values.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008 Nokia Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gee.h>


#define RYGEL_TRACKER_TYPE_METADATA_VALUES (rygel_tracker_metadata_values_get_type ())
#define RYGEL_TRACKER_METADATA_VALUES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_METADATA_VALUES, RygelTrackerMetadataValues))
#define RYGEL_TRACKER_METADATA_VALUES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_METADATA_VALUES, RygelTrackerMetadataValuesClass))
#define RYGEL_TRACKER_IS_METADATA_VALUES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_METADATA_VALUES))
#define RYGEL_TRACKER_IS_METADATA_VALUES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_METADATA_VALUES))
#define RYGEL_TRACKER_METADATA_VALUES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_METADATA_VALUES, RygelTrackerMetadataValuesClass))

typedef struct _RygelTrackerMetadataValues RygelTrackerMetadataValues;
typedef struct _RygelTrackerMetadataValuesClass RygelTrackerMetadataValuesClass;
typedef struct _RygelTrackerMetadataValuesPrivate RygelTrackerMetadataValuesPrivate;

#define RYGEL_TRACKER_TYPE_ITEM_FACTORY (rygel_tracker_item_factory_get_type ())
#define RYGEL_TRACKER_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactory))
#define RYGEL_TRACKER_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactoryClass))
#define RYGEL_TRACKER_IS_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY))
#define RYGEL_TRACKER_IS_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_ITEM_FACTORY))
#define RYGEL_TRACKER_ITEM_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactoryClass))

typedef struct _RygelTrackerItemFactory RygelTrackerItemFactory;
typedef struct _RygelTrackerItemFactoryClass RygelTrackerItemFactoryClass;

#define RYGEL_TRACKER_TYPE_RESOURCES_IFACE (rygel_tracker_resources_iface_get_type ())
#define RYGEL_TRACKER_RESOURCES_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_RESOURCES_IFACE, RygelTrackerResourcesIface))
#define RYGEL_TRACKER_IS_RESOURCES_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_RESOURCES_IFACE))
#define RYGEL_TRACKER_RESOURCES_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TRACKER_TYPE_RESOURCES_IFACE, RygelTrackerResourcesIfaceIface))

typedef struct _RygelTrackerResourcesIface RygelTrackerResourcesIface;
typedef struct _RygelTrackerResourcesIfaceIface RygelTrackerResourcesIfaceIface;

#define RYGEL_TRACKER_TYPE_RESOURCES_IFACE_PROXY (rygel_tracker_resources_iface_proxy_get_type ())
#define _rygel_tracker_item_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_item_factory_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TRACKER_TYPE_QUERY_TRIPLETS (rygel_tracker_query_triplets_get_type ())
#define RYGEL_TRACKER_QUERY_TRIPLETS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTriplets))
#define RYGEL_TRACKER_QUERY_TRIPLETS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTripletsClass))
#define RYGEL_TRACKER_IS_QUERY_TRIPLETS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS))
#define RYGEL_TRACKER_IS_QUERY_TRIPLETS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS))
#define RYGEL_TRACKER_QUERY_TRIPLETS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTripletsClass))

typedef struct _RygelTrackerQueryTriplets RygelTrackerQueryTriplets;
typedef struct _RygelTrackerQueryTripletsClass RygelTrackerQueryTripletsClass;
typedef struct _RygelTrackerItemFactoryPrivate RygelTrackerItemFactoryPrivate;

#define RYGEL_TRACKER_TYPE_SEARCH_CONTAINER (rygel_tracker_search_container_get_type ())
#define RYGEL_TRACKER_SEARCH_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainer))
#define RYGEL_TRACKER_SEARCH_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainerClass))
#define RYGEL_TRACKER_IS_SEARCH_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER))
#define RYGEL_TRACKER_IS_SEARCH_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER))
#define RYGEL_TRACKER_SEARCH_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainerClass))

typedef struct _RygelTrackerSearchContainer RygelTrackerSearchContainer;
typedef struct _RygelTrackerSearchContainerClass RygelTrackerSearchContainerClass;

#define RYGEL_TRACKER_TYPE_QUERY_TRIPLET (rygel_tracker_query_triplet_get_type ())
#define RYGEL_TRACKER_QUERY_TRIPLET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLET, RygelTrackerQueryTriplet))
#define RYGEL_TRACKER_QUERY_TRIPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLET, RygelTrackerQueryTripletClass))
#define RYGEL_TRACKER_IS_QUERY_TRIPLET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLET))
#define RYGEL_TRACKER_IS_QUERY_TRIPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLET))
#define RYGEL_TRACKER_QUERY_TRIPLET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLET, RygelTrackerQueryTripletClass))

typedef struct _RygelTrackerQueryTriplet RygelTrackerQueryTriplet;
typedef struct _RygelTrackerQueryTripletClass RygelTrackerQueryTripletClass;
#define _rygel_tracker_query_triplet_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_query_triplet_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define RYGEL_TRACKER_TYPE_QUERY (rygel_tracker_query_get_type ())
#define RYGEL_TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQuery))
#define RYGEL_TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQueryClass))
#define RYGEL_TRACKER_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY))
#define RYGEL_TRACKER_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY))
#define RYGEL_TRACKER_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQueryClass))

typedef struct _RygelTrackerQuery RygelTrackerQuery;
typedef struct _RygelTrackerQueryClass RygelTrackerQueryClass;

#define RYGEL_TRACKER_TYPE_SELECTION_QUERY (rygel_tracker_selection_query_get_type ())
#define RYGEL_TRACKER_SELECTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQuery))
#define RYGEL_TRACKER_SELECTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQueryClass))
#define RYGEL_TRACKER_IS_SELECTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY))
#define RYGEL_TRACKER_IS_SELECTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_SELECTION_QUERY))
#define RYGEL_TRACKER_SELECTION_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQueryClass))

typedef struct _RygelTrackerSelectionQuery RygelTrackerSelectionQuery;
typedef struct _RygelTrackerSelectionQueryClass RygelTrackerSelectionQueryClass;
#define _rygel_tracker_query_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_query_unref (var), NULL)))
typedef struct _RygelTrackerQueryPrivate RygelTrackerQueryPrivate;
typedef struct _RygelTrackerSelectionQueryPrivate RygelTrackerSelectionQueryPrivate;
typedef struct _RygelTrackerQueryTripletPrivate RygelTrackerQueryTripletPrivate;
typedef struct _RygelTrackerMetadataValuesFetchMetadataValuesData RygelTrackerMetadataValuesFetchMetadataValuesData;
typedef struct _RygelTrackerMetadataValuesFindObjectData RygelTrackerMetadataValuesFindObjectData;

struct _RygelTrackerMetadataValues {
	RygelSimpleContainer parent_instance;
	RygelTrackerMetadataValuesPrivate * priv;
	gchar** key_chain;
	gint key_chain_length1;
};

struct _RygelTrackerMetadataValuesClass {
	RygelSimpleContainerClass parent_class;
	gchar* (*create_id_for_title) (RygelTrackerMetadataValues* self, const gchar* title);
	gchar* (*create_title_for_value) (RygelTrackerMetadataValues* self, const gchar* value);
	gchar* (*create_filter) (RygelTrackerMetadataValues* self, const gchar* variable, const gchar* value);
};

struct _RygelTrackerResourcesIfaceIface {
	GTypeInterface parent_iface;
	void (*sparql_query) (RygelTrackerResourcesIface* self, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar** (*sparql_query_finish) (RygelTrackerResourcesIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
	void (*sparql_update) (RygelTrackerResourcesIface* self, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*sparql_update_finish) (RygelTrackerResourcesIface* self, GAsyncResult* _res_, GError** error);
	void (*sparql_update_blank) (RygelTrackerResourcesIface* self, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable** (*sparql_update_blank_finish) (RygelTrackerResourcesIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
};

struct _RygelTrackerMetadataValuesPrivate {
	RygelTrackerItemFactory* item_factory;
	gchar* child_class;
	RygelTrackerResourcesIface* resources;
};

struct _RygelTrackerItemFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerItemFactoryPrivate * priv;
	gchar* category;
	gchar* upnp_class;
	gchar* upload_dir;
	GeeArrayList* properties;
};

struct _RygelTrackerItemFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerItemFactory *self);
	RygelMediaItem* (*create) (RygelTrackerItemFactory* self, const gchar* id, const gchar* uri, RygelTrackerSearchContainer* parent, gchar** metadata, int metadata_length1, GError** error);
	void (*set_metadata) (RygelTrackerItemFactory* self, RygelMediaItem* item, const gchar* uri, gchar** metadata, int metadata_length1, GError** error);
};

struct _RygelTrackerQuery {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerQueryPrivate * priv;
	RygelTrackerQueryTriplets* triplets;
};

struct _RygelTrackerQueryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerQuery *self);
	void (*execute) (RygelTrackerQuery* self, RygelTrackerResourcesIface* resources, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*execute_finish) (RygelTrackerQuery* self, GAsyncResult* _res_, GError** error);
	gchar* (*to_string) (RygelTrackerQuery* self);
};

struct _RygelTrackerSelectionQuery {
	RygelTrackerQuery parent_instance;
	RygelTrackerSelectionQueryPrivate * priv;
	GeeArrayList* variables;
	GeeArrayList* filters;
	gchar* order_by;
	gint offset;
	gint max_count;
	gchar** result;
	gint result_length1;
	gint result_length2;
};

struct _RygelTrackerSelectionQueryClass {
	RygelTrackerQueryClass parent_class;
};

struct _RygelTrackerQueryTriplet {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerQueryTripletPrivate * priv;
	gchar* subject;
	gchar* predicate;
	gchar* obj;
	RygelTrackerQueryTriplet* next;
};

struct _RygelTrackerQueryTripletClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerQueryTriplet *self);
};

struct _RygelTrackerMetadataValuesFetchMetadataValuesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerMetadataValues* self;
	gint i;
	RygelTrackerQueryTriplets* _tmp0_;
	RygelTrackerQueryTriplets* triplets;
	RygelTrackerQueryTriplet* _tmp1_;
	RygelTrackerQueryTriplet* _tmp2_;
	gint num_keys;
	gchar** _tmp3_;
	gchar** variables;
	gint variables_length1;
	gint _variables_size_;
	gboolean _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* subject;
	gchar* _tmp9_;
	gchar* _tmp10_;
	RygelTrackerQueryTriplet* _tmp11_;
	RygelTrackerQueryTriplet* _tmp12_;
	GeeArrayList* _tmp13_;
	GeeArrayList* selected;
	gchar* _tmp14_;
	gchar* last_variable;
	gchar* _tmp15_;
	gchar* _tmp16_;
	RygelTrackerSelectionQuery* _tmp17_;
	RygelTrackerSelectionQuery* query;
	GError * _error_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gboolean _tmp21_;
	gchar* _tmp22_;
	gchar* value;
	gchar* _tmp23_;
	gchar* title;
	gchar* _tmp24_;
	gchar* id;
	gboolean _tmp25_;
	gboolean _tmp26_;
	RygelTrackerQueryTriplets* _tmp27_;
	RygelTrackerQueryTriplets* child_triplets;
	GeeArrayList* _tmp28_;
	GeeArrayList* filters;
	gpointer _tmp29_;
	RygelTrackerQueryTriplet* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* filter;
	RygelTrackerSearchContainer* _tmp33_;
	RygelTrackerSearchContainer* container;
	gchar* _tmp34_;
	GError * _inner_error_;
};

struct _RygelTrackerMetadataValuesFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerMetadataValues* self;
	gchar* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	gboolean _tmp0_;
	RygelMediaObject* _tmp1_;
	RygelMediaObject* _tmp2_;
	GError * _inner_error_;
};


static gpointer rygel_tracker_metadata_values_parent_class = NULL;

GType rygel_tracker_metadata_values_get_type (void) G_GNUC_CONST;
gpointer rygel_tracker_item_factory_ref (gpointer instance);
void rygel_tracker_item_factory_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_item_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_tracker_value_set_item_factory (GValue* value, gpointer v_object);
void rygel_tracker_value_take_item_factory (GValue* value, gpointer v_object);
gpointer rygel_tracker_value_get_item_factory (const GValue* value);
GType rygel_tracker_item_factory_get_type (void) G_GNUC_CONST;
GType rygel_tracker_resources_iface_proxy_get_type (void) G_GNUC_CONST;
guint rygel_tracker_resources_iface_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType rygel_tracker_resources_iface_get_type (void) G_GNUC_CONST;
#define RYGEL_TRACKER_METADATA_VALUES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TRACKER_TYPE_METADATA_VALUES, RygelTrackerMetadataValuesPrivate))
enum  {
	RYGEL_TRACKER_METADATA_VALUES_DUMMY_PROPERTY
};
#define RYGEL_TRACKER_METADATA_VALUES_TRACKER_SERVICE "org.freedesktop.Tracker1"
#define RYGEL_TRACKER_METADATA_VALUES_RESOURCES_PATH "/org/freedesktop/Tracker1/Resources"
RygelTrackerMetadataValues* rygel_tracker_metadata_values_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, RygelTrackerItemFactory* item_factory, gchar** key_chain, int key_chain_length1, const gchar* child_class);
static gchar** _vala_array_dup1 (gchar** self, int length);
static void rygel_tracker_metadata_values_create_proxies (RygelTrackerMetadataValues* self, GError** error);
static void rygel_tracker_metadata_values_fetch_metadata_values (RygelTrackerMetadataValues* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_tracker_metadata_values_fetch_metadata_values_finish (RygelTrackerMetadataValues* self, GAsyncResult* _res_);
static void rygel_tracker_metadata_values_fetch_metadata_values_data_free (gpointer _data);
static gboolean rygel_tracker_metadata_values_fetch_metadata_values_co (RygelTrackerMetadataValuesFetchMetadataValuesData* data);
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_new (void);
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_construct (GType object_type);
GType rygel_tracker_query_triplets_get_type (void) G_GNUC_CONST;
#define RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE "?item"
GType rygel_tracker_search_container_get_type (void) G_GNUC_CONST;
RygelTrackerQueryTriplet* rygel_tracker_query_triplet_new (const gchar* subject, const gchar* predicate, const gchar* obj);
RygelTrackerQueryTriplet* rygel_tracker_query_triplet_construct (GType object_type, const gchar* subject, const gchar* predicate, const gchar* obj);
gpointer rygel_tracker_query_triplet_ref (gpointer instance);
void rygel_tracker_query_triplet_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_query_triplet (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_tracker_value_set_query_triplet (GValue* value, gpointer v_object);
void rygel_tracker_value_take_query_triplet (GValue* value, gpointer v_object);
gpointer rygel_tracker_value_get_query_triplet (const GValue* value);
GType rygel_tracker_query_triplet_get_type (void) G_GNUC_CONST;
RygelTrackerSelectionQuery* rygel_tracker_selection_query_new (GeeArrayList* variables, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters, const gchar* order_by, gint offset, gint max_count);
RygelTrackerSelectionQuery* rygel_tracker_selection_query_construct (GType object_type, GeeArrayList* variables, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters, const gchar* order_by, gint offset, gint max_count);
gpointer rygel_tracker_query_ref (gpointer instance);
void rygel_tracker_query_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_query (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_tracker_value_set_query (GValue* value, gpointer v_object);
void rygel_tracker_value_take_query (GValue* value, gpointer v_object);
gpointer rygel_tracker_value_get_query (const GValue* value);
GType rygel_tracker_query_get_type (void) G_GNUC_CONST;
GType rygel_tracker_selection_query_get_type (void) G_GNUC_CONST;
void rygel_tracker_query_execute (RygelTrackerQuery* self, RygelTrackerResourcesIface* resources, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_tracker_query_execute_finish (RygelTrackerQuery* self, GAsyncResult* _res_, GError** error);
static void rygel_tracker_metadata_values_fetch_metadata_values_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gchar* rygel_tracker_metadata_values_create_title_for_value (RygelTrackerMetadataValues* self, const gchar* value);
gchar* rygel_tracker_metadata_values_create_id_for_title (RygelTrackerMetadataValues* self, const gchar* title);
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_new_clone (RygelTrackerQueryTriplets* triplets);
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_construct_clone (GType object_type, RygelTrackerQueryTriplets* triplets);
gchar* rygel_tracker_metadata_values_create_filter (RygelTrackerMetadataValues* self, const gchar* variable, const gchar* value);
RygelTrackerSearchContainer* rygel_tracker_search_container_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, RygelTrackerItemFactory* item_factory, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters);
RygelTrackerSearchContainer* rygel_tracker_search_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, RygelTrackerItemFactory* item_factory, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters);
static void rygel_tracker_metadata_values_real_find_object_data_free (gpointer _data);
static void rygel_tracker_metadata_values_real_find_object (RygelMediaContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_tracker_metadata_values_real_find_object_co (RygelTrackerMetadataValuesFindObjectData* data);
static gboolean rygel_tracker_metadata_values_is_our_child (RygelTrackerMetadataValues* self, const gchar* id);
static void rygel_tracker_metadata_values_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gchar* rygel_tracker_metadata_values_real_create_id_for_title (RygelTrackerMetadataValues* self, const gchar* title);
static gchar* rygel_tracker_metadata_values_real_create_title_for_value (RygelTrackerMetadataValues* self, const gchar* value);
static gchar* rygel_tracker_metadata_values_real_create_filter (RygelTrackerMetadataValues* self, const gchar* variable, const gchar* value);
static void rygel_tracker_metadata_values_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _rygel_tracker_item_factory_ref0 (gpointer self) {
	return self ? rygel_tracker_item_factory_ref (self) : NULL;
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


RygelTrackerMetadataValues* rygel_tracker_metadata_values_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, RygelTrackerItemFactory* item_factory, gchar** key_chain, int key_chain_length1, const gchar* child_class) {
	RygelTrackerMetadataValues * self = NULL;
	RygelTrackerItemFactory* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gchar* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (item_factory != NULL, NULL);
	self = (RygelTrackerMetadataValues*) rygel_simple_container_construct (object_type, id, parent, title);
	_tmp0_ = _rygel_tracker_item_factory_ref0 (item_factory);
	_rygel_tracker_item_factory_unref0 (self->priv->item_factory);
	self->priv->item_factory = _tmp0_;
	_tmp1_ = (_tmp2_ = key_chain, (_tmp2_ == NULL) ? ((gpointer) _tmp2_) : _vala_array_dup1 (_tmp2_, key_chain_length1));
	self->key_chain = (_vala_array_free (self->key_chain, self->key_chain_length1, (GDestroyNotify) g_free), NULL);
	self->key_chain = _tmp1_;
	self->key_chain_length1 = key_chain_length1;
	_tmp3_ = g_strdup (child_class);
	_g_free0 (self->priv->child_class);
	self->priv->child_class = _tmp3_;
	rygel_tracker_metadata_values_create_proxies (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch1_g_io_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	goto __finally1;
	__catch1_g_io_error:
	{
		GError * _error_;
		const gchar* _tmp4_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = _ ("Failed to connect to session bus: %s");
		g_critical (_tmp4_, _error_->message);
		_g_error_free0 (_error_);
		return self;
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	rygel_tracker_metadata_values_fetch_metadata_values (self, NULL, NULL);
	return self;
}


static void rygel_tracker_metadata_values_fetch_metadata_values_data_free (gpointer _data) {
	RygelTrackerMetadataValuesFetchMetadataValuesData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (RygelTrackerMetadataValuesFetchMetadataValuesData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_tracker_metadata_values_fetch_metadata_values (RygelTrackerMetadataValues* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerMetadataValuesFetchMetadataValuesData* _data_;
	_data_ = g_slice_new0 (RygelTrackerMetadataValuesFetchMetadataValuesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_tracker_metadata_values_fetch_metadata_values);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_metadata_values_fetch_metadata_values_data_free);
	_data_->self = _g_object_ref0 (self);
	rygel_tracker_metadata_values_fetch_metadata_values_co (_data_);
}


static void rygel_tracker_metadata_values_fetch_metadata_values_finish (RygelTrackerMetadataValues* self, GAsyncResult* _res_) {
	RygelTrackerMetadataValuesFetchMetadataValuesData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GRegex* _tmp2_ = NULL;
	GRegex* _tmp3_;
	GRegex* regex;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	_tmp0_ = g_regex_escape_string (old, -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_regex_new (_tmp1_, 0, 0, &_inner_error_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	regex = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch2_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch2_g_regex_error;
		}
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp5_;
	_g_regex_unref0 (regex);
	return result;
	_g_regex_unref0 (regex);
	goto __finally2;
	__catch2_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void rygel_tracker_metadata_values_fetch_metadata_values_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerMetadataValuesFetchMetadataValuesData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_tracker_metadata_values_fetch_metadata_values_co (data);
}


static gboolean rygel_tracker_metadata_values_fetch_metadata_values_co (RygelTrackerMetadataValuesFetchMetadataValuesData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	rygel_simple_container_clear ((RygelSimpleContainer*) data->self);
	data->_tmp0_ = NULL;
	data->_tmp0_ = rygel_tracker_query_triplets_new ();
	data->triplets = data->_tmp0_;
	data->_tmp1_ = NULL;
	data->_tmp1_ = rygel_tracker_query_triplet_new (RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE, "a", data->self->priv->item_factory->category);
	data->_tmp2_ = data->_tmp1_;
	gee_abstract_collection_add ((GeeAbstractCollection*) data->triplets, data->_tmp2_);
	_rygel_tracker_query_triplet_unref0 (data->_tmp2_);
	data->num_keys = data->self->key_chain_length1 - 1;
	data->_tmp3_ = NULL;
	data->_tmp3_ = g_new0 (gchar*, data->num_keys + 1);
	data->variables = data->_tmp3_;
	data->variables_length1 = data->num_keys;
	data->_variables_size_ = data->num_keys;
	{
		data->i = 0;
		data->_tmp4_ = TRUE;
		while (TRUE) {
			if (!data->_tmp4_) {
				data->i++;
			}
			data->_tmp4_ = FALSE;
			if (!(data->i < data->num_keys)) {
				break;
			}
			data->_tmp5_ = NULL;
			data->_tmp5_ = string_replace (data->self->key_chain[data->i], ":", "_");
			data->_tmp6_ = data->_tmp5_;
			data->_tmp7_ = g_strconcat ("?", data->_tmp6_, NULL);
			data->_tmp8_ = data->_tmp7_;
			_g_free0 (data->variables[data->i]);
			data->variables[data->i] = data->_tmp8_;
			_g_free0 (data->_tmp6_);
			if (data->i == 0) {
				data->_tmp9_ = g_strdup (RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE);
				_g_free0 (data->subject);
				data->subject = data->_tmp9_;
			} else {
				data->_tmp10_ = g_strdup (data->variables[data->i - 1]);
				_g_free0 (data->subject);
				data->subject = data->_tmp10_;
			}
			data->_tmp11_ = NULL;
			data->_tmp11_ = rygel_tracker_query_triplet_new (data->subject, data->self->key_chain[data->i], data->variables[data->i]);
			data->_tmp12_ = data->_tmp11_;
			gee_abstract_collection_add ((GeeAbstractCollection*) data->triplets, data->_tmp12_);
			_rygel_tracker_query_triplet_unref0 (data->_tmp12_);
			_g_free0 (data->subject);
		}
	}
	data->_tmp13_ = NULL;
	data->_tmp13_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	data->selected = data->_tmp13_;
	data->_tmp14_ = g_strdup (data->variables[data->num_keys - 1]);
	data->last_variable = data->_tmp14_;
	data->_tmp15_ = g_strconcat ("DISTINCT ", data->last_variable, NULL);
	data->_tmp16_ = data->_tmp15_;
	gee_abstract_collection_add ((GeeAbstractCollection*) data->selected, data->_tmp16_);
	_g_free0 (data->_tmp16_);
	data->_tmp17_ = NULL;
	data->_tmp17_ = rygel_tracker_selection_query_new (data->selected, data->triplets, NULL, data->last_variable, 0, -1);
	data->query = data->_tmp17_;
	data->_state_ = 1;
	rygel_tracker_query_execute ((RygelTrackerQuery*) data->query, data->self->priv->resources, rygel_tracker_metadata_values_fetch_metadata_values_ready, data);
	return FALSE;
	_state_1:
	rygel_tracker_query_execute_finish ((RygelTrackerQuery*) data->query, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch3_g_error;
	}
	goto __finally3;
	__catch3_g_error:
	{
		data->_error_ = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp18_ = NULL;
		data->_tmp18_ = _ ("Error getting all values for '%s': %s");
		data->_tmp19_ = NULL;
		data->_tmp19_ = g_strjoinv (" -> ", data->self->key_chain);
		data->_tmp20_ = data->_tmp19_;
		g_critical (data->_tmp18_, data->_tmp20_, data->_error_->message);
		_g_free0 (data->_tmp20_);
		_g_error_free0 (data->_error_);
		_rygel_tracker_query_unref0 (data->query);
		_g_free0 (data->last_variable);
		_g_object_unref0 (data->selected);
		data->variables = (_vala_array_free (data->variables, data->variables_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (data->triplets);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	__finally3:
	if (data->_inner_error_ != NULL) {
		_rygel_tracker_query_unref0 (data->query);
		_g_free0 (data->last_variable);
		_g_object_unref0 (data->selected);
		data->variables = (_vala_array_free (data->variables, data->variables_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (data->triplets);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	{
		data->i = 0;
		data->_tmp21_ = TRUE;
		while (TRUE) {
			if (!data->_tmp21_) {
				data->i++;
			}
			data->_tmp21_ = FALSE;
			if (!(data->i < data->query->result_length1)) {
				break;
			}
			data->_tmp22_ = g_strdup (data->query->result[(data->i * data->query->result_length2) + 0]);
			data->value = data->_tmp22_;
			if (g_strcmp0 (data->value, "") == 0) {
				_g_free0 (data->value);
				continue;
			}
			data->_tmp23_ = NULL;
			data->_tmp23_ = rygel_tracker_metadata_values_create_title_for_value (data->self, data->value);
			data->title = data->_tmp23_;
			if (data->title == NULL) {
				_g_free0 (data->title);
				_g_free0 (data->value);
				continue;
			}
			data->_tmp24_ = NULL;
			data->_tmp24_ = rygel_tracker_metadata_values_create_id_for_title (data->self, data->title);
			data->id = data->_tmp24_;
			if (data->id == NULL) {
				data->_tmp25_ = TRUE;
			} else {
				data->_tmp26_ = rygel_simple_container_is_child_id_unique ((RygelSimpleContainer*) data->self, data->id);
				data->_tmp25_ = !data->_tmp26_;
			}
			if (data->_tmp25_) {
				_g_free0 (data->id);
				_g_free0 (data->title);
				_g_free0 (data->value);
				continue;
			}
			data->_tmp27_ = NULL;
			data->_tmp27_ = rygel_tracker_query_triplets_new_clone (data->triplets);
			data->child_triplets = data->_tmp27_;
			data->_tmp28_ = NULL;
			data->_tmp28_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
			data->filters = data->_tmp28_;
			data->_tmp29_ = NULL;
			data->_tmp29_ = gee_abstract_list_last ((GeeAbstractList*) data->child_triplets);
			data->_tmp30_ = (RygelTrackerQueryTriplet*) data->_tmp29_;
			data->_tmp31_ = NULL;
			data->_tmp31_ = rygel_tracker_metadata_values_create_filter (data->self, data->_tmp30_->obj, data->value);
			data->_tmp32_ = data->_tmp31_;
			_rygel_tracker_query_triplet_unref0 (data->_tmp30_);
			data->filter = data->_tmp32_;
			gee_abstract_collection_add ((GeeAbstractCollection*) data->filters, data->filter);
			data->_tmp33_ = NULL;
			data->_tmp33_ = rygel_tracker_search_container_new (data->id, (RygelMediaContainer*) data->self, data->title, data->self->priv->item_factory, data->child_triplets, data->filters);
			data->container = data->_tmp33_;
			if (data->self->priv->child_class != NULL) {
				data->_tmp34_ = g_strdup (data->self->priv->child_class);
				_g_free0 (((RygelMediaObject*) data->container)->upnp_class);
				((RygelMediaObject*) data->container)->upnp_class = data->_tmp34_;
			}
			rygel_simple_container_add_child_container ((RygelSimpleContainer*) data->self, (RygelMediaContainer*) data->container);
			_g_object_unref0 (data->container);
			_g_free0 (data->filter);
			_g_object_unref0 (data->filters);
			_g_object_unref0 (data->child_triplets);
			_g_free0 (data->id);
			_g_free0 (data->title);
			_g_free0 (data->value);
		}
	}
	rygel_media_container_updated ((RygelMediaContainer*) data->self);
	_rygel_tracker_query_unref0 (data->query);
	_g_free0 (data->last_variable);
	_g_object_unref0 (data->selected);
	data->variables = (_vala_array_free (data->variables, data->variables_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (data->triplets);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_tracker_metadata_values_real_find_object_data_free (gpointer _data) {
	RygelTrackerMetadataValuesFindObjectData* data;
	data = _data;
	_g_free0 (data->id);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (RygelTrackerMetadataValuesFindObjectData, data);
}


static void rygel_tracker_metadata_values_real_find_object (RygelMediaContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerMetadataValues * self;
	RygelTrackerMetadataValuesFindObjectData* _data_;
	self = (RygelTrackerMetadataValues*) base;
	_data_ = g_slice_new0 (RygelTrackerMetadataValuesFindObjectData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_tracker_metadata_values_real_find_object);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_metadata_values_real_find_object_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->id = g_strdup (id);
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_tracker_metadata_values_real_find_object_co (_data_);
}


static RygelMediaObject* rygel_tracker_metadata_values_real_find_object_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelTrackerMetadataValuesFindObjectData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_tracker_metadata_values_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerMetadataValuesFindObjectData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_tracker_metadata_values_real_find_object_co (data);
}


static gboolean rygel_tracker_metadata_values_real_find_object_co (RygelTrackerMetadataValuesFindObjectData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = rygel_tracker_metadata_values_is_our_child (data->self, data->id);
	if (data->_tmp0_) {
		data->_state_ = 1;
		RYGEL_MEDIA_CONTAINER_CLASS (rygel_tracker_metadata_values_parent_class)->find_object ((RygelMediaContainer*) RYGEL_SIMPLE_CONTAINER (data->self), data->id, data->cancellable, rygel_tracker_metadata_values_find_object_ready, data);
		return FALSE;
		_state_1:
		data->_tmp1_ = NULL;
		data->_tmp1_ = RYGEL_MEDIA_CONTAINER_CLASS (rygel_tracker_metadata_values_parent_class)->find_object_finish ((RygelMediaContainer*) RYGEL_SIMPLE_CONTAINER (data->self), data->_res_, &data->_inner_error_);
		data->_tmp2_ = data->_tmp1_;
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		data->result = data->_tmp2_;
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	} else {
		data->result = NULL;
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static gchar* rygel_tracker_metadata_values_real_create_id_for_title (RygelTrackerMetadataValues* self, const gchar* title) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	_tmp0_ = g_strconcat (((RygelMediaObject*) self)->id, ":", NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_uri_escape_string (title, "", TRUE);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp1_, _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = _tmp5_;
	return result;
}


gchar* rygel_tracker_metadata_values_create_id_for_title (RygelTrackerMetadataValues* self, const gchar* title) {
	return RYGEL_TRACKER_METADATA_VALUES_GET_CLASS (self)->create_id_for_title (self, title);
}


static gchar* rygel_tracker_metadata_values_real_create_title_for_value (RygelTrackerMetadataValues* self, const gchar* value) {
	gchar* result = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (value != NULL, NULL);
	_tmp0_ = g_strdup (value);
	result = _tmp0_;
	return result;
}


gchar* rygel_tracker_metadata_values_create_title_for_value (RygelTrackerMetadataValues* self, const gchar* value) {
	return RYGEL_TRACKER_METADATA_VALUES_GET_CLASS (self)->create_title_for_value (self, value);
}


static gchar* rygel_tracker_metadata_values_real_create_filter (RygelTrackerMetadataValues* self, const gchar* variable, const gchar* value) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (variable != NULL, NULL);
	g_return_val_if_fail (value != NULL, NULL);
	_tmp0_ = g_strconcat (variable, " = \"", NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, value, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, "\"", NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = _tmp5_;
	return result;
}


gchar* rygel_tracker_metadata_values_create_filter (RygelTrackerMetadataValues* self, const gchar* variable, const gchar* value) {
	return RYGEL_TRACKER_METADATA_VALUES_GET_CLASS (self)->create_filter (self, variable, value);
}


static gboolean rygel_tracker_metadata_values_is_our_child (RygelTrackerMetadataValues* self, const gchar* id) {
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (id != NULL, FALSE);
	_tmp0_ = g_strconcat (((RygelMediaObject*) self)->id, ":", NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_str_has_prefix (id, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}


static void rygel_tracker_metadata_values_create_proxies (RygelTrackerMetadataValues* self, GError** error) {
	RygelTrackerResourcesIface* _tmp0_ = NULL;
	RygelTrackerResourcesIface* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_initable_new (RYGEL_TRACKER_TYPE_RESOURCES_IFACE_PROXY, NULL, &_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", RYGEL_TRACKER_METADATA_VALUES_TRACKER_SERVICE, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", RYGEL_TRACKER_METADATA_VALUES_RESOURCES_PATH, "g-interface-name", "org.freedesktop.Tracker1.Resources", NULL);
	_tmp1_ = (RygelTrackerResourcesIface*) _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (self->priv->resources);
	self->priv->resources = _tmp1_;
}


static void rygel_tracker_metadata_values_class_init (RygelTrackerMetadataValuesClass * klass) {
	rygel_tracker_metadata_values_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelTrackerMetadataValuesPrivate));
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object = rygel_tracker_metadata_values_real_find_object;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object_finish = rygel_tracker_metadata_values_real_find_object_finish;
	RYGEL_TRACKER_METADATA_VALUES_CLASS (klass)->create_id_for_title = rygel_tracker_metadata_values_real_create_id_for_title;
	RYGEL_TRACKER_METADATA_VALUES_CLASS (klass)->create_title_for_value = rygel_tracker_metadata_values_real_create_title_for_value;
	RYGEL_TRACKER_METADATA_VALUES_CLASS (klass)->create_filter = rygel_tracker_metadata_values_real_create_filter;
	G_OBJECT_CLASS (klass)->finalize = rygel_tracker_metadata_values_finalize;
}


static void rygel_tracker_metadata_values_instance_init (RygelTrackerMetadataValues * self) {
	self->priv = RYGEL_TRACKER_METADATA_VALUES_GET_PRIVATE (self);
}


static void rygel_tracker_metadata_values_finalize (GObject* obj) {
	RygelTrackerMetadataValues * self;
	self = RYGEL_TRACKER_METADATA_VALUES (obj);
	_rygel_tracker_item_factory_unref0 (self->priv->item_factory);
	self->key_chain = (_vala_array_free (self->key_chain, self->key_chain_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->child_class);
	_g_object_unref0 (self->priv->resources);
	G_OBJECT_CLASS (rygel_tracker_metadata_values_parent_class)->finalize (obj);
}


/**
 * Container listing possible values of a particuler Tracker metadata key.
 */
GType rygel_tracker_metadata_values_get_type (void) {
	static volatile gsize rygel_tracker_metadata_values_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_tracker_metadata_values_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerMetadataValuesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_tracker_metadata_values_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTrackerMetadataValues), 0, (GInstanceInitFunc) rygel_tracker_metadata_values_instance_init, NULL };
		GType rygel_tracker_metadata_values_type_id;
		rygel_tracker_metadata_values_type_id = g_type_register_static (RYGEL_TYPE_SIMPLE_CONTAINER, "RygelTrackerMetadataValues", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_tracker_metadata_values_type_id__volatile, rygel_tracker_metadata_values_type_id);
	}
	return rygel_tracker_metadata_values_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



