/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999, 2000, 2001  Pan Development Team <pan@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __PREFS_H__
#define __PREFS_H__

/**
*** Global Variables
**/

typedef enum
{
	ONLINE_PROMPT	= 0,
	ONLINE_YES	= 1,
	ONLINE_NO	= 2
}
GoingOnlinePreference;

typedef enum
{
	CLICK_ACTION_SELECT,
	CLICK_ACTION_LOAD
}
ListClickAction;

extern GoingOnlinePreference   going_online_preference;
extern ListClickAction         grouplist_mb1_action;
extern ListClickAction         grouplist_mb2_action;
extern ListClickAction         articlelist_mb1_action;
extern ListClickAction         articlelist_mb2_action;
extern gboolean                show_group_pane;
extern gboolean                show_header_pane;
extern gboolean                show_article_pane;
extern gboolean                download_bodies_too;
extern gboolean                navigate_cached_only;
extern gboolean                navigate_read_on_select;
extern gboolean                text_use_fixed_font;
extern gboolean                text_window_smooth_scrolling;
extern gint                    text_window_smooth_scrolling_speed;
extern gboolean                fetch_new_on_group_load;
extern gboolean                display_article_dates_in_local_time;
extern gboolean                hide_mpart_child_nodes;
extern gboolean                auto_part_selection;
extern gboolean                pan_mute;
extern gboolean                use_gdk_fontset_load;
extern gchar                 * thread_date_format;
extern gchar                 * body_date_format;
extern gchar                 * grouplist_font;
extern gchar                 * thread_normal_font;
extern gchar                 * thread_new_replies_font;
extern gchar                 * message_body_font;
extern gchar                 * message_body_font_fixed;
extern gchar                 * external_web_browser;
extern gchar                 * external_editor;
extern gint                    watched_thread_span_days;
extern gchar                 * extra_posting_headers;
extern gchar                 * mail_server_address;
extern gchar                 * layout_str;
extern gint                    mail_server_port;
extern gint                    wrap_column;
extern gboolean                wrap_body_on_reply;
extern gboolean                collapse_group_names;
extern gboolean                use_system_fg;
extern gboolean                use_system_bg;

extern gchar *                 newsrc_filename;
extern gboolean                newsrc_do_port;
extern gboolean                newsrc_port_subscribed_only;
extern gboolean                newsrc_do_backup_before_export;


/** 
*** Function Prototypes
**/

extern void prefs_spawn_to_news_servers      (void);

extern void prefs_spawn_to_news_connections  (void);

extern void prefs_spawn                      (void);

extern void prefs_init                       (void);

#endif /* __PREFS_H__ */
