# -*- coding: utf-8 -*-

# Copyright (C) 2004-2006 Johan Svedberg <johan@svedberg.com>

# This file is part of ontv.

# ontv is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# ontv is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with ontv; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import sys
from gettext import gettext as _

import dbus
import gobject

import GUI
from DBus import DBus
from ontv import NAME

TIMEOUT = 60000

class Notification:
    def __init__(self, program, get_readable_time):
        self.program = program
        self.get_readable_time = get_readable_time
        self.id = 0L

        from OnTVApplet import OnTVApplet
        self.ontvapplet = OnTVApplet()

        bus = DBus()
        interface = bus.get_notifications_interface()
        if interface is None:
            print >> sys.stderr, "Unable to get DBus session bus."
        else:
            interface.connect_to_signal("NotificationClosed", self.__closed)
            self.__show()
            self.__update_id = gobject.timeout_add(TIMEOUT, self.__update)

    def __closed(self, id):
        if id == self.id:
            gobject.source_remove(self.__update_id)

    def __update(self):
        self.__show()
        return True

    def __show(self):
        bus = DBus()
        interface = bus.get_notifications_interface()
        if interface is None:
            print >> sys.stderr, "Unable to get DBus session bus."
        else:
            summary = "%s %s" % (self.program.start_time,
                                 self.program.markup_escaped_title)
            # Due to what appears to be a bug in dbus the icon_data hint
            # doesn't seem to work, hopefully some day.
            # if not self.program.channel.logo is None:
                # logo = self.program.channel.logo
                # image = (logo.get_width(), logo.get_height(),
                           # logo.get_rowstride(), logo.get_has_alpha(),
                           # logo.get_bits_per_sample(), logo.get_n_channels(),
                           # logo.get_pixels())
            # else:
            summary += "\n" + self.program.channel.markup_escaped_name
            body = _("Program starts in %s.") % \
                   self.get_readable_time(self.program.get_time_until_start())
            (x, y, gravity) = self.ontvapplet.get_docking_data(True)
            time = self.program.get_time_until_start().seconds * 1000
            self.id = interface.Notify(NAME, self.id, GUI.icon_file, summary,
                                       body + "\n\n", [], {"x": x, "y": y},
                                       time)


# vim: set sw=4 et sts=4 tw=79 fo+=l:
