/* -*- Mode: C; indent-tabs-mode:nil; c-basic-offset: 8-*- */

/*
 *This file is part of MlView.
 *
 *MlView is free software; you can redistribute 
 *it and/or modify it under the terms of 
 *the GNU General Public License as published by the 
 *Free Software Foundation; either version 2, 
 *or (at your option) any later version.
 *
 *GNU MlView is distributed in the hope that it will 
 *be useful, but WITHOUT ANY WARRANTY; 
 *without even the implied warranty of 
 *MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *See the GNU General Public License for more details.
 *
 *You should have received a copy of the 
 *GNU General Public License along with MlView; 
 *see the file COPYING. 
 *If not, write to the Free Software Foundation, 
 *Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *See COPYRIGHT file for copyright information.
 */

#ifndef __MLVIEW_IVIEW_H__
#define __MLVIEW_IVIEW_H__

#include "mlview-utils.h"
#include "mlview-action.h"
#include "mlview-xml-document.h"


/**
 *@file
 *The declaration of the #MlViewIView interface.
 */
G_BEGIN_DECLS

#define MLVIEW_TYPE_IVIEW (mlview_iview_get_type ())
#define MLVIEW_IVIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MLVIEW_TYPE_IVIEW, MlViewIView))
#define MLVIEW_IS_IVIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MLVIEW_TYPE_IVIEW))
#define MLVIEW_IVIEW_GET_IFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), MLVIEW_TYPE_IVIEW, MlViewIView))

typedef struct _MlViewIView MlViewIView ;/*dummy object*/
typedef struct _MlViewIViewClass MlViewIViewClass ;
typedef struct _MlViewIViewPriv  MlViewIViewPriv ;

typedef GtkWidget * (*ViewConstructor) (MlViewXMLDocument *a_doc,
                                        const gchar *a_view_name,
                                        MlViewAppContext *a_context) ;

struct MlViewViewDesc {
        gchar *view_type_name ;
	gchar *translated_view_name ;
        gchar *view_description ;
        ViewConstructor view_constructor ;        
} ;

/**
 *The base interface of all the
 *editing views manipulated
 *by the #MlViewEditor class.
 */
struct _MlViewIView {
        GTypeInterface parent_iface;

	/**************************************
	 * the iface vtable
	 *
	 * All this methods 
	 * must be implemented
	 * by the implementations
	 * of the view.
	 * See How MlViewViewAdapter
	 * has been implemented for example
	 ************************************/

        enum MlViewStatus (*set_name) (MlViewIView *a_this,
                                       guchar *a_name) ;

	enum MlViewStatus (*set_name_interactive) (MlViewIView *a_this) ;

	enum MlViewStatus (*get_name) (MlViewIView *a_this,
                                       guchar **a_name) ;

	enum MlViewStatus (*get_document) (MlViewIView *a_this,
                                           MlViewXMLDocument **a_doc) ;

	enum MlViewStatus (*set_document) (MlViewIView *a_this,
					   MlViewXMLDocument *a_doc) ;

        enum MlViewStatus (*get_impl) (MlViewIView *a_this,
                                       GtkWidget **a_impl) ;

        enum MlViewStatus (*set_desc_type_name)  (MlViewIView *a_this,
			                          const gchar *a_name) ;

        enum MlViewStatus (*get_desc_type_name)  (MlViewIView *a_this,
			                          gchar **a_name) ;


	enum MlViewStatus (*connect_to_doc) (MlViewIView *a_this,
                                             MlViewXMLDocument *a_doc) ;

	enum MlViewStatus (*disconnect_from_doc) (MlViewIView *a_this,
                                                  MlViewXMLDocument *a_doc) ;

        enum MlViewStatus (*update_contextual_menu) (MlViewIView *a_this,
                                                     GtkWidget **a_menu) ;

	enum MlViewStatus (*execute_action) (MlViewIView *a_this,
			                     MlViewAction *a_action) ;

	enum MlViewStatus (*get_must_rebuild_upon_document_reload) 
							(MlViewIView *a_this,
	   		                                 gboolean *a_result) ;
	enum MlViewStatus (*undo) (MlViewIView *a_this) ;

	enum MlViewStatus (*redo) (MlViewIView *a_this) ;

	enum MlViewStatus (*can_undo) (MlViewIView *a_this,
	                               gboolean *a_can_undo) ;

	enum MlViewStatus (*can_redo) (MlViewIView *a_this,
	                               gboolean *a_can_undo) ;

	/********************
         *signals
         ********************/

	void (*name_changed) (MlViewIView *a_this, gpointer a_data) ;

        void (*is_swapped_out)  (MlViewIView *a_this, gpointer a_data);

        void  (*is_swapped_in) (MlViewIView *a_this, gpointer a_data) ;

        void (*application_menu_populating_requested) (MlViewIView *a_this, 
			                               gpointer a_data) ;
};


GType mlview_iview_get_type (void) ;

enum MlViewStatus mlview_iview_connect_to_doc (MlViewIView *a_this,
                                               MlViewXMLDocument *a_doc) ;

enum MlViewStatus mlview_iview_disconnect_from_doc (MlViewIView *a_this,
                                                    MlViewXMLDocument *a_doc) ;

enum MlViewStatus mlview_iview_set_name (MlViewIView *a_this,
                                         guchar *a_name) ;

enum MlViewStatus mlview_iview_get_name (MlViewIView *a_this,
                                         guchar **a_name) ;

enum MlViewStatus mlview_iview_set_name_interactive (MlViewIView *a_this) ;

enum MlViewStatus mlview_iview_get_document (MlViewIView *a_this,
                                             MlViewXMLDocument **a_doc) ;

enum MlViewStatus mlview_iview_set_document (MlViewIView *a_this,
                                             MlViewXMLDocument *a_doc) ;

enum MlViewStatus mlview_iview_set_desc_type_name (MlViewIView *a_this,
		                                   const gchar *a_desc_type_name) ;

enum MlViewStatus mlview_iview_get_desc_type_name (MlViewIView *a_this,
		                                   gchar **a_desc_type_name) ;

enum MlViewStatus mlview_iview_get_must_rebuild_upon_document_reload (MlViewIView *a_this, 
		                                                      gboolean *a_result) ;

enum MlViewStatus mlview_iview_execute_action (MlViewIView  *a_this,
                                               MlViewAction *a_action) ;

enum MlViewStatus mlview_iview_update_contextual_menu (MlViewIView *a_this,
				                       GtkWidget **a_menu) ;

enum MlViewStatus mlview_iview_get_impl (MlViewIView *a_this, GtkWidget **a_impl) ;

enum MlViewStatus mlview_iview_notify_swapped_out (MlViewIView *a_this) ;

enum MlViewStatus mlview_iview_notify_swapped_in (MlViewIView *a_this);

enum MlViewStatus mlview_iview_request_application_menu_populating 
							(MlViewIView *a_this) ;

enum MlViewStatus mlview_iview_undo (MlViewIView *a_this) ;

enum MlViewStatus mlview_iview_redo (MlViewIView *a_this) ;

enum MlViewStatus mlview_iview_can_undo (MlViewIView *a_this,
                                         gboolean *a_can_undo) ;

enum MlViewStatus mlview_iview_can_redo (MlViewIView *a_this,
                                         gboolean *a_can_redo) ;

G_END_DECLS
#endif
