/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 8-*- */

/*
 *This file is part of MlView
 *
 *MlView is free software; you can redistribute it and/or 
 *modify it under the terms of 
 *the GNU General Public License as published 
 *by the Free Software Foundation; either version 2
 *or (at your option) any later version.
 *
 *MlView is distributed in the hope that it will 
 *be useful, but WITHOUT ANY WARRANTY; 
 *without even the implied warranty of 
 *MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *See the GNU General Public License for more details.
 *
 *You should have received a copy of the 
 *GNU General Public License along with MlView.
 *see the file COPYING. 
 *If not, write to the 
 *Free Software Foundation, 
 *Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *See COPYRIGHT file for copyright information.
 */

#ifndef __MLVIEW_GUI_H__
#define __MLVIEW_GUI_H__

#include "mlview-editor.h"

/**
 *@file 
 *the mlview application class definition.
 *It instanciates mlview's instance of  GnomeApp, 
 *fills it with an instance of MlViewEditor, builds the application menus
 *and toolbars and creates an instance of MlViewAppContext.
 */

#define MLVIEW_ROOTWINDOW_WIDTH 800
#define MLVIEW_ROOTWINDOW_HEIGHT 600
#define MLVIEW_MAINPANED_POSITION 400

G_BEGIN_DECLS

typedef struct _MlViewApp MlViewApp ;
typedef struct _MlViewAppPriv MlViewAppPriv ;

struct _MlViewApp {
        MlViewAppPriv *priv ;
} ;


/**
 *This struct
 *is a handle to access
 *widgets items build using glade.
 *e.g: menubar, menu items etc ...
 */
struct MlViewWidgetsHandle {
        GtkWidget *app_win;/*main app window*/
        GtkWidget *menu_bar_container ;
        GtkWidget *toolbar_container ;
        /****MENU BAR STUFFS*****/
        GtkWidget *main_menu_bar ;
        /******new menu entries go here*****/
        GtkWidget *hhmm ;
        /****Editor*widget*/
        GtkWidget *editor ;
} ;


MlViewApp * mlview_app_new (const guchar * a_appname);

void mlview_app_set_visible (MlViewApp *a_app);

MlViewEditor *mlview_app_get_editor (MlViewApp * a_win);

MlViewAppContext * mlview_app_get_application_context (MlViewApp *a_app) ;

struct MlViewWidgetsHandle *mlview_app_get_widgets_handle (MlViewApp *a_this) ;

enum MlViewStatus mlview_app_set_main_window_title (MlViewApp *a_this,
                                                    const gchar *a_document_name) ;

GtkUIManager * mlview_app_get_ui_manager (MlViewApp *a_this) ;

void mlview_app_close_application (MlViewApp *a_this,
		                   gboolean a_interactive) ;

void mlview_app_close_all_docs (MlViewApp *a_this, gboolean a_interactive) ;

G_END_DECLS
#endif
