/* data-handler-private.h
 *
 * Copyright (C) 2002 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __DATA_HANDLER_PRIVATE__
#define __DATA_HANDLER_PRIVATE__

#include "data-handler.h"
#include "server-access.h"

G_BEGIN_DECLS

struct _DataHandlerPriv {
	gchar          *descr;
	gchar          *detailled_descr;
	gchar          *plugin_name;	        /* NULL if builtin Data display */
	gchar          *plugin_file;	        /* NULL if builtin Data display */
	GModule        *lib_handle;	        /* NULL if builtin Data display */
	gchar          *version;	        /* NULL if builtin Data display */
	gchar        *(*get_unique_key)     ();	/* NULL if builtin Data display */
	guint           nb_gda_type;
	GdaValueType   *valid_gda_types;
	gboolean        expand_widget;
	ServerAccess  *srv;

	/* REM:
	   - sql_from_value() and str_from_value() may return NULL
	   - GtkWidget is ALWAYS a DataEntry
	*/
	GtkWidget   *(*widget_from_value)   (DataHandler *dh, const GdaValue * value);
	GdaValue    *(*value_from_widget)   (DataHandler *dh, GtkWidget * wid);
	void         (*widget_update)       (DataHandler *dh, GtkWidget * wid, const GdaValue * value, 
					     gboolean value_as_init); 
	gchar       *(*sql_from_value)      (DataHandler *dh, const GdaValue * value);
	gchar       *(*str_from_value)      (DataHandler *dh, const GdaValue * value);

	gboolean       disposed;
};

G_END_DECLS

#endif
