/* gnome-db-server-data-type.h
 *
 * Copyright (C) 2003 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#ifndef __GNOME_DB_SERVER_DATA_TYPE_H_
#define __GNOME_DB_SERVER_DATA_TYPE_H_

#include "gnome-db-base.h"
#include "gnome-db-decl.h"
#include <libgda/libgda.h>

G_BEGIN_DECLS

#define GNOME_DB_TYPE_SERVER_DATA_TYPE          (gnome_db_server_data_type_get_type())
#define GNOME_DB_SERVER_DATA_TYPE(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_server_data_type_get_type(), GnomeDbServerDataType)
#define GNOME_DB_SERVER_DATA_TYPE_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_server_data_type_get_type (), GnomeDbServerDataTypeClass)
#define IS_GNOME_DB_SERVER_DATA_TYPE(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_server_data_type_get_type ())


/* error reporting */
extern GQuark gnome_db_server_data_type_error_quark (void);
#define GNOME_DB_SERVER_DATA_TYPE_ERROR gnome_db_server_data_type_error_quark ()

enum
{
	GNOME_DB_SERVER_DATA_TYPE_XML_LOAD_ERROR
};


/* struct for the object's data */
struct _GnomeDbServerDataType
{
	GnomeDbBase                         object;
	GnomeDbServerDataTypePrivate       *priv;
};

/* struct for the object's class */
struct _GnomeDbServerDataTypeClass
{
	GnomeDbBaseClass                    class;

	/* signals */
	void   (*templ_signal)        (GnomeDbServerDataType *obj);
};

GType               gnome_db_server_data_type_get_type      (void);
GObject            *gnome_db_server_data_type_new           (GnomeDbServer *srv);

void                gnome_db_server_data_type_set_sqlname   (GnomeDbServerDataType *dt, const gchar *sqlname);
const gchar        *gnome_db_server_data_type_get_sqlname   (GnomeDbServerDataType *dt);

void                gnome_db_server_data_type_set_gda_type  (GnomeDbServerDataType *dt, GdaValueType gda_type);
GdaValueType        gnome_db_server_data_type_get_gda_type  (GnomeDbServerDataType *dt);

void                gnome_db_server_data_type_add_synonym   (GnomeDbServerDataType *dt, const gchar *synonym);
const GSList       *gnome_db_server_data_type_get_synonyms  (GnomeDbServerDataType *dt);
void                gnome_db_server_data_type_clear_synonyms(GnomeDbServerDataType *dt);

void                gnome_db_server_data_type_set_handler   (GnomeDbServerDataType *dt, GnomeDbDataHandler *dh);
GnomeDbDataHandler *gnome_db_server_data_type_get_handler   (GnomeDbServerDataType *dt);

G_END_DECLS

#endif
