/* gnome-db-custom-layout.h
 *
 * Copyright (C) 2004 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#ifndef __GNOME_DB_CUSTOM_LAYOUT_H_
#define __GNOME_DB_CUSTOM_LAYOUT_H_

#include <gtk/gtk.h>
#include "gnome-db-base.h"
#include "gnome-db-decl.h"
#include <libgda/libgda.h>
#include <glade/glade.h>
#include "gnome-db-matrix.h"

G_BEGIN_DECLS

#define GNOME_DB_CUSTOM_LAYOUT_TYPE          (gnome_db_custom_layout_get_type())
#define GNOME_DB_CUSTOM_LAYOUT(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_custom_layout_get_type(), GnomeDbCustomLayout)
#define GNOME_DB_CUSTOM_LAYOUT_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_custom_layout_get_type (), GnomeDbCustomLayoutClass)
#define IS_GNOME_DB_CUSTOM_LAYOUT(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_custom_layout_get_type ())

typedef enum {
	GNOME_DB_CUSTOM_LAYOUT_LAYOUT,
	GNOME_DB_CUSTOM_LAYOUT_GRID,
	GNOME_DB_CUSTOM_LAYOUT_FORM,
	GNOME_DB_CUSTOM_LAYOUT_MATRIX
} GnomeDbCustomLayoutType;

typedef struct
{
	GnomeDbCustomLayoutType type;

	/* contents of the layout */
	union {
		/* sub layouts, for GNOME_DB_CUSTOM_LAYOUT_LAYOUT */
		struct {
			GSList           *children; /* list of GnomeDbCustomLayout objects, DON'T FREE */
			GSList           *connects; /* list of GnomeDbCustomLayoutConnect structures, DON'T FREE */
		} layout;
		
		struct {
			/* for all the GnomeDbWork* widgets */
			GnomeDbQuery          *query;
			guint             mode;
			GnomeDbBase           *modified;

			/* For GnomeDbWorkMatrix only */
			GnomeDbQuery          *query_extra;
			GnomeDbTarget         *cols_target;
			GnomeDbTarget         *rows_target;
			GnomeDbMatrixType      view_type;
		} work_iface;
	} contents;
} GnomeDbCustomLayoutData;

typedef struct {
	GnomeDbCustomLayout *src_layout;
	GnomeDbField        *src_field;
	GnomeDbCustomLayout *dest_layout;
	GnomeDbField        *dest_field;
} GnomeDbCustomLayoutConnect;

enum
{
	GNOME_DB_CUSTOM_LAYOUT_XML_SAVE_ERROR,
	GNOME_DB_CUSTOM_LAYOUT_XML_LOAD_ERROR,
	GNOME_DB_CUSTOM_LAYOUT_GLADEXML_ERROR,
	GNOME_DB_CUSTOM_LAYOUT_DATA_ERROR
};

/* error reporting */
extern GQuark gnome_db_custom_layout_error_quark (void);
#define GNOME_DB_CUSTOM_LAYOUT_ERROR gnome_db_custom_layout_error_quark ()

/* struct for the object's data */
struct _GnomeDbCustomLayout
{
	GnomeDbBase                  object;
	GnomeDbCustomLayoutPrivate    *priv;
};

/* struct for the object's class */
struct _GnomeDbCustomLayoutClass
{
	GnomeDbBaseClass          class;
};

GType               gnome_db_custom_layout_get_type                 (void);
GObject            *gnome_db_custom_layout_new                      (GnomeDbDict *dict);
GnomeDbCustomLayoutType  gnome_db_custom_layout_get_layout_type          (GnomeDbCustomLayout *layout);
GnomeDbCustomLayoutData *gnome_db_custom_layout_get_data                 (GnomeDbCustomLayout *layout, GError **error);
void                gnome_db_custom_layout_data_free                (GnomeDbCustomLayoutData *data);
GladeXML           *gnome_db_custom_layout_get_glade_instance       (GnomeDbCustomLayout *layout, 
							       GtkWidget **root_widget, GHashTable **box_widgets, 
							       GError **error);
GtkWidget          *gnome_db_custom_layout_get_widget               (GnomeDbCustomLayout *layout, GError **error);

GnomeDbDataSet          *gnome_db_custom_layout_get_exec_context         (GnomeDbCustomLayout *layout);
GnomeDbDataSet          *gnome_db_custom_layout_get_data_context         (GnomeDbCustomLayout *layout);

G_END_DECLS

#endif
