/* gnome-db-sql-parser.h
 *
 * Copyright (C) 2004 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#ifndef _GNOME_DB_SQL_PARSER_H
#define _GNOME_DB_SQL_PARSER_H

#include <glib.h>
#define YY_NO_UNISTD_H


typedef struct GnomeDbSqlStatement        GnomeDbSqlStatement;
typedef struct GnomeDbSqlExpr             GnomeDbSqlExpr;
typedef struct GnomeDbParamSpec           GnomeDbParamSpec;

/*
 * Type of parsed SQL
 */
typedef enum
{
	GNOME_DB_SQL_SELECT,
	GNOME_DB_SQL_INSERT,
	GNOME_DB_SQL_DELETE,
	GNOME_DB_SQL_UPDATE
}
GnomeDbSqlStatementType;


/*
 * Structure to hold a SQL statement
 */
struct GnomeDbSqlStatement
{
	GnomeDbSqlStatementType  type;
	char               *full_query;
	GList              *expr_list;  /* list of GnomeDbSqlExpr structures */
	GList              *params_specs;/* list of GList of GnomeDbParamSpec structures */
};

/*
 * Structure to hold a single statement
 */
struct GnomeDbSqlExpr
{
	GList         *pspec_list; /* list of GnomeDbParamSpec structures */
	gchar         *sql_text;
};
#define GNOME_DB_SQL_EXPR(x) ((GnomeDbSqlExpr*)(x))

/*
 * Different types of parameter specifications
 */
typedef enum
{
	GNOME_DB_PARAM_NAME,
	GNOME_DB_PARAM_DESCR,
	GNOME_DB_PARAM_TYPE,
	GNOME_DB_PARAM_ISPARAM,
	GNOME_DB_PARAM_NULLOK
} GnomeDbParamSpecType;

/*
 * Structure to hold one parameter specification
 */
struct GnomeDbParamSpec
{
	GnomeDbParamSpecType  type;
	char            *content;
};
#define GNOME_DB_PARAM_SPEC(x) ((GnomeDbParamSpec *)(x))

void  gnome_db_sql_display (GnomeDbSqlStatement * statement);
int   gnome_db_sql_destroy (GnomeDbSqlStatement * statement);

GnomeDbSqlStatement *gnome_db_sql_parse                (const char *sql_text);
GnomeDbSqlStatement *gnome_db_sql_parse_with_error     (const char *sql_text, GError ** error);
GnomeDbSqlStatement *gnome_db_sql_parse_copy_statement (GnomeDbSqlStatement * statement);

#endif
