/* GNOME DB library
 * Copyright (C) 1999 - 2005 The GNOME Foundation.
 *
 * AUTHORS:
 * 	Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gtk/gtkbox.h>
#include <gtk/gtktable.h>
#include <libgnomedb/gnome-db-table-editor.h>
#include <libgnomedb/gnome-db-util.h>
#include <glib/gi18n-lib.h>

#define PARENT_TYPE GTK_TYPE_VBOX

struct _GnomeDbTableEditorPrivate {
	/* widgets */
	GtkWidget *name_entry;
	GtkWidget *field_box;
};

static void gnome_db_table_editor_class_init (GnomeDbTableEditorClass *klass);
static void gnome_db_table_editor_init       (GnomeDbTableEditor *editor,
					      GnomeDbTableEditorClass *klass);
static void gnome_db_table_editor_finalize   (GObject *object);

static GObjectClass *parent_class = NULL;

/*
 * Private functions
 */

/*
 * GnomeDbTableEditor class implementation
 */

static void
gnome_db_table_editor_class_init (GnomeDbTableEditorClass *klass)
{
	GObjectClass *object_class = G_OBJECT_CLASS (klass);

	parent_class = g_type_class_peek_parent (klass);

	object_class->finalize = gnome_db_table_editor_finalize;
}

static void
gnome_db_table_editor_init (GnomeDbTableEditor *editor,
			    GnomeDbTableEditorClass *klass)
{
	GtkWidget *table;
	GtkWidget *label;
	GtkWidget *scroll;

	g_return_if_fail (GNOME_DB_IS_TABLE_EDITOR (editor));

	/* allocate internal structure */
	editor->priv = g_new0 (GnomeDbTableEditorPrivate, 1);

	/* setup widgets */
	table = gnome_db_new_table_widget (4, 4, FALSE);
	gtk_box_pack_start (GTK_BOX (editor), table, TRUE, TRUE, 0);

	label = gnome_db_new_label_widget (_("Table name"));
	gtk_table_attach (GTK_TABLE (table), label, 0, 1, 0, 1, GTK_FILL, GTK_FILL, 2, 2);
	editor->priv->name_entry = gnome_db_new_entry_widget (0, TRUE);
	gtk_table_attach (GTK_TABLE (table), editor->priv->name_entry, 1, 2, 0, 1,
			  GTK_FILL, GTK_FILL, 2, 2);

	scroll = gnome_db_new_scrolled_window_widget ();
	gtk_table_attach (GTK_TABLE (table), scroll, 0, 4, 1, 4,
			  GTK_FILL | GTK_EXPAND | GTK_SHRINK,
			  GTK_FILL | GTK_EXPAND | GTK_SHRINK, 2, 2);
	editor->priv->field_box = gnome_db_new_vbox_widget (FALSE, 0);
}

static void
gnome_db_table_editor_finalize (GObject *object)
{
	GnomeDbTableEditor *editor = (GnomeDbTableEditor *) object;

	g_return_if_fail (GNOME_DB_IS_TABLE_EDITOR (editor));

	/* free memory */
	g_free (editor->priv);
	editor->priv = NULL;

	/* chain to parent class */
	parent_class->finalize (object);
}

GType
gnome_db_table_editor_get_type (void)
{
	static GType type = 0;

	if (!type) {
		static const GTypeInfo info = {
			sizeof (GnomeDbTableEditorClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) gnome_db_table_editor_class_init,
			NULL,
			NULL,
			sizeof (GnomeDbTableEditor),
			0,
			(GInstanceInitFunc) gnome_db_table_editor_init
		};
		type = g_type_register_static (PARENT_TYPE, "GnomeDbTableEditor", &info, 0);
	}
	return type;
}

/**
 * gnome_db_table_editor_new
 *
 * Create a new #GnomeDbTableEditor widget, which lets the user visually
 * display and modify a table's structure.
 *
 * Returns: the newly created widget.
 */
GtkWidget *
gnome_db_table_editor_new (void)
{
	GnomeDbTableEditor *editor;

	editor = g_object_new (GNOME_DB_TYPE_TABLE_EDITOR, NULL);
	return GTK_WIDGET (editor);
}
