/* gnome-db-qf-value.h
 *
 * Copyright (C) 2003 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#ifndef __GNOME_DB_QF_VALUE_H_
#define __GNOME_DB_QF_VALUE_H_

#include <libgda/libgda.h>
#include "gnome-db-base.h"
#include "gnome-db-decl.h"
#include "gnome-db-qfield.h"
#include "gnome-db-server-data-type.h"

G_BEGIN_DECLS

#define GNOME_DB_QF_VALUE_TYPE          (gnome_db_qf_value_get_type())
#define GNOME_DB_QF_VALUE(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_qf_value_get_type(), GnomeDbQfValue)
#define GNOME_DB_QF_VALUE_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_qf_value_get_type (), GnomeDbQfValueClass)
#define IS_GNOME_DB_QF_VALUE(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_qf_value_get_type ())


/* error reporting */
extern GQuark gnome_db_qf_value_error_quark (void);
#define GNOME_DB_QF_VALUE_ERROR gnome_db_qf_value_error_quark ()

enum
{
	GNOME_DB_QF_VALUE_XML_LOAD_ERROR,
	GNOME_DB_QF_VALUE_RENDER_ERROR,
	GNOME_DB_QF_VALUE_PARAM_ERROR,
	GNOME_DB_QF_VALUE_DEFAULT_PARAM_ERROR
};


/* struct for the object's data */
struct _GnomeDbQfValue
{
	GnomeDbQfield              object;
	GnomeDbQfValuePrivate     *priv;
};

/* struct for the object's class */
struct _GnomeDbQfValueClass
{
	GnomeDbQfieldClass                  class;

	/* signals */
	void   (*templ_signal)        (GnomeDbQfValue *obj);
};

guint             gnome_db_qf_value_get_type            (void);
GObject          *gnome_db_qf_value_new                 (GnomeDbQuery *query, GnomeDbServerDataType *type);

void              gnome_db_qf_value_set_value           (GnomeDbQfValue *field, const GdaValue *val);
const GdaValue   *gnome_db_qf_value_get_value           (GnomeDbQfValue *field);
void              gnome_db_qf_value_set_default_value   (GnomeDbQfValue *field, const GdaValue *default_val);
const GdaValue   *gnome_db_qf_value_get_default_value   (GnomeDbQfValue *field);
GdaValueType      gnome_db_qf_value_get_value_type      (GnomeDbQfValue *field);

void              gnome_db_qf_value_set_server_data_type(GnomeDbQfValue *field, GnomeDbServerDataType *type);
GnomeDbServerDataType *gnome_db_qf_value_get_server_data_type(GnomeDbQfValue *field);

void              gnome_db_qf_value_set_is_parameter    (GnomeDbQfValue *field, gboolean is_param);
gboolean          gnome_db_qf_value_is_parameter        (GnomeDbQfValue *field);

void              gnome_db_qf_value_set_not_null        (GnomeDbQfValue *field, gboolean not_null);
gboolean          gnome_db_qf_value_get_not_null        (GnomeDbQfValue *field);
gboolean          gnome_db_qf_value_is_value_null       (GnomeDbQfValue *field, GnomeDbDataSet *context);

gboolean          gnome_db_qf_value_restrict_with_field (GnomeDbQfValue *field, GnomeDbQfield *provider, GError **error);
gboolean          gnome_db_qf_value_restrict_with_field_xml (GnomeDbQfValue *field, const gchar *prov_xml_id, GError **error);


G_END_DECLS

#endif
